#ifndef __LINUX_MEM_TRACKER_DEF_H
#define __LINUX_MEM_TRACKER_DEF_H

#ifdef CONFIG_MEM_TRACKER
#define MEM_TRACKER_TYPE_BUDDY    (0)
#define MEM_TRACKER_TYPE_KMALLOC  (1)
#define MEM_FALSE                 (0)
#define MEM_TRUE                  (1)

// #define HEAP_SUFFIX_SIZE  				(2 * (sizeof(size_t)))
#define HEAP_SUFFIX_SIZE  				(64)
#define KMALLOC_SETUP(base)  			((void *)((unsigned long)(base) + HEAP_SUFFIX_SIZE))
#define KMALLOC_SET_ENTRY(base, entry)	(*(size_t *)(base) = (entry))
#define KMALLOC_ORIGINAL_SIZE(size)     ((size)- HEAP_SUFFIX_SIZE)

/* Return base-address of a kmalloc allocation */
#define KMALLOC_BASE(addr)	((void *)((unsigned long)(addr) - HEAP_SUFFIX_SIZE))

extern int check_node_entry(const int entry);
extern void mem_free_tracker(void *addr, int type);
extern void mem_alloc_tracker(void *addr, int order);
extern void kmalloc_alloc_tracker(void *addr, int len);
#endif

#endif /* __LINUX_MEM_TRACKER_DEF_H */

