/*
 * Modifications by Christian Pellegrin <chripell@evolware.org>
 *
 * zx29xx_nau8810.c  --  zx29xx_NAU8810 ALSA SoC Audio board driver
 *
 * Copyright 2007 Dension Audio Systems Ltd.
 * Author: Zoltan Devai
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License version 2 as
 * published by the Free Software Foundation.
 */

#include <linux/clk.h>
#include <linux/gpio.h>
#include <linux/module.h>

#include <sound/soc.h>
#include <sound/jack.h>
#include <sound/zx29_snd_platform.h>
#include <mach/iomap.h>
#include <mach/board.h>
#include "../codecs/nau8810.h"
#include <sound/pcm_params.h>
#include "i2s.h"

#define  NAU8810_MCLK   26000000
#define  NAU8810_IMCLK  11289600 //256*fs

#define AON_WIFI_BT_CLK_CFG2  ((volatile unsigned int *)(ZX_TOP_CRM_BASE + 0x94))

static struct platform_device *zx297520v3_nau8810_snd_device;

static struct snd_soc_dapm_widget widgets[] = {
	SND_SOC_DAPM_HP("Headphone", NULL),

	SND_SOC_DAPM_MIC("Main Mic", NULL),
	SND_SOC_DAPM_MIC("Aux Mic", NULL),

	SND_SOC_DAPM_SPK("Main Speaker", NULL),
};

static struct snd_soc_dapm_route audio_paths[] = {
	{ "Headphone", NULL, "MONOOUT" },
	{ "Main Speaker", NULL, "SPKOUTP" },
	{ "Main Speaker", NULL, "SPKOUTN" },
	
	{ "Main Mic", NULL, "MICBIAS" },
	{ "Aux Mic", NULL, "MICBIAS" },
	{ "MICN", NULL, "Aux Mic" },
	{ "MICP", NULL, "Main Mic" },

};

static struct snd_soc_jack nau8810_headset;

/* Headset jack detection DAPM pins */
static struct snd_soc_jack_pin nau8810_headset_pins[] = {
	{
		.pin = "Headset Mic",
		.mask = SND_JACK_HEADPHONE,
	},
	{
		.pin = "Headphone",
		.mask = SND_JACK_HEADPHONE,
	},
};

static int zx297520v3_nau8810_startup(struct snd_pcm_substream *substream)
{
	int ret = 0;
//	print_audio( "Entered func %s\n", __func__);
	unsigned int  armRegBit = 0;

	armRegBit = zx_read_reg(AON_WIFI_BT_CLK_CFG2);
	armRegBit &= 0xfffffffe;
	armRegBit |= 0x1;
	zx_write_reg(AON_WIFI_BT_CLK_CFG2, armRegBit);

	return ret;
}

static void zx297520v3_nau8810_shutdown(struct snd_pcm_substream *substream)
{
	struct snd_soc_pcm_runtime *rtd = substream->private_data;
	struct snd_soc_codec *codec = rtd->codec;
	struct snd_soc_dapm_context *dapm = &codec->dapm;
//	print_audio( "Entered func %s\n", __func__);
	
	unsigned int  armRegBit = 0;
	if (rtd->cpu_dai->active)
		return;
	armRegBit = zx_read_reg(AON_WIFI_BT_CLK_CFG2);
	armRegBit &= 0xfffffffe;
	armRegBit |= 0x0;
	zx_write_reg(AON_WIFI_BT_CLK_CFG2, armRegBit);
			

//	snd_soc_dapm_disable_pin(&codec->dapm, "MICBIAS");
}
static int zx297520v3_nau8810_init_paiftx(struct snd_soc_pcm_runtime *rtd)
{
	struct snd_soc_codec *codec = rtd->codec;
	struct snd_soc_dapm_context *dapm = &codec->dapm;
	
	/* MicIn */
	snd_soc_dapm_enable_pin(dapm, "MICN");
	snd_soc_dapm_enable_pin(dapm, "MICP");

	snd_soc_dapm_enable_pin(dapm, "MONOOUT");
	snd_soc_dapm_enable_pin(dapm, "SPKOUTP");
	snd_soc_dapm_enable_pin(dapm, "SPKOUTN");

	return 0;
}

static int zx297520v3_nau8810_hw_params(struct snd_pcm_substream *substream,
                                       struct snd_pcm_hw_params *params)
{
	print_audio( "Entered func %s\n", __func__);
	struct snd_soc_pcm_runtime *rtd = substream->private_data;
	struct snd_soc_dai *cpu_dai = rtd->cpu_dai;
	struct snd_soc_dai *codec_dai = rtd->codec_dai;
	int ret;
	unsigned int pll_out;
	int rfs;
	/* Set the Codec DAI configuration */
	ret = snd_soc_dai_set_fmt(codec_dai, SND_SOC_DAIFMT_I2S
					 | SND_SOC_DAIFMT_NB_NF
					 | SND_SOC_DAIFMT_CBS_CFS);
	if (ret < 0)
		return ret;

	/* Set the AP DAI configuration */
	ret = snd_soc_dai_set_fmt(cpu_dai, SND_SOC_DAIFMT_I2S
					 | SND_SOC_DAIFMT_NB_NF
					 | SND_SOC_DAIFMT_CBS_CFS);
	if (ret < 0)
		return ret;
	ret = snd_soc_dai_set_sysclk(codec_dai, NAU8810_SCLK_PLL,  //NAU8810_SCLK_MCLK NAU8810_SCLK_PLL
				     NAU8810_MCLK, SND_SOC_CLOCK_IN);
	if (ret < 0)
		return ret;

	ret = snd_soc_dai_set_sysclk(cpu_dai, ZX29_I2S_WCLK_SEL,
				     ZX29_I2S_WCLK_FREQ_26M, SND_SOC_CLOCK_IN);	
	if (ret < 0)
		return ret;
	
	switch (params_rate(params)) {
	case 8000:
	case 16000:
	case 22050:
	case 32000:
	case 44100:
	case 48000:
	case 88200:
	case 96000:
		rfs = 256;
		break;
	case 64000:
		rfs = 384;
		break;	
	case 11025:
		rfs = 512;
		break;
	default:
		return -EINVAL;
	}
	
	pll_out = params_rate(params) * rfs;
//	printk("[PLL] zx297520v3_nau8810_hw_params pll_out = %d\n",pll_out);
	ret = snd_soc_dai_set_pll(codec_dai, 0, 0,
 				 NAU8810_MCLK, pll_out);
	if (ret < 0)
		return ret;

	return 0;
}

static int zx297520v3_nau8810_hw_params1(struct snd_pcm_substream *substream,
                                       struct snd_pcm_hw_params *params)
{
//	print_audio( "Entered func %s\n", __func__);
	struct snd_soc_pcm_runtime *rtd = substream->private_data;
	struct snd_soc_dai *cpu_dai = rtd->cpu_dai;
	struct snd_soc_dai *codec_dai = rtd->codec_dai;
	unsigned int pll_out;
	int bfs, rfs, ret;
	
	switch (params_rate(params)) {
	case 8000:
	case 16000:
	case 22050:
	case 32000:
	case 44100:
	case 48000:
	case 88200:
	case 96000:
		rfs = 256;
		break;
	case 64000:
		rfs = 384;
		break;	
	case 11025:
		rfs = 512;
		break;
	default:
		return -EINVAL;
	}
	
	pll_out = params_rate(params) * rfs;

	/* Set the Codec DAI configuration */
	ret = snd_soc_dai_set_fmt(codec_dai, SND_SOC_DAIFMT_I2S
					 | SND_SOC_DAIFMT_NB_NF
					 | SND_SOC_DAIFMT_CBS_CFS);
	if (ret < 0)
		return ret;

	ret = snd_soc_dai_set_sysclk(codec_dai, NAU8810_SCLK_MCLK,
				     NAU8810_MCLK, SND_SOC_CLOCK_IN);
	if (ret < 0)
		return ret;
	
	ret = snd_soc_dai_set_pll(codec_dai, 0, 0,
					 NAU8810_MCLK, NAU8810_IMCLK);
	if (ret < 0)
		return ret;

	return 0;
}

static void zx29_i2s_top_reg_cfg(void)
{
	unsigned int i2s_top_reg;
	int ret = 0;

#ifdef CONFIG_USE_PIN_I2S0
	ret = gpio_request(PIN_I2S0_WS, "i2s0_ws");
	if (ret < 0)
		BUG();
	ret = gpio_request(PIN_I2S0_CLK, "i2s0_clk");
	if (ret < 0)
		BUG();
	ret = gpio_request(PIN_I2S0_DIN, "i2s0_din");
	if (ret < 0)
		BUG();
	ret = gpio_request(PIN_I2S0_DOUT, "i2s0_dout");
	if (ret < 0)
		BUG();
	zx29_gpio_config(PIN_I2S0_WS, FUN_I2S0_WS);
	zx29_gpio_config(PIN_I2S0_CLK, FUN_I2S0_CLK);
	zx29_gpio_config(PIN_I2S0_DIN, FUN_I2S0_DIN);
	zx29_gpio_config(PIN_I2S0_DOUT, FUN_I2S0_DOUT);
	
	//top i2s1 cfg
	i2s_top_reg = zx_read_reg(ZX29_I2S_LOOP_CFG);
	i2s_top_reg &= 0xfffffff8;
	i2s_top_reg |= 0x00000001; //  inter arm_i2s1--top i2s1
	zx_write_reg(ZX29_I2S_LOOP_CFG, i2s_top_reg);
#elif defined (CONFIG_USE_PIN_I2S1)
	ret = gpio_request(PIN_I2S1_WS,"i2s1_ws");
	if(ret < 0)
		BUG();
	ret = gpio_request(PIN_I2S1_CLK,"i2s1_clk");
	if(ret < 0)
		BUG();
	ret = gpio_request(PIN_I2S1_DIN,"i2s1_din");
	if(ret < 0)
		BUG();
	ret = gpio_request(PIN_I2S1_DOUT,"i2s1_dout");
	if(ret < 0)
		BUG();
	zx29_gpio_config(PIN_I2S1_WS, FUN_I2S1_WS);
	zx29_gpio_config(PIN_I2S1_CLK, FUN_I2S1_CLK);
	zx29_gpio_config(PIN_I2S1_DIN, FUN_I2S1_DIN);
	zx29_gpio_config(PIN_I2S1_DOUT, FUN_I2S1_DOUT);
		
	//top i2s2 cfg
	i2s_top_reg = zx_read_reg(ZX29_I2S_LOOP_CFG);
	i2s_top_reg &= 0xfff8ffff;
	i2s_top_reg |= 0x00010000; //  inter arm_i2s1--top i2s2
	zx_write_reg(ZX29_I2S_LOOP_CFG, i2s_top_reg);
#endif

	// inter loop
    i2s_top_reg = zx_read_reg(ZX29_I2S_LOOP_CFG);
    i2s_top_reg &= 0xfffffe07;
    i2s_top_reg |= 0x000000a8; //  inter arm_i2s2--afe i2s
    zx_write_reg(ZX29_I2S_LOOP_CFG, i2s_top_reg);
	
//	print_audio("Alsa %s i2s loop cfg reg=%x\n",__func__, zx_read_reg(ZX29_I2S_LOOP_CFG));	
}

static int zx297520v3_nau8810_late_probe(struct snd_soc_card *card)
{
	struct snd_soc_codec *codec = card->rtd[0].codec;
	struct snd_soc_dai *codec_dai = card->rtd[0].codec_dai;
	int ret;
//	print_audio("zx297520v3_nau8810_late_probe entry!\n");
	ret = snd_soc_jack_new(codec, "Headset",
			       SND_JACK_HEADSET,
			       &nau8810_headset);
	if (ret)
		return ret;

	ret = snd_soc_jack_add_pins(&nau8810_headset,
				    ARRAY_SIZE(nau8810_headset_pins),
				    nau8810_headset_pins);
	if (ret)
		return ret;

	nau8810_mic_detect(codec, &nau8810_headset);

	return 0;
}

static struct snd_soc_ops zx297520v3_nau8810_ops =
{
//	.startup = zx297520v3_nau8810_startup,
//	.shutdown = zx297520v3_nau8810_shutdown,
	.hw_params = zx297520v3_nau8810_hw_params,
};

static struct snd_soc_ops zx297520v3_nau8810_ops1 =
{
//	.startup = zx297520v3_nau8810_startup,
 //    .shutdown = zx297520v3_nau8810_shutdown,
	.hw_params = zx297520v3_nau8810_hw_params1,
};

static struct snd_soc_dai_link zx297520v3_nau8810_dai_link[] =
{
	{
		.name = "NAU8810_Media",
		.stream_name = "MultiMedia",
		.codec_name = "nau8810.1-001a", //nau8810.1-001a
		.codec_dai_name = "nau8810-hifi",
		.cpu_dai_name = "MultiMedia", //"zx29_i2s.0"
		.ops = &zx297520v3_nau8810_ops,
		.init = zx297520v3_nau8810_init_paiftx,
		.platform_name	= "zx29-pcm-audio",
	},
	{
		.name = "voice_call",
		.stream_name = "voice",
		.codec_name = "nau8810.1-001a",
		.codec_dai_name = "nau8810-hifi",
		.cpu_dai_name = "voice", //"snd-soc-dummy-dai",
		.platform_name	= "snd-soc-dummy",
		.init = zx297520v3_nau8810_init_paiftx,
		.ops = &zx297520v3_nau8810_ops1,
	}
};

static struct snd_soc_card snd_soc_zx297520v3_nau8810 =
{
	.name = "zx297520v3_nau8810",
	.owner = THIS_MODULE,
	.dai_link = &zx297520v3_nau8810_dai_link,
	.num_links = ARRAY_SIZE(zx297520v3_nau8810_dai_link),
//	.dapm_widgets = widgets,
//	.num_dapm_widgets = ARRAY_SIZE(widgets),
//	.dapm_routes = audio_paths,
//	.num_dapm_routes = ARRAY_SIZE(audio_paths),
//	.fully_routed = true,
	.late_probe = zx297520v3_nau8810_late_probe,
};

static struct zx297520v3_nau8810_platform_data *zx297520v3_nau8810_pow_pins;

static int zx297520v3_nau8810_setup_pins(struct zx297520v3_nau8810_platform_data *codec_pins, char *fun)
{
	int ret;
//xf.li@20230428 modify for codec start
	u32 aon_clk_out2_sel = 0;

	ret = gpio_request(ZX29_GPIO_17, "codec_refclk");
	if (ret < 0) {
		printk(KERN_ERR "zx297520v3_nau8810 SoC Audio: %s pin already in use\n", fun);
		return ret;
	}
	zx29_gpio_config(ZX29_GPIO_17, GPIO17_CLK_OUT2);
	aon_clk_out2_sel = ioread32(ZX_TOP_CRM_BASE+0x94);

	aon_clk_out2_sel |= (1<<0) | (1<<2);
	iowrite32(aon_clk_out2_sel,(ZX_TOP_CRM_BASE+0x94));
//xf.li@20230428 modify for codec end
return 0;

}

static int zx297520v3_nau8810_probe(struct platform_device *pdev)
{
	int ret;
	unsigned int  armRegBit = 0;
//	print_audio( "zx297520v3_nau8810 SoC Audio driver\n");

	zx297520v3_nau8810_pow_pins = pdev->dev.platform_data;
	if (zx297520v3_nau8810_pow_pins == NULL) {
		printk(KERN_ERR "zx297520v3_nau8810 SoC Audio: unable to find platform data\n");
		return -ENODEV;
	}

	if (zx297520v3_nau8810_setup_pins(zx297520v3_nau8810_pow_pins, "codec") < 0)
		return -EBUSY;

	zx29_i2s_top_reg_cfg();
	
	zx297520v3_nau8810_snd_device = platform_device_alloc("soc-audio", -1);
	if (!zx297520v3_nau8810_snd_device) {
		printk(KERN_ERR "zx297520v3_nau8810 SoC Audio: Unable to register\n");
		return -ENOMEM;
	}

	platform_set_drvdata(zx297520v3_nau8810_snd_device,
			     &snd_soc_zx297520v3_nau8810);
//	platform_device_add_data(zx29xx_nau8810_snd_device, &zx29xx_nau8810, sizeof(zx29xx_nau8810));
	ret = platform_device_add(zx297520v3_nau8810_snd_device);
	if (ret) {
		printk(KERN_ERR "zx297520v3_nau8810 SoC Audio: Unable to add\n");
		platform_device_put(zx297520v3_nau8810_snd_device);
	}
/*
	armRegBit = zx_read_reg(AON_WIFI_BT_CLK_CFG2);
	armRegBit &= 0xfffffffe;
	armRegBit |= 0x1;
	zx_write_reg(AON_WIFI_BT_CLK_CFG2, armRegBit);
*/
	return ret;
}

static int zx297520v3_nau8810_remove(struct platform_device *pdev)
{
	gpio_free(zx297520v3_nau8810_pow_pins->codec_refclk);
//	gpio_free(zx297520v3_nau8810_pow_pins->codec_en);

	platform_device_unregister(zx297520v3_nau8810_snd_device);
	return 0;
}

static struct platform_driver zx297520v3_nau8810_driver =
{
	.probe  = zx297520v3_nau8810_probe,
	.remove = zx297520v3_nau8810_remove,
	.driver = {
		.name = "zx297520v3_nau8810",
		.owner = THIS_MODULE,
	},
};

module_platform_driver(zx297520v3_nau8810_driver);

MODULE_DESCRIPTION("ZX297520V3_NAU8810 ALSA SoC audio driver");
MODULE_LICENSE("GPL");

