/*
 * zx297520v3_es8374.c  --  zx297520v3_es8374 ALSA SoC Audio board driver
 *
 * Copyright (C) 2017, ZTE Corporation.
 *
 * Based on smdk_wm8994.c
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License version 2 as
 * published by the Free Software Foundation.
 */

#include <linux/clk.h>
#include <linux/gpio.h>
#include <linux/module.h>
#include <linux/delay.h>
#include <sound/tlv.h>
#include <sound/soc.h>
#include <sound/jack.h>
#include <sound/zx29_snd_platform.h>
#include <mach/iomap.h>
#include <mach/board.h>
#include "../codecs/es8374.h"
#include <sound/pcm_params.h>
#include "i2s.h"
#if 1

#define  ZXIC_MCLK                    26000000
#define  ZXIC_PLL_CLKIN_MCLK		  0
#define AON_WIFI_BT_CLK_CFG2  ((volatile unsigned int *)(ZX_TOP_CRM_BASE + 0x94))

static struct platform_device *zx29_snd_device;

static DEFINE_RAW_SPINLOCK(codec_pa_lock);

static int set_path_stauts_switch(struct snd_kcontrol *kcontrol,
				struct snd_ctl_elem_value *ucontrol);
static int get_path_stauts_switch(struct snd_kcontrol *kcontrol,
				struct snd_ctl_elem_value *ucontrol);

#ifdef CONFIG_PREEMPT_RT_FULL
extern int zDrv_Audio_Printf(void *pFormat, ...);
extern int zDrvVp_GetVol_Wrap(void);
extern int zDrvVp_SetVol_Wrap(int volume);
extern int zDrvVp_GetPath_Wrap(void);
extern int zDrvVp_SetPath_Wrap(int path);
extern int zDrvVp_SetMute_Wrap(bool enable);
extern bool zDrvVp_GetMute_Wrap(void);
extern int zDrvVp_SetTone_Wrap(int toneNum);

static int vp_GetPath(struct snd_kcontrol *kcontrol, struct snd_ctl_elem_value *ucontrol);
static int vp_SetPath(struct snd_kcontrol *kcontrol, struct snd_ctl_elem_value *ucontrol);
static int vp_SetVol(struct snd_kcontrol *kcontrol, struct snd_ctl_elem_value *ucontrol);
static int vp_GetVol(struct snd_kcontrol *kcontrol, struct snd_ctl_elem_value *ucontrol);
static int vp_SetMute(struct snd_kcontrol *kcontrol, struct snd_ctl_elem_value *ucontrol);
static int vp_GetMute(struct snd_kcontrol *kcontrol, struct snd_ctl_elem_value *ucontrol);
static int vp_SetTone(struct snd_kcontrol *kcontrol, struct snd_ctl_elem_value *ucontrol);
static int vp_getTone(struct snd_kcontrol *kcontrol, struct snd_ctl_elem_value *ucontrol);

static int audio_GetPath(struct snd_kcontrol *kcontrol, struct snd_ctl_elem_value *ucontrol);
static int audio_SetPath(struct snd_kcontrol *kcontrol, struct snd_ctl_elem_value *ucontrol);

static const DECLARE_TLV_DB_SCALE(vp_path_tlv, 0, 300, 0);

static const char * const vpath_in_text[] = {
	"handset", "speak", "headset", "bluetooth",
};

static const char *tone_class[] = {
	"Lowpower", "Sms", "Callstd", "Alarm", "Calltime",
};

static const struct soc_enum vpath_in_enum =	SOC_ENUM_SINGLE_EXT(ARRAY_SIZE(vpath_in_text), vpath_in_text); 

static const struct soc_enum tone_class_enum[] = {
	SOC_ENUM_SINGLE_EXT(ARRAY_SIZE(tone_class),	tone_class),
};

static const struct snd_kcontrol_new vp_snd_controls[] = {	
	SOC_ENUM_EXT("voice processing path select",vpath_in_enum,vp_GetPath,vp_SetPath),
	SOC_SINGLE_EXT_TLV("voice processing path Volume",0, 5, 5, 0,vp_GetVol, vp_SetVol,vp_path_tlv),	
	SOC_SINGLE_EXT("voice uplink mute", 0, 1, 1, 0,vp_GetMute, vp_SetMute),
	SOC_ENUM_EXT("voice tone sel", tone_class_enum[0], vp_getTone, vp_SetTone),
    SOC_SINGLE_BOOL_EXT("path stauts dump", 0,get_path_stauts_switch, set_path_stauts_switch),
	SOC_ENUM_EXT("audio path select",vpath_in_enum,audio_GetPath,audio_SetPath),
};

static int curtonetype = 0;
static int vp_getTone(struct snd_kcontrol *kcontrol, struct snd_ctl_elem_value *ucontrol)
{
	ucontrol->value.integer.value[0] = curtonetype;
	return 0;
}

static int vp_SetTone(struct snd_kcontrol *kcontrol, struct snd_ctl_elem_value *ucontrol)
{
	int vol = 0,ret = 0, tonenum;
	tonenum = ucontrol->value.integer.value[0];
	curtonetype = tonenum;
	//printk("Alsa vp_SetTone tonenum=%d\n", tonenum);
	ret = CPPS_FUNC(cpps_callbacks, zDrvVp_SetTone_Wrap)(tonenum);
	if(ret < 0)
	{
		printk(KERN_ERR "vp_SetTone fail = %d\n", tonenum);
		return ret;
	}
	return 0;
}

static int vp_SetMute(struct snd_kcontrol *kcontrol, struct snd_ctl_elem_value *ucontrol)
{
	int enable = 0,ret = 0;
	enable = ucontrol->value.integer.value[0];
	CPPS_FUNC(cpps_callbacks, zDrv_Audio_Printf)("Alsa vp_SetMute kcontrol id name=%s,enable=%d \n",kcontrol->id.name, enable);		
	
	ret = CPPS_FUNC(cpps_callbacks, zDrvVp_SetMute_Wrap)(enable);
	if(ret < 0)
	{
	  printk(KERN_ERR "vp_SetMute fail = %d\n",enable);
	  return ret;
	}
	return 0;
}

static int vp_GetMute(struct snd_kcontrol *kcontrol, struct snd_ctl_elem_value *ucontrol)
{       
       ucontrol->value.integer.value[0] = CPPS_FUNC(cpps_callbacks, zDrvVp_GetMute_Wrap)();
       return 0;
}

static int vp_SetVol(struct snd_kcontrol *kcontrol,
                               struct snd_ctl_elem_value *ucontrol)
{
	   int vol = 0,ret = 0;
	   vol = ucontrol->value.integer.value[0];
	   CPPS_FUNC(cpps_callbacks, zDrv_Audio_Printf)("Alsa vp_SetVol kcontrol id name=%s,vol=%d \n",kcontrol->id.name, vol);		
	   
	   ret = CPPS_FUNC(cpps_callbacks, zDrvVp_SetVol_Wrap)(vol);
	   if(ret < 0)
	   {
		  printk(KERN_ERR "vp_SetVol fail = %d\n",vol);
		  return ret;
	  }
	return 0;
}
static int vp_GetVol(struct snd_kcontrol *kcontrol,
                               struct snd_ctl_elem_value *ucontrol)
{       
       ucontrol->value.integer.value[0] = CPPS_FUNC(cpps_callbacks, zDrvVp_GetVol_Wrap)();
       return 0;
}
static int vp_GetPath(struct snd_kcontrol *kcontrol,
			struct snd_ctl_elem_value *ucontrol)
{	
	ucontrol->value.enumerated.item[0] = CPPS_FUNC(cpps_callbacks, zDrvVp_GetPath_Wrap)();
	return 0;
}
#ifdef _USE_7520V3_PHONE_TYPE_WTWD 	
void SpkPaSwitch(int path);
#endif
static int vp_SetPath(struct snd_kcontrol *kcontrol,
			struct snd_ctl_elem_value *ucontrol)
{
	int ret = 0,path = 0;
	unsigned long  flags;

	path = ucontrol->value.enumerated.item[0];
	CPPS_FUNC(cpps_callbacks, zDrv_Audio_Printf)("Alsa vp_SetPath kcontrol id name=%s,path=%d \n",kcontrol->id.name, path);		

	ret = CPPS_FUNC(cpps_callbacks, zDrvVp_SetPath_Wrap)(path);
	if(ret < 0)
	{
	  printk(KERN_ERR "vp_SetPath fail = %d\n",path);
	  return ret;
	}
#ifdef _USE_7520V3_PHONE_TYPE_WTWD 	
	 SpkPaSwitch(path);	
#endif

#ifdef _USE_7520V3_PHONE_TYPE_C31F 
	switch (path) {
	case 0://handset
		gpio_set_value(ZX29_GPIO_39, GPIO_LOW);
		mdelay(1);	
		gpio_set_value(ZX29_GPIO_40, GPIO_LOW);
		break;
	case 1://speaker
		gpio_set_value(ZX29_GPIO_39, GPIO_LOW);
		mdelay(1);	
		raw_spin_lock_irqsave(&codec_pa_lock, flags);
		gpio_set_value(ZX29_GPIO_39, GPIO_HIGH);
		udelay(2);	
		gpio_set_value(ZX29_GPIO_39, GPIO_LOW);
		udelay(2);
		gpio_set_value(ZX29_GPIO_39, GPIO_HIGH);
		raw_spin_unlock_irqrestore(&codec_pa_lock, flags);
		gpio_set_value(ZX29_GPIO_40, GPIO_HIGH);

		break;
	case 2://headset
		break;
	case 3:
		break;
	default:
		break;
	}
#endif



	return 0;
}

static int curpath = 0;
static int audio_GetPath(struct snd_kcontrol *kcontrol,
			struct snd_ctl_elem_value *ucontrol)
{	
	ucontrol->value.enumerated.item[0] = curpath;
	return 0;
}

static int audio_SetPath(struct snd_kcontrol *kcontrol,
			struct snd_ctl_elem_value *ucontrol)
{
	int ret = 0,path = 0;
	unsigned long  flags;
	
	path = ucontrol->value.enumerated.item[0];
	curpath = path;
#if (defined _USE_7520V3_PHONE_TYPE_C31F || defined _USE_7520V3_PHONE_TYPE_WTWD )
	switch (path) {
	case 0:
		gpio_set_value(ZX29_GPIO_39, GPIO_LOW);
#ifdef _USE_7520V3_PHONE_TYPE_C31F
		mdelay(1);	
		gpio_set_value(ZX29_GPIO_40, GPIO_LOW);
#endif
		break;
	case 1:
		gpio_set_value(ZX29_GPIO_39, GPIO_LOW);
		mdelay(1);	
		raw_spin_lock_irqsave(&codec_pa_lock, flags);
		gpio_set_value(ZX29_GPIO_39, GPIO_HIGH);
		udelay(2);	
		gpio_set_value(ZX29_GPIO_39, GPIO_LOW);
		udelay(2);
		gpio_set_value(ZX29_GPIO_39, GPIO_HIGH);
		raw_spin_unlock_irqrestore(&codec_pa_lock, flags);
#ifdef _USE_7520V3_PHONE_TYPE_C31F
		gpio_set_value(ZX29_GPIO_40, GPIO_HIGH);
#endif
		break;
	case 2:
		break;
	case 3:
		break;
	default:
		break;
	}
#endif
	return 0;
}

typedef enum
{
    VP_PATH_HANDSET    =0,     
    VP_PATH_SPEAKER,  		
    VP_PATH_HEADSET,                     
    VP_PATH_BLUETOOTH,                    
    VP_PATH_BLUETOOTH_NO_NR,                    
    VP_PATH_HSANDSPK,
    
    VP_PATH_OFF = 255,					
    
    MAX_VP_PATH = VP_PATH_OFF               
}T_ZDrv_VpPath;

extern int zDrvVp_Loop(T_ZDrv_VpPath path);
int zx297520xx_prepare2(struct snd_pcm_substream *substream)
{
	int path, ret;
	if (substream->stream == SNDRV_PCM_STREAM_PLAYBACK) {
		ret = CPPS_FUNC(cpps_callbacks, zDrvVp_Loop)(VP_PATH_SPEAKER);
		if (ret < 0)
			return -1;
	}
	
	return 0;
}

#else
static const struct snd_kcontrol_new machine_snd_controls[] = {			
	SOC_SINGLE_BOOL_EXT("path stauts dump", 0,get_path_stauts_switch, set_path_stauts_switch),
};

#endif

//extern int rt5670_hs_detect(struct snd_soc_codec *codec, struct snd_soc_jack *jack);

int path_stauts_switch = 0;
static int set_path_stauts_switch(struct snd_kcontrol *kcontrol,
				struct snd_ctl_elem_value *ucontrol)
{
	struct snd_soc_card *card = snd_kcontrol_chip(kcontrol);
	struct snd_soc_dapm_path *p;

	int path_stauts_switch = ucontrol->value.integer.value[0];

	
	if (path_stauts_switch == 1)
	{
		list_for_each_entry(p, &card->paths, list){
			
		  //print_audio("Alsa  path name (%s),longname (%s),sink (%s),source (%s),connect %d \n", p->name,p->long_name,p->sink->name,p->source->name,p->connect);
		  printk("Alsa  path longname %s,sink %s,source %s,connect %d \n", p->long_name,p->sink->name,p->source->name,p->connect);

		}
	}
	return 0;
}

static int get_path_stauts_switch(struct snd_kcontrol *kcontrol,
				struct snd_ctl_elem_value *ucontrol)
{
	
	ucontrol->value.integer.value[0] = path_stauts_switch;
	return 0;
};


#ifdef CONFIG_SND_SOC_JACK_DECTEC

static struct snd_soc_jack codec_headset;

/* Headset jack detection DAPM pins */
static struct snd_soc_jack_pin codec_headset_pins[] = {
	{
		.pin = "Headphone",
		.mask = SND_JACK_HEADPHONE,
	},
};

#endif

static int zx297520xx_startup(struct snd_pcm_substream *substream)
{
//	int ret = 0;
//	print_audio("Alsa  Entered func %s\n", __func__);
	CPPS_FUNC(cpps_callbacks, zDrv_Audio_Printf)("Alsa: zx297520xx_startup device=%d,stream=%d\n", substream->pcm->device, substream->stream);

	struct snd_pcm *pcmC0D0p = snd_lookup_minor_data(16, SNDRV_DEVICE_TYPE_PCM_PLAYBACK);
	struct snd_pcm *pcmC0D1p = snd_lookup_minor_data(17, SNDRV_DEVICE_TYPE_PCM_PLAYBACK);
	struct snd_pcm *pcmC0D2p = snd_lookup_minor_data(18, SNDRV_DEVICE_TYPE_PCM_PLAYBACK);   
	struct snd_pcm *pcmC0D3p = snd_lookup_minor_data(19, SNDRV_DEVICE_TYPE_PCM_PLAYBACK);  
	if ((pcmC0D0p == NULL) || (pcmC0D1p == NULL) || (pcmC0D2p == NULL) || (pcmC0D3p == NULL))
		return  -EINVAL;       
	if ((pcmC0D0p->streams[0].substream_opened && pcmC0D1p->streams[0].substream_opened) || 
		(pcmC0D0p->streams[0].substream_opened && pcmC0D2p->streams[0].substream_opened) || 
		(pcmC0D0p->streams[0].substream_opened && pcmC0D3p->streams[0].substream_opened) || 
		(pcmC0D1p->streams[0].substream_opened && pcmC0D2p->streams[0].substream_opened) ||
		(pcmC0D1p->streams[0].substream_opened && pcmC0D3p->streams[0].substream_opened) ||
		(pcmC0D2p->streams[0].substream_opened && pcmC0D3p->streams[0].substream_opened))
		BUG();
#if 0
	unsigned long  flags;
	if (substream->stream == SNDRV_PCM_STREAM_PLAYBACK) {
		gpio_set_value(ZX29_GPIO_125, GPIO_LOW);
		mdelay(1);	

		raw_spin_lock_irqsave(&codec_pa_lock, flags);
		gpio_set_value(ZX29_GPIO_125, GPIO_HIGH);
		udelay(2);	
		gpio_set_value(ZX29_GPIO_125, GPIO_LOW);
		udelay(2);
		gpio_set_value(ZX29_GPIO_125, GPIO_HIGH);
		udelay(2);	
		gpio_set_value(ZX29_GPIO_125, GPIO_LOW);
		udelay(2);
		gpio_set_value(ZX29_GPIO_125, GPIO_HIGH);
		raw_spin_unlock_irqrestore(&codec_pa_lock, flags);
	}
#endif

/*
	armRegBit = zx_read_reg(AON_WIFI_BT_CLK_CFG2);
	armRegBit &= 0xfffffffe;
	armRegBit |= 0x1;
	zx_write_reg(AON_WIFI_BT_CLK_CFG2, armRegBit);
*/	
	return 0;
}

static void zx297520xx_shutdown(struct snd_pcm_substream *substream)
{
	CPPS_FUNC(cpps_callbacks, zDrv_Audio_Printf)("Alsa: zx297520xx_shutdown device=%d, stream=%d\n", substream->pcm->device, substream->stream);
//	print_audio("Alsa  Entered func %s, stream=%d\n", __func__, substream->stream);
	struct snd_soc_pcm_runtime *rtd = substream->private_data;

	if (substream->stream == SNDRV_PCM_STREAM_PLAYBACK) {
#ifdef _USE_7520V3_PHONE_TYPE_C31F
		gpio_set_value(ZX29_GPIO_39, GPIO_LOW);
		mdelay(1);	
		gpio_set_value(ZX29_GPIO_40, GPIO_LOW);
#endif
#ifdef _USE_7520V3_PHONE_TYPE_WTWD 
		gpio_set_value(ZX29_GPIO_39, GPIO_LOW);
#endif
	}
	
	if (rtd->cpu_dai->active)
		return;

}

static void zx297520xx_shutdown2(struct snd_pcm_substream *substream)
{
	CPPS_FUNC(cpps_callbacks, zDrv_Audio_Printf)("Alsa: zx297520xx_shutdown2 device=%d, stream=%d\n", substream->pcm->device, substream->stream);
	if (substream->stream == SNDRV_PCM_STREAM_PLAYBACK) {
#ifdef _USE_7520V3_PHONE_TYPE_C31F
		gpio_set_value(ZX29_GPIO_39, GPIO_LOW);
		mdelay(1);	
		gpio_set_value(ZX29_GPIO_40, GPIO_LOW);
#endif
#ifdef _USE_7520V3_PHONE_TYPE_WTWD 
		gpio_set_value(ZX29_GPIO_39, GPIO_LOW);
#endif
#ifdef CONFIG_PREEMPT_RT_FULL
		CPPS_FUNC(cpps_callbacks, zDrvVp_Loop)(VP_PATH_OFF);
#endif
	}
}
static int zx297520xx_init_paiftx(struct snd_soc_pcm_runtime *rtd)
{
	struct snd_soc_codec *codec = rtd->codec;
	struct snd_soc_dapm_context *dapm = &codec->dapm;

	//snd_soc_dapm_enable_pin(dapm, "HPOL");
	//snd_soc_dapm_enable_pin(dapm, "HPOR");

	/* Other pins NC */
//	snd_soc_dapm_nc_pin(dapm, "HPOUT2P");

//	print_audio("Alsa  Entered func %s\n", __func__);

	return 0;
}
static int zx297520xx_hw_params(struct snd_pcm_substream *substream,
                                       struct snd_pcm_hw_params *params)
{
//	print_audio("Alsa  Entered func %s\n", __func__);
	struct snd_soc_pcm_runtime *rtd = substream->private_data;
	struct snd_soc_dai *cpu_dai = rtd->cpu_dai;
	struct snd_soc_dai *codec_dai = rtd->codec_dai;
	int ret;
	int fs = 0, datawidth = 0;	
		
	/* Set the Codec DAI configuration */
	ret = snd_soc_dai_set_fmt(codec_dai, SND_SOC_DAIFMT_I2S
	                          | SND_SOC_DAIFMT_NB_NF
	                          | SND_SOC_DAIFMT_CBS_CFS);
	if (ret < 0)
		return ret;

	/* Set the AP DAI configuration */
	ret = snd_soc_dai_set_fmt(cpu_dai, SND_SOC_DAIFMT_I2S
	                          | SND_SOC_DAIFMT_NB_NF
	                          | SND_SOC_DAIFMT_CBS_CFS);
	if (ret < 0)
		return ret;

	fs = params_rate(params);

	switch (params_format(params)) {
	case SNDRV_PCM_FORMAT_S16_LE:
		datawidth = 16;
		break;
	default:
		return -EINVAL;
	}
	/* Set the Codec DAI clk */		
	/*ret =snd_soc_dai_set_pll(codec_dai, 0, RT5670_PLL1_S_BCLK1,
	                             fs*datawidth*2, 256*fs);
	if (ret < 0)
		return ret;
	*/
	ret = snd_soc_dai_set_sysclk(codec_dai, ES8374_CLKID_PLLO,
	                             ZXIC_MCLK, SND_SOC_CLOCK_IN);
	if (ret < 0)
		return ret;
	
	/* Set the AP DAI clk */
	ret = snd_soc_dai_set_sysclk(cpu_dai, ZX29_I2S_WCLK_SEL,
	                             ZX29_I2S_WCLK_FREQ_26M, SND_SOC_CLOCK_IN);

	if (ret < 0)
		return ret;

	return 0;
}

static int zx297520xx_hw_params1(struct snd_pcm_substream *substream,
                                        struct snd_pcm_hw_params *params)
{
//	print_audio("Alsa  Entered func %s\n", __func__);
	struct snd_soc_pcm_runtime *rtd = substream->private_data;
	struct snd_soc_dai *cpu_dai = rtd->cpu_dai;
	struct snd_soc_dai *codec_dai = rtd->codec_dai;
	unsigned int pll_out;
	int fs, datawidth, ret;

	/* Set the Codec DAI configuration */
	ret = snd_soc_dai_set_fmt(codec_dai, SND_SOC_DAIFMT_I2S
	                          | SND_SOC_DAIFMT_NB_NF
	                          | SND_SOC_DAIFMT_CBS_CFS);   //SND_SOC_DAIFMT_CBM_CFM
	if (ret < 0)
		return ret;

	fs = params_rate(params);

	switch (params_format(params)) {
	case SNDRV_PCM_FORMAT_S16_LE:
		datawidth = 16;
		break;
	default:
		return -EINVAL;
	}

	ret = snd_soc_dai_set_sysclk(codec_dai, ES8374_CLKID_PLLO,
	                             ZXIC_MCLK, SND_SOC_CLOCK_IN);
	if (ret < 0)
		return ret;

	return 0;
}

static void zx29_i2s_top_reg_cfg(void)
{
	unsigned int i2s_top_reg = 0;
	int ret = 0;

#ifdef CONFIG_USE_PIN_I2S0
	ret = gpio_request(PIN_I2S0_WS, "i2s0_ws");
	if (ret < 0)
		BUG();
	ret = gpio_request(PIN_I2S0_CLK, "i2s0_clk");
	if (ret < 0)
		BUG();
	ret = gpio_request(PIN_I2S0_DIN, "i2s0_din");
	if (ret < 0)
		BUG();
	ret = gpio_request(PIN_I2S0_DOUT, "i2s0_dout");
	if (ret < 0)
		BUG();
	zx29_gpio_config(PIN_I2S0_WS, FUN_I2S0_WS);
	zx29_gpio_config(PIN_I2S0_CLK, FUN_I2S0_CLK);
	zx29_gpio_config(PIN_I2S0_DIN, FUN_I2S0_DIN);
	zx29_gpio_config(PIN_I2S0_DOUT, FUN_I2S0_DOUT);
	
	//top i2s1 cfg
	i2s_top_reg = zx_read_reg(ZX29_I2S_LOOP_CFG);
	i2s_top_reg &= 0xfffffff8;
	i2s_top_reg |= 0x00000001; //  inter arm_i2s1--top i2s1
	zx_write_reg(ZX29_I2S_LOOP_CFG, i2s_top_reg);
#elif defined (CONFIG_USE_PIN_I2S1)
	ret = gpio_request(PIN_I2S1_WS,"i2s1_ws");
	if(ret < 0)
		BUG();
	ret = gpio_request(PIN_I2S1_CLK,"i2s1_clk");
	if(ret < 0)
		BUG();
	ret = gpio_request(PIN_I2S1_DIN,"i2s1_din");
	if(ret < 0)
		BUG();
	ret = gpio_request(PIN_I2S1_DOUT,"i2s1_dout");
	if(ret < 0)
		BUG();
	zx29_gpio_config(PIN_I2S1_WS, FUN_I2S1_WS);
	zx29_gpio_config(PIN_I2S1_CLK, FUN_I2S1_CLK);
	zx29_gpio_config(PIN_I2S1_DIN, FUN_I2S1_DIN);
	zx29_gpio_config(PIN_I2S1_DOUT, FUN_I2S1_DOUT);
		
	//top i2s2 cfg
	i2s_top_reg = zx_read_reg(ZX29_I2S_LOOP_CFG);
	i2s_top_reg &= 0xfff8ffff;
	i2s_top_reg |= 0x00010000; //  inter arm_i2s1--top i2s2
	zx_write_reg(ZX29_I2S_LOOP_CFG, i2s_top_reg);
#endif

	// inter loop
    i2s_top_reg = zx_read_reg(ZX29_I2S_LOOP_CFG);
    i2s_top_reg &= 0xfffffe07;
    i2s_top_reg |= 0x000000a8; //  inter arm_i2s2--afe i2s
    zx_write_reg(ZX29_I2S_LOOP_CFG, i2s_top_reg);
	
//	print_audio("Alsa %s i2s loop cfg reg=%x\n",__func__, zx_read_reg(ZX29_I2S_LOOP_CFG));	
}

static int zx29_late_probe(struct snd_soc_card *card)
{
	struct snd_soc_codec *codec = card->rtd[0].codec;
	struct snd_soc_dai *codec_dai = card->rtd[0].codec_dai;
	int ret;
//	print_audio("Alsa  zx29_late_probe entry!\n");

#ifdef CONFIG_SND_SOC_JACK_DECTEC
	
	ret = snd_soc_jack_new(codec, "Headset",
	                       SND_JACK_HEADSET |SND_JACK_BTN_0 | SND_JACK_BTN_1 | SND_JACK_BTN_2,
	                       &codec_headset);
	if (ret)
		return ret;

	ret = snd_soc_jack_add_pins(&codec_headset,
	                            ARRAY_SIZE(codec_headset_pins),
	                            codec_headset_pins);
	if (ret)
		return ret;
       #ifdef CONFIG_SND_SOC_codec
	//rt5670_hs_detect(codec, &codec_headset);
       #endif
#endif

	return 0;
}

static struct snd_soc_ops zx297520xx_ops = {
	.startup = zx297520xx_startup,
	.shutdown = zx297520xx_shutdown,
	.hw_params = zx297520xx_hw_params,
};

static struct snd_soc_ops zx297520xx_ops1 = {
	.startup = zx297520xx_startup,
	.shutdown = zx297520xx_shutdown,
	.hw_params = zx297520xx_hw_params1,
};

static struct snd_soc_ops zx297520xx_ops2 = {
	.startup = zx297520xx_startup,
	.shutdown = zx297520xx_shutdown2,
	.hw_params = zx297520xx_hw_params1,
	.prepare = zx297520xx_prepare2,
};

static struct snd_soc_dai_link zxic_dai_link[] = {
	{
		.name = "Audio_Media",
		.stream_name = "MultiMedia",
		.codec_name = "es8374.1-0010",
		.codec_dai_name = "ES8374 HiFi",
		.cpu_dai_name = "MultiMedia", //"zx29_i2s.0"
		.ops = &zx297520xx_ops,
		.init = zx297520xx_init_paiftx,
		.platform_name	= "zx29-pcm-audio",
	},
	{
		.name = "voice_call",
		.stream_name = "voice",
		.codec_name = "es8374.1-0010",
		.codec_dai_name = "ES8374 HiFi",
		.cpu_dai_name = "voice", //"snd-soc-dummy-dai",
		.platform_name	= "snd-soc-dummy",
		.init = zx297520xx_init_paiftx,
		.ops = &zx297520xx_ops1,
	},
#ifdef CONFIG_PREEMPT_RT_FULL
	{
		.name = "2&3g_voice",
		.stream_name = "2_3g_voice",
		.codec_name = "es8374.1-0010",
		.codec_dai_name = "ES8374 HiFi",
		.cpu_dai_name = "voice", //"snd-soc-dummy-dai",
		.platform_name	= "voice_audio",
		.init = zx297520xx_init_paiftx,
		.ops = &zx297520xx_ops1,
	},
	{
		.name = "loop_test",
		.stream_name = "loop_voice",
		.codec_name = "es8374.1-0010",
		.codec_dai_name = "ES8374 HiFi",
		.cpu_dai_name = "voice", //"snd-soc-dummy-dai",
		.platform_name	= "snd-soc-dummy",
		.init = zx297520xx_init_paiftx,
		.ops = &zx297520xx_ops2,
	},
	{
		.name = "3g_voice", // 3g nb,wb
		.stream_name = "3g_voice",
		.codec_name = "es8374.1-0010",
		.codec_dai_name = "ES8374 HiFi",
		.cpu_dai_name = "voice", //"snd-soc-dummy-dai",
		.platform_name	= "voice_audio",
		.init = zx297520xx_init_paiftx,
		.ops = &zx297520xx_ops1,
	}
#endif
};

static struct snd_soc_card zxic_soc_card = {
	.name = "zx297520v3_es8374",
	.owner = THIS_MODULE,
	.dai_link = &zxic_dai_link,
	.num_links = ARRAY_SIZE(zxic_dai_link),
#ifdef CONFIG_PREEMPT_RT_FULL
	.controls = vp_snd_controls,
	.num_controls = ARRAY_SIZE(vp_snd_controls),
#endif

//	.late_probe = zx29_late_probe,
	
};

static struct zx297520v3_es8374_pdata *zx29_platform_data;

static int zx297520xx_setup_pins(struct zx297520v3_es8374_pdata *codec_pins, char *fun)
{
	int ret;

	ret = gpio_request(codec_pins->codec_refclk, "codec_refclk");
	if (ret < 0) {
		printk(KERN_ERR "zx297520xx SoC Audio: %s pin already in use\n", fun);
		return ret;
	}
	zx29_gpio_config(codec_pins->codec_refclk, GPIO15_CLK_OUT0);

#ifdef  _USE_7520V3_PHONE_TYPE_C31F

	ret = gpio_request_one(ZX29_GPIO_39, GPIOF_OUT_INIT_LOW, "codec_pa");
	if (ret < 0) {
		printk(KERN_ERR "zx297520xx SoC Audio:  codec_pa in use\n");
		return ret;
	}
	
	ret = gpio_request_one(ZX29_GPIO_40, GPIOF_OUT_INIT_LOW, "codec_sw");
	if (ret < 0) {
		printk(KERN_ERR "zx297520xx SoC Audio:  codec_sw in use\n");
		return ret;
	}
#endif
#ifdef  _USE_7520V3_PHONE_TYPE_WTWD

	ret = gpio_request_one(ZX29_GPIO_39, GPIOF_OUT_INIT_LOW, "codec_pa");
	if (ret < 0) {
		printk(KERN_ERR "zx297520xx SoC Audio:  codec_pa in use\n");
		return ret;
	}	
#endif

	return 0;
}
#endif

static int zx297520xx_probe(struct platform_device *pdev)
{
	int ret;

//	print_audio("Alsa  zx297520xx SoC Audio driver\n");

	zx29_platform_data = pdev->dev.platform_data;
	if (zx29_platform_data == NULL) {
		printk(KERN_ERR "Alsa  zx297520xx SoC Audio: unable to find platform data\n");
		return -ENODEV;
	}

	if (zx297520xx_setup_pins(zx29_platform_data, "codec") < 0)
		return -EBUSY;

	zx29_i2s_top_reg_cfg();

	zx29_snd_device = platform_device_alloc("soc-audio", -1);
	if (!zx29_snd_device) {
		printk(KERN_ERR "Alsa  zx297520xx SoC Audio: Unable to register\n");
		return -ENOMEM;
	}

	platform_set_drvdata(zx29_snd_device, &zxic_soc_card);
//	platform_device_add_data(zx29xx_ti3100_snd_device, &zx29xx_ti3100, sizeof(zx29xx_ti3100));
	ret = platform_device_add(zx29_snd_device);
	if (ret) {
		printk(KERN_ERR "Alsa  zx297520xx SoC Audio: Unable to add\n");
		platform_device_put(zx29_snd_device);
	}

	return ret;
}

static int zx297520xx_remove(struct platform_device *pdev)
{
	gpio_free(zx29_platform_data->codec_refclk);
	platform_device_unregister(zx29_snd_device);
	return 0;
}

static struct platform_driver zx297520xx_platform_driver = {
	.probe  = zx297520xx_probe,
	.remove = zx297520xx_remove,
	.driver = {
		.name = "zx29_snd_machine",
		.owner = THIS_MODULE,
	},
};

module_platform_driver(zx297520xx_platform_driver);

MODULE_DESCRIPTION("zx297520xx ALSA SoC audio driver");
MODULE_LICENSE("GPL");

#ifdef _USE_7520V3_PHONE_TYPE_WTWD 
#define  PA_PULSE_COUNT                 1//old 3
int Get_current_audioPath(void)
{
    return curpath;
}
void SpkPaSwitch(int path)
{
    int i = 0;
	unsigned long  flags;
    
    if (VP_PATH_SPEAKER == path)
    {
        #if 1
        gpio_set_value(ZX29_GPIO_39, GPIO_LOW);
        mdelay(1);
		
        raw_spin_lock_irqsave(&codec_pa_lock, flags);
        for (i = 0; i < PA_PULSE_COUNT; i++)
        {       
            gpio_set_value(ZX29_GPIO_39, GPIO_HIGH);
            udelay(2);
            gpio_set_value(ZX29_GPIO_39, GPIO_LOW);     
            udelay(2);
        }       
            gpio_set_value(ZX29_GPIO_39, GPIO_HIGH);
            raw_spin_unlock_irqrestore(&codec_pa_lock, flags);
        #endif

    }
	else
	{
	    
	        gpio_set_value(ZX29_GPIO_39, GPIO_LOW);     
            udelay(2);
	
	}

}
#endif
