#include <dma_cfg.h>

#ifdef LYNQ_NV_CFG_SUPPORT

#include "../rsa/drv_rsa.h"
#include "../hash/drv_hash.h"
#include "lynq_uboot_nv_cfg.h"

#define LYNQ_ERROR(t) do{BOOT_PRINTF(UBOOT_NOTICE, t);}while(0)

#define DEBUG_LYNQ_NV_CFG 1

#ifdef DEBUG_LYNQ_NV_CFG
void lynq_hex_display(u32 * buff, int len)
{
    int i, pos;
    char * txt_buffer = malloc(4096);
    memset(txt_buffer, 0, 4096);
    pos = 0;
    BOOT_PRINTF(UBOOT_NOTICE, "display data begin:\n");
    for(i=0;i<len;i++)
    {
        pos += sprintf(txt_buffer+pos, "%08x", buff[i]);
        //BOOT_PRINTF(UBOOT_NOTICE, "%08x ", buff[i]);
        if (i % 8 == 7 )
        {
            BOOT_PRINTF(UBOOT_NOTICE, "%s\n", txt_buffer);
            memset(txt_buffer, 0, 4096);
            pos = 0;
        }
    }
    BOOT_PRINTF(UBOOT_NOTICE, "%s\n", txt_buffer);
    free(txt_buffer);
}
#define LYNQ_DEBUG(t) do{BOOT_PRINTF(UBOOT_NOTICE, t);}while(0)
#else
#define lynq_hex_display(...) do{}while(0)
#define LYNQ_DEBUG(t) do{}while(0)
#endif

int check_lynq_nv_cfg(void)
{
    struct lynq_nv_cfg * tmp_cfg;
    int content_len, pos, len, x;
    T_Rsa_Paramter sRSAInput;
    u32 uiRet = -1;
    u32 uiHashResArr[4] = {0};
    u32 uiHashResLen = 0;
    u32 uiRsaResArr[RSA_U32_LEN] = {0};
    u32 puiArrPubKey[RSA_U32_LEN*2] = {0};
    u32 *puiRsaResAddr = NULL;
    char * tmp_buffer = malloc(MMC_LYNQ_NV_CFG_SIZE*3);
    memset(tmp_buffer, 0 , MMC_LYNQ_NV_CFG_SIZE*3);
    tmp_cfg = (struct lynq_nv_cfg *)tmp_buffer;
    if (sizeof (lynq_nv_cfg_bitmap) <= 0 || sizeof (lynq_nv_cfg_bitmap) != sizeof (oem_nv_cfg_bitmap))
    {
        LYNQ_ERROR("got bad bitmap\n");
        goto fail_exit;
    }
    if (sizeof (lynq_nv_cfg_publickey) != LYNQ_NV_CFG_PUBLICKEY_LEN)
    {
        LYNQ_ERROR("got bad public key\n");
        goto fail_exit;
    }
    if (sizeof (lynq_nv_cfg_sign) != LYNQ_NV_CFG_SIGN_LEN )
    {
        LYNQ_ERROR("got bad sign\n");
        goto fail_exit;
    }
    if (sizeof(lynq_nv_cfg_value) == sizeof(struct lynq_nv_cfg))
    {
        pos = 0;
        len = sizeof(lynq_nv_cfg_value);
        memcpy(tmp_cfg, lynq_nv_cfg_value, len);
        pos += len;
        content_len = ((char*)&tmp_cfg->tail - (char*)&tmp_cfg->head) - sizeof(struct lynq_nv_cfg_header);

        if (tmp_cfg->head.magic_flag == 0xaa55 && tmp_cfg->tail.magic_flag == 0x55aa
                && tmp_cfg->head.content_len == content_len  && tmp_cfg->tail.content_len == content_len
                && tmp_cfg->head.valid_flag == 1 && tmp_cfg->tail.valid_flag == 1)
        {
            len = sizeof (lynq_nv_cfg_version);
            memcpy(tmp_buffer+pos, lynq_nv_cfg_version, len);
            pos += len;

            len = sizeof (lynq_nv_cfg_bitmap);
            memcpy(tmp_buffer+pos, lynq_nv_cfg_bitmap, len);
            pos += len;

            len = sizeof (oem_nv_cfg_bitmap);
            memcpy(tmp_buffer+pos, oem_nv_cfg_bitmap, len);
            pos += len;

            for(x=0; x < sizeof(lynq_nv_cfg_bitmap); x++)
            {
                tmp_cfg->content[x] &= lynq_nv_cfg_bitmap[x];
            }

            memcpy(puiArrPubKey, lynq_nv_cfg_publickey, RSA_BYTE_LEN);
            memcpy((puiArrPubKey+(RSA_U32_LEN*2 -1)), lynq_nv_cfg_publickey + RSA_BYTE_LEN, sizeof(u32));
            sRSAInput.udCalMode = RSA_MOD_EXPO_WITH_INIT;
            sRSAInput.udNbitLen = RAS_BIT_LEN;
            sRSAInput.udEbitLen = RAS_BIT_LEN;
            sRSAInput.pudInputM = (u32*)lynq_nv_cfg_sign;
            sRSAInput.pudInputE = (u32*)puiArrPubKey + RSA_U32_LEN;
            sRSAInput.pudInputN = ((u32*)puiArrPubKey);
            sRSAInput.pudOutputP = uiRsaResArr;

            lynq_hex_display(sRSAInput.pudInputE, RSA_U32_LEN);
            lynq_hex_display(sRSAInput.pudInputN, RSA_U32_LEN);
            lynq_hex_display(sRSAInput.pudInputM, RSA_U32_LEN);

            uiRet = Rsa_Calculate(sRSAInput);
            if(uiRet != 0)
            {
                LYNQ_ERROR("calc rsa fail\n");
                goto fail_exit;
            }

            lynq_hex_display(uiRsaResArr, RSA_U32_LEN);

            uiRet = Hash_Calculate(HASH_MODE_MD5,
                                   HASH_SMALL_ENDIAN,
                                   (u32*)tmp_buffer,
                                   pos,
                                   NULL,
                                   0,
                                   uiHashResArr,
                                   &uiHashResLen);
            if(uiRet != 0)
            {
                LYNQ_ERROR("calc hash fail\n");
                goto fail_exit;
            }
            lynq_hex_display(uiHashResArr, uiHashResLen);

            puiRsaResAddr = sRSAInput.pudOutputP + (RSA_U32_LEN - uiHashResLen);

            if (memcmp(puiRsaResAddr, uiHashResArr, uiHashResLen*sizeof (u32)) != 0)
            {
                LYNQ_ERROR("not valid sign\n");
                goto fail_exit;
            }
        }
        else
        {
            LYNQ_ERROR("not valid head\n");
            goto fail_exit;
        }
    }
    else
    {
        LYNQ_ERROR("not valid cfg\n");
        goto fail_exit;
    }

    free(tmp_buffer);
//    for (x=0;x<10;x++)
//        udelay (600000);
//    LYNQ_ERROR("cy: lynq_setup_nv_cfg\n");
    return 0;
fail_exit:
    free(tmp_buffer);
    return -1;
}

extern char* get_oem_nv_cfg(void);
void lynq_setup_nv_cfg(void)
{
    char * oem_cfg_buff;
    memset((void*)MMC_LYNQ_NV_CFG_ADDR, 0, MMC_LYNQ_NV_CFG_SIZE);
    if (sizeof(lynq_nv_cfg_value) <= MMC_LYNQ_NV_CFG_SIZE && check_lynq_nv_cfg() == 0)
    {
        oem_cfg_buff = get_oem_nv_cfg();
        if (oem_cfg_buff != NULL)
        {
            memcpy((void*)MMC_LYNQ_NV_CFG_ADDR, oem_cfg_buff, sizeof(lynq_nv_cfg_value));
            free(oem_cfg_buff);
            LYNQ_DEBUG("using oem nv cfg\n");
        }
        else
        {
            memcpy((void*)MMC_LYNQ_NV_CFG_ADDR, lynq_nv_cfg_value, sizeof(lynq_nv_cfg_value));
            LYNQ_DEBUG("using lynq nv cfg\n");
        }
    }
    else
    {
        LYNQ_ERROR("lynq_setup_nv_cfg no valid nv config\n");
    }
}

#endif

