#ifndef __LYNQ_UBOOT_NV_CFG__H__
#define __LYNQ_UBOOT_NV_CFG__H__

#define RAS_BIT_LEN 1024
#define RSA_BYTE_LEN (RAS_BIT_LEN / 8)
#define RSA_U32_LEN (RSA_BYTE_LEN / sizeof(u32))
#define LYNQ_NV_CFG_SIGN_LEN RSA_BYTE_LEN
#define LYNQ_NV_CFG_PUBLICKEY_LEN (RSA_BYTE_LEN + sizeof(u32))

#pragma pack(1)

struct lynq_nv_cfg_header
{
    unsigned short magic_flag;
    unsigned short valid_flag:1;
    unsigned short content_len:15;
};
struct lynq_nv_cfg
{
    struct lynq_nv_cfg_header head;
    unsigned char content[4];
    struct lynq_nv_cfg_header tail;
    unsigned int lynq_reserved[1];
};
#pragma pack()

static const char lynq_nv_cfg_version[] = "T106_CN_20240627";
static const char lynq_nv_cfg_value[] = {
    '\x55', '\xaa', '\x09', '\x00', '\x40', '\x00', '\x00', '\x00', '\xaa', '\x55', '\x09', '\x00', '\x01', '\x00', '\x15', '\xc0'
};

static const char lynq_nv_cfg_bitmap[] = {
    '\xc0', '\x80', '\x80', '\x80'
};
static const char oem_nv_cfg_bitmap[] = {
    '\x80', '\x80', '\x80', '\x80'
};
static const char lynq_nv_cfg_publickey[] = {
    '\xe7', '\x09', '\xa3', '\x94', '\x19', '\x39', '\x46', '\x55', '\x59', '\x0f', '\x1b', '\x81', '\xa3', '\x61', '\x45', '\x3b', 
    '\x74', '\x07', '\x9a', '\x21', '\x4a', '\xb3', '\x63', '\x1b', '\x96', '\x32', '\xf8', '\xbb', '\xc2', '\x4e', '\xf1', '\xa6', 
    '\x0c', '\x77', '\x43', '\xe0', '\x45', '\x15', '\xb2', '\x1c', '\x2d', '\xf1', '\xf9', '\x22', '\xdb', '\xbc', '\xfb', '\x5c', 
    '\xef', '\x3d', '\x4b', '\xc3', '\x91', '\xfa', '\x1f', '\xe8', '\x36', '\xc9', '\xd8', '\xcf', '\x79', '\xf3', '\xe8', '\xbe', 
    '\x30', '\x7e', '\x11', '\x8b', '\x7f', '\xc9', '\x22', '\xfb', '\x3c', '\x77', '\x7a', '\xa2', '\xd8', '\x23', '\x60', '\xc5', 
    '\x79', '\x97', '\xbf', '\x8d', '\x21', '\xee', '\x87', '\xd3', '\xdf', '\x2c', '\xc3', '\x34', '\xd8', '\xa2', '\x3d', '\xca', 
    '\x40', '\xf3', '\x83', '\x23', '\x28', '\x82', '\xb3', '\x67', '\xf8', '\x34', '\xdd', '\x9c', '\x40', '\x35', '\x61', '\x85', 
    '\x89', '\xae', '\xc2', '\x26', '\xfb', '\xbd', '\x77', '\xe6', '\xfe', '\x81', '\x39', '\xc3', '\xd1', '\x7b', '\xe0', '\x39', 
    '\x01', '\x00', '\x01', '\x00'
};
static const char lynq_nv_cfg_sign[] = {
    '\x79', '\xc0', '\x04', '\x03', '\xb3', '\x6b', '\x18', '\x12', '\x1d', '\x09', '\xf7', '\x7f', '\xb0', '\x56', '\x86', '\x9c', 
    '\x26', '\x21', '\x75', '\xbd', '\x0e', '\x93', '\xe1', '\x3d', '\xae', '\x35', '\x68', '\x6f', '\xfc', '\x0a', '\x0a', '\x40', 
    '\x48', '\x40', '\xf3', '\x95', '\x7c', '\x26', '\xb8', '\xd7', '\xc3', '\xd0', '\xc9', '\x99', '\x35', '\x0f', '\x0f', '\x36', 
    '\x77', '\xe4', '\x98', '\x41', '\x25', '\xa1', '\xff', '\xbd', '\x4c', '\xad', '\x41', '\xe3', '\x9c', '\x73', '\x92', '\x66', 
    '\xaa', '\xad', '\x3e', '\x17', '\x78', '\xaa', '\x86', '\x78', '\x61', '\x56', '\x63', '\x2a', '\xa4', '\xc0', '\x49', '\x28', 
    '\x25', '\x3a', '\xb5', '\x53', '\x23', '\xe4', '\x2c', '\x79', '\x69', '\x6a', '\x45', '\x86', '\xbc', '\x5c', '\x08', '\x57', 
    '\xa4', '\xc6', '\x7f', '\xf5', '\x0e', '\x32', '\xf5', '\x46', '\x9a', '\xa1', '\xef', '\x07', '\xc3', '\x5d', '\x09', '\x75', 
    '\xc0', '\x87', '\x8d', '\x1d', '\x0d', '\x0a', '\x07', '\xca', '\xb2', '\xb8', '\xe8', '\x75', '\x9d', '\x37', '\xcf', '\xeb'
};

#endif
