#!/bin/sh
#
# Run the daemon
#

DAEMON="lynq-ril-service"
PIDFILE="/var/run/$DAEMON.pid"
EXEC="/usr/bin/lynq-ril-service"
EXEC_ARGS=""


start() {
        echo -n "Starting $DAEMON... "
        start-stop-daemon --notify-await --no-close -S -b -m -p $PIDFILE -x $EXEC -- $EXEC_ARGS
        [ $? -eq 0 ] && echo "OK" || echo "ERROR"
}

stop() {
        echo -n "Stopping $DAEMON... "
        start-stop-daemon -K -p $PIDFILE
        [ $? -eq 0 ] && echo "OK" || echo "ERROR"
}

restart() {
        stop
        start
}

case "$1" in
  start|stop|restart)
        "$1"
        ;;
  *)
        echo "Usage: $0 {start|stop|restart}"
        exit 1
esac

exit $?

