#include <pthread.h>
#include "lynq_sms_manager.h"
#include <liblog/lynq_deflog.h>
#include <sqlite3.h>
#include <log/log.h>
#include <stdlib.h>
#include <string.h>
#include "common.h"
sms_manager * g_smsManagement;
int sms_indexs[LYNQ_MAX_SMS_LIST]={0};
int next_index = 0;

sms_manager::sms_manager()
{
    set_sms_total(0);
    return;
}
sms_manager:: ~ sms_manager(){}
int lynq_sms_callback(void *data, int argc, char **argv, char **azColName){
    int i;
    if(next_index < LYNQ_MAX_SMS_LIST)
    {
        sms_indexs[next_index++] = atoi(argv[0]);
    }
    LYVERBLOG("next_index=%d",next_index);
    for(i=0; i<argc; i++){
       LYDBGLOG("%s = %s", azColName[i], argv[i] ? argv[i] : "NULL");
    }
    return 0;
}

/**
 * @brief Check whether the ID exists in the database
 * 
 * @param index 
 * @return int 
 * find:turn 1 
 * not find:turn 0
 */
int sms_manager::lynq_check_index(int index)
{
    memset(sms_indexs,0,LYNQ_MAX_SMS_LIST);
    next_index = 0;
    char *zErrMsg = 0;
    int rc;
    char sql[128]={0};
    /* Open database */
    rc = sqlite3_open(SMS_DB_PATH, &smsDb);
    if( rc )
    {
        LYVERBLOG("[%s] Can't open database: %s\n", __FUNCTION__,sqlite3_errmsg(smsDb));
        return LYNQ_E_SMS_DB_FAIL;
    }
    sprintf(sql,"%s", "SELECT * from LYNQSMS");
    rc = sqlite3_exec(smsDb, sql, lynq_sms_callback, NULL, &zErrMsg);
    if( rc != SQLITE_OK )
    {
        LYVERBLOG("SQL error: %s\n", zErrMsg);
        sqlite3_free(zErrMsg);
        sqlite3_close(smsDb);
        return LYNQ_E_SMS_SQL_FAIL;
    }
    for(int cnt = 0; cnt < next_index;cnt++)
    {
        if(index == sms_indexs[cnt])
        {
            sqlite3_close(smsDb);
            return 1;
        }
    }
    sqlite3_close(smsDb);
    return 0;
}

int read_sms_from_memory_cb(void *data, int argc, char **argv, char **azColName)
{
    if(data==NULL)
    {
        return 1;
    }
    sms_indexs[next_index] = atoi(argv[0]);
    next_index++;
    LYVERBLOG("next_index=%d",next_index);
    lynq_sms_t* temp = (lynq_sms_t *)data;
    for(int i=0; i<argc; i++){
       LYVERBLOG("[%s]%s = %s\n", __FUNCTION__,azColName[i], argv[i] ? argv[i] : "NULL");
    }
    LYVERBLOG("lcz1111 smsInfo address %p\n",temp);
    temp->index = atoi(argv[0]);
    temp->slot_id = atoi(argv[1]);
    temp->lynq_sms_status=(lynq_sms_status_t)atoi(argv[2]);
    LYVERBLOG("lcz2222 smsInfo.adress address %p\n",temp->address);
    strncpy(temp->address,argv[3],LYNQ_TELEPHONE_NUM_LEN);
    temp->addrLen = strlen(argv[3]);
    LYVERBLOG("lcz3333 smsInfo.sms %p\n",temp->smsc);
    strncpy(temp->smsc,argv[4],LYNQ_SMS_MAX_SCA_NUMBER_LEN);
    temp->smscLen = strlen(argv[4]);
    temp->charset = atoi(argv[5]);
    LYVERBLOG("lcz_pdu smsInfo.pdu %p\n",temp->pdu);
    strncpy(temp->pdu,argv[6],LYNQ_SMS_MAX_PDU_NUMBER_LEN);
    temp->pduLen = strlen(argv[6]);
    LYVERBLOG("lcz5555 smsInfo.text %p\n",temp->sms_text);
    strncpy(temp->sms_text,argv[7],LYNQ_SMS_MAX_TEXT_NUMBER_LEN);
    temp->sms_text_len = strlen(argv[7]);
    /*lei add for gsw 2022/5/12*/
    temp->current = atoi(argv[8]);
    RLOGD("temp->current = %d", temp->current);
    temp->total = atoi(argv[9]);
    RLOGD("temp->total = %d", temp->total);
    /*lei add for gsw 2022/5/12*/
    return 0;
}

/*
int list_sms_from_memory_cb(void *data, int argc, char **argv, char **azColName)
{
    if(data==NULL)
    {
        return 1;
    }
    lynq_sms_list_t* temp = (lynq_sms_list_t *)data;
    for(int i=0; i<argc; i++){
       LYVERBLOG("[%s]%s = %s", __FUNCTION__,azColName[i], argv[i] ? argv[i] : "NULL");
    }
}
*/
int callback(void *NotUsed, int argc, char **argv, char **azColName){
   int i;
   for(i=0; i<argc; i++){
      LYVERBLOG("[%s]%s = %s", __FUNCTION__,azColName[i], argv[i] ? argv[i] : "NULL");
   }
   return 0;
}

int sms_manager::find_unuse_sms_index(char *path)
{
    char *zErrMsg = 0;
    int rc;
    int count =1;
    bool sms_usable = false;
    char *sql;
    //const char* data = "Callback function called";
    //int indexs[LYNQ_MAX_SMS_LIST]={0};
    memset(sms_indexs,0,LYNQ_MAX_SMS_LIST);
    next_index = 0;
    LYVERBLOG("index = %p",sms_indexs);
    /* Open database */
    rc = sqlite3_open(SMS_DB_PATH, &smsDb);
    if( rc )
    {
       LYERRLOG("Can't open database: %s\n", sqlite3_errmsg(smsDb));
       return -1;
    }
    else
    {
       LYDBGLOG("Opened database successfully\n");
    }

    /* Create SQL statement */
    sql = "SELECT ID from LYNQSMS";
    /* Execute SQL statement */
    //int* temp_index = indexs;
    rc = sqlite3_exec(smsDb, sql, lynq_sms_callback,NULL, &zErrMsg);
    if( rc != SQLITE_OK )
    {
        LYERRLOG("SQL error: %s\n", zErrMsg);
        sqlite3_free(zErrMsg);
        sqlite3_close(smsDb);
        return -1;
    }
    else
    {
       LYDBGLOG("Operation done successfully\n");
    }
    //indexs = temp_index;
    LYVERBLOG("index = %p",sms_indexs);
    for(count;count<=LYNQ_MAX_SMS_LIST;count++)
    {
        if(sms_indexs[count-1]!=count)
        {
            sms_usable=true;
            break;
        }
    }
    if((!sms_usable)&&(count > LYNQ_MAX_SMS_LIST))
    {
        set_sms_full(true);
    }
    sqlite3_close(smsDb);
    return count;
}

int sms_manager::lynq_check_sms_full()
{
    int id = find_unuse_sms_index(SMS_DB_PATH);
    RLOGD("[%s] id = %d\n",__FUNCTION__,id);
    if(!get_sms_full())
    {
        return id;
    }
    LYERRLOG("sms storage space is full!!!");
    return -1;
}

int sms_manager::lynq_write_sms_to_memory(const char* data,const char *num,const char *smsc,const char *msg,const int charset,const int slot_id,int current,int total)
{
    int id = lynq_check_sms_full();
    if(id > 0)
    {
        RLOGD("[%s] sms full is false\n",__FUNCTION__);
        lynq_write_sms_to_sms_db(id, slot_id,0,smsc, charset,data,msg,SMS_DB_PATH,num,current,total);
        return id;//sms story index
    }
    else
        return -1;
}
int sms_manager::lynq_delete_sms_from_memory(const int index)
{
    char *zErrMsg = 0;
    int rc;
    char sql[128]={0};
    if(index != -1)
    {
        if(!lynq_check_index(index))
        {
            return LYNQ_E_SMS_SQL_FAIL;
        }
    }
    /*lei add*/
    
    /* Open database */
    rc = sqlite3_open(SMS_DB_PATH, &smsDb);
    if(index == -1)
    {
        sprintf(sql,"DELETE  from LYNQSMS");
        if( rc )
        {
            LYVERBLOG("[%s] Can't open database: %s\n", __FUNCTION__,sqlite3_errmsg(smsDb));
            return LYNQ_E_SMS_DB_FAIL;
        }
        LYVERBLOG("[%s] Opened database successfully\n",__FUNCTION__);
        rc = sqlite3_exec(smsDb, sql, NULL, NULL, &zErrMsg);
        if( rc != SQLITE_OK )
        {
            LYVERBLOG("SQL error: %s\n", zErrMsg);
            sqlite3_free(zErrMsg);
            sqlite3_close(smsDb);
            return LYNQ_E_SMS_SQL_FAIL;
        }
        LYVERBLOG("delete sms %d successfully\n",index);
        sqlite3_close(smsDb);
        memset(sms_indexs, 0, sizeof(sms_indexs)); // clear 
        next_index = 0;
        set_sms_full(false);
        return 0;
    }
    else
    {
        if( rc )
        {
            LYVERBLOG("[%s] Can't open database: %s\n", __FUNCTION__,sqlite3_errmsg(smsDb));
            return LYNQ_E_SMS_DB_FAIL;
        }
        LYVERBLOG("[%s] Opened database successfully\n",__FUNCTION__);
        /* Create SQL statement */
        //sql = "SELECT * from LYNQSMS";
        sprintf(sql,"DELETE  from LYNQSMS WHERE ID=%d",index);
        /* Execute SQL statement */
        rc = sqlite3_exec(smsDb, sql, NULL, NULL, &zErrMsg);
        if( rc != SQLITE_OK )
        {
            LYVERBLOG("SQL error: %s\n", zErrMsg);
            sqlite3_free(zErrMsg);
            sqlite3_close(smsDb);
            return LYNQ_E_SMS_SQL_FAIL;
        }
        LYVERBLOG("delete sms %d successfully\n",index);
        sqlite3_close(smsDb);
        return 0;
    }
}
int sms_manager::lynq_read_sms_from_memory(const int index, lynq_sms_t *sms)
{
    /*lei add*/
    if(!lynq_check_index(index))
    {
        return LYNQ_E_SMS_SQL_FAIL;
    }
    /*lei add*/
    char *zErrMsg = 0;
    int rc;
    char sql[128]={0};
    /* Open database */
    rc = sqlite3_open(SMS_DB_PATH, &smsDb);
    if( rc )
    {
        LYVERBLOG("[%s] Can't open database: %s\n", __FUNCTION__,sqlite3_errmsg(smsDb));
        return LYNQ_E_SMS_DB_FAIL;
    }
    LYVERBLOG("[%s] Opened database successfully\n",__FUNCTION__);
    /* Create SQL statement */
    //sql = "SELECT * from LYNQSMS";
    sprintf(sql,"SELECT * from LYNQSMS WHERE ID=%d",index);
   /* Execute SQL statement */
    rc = sqlite3_exec(smsDb, sql, read_sms_from_memory_cb, (void *)sms, &zErrMsg);
    if( rc != SQLITE_OK )
    {
        LYVERBLOG("SQL error: %s\n", zErrMsg);
        sqlite3_free(zErrMsg);
        sqlite3_close(smsDb);
        return LYNQ_E_SMS_SQL_FAIL;
    }
    memset(sql,0,128);
    sprintf(sql,"UPDATE LYNQSMS set STATUS = 1 WHERE ID=%d",index);
    rc = sqlite3_exec(smsDb, sql, NULL,NULL, &zErrMsg);
    if( rc != SQLITE_OK )
    {
        LYVERBLOG("update SQL error: %s\n", zErrMsg);
        sqlite3_free(zErrMsg);
        sqlite3_close(smsDb);
        return LYNQ_E_SMS_SQL_FAIL;
    }
    LYVERBLOG("read sms %d successfully\n",index);
    sqlite3_close(smsDb);
    return 0;
}
int sms_manager::lynq_list_sms_from_memory(const int status,lynq_sms_list_t * sms_list)
{
    if(sms_list==NULL)
    {
        return 1;
    }
    char *zErrMsg = 0;
    int rc;
    char sql[128]={0};
    memset(sms_indexs,0,LYNQ_MAX_SMS_LIST);
    next_index = 0;
    /* Open database */
    rc = sqlite3_open(SMS_DB_PATH, &smsDb);
    if( rc )
    {
        LYVERBLOG("[%s] Can't open database: %s\n", __FUNCTION__,sqlite3_errmsg(smsDb));
        return LYNQ_E_SMS_DB_FAIL;
    }
    LYVERBLOG("[%s] Opened database successfully\n",__FUNCTION__);
    /* Create SQL statement */
    //sql = "SELECT * from LYNQSMS";
    if(status==0)
    {
        sprintf(sql,"SELECT ID from LYNQSMS");
    }
    else
    {
        sprintf(sql,"SELECT ID from LYNQSMS WHERE STATUS=%d",status);
    }
   /* Execute SQL statement */
    rc = sqlite3_exec(smsDb, sql, lynq_sms_callback,NULL, &zErrMsg);
    if( rc != SQLITE_OK )
    {
        LYVERBLOG("SQL error: %s\n", zErrMsg);
        sqlite3_free(zErrMsg);
        sqlite3_close(smsDb);
        return LYNQ_E_SMS_SQL_FAIL;
    }
    for(int i=0;i<next_index;i++)
    {
        sms_list->index[sms_indexs[i]-1]=sms_indexs[i];
        LYVERBLOG("test index =%d\n", sms_list->index[i]);
        RLOGD("test index =%d   sms_indexs %d i %d\n", sms_list->index[sms_indexs[i]-1], sms_indexs[i], i);
    }
    sms_list->num_of_indexs = next_index;
    LYVERBLOG("list sms successfully");
    sqlite3_close(smsDb);
    return 0;
}
int has_sms_db_created(char *path,sqlite3* smsDb_l)
{
    if (path == NULL || strlen(path) == 0)
    {
        LYVERBLOG("initSmsDb error with null path!");
        return SMS_DB_ERR;
    }
    int rc = sqlite3_open_v2(path, &smsDb_l, SQLITE_OPEN_READWRITE,NULL);
    if (rc == SQLITE_OK) 
    {
        LYVERBLOG("check init success!");
        return SMS_DB_READED;
    } 
    else 
    {
        LYVERBLOG("db has not create %s!", sqlite3_errmsg(smsDb_l));
        sqlite3_close_v2(smsDb_l);
        return SMS_DB_ERR;
    }
}
int sms_manager::create_sms_db(char *path)
{
    if (path == NULL || strlen(path) == 0) {
        LYVERBLOG("initSmsDb error with null path!");
        return SMS_DB_ERR;
    }
    if(SMS_DB_READED==has_sms_db_created(path,smsDb))
    {
        return SMS_DB_READED;
    }
    int rc = sqlite3_open(path, &smsDb);
    if (rc != SQLITE_OK) {
        LYVERBLOG("initDb failed %s", sqlite3_errcode(smsDb));
        return SMS_DB_ERR;
    } else {
        LYVERBLOG("create db in %s", path);
    }
    sqlite3_close(smsDb);
    return SMS_DB_CREATE;
}
int sms_manager::create_sms_table(char*path)
{
    char *zErrMsg = 0;
    int rc;
    char *sql;

    /* Open database */
    rc = sqlite3_open(path, &smsDb);
    if( rc )
    {
        LYVERBLOG("[%s] Can't open database: %s\n", __FUNCTION__,sqlite3_errmsg(smsDb));
        return 1;
    }
    LYVERBLOG("[%s] Opened database successfully\n",__FUNCTION__);
    /* Create SQL statement */
    /*lei modify for gsw 2022/5/11*/
    sql = "CREATE TABLE LYNQSMS( \
         ID                       INT PRIMARY KEY      NOT NULL, \
         SLOT                 INT                                 NOT NULL, \
         STATUS            INT                                 NOT NULL, \
         ADDRESS         NONE                                 NOT NULL, \
         SMSC                NONE                             NOT NULL,\
         CHARSET         INT                                 NOT NULL, \
         PDU                   NONE                             NOT NULL, \
         CONTENT         TEXT                             NOT NULL, \
         CURRENT         INT                             NOT NULL, \
         TOTAL         INT                             NOT NULL)";
   /* Execute SQL statement */
   /*lei modify for gsw 2022/5/11*/
    rc = sqlite3_exec(smsDb, sql, NULL, 0, &zErrMsg);
    if( rc != SQLITE_OK )
    {
        LYVERBLOG("SQL error: %s\n", zErrMsg);
        sqlite3_free(zErrMsg);
        sqlite3_close(smsDb);
        return 1;
    }
    LYVERBLOG("Table LYNQSMS created successfully\n");
    sqlite3_close(smsDb);
    return 0;
}
int sms_manager::create_sms_number_table(char * path)
{
    char *zErrMsg = 0;
    int rc;
    char *sql;

    /* Open database */
    rc = sqlite3_open(path, &smsDb);
    if( rc )
    {
        LYVERBLOG("[%s] Can't open database: %s", __FUNCTION__,sqlite3_errmsg(smsDb));
        return 1;
    }
    LYVERBLOG("[%s] Opened database successfully",__FUNCTION__);
    /* Create SQL statement */
    sql = "CREATE TABLE LYNQ_SMS_TOTAL(" \
         "ID                      INT PRIMARY KEY      NOT NULL," \
         "TOTAL             INT                                 NOT NULL);";
   /* Execute SQL statement */
    rc = sqlite3_exec(smsDb, sql, callback, 0, &zErrMsg);
    if( rc != SQLITE_OK )
    {
        LYVERBLOG("SQL error: %s", zErrMsg);
        sqlite3_free(zErrMsg);
        sqlite3_close(smsDb);
        return 1;
    }
    LYDBGLOG("LYNQ_SMS_TOTAL table created successfully");
    sqlite3_close(smsDb);
    return 0;
}
/*lei modify for gsw 2022/5/11*/
int sms_manager::lynq_write_sms_to_sms_db(int id,int slot_id,int status,const char *smsc,int charset,const char *pdu,const char *content,char *path,const char*address,int current,int total)
{
    char *zErrMsg = 0;
    int rc;
    //char sql[LYNQ_SMS_MAX_SCA_NUMBER_LEN+LYNQ_SMS_MAX_PDU_NUMBER_LEN+LYNQ_SMS_MAX_TEXT_NUMBER_LEN+3+1+100]={0};
    /* Open database */
    rc = sqlite3_open(path, &smsDb);
    if( rc )
    {
        RLOGD("[%s] Can't open database: %s",__FUNCTION__,sqlite3_errmsg(smsDb));
        LYERRLOG("[%s] Can't open database: %s",__FUNCTION__,sqlite3_errmsg(smsDb));
        return 1;
    }
    LYDBGLOG("[%s] Opened database successfully",__FUNCTION__);
    /* Create SQL statement */
    //sprintf(sql,"INSERT INTO LYNQSMS (ID,SLOT,STATUS,ADDRESS,SMSC,CHARSET,PDU,CONTENT,CURRENT,TOTAL) VALUES (%d,%d,%d,'%s','%s',%d,'%s','%s',%d,%d);",id,slot_id,status,address,smsc,charset,pdu,content,current,total);
    /* Execute SQL statement */
    //printf("%s\n",sql);
    char *sql = sqlite3_mprintf("INSERT INTO LYNQSMS VALUES('%d','%d','%d','%q','%q','%d','%q','%q','%d','%d')",id,slot_id,status,address,smsc,charset,pdu,content,current,total);
    rc = sqlite3_exec(smsDb, sql, NULL,NULL, &zErrMsg);
    if( rc != SQLITE_OK )
    {
        RLOGD("SQL error: %s", zErrMsg);
        LYVERBLOG( "SQL error: %s", zErrMsg);
        sqlite3_free(zErrMsg);
        sqlite3_close(smsDb);
        return 1;
    }
    LYDBGLOG("write sms to sms db successfully");
    sqlite3_close(smsDb);
    //printf("write sms to sms db successfully\n");
    return 0;
}
/*lei modify for gsw 2022/5/11*/
int sms_manager::initSmsManager()
{
    int db_ret=0;
    int table_ret=0;
    db_ret = create_sms_db(SMS_DB_PATH);
    if(db_ret==SMS_DB_CREATE)
    {
        table_ret = create_sms_table(SMS_DB_PATH);
        if(table_ret!=0)
        {
            LYERRLOG("create sms table fail!!!");
            return 1;
        }
        table_ret = create_sms_number_table(SMS_DB_PATH);
        if(table_ret!=0)
        {
            LYERRLOG("create sms number table fail!!!");
            return 1;
        }
    }
    else if(db_ret==SMS_DB_READED)
    {
        LYDBGLOG("[%s] sms db has be build!!!",__FUNCTION__);
    }
    else
    {
        LYDBGLOG("init sms db fail!!!");
    }
    set_sms_full(false);
    //get_sms_total();
    return 0;
}

int lynq_init_sms_manager()
{
    g_smsManagement = new sms_manager();
    if(g_smsManagement==NULL)
    {
        RLOGE("init class sms manager fail!!!");
        exit(EXIT_FAILURE);
    }
    RLOGD("init class sms manager success!!!");
    g_smsManagement->initSmsManager();
    return 0;
}


