/* Copyright Statement:
 *
 * This software/firmware and related documentation ("MediaTek Software") are
 * protected under relevant copyright laws. The information contained herein
 * is confidential and proprietary to MediaTek Inc. and/or its licensors.
 * Without the prior written permission of MediaTek inc. and/or its licensors,
 * any reproduction, modification, use or disclosure of MediaTek Software,
 * and information contained herein, in whole or in part, shall be strictly prohibited.
 */
/* MediaTek Inc. (C) 2010. All rights reserved.
 *
 * BY OPENING THIS FILE, RECEIVER HEREBY UNEQUIVOCALLY ACKNOWLEDGES AND AGREES
 * THAT THE SOFTWARE/FIRMWARE AND ITS DOCUMENTATIONS ("MEDIATEK SOFTWARE")
 * RECEIVED FROM MEDIATEK AND/OR ITS REPRESENTATIVES ARE PROVIDED TO RECEIVER ON
 * AN "AS-IS" BASIS ONLY. MEDIATEK EXPRESSLY DISCLAIMS ANY AND ALL WARRANTIES,
 * EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE IMPLIED WARRANTIES OF
 * MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE OR NONINFRINGEMENT.
 * NEITHER DOES MEDIATEK PROVIDE ANY WARRANTY WHATSOEVER WITH RESPECT TO THE
 * SOFTWARE OF ANY THIRD PARTY WHICH MAY BE USED BY, INCORPORATED IN, OR
 * SUPPLIED WITH THE MEDIATEK SOFTWARE, AND RECEIVER AGREES TO LOOK ONLY TO SUCH
 * THIRD PARTY FOR ANY WARRANTY CLAIM RELATING THERETO. RECEIVER EXPRESSLY ACKNOWLEDGES
 * THAT IT IS RECEIVER'S SOLE RESPONSIBILITY TO OBTAIN FROM ANY THIRD PARTY ALL PROPER LICENSES
 * CONTAINED IN MEDIATEK SOFTWARE. MEDIATEK SHALL ALSO NOT BE RESPONSIBLE FOR ANY MEDIATEK
 * SOFTWARE RELEASES MADE TO RECEIVER'S SPECIFICATION OR TO CONFORM TO A PARTICULAR
 * STANDARD OR OPEN FORUM. RECEIVER'S SOLE AND EXCLUSIVE REMEDY AND MEDIATEK'S ENTIRE AND
 * CUMULATIVE LIABILITY WITH RESPECT TO THE MEDIATEK SOFTWARE RELEASED HEREUNDER WILL BE,
 * AT MEDIATEK'S OPTION, TO REVISE OR REPLACE THE MEDIATEK SOFTWARE AT ISSUE,
 * OR REFUND ANY SOFTWARE LICENSE FEES OR SERVICE CHARGE PAID BY RECEIVER TO
 * MEDIATEK FOR SUCH MEDIATEK SOFTWARE AT ISSUE.
 *
 * The following software/firmware and/or related documentation ("MediaTek Software")
 * have been modified by MediaTek Inc. All revisions are subject to any receiver's
 * applicable license agreements with MediaTek Inc.
 */
#ifndef __RIL_CC__
#define __RIL_CC__
#include  <vendor-ril/telephony/ril.h>
#include  "common.h"
typedef enum {
    SPEECH_OFF = 0,
    NORMAL_SPEECH_ON,
    BT_SPEECH_ON,
} speech_status;

typedef enum {
    CALL_OFF = 0,
    CALL_ON,
} call_status;

//extern int callIndex;
int getCallMute();
int setCallMute(bool mute);

int dial(int argc, char **argv, RIL_SOCKET_ID socket_id, RequestInfo *pRI);
int setAudioPath(int argc, char **argv, RIL_SOCKET_ID socket_id, RequestInfo *pRI);
speech_status getSpeechStatus();
void setSpeechAndStatus(int value);
int forceReleaseCall(int argc, char **argv, RIL_SOCKET_ID socket_id, RequestInfo *pRI);
int hangupAll(int argc, char **argv, RIL_SOCKET_ID socket_id, RequestInfo *pRI);
int hangupConnection(int argc, char **argv, RIL_SOCKET_ID socket_id, RequestInfo *pRI);
//int invokeOemRilRequestStrings(int argc, char **argv, RIL_SOCKET_ID socket_id, RequestInfo *pRI);
int separateConnection(int argc, char **argv, RIL_SOCKET_ID socket_id, RequestInfo *pRI);
int rejectCall(int argc, char **argv, RIL_SOCKET_ID socket_id, RequestInfo *pRI);
int acceptCall(int argc, char **argv, RIL_SOCKET_ID socket_id, RequestInfo *pRI);
int conference(int argc, char **argv, RIL_SOCKET_ID socket_id, RequestInfo *pRI);
int hangupWaitingOrBackground(int argc, char **argv, RIL_SOCKET_ID socket_id, RequestInfo *pRI);
int switchWaitingOrHoldingAndActive(int argc, char **argv, RIL_SOCKET_ID socket_id, RequestInfo *pRI);
int hangupForegroundResumeBackground(int argc, char **argv, RIL_SOCKET_ID socket_id, RequestInfo *pRI);
int explicitCallTransfer(int argc, char **argv, RIL_SOCKET_ID socket_id, RequestInfo *pRI);
int sendDtmf(int argc, char **argv, RIL_SOCKET_ID socket_id, RequestInfo *pRI);
int getMute(int argc, char **argv, RIL_SOCKET_ID socket_id, RequestInfo *pRI);
int setMute(int argc, char **argv, RIL_SOCKET_ID socket_id, RequestInfo *pRI);
int getCurrentCalls(int argc, char **argv, RIL_SOCKET_ID socket_id, RequestInfo *pRI);
int autoAnswerCall(int argc, char **argv, RIL_SOCKET_ID socket_id, RequestInfo *pRI);
int inCallRecord(int argc, char **argv, RIL_SOCKET_ID socket_id, RequestInfo *pRI);
int addImsConferenceCallMember(int argc, char **argv, RIL_SOCKET_ID socket_id, RequestInfo *pRI);
int removeImsConferenceCallMember(int argc, char **argv, RIL_SOCKET_ID socket_id, RequestInfo *pRI);
int conferenceDial(int argc, char **argv, RIL_SOCKET_ID socket_id, RequestInfo *pRI);
int dialWithSipUri(int argc, char **argv, RIL_SOCKET_ID socket_id, RequestInfo *pRI);
int holdCall(int argc, char **argv, RIL_SOCKET_ID socket_id, RequestInfo *pRI);
int resumeCall(int argc, char **argv, RIL_SOCKET_ID socket_id, RequestInfo *pRI);
long int mixer_get_volume();
int mixer_set_volume(int value);
//  modem reset
int mixer_reset_set(int value);
#if 0
int setSpeechOn(int argc, char **argv, RIL_SOCKET_ID socket_id, RequestInfo *pRI);
int setSpeechOff(int argc, char **argv, RIL_SOCKET_ID socket_id, RequestInfo *pRI);
#endif
int get_call_status(void);
void set_audio_path(int path);
int get_audio_path(void);
void set_bt_has_ecnr(int ecnr);
int get_bt_has_ecnr(void);
void set_bt_wbs(int wbs);
int get_bt_wbs(void);
int setSpeechVolume(int argc, char **argv, RIL_SOCKET_ID socket_id, RequestInfo *pRI);
int setDtmfVolume(int argc, char **argv, RIL_SOCKET_ID socket_id, RequestInfo *pRI);
//void callStateChange(void);
void speechonoff(int callnum);
void callRing(RIL_SOCKET_ID soc_id);
int handleUnsolSipCallProgressInd(const void *response, size_t responselen);
int emergencyDial(int argc, char **argv, RIL_SOCKET_ID socket_id, RequestInfo *pRI);
int setEccServiceCategory(int argc, char **argv, RIL_SOCKET_ID socket_id, RequestInfo *pRI);
int setEccList(int argc, char **argv, RIL_SOCKET_ID socket_id, RequestInfo *pRI);
int getLastCallFailCause(int argc, char **argv, RIL_SOCKET_ID socket_id, RequestInfo *pRI);
int setEccNum(int argc, char **argv, RIL_SOCKET_ID socket_id, RequestInfo *pRI);
int getEccNum(int argc, char **argv, RIL_SOCKET_ID socket_id, RequestInfo *pRI);
int handleECCNumResponse(const void *data, int datalen, RIL_SOCKET_ID socket_id);
int handleUnsolCallInfoInd(const void *response, size_t responselen, RIL_SOCKET_ID socket_id);
int handleRingbackTone(const void *response, size_t responselen, RIL_SOCKET_ID socket_id);
int stopDtmf(int argc, char **argv, RIL_SOCKET_ID socket_id, RequestInfo *pRI);

int mixer_init();

//#ifdef C2K_SUPPORT
int sendBurstDtmf(int argc, char **argv, RIL_SOCKET_ID socket_id, RequestInfo *pRI);
int sendCDMAFeatureCode(int argc, char **argv, RIL_SOCKET_ID socket_id, RequestInfo *pRI);
void autoAnswerForCdma(RIL_SOCKET_ID socket_id);
void resetMute();
//#endif /*C2K_SUPPORT*/
#endif
