/* Copyright Statement:
 *
 * This software/firmware and related documentation ("MediaTek Software") are
 * protected under relevant copyright laws. The information contained herein
 * is confidential and proprietary to MediaTek Inc. and/or its licensors.
 * Without the prior written permission of MediaTek inc. and/or its licensors,
 * any reproduction, modification, use or disclosure of MediaTek Software,
 * and information contained herein, in whole or in part, shall be strictly prohibited.
 */
/* MediaTek Inc. (C) 2010. All rights reserved.
 *
 * BY OPENING THIS FILE, RECEIVER HEREBY UNEQUIVOCALLY ACKNOWLEDGES AND AGREES
 * THAT THE SOFTWARE/FIRMWARE AND ITS DOCUMENTATIONS ("MEDIATEK SOFTWARE")
 * RECEIVED FROM MEDIATEK AND/OR ITS REPRESENTATIVES ARE PROVIDED TO RECEIVER ON
 * AN "AS-IS" BASIS ONLY. MEDIATEK EXPRESSLY DISCLAIMS ANY AND ALL WARRANTIES,
 * EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE IMPLIED WARRANTIES OF
 * MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE OR NONINFRINGEMENT.
 * NEITHER DOES MEDIATEK PROVIDE ANY WARRANTY WHATSOEVER WITH RESPECT TO THE
 * SOFTWARE OF ANY THIRD PARTY WHICH MAY BE USED BY, INCORPORATED IN, OR
 * SUPPLIED WITH THE MEDIATEK SOFTWARE, AND RECEIVER AGREES TO LOOK ONLY TO SUCH
 * THIRD PARTY FOR ANY WARRANTY CLAIM RELATING THERETO. RECEIVER EXPRESSLY ACKNOWLEDGES
 * THAT IT IS RECEIVER'S SOLE RESPONSIBILITY TO OBTAIN FROM ANY THIRD PARTY ALL PROPER LICENSES
 * CONTAINED IN MEDIATEK SOFTWARE. MEDIATEK SHALL ALSO NOT BE RESPONSIBLE FOR ANY MEDIATEK
 * SOFTWARE RELEASES MADE TO RECEIVER'S SPECIFICATION OR TO CONFORM TO A PARTICULAR
 * STANDARD OR OPEN FORUM. RECEIVER'S SOLE AND EXCLUSIVE REMEDY AND MEDIATEK'S ENTIRE AND
 * CUMULATIVE LIABILITY WITH RESPECT TO THE MEDIATEK SOFTWARE RELEASED HEREUNDER WILL BE,
 * AT MEDIATEK'S OPTION, TO REVISE OR REPLACE THE MEDIATEK SOFTWARE AT ISSUE,
 * OR REFUND ANY SOFTWARE LICENSE FEES OR SERVICE CHARGE PAID BY RECEIVER TO
 * MEDIATEK FOR SUCH MEDIATEK SOFTWARE AT ISSUE.
 *
 * The following software/firmware and/or related documentation ("MediaTek Software")
 * have been modified by MediaTek Inc. All revisions are subject to any receiver's
 * applicable license agreements with MediaTek Inc.
 */

#include <glib.h>
#include <vendor-ril/telephony/ril.h>
#include <stdio.h>
#include <log/log.h>

#undef LOG_TAG
#define LOG_TAG "DEMO_RESP_TIMEOUT"

static GSource *g_resp_source[2];
static GMutex mutex;
static bool tag[2] = {false,false};
static char* name[2] = {"one_minutes_timesout_0","ont_minutes_timesout_1"};

extern void ARspRequest (int request, RIL_SOCKET_ID socket_id);

static gboolean resp_cb(gpointer data) {
  RLOGD("execute response command: RIL_REQUEST_STK_HANDLE_CALL_SETUP_REQUESTED_FROM_SIM");
  ARspRequest(RIL_REQUEST_STK_HANDLE_CALL_SETUP_REQUESTED_FROM_SIM, (RIL_SOCKET_ID)(GPOINTER_TO_INT (data)));
  return G_SOURCE_REMOVE;
}

static gpointer start_timeout_func(gpointer data) {
  RLOGD("start_timeout_func");
  GMainContext *ctx;
  GMainLoop *loop;

  ctx = g_main_context_new ();
  loop = g_main_loop_new (ctx, FALSE);
  int slot = GPOINTER_TO_INT(data);
  g_resp_source[slot] = g_timeout_source_new (1000*60); //one minutes
  g_source_set_callback (g_resp_source[slot], resp_cb, data, NULL);
  g_source_attach (g_resp_source[slot], ctx);
  g_source_unref (g_resp_source[slot]);

  g_main_loop_run (loop);

  RLOGD("release loop and context");
  g_main_loop_unref (loop);
  g_main_context_unref (ctx);
  return NULL;
}

void setup_timeout(int slot_id) {
  RLOGD("setup_timeout");
  g_mutex_lock(&mutex);
  gpointer result;
  GThread *thread;
  GError *error = NULL;

  thread = g_thread_try_new (name[slot_id], start_timeout_func, GINT_TO_POINTER (slot_id), &error);
  tag[slot_id] = true;
  g_mutex_unlock(&mutex);
  g_thread_unref (thread);
}

void clear_timeout(int slot_id) {
  RLOGD("stop timeout configuration");
  g_mutex_lock(&mutex);
  if (tag[slot_id])
  {
    tag[slot_id] = false;
    if (!g_source_is_destroyed(g_resp_source[slot_id]))
    {
      g_source_destroy(g_resp_source[slot_id]);
    }
  }
  g_mutex_unlock(&mutex);
}
