/**
 * 
 * @file      zcat_diag.h
 * @brief     
 *            This file is part of ZCAT.
 *            ZCATDIAGϢͽṹ
 *            
 * @details   
 * @author    Tools Team.
 * @email     
 * @copyright Copyright (C) 2013 Sanechips Technology Co., Ltd.
 * @warning   
 * @date      2019/02/02
 * @version   1.2
 * @pre       
 * @post      
 *            
 * @par       
 * Change History :
 * ---------------------------------------------------------------------------
 * date        version  author         description
 * ---------------------------------------------------------------------------
 * 2012/12/27  1.0      lu.xieji       Create file
 * 2013/10/11  1.1      hou.bing       Add Sys View
 * 2019/02/02  1.2      jiang.fenglin  ޸עͷʽΪdoxygen
 * ---------------------------------------------------------------------------
 * 
 * 
 */

#ifndef ZCAT_DIAG_H
#define ZCAT_DIAG_H

#ifdef __cplusplus
extern "C"
{
#endif


/* ϵͳ۲ */
#define ZCAT_SYSVIEW_BASE                     (UINT32)(EV_ZOSS_TRACE_BASE + 115)
#define ZCAT_SYSVIEW_TASK_REQ                 (UINT32)(ZCAT_SYSVIEW_BASE)         /* Ϣ */
#define ZCAT_SYSVIEW_TASK_INFO                (UINT32)(ZCAT_SYSVIEW_BASE + 1)     /* ӦϢ */
#define ZCAT_SYSVIEW_TASK_RESET_REQ           (UINT32)(ZCAT_SYSVIEW_BASE + 2)     /* дʱϢ */
#define ZCAT_SYSVIEW_TASK_RESET_ACK           (UINT32)(ZCAT_SYSVIEW_BASE + 3)     /* дʱӦϢ */
#define ZCAT_SYSVIEW_THREAD_REQ               (UINT32)(ZCAT_SYSVIEW_BASE + 4)     /* ߳Ϣ */
#define ZCAT_SYSVIEW_THREAD_INFO              (UINT32)(ZCAT_SYSVIEW_BASE + 5)     /* ߳ӦϢ */
#define ZCAT_SYSVIEW_THREAD_RESET_REQ         (UINT32)(ZCAT_SYSVIEW_BASE + 6)     /* ߳дʱϢ */
#define ZCAT_SYSVIEW_THREAD_RESET_ACK         (UINT32)(ZCAT_SYSVIEW_BASE + 7)     /* ߳дʱӦϢ */
#define ZCAT_SYSVIEW_PERF_REQ                 (UINT32)(ZCAT_SYSVIEW_BASE + 8)     /* Ϣ */
#define ZCAT_SYSVIEW_PERF_INFO                (UINT32)(ZCAT_SYSVIEW_BASE + 9)     /* ӦϢ */
#define ZCAT_SYSVIEW_RUNLOG_NAME_REQ          (UINT32)(ZCAT_SYSVIEW_BASE + 10)    /* ̺߳IDԳƹϵ */
#define ZCAT_SYSVIEW_RUNLOG_NAME_INFO         (UINT32)(ZCAT_SYSVIEW_BASE + 11)    /* ̺߳ƺID */
#define ZCAT_SYSVIEW_RUNLOG_SETID_REQ         (UINT32)(ZCAT_SYSVIEW_BASE + 12)    /* ѡҪ¼̺߳ID */
#define ZCAT_SYSVIEW_RUNLOG_SETID_ACK         (UINT32)(ZCAT_SYSVIEW_BASE + 13)    /* ѡҪ¼̺߳IDĻӦ */
#define ZCAT_SYSVIEW_RUNLOG_START_REQ         (UINT32)(ZCAT_SYSVIEW_BASE + 14)    /* ʼ¼л켣󣬰ǷԶֹͣ */
#define ZCAT_SYSVIEW_RUNLOG_START_ACK         (UINT32)(ZCAT_SYSVIEW_BASE + 15)    /* ʼ¼л켣Ӧɹʧ */
#define ZCAT_SYSVIEW_RUNLOG_STOP_REQ          (UINT32)(ZCAT_SYSVIEW_BASE + 16)    /* ֹͣ¼л켣  */
#define ZCAT_SYSVIEW_RUNLOG_HALF_REQ          (UINT32)(ZCAT_SYSVIEW_BASE + 17)    /* ֹͣ¼л켣  */
#define ZCAT_SYSVIEW_RUNLOG_FULL_REQ          (UINT32)(ZCAT_SYSVIEW_BASE + 18)    /* ֹͣ¼л켣  */
#define ZCAT_SYSVIEW_RUNLOG_INFO              (UINT32)(ZCAT_SYSVIEW_BASE + 19)    /* ϱл켣¼ */
#define ZCAT_SYSVIEW_RUNLOG_STOP_ACK          (UINT32)(ZCAT_SYSVIEW_BASE + 20)    /* ϱл켣¼*/
#define ZCAT_SYSVIEW_RUNLOG_LINK_KEEP         (UINT32)(ZCAT_SYSVIEW_BASE + 21)    /* ߳л¼Ϣ*/
#define ZCAT_SYSVIEW_HEAP_REQ                 (UINT32)(ZCAT_SYSVIEW_BASE + 22)    /* ʹϢ */
#define ZCAT_SYSVIEW_HEAP_INFO                (UINT32)(ZCAT_SYSVIEW_BASE + 23)    /* ʹӦϢ */
#define ZCAT_SYSVIEW_UB_USE_REQ               (UINT32)(ZCAT_SYSVIEW_BASE + 24)    /* UBϢ */
#define ZCAT_SYSVIEW_UB_USE_INFO              (UINT32)(ZCAT_SYSVIEW_BASE + 25)    /* UBӦϢ */
#define ZCAT_SYSVIEW_UB_LEAK_REQ              (UINT32)(ZCAT_SYSVIEW_BASE + 26)    /* UBϢ */
#define ZCAT_SYSVIEW_UB_LEAK_INFO             (UINT32)(ZCAT_SYSVIEW_BASE + 27)    /* UBӦϢ */
#define ZCAT_SYSVIEW_FS_REQ                   (UINT32)(ZCAT_SYSVIEW_BASE + 28)    /* ļϵͳϢ */
#define ZCAT_SYSVIEW_FS_INFO                  (UINT32)(ZCAT_SYSVIEW_BASE + 29)    /* ļϵͳӦϢ */
#define ZCAT_SYSVIEW_FW_REQ                   (UINT32)(ZCAT_SYSVIEW_BASE + 30)    /* ӲϢϢ */
#define ZCAT_SYSVIEW_FW_INFO                  (UINT32)(ZCAT_SYSVIEW_BASE + 31)    /* ӲϢӦϢ */


#define ZCAT_SYSVIEW_MAX_THREAD_NAME_LEN      16                                  /* ߳󳤶 */
#define ZCAT_SYSVIEW_MAX_TASK_NAME_LEN        16                                  /* 󳤶 */
#define ZCAT_SYSVIEW_MAX_NAME_LEN             16                                  /* ߳()󳤶 */
#define ZCAT_SYSVIEW_MAX_UBLEAK_FILE_NAME_LEN 8                                   /* UBй¶Ϣļ󳤶 */
#define ZCAT_SYSVIEW_MAX_DRIVER_NAME_LEN      8                                   /* ̷󳤶 */
#define ZCAT_SYSVIEW_MAX_FW_INFO_LEN          32                                  /* ϵͳӲϢݳ */
#define ZCAT_SYSVIEW_MAX_FLASH_NAME_LEN       32                                  /* FLASH󳤶 */
#define ZCAT_SYSVIEW_COMMON_SYNCBIT1          (0x07)                              /* Ϣͬλ1 */
#define ZCAT_SYSVIEW_COMMON_SYNCBIT2          (0x08)                              /* ͨϢͬλ2 */
#define ZCAT_SYSVIEW_PRINT_SYNCBIT2           (0x09)                              /* WinTraceĴӡϢͬλ2 */
#define ZCAT_SYSVIEW_MA_SYNCBIT2              (0x0A)                              /* MaTraceĴӡϢͬλ2 */
#define ZCAT_SYSVIEW_DSP_SYNCBIT2             (0x0B)                              /* DspTraceĴӡϢͬλ2 */
#define ZCAT_SYSVIEW_PRINT_SUBMDL_NUM         (255)                               /* ӡģ */


#define ZCAT_SYSVIEW_NAME_MAX_LEN 16

/* ϵͳ۲쵥Ϣ */
typedef struct _tagtraceTaskInfo
{
    ZOSS_TASK_ID task_id;                                                         /* ID */
    CHAR task_name[ZCAT_SYSVIEW_MAX_TASK_NAME_LEN];                               /*  */
    ZOSS_THREAD_ID thread_id;                                                     /* ߳ID */
    CHAR thread_name[ZCAT_SYSVIEW_MAX_THREAD_NAME_LEN];                           /* ߳ */
    UINT32 task_time;                                                             /* ʱ䣬λms */
    UINT32 task_count;                                                            /* д */
    UINT32 malloc_size;                                                           /* mallocڴС */
    UINT32 ub_size;                                                               /* ubڴС */
    UINT8 thread_priority;                                                        /* ߳ȼ */
    UINT8 task_status;                                                            /* ״̬ȡֵ1.2 */
    UINT8 task_state;                                                             /* ״̬ȡֵ1.2*/
    UINT8 cpu_used;                                                               /* CPUʹ */
} T_ZCAT_SYSVIEW_TaskInfo;

/* ϵͳ۲쵥߳Ϣ */
typedef struct _tagtraceThreadInfo
{
    ZOSS_THREAD_ID thread_id;                                                     /* ߳ID */
    CHAR thread_name[ZCAT_SYSVIEW_MAX_THREAD_NAME_LEN];                           /* ߳ */
    UINT32 stack_size;                                                            /* ջС */
    UINT32 malloc_size;                                                           /* mallocڴС */
    UINT32 ub_size;                                                               /* ubڴС */
    UINT32 msg_count;                                                             /* Ϣ */
    UINT32 stack_address;                                                         /* ջַ */
    UINT32 thread_time;                                                           /* ߳ʱ䣬λms */
    UINT32 thread_count;                                                          /* ߳д */
    UINT8 thread_priority;                                                        /* ߳ȼ(0~31) */
    UINT8 cpu_used;                                                               /* ߳CPUʹ */
    UINT8 stack_used;                                                             /* ջʹ */
    UINT8 run_status;                                                             /* ߳״̬ݲ֧֣0xFF */
} T_ZCAT_SYSVIEW_ThreadInfo;

/* ϵͳ۲Ϣ */
typedef struct _tagtraceSysPerfInfo
{
    UINT32 cpu_used;                                                              /* CPUʹ */
#if 0
    UINT32 mem_used;                                                              /* ڴʹ */
    UINT32 mem_total;                                                             /* ڴ */
#endif
} T_ZCAT_SYSVIEW_SysPerfInfo;

/* CPUй켣߳ӦϢ̺߳Ϣ */
typedef struct _tagtraceThreadTaskInfo
{
    ZOSS_THREAD_ID thread_id;                                                     /* ߳ID */
    ZOSS_TASK_ID task_id;                                                         /* ID(ΪձʾΪ߳) */
    CHAR name[ZCAT_SYSVIEW_MAX_NAME_LEN];                                                /* ߳ */
} T_ZCAT_SYSVIEW_ThreadTaskInfo;

/* ϵͳ۲ʹϢ */
typedef struct _tagtraceSysHeapInfo
{
    UINT32 heap_total;                                                            /* ܴС */
    UINT32 heap_free;                                                             /* ѿдС */
    UINT32 heap_zmalloc;                                                          /* ʹZOSS_MALLOCĶѴС */
} T_ZCAT_SYSVIEW_SysHeapInfo;

/* UBй¶ͷԪϢWinTrace */
typedef struct _tagtraceLeakUBInfo
{
    UINT32 block_size;                                                            /* ڴС */
    UINT32 using_size;                                                            /* ʵռôС */
    char name[ZCAT_SYSVIEW_MAX_UBLEAK_FILE_NAME_LEN];                             /* ļ(·ļǰ11ֽ) */
    UINT32 line;                                                                  /* ļк */
    ZOSS_THREAD_ID thread_id;                                                     /* ߳ID */
    char thread_name[ZCAT_SYSVIEW_MAX_THREAD_NAME_LEN];                           /* ߳ */
    ZOSS_TASK_ID task_id;                                                         /* ID */
    char task_name[ZCAT_SYSVIEW_MAX_TASK_NAME_LEN];                               /*  */
    UINT32 apply_time_tick;                                                       /* ʱ */
} T_ZCAT_SYSVIEW_LeakUBInfo;

/* ԪϢ */
typedef struct _tagtraceSysFSInfo
{
    CHAR driver_name[ZCAT_SYSVIEW_MAX_DRIVER_NAME_LEN];                           /* ̷ */
    UINT64 size_total;                                                            /* ܿռС */
    UINT64 size_free;                                                             /* ʹÿռС */
} T_ZCAT_SYSVIEW_SysFSInfo;

/* FLASHϢ */
typedef struct _tagSYS_FLASH_HEADER
{
    UINT32 size_total;                                                            /* FLASHܴС */
    UINT32 seg_num;                                                               /* FLASHĶ */
} T_ZCAT_SYSVIEW_FLASH_HEADER;

/* FLASHϢ */
typedef struct _tagSYS_FLASH_SEGMENT
{
    UINT32 seg_address;                                                           /* εַ */
    UINT32 seg_size;                                                              /* δС */
    CHAR seg_name[ZCAT_SYSVIEW_MAX_FLASH_NAME_LEN];                               /* (;) */
} T_ZCAT_SYSVIEW_FLASH_SEGMENT;

typedef struct tag_traceFlashConfig
{
    CHAR name[ZCAT_SYSVIEW_NAME_MAX_LEN];/**/
    UINT32 base;                  /*ʼַ*/
    UINT32 size;                  /*С*/
    struct tag_traceFlashConfig *next; /*һ*/
} T_ZCAT_SYSVIEW_FlashConfig;

typedef struct _tagSYS_FW_INFO
{
    UINT32 freq;                                                                  /* ʱƵ */
    CHAR hw_version[ZCAT_SYSVIEW_MAX_FW_INFO_LEN];                                /* Ӳ汾 */
    CHAR sw_version[ZCAT_SYSVIEW_MAX_FW_INFO_LEN];                                /* 汾 */
    CHAR build_time[ZCAT_SYSVIEW_MAX_FW_INFO_LEN];                                /* 汾ʱ */
} T_ZCAT_SYSVIEW_FW_INFO;

typedef struct _tagTraceImageInfo
{
    UINT32 ro_base; /*RO(CODE,RO DATA)*/
    UINT32 ro_size;
    UINT32 rw_base;  /*RW DATA*/
    UINT32 rw_size;
    UINT32 zi_base; /*ZI(BSS)*/
    UINT32 zi_size;
} T_ZCAT_SYSVIEW_ImageInfo;

typedef struct _tagtraceSysHardwareInfo
{
    UINT32 sys_freq;                                                              /* ʱƵ */
    CHAR hw_version[ZCAT_SYSVIEW_MAX_NAME_LEN];                                   /* Ӳ汾 */
} T_ZCAT_SYSVIEW_SysHardwareInfo;

typedef struct _tagtraceSysSoftwareInfo
{
    /* ʱƵ */
    CHAR   sys_version[ZCAT_SYSVIEW_MAX_NAME_LEN];                                /* 汾 */
    CHAR   build_date[ZCAT_SYSVIEW_MAX_NAME_LEN];                                 /*  */
    CHAR   build_time[ZCAT_SYSVIEW_MAX_NAME_LEN];                                 /* ʱ */
    T_ZCAT_SYSVIEW_ImageInfo image_info;                                          /* binļϢ */
} T_ZCAT_SYSVIEW_SysSoftwareInfo;

/* FLASHϢ */
typedef struct _tagtraceFlashSegment
{
    UINT32 seg_address;                                                           /* εַ */
    UINT32 seg_size;                                                              /* δС */
    CHAR seg_name[ZCAT_SYSVIEW_MAX_FLASH_NAME_LEN];                               /* (;) */
} T_ZCAT_SYSVIEW_FlashSegment;



typedef struct
{
    UINT16 type;
    UINT8  operation;
    UINT8  result;
} T_ZCAT_DIAG_CONFIG_RSP;

typedef struct
{
    UINT32 total_drop_count;
    UINT32 sig_drop_count;
    UINT32 event_drop_count;
    UINT32 print_drop_count;
    UINT32 ipppp_drop_count;
    UINT32 diag_drop_count;
    UINT32 ap_kernel_drop_count;
    UINT32 ap_app_drop_count;

    UINT32 dbg_gsm_phy_drop_count;
    UINT32 dbg_td_phy_drop_count;
    UINT32 dbg_lte_phy_drop_count;
    UINT32 dbg_wcdma_phy_drop_count;
    UINT32 dbg_ps_primary_drop_count;
    UINT32 dbg_ps_exception_drop_count;
} T_ZCAT_DIAG_DROP_COUNT;

typedef struct
{
    UINT8 PsCpuLinkStatus;
    UINT8 PhyCpuLinkStatus;
    UINT16 reserved;
} T_ZCAT_DIAG_UE_LINK_RSP;

typedef struct
{
    union
    {
        struct
        {
            UINT8 PsCpuStatus;
            UINT8 PhyCpuStatus;
            UINT16 reserved;
        } CpuStatus;

        UINT32 Status;
    } CpStatus;

    UINT32 ApStatus;
} T_ZCAT_DIAG_UE_STATUE;

typedef struct
{
    T_ZCAT_HEADER zcatHeader;
    T_ZCAT_DIAG_HEADER diagHeader;
    T_ZCAT_DIAG_UE_LINK_REQ LinkReq;

}T_ZCAT_DIAG_TEST_LINK;

/**************************************************************************
 *                            NVϢṹ                                *
**************************************************************************/
//NVϢͷ
typedef struct
{
    UINT32 nv_OperateType;    //NVID, 0Ϊ1Ϊд,2Ϊ汾
    UINT32 nv_len;   //NAĳ

}T_NVTOOL_HEADER;


typedef struct
{
    BYTE nvType;    // NV, 0Ϊ㣬 1ΪЭջ
    BYTE bitlen;    // bitʱĳ
    BYTE bitstart;  // bit͵ʼλ
    BYTE ret;       // ظıλ
    DWORD wLen;     // ֽڳ
    DWORD dwOffset; // ƫƵַ
}T_NVTOOL_MSG;
typedef struct
{
    UINT32  msgID;
    UINT32  optWord;
    UINT32  length;
} T_AU_HEADER;

typedef struct
{
    unsigned int offset;
    unsigned int length;
} T_AU_ONLINE_DATA_ITEM;

typedef struct
{
    T_AU_ONLINE_DATA_ITEM itemTx;
    T_AU_ONLINE_DATA_ITEM itemRx;
} T_AU_ONLINE_DATA_TABLE;


/************************************************************************/
/*                              ӿԭ                                */
/************************************************************************/
// С


#ifdef __cplusplus
}
#endif

#endif // ZCAT_DIAG_H


