/**************************************************************************
*
*                  Copyright (c) 2012 ZTE Corporation.
*
***************************************************************************
* ģ   : P98C_OSS
*    : oss_irq.h
* ļ : 
* ʵֹ : жģ
*      : chenxingfang
*      : V1.0
*  : 2012-08-10
* ˵ : 
**************************************************************************/

/**************************************************************************
* ޸ļ¼
**************************************************************************/
#ifndef _OSS_IRQ_H
#define _OSS_IRQ_H

/**************************************************************************
* #include
**************************************************************************/
#ifdef _OS_LINUX
#include <linux/irqflags.h>
#endif

#ifdef __cplusplus
extern "C"
{
#endif

/**************************************************************************
* 
**************************************************************************/
#ifdef _OS_TOS
extern long tos_irq_level;
extern long tos_isr_level;
extern long tos_dsr_level;
#endif

#if defined _OS_TOS    
#define TOS_STATISTIC_IRQ
    
#define TOS_TRACE_IRQ
    
#define TOS_DISABLE_IRQ()                               \
        {                                               \
            CYG_INTERRUPT_STATE old_intr;               \
                                                        \
            HAL_DISABLE_INTERRUPTS(old_intr);
    
#define TOS_ENABLE_IRQ()                                \
            HAL_RESTORE_INTERRUPTS(old_intr);           \
        }
    
/* TOS 3.0ϵͳȥʹܡʹܡ桢ָжϷ */
#define TOS_DISABLE_IRQ_FAST()      HAL_DISABLE_INTERRUPTS(old_intr)
#define TOS_ENABLE_IRQ_FAST()       HAL_RESTORE_INTERRUPTS(old_intr)
#define TOS_SAVE_IRQ(old_intr)      HAL_DISABLE_INTERRUPTS(old_intr)
#define TOS_RESTORE_IRQ(old_intr)   HAL_RESTORE_INTERRUPTS(old_intr)
#define TOS_QUERY_IRQ(old_intr)     HAL_QUERY_INTERRUPTS(old_intr)
    
/* ֧ŵȥʹܡʹܡ桢ָжϷҪԲͬĲϵͳƽֲ̨ */
#define ZOSS_INTR                   CYG_INTERRUPT_STATE
#define ZOSS_DISABLE_IRQ()          TOS_DISABLE_IRQ()
#define ZOSS_ENABLE_IRQ()           TOS_ENABLE_IRQ()
#define ZOSS_DISABLE_IRQ_FAST()     TOS_DISABLE_IRQ_FAST()
#define ZOSS_ENABLE_IRQ_FAST()      TOS_ENABLE_IRQ_FAST()
#define ZOSS_SAVE_IRQ(old_intr)     TOS_SAVE_IRQ(old_intr)
#define ZOSS_RESTORE_IRQ(old_intr)  TOS_RESTORE_IRQ(old_intr)
#define ZOSS_QUERY_IRQ(old_intr)    TOS_QUERY_IRQ(old_intr)
    
/* ԭдеȥʹܡʹܡ桢ָжϷ */
#define LOCK_SAVE(old_intr)         ZOSS_SAVE_IRQ(old_intr)
#define LOCK_RESTORE(old_intr)      ZOSS_RESTORE_IRQ(old_intr)
#elif defined _OS_OSE
#define ZOSS_INTR   unsigned long
    
#define ZOSS_DISABLE_IRQ()              \
        {                               \
            unsigned long msr;          \
            LOCK_SAVE(msr);
     
#define ZOSS_ENABLE_IRQ()               \
            LOCK_RESTORE(msr);          \
        }      
    
#define ZOSS_DISABLE_IRQ_FAST()     LOCK_SAVE(old_intr)
#define ZOSS_ENABLE_IRQ_FAST()      LOCK_RESTORE(old_intr)
    
#define ZOSS_SAVE_IRQ(old_intr)     LOCK_SAVE(old_intr)
#define ZOSS_RESTORE_IRQ(old_intr)  LOCK_RESTORE(old_intr)
#elif defined _OS_LINUX
#define LINUX_STATISTIC_IRQ
#define LINUX_TRACE_IRQ
#define LINUX_DISABLE_IRQ()                             \
        {                                               \
            unsigned long flags;                        \
                                                        \
            local_irq_save(flags);
    
#define LINUX_ENABLE_IRQ()                              \
            local_irq_restore(flags);                   \
        }

/* LINUX ϵͳȥʹܡʹܡ桢ָжϷ */
#define LINUX_DISABLE_IRQ_FAST()    local_irq_save(old_intr)
#define LINUX_ENABLE_IRQ_FAST()     local_irq_restore(old_intr)
#define LINUX_SAVE_IRQ(old_intr)    local_irq_save(old_intr)
#define LINUX_RESTORE_IRQ(old_intr) local_irq_restore(old_intr)
#define LINUX_QUERY_IRQ(old_intr)   local_save_flags(old_intr)

/* ֧ŵȥʹܡʹܡ桢ָжϷҪԲͬĲϵͳƽֲ̨ */
#define ZOSS_INTR                   unsigned long
#define ZOSS_DISABLE_IRQ()          LINUX_DISABLE_IRQ()
#define ZOSS_ENABLE_IRQ()           LINUX_ENABLE_IRQ()
#define ZOSS_DISABLE_IRQ_FAST()     LINUX_DISABLE_IRQ_FAST()
#define ZOSS_ENABLE_IRQ_FAST()      LINUX_ENABLE_IRQ_FAST()
#define ZOSS_SAVE_IRQ(old_intr)     LINUX_SAVE_IRQ(old_intr)
#define ZOSS_RESTORE_IRQ(old_intr)  LINUX_RESTORE_IRQ(old_intr)
#define ZOSS_QUERY_IRQ(old_intr)    LINUX_QUERY_IRQ(old_intr)
    
/* ԭдеȥʹܡʹܡ桢ָжϷ */
#define LOCK_SAVE(old_intr)         ZOSS_SAVE_IRQ(old_intr)
#define LOCK_RESTORE(old_intr)      ZOSS_RESTORE_IRQ(old_intr)
#endif

#define zDrv_DisableIrq()           ZOSS_DISABLE_IRQ()
#define zDrv_EnableIrq()            ZOSS_ENABLE_IRQ()

/**************************************************************************
* ݽṹ
**************************************************************************/
#ifdef _OS_TOS
typedef UINT32 tos_isr_t(UINT32 vector, UINT32 data);
typedef VOID tos_dsr_t(UINT32 vector, UINT32 count, UINT32 data);
#elif defined _OS_LINUX
typedef UINT32 linux_isr_t(UINT32 vector, UINT32 data);
typedef VOID linux_dsr_t(UINT32 vector, UINT32 count, UINT32 data);
#endif

/**************************************************************************
* 
**************************************************************************/
#ifdef _OS_TOS
UINT32 tos_default_isr( UINT32 vector, UINT32 data);
#ifdef _USE_OSS_MIN
UINT32 tos_create_irq(UINT32 vector, UINT32 priority, UINT32 data, tos_isr_t isr, tos_dsr_t dsr, cyg_interrupt *interrupt); 
#else
UINT32 tos_create_irq(UINT32 vector, UINT32 priority, UINT32 data, tos_isr_t isr, tos_dsr_t dsr); 
#endif
void tos_delete_irq(UINT32 interrupt_handle);
    
#ifdef TOS_STATISTIC_IRQ
void tos_statistic_irq_open(void);
void tos_statistic_irq_close(void);
void tos_statistic_irq_assert(void);
void tos_statistic_irq_thread_start(void);
void tos_statistic_irq_thread_end(void);
#endif
    
#ifdef TOS_TRACE_IRQ
void tos_trace_irq_open(void);
void tos_trace_irq_close(void);
void tos_trace_irq_assert(void);
#endif
    
static inline SINT32 tos_get_irq_nesting_level(VOID)
{
    return tos_irq_level;
}

static inline SINT32 tos_get_isr_nesting_level(VOID)
{
    return tos_isr_level;
}

static inline SINT32 tos_get_dsr_nesting_level(VOID)
{
    return tos_dsr_level;
}

#ifdef _USE_OSS_MIN
static inline UINT32 tos_create_isr(UINT32 vector,           /* ж         */
                                     UINT32 priority,           /* жȼ       */
                                     UINT32 data,               /* ָ         */
                                     tos_isr_t isr,             /* жϷ     */
                                     cyg_interrupt *interrupt)  /* жϽṹָ   */
{
    return tos_create_irq(vector,       /* ж         */
                           priority,    /* жȼ       */
                           data,        /* ָ         */
                           isr,         /* жϷ     */
                           NULL,        /* жӳٷ */
                           interrupt);  /* жϽṹָ   */
}

static inline UINT32 tos_create_dsr(UINT32 vector,          /* ж         */
                                     UINT32 priority,           /* жȼ       */
                                     UINT32 data,               /* ָ         */
                                     tos_dsr_t dsr,             /* жϷ     */
                                     cyg_interrupt *interrupt)  /* жϽṹָ   */
{
    return tos_create_irq(vector,           /* ж         */
                           priority,        /* жȼ       */
                           data,            /* ָ         */
                           tos_default_isr, /* жϷ     */
                           dsr,             /* жӳٷ */
                           interrupt);      /* жϽṹָ   */
}
#else
static inline UINT32 tos_create_isr(UINT32 vector,      /* ж     */
                                    UINT32 priority,    /* жȼ   */
                                    UINT32 data,        /* ָ     */
                                    tos_isr_t isr)      /* жϷ */
{
    return tos_create_irq(vector, 
                          priority, 
                          data, 
                          isr, 
                          NULL);                        /* жϷ */
}

static inline UINT32 tos_create_dsr(UINT32 vector,      /* ж     */
                                    UINT32 priority,    /* жȼ   */
                                    UINT32 data,        /* ָ     */
                                    tos_dsr_t dsr)      /* жϷ */
{
    return tos_create_irq(vector, 
                          priority, 
                          data, 
                          tos_default_isr,              /* жϷ */
                          dsr);  
}
#endif

static inline VOID tos_delete_isr(UINT32 interrupt_handle)
{
    tos_delete_irq(interrupt_handle);
}

static inline VOID tos_delete_dsr(UINT32 interrupt_handle)
{
    tos_delete_irq(interrupt_handle);
}
#elif defined _OS_LINUX
UINT32 linux_default_isr( UINT32 vector, UINT32 data);

UINT32 linux_create_irq(UINT32 vector, UINT32 priority, UINT32 data, linux_isr_t isr, linux_dsr_t dsr); 

void linux_delete_irq(UINT32 interrupt_handle);

static inline UINT32 linux_create_isr(UINT32 vector,      /* ж     */
                                    UINT32 priority,    /* жȼ   */
                                    UINT32 data,        /* ָ     */
                                    linux_isr_t isr)      /* жϷ */
{
    return 0x00;
}

static inline UINT32 linux_create_dsr(UINT32 vector,      /* ж     */
                                    UINT32 priority,    /* жȼ   */
                                    UINT32 data,        /* ָ     */
                                    linux_dsr_t dsr)      /* жϷ */
{
    return 0x00;
}

static inline VOID linux_delete_isr(UINT32 interrupt_handle)
{
    linux_delete_irq(interrupt_handle);
}

static inline VOID linux_delete_dsr(UINT32 interrupt_handle)
{
    linux_delete_irq(interrupt_handle);
}
#endif

/**************************************************************************
* ȫֱ
**************************************************************************/

#ifdef __cplusplus
}
#endif

#endif  /* _OSS_IRQ_H */


