/**
 * @file oss_kernel.h
 * @brief ϵͳӿͷļ
 *
 * Copyright (C) 2017 Sanechips Technology Co., Ltd.
 * 
 * 
 */

#ifndef _OSS_KERNEL_H
#define _OSS_KERNEL_H

/*******************************************************************************
 *                           Include header files                              *
 ******************************************************************************/
#ifdef __cplusplus
extern "C"
{
#endif

/*******************************************************************************
 *                             Macro definitions                               *
 ******************************************************************************/
/*  */
/**
 * @brief assert
 * @param _EXP Σ쳣ʽ
 */
#ifdef _DEBUG
# if defined _OS_WIN
#  define zOss_ASSERT(_EXP) do {if(!(_EXP)) EXP_Handler(#_EXP, __FILE__, NULL, __LINE__);} while(0)
# else
#  define zOss_ASSERT(_EXP) do {if(!(_EXP)) EXP_Handler(#_EXP, NULL, NULL, __LINE__);} while(0)
# endif
#else
# define zOss_ASSERT(_EXP)
#endif
    
/**
 * @brief ֵassert
 * @param _EXP Σ쳣ʽ
 * @param _RET Σֵ
 */
#define zOss_AssertEx(_EXP, _RET) do {if(!(_EXP)) {zOss_ASSERT((_EXP)); return (_RET);}} while(0)

/**
 * @brief ֵ͸ִвassert
 * @param _EXP Σ쳣ʽ
 * @param _ACT Σִв
 * @param _RET Σֵ
 */
#define zOss_AssertExA(_EXP, _ACT, _RET) do {if(!(_EXP)) {zOss_ASSERT((_EXP)); _ACT; return (_RET);}} while(0)

/**
 * @brief ֵassert
 * @param _EXP Σ쳣ʽ
 */
#define zOss_AssertExN(_EXP) do {if(!(_EXP)) {zOss_ASSERT((_EXP)); return;}} while(0)

/* ÷ֵ */
/**
 * @brief ZOSS_SUCCESS궨
 */
#define ZOSS_SUCCESS            0x0

/**
 * @brief ZOSS_ERROR궨
 */
#define ZOSS_ERROR              0xffffffff

/**
 * @brief ZOSS_NULL궨
 */
#define ZOSS_NULL               NULL        

/**
 * @brief Ч߳ID궨
 */
#define ZOSS_INVALID_THREAD_ID  NULL

/**
 * @brief ЧID궨
 */
#define ZOSS_INVALID_TASK_ID    NULL    

/**
 * @brief ЧʱID궨
 */
#define ZOSS_INVALID_TIMER_ID   NULL

/**
 * @brief ߳󳤶
 */ 
#define MAX_THREADNAME_LEN      63

/**
 * @brief ź󳤶
 */
#define MAX_SEMNAME_LEN         63

/**
 * @brief ź󳤶
 */
#define MAX_MUTEXNAME_LEN       63


/**
 * @brief ȴʱԣȴ
 */
#define ZOSS_NO_WAIT            0x0          

/**
 * @brief ȴʱԣһֱȴȥ
 */
#define ZOSS_WAIT_FOREVER       0xffffffff
    

/**
 * @brief ԣȼȡ
 */
#define ZOSS_INHERIT            0x1

/**
 * @brief ԣ˳ȡ
 */
#define ZOSS_NO_INHERIT         0x0

#ifdef _OS_LINUX
# define ZOSS_PREEMPT_IRQ_THREAD    (0xffffffff)
#endif

/*******************************************************************************
 *                             Type definitions                                *
 ******************************************************************************/
/**
 * @brief źIDͶ
 */
typedef VOID    *ZOSS_SEMAPHORE_ID;

/**
 * @brief IDͶ
 */
typedef VOID    *ZOSS_MUTEX_ID;

/**
 * @brief ʱIDͶ
 */
typedef VOID    *ZOSS_TIMER_ID;

/**
 * @brief ߳IDͶ
 */
typedef VOID    *ZOSS_THREAD_ID;

/**
 * @brief IDͶ
 */
typedef VOID    *ZOSS_TASK_ID;

/**
 * @brief IDͶ
 */
typedef VOID    *ZOSS_QUEUE_ID;

/**
 * @brief ¼IDͶ
 */
typedef VOID    *ZOSS_EVENT_ID;

/**
 * @brief ̺߳Ͷ
 */
typedef VOID    (*ZOSS_THREAD_FUN)(SINT32);

/**
 * @brief ʱصͶ
 */
typedef VOID    (*ZOSS_TIMER_FUN)(SINT32);

/**
 * @brief ̹߳ӺͶ
 */
typedef UINT32  (*THREAD_MSG_HOOK)(UINT32 msg_id, VOID *p_buf, UINT32 buf_size, UINT8 dire);

#ifndef DOXYGEN_SHOULD_SKIP_THIS
/* ̹߳ */
/**
 * @brief ̹߳ṹ
 * @param threadid         ߳id
 * @param threadname       ߳
 * @param runstatus        ߳״̬
 * @param priority         ߳ȼ
 * @param maxstack         ߳ջջʹ
 * @param cpupercent       ߳CPUռ
 * @param stacksize        ̶߳ջС 
 * @param cputime          ߳CPUռʱ 
 * @param topstack         ߳ջַ 
 * @param runtime          ߳ʱ 
 * @param RunTimeInMs      
 * @param msgnum           ߳ϢϢ 
 * @param runcount         ߳д 
 * @param curpath          ̵߳ǰ·osй 
 * @param ptrf             ̵߳ǼǱ 
 * @param curtaskid        ǰID 
 * @param heapsize         ߳ڴС 
 * @param ubsize           ߳ڴشС 
 * @param psmCpuTime       ߳psmʱʱ 
 * @param sleepTimerId     ߳˯ʱĶʱID 
 * @param sleepsem         ߳˯ʱźID 
 */
typedef struct
{
    ZOSS_THREAD_ID    threadid;                           /* ߳ID                   */
    CHAR              threadname[MAX_THREADNAME_LEN + 1]; /* ߳                   */
    UINT8             runstatus;                          /* ߳״̬             */
    UINT8             priority;                           /* ߳ȼ               */
    UINT8             maxstack;                           /* ߳ջջʹ       */
    FLOAT             cpupercent;                         /* ߳CPUռ            */ 
    UINT32            stacksize;                          /* ̶߳ջС             */
    UINT32            cputime;                            /* ߳CPUռʱ        */
    UINT32            topstack;                           /* ߳ջַ             */
    UINT32            runtime;                            /* ߳ʱ             */
    UINT32            RunTimeInMs;
    UINT32            msgnum;                             /* ߳ϢϢ       */
    UINT32            runcount;                           /* ߳д             */
    CHAR              *curpath;                           /* ̵߳ǰ·osй   */
    VOID              *ptrf;                              /* ̵߳ǼǱ           */
    VOID              *curtaskid;                         /* ǰID               */ 
    UINT32            heapsize;                           /* ߳ڴС       */
    UINT32            ubsize;                             /* ߳ڴشС       */
    UINT32            psmCpuTime;                         /* ߳psmʱʱ          */
    ZOSS_TIMER_ID     sleepTimerId;                       /* ߳˯ʱĶʱID */
    ZOSS_SEMAPHORE_ID sleepsem;                           /* ߳˯ʱźID */    
}T_ZOsa_ThreadUserArea;                                   /* ߳ûռ             */
#endif //#ifndef DOXYGEN_SHOULD_SKIP_THIS
/*******************************************************************************
 *                       Global variable declarations                          *
 ******************************************************************************/

/*******************************************************************************
 *                       Global function declarations                          *
 ******************************************************************************/
/* ̹߳ */
 
 /**
 * @brief ȡȼֵӿ
 * @param offset Σȡֵ0~31
 * @return ɹȼֵ򷵻ZOSS_ERROR
 * @retval ȼֵ   ɹ
 * @retval ZOSS_ERROR   ʧ
 * @note
 * @warning 
 */
UINT32 zOss_GetPrioCfg(UINT8 offset);

/**
 * @brief ߳̽ӿ
 * @param thread_name     Σ߳
 * @param entry           Σ߳ʵ庯
 * @param arg             Σ߳ʵ庯Ĳ
 * @param stack_size      Σ߳ӵеĶջС
 * @param priority        Σ̵߳ȵȼ0~31
 * @param preempt         Σͬȼ߳Ƿռ0ֵΪռ̣߳Ϊռִ̣߳ʱƬ
 * @param auto_start      Σ̺߳ǷԶִ
 * @return ɹ߳IDʧܷZOSS_INVALID_THREAD_ID
 * @retval ZOSS_THREAD_ID͵߳id    ɹ
 * @retval ZOSS_INVALID_THREAD_ID        ʧ
 * @note   
 * @warning 
 */
ZOSS_THREAD_ID zOss_CreateThread(const CHAR *thread_name, VOID (*entry)(SINT32), SINT32 arg, UINT32 stack_size, UINT32 priority, UINT32 preempt, UINT32 auto_start);

/**
 * @brief ˳ǰ߳̽ӿ
 * @param void
 * @return void
 * @note   
 * @warning 
 */
VOID zOss_ExitThread(VOID);

/**
 * @brief ̹߳ӿ
 * @param thread_id     ΣҪ߳id
 * @return ɹZOSS_SUCCESSϵͳ
 * @retval ZOSS_SUCCESS ɹ
 * @retval ZOSS_ERROR   ʧ
 * @note   ̵߳ҹ
 * @warning 
 */
UINT32 zOss_SuspendThread(ZOSS_THREAD_ID thread_id);

/**
 * @brief ָ̻߳ӿ
 * @param thread_id     ΣҪָ߳id
 * @return ɹZOSS_SUCCESSϵͳ
 * @retval ZOSS_SUCCESS ɹ
 * @retval ZOSS_ERROR   ʧ
 * @note
 * @warning 
 */
UINT32 zOss_ResumeThread(ZOSS_THREAD_ID thread_id);

/**
 * @brief ߳˯߽ӿ
 * @param time_in_ms     Σ߳̽Ҫ˯ߵʱ䣬λms
 * @return void
 * @note
 * @warning 
 */
VOID zOss_Sleep(UINT32 time_in_ms);

/**
 * @brief ߳ɾӿ
 * @param thread_id     Σɾ߳id
 * @return ɹZOSS_SUCCESSϵͳ
 * @retval ZOSS_SUCCESS ɹ
 * @retval ZOSS_ERROR   ʧ
 * @note   zOss_CreateThread߳ջռ߳̿ƿṹռ
 *         Cyg_Thread::exitͷţΪcyg_thread_deleteִ
 *         дű̵߳Чˡ
 * @warning 
 */
UINT32 zOss_DeleteThread(ZOSS_THREAD_ID thread_id);

/**
 * @brief ȡǰ߳idӿ
 * @param void
 * @return ǰ߳id
 * @note
 * @warning 
 */
ZOSS_THREAD_ID zOss_GetCurThreadID(VOID);

/**
 * @brief ݲṩ߳ƣҸ̵߳߳id
 * @param thread_name     Σ߳
 * @return ҳɹ̵߳Ч߳idϵͳ
 * @note
 * @warning 
 */
ZOSS_THREAD_ID zOss_GetThreadIDByName(const CHAR *thread_name); 

/**
 * @brief ݲṩ߳idȡ̵߳߳
 * @param thread_id     Σȡ߳Ƶ߳id
 * @param thread_name   Σ߳ƴŵַ
 * @return ɹָ߳룻ϵͳԻ򷵻ؿָ
 * @retval ָ߳ ɹ
 * @retval NULL   ʧ
 * @note
 * @warning 
 */
CHAR *zOss_GetThreadName(ZOSS_THREAD_ID thread_id, CHAR *thread_name);

/**
 * @brief ݲṩ߳idȡ̵߳߳Ϣ
 * @param thread_id     Σȡ߳Ϣ߳id
 * @param thread_name   Σ߳ƴŵַ
 * @param stat          Σ߳״̬ŵַ
 * @param priority      Σ߳ȼŵַ
 * @param preempt       Σ߳̿ռŵַ
 * @return ɹZOSS_SUCCESSϵͳ
 * @retval ZOSS_SUCCESS ɹ
 * @retval ZOSS_ERROR   ʧ
 * @note
 * @warning 
 */
UINT32 zOss_GetThreadInfo(ZOSS_THREAD_ID thread_id, CHAR *thread_name, UINT32 *stat, UINT32 *priority, UINT32 *preempt);

/**
 * @brief ݲṩ߳idø̵߳߳ȼ
 * @param thread_id     Σȼ߳id
 * @param priority      Σ߳̽õȼ
 * @return ɹZOSS_SUCCESSϵͳ
 * @retval ZOSS_SUCCESS ɹ
 * @retval ZOSS_ERROR   ʧ
 * @note
 * @warning 
 */
UINT32 zOss_SetThreadPri(ZOSS_THREAD_ID thread_id, UINT32 priority);

/**
 * @brief ݲṩ߳idȡ̵߳߳ȼ
 * @param thread_id     Σȼ߳id
 * @param priority      Σȡ߳ȼŵַ
 * @return ɹZOSS_SUCCESSϵͳ
 * @retval ZOSS_SUCCESS ɹ
 * @retval ZOSS_ERROR   ʧ
 * @note
 * @warning 
 */
UINT32 zOss_GetThreadPri(ZOSS_THREAD_ID thread_id, UINT32 *priority);

/**
 * @brief ֤һ߳ǷЧ
 * @param threadID     Σ֤߳id
 * @return ߳ЧZOSS_SUCCESSϵͳ
 * @retval ZOSS_SUCCESS ɹ
 * @retval ZOSS_ERROR   ʧ
 * @note
 * @warning 
 */
UINT32 zOss_IdentifyThread(ZOSS_THREAD_ID threadID);

/* ߳Ϣģ */
/**
 * @brief ڴϢͷ+ػָ
 * @param size     ΣС
 * @return ָ
 * @note ӿڣϢͷһ룬ظûǰϢͷûʹÿռַ
 * @warning zOss_ThreadRetMsgBufʵ
 */
VOID *zOss_ThreadGetMsgBuf(UINT32 size); 

/**
 * @brief ڴͷϢͷ+
 * @param p_buf     Σָ
 * @return void
 * @note ͷŽӿڻϢͷһͷ
 * @warning zOss_ThreadGetMsgBufʵ
 */
VOID zOss_ThreadRetMsgBuf(VOID *p_buf);

/**
 * @brief thread_id̷߳Ϣ
 * @param msg_id       ΣϢid
 * @param p_buf        Σָ
 * @param buf_size     ΣС
 * @param thread_id    ΣĿ߳id
 * @return ɹZOSS_SUCCESS򷵻ZOSS_ERROR
 * @retval ZOSS_SUCCESS ɹ
 * @retval ZOSS_ERROR   ʧ
 * @note zOss_ThreadRecvMsgʵ
 * @warning 
 */
UINT32 zOss_ThreadSendMsg(UINT32 msg_id, VOID *p_buf, UINT16 buf_size, ZOSS_THREAD_ID thread_id);

/**
 * @brief ߳̽Ϣ
 * @param p_msg_id     ΣϢidĴŵַ
 * @param p_buf        ΣϢָĴŵַ
 * @param p_buf_size   ΣϢСĴŵַ
 * @param timeout      ΣϢĳʱʱ
 * @return ɹZOSS_SUCCESS򷵻ZOSS_ERROR
 * @retval ZOSS_SUCCESS ɹ
 * @retval ZOSS_ERROR   ʧ
 * @note  zOss_ThreadSendMsgʵ
 * @warning 
 */
UINT32 zOss_ThreadRecvMsg(UINT32 *p_msg_id, VOID **p_buf, UINT32 *p_buf_size, UINT32 timeout);

/**
 * @brief ע߳ϢӺ
 * @param thread_id   Σ߳id
 * @param type        ΣӺ
 * @param dire        ΣӺ
 * @param func        ΣӺָ
 * @return ɹZOSS_SUCCESS򷵻ZOSS_ERROR
 * @retval ZOSS_SUCCESS ɹ
 * @retval ZOSS_ERROR   ʧ
 * @note  
 * @warning 
 */
UINT32 zOss_RegThreadMsgHook(ZOSS_THREAD_ID thread_id, UINT8 type, UINT8 dire, THREAD_MSG_HOOK func);

/* ϢͨѶ */

/**
 * @brief ̷ָ߳Ϣ
 * @param thread_id     ΣĿ̵߳߳id
 * @param msg_ptr       ΣϢݵָ
 * @param size          ΣϢĴС
 * @param timeout       ΣϢĳʱʱ
 * @return ɹZOSS_SUCCESS򷵻ZOSS_ERROR
 * @retval ZOSS_SUCCESS ɹ
 * @retval ZOSS_ERROR   ʧ
 * @note  timeoutZOSS_WAIT_FOREVERһֱȴϢͳɹٷأ
          timeoutZOSS_NO_WAITԷϢʧܣֱӷأ
          timeoutǳʱʱ䣬㷽ǽǰϵͳʱtimeoutӣ
                Ϊabs_timeout,ȻһʱֱϢͳɹʱ
 * @warning 
 */
UINT32 zOss_SendMsg(ZOSS_THREAD_ID thread_id, VOID *msg_ptr, UINT32 size, UINT32 timeout);

/**
 * @brief Ϣ
 * @param msg_ptr     ΣϢָĴŵַ
 * @param size        ΣϢݴСĴŵַ
 * @param timeout     ΣϢĳʱʱ
 * @return ɹZOSS_SUCCESS򷵻ZOSS_ERROR
 * @retval ZOSS_SUCCESS ɹ
 * @retval ZOSS_ERROR   ʧ
 * @note  timeoutZOSS_WAIT_FOREVERһֱȴϢͳɹٷأ
          timeoutZOSS_NO_WAITԷϢʧܣֱӷأ
          timeoutǳʱʱ䣬㷽ǽǰϵͳʱtimeoutӣ
                Ϊabs_timeout,ȻһʱֱϢͳɹʱ
 * @warning 
 */
UINT32 zOss_RecvMsg(VOID **msg_ptr, UINT32 *size, UINT32 timeout);

/* ź */
/**
 * @brief ź
 * @param name_ptr        Σź
 * @param initial_count   Σźĳʼֵ
 * @return ɹźľϵͳ
 * @note  
 * @warning 
 */
ZOSS_SEMAPHORE_ID zOss_CreateSemaphore(const CHAR *name_ptr, UINT32 initial_count);

/**
 * @brief ȡź
 * @param sem_id   Σڻȡźid
 * @param timeout  Σʱ
 * @return ɹZOSS_SUCCESS򷵻ZOSS_ERROR
 * @retval ZOSS_SUCCESS ɹ
 * @retval ZOSS_ERROR   ʧ
 * @note  timeoutZOSS_WAIT_FOREVERһֱȴϢͳɹٷأ
                timeoutZOSS_NO_WAITԷϢʧܣֱӷأ
                timeoutǳʱʱ䣬㷽ǽǰϵͳʱtimeoutӣ
                Ϊabs_timeout,ȻһʱֱϢͳɹʱ
 * @warning 
 */
UINT32 zOss_GetSemaphore(ZOSS_SEMAPHORE_ID sem_id, UINT32 timeout);

/**
 * @brief ͷź
 * @param sem_id   Σͷŵźid
 * @return ɹZOSS_SUCCESSϵͳ
 * @retval ZOSS_SUCCESS ɹ
 * @retval ZOSS_ERROR   ʧ
 * @note  
 * @warning 
 */
UINT32 zOss_PutSemaphore(ZOSS_SEMAPHORE_ID sem_id);

/**
 * @brief ȡźĵǰֵ
 * @param sem_id   Σڱȡֵźid
 * @return źĵǰֵ
 * @note  
 * @warning 
 */
UINT32 zOss_GetSemaphoreCount(ZOSS_SEMAPHORE_ID sem_id);

/**
 * @brief ɾź
 * @param sem_id   Σɾźid
 * @return ɹZOSS_SUCCESSϵͳ
 * @retval ZOSS_SUCCESS ɹ
 * @retval ZOSS_ERROR   ʧ
 * @note  
 * @warning 
 */
UINT32 zOss_DeleteSemaphore(ZOSS_SEMAPHORE_ID sem_id);

/* ź */
/**
 * @brief 
 * @param name_ptr          Σ
 * @param priority_inherit  ΣԣZOSS_INHERIT֮߳䰴
                ȼ˳ȡ壻ZOSS_NO_INHERIT򰴵ȴ˳ȡ
                
 * @return ɹشĻϵͳ
 * @note 
 * @warning 
 */
ZOSS_MUTEX_ID zOss_CreateMutex(const CHAR *name_ptr, UINT32 priority_inherit);

/**
 * @brief ȡ
 * @param mutex_id   ΣȡĻid
 * @param timeout    Σȡĳʱʱ
 * @return ɹZOSS_SUCCESS򷵻ZOSS_ERROR
 * @retval ZOSS_SUCCESS ɹ
 * @retval ZOSS_ERROR   ʧ
 * @note  
 * @warning 
 */
UINT32 zOss_GetMutex(ZOSS_MUTEX_ID mutex_id, UINT32 timeout);

/**
 * @brief ͷŻ
 * @param mutex_id   ΣͷŵĻid
 * @return ɹZOSS_SUCCESSϵͳ
 * @retval ZOSS_SUCCESS ɹ
 * @retval ZOSS_ERROR   ʧ
 * @note 
 * @warning 
 */
UINT32 zOss_PutMutex(ZOSS_MUTEX_ID mutex_id);

/**
 * @brief ٻ
 * @param mutex_id   ΣٵĻid
 * @return ɹZOSS_SUCCESSϵͳ
 * @retval ZOSS_SUCCESS ɹ
 * @retval ZOSS_ERROR   ʧ
 * @note  
 * @warning 
 */
UINT32 zOss_DeleteMutex(ZOSS_MUTEX_ID mutex_id);

/* ʱ */
/**
 * @brief ȡϵͳĵǰδ
 * @param void 
 * @return زϵͳĵǰδ
 * @retval δ
 * @note  
 * @warning 
 */
UINT32 zOss_GetTickCount(VOID);

#ifndef DOXYGEN_SHOULD_SKIP_THIS
/* CPUʹͳ */
UINT8 zOss_GetCPU(VOID);

/* 쳣 */
VOID EXP_Handler(const CHAR *pExp, const CHAR *pcFileName, const CHAR *pcFuncName, SINT32 dwLineNum);

#endif //#ifndef DOXYGEN_SHOULD_SKIP_THIS
/*******************************************************************************
 *                      Inline function implementations                        *
 ******************************************************************************/

#ifdef __cplusplus
}
#endif

#endif  // #ifndef _OSS_KERNEL_H

