/*******************************************************************************
* Ȩ (C)2012, ͨѶɷ޹˾
* 
* ļ:     oss_monitor.h
* ļʶ:     oss_monitor.h
* ժҪ:     ֧Ųģͷļeleʾelement
* ʹ÷:     #include "oss_monitor.h"
* 
* ޸        汾      ޸ı        ޸          ޸
* ------------------------------------------------------------------------------
* 2012/09/20      V1.0        Create                    
* 
*******************************************************************************/

#ifndef _OSS_MONITOR_H
#define _OSS_MONITOR_H

/*******************************************************************************
*                                   ͷļ                                     *
*******************************************************************************/

#ifdef __cplusplus
extern "C" {
#endif

/*******************************************************************************
*                                   궨                                     *
*******************************************************************************/
#define OSS_MON_PERCENT_RADIO           100    

/*Ϣֵ*/
#define OSS_MON_INFO_MAX_NUMBER         (0x64)

/*߳״̬ */
#define OSS_MON_THREAD_RUNNING          (0x01)
#define OSS_MON_THREAD_READY            (0x02)
#define OSS_MON_THREAD_WAITING          (0x04)

/*״̬ */
#define OSS_MON_TASK_STOPPED            (0x01)
#define OSS_MON_TASK_IDLE               (0x02)
#define OSS_MON_TASK_READY              (0x03)
#define OSS_MON_TASK_RUN                (0x04)

/*̺߳DSRĹ켣 */
#define OSS_MON_EVENT_THREAD_SWAPIN     (0x00) 
#define OSS_MON_EVENT_THREAD_SWAPOUT    (0x01)
#define OSS_MON_EVENT_DSR_SWAPIN        (0x02)
#define OSS_MON_EVENT_DSR_SWAPOUT       (0x03)

/*MMU*/
#define OSS_MON_MMU_PERMISSION_RW       (0x01)
#define OSS_MON_MMU_PERMISSION_RO       (0x02)
#define OSS_MON_MMU_ACCESS_WRITEBACK    (0x04)
#define OSS_MON_MMU_ACCESS_WRITETHROUGH (0x08)

/*ؿر־*/
#define OSS_MON_FLAG_OFF                (0x0)
#define OSS_MON_FLAG_ON                 (0x1)

/*Ϣ*/
#define OSS_MON_INVALID                 (-1)
#define OSS_MON_BASE                    (0x00)
#define OSS_MON_VERSION                 (OSS_MON_BASE + 0)
#define OSS_MON_CPU_FREQUENCY           (OSS_MON_BASE + 1)
#define OSS_MON_CPU_LOAD                (OSS_MON_BASE + 2)
#define OSS_MON_POOL                    (OSS_MON_BASE + 3)
#define OSS_MON_POOL_ALLOC              (OSS_MON_BASE + 4)
#define OSS_MON_POOL_LEAK               (OSS_MON_BASE + 5)
#define OSS_MON_HEAP                    (OSS_MON_BASE + 6)
#define OSS_MON_THREAD                  (OSS_MON_BASE + 7)
#define OSS_MON_TASK                    (OSS_MON_BASE + 8)
#define OSS_MON_EVENT                   (OSS_MON_BASE + 9)
#define OSS_MON_MSG                     (OSS_MON_BASE + 10)
#define OSS_MON_RAMLOG                  (OSS_MON_BASE + 11)
#define OSS_MON_GET_VAR_REQ             (OSS_MON_BASE + 12)
#define OSS_MON_GET_VAR_ACK             (OSS_MON_BASE + 13)
#define OSS_MON_SET_VAR                 (OSS_MON_BASE + 14)
#define OSS_MON_TIMER                   (OSS_MON_BASE + 15)
#define OSS_MON_MMU                     (OSS_MON_BASE + 16)
#define OSS_MON_SET_FLAG                (OSS_MON_BASE + 17)

/*******************************************************************************
*                                Ͷ                                  *
*******************************************************************************/
/*ذ汾*/
typedef struct
{
    const CHAR *version;
} T_ZOss_Mon_Version;

/*cpu Ƶ*/
typedef struct
{
    UINT16  frequency;
} T_ZOss_Mon_Cpu_Frequency;

/*cpu  (load/100)*/
typedef struct
{
    UINT16  load;
} T_ZOss_Mon_Cpu_Load;

/*pool Ϣ*/
typedef struct
{
    UINT32  size;
    UINT32  total;
    UINT32  used;
    UINT32  max_used;
} T_ZOss_Mon_Pool_Ele;

typedef struct
{
    UINT32  num;
    T_ZOss_Mon_Pool_Ele *ele;
} T_ZOss_Mon_Pool;

/*pool alloc Ϣ*/
typedef struct
{
    UINT32      addr;
    UINT32      owner;
    UINT32      timestamp;
    const CHAR *file;
    UINT32      line;
} T_ZOss_Mon_Pool_Alloc_Ele;

typedef struct
{
    UINT32  num;
    T_ZOss_Mon_Pool_Alloc_Ele *ele;
} T_ZOss_Mon_Pool_Alloc;

/*pool leak Ϣ*/
typedef struct
{
    UINT32      addr;
    UINT32      owner;
    UINT32      timestamp;
    const CHAR  *file;
    UINT32      line;
} T_ZOss_Mon_Pool_Leak_Ele;

typedef struct
{
    UINT32  num;
    T_ZOss_Mon_Pool_Leak_Ele *ele;
} T_ZOss_Mon_Pool_Leak;

/*heap Ϣ*/
typedef struct
{
    UINT32  base;
    UINT32  size;
    UINT32  used;
} T_ZOss_Mon_Heap;

/*߳Ϣ*/
typedef struct
{
    CHAR    *name;
    UINT32  handle;
    UINT32  msg_num;
    UINT8   status;
    UINT8   priority;
    UINT16  stack_used;
    UINT16  stack_max_used;
    UINT16  cpu_load;
} T_ZOss_Mon_Thread_Ele;

typedef struct
{
    unsigned int num;
    T_ZOss_Mon_Thread_Ele *ele;
} T_ZOss_Mon_Thread;

/*Ϣ*/
typedef struct
{
    CHAR    *name;
    UINT32  handle;
    UINT32  thread_handle;
    UINT8   status;
} T_ZOss_Mon_Task_Ele;

typedef struct
{
    UINT32  num;
    T_ZOss_Mon_Task_Ele *ele;
} T_ZOss_Mon_Task;

/*̺߳жϹ켣Ϣ*/
typedef struct
{
    UINT8   event;
    CHAR    *name;
    UINT32  handle;
    UINT64  tickstamp;
} T_ZOss_Mon_Event_Ele;

typedef struct
{
    UINT32  num;
    T_ZOss_Mon_Event_Ele *ele;
} T_ZOss_Mon_Event;

/*ϢշϢ*/
typedef struct
{   
    UINT32  msgId;
    UINT32  ptr;
    UINT32  size;
    CHAR    *sender;
    CHAR    *receiver;
    UINT32  timestamp;
} T_ZOss_Mon_Msg_Ele;

typedef struct
{
    UINT32  num;
    T_ZOss_Mon_Msg_Ele  *ele;
} T_ZOss_Mon_Msg;

/*ramlog Ϣ*/
typedef struct
{   
    UINT32  size;
    const CHAR *ramlog;
} T_ZOss_Mon_Ramlog;

/*ȡ*/
typedef struct
{
    UINT32  base;
    UINT32  size;
} T_ZOss_Mon_Get_Var_Req;

/*ȡȷϢ*/
typedef struct
{
    UINT32  size;
    UINT8   *value;
} T_ZOss_Mon_Get_Var_Ack;

/*ñ*/
typedef struct
{
    UINT32  base;
    UINT32  size;
    UINT8   *value;
} T_ZOss_Mon_Set_Var;

/*ʱϢ*/
typedef struct
{
    UINT32  start_time;
    UINT32  expire_time;
    UINT32  callback_func;
    UINT8   is_period;
    UINT32  handle;
} T_ZOss_Mon_Timer_Ele;

typedef struct
{
    UINT32  num;
    T_ZOss_Mon_Timer_Ele *ele;
} T_ZOss_Mon_Timer;

/*MMU Ϣ*/
typedef struct
{
    CHAR    *name;
    UINT32  vir_addr;
    UINT32  phy_addr;
    UINT32  size;
    UINT8   attr; /* permission and access */
} T_ZOss_Mon_Mmu_Ele;

typedef struct
{
    UINT32  num;
    T_ZOss_Mon_Mmu_Ele *ele;
} T_ZOss_Mon_Mmu;

/*MPU Ϣ*/
typedef struct
{
    CHAR   *name;
    UINT32 num;
    UINT32 base;
    UINT32 size;
    UINT32 attr;
    UINT32 subRegion;
} T_ZOss_Mon_Mpu_Ele;

typedef struct
{
    UINT32  num;
    T_ZOss_Mon_Mpu_Ele *ele;
} T_ZOss_Mon_Mpu;

typedef struct
{
    UINT32  flag;
} T_ZOss_Mon_Set_Flag;

/*******************************************************************************
*                                ȫֱ                                  *
*******************************************************************************/
#ifdef _USE_MONITOR
extern UINT32   gOsa_MonitorFlag;
#endif

/*******************************************************************************
*                                ȫֺ                                  *
*******************************************************************************/
/* TOSģ */
VOID zTos_GetMmuConfigTable(T_ZOss_Mon_Mmu *pMonMmuInfo);
VOID pool_used_info(T_ZOss_Mon_Pool *pMonPoolInfo);
VOID pool_alloc_info(T_ZOss_Mon_Pool_Alloc *pMonPoolAllocInfo);
VOID pool_leak_info(T_ZOss_Mon_Pool_Leak *pMonPoolLeakInfo);
VOID z0ss_GetMsgInfo(T_ZOss_Mon_Msg *pMonMsgInfo);
VOID z0ss_GetEventInfo(T_ZOss_Mon_Event *pMonEventInfo);
VOID zOss_GetAllTaskInfo(T_ZOss_Mon_Task *pMonTaskInfo);
VOID z0ss_GetAllThreadInfo(T_ZOss_Mon_Thread *pMonThreadInfo);
VOID zOss_GetTimerInfo(T_ZOss_Mon_Timer *pMonTimerInfo);
VOID z0ss_GetRamlogInfo(T_ZOss_Mon_Ramlog *pMonRamlogInfo);
VOID z0ss_GetHeapInfo(T_ZOss_Mon_Heap *pMonHeapInfo);

#ifdef __cplusplus
}
#endif

#endif // #ifndef _OSS_MONITOR_H

