/*******************************************************************************
* Ȩ (C)2014, ͨѶɷ޹˾
* 
* ļ:     oss_pool.h
* ļʶ:     oss_pool.h
* ժҪ:     oss֧Ųڴعģͷļ
* ʹ÷:     #include "oss_api.h"
* 
* ޸        汾      ޸ı        ޸          ޸
* ------------------------------------------------------------------------------
* 2014/08/25      V1.0        Create                    
* 
*******************************************************************************/

#ifndef _OSS_POOL_H
#define _OSS_POOL_H

/*******************************************************************************
*                                   ͷļ                                     *
*******************************************************************************/

/*******************************************************************************
*                                   궨                                     *
*******************************************************************************/
#if defined(_DEBUG) && !defined(_USE_OSS_MIN)
# define POOL_DEBUG
# define POOL_LEAK_CHECK
# define POOL_INIT_CHECK
#endif

#ifdef POOL_DEBUG
# define palloc(size)           pool_alloc(size, __FILE__, __LINE__)
# define pfree(ptr)             pool_free(ptr, __FILE__, __LINE__)
# define prealloc(ptr, size)    pool_realloc(ptr, size, __FILE__, __LINE__)
# define psize(ptr)             pool_node_size(ptr, __FILE__, __LINE__)
#else
# define palloc(size)           pool_alloc(size, NULL, 0x00)
# define pfree(ptr)             pool_free(ptr, NULL, 0x00)
# define prealloc(ptr, size)    pool_realloc(ptr, size, NULL, 0x00)
# define psize(ptr)             pool_node_size(ptr, NULL, 0x00)
#endif

#define POOL_INDEX_0_NUM    (4096)    /* the number of index 0 pool node  */
#define POOL_INDEX_0_SIZE   (4)       /* the size of index 0 pool node    */

#define POOL_INDEX_1_NUM    (4096)    /* the number of index 1 pool node  */
#define POOL_INDEX_1_SIZE   (8)       /* the size of index 1 pool node    */

#define POOL_INDEX_2_NUM    (256)     /* the number of index 2 pool node  */
#define POOL_INDEX_2_SIZE   (16)      /* the size of index 2 pool node    */

#define POOL_INDEX_3_NUM    (2048)    /* the number of index 3 pool node  */
#define POOL_INDEX_3_SIZE   (32)      /* the size of index 3 pool node    */

#define POOL_INDEX_4_NUM    (3072)    /* the number of index 4 pool node  */
#define POOL_INDEX_4_SIZE   (64)      /* the size of index 4 pool node    */

#define POOL_INDEX_5_NUM    (512)     /* the number of index 5 pool node  */
#define POOL_INDEX_5_SIZE   (128)     /* the size of index 5 pool node    */

#define POOL_INDEX_6_NUM    (512)     /* the number of index 6 pool node  */
#define POOL_INDEX_6_SIZE   (256)     /* the size of index 6 pool node    */

#define POOL_INDEX_7_NUM    (300)     /* the number of index 7 pool node  */
#define POOL_INDEX_7_SIZE   (512)     /* the size of index 7 pool node    */

#define POOL_INDEX_8_NUM    (300)     /* the number of index 8 pool node  */
#define POOL_INDEX_8_SIZE   (1024)    /* the size of index 8 pool node    */

#define POOL_INDEX_9_NUM    (100)     /* the number of index 9 pool node  */
#define POOL_INDEX_9_SIZE   (2048)    /* the size of index 9 pool node    */

#define POOL_INDEX_10_NUM   (21)      /* the number of index 10 pool node */
#define POOL_INDEX_10_SIZE  (4096)    /* the size of index 10 pool node   */

#define POOL_INDEX_11_NUM   (60)      /* the number of index 11 pool node */
#define POOL_INDEX_11_SIZE  (8192)    /* the size of index 11 pool node   */

#define POOL_INDEX_12_NUM   (15)      /* the number of index 12 pool node */
#define POOL_INDEX_12_SIZE  (16384)   /* the size of index 12 pool node   */

#define POOL_INDEX_13_NUM   (5)       /* the number of index 13 pool node */
#define POOL_INDEX_13_SIZE  (32768)   /* the size of index 13 pool node   */

#define POOL_INDEX_14_NUM   (5)       /* the number of index 14 pool node */
#define POOL_INDEX_14_SIZE  (65536)   /* the size of index 14 pool node   */

#define POOL_INDEX_15_NUM   (1)       /* the number of index 15 pool node */
#define POOL_INDEX_15_SIZE  (131072)  /* the size of index 15 pool node   */

#define POOL_LEAK_CHECK_TIMEOUT     (100)

#define POOL_ALLOC_STATISTIC_NUM    (8)

#define POOL_MBOX_ITEM_COUNT        (3000)  /* the total available items(msgs) for system */


/*******************************************************************************
*                                Ͷ                                  *
*******************************************************************************/

/*******************************************************************************
*                                ȫֱ                                  *
*******************************************************************************/

/*******************************************************************************
*                                ȫֺ                                  *
*******************************************************************************/
void pool_init(void);
__tcm_call_func void *pool_alloc(unsigned long size, const char *file, unsigned long line);
__tcm_call_func void pool_free(void *ptr, const char *file, unsigned long line);
void *pool_realloc(void *old_ptr, unsigned long new_size, const char *file, unsigned long line);
unsigned long pool_node_size(void *ptr, const char *file, unsigned long line);
void pool_print_leak(unsigned long timeout);
void pool_print_alloc_fail(void);
void pool_print_alloc_statistic(void);
void pool_print_free(void);
void pool_trace_leak_start(void);
void pool_trace_leak_end(unsigned long timeout);

#endif  // #ifndef _OSS_POOL_H

