#ifndef _MY_HEADER_H_
#define _MY_HEADER_H_

/*
 * Passing NETID_UNSET as the netId causes system/netd/server/DnsProxyListener.cpp to
 * fill in the appropriate default netId for the query.
 */
#define NETID_UNSET 0u

/*
 * MARK_UNSET represents the default (i.e. unset) value for a socket mark.
 */
#define MARK_UNSET 0u


/*
 * Definition of type and code field values.
 *	http://www.iana.org/assignments/icmp-parameters
 */
#define	ICMP_ECHOREPLY	0		/* echo reply */
#define	ICMP_UNREACH	3		/* dest unreachable, codes: */
#define	ICMP_UNREACH_NET		0	/* bad net */
#define	ICMP_UNREACH_HOST		1	/* bad host */
#define	ICMP_UNREACH_PROTOCOL	2	/* bad protocol */
#define	ICMP_UNREACH_PORT		3	/* bad port */
#define	ICMP_UNREACH_NEEDFRAG	4	/* IP_DF caused drop */
#define	ICMP_UNREACH_NET_PROHIB		9	/* for crypto devs */
#define	ICMP_UNREACH_HOST_PROHIB	10	/* ditto */
#define	ICMP_UNREACH_FILTER_PROHIB	13	/* prohibited access */
#define	ICMP_UNREACH_PRECEDENCE_CUTOFF	15	/* precedence cutoff */
#define	ICMP_SOURCEQUENCH	4		/* packet lost, slow down */
#define	ICMP_ECHO		   8		/* echo service */
#define NETID_USE_LOCAL_NAMESERVERS 0x80000000

#if 0
struct ucred {
  pid_t pid;
  uid_t uid;
  gid_t gid;
};
#endif

#define AID_VPN  1016         /* vpn system */
#define AID_CLAT 1029         /* clat part of nat464 */
#define AID_INET 3003         /* can create AF_INET and AF_INET6 sockets */

#endif

