#include "cwmp/model.h"
#include "data_model.h"
#include "cwmp_module.h"
#include "InternetGatewayDevice/InternetGatewayDevice.c"


model_func_t ModelFunction[] =
{
    //InternetGatewayDevice.DeviceInfo.
    {"get_igd_di_manufacturer", cpe_get_igd_di_manufacturer},
    {"get_igd_di_manufactureroui", cpe_get_igd_di_manufactureroui},
    {"get_igd_di_productclass", cpe_get_igd_di_productclass},
    {"get_igd_di_serialnumber", cpe_get_igd_di_serialnumber},
    {"get_igd_di_specversion", cpe_get_igd_di_specversion},
    {"get_igd_di_hardwareversion", cpe_get_igd_di_hardwareversion},
    {"get_igd_di_softwareversion", cpe_get_igd_di_softwareversion},
    {"get_igd_di_provisioningcode", cpe_get_igd_di_provisioningcode},
    {"set_igd_di_softwareversion", cpe_set_igd_di_softwareversion},
    {"set_igd_di_hardwareversion", cpe_set_igd_di_hardwareversion},	

    //InternetGatewayDevice.DeviceInfo.VendorConfigFile.	
    {"get_igd_di_vc_name", cpe_get_igd_di_vc_name},
    {"get_igd_di_vc_version", cpe_get_igd_di_vc_version},
    {"get_igd_di_vc_date", cpe_get_igd_di_vc_date},
    {"get_igd_di_vc_description", cpe_get_igd_di_vc_description},    

    //InternetGatewayDevice.ManagementServer.
    {"get_igd_ms_username", cpe_get_igd_ms_username},
    {"set_igd_ms_username", cpe_set_igd_ms_username},    
    {"get_igd_ms_password", cpe_get_igd_ms_password},
    {"set_igd_ms_password", cpe_set_igd_ms_password},   
    {"get_igd_ms_url", cpe_get_igd_ms_url},
    {"set_igd_ms_url", cpe_set_igd_ms_url},    
    {"get_igd_ms_connectionrequesturl", cpe_get_igd_ms_connectionrequesturl},
    {"get_igd_ms_connectionrequestusername", cpe_get_igd_ms_connectionrequestusername},
    {"set_igd_ms_connectionrequestusername", cpe_set_igd_ms_connectionrequestusername},    
    {"get_igd_ms_connectionrequestpassword", cpe_get_igd_ms_connectionrequestpassword},
    {"set_igd_ms_connectionrequestpassword", cpe_set_igd_ms_connectionrequestpassword},
    {"get_igd_ms_STUNEnable", cpe_get_igd_ms_STUNEnable},
    {"set_igd_ms_STUNEnable", cpe_set_igd_ms_STUNEnable},
    {"get_igd_ms_parameterkey", cpe_get_igd_ms_parameterkey},
    {"set_igd_ms_parameterkey", cpe_set_igd_ms_parameterkey},  
    {"get_igd_ms_stunserveraddress", cpe_get_igd_ms_stunserveraddress},
    {"set_igd_ms_stunserveraddress", cpe_set_igd_ms_stunserveraddress},
    {"get_igd_ms_stunserverport", cpe_get_igd_ms_stunserverport},
    {"set_igd_ms_stunserverport", cpe_set_igd_ms_stunserverport},
    {"get_igd_ms_stunusername", cpe_get_igd_ms_stunusername},
    {"set_igd_ms_stunusername", cpe_set_igd_ms_stunusername},
    {"get_igd_ms_stunpassword", cpe_get_igd_ms_stunpassword},
    {"set_igd_ms_stunpassword", cpe_set_igd_ms_stunpassword},
	{"get_igd_ms_stunmaximumkeepaliveperiod", cpe_get_igd_ms_stunmaximumkeepaliveperiod},
	{"set_igd_ms_stunmaximumkeepaliveperiod", cpe_set_igd_ms_stunmaximumkeepaliveperiod},
	{"get_igd_ms_stunminimumkeepaliveperiod", cpe_get_igd_ms_stunminimumkeepaliveperiod},
	{"set_igd_ms_stunminimumkeepaliveperiod", cpe_set_igd_ms_stunminimumkeepaliveperiod},
	{"get_igd_ms_natdetected", cpe_get_igd_ms_natdetected},
	{"set_igd_ms_natdetected", cpe_set_igd_ms_natdetected},
    {"get_igd_ms_PeriodicInformEnable", cpe_get_igd_ms_PeriodicInformEnable},
    {"set_igd_ms_PeriodicInformEnable", cpe_set_igd_ms_PeriodicInformEnable},
    {"get_igd_ms_PeriodicInformInterval", cpe_get_igd_ms_PeriodicInformInterval},
    {"set_igd_ms_PeriodicInformInterval", cpe_set_igd_ms_PeriodicInformInterval},	    

    {"add_igd_wanpppconnection", cpe_add_igd_wanpppconnection},
    
    {"del_igd_wanconnectiondevice", cpe_del_igd_wanconnectiondevice},

	{"refresh_igd_landevice", cpe_refresh_igd_landevice},

	//InternetGatewayDevice.Time
	{"get_igd_time_ntpserver0", cpe_get_igd_time_ntpserver0},
    {"get_igd_time_ntpserver1", cpe_get_igd_time_ntpserver1},
    {"get_igd_time_ntpserver2", cpe_get_igd_time_ntpserver2},
    {"set_igd_time_ntpserver0", cpe_set_igd_time_ntpserver0},
    {"set_igd_time_ntpserver1", cpe_set_igd_time_ntpserver1},
    {"set_igd_time_ntpserver2", cpe_set_igd_time_ntpserver2},    
    {"get_igd_time_currentlocaltime", cpe_get_igd_time_currentlocaltime},
    {"get_igd_time_localtimezone", cpe_get_igd_time_localtimezone},
    {"get_igd_time_localtimezonename", cpe_get_igd_time_localtimezonename},

	//InternetGatewayDevice.WANDevice
	{"refresh_igd_wandevice", cpe_refresh_igd_wandevice},

	//InternetGatewayDevice.WANDevice.WANConnectionDevice
    {"refresh_igd_wd_wanconnectiondevice", cpe_refresh_igd_wd_wanconnectiondevice},

	//InternetGatewayDevice.WANDevice.WANConnectionDevice.WANIPConnection
    {"refresh_igd_wd_wcd_wanipconnection", cpe_refresh_igd_wd_wcd_wanipconnection},
	{"get_igd_wd_wcd_wic_enable", cpe_get_igd_wd_wcd_wic_enable},
    {"get_igd_wd_wcd_wic_rsrp", cpe_get_igd_wd_wcd_wic_rsrp},
	{"get_igd_wd_wcd_wic_rssi", cpe_get_igd_wd_wcd_wic_rssi},

    //InternetGatewayDevice.WANDevice.COM_WANInterfaceConfig
    {"refresh_igd_wd_comwaninterfaceconfig", cpe_refresh_igd_wd_comwaninterfaceconfig},

	//InternetGatewayDevice.WANDevice.WANEthernetInterfaceConfig
    {"refresh_igd_wd_wanetherinterfaceconfig", cpe_refresh_igd_wd_wanetherinterfaceconfig},

    //InternetGatewayDevice.LANDevice
    {"refresh_igd_landevice", cpe_refresh_igd_landevice},

	//InternetGatewayDevice.LANDevice.LANHostConfigManagement.IPInterface
    {"refresh_igd_ld_lhcm_ipinterface", cpe_refresh_igd_ld_lhcm_ipinterface},

	{"get_igd_ld_lhcm_ipinterfaceipaddress", cpe_get_igd_ld_lhcm_ipinterfaceipaddress},
    {"set_igd_ld_lhcm_ipinterfaceipaddress", cpe_set_igd_ld_lhcm_ipinterfaceipaddress},
    {"get_igd_ld_lhcm_ipinterfacesubnetMask", cpe_get_igd_ld_lhcm_ipinterfacesubnetMask},
    {"set_igd_ld_lhcm_ipinterfacesubnetMask", cpe_set_igd_ld_lhcm_ipinterfacesubnetMask},

    //InternetGatewayDevice.LANDevice.LANHostConfigManagement.DHCPStaticAddress
    {"refresh_igd_ld_lhcm_dhcpstaticaddress", cpe_refresh_igd_ld_lhcm_dhcpstaticaddress},
    
    //InternetGatewayDevice.LANDevice.LANEthernetInterfaceConfig
    {"refresh_igd_ld_lanethernetinterfaceconfig", cpe_refresh_igd_ld_lanethernetinterfaceconfig},

	//InternetGatewayDevice.LANDevice.WLANConfiguration
    {"refresh_igd_ld_wlanconfiguration", cpe_refresh_igd_ld_wlanconfiguration},	

	{"get_igd_ld_wc_ssid", cpe_get_igd_ld_wc_ssid},

    //InternetGatewayDevice.LANDevice.WLANConfiguration.WEPKey
    {"refresh_igd_ld_wc_wepkey", cpe_refresh_igd_ld_wc_wepkey},

    //InternetGatewayDevice.LANDevice.WLANConfiguration.PreSharedKey
    {"refresh_igd_ld_wc_presharekey", cpe_refresh_igd_ld_wc_presharekey},
};

int get_index_after_paramname(parameter_node_t * param, const char * tag_name)
{
    parameter_node_t * parent;
    parameter_node_t * tmp;
    for(parent=param->parent, tmp = param; parent; tmp = parent, parent = parent->parent)
    {
        if(TRstrcmp(parent->name, tag_name) == 0)
        {
             if(is_digit(tmp->name) == 0)
             {
                return TRatoi(tmp->name);   
             }
        }        
    }
    return -1;
}


void cwmp_model_load(cwmp_t * cwmp, const char * xmlfile)
{  

    cwmp_model_load_xml(cwmp, xmlfile, ModelFunction, sizeof(ModelFunction)/sizeof(model_func_t));
}


