/**
* @file Wifi_msg.h
* @brief ṩwifiõϢӿ
*
* Copyright (C) 2017 Sanechips Technology Co., Ltd.
* @author Linxu Gebin
*
* This program is free software; you can redistribute it and/or modify
* it under the terms of the GNU General Public License version 2 as
* published by the Free Software Foundation.
*
************************************************************************
*/

#ifndef __WIFI_MSG_H__
#define __WIFI_MSG_H__

#include "message.h"
#include "wifi.h"


/**
* @brief wifiϢ
 * @param MSG_CMD_WIFI_BASE ssidĻϢ
 * @param MSG_CMD_WIFI_SSID_M øssidĻϢ
 * @param MSG_CMD_WIFI_CLOSE رwifiϢ
 * @param MSG_CMD_WIFI_OPEN wifiϢ
 * @param MSG_CMD_WIFI_RESTART wifiϢ
 * @param MSG_CMD_WIFI_ADVANCED wifiĸ߼Ϣ
 * @param MSG_CMD_WIFI_WPS WPSϢ
 * @param MSG_CMD_WIFI_WPS_UP WPSģ鷢WPSϢ
 * @param MSG_CMD_WIFI_WPS_DOWN WPSģ鷢WPS رϢ
 * @param MSG_CMD_WIFI_SLEEP WEBUI˯ʱϢ
 * @param MSG_CMD_CAPTURE_STATION ѯstaϢ
 * @param MSG_CMD_WIFI_COVERAGE wifiĸǷΧϢ
 * @param MSG_CMD_WIFI_MAC mac˹Ϣ
 * @param MSG_CMD_USB_CHARGING_CHANGED ⵽usb״̬仯ϱϢ
 * @param MSG_CMD_WIFI_STATION_OPEN apstaϢ
 * @param MSG_CMD_WIFI_STATION_CLOSE رapstaϢ
 * @param MSG_CMD_WIFI_STATION_CLOSE_OPEN_MSSID apstaرնssidϢ
 * @param MSG_CMD_WIFI_STATION_SCAN ɨȵϢ
 * @param MSG_CMD_WIFI_STATION_CONNECT ȵϢ
 * @param MSG_CMD_WIFI_STATION_CONNECT_TIMEOUT ӳʱĴϢ
 * @param MSG_CMD_WIFI_STATION_SIM_INIT_TIMER_PROCESS ѯsimõĶʱϢ
 * @param MSG_CMD_WIFI_STATION_GET_SCAN_RESULTS_TIMER_PROCESS wpa_supplicantɨϢ
 * @param MSG_CMD_WIFI_STATION_DISCONNECT ϿӵȵϢ
 * @param MSG_CMD_WIFI_STATION_SPOT_UPDATE ȵбϢ
 * @param MSG_CMD_WIFI_STATION_EVENT_CONNECTING wpa_supplicantڳ¼Ϣ
 * @param MSG_CMD_WIFI_STATION_EVENT_CONNECTED apstaȵӳɹ֪ͨϢ
 * @param MSG_CMD_WIFI_STATION_EVENT_DISCONNECTED apstaȵϿ֪ͨϢ
 * @param MSG_CMD_BLC_OPEN_WIFISTATION_ACCESS blc͵ӳɹstationipѷ䵽Ϣ
 * @param MSG_CMD_BLC_OPEN_WIFISTATION_ACCESS blcϢapstaϢ
 * @param MSG_CMD_BLC_CLOSE_WIFISTATION_ACCESS blcϢϿapstaϢ
 * @param MSG_CMD_WIFI_STATION_NO_AVAILABLE_AP apstaЧϢ
 * @param MSG_CMD_WIFI_STATION_END apstationϢΧend
 * @param MSG_CMD_WIFI_TSW_SET öʱ˯߻ѵϢ
 * @param MSG_CMD_WIFI_TSW_CLOSE رնʱ˯߻ѹܵϢ
 * @param MSG_CMD_RTC_TIME_UPDATE öʱ˯߻Ϣ
 * @param MSG_CMD_WIFI_RESET_TIMER mmi˯timer
*/
enum wifi_msg_cmd {
	MSG_CMD_WIFI_CFG_AP = MSG_CMD_WIFI_BASE, //ssidĻϢ4001
	MSG_CMD_WIFI_CFG_AP2, //øssidĻϢ
	//MMIģ鲻Ӧôٹػ߼MMIṩ1ػNVҪģȡжǷٹػ
	//MSG_CMD_WIFI_CLOSE_FAST,             //ÿٹػϢ
	MSG_CMD_WIFI_CLOSE,                    //رwifiϢ
	MSG_CMD_WIFI_OPEN,                     //wifiϢ
	MSG_CMD_WIFI_FORCE_RESTART,            //CrashǿwifiϢ
	MSG_CMD_WIFI_ADVANCED,                 //wifiĸ߼Ϣ
	MSG_CMD_WIFI_WPS,                      //WPSܣ2ԶأʲҪرϢ
	MSG_CMD_WIFI_WPS_UP,                   //WPSģ鷢WPSϢ
	MSG_CMD_WIFI_WPS_DOWN,                 //WPSģ鷢WPS رյϢ
	MSG_CMD_WIFI_SLEEP,                    //WEBUI˯ʱϢ
	MSG_CMD_CAPTURE_STATION,               //ѯsta
	MSG_CMD_WIFI_COVERAGE,                 //wifiĸǷΧ
	MSG_CMD_WIFI_MAC,                      //mac˹
	MSG_CMD_WIFI_CHANNEL_FOLLOW,           //wifi APŵSTA

	MSG_CMD_USB_CHARGING_CHANGED,          //⵽usb״̬仯ϱϢ

	//for apstation
	MSG_CMD_WIFI_STATION_OPEN,             //apsta
	MSG_CMD_WIFI_STATION_OPEN_SUCCESS,   //0x4010
	MSG_CMD_WIFI_STATION_OPEN_FAIL,
	MSG_CMD_WIFI_STATION_CLOSE,            //رapsta
	MSG_CMD_WIFI_STATION_CLOSE_SUCCESS,
	MSG_CMD_WIFI_STATION_CLOSE_OPEN_MSSID, //apstaرնssid
	MSG_CMD_WIFI_STATION_SCAN,             //ɨȵ
	MSG_CMD_WIFI_STATION_CONNECT,          //ȵ
	MSG_CMD_WIFI_STATION_CONNECT_TIMEOUT,  //ӳʱĴϢ

	MSG_CMD_WIFI_STATION_SIM_INIT_TIMER_PROCESS,   //eap-sim/akaܣѯsimõĶʱϢ
	MSG_CMD_WIFI_STATION_GET_SCAN_RESULTS,         // wpa_supplicantɨ8sһ
	MSG_CMD_WIFI_STATION_DISCONNECT,               //Ͽӵȵ
	MSG_CMD_WIFI_STATION_SPOT_UPDATE,              //ȵб
	MSG_CMD_WIFI_STATION_EVENT_CONNECTING,         //wpa_supplicantڳ¼Ϣ
	MSG_CMD_WIFI_STATION_EVENT_CONNECTED,          //apstaȵӳɹ֪ͨϢ
	MSG_CMD_WIFI_STATION_EVENT_DISCONNECTED,       //apstaȵϿ֪ͨϢ
	MSG_CMD_WIFI_STATION_BLC_CONNECTED,            //blc͵ӳɹstationipѷ䵽
	MSG_CMD_BLC_OPEN_WIFISTATION_ACCESS,           //blcϢapsta//0x4020
	MSG_CMD_BLC_CLOSE_WIFISTATION_ACCESS,          //blcϢϿapsta
	MSG_CMD_WIFI_STATION_NO_AVAILABLE_AP,
	MSG_CMD_WIFI_STATION_FORGET,               //
	MSG_CMD_WIFI_STATION_INDICATE_SCAN_RESULTS,
	MSG_CMD_WIFI_STATION_CONNECT_FAIL,
	MSG_CMD_WIFI_STATION_SUPPLICANT_EVT, //
	MSG_CMD_WIFI_STATION_TEMP_DISABLED,         //apstaδɹȵĹ¼֮Զ
	MSG_CMD_WIFI_STATION_FAILED_SET,         //apstaδɹȵļȨʧ¼֮
	
	MSG_CMD_WIFI_STATION_DEBUG_DUMP,
	MSG_CMD_WIFI_STATION_WPA_CMD,
	MSG_CMD_WIFI_STATION_CONNECTED_ENABLE_AP_CMD, //apstaȵɹap
	
	//cap->ap
	MSG_CMD_CAP_STA_SET_PARAM,	//sta ssid auth pw
	MSG_CMD_CAP_STA_ENABLE, //ap on off
	MSG_CMD_CAP_STA_SCAN, //scan
	
	MSG_CMD_WIFI_STATION_END,                      //apstationϢΧend

	//timing of sleep wake up
	MSG_CMD_WIFI_TSW_SET,         //öʱ˯߻ѵϢ
	MSG_CMD_WIFI_TSW_CLOSE,       //رնʱ˯߻ѹܵϢ
	MSG_CMD_RTC_TIME_UPDATE,      //rtcʱ öʱ˯߻
	MSG_CMD_WIFI_RESET_TIMER,     //mmi˯timer


	/***************wifi OPENCPUϢ****************/
	MSG_CMD_WIFI_SWITCH_REQ,
	MSG_CMD_WIFI_SWITCH_RSP,
	MSG_CMD_WIFI_CFG_SSID_REQ,  //0x4030
	MSG_CMD_WIFI_CFG_SSID_RSP,
	MSG_CMD_WIFI_CFG_PWD_REQ,
	MSG_CMD_WIFI_CFG_PWD_RSP,
	/***************wifi OPENCPUϢ****************/
	
	MSG_CMD_AP_STA_CONNECTED,
	MSG_CMD_AP_STA_DISCONNECTED,

	//cap recv
	MSG_CMD_CAP_WIFI_STATUS,
	MSG_CMD_CAP_AP_STATUS,
	MSG_CMD_CAP_AP_STA_CHANGE,
	MSG_CMD_CAP_STA_STATUS,
	MSG_CMD_CAP_STA_SCAN_RES,
	
	//cap send
	MSG_CMD_CAP_WIFI_ENABLE, 	//wifiʼ, wlan up
	MSG_CMD_CAP_WIFI_DISABLE, 	//wifiȥʼ, wlan down
	MSG_CMD_CAP_WIFI_WORK_MODE, //wifiģʽ
	MSG_CMD_CAP_WIFI_SET_SSID,	//
	MSG_CMD_CAP_WIFI_SET_HIDESSID,	//0 not hide, 1 hide
	MSG_CMD_CAP_WIFI_SET_MODE,	//80211 mode bgn...
	MSG_CMD_CAP_WIFI_SET_BANDWIDTH,	//0 20M, 1 20/40M
	//MSG_CMD_CAP_WIFI_SET_CHANNEL,	//0 - 13
	MSG_CMD_CAP_WIFI_SET_MAXSTANUM,	//0 - 32
	MSG_CMD_CAP_WIFI_SET_CC_CH, //country code, channel
	MSG_CMD_CAP_WIFI_SET_ACL,
	MSG_CMD_CAP_WIFI_SET_AUTH, //wpa
	MSG_CMD_CAP_WIFI_AP_ENABLE, //ap on off

	MSG_CMD_CAP_WIFI_TEST_ENABLE, 	//wifiģʽʼ, 1 insmod/0 rmmod

	//for cap sync API
	MSG_CMD_CAP_WIFI_STA_STAT_REQ,
	MSG_CMD_CAP_WIFI_STA_STAT_RSP,

};


#define WIFI_SSID_LEN			33
#define WLAN_PSK_LEN 			65
#define WLAN_SECURITY_LEN		20
#define WLAN_ENCRYPT_LEN		10
#define WLAN_DEFAULTID_LEN		4
#define WLAN_WEPKEY_LEN			32
#define WLAN_ENCODE_PSK_LEN		100
#define WLAN_MAX_ACCESS_NUM_LEN 4
#define WLAN_HIDESSID_LEN		4
#define WF_AUTH_OPEN			"OPEN"
#define WF_AUTH_SHARE			"SHARED"
#define WF_AUTH_WEPAUTO			"WEPAUTO"
#define WF_AUTH_WPA				"WPAPSK"
#define WF_AUTH_WPA2			"WPA2PSK"
#define WF_AUTH_WPA_WPA2		"WPAPSKWPA2PSK"
#define WF_AUTH_WAPIPSK			"WAPIPSK"
#define WF_ENCRP_NONE			"NONE"   //encrypt
#define WF_ENCRP_WEP			"WEP"
#define WF_ENCRP_TKIP			"TKIP"
#define WF_ENCRP_CCMP			"CCMP"
#define WF_ENCRP_AES			"AES"
#define WF_ENCRP_TKIP_CCMP		"TKIPCCMP"
#define WF_ENCRP_TKIP_AES		"TKIPAES"

/**
* @brief MSG_CMD_WIFI_CFG_AP ,MSG_CMD_WIFI_CFG_AP2 Ϣݽṹ
*
*
*
*/
typedef struct wlan_cfg_basic {
	char ssid[WIFI_SSID_LEN];			//ssid should be less than 32 bytes
	char pwd[WLAN_PSK_LEN];				//pwd len should be in 8~64 bytes
	char authmode[WLAN_SECURITY_LEN];
	char encrypt[WLAN_ENCRYPT_LEN];
	char max_access_num[WLAN_MAX_ACCESS_NUM_LEN];
	char hidessid[WLAN_HIDESSID_LEN];
} wlan_basic_info;

typedef struct _wlan_mac_info{
	char hostname[32];
	char mac[20];
}wlan_mac_info;

typedef struct _wlan_mac_info_list{
	wlan_mac_info mac_info[MAX_NUMBER_OF_MAC];
	int access_count;
}wlan_mac_info_list;

/**
* @brief wifi״̬
 * @param WIFI_ADVANCED_CLOSE رwifiϢ
 * @param WIFI_ADVANCED_OPEN wifiϢ
 * @param WIFI_ADVANCED_OPEN_VA01 ͬʱssidϢ
 * @param WIFI_ADVANCED_CLOSE_MSSID رոssidϢ
 * @param WIFI_ADVANCED_OPEN_VA1 򿪸ssidϢ
 * @param WIFI_ADVANCED_RF ƵϢ
 * @param WIFI_ADVANCED_RESTART оƬϢ
*/
enum {
	WIFI_ADVANCED_CLOSE = 0,	// 0 رwifi
	WIFI_ADVANCED_OPEN,			// 1 va0
	WIFI_ADVANCED_OPEN_VA01,	// 2 ͬʱssid
	WIFI_ADVANCED_CLOSE_MSSID,	// 3رոssid
	WIFI_ADVANCED_OPEN_VA1,		// 4 򿪸ssid
	WIFI_ADVANCED_RF,			// 5 Ƶ
	WIFI_ADVANCED_RESTART,		// 6 оƬ
};

/**********wlan atate***************/
#define WIFI_OPENED        "1"    //ѻ
#define WIFI_CLOSED        "0"    //ѹر

#define WLAN_ON             1    //ѻ
#define WLAN_OFF            0

/**
* @brief wifi apstation SIM״̬
 * @param CARD_MODE_NO_SIM ûSIMϢ
 * @param WCARD_MODE_SIM SIMϢ
 * @param CARD_MODE_USIM USIMϢ
*/
//apstaʶsim
enum CardMode_Def {
	/*T_zUfi_CardMode*/
	CARD_MODE_NO_SIM = 0x1b00,
	CARD_MODE_SIM,
	CARD_MODE_USIM,
	/*--------------------*/
};


/**
* @brief wifi PIN״̬
 * @param PIN_STATUS_NO_PIN ûPINϢ
 * @param PIN_STATUS_PIN1 PIN1Ϣ
 * @param PIN_STATUS_PIN2 PIN2Ϣ
 * @param PIN_STATUS_PUK1 PUK1Ϣ
 * @param PIN_STATUS_PUK2 PUK2Ϣ
*/
enum PinStatus_Def {
	/*T_zUfi_PinStatus*/
	PIN_STATUS_NO_PIN = 0x1c00,
	PIN_STATUS_PIN1,
	PIN_STATUS_PIN2,
	PIN_STATUS_PUK1,
	PIN_STATUS_PUK2,
	/*--------------------*/
};

/*********************station begin****************/

//#ifndef  __REALTEK_8192_CHIP__
#if !(defined(__REALTEK_8192_CHIP__) || defined(__SSV_6X5X_CHIP__) || defined(__AIC_8800DW_CHIP__))


#define WIFI_STATION_MAC_LEN                20
#define WIFI_STATION_SSID_LEN               128
#define WIFI_STATION_AUTH_MODE_LEN  		20
#define WIFI_STATION_ENCRYPT_TYPE_LEN  		20
#define WIFI_STATION_SPOT_PASSWORD_LEN  	128

typedef struct scan_result {
	char     mac[WIFI_STATION_MAC_LEN];
	char     ssid[WIFI_STATION_SSID_LEN];
	char     auth_mode[WIFI_STATION_AUTH_MODE_LEN];
	char     encrypt_type[WIFI_STATION_ENCRYPT_TYPE_LEN];
	short    connect_status;
	short    channel;
	short    signal;
	short    network_id;
} scan_result_t;

typedef struct spot {
	char     mac[WIFI_STATION_MAC_LEN];
	char     ssid[WIFI_STATION_SSID_LEN];
	char     auth_mode[WIFI_STATION_AUTH_MODE_LEN];
	char     encrypt_type[WIFI_STATION_ENCRYPT_TYPE_LEN];
	char     password[WIFI_STATION_SPOT_PASSWORD_LEN];
	short    network_id;
} spot_t;

typedef enum{
	SAVE_ACTION,
	DEL_ACTION,
	CONNECTING_ACTION,
	DHCPING_ACTION,
	CONNECTED_ACTION,
	DISCONNECT_ACTION,
	
	//kw 3
	ACTION_MAX
}spot_action_t;

typedef struct  msg_act_spot {
	spot_action_t  act;
	char  mac[WIFI_STATION_MAC_LEN];
	char  ssid[WIFI_STATION_SSID_LEN];
	int network_id;
} msg_act_spot_t;

typedef enum scan_content {	
	WIFI_STATION_AP_CONTENT_UNDEFINED,
	WIFI_STATION_AP_MAC,
	WIFI_STATION_AP_SSID,
	WIFI_STATION_AP_AUTH_MODE,
	WIFI_STATION_AP_ENCRYPT_TYPE,	
	WIFI_STATION_AP_CHANNEL,
	WIFI_STATION_AP_SIGNAL,
	WIFI_STATION_AP_CONNECT_STATUS,
	WIFI_STATION_AP_NETWORK_ID,
} scan_content_t;

typedef enum{
	DISCONNECT_STATUS,
	CONNECTING_STATUS,
	DHCPING_STATUS,
	CONNECTED_STATUS,
}connect_status_t;

typedef enum {
	WIFI_STATION_WRONG_KEY,
	WIFI_STATION_IP_FAIL,
	WIFI_STATION_AUTH_FAIL,
	WIFI_STATION_OTHER,
}conn_fail_reason_t;

#else

#define WIFI_STATION_SPOT_ACTION_LEN             32
#define WIFI_STATION_SPOT_LEN  256
#define WIFI_STATION_SPOT_LIST_NUM  10
#define WIFI_STATION_SPOT_PROFILE_NAME_LEN  30
#define WIFI_STATION_SPOT_PASSWORD_LEN  128
#define WIFI_STATION_SPOT_KEY_ID_LEN  10
#define WIFI_STATION_PROFILE_NV_NAME_LEN  20

#define WIFI_STATION_WPA_STATUS_LEN         30
#define WIFI_STATION_MAC_LEN                20
#define WIFI_STATION_SSID_LEN               128
#define WIFI_STATION_AUTH_MODE_LEN  20
#define WIFI_STATION_ENCRYPT_TYPE_LEN  20
#define WIFI_STATION_FLAGS_LEN    128

typedef struct  update_spot_info {
	char spot[WIFI_STATION_SPOT_LEN];
	char action[WIFI_STATION_SPOT_ACTION_LEN];
	char ssid[WIFI_SSID_LEN];			//ssid should be less than 32 bytes
	char pwd[WLAN_PSK_LEN];				//pwd len should be in 8~64 bytes
} updateinfo_t;

typedef enum wifi_profile_content {
	WIFI_STATION_CONTENT_UNDEFINED,
	WIFI_STATION_PROFILE_NAME,
	WIFI_STATION_FROM_PROVIDER,
	WIFI_STATION_CONNECT_STATUS,
	WIFI_STATION_SIGNAL,
	WIFI_STATION_SSID,
	WIFI_STATION_AUTH_MODE,
	WIFI_STATION_ENCRYPT_TYPE,
	WIFI_STATION_PASSWORD,
	WIFI_STATION_KEY_ID,
	WIFI_STATION_AP_MAC
} wifi_profile_content_t;

typedef struct scan_result {
	char     mac[WIFI_STATION_MAC_LEN];
	char     ssid[WIFI_STATION_SSID_LEN];
	char     auth_mode[WIFI_STATION_AUTH_MODE_LEN];
	char     encrypt_type[WIFI_STATION_ENCRYPT_TYPE_LEN];
	short    from_provider;//0:Ӫ̣1:Ӫ
	short    connect_status;
	short    channel;
	short    signal;
#ifdef USE_CAP_SUPPORT
	//short    ch_freq;
	signed char    signal_db;
#endif
} scan_result_t;


typedef struct spot {
	char      profile_name[WIFI_STATION_SPOT_PROFILE_NAME_LEN];
	short    from_provider;//0:Ӫ̣1:Ӫ
	short    connect_status;
	short    signal;
	char      ssid[WIFI_STATION_SSID_LEN];
	char      auth_mode[WIFI_STATION_AUTH_MODE_LEN];
	char      encrypt_type[WIFI_STATION_ENCRYPT_TYPE_LEN];
	char      password[WIFI_STATION_SPOT_PASSWORD_LEN];
	short    keyID;
	char     mac[WIFI_STATION_MAC_LEN];
	BOOL    is_tried_connect;
	short    network_id;
} spot_t;


typedef struct  spot_ssid_id {
	int  id;
	char  ssid[WIFI_STATION_SSID_LEN];
} spot_ssid_id_t;
#endif

/*********************station end****************/

/*nv   set flags */

//wifi

#define NVIO_WIFI_MAX_LEN  				200 /*write or read nv length*/
#define WIFI_PSW_DEFAULT_LENGTH  		65
#define WIFI_STATUS_LEN					 2
#define WIFI_PSW_MIN_LEN 				1
#define WIFI_PSW_MAN_LEN 				64
#define WIFI_CONFIG_DEFAULT_LENGTH  	128
#define WF_WPS_KEY_INDEX_LEN  			2
#define WF_KEY_MODE_LEN  				3
#define WF_WEP_KEY_MAX_LEN  			27
#define WF_WPA_KEY_MAX_LEN  			65
#define WF_ENCRY_TYPE_LEN 				16
#define WF_AU_MODE_LEN  				16
#define WPS_MODE_PIN 					"PIN"      //wps mode 
#define WPS_MODE_PBC  					"PBC"
#define WPS_MODE_AP_PIN   				"APPIN"
#define WF_AU_OPEN            				"OPEN"            //wifi auth mode?
#define WF_AU_SHARE           				"SHARED"
#define WF_AU_WEPAUTO         				"WEPAUTO"
#define WF_AU_WPA             				"WPAPSK"
#define WF_AU_WPA2            				"WPA2PSK"
#define WF_AU_WPA_WPA2  	  			"WPAPSKWPA2PSK"
#define WF_AU_WPA3            				"WPA3Personal"
#define WF_AU_WPA2_WPA3            				"WPA2WPA3"
#define WF_AU_WAPIPSK	      				"WAPIPSK"
#define WF_ENCRY_NONE      				"NONE"   //encrypt
#define WF_ENCRY_WEP      				 "WEP"
#define WF_ENCRY_TKIP      				"TKIP"
#define WF_ENCRY_CCMP     				 "CCMP"
#define WF_ENCRY_AES       				"AES"
#define WF_ENCRY_TKIP_CCMP 				"TKIPCCMP"
#define WF_ENCRY_TKIP_AES  				"TKIPAES"
#define WIFI_SSID_INDEX 					"ssid_index"
#define WIFI_STATION_MAC 				"mac_addr"
#define WIFI_STATION_HOSTNAME 			"hostname"
#define WIFI_STATION_IPADDR 				"ip_addr"
#define WIFI_STATION_CONNECTTIME 		"connect_time"
#define WIFI_STATION_VALIDTIME 			"valid_time"
#define WIFI_STATION_IPTYPE 				"ip_type"
#define WIFI_STATION_DEVTYPE 			"dev_type"
#define WIFI_NV_ITEM_WIFI_SET_FLAGS 	"wifi_set_flags"
#define NV_WIFI_SCAN_FINISH         			"scan_finish"

#define NV_WIFI_WPA_PASS            			"WPAPSK1"
#define NV_WIFI_WPA_PASS_ENCODE     		"WPAPSK1_encode"
#define NV_WIFI_WPA_PASS_M          		"m_WPAPSK1"
#define NV_WIFI_WPA_PASS_M_ENCODE   	"m_WPAPSK1_encode"
#define NV_WIFI_COVERAGE  				"wifi_coverage"
#define NV_WIFI_WPS_STATE 				 "WscModeOption"
#define NV_WIFI_WPS_MODE      			"wps_mode"
#define NV_WIFI_WPS_SSID       			"WPS_SSID"
#define NV_WIFI_WPS_INDEX   				"wifi_wps_index"
#define NV_WIFI_WPS_PIN   				"wps_pin"
#define NV_WIFI_WPS_AP_PIN   			"wifi_ap_pin"
#define NV_WIFI_WPS_DEF_PIN   			"wifi_def_pin"
#define CMD_WIFI_STATION_LIST 			"station_list"
#define CMD_HOSTNAME_LIST 				"hostNameList"
#define CMD_WIFI_WPS_AP_PIN 			"wifi_ap_pin"
#define CMD_WIFI_WPS_AP_DEF_PIN 		"wifi_def_pin"

typedef enum {
	ZTE_WLAN_SSID_SET = 0x1,
	ZTE_WLAN_BROADCAST_SET = 0x2,
	ZTE_WLAN_BASIC_SECURITY_SET = 0x4,
	ZTE_WLAN_MAX_ACCESS_NUM_SET = 0x8,


	ZTE_WLAN_ON_OFF_SET = 0x10,
	ZTE_WLAN_WIRELESS_MODE_SET = 0x20,	
	ZTE_WLAN_CHANNEL_SET = 0x40,	
	ZTE_WLAN_COUNTRY_SET = 0x80,
	ZTE_WLAN_WIFI_BAND_SET = 0x100,

	ZTE_WLAN_POWER_SET = 0x1000,	
	ZTE_WLAN_ACL_SET = 0x2000,	
	ZTE_WLAN_WPS_SET = 0x4000,	
	ZTE_WLAN_SET_AP_SLEEPTIMER = 0x8000,


	ZTE_WLAN_SET_AP_MSSID = 0x10000,	

} zte_wlan_set_e_flags;


//cap:api->wlan_proxy->ap:wlan_server
typedef enum
{
	IN_WIFI_STATUS_DISABLED = 0,
	IN_WIFI_STATUS_ENABLED,
	IN_WIFI_STATUS_INVALID_MAC,
	IN_WIFI_STATUS_DEV_INIT_FAIL,
	IN_WIFI_STATUS_FIRMWARE_CRASH,
} inner_wifi_status_e;

//nei bu zhuan huan yong
//same as sc_wifi_ap_index_e
typedef enum
{
	IN_WIFI_AP_INDEX_MIN = -1,
	IN_WIFI_AP_INDEX_AP0 = 0, 	//2.4G
	IN_WIFI_AP_INDEX_AP1, 		//5G
	IN_WIFI_AP_INDEX_MAX
} inner_wifi_ap_id_e;

typedef struct {
	int idx; 			//refers to: wlan0,1... 
	char ssid[WIFI_SSID_LEN]; 	//ssid should be less than 32 bytes
} wlan_ap_ssid_t;

typedef struct {
	int idx; 			//refers to: wlan0,1... 
	int ssid_hide; 				//0 not hide, 1 hide
} wlan_ap_ssid_hide_t;

typedef struct {
	int idx; 			//refers to: wlan0,1... 
	int wl_mode; 				//2.4G: 6 bgnax, 4 bgn; 5G: 6 a/n/ac/ax, 5 a/n/ac, 4 a/n
} wlan_ap_wl_mode_t;

typedef struct {
	int idx; 			//refers to: wlan0,1... 
	int htMode; 		//4 20/40/80M, 1 20/40M, 0 20M
	//int force_40m;
} wlan_ap_bandwidth_t;

typedef struct {
	int idx; 			//refers to: wlan0,1... 
	int max_sta_num; 			//1-32
} wlan_ap_max_sta_t;

typedef struct {
	int idx; 			//refers to: wlan0,1... 
	char countrycode[3]; 		//default CN
	int channel;  //0-13
} wlan_ap_cc_ch_t;

typedef struct {
	int idx; 			//refers to: wlan0,1... 
	int acl_rule; 				//0 none, 1 white, 2 black
	char acl_list[360]; 		//max 10 mac1;mac2...
} wlan_ap_acl_t;

typedef struct {
	int idx; 			//refers to: wlan0,1... 
	char authmode[WLAN_SECURITY_LEN];
	char encrypt[WLAN_ENCRYPT_LEN]; //realtek use
	char pwd[WLAN_PSK_LEN];	 	//max 64
} wlan_ap_auth_t;

typedef struct {
	int idx; 			//refers to: wlan0,1... 
	int enable; 			//1 ap on , 0 ap off
} wlan_ap_enable_t;

//station
typedef struct {
	int enable; 			//1 ap on , 0 ap off
} wlan_sta_enable_t;


//ap->cap:ind 
//ṹ,չ
typedef struct {
	int wifi_status;
} wlan_status_t;

//same as sc_wifi_work_mode_e  to do: hu huan
typedef enum
{
	IN_WIFI_WORK_MODE_MIN = -1,
	IN_WIFI_WORK_MODE_AP0 = 0, 	//2.4G single ap / ap+sta
	IN_WIFI_WORK_MODE_AP1, 		//5G single ap / ap+sta
	IN_WIFI_WORK_MODE_STA,
	IN_WIFI_WORK_MODE_MAX
} inner_wifi_work_mode_e;

//same as sc_wifi_ap_status_e
typedef enum
{
	IN_WIFI_AP_STATUS_NONE = 0,
	IN_WIFI_AP_STATUS_IDLE, //or disable
	IN_WIFI_AP_STATUS_ENABLING,
	IN_WIFI_AP_STATUS_ENABLED,
	IN_WIFI_AP_STATUS_DISABLING,
	IN_WIFI_AP_STATUS_ERROR
} inner_wifi_ap_status_e;

typedef struct {
	int idx;
	int pre_status; //capиֵ
	int status;
	char ifname[32];
	char bssid[18]; //capиֵ
} wlan_ap_status_t;

//sc_wifi_sta_connect_status_t
typedef struct {
	int idx;
	int is_connected;
	char macaddr[18];
} wlan_sta_connect_status_t;

//cap station
typedef struct {
	char ssid[WIFI_SSID_LEN]; 	//ssid should be less than 32 bytes
	char authmode[WLAN_SECURITY_LEN];
	char encrypt[WLAN_ENCRYPT_LEN]; //realtek use
	char pwd[WLAN_PSK_LEN];	 	//max 64
} wlan_sta_param_t;

//same as sc_wifi_sta_status_e
typedef enum
{
	IN_WIFI_STA_STATUS_NONE, //close
	IN_WIFI_STA_STATUS_IDLE,
	IN_WIFI_STA_STATUS_CONNECTING, //Trying to associate with
	IN_WIFI_STA_STATUS_ASSOCIATED, //dhcping
	IN_WIFI_STA_STATUS_CONNECTED,
	IN_WIFI_STA_STATUS_DISCONNECTED, 
	IN_WIFI_STA_STATUS_ERROR
} in_wifi_sta_status_e;

//same as sc_wifi_reason_code_e
typedef enum
{
	IN_WIFI_REASON_CODE_NONE,
	IN_WIFI_REASON_CODE_WRONG_KEY,
	IN_WIFI_REASON_CODE_AUTH_FAILED,
	IN_WIFI_REASON_CODE_CONN_FAILED,
	IN_WIFI_REASON_CODE_SET_FAILED,
	IN_WIFI_REASON_CODE_DHCP_FAILED
} in_wifi_reason_code_e;

typedef struct
{
	char addr[16]; //255.255.255.255 16 IPV4ADDLEN_MAX
	char netmask[16];
	unsigned char subnet_bits; //255.255.255.0 is 24
	char gateway[16];
	char dnsp[16]; //primary DNS
	char dnss[16]; //secondary DNS
} in_wifi_net_addr_t;

typedef struct
{
	char addr[48]; //0001:0002:0003:0004:0001:0002:0003:0004 40 (+8:, 48)
	char prefix[48];
	unsigned char prefix_bits;
	char gateway[48];
	char dnsp[48]; //primary DNS
	char dnss[48]; //secondary DNS
} in_wifi_net_addr6_t;

//same as sc_wifi_sta_status_t
typedef struct {
	int pre_status; //proxy record

	int status; //in_wifi_sta_status_e
	char ifname[32];
	char ap_bssid[18]; //cur ap mac
	int rssi;
	unsigned char signal_level;
	unsigned char has_addr;
	in_wifi_net_addr_t addr;
	unsigned char has_addr6;
	in_wifi_net_addr6_t addr6;
	int reason_code; //in_wifi_reason_code_e	
} wlan_sta_status_t;

typedef struct {
	int rssi;
} wlan_sta_stat_sync_t;


typedef struct {
	int result;
	wlan_sta_status_t status;
} scwifi_sta_stat_res_t;


#define CAP_WIFI_MAX_SCAN_CNT 30

#define CAP_WIFI_AUTH_UNSUP -1 //"not support"
#define CAP_WIFI_AUTH_OPEN 0 //"OPEN"
#define CAP_WIFI_AUTH_WPA2 1 //"WPA2PSK"
#define CAP_WIFI_AUTH_WPA3 2 //"WPA3Personal"
#define CAP_WIFI_AUTH_WPA12 3 //"WPAPSKWPA2PSK"
#define CAP_WIFI_AUTH_WPA23 4 //"WPA2WPA3"

#define CAP_WIFI_ENCRYPT_UNSUP -1 //"not support"
#define CAP_WIFI_ENCRYPT_AUTO 0 //"TKIPCCMP"
#define CAP_WIFI_ENCRYPT_TKIP 1 //"TKIP"
#define CAP_WIFI_ENCRYPT_AES 2 //"CCMP"

//sc_wifi_sta_scan_info_t
typedef struct
{
	char bssid[18];//mac
	char essid[33];
	signed char signal; //dbm
	unsigned char signal_level; //0-5, max 5
	unsigned char channel; //1-13, 36...
	unsigned char auth;
	unsigned char cipher;
	//int frequency; //Hz
} wlan_sta_scan_info_t;

//sc_wifi_sta_scan_list_t
typedef struct
{
	int cnt;
	wlan_sta_scan_info_t info[CAP_WIFI_MAX_SCAN_CNT];
} wlan_sta_scan_list_t;

typedef struct {
	int work_mode; //inner_wifi_work_mode_e
} wlan_work_mode_t;//scwifi_workmode_t

#endif
