/**
 * 
 * @file      amt_wifi_test.c
 * @brief     
 *            This file is part of FTM.
 *            AMTӦò
 *            
 * @details   
 * @author    Tools Team.
 * @email     
 * @copyright Copyright (C) 2013 Sanechips Technology Co., Ltd.
 * @warning   
 * @date      2019/02/02
 * @version   1.1
 * @pre       
 * @post      
 *            
 * @par       
 * Change History :
 * ---------------------------------------------------------------------------
 * date        version  author         description
 * ---------------------------------------------------------------------------
 * 2015/04/28  1.0      lu.xieji       Create file
 * 2019/02/02  1.1      jiang.fenglin  ޸עͷʽΪdoxygen
 * ---------------------------------------------------------------------------
 * 
 * 
 */


#include <stdlib.h>
#include <stdio.h>
#include <string.h>
#include <fcntl.h>
#include <sys/stat.h>
#include "amt.h"

#define MAX_CMD_BUFFER_LENGTH  256
#define MAX_RECV_BUFFER_LENGTH 2048

//static char g_CmdBuffer[MAX_CMD_BUFFER_LENGTH];
//static char g_RecvBuffer[MAX_RECV_BUFFER_LENGTH];

/**
 * @brief AMTWIFIʼ
 * @return ɹ0, ʧܷ-1
 * @note
 * @see 
 */
int Amt_Wifi_Init(void)
{
    return 0;
}

int wifi_ioctl_handle(int cmd)
{
	int fd = -1;
	int ret = 0;
	fd = open("/dev/wifi_device", O_RDWR);
	if (fd < 0)
		return -1;
	ret = ioctl(fd, cmd);
	if (ret < 0)
		printf("ioctl wifi_device err:%d\n", ret);
	close(fd);
	return ret;
}



/**
 * @brief AMTWIFIϢ
 * @param[in] msg_id FID
 * @param[in] msg_buf buffer
 * @param[in] msg_len buffer
 * @return ɹ0, ʧܷ-1
 * @note
 * @see 
 */
int Amt_Wifi_ProcessMsg(unsigned int msg_id, unsigned char* msg_buf, unsigned int msg_len)
{
    char*pCmdBuffer = malloc(MAX_CMD_BUFFER_LENGTH);
    if (pCmdBuffer == NULL)
    {
        AmtPrintf(AMT_ERROR "%s: malloc pCmdBuffer failure.\n", __FUNCTION__);
        return -1;
    }
    char*pRecvBuffer = malloc(MAX_RECV_BUFFER_LENGTH);
    if (pRecvBuffer == NULL)
    {
        AmtPrintf(AMT_ERROR "%s: malloc pRecvBuffer failure.\n", __FUNCTION__);
		free(pCmdBuffer);
        return -1;
    }
    memcpy(pCmdBuffer, msg_buf, msg_len);
    pCmdBuffer[msg_len] = '\0';

    memset(pRecvBuffer, 0, MAX_RECV_BUFFER_LENGTH);

	AmtPrintf(AMT_INFO "%s: cmd=%s.\n", __FUNCTION__, pCmdBuffer);

     // sv6158 load firmware
    if ((strcmp(pCmdBuffer, "insmod ./lib/modules/3.4.110-rt140/kernel/drivers/net/wireless/ssv6x5x/ssv6x5x.ko stacfgpath=/etc/firmware/ssv6x5x-wifi.cfg") == 0)||
		(strcmp(pCmdBuffer, "insmod ./lib/modules/3.4.110-rt140/kernel/drivers/net/wireless/ssv6x5x/prealloc/ssv6xxx_prealloc_skb.ko") == 0)||
		(strcmp(pCmdBuffer, "insmod ./lib/modules/3.4.110-rt140/kernel/drivers/net/wireless/ssv6x5x/ssv6x5x_host/ssv6x5x.ko stacfgpath=/etc/firmware/ssv6x5x-wifi.cfg") == 0))
    {
		static int load_flag = 0;
		AmtPrintf(AMT_INFO "%s: recv insmod cmd=%s.\n", __FUNCTION__, pCmdBuffer);
		if(load_flag == 0)
		{
			int ret = wifi_ioctl_handle(1);
			load_flag = 1;
			if(ret < 0)
		    {
				AmtPrintf(AMT_ERROR "%s: load sv6158 firmware fail! ret=%d.\n", __FUNCTION__, ret);
            	free(pCmdBuffer);
            	free(pRecvBuffer);
            	return -1;
			}
			else
			{
				if (Amt_CreateResponse(msg_id, &ret, sizeof(ret)) == -1)
        		{
            		AmtPrintf(AMT_ERROR "%s: Send data failure.\n", __FUNCTION__);
        		}
        		else
        		{
            		AmtPrintf(AMT_INFO "%s: Send data success.\n", __FUNCTION__);
        		}

				free(pCmdBuffer);
    			free(pRecvBuffer);
				
    			return 0;
			}
		   
		}
		else
		{
			free(pCmdBuffer);
    		free(pRecvBuffer);
			return 0;
		}
	}
	

    int read_len = Amt_ExecuteCmd(pCmdBuffer, pRecvBuffer, MAX_RECV_BUFFER_LENGTH);

    if (read_len > 0)
    {
		// ǿӽ
		pRecvBuffer[MAX_RECV_BUFFER_LENGTH - 1] = '\0';
		
        // Broadcom
        if (strcmp(pCmdBuffer, "wl counters") == 0)
        {
            char pRxStr[] = "pktengrxdmcast";
            char *ptr = strstr(pRecvBuffer, pRxStr);

            if (ptr != NULL)
            {
                int packetsNum = 0;
                sscanf(ptr, "%*[^ ]%d", &packetsNum);
                memcpy(pRecvBuffer, &packetsNum, sizeof(packetsNum));
                read_len = sizeof(packetsNum);
            }
            else
            {
                AmtPrintf(AMT_ERROR "%s: Can not find \"%s\".\n", __FUNCTION__, pRxStr);
                free(pCmdBuffer);
                free(pRecvBuffer);
                return -1;
            }
        }

        if (Amt_CreateResponse(msg_id, (unsigned char*)pRecvBuffer, read_len) == -1)
        {
            AmtPrintf(AMT_ERROR "%s: Send data failure.\n", __FUNCTION__);
        }
        else
        {
            AmtPrintf(AMT_INFO "%s: Send data success.\n", __FUNCTION__);
        }
    }
    else
    {
        AmtPrintf(AMT_INFO "%s: no return.\n", __FUNCTION__);
    }
    free(pCmdBuffer);
    free(pRecvBuffer);
    return 0;
}


