#include "sd_httpshare.h"
#include "sqlite3.h"

extern char usb_lun_path[];

int zte_del_file(char *path)
{
	char cmd[MAX_CMD_LEN] = {0};

	if (!path) {
		slog(SDCARD_PRINT, SLOG_ERR, "[sdcard-hotplug]del_file  null\n");
		return 0;
	}

	sprintf(cmd, "/bin/rm -rf '%s'", path);
	zxic_system(cmd);

	if (access(path, F_OK) == 0) {
		slog(SDCARD_PRINT, SLOG_ERR, "[sdcard-hotplug]delfile %s fail!\n", path);
	}
	return 1;
}

int zte_umount_dev()
{
	char cmd[MAX_CMD_LEN] = {0};
	char sd_path[20] = {0};
	
	sc_cfg_get ("cur_tcard_blk", sd_path, sizeof(sd_path));
	if (strlen(sd_path) != 0) {
		sprintf(cmd, "/bin/umount %s", sd_path);
	}
	else {
		sprintf(cmd, "/bin/umount %s", USB_DEV_SDCARD_PATH);
	}
	zxic_system(cmd);

	memset(cmd, 0, sizeof(cmd));
	sprintf(cmd, "/bin/umount %s", USB_DEV_SDCARD_PATH_BACK);
	zxic_system(cmd);

	memset(cmd, 0, sizeof(cmd));
	sprintf(cmd, "/bin/umount %s", SD_CARD_PATH);
	zxic_system(cmd);
	return 0;
}

int zte_check_sdcard_exist()
{
	char cmd[MAX_CMD_LEN] = {0};
	int ret = 0;
	FILE *fd = NULL;

	char size_sd[ZTE_HTTPSHARE_LEN_12] = {0};

    if(access("/sys/kernel/debug/mmc1/present", R_OK) != 0)
    {
		slog(SDCARD_PRINT, SLOG_ERR, "[sdcard-hotplug] check_sdcard_exist file not exist!\n");
        return ret;	
    }

	sprintf(cmd, "echo %s>%s", USB_DEV_SDCARD_PATH_BACK, TCARD_SIZE_FILE);
	soft_system(cmd);

	//fd = popen("cat /proc/proc_sd/size","r");
	fd = popen("cat /sys/kernel/debug/mmc1/present", "r");

	if (fd == NULL) {
		slog(SDCARD_PRINT, SLOG_ERR, "[sdcard-hotplug]check_sdcard_exist popen file = NULL\n");
		return ret;
	}
	if (!feof(fd) && fgets(size_sd, sizeof(size_sd), fd) != NULL) {
		ret = atoi(size_sd);
	}

	pclose(fd);

	slog(SDCARD_PRINT, SLOG_DEBUG, "[sdcard-hotplug]check_sdcard_exist :get size data = %d\n", ret);

	return ret;
}

// Get current mode from nv
zte_httpshare_current_mode_type zte_httpshare_get_current_mode()
{
	char nv_item[ZTE_HTTPSHARE_DEFAULT_LEN] = {0};
	sc_cfg_get("sdcard_mode_option", nv_item, sizeof(nv_item));
	slog(SDCARD_PRINT, SLOG_DEBUG, "[sdcard-hotplug]sdcard_mode_option:%s\n", nv_item);

	if (0 == strcmp("1", nv_item)) {
		return ZTE_HTTPSHARE_HTTPSHARE;
	} else {
		return ZTE_HTTPSHARE_USB;
	}
}

int zte_httpshare_mount_sd()
{
	char cmd[MAX_CMD_LEN] = {0};
	char sd_path[20] = {0};
	int i = 0;

	zte_umount_dev();

//ѯ1-10
	for (i = 1; i <= 10; i++) {
		memset(sd_path, 0, sizeof(sd_path));
		snprintf(sd_path, sizeof(sd_path), "/dev/mmcblk0p%d", i);

		memset(cmd, 0, sizeof(cmd));
		sprintf(cmd, "/bin/mount -t vfat %s %s", sd_path, SD_CARD_PATH);
		if (0 == zxic_system(cmd)) {
			sc_cfg_set("cur_tcard_blk", sd_path);
			sleep(2);
			return 1;
		}
		slog(MISC_PRINT, SLOG_ERR,"[sdcard-hotplug]httpshare_mount_sd %s error!\n", sd_path);
	}

	memset(cmd, 0, sizeof(cmd));
	sprintf(cmd, "/bin/mount -t vfat %s %s", USB_DEV_SDCARD_PATH_BACK, SD_CARD_PATH);
	if (0 != zxic_system(cmd)) {
		slog(MISC_PRINT, SLOG_ERR,"[sdcard-hotplug]httpshare_mount_sd %s error!\n", USB_DEV_SDCARD_PATH_BACK);
		return 0;
	}
	sleep(2);
	return 1;
}

int zte_mount_httpshare()
{
	char cmd[MAX_CMD_LEN] = {0};

	sprintf(cmd, "echo NULL > %s", usb_lun_path);
	//zte_httpshare_call_system("echo NULL > /sys/devices/platform/zx29_hsotg.0/gadget/lun1/file");
	soft_system(cmd);
	if (-1 == access(SD_CARD_PATH, F_OK)) {
		slog(SDCARD_PRINT, SLOG_ERR, "[sdcard-hotplug]mount_httpshare mmc2 no exist!\n");
		
		if(mkdir(SD_CARD_PATH, 0777) < 0) // cov M CHECKED_RETURN
		{
		    slog(SDCARD_PRINT, SLOG_ERR, "mkdir fail, path:%s!\n", SD_CARD_PATH);
		}
		return zte_httpshare_mount_sd();
	} else {
		//system("umount /mnt/jffs2/mmc2");
		slog(SDCARD_PRINT, SLOG_DEBUG, "[sdcard-hotplug]mount_httpshare %s exist\n", SD_CARD_PATH);
		return zte_httpshare_mount_sd();
	}
}

void zte_mount_usb()
{
	char cmd[MAX_CMD_LEN] = {0};

	sprintf(cmd, "echo %s > %s", USB_DEV_SDCARD_PATH_BACK, usb_lun_path);
	soft_system(cmd);
	//zte_httpshare_call_system("echo dev/mmcblk0 > /sys/devices/platform/zx29_hsotg.0/gadget/lun1/file");
	zte_umount_dev();
}

int zte_httpshare_change_current_mode(zte_httpshare_current_mode_type mode)
{
	char cmd[ZTE_HTTPSHARE_DEFAULT_LEN] = {0};
	zte_umount_dev();
	if (ZTE_HTTPSHARE_HTTPSHARE == mode) {
		if (!zte_mount_httpshare()) { /*sd*/
			/*sdcardʧ*/
			slog(SDCARD_PRINT, SLOG_ERR, "[sdcard-hotplug]change to %d mode faile\n", mode);
			sc_cfg_set("sdcard_mode_option", "0");

			sprintf(cmd, "echo %s > %s", USB_DEV_SDCARD_PATH_BACK, usb_lun_path);
			soft_system(cmd);
			//zte_httpshare_call_system("echo dev/mmcblk0 > /sys/devices/platform/zx29_hsotg.0/gadget/lun1/file");
			return ZTE_CHANGE_MODE_ERROR;
		}
		slog(SDCARD_PRINT, SLOG_NORMAL, "[sdcard-hotplug]change to %d mode suc.\n", mode);
		sc_cfg_set("sdcard_mode_option", "1");
	} else {
		zte_mount_usb();
		sc_cfg_set("sdcard_mode_option", "0");
	}
	return ZTE_CHANGE_MODE_OK;

}

int zte_init_sdcard_path()
{
	if (-1 == access(SD_CARD_PATH_PR, F_OK)) {
		slog(SDCARD_PRINT, SLOG_ERR, "init_sdcard_path:%s does not exist, create it.\n", SD_CARD_PATH_PR);

		if (-1 == mkdir(SD_CARD_PATH_PR, 0777)) {          /*lint !e1055*/
			slog(SDCARD_PRINT, SLOG_ERR, "init_sdcard_path:failed to create %s.\n", SD_CARD_PATH_PR);
			return ZTE_HTTPSHARE_FAILURE;
		}
	}
	return ZTE_HTTPSHARE_SUCCESS;
}

int zte_init_sdcard_mode()
{
	if (zte_check_sdcard_exist() > 0) {
		slog(SDCARD_PRINT, SLOG_DEBUG, "[sdcard-hotplug]sd ok!\n");

		sc_cfg_set("sd_card_state", "1");

		if (ZTE_HTTPSHARE_USB == zte_httpshare_get_current_mode()) {
			return zte_httpshare_change_current_mode(ZTE_HTTPSHARE_USB);
		} else {
			return zte_httpshare_change_current_mode(ZTE_HTTPSHARE_HTTPSHARE);
		}
	} else {
		slog(SDCARD_PRINT, SLOG_DEBUG, "[sdcard-hotplug]no sd!\n");
		sc_cfg_set("sd_card_state", "0");
		zte_del_file(SD_CARD_PATH);
		return ZTE_CHANGE_MODE_ERROR;
	}
}

zte_httpshare_return_e_type zte_httpshare_check_and_creat_dir(char *path)
{
	if (!path) {
		slog(SDCARD_PRINT, SLOG_ERR, "[sdcard-hotplug]httpshare_check_and_creat_dir: check dir path null.\n");
		return ZTE_HTTPSHARE_FAILURE;
	}

	if (-1 == access(path, F_OK)) {
		slog(SDCARD_PRINT, SLOG_ERR, "[sdcard-hotplug]httpshare_check_and_creat_dir:%s does not exist,socreate it.\n", ZTE_HTTPSHARE_DB_DIR);

		if (-1 == mkdir(path, 0777)) {          /*lint !e1055*/
			slog(SDCARD_PRINT, SLOG_ERR, "[sdcard-hotplug]httpshare_check_and_creat_dir:failed to create db dir.\n");
			return ZTE_HTTPSHARE_FAILURE;
		}
	}
	return ZTE_HTTPSHARE_SUCCESS;
}

zte_httpshare_db_result_e_type zte_httpshare_db_open(sqlite3**db)
{
	sqlite3* tmp_db;
	int rc = 0;

	if (NULL == db) {
		slog(SDCARD_PRINT, SLOG_ERR, "[sdcard-hotplug]httpshare_db_open:invalide inputs.\n");
		return ZTE_HTTPSHARE_DB_ERROR_INVAILD_PTR;
	}

	rc = sqlite3_open(ZTE_HTTPSHARE_DB_PATH, &tmp_db);
	if (rc) {
		slog(SDCARD_PRINT, SLOG_ERR, "[sdcard-hotplug]httpshare_db_open:can not open db,sqlite3_errmsg:%s\n", sqlite3_errmsg(tmp_db));
		(void)sqlite3_close(tmp_db);
		return ZTE_HTTPSHARE_DB_ERROR_NOT_OPEN_DB;
	}
	*db = tmp_db;
	return ZTE_HTTPSHARE_DB_OK;
}

zte_httpshare_db_result_e_type zte_httpshare_db_close(sqlite3*db)
{
	int rc = 0;

	if (NULL == db) {
		slog(SDCARD_PRINT, SLOG_ERR, "[sdcard-hotplug]httpshare_db_close:invalide inputs.\n");
		return ZTE_HTTPSHARE_DB_ERROR_INVAILD_PTR;
	}
	rc = sqlite3_close(db);
	if (rc) {
		slog(SDCARD_PRINT, SLOG_ERR, "[sdcard-hotplug]httpshare_db_close:can not close db.\n");
		return ZTE_HTTPSHARE_DB_ERROR;
	}
	return ZTE_HTTPSHARE_DB_OK;
}

zte_httpshare_db_result_e_type zte_httpshare_db_exec_sql(const char *sql, sqlite3_callback callback, void *fvarg)
{
	sqlite3* db;
	int rc = 0;

	if (NULL == sql) {
		slog(SDCARD_PRINT, SLOG_ERR, "[sdcard-hotplug]httpshare_db_exec_sql:invalide inputs.\n");
		return ZTE_HTTPSHARE_DB_ERROR_INVAILD_PTR;
	}
	if (0 != zte_httpshare_db_open(&db)) {
		slog(SDCARD_PRINT, SLOG_ERR, "[sdcard-hotplug]httpshare_db_exec_sql:open httpshare.db failed.\n");
		return ZTE_HTTPSHARE_DB_ERROR_NOT_OPEN_DB;
	}
	rc = sqlite3_exec(db, sql, callback, fvarg, NULL);

	slog(SDCARD_PRINT, SLOG_ERR, "[sdcard-hotplug]httpshare_db_exec_sql:%s rc=%d\n", sql, rc);
	if (rc) {
		slog(SDCARD_PRINT, SLOG_ERR, "[sdcard-hotplug]httpshare_db_exec_sql:can not exec sql,sqlite3_errmsg:%s.\n", sqlite3_errmsg(db));
		(void)sqlite3_close(db);
		return ZTE_HTTPSHARE_DB_ERROR;
	}
	(void)zte_httpshare_db_close(db);

	return ZTE_HTTPSHARE_DB_OK;
}

zte_httpshare_db_result_e_type zte_httpshare_create_table()
{
	zte_httpshare_db_result_e_type result = ZTE_HTTPSHARE_DB_OK;

	//create httpshare table
	result = zte_httpshare_db_exec_sql(ZTE_CREATE_TABLE_HTTPSHARE_SQL, NULL, NULL);

	if (ZTE_HTTPSHARE_DB_OK != result) {
		slog(SDCARD_PRINT, SLOG_ERR, "[sdcard-hotplug]httpshare_create_table:create httpshare table result is %d\n", result);
		return result;
	}
	return result;
}


void zte_httpshare_init()
{
	(void)zte_del_file(ZTE_HTTPSHARE_DB_PATH);

	/*ʵҪ·Ŀ¼Ƿڣ򴴽*/
	if (ZTE_HTTPSHARE_SUCCESS != zte_init_sdcard_path()) {
		slog(SDCARD_PRINT, SLOG_ERR, "httpshare_init:%s does not exist.\n", SD_CARD_PATH_PR);
		return;
	}

	/*httpsharedb·*/
	if (ZTE_HTTPSHARE_SUCCESS != zte_httpshare_check_and_creat_dir(ZTE_HTTPSHARE_DB_DIR)) {
		slog(SDCARD_PRINT, SLOG_ERR, "[sdcard-hotplug]httpshare_init:httpshare_check_and_creat_dir HTTPSHARE_DB_DIR fail!\n");
		return;
	}
	/*httpshareı*/
	if (ZTE_HTTPSHARE_DB_OK != zte_httpshare_create_table()) {
		slog(SDCARD_PRINT, SLOG_ERR, "[sdcard-hotplug]httpshare_init:httpshare_create_table fail!\n");
		return;
	}

	zte_init_sdcard_mode();
}


