/************************************************************************
* Ȩ (C)2008, ͨѶɷ޹˾
* 
* ļƣ sms_db.c
* ļʶ 
* ժҪ SMSģݿļ
* ˵ 
* ǰ汾 V0.1
*     ߣ G.F
* ڣ 2008-12-13
* 
* ޸ļ¼1    
* ޸ݣʼ汾
************************************************************************/
#include <stdio.h>
#include <time.h>
#include <limits.h>
#include "sms_db.h"
#include "sms_code.h"
#include "cfg_nv_def.h"

/**************************************************************************
* 
**************************************************************************/

/* 괦 */
typedef sqlite3_callback zte_wms_db_callback;

#define ZTE_WMS_CREATE_TABLE_SMS_SQL        "CREATE TABLE IF NOT EXISTS sms" \
                                            "(id INTEGER PRIMARY KEY AUTOINCREMENT" \
                                            " NOT NULL, ind TEXT,Mem_Store TEXT,Tag" \
                                            " TEXT,Number TEXT,Cc_Sms TEXT,Cc_Ref " \
                                            " TEXT,Cc_Total TEXT, Cc_Seq TEXT,Cc_Num" \
                                            " TEXT,Cc_Content TEXT,Language TEXT,Tp_Dcs" \
                                            " TEXT,Msg_Ref TEXT,Content TEXT, " \
                                            " Sms_Report_Recived TEXT,Draft_Group_Id TEXT,Year TEXT,Month TEXT," \
                                            " Day TEXT,Hour TEXT,Minute TEXT,Second TEXT,TimeZone TEXT,Mktime INTEGER,DisplayMode TEXT);"

#define ZTE_WMS_CREATE_CMD_STATUS_SQL       "CREATE TABLE IF NOT EXISTS cmd_status(Cmd TEXT PRIMARY KEY,Cmd_Status TEXT," \
                                            " Err_Code TEXT,Send_Fail_Count TEXT,Del_Type TEXT," \
                                            " Del_Count TEXT,Del_index TEXT, Failed_Count TEXT,Failed TEXT);"

#define ZTE_WMS_CREATE_SMS_REP_SQL          "CREATE TABLE IF NOT EXISTS sms_report(id INTEGER PRIMARY KEY" \
                                            " AUTOINCREMENT NOT NULL,  address TEXT,content TEXT,Year TEXT,Month TEXT," \
                                            " Day TEXT,Hour TEXT,Minute TEXT,Second TEXT,TimeZone TEXT);"

#define ZTE_WMS_CREATE_PAR_SQL              "CREATE TABLE IF NOT EXISTS parameter(id INT PRIMARY KEY, Sms_Report TEXT, Sms_Sca TEXT, "\
                                            " Mem_Store TEXT,Tp_Validity TEXT,Send_Retry TEXT,Outdate_Delete TEXT,Default_Store TEXT,Max_Cc_Ref TEXT, " \
                                            " Max_Sms_Ref TEXT);"

#define ZTE_WMS_CREATE_INFO_SQL             "CREATE TABLE IF NOT EXISTS sms_info(id INTEGER PRIMARY KEY" \
                                            " AUTOINCREMENT NOT NULL, name TEXT, value TEXT);"

#define ZTE_WMS_CREATE_CELL_BRO_SQL         "CREATE TABLE IF NOT EXISTS cell_bro (id INTEGER PRIMARY KEY" \
                                            " AUTOINCREMENT NOT NULL, msg_content TEXT);"
#define ZTE_WMS_CREATE_SEND_CONTENT_SQL     "CREATE TABLE IF NOT EXISTS send_content (id INTEGER PRIMARY KEY" \
                                            " AUTOINCREMENT NOT NULL, msg_content TEXT);"

#define ZTE_WMS_DROP_ALL_TABLE_SQL          "DROP TABLE IF EXISTS sms;"\
                                            "DROP TABLE IF EXISTS cmd_status;"\
                                            "DROP TABLE IF EXISTS sms_report;"\
                                            "DROP TABLE IF EXISTS parameter;"\
                                            "DROP TABLE IF EXISTS sms_info;"\
                                            "DROP TABLE IF EXISTS cell_bro;"\
                                            "DROP TABLE IF EXISTS send_content;"

#define ZTE_WMS_DROP_TABLE_EXCEPTSMS_SQL    "DROP TABLE IF EXISTS cmd_status;"\
                                            "DROP TABLE IF EXISTS sms_report;"\
                                            "DROP TABLE IF EXISTS parameter;"\
                                            "DROP TABLE IF EXISTS sms_info;"\
                                            "DROP TABLE IF EXISTS cell_bro;"\
                                            "DROP TABLE IF EXISTS send_content;"


#define ZTE_WMS_DEL_SIM_SQL "DELETE FROM sms Where Mem_Store='sim';"
//#define ZTE_WMS_DEL_NV_SQL "DELETE FROM sms Where Mem_Store='nv'"

//90*24*60*60s three month
#define OUTDATEINTERVAL 7776000
/**************************************************************************
* ݽṹ
**************************************************************************/
typedef struct
{
    char *buf_addr;
    int buf_len;
}T_zUfiSms_BufInfo;
typedef struct 
{
    int   valid; 
    char *strSQL;
}T_zUfiSms_SQLMap;

// ݿָ
sqlite3* g_zUfiSms_DbPointer = 0;

extern T_zUfiSms_ParaInfo g_zUfiSms_CurSmsPara;
extern unsigned long g_zUfiSms_StoreCapablity[ZTE_WMS_MEMORY_MAX];
extern T_zUfiSms_DelSms g_zUfiSms_DelMsg;

/**************************************************************************
* static
**************************************************************************/

/**************************************************************************
* ȫֱ
**************************************************************************/

/**************************************************************************
* ʵ
**************************************************************************/
static int  isSucess(T_zUfiSms_DbResult dbRst)
{
    return dbRst == ZTE_WMS_DB_OK ? ZUFI_SUCC : ZUFI_FAIL;
}
time_t zte_getsecond(T_zUfiSms_Date date)
{
    time_t timet;
    struct tm tmtime = {0};//cov
    int tmp_i = 0;
#if 0
    if(atoi(date.year) > 99 || atoi(date.year) < 0)
    {
        printf("[SMS] getsecond error, year out of range: %d!!!", atoi(date.year));
        return 0;
    }
#endif
	tmp_i = atoi(date.year); //kw 3
	if(tmp_i < 0 || tmp_i > INT_MAX-1) { 
		at_print(LOG_ERR,"[SMS]date.year err:%d\n", tmp_i);
		return 0;
	}
    tmtime.tm_year = tmp_i + 2000 - 1900;

	tmp_i = atoi(date.month); //kw 3
	if(tmp_i < 0 || tmp_i > INT_MAX-1) { 
		at_print(LOG_ERR,"[SMS]date.month err:%d\n", tmp_i);
		return 0;
	}
    tmtime.tm_mon = tmp_i - 1;

	tmp_i = atoi(date.day); //kw 3
	if(tmp_i < 0 || tmp_i > INT_MAX-1) { 
		at_print(LOG_ERR,"[SMS]date.day err:%d\n", tmp_i);
		return 0;
	}
    tmtime.tm_mday = tmp_i;

	tmp_i = atoi(date.hour); //kw 3
	if(tmp_i < 0 || tmp_i > INT_MAX-1) { 
		at_print(LOG_ERR,"[SMS]date.hour err:%d\n", tmp_i);
		return 0;
	}
    tmtime.tm_hour = tmp_i;

	tmp_i = atoi(date.min); //kw 3
	if(tmp_i < 0 || tmp_i > INT_MAX-1) { 
		at_print(LOG_ERR,"[SMS]date.min err:%d\n", tmp_i);
		return 0;
	}
    tmtime.tm_min = tmp_i;

	tmp_i = atoi(date.sec); //kw 3
	if(tmp_i < 0 || tmp_i > INT_MAX-1) { 
		at_print(LOG_ERR,"[SMS]date.sec err:%d\n", tmp_i);
		return 0;
	}
    tmtime.tm_sec = tmp_i;
	
    timet = mktime(&tmtime);
    //printf("--------start: %4d/%02d/%02d %02d:%02d:%02d------",1900 + tmtime.tm_year,1 + tmtime.tm_mon,tmtime.tm_mday,tmtime.tm_hour,tmtime.tm_min,tmtime.tm_sec);
    //printf("--------second: %u,date: %s,l: %d,ll: %d ---------",(unsigned int)timet,ctime((time_t *)&timet),sizeof(long),sizeof(long long));	
    return timet;
}
//smsݿ⣬g_zUfiSms_Db
T_zUfiSms_DbResult zUfiSms_OpenDb(void)
{
    int retry_times = 0;
    int open_rst    = SQLITE_ERROR;
    
    if(g_zUfiSms_DbPointer != NULL)   
    {
        sqlite3_close(g_zUfiSms_DbPointer);
        g_zUfiSms_DbPointer = NULL;
    }
    
    do
    {
        open_rst = sqlite3_open(ZTE_WMS_DB_PATH, &g_zUfiSms_DbPointer);
        
    }while(open_rst == SQLITE_CANTOPEN && retry_times++ < 10);
    
    printf("zUfiSms_OpenDb: retry_times = %d, open_rst = %d\n", retry_times, open_rst);
    
    return open_rst == SQLITE_OK ? ZTE_WMS_DB_OK : ZTE_SMS_DB_ERROR_NOT_OPEN_DB;
}
T_zUfiSms_DbResult zUfiSms_CloseDb(void)
{
    if(sqlite3_close(g_zUfiSms_DbPointer) != SQLITE_OK)
    {
        return ZTE_SMS_DB_ERROR;
    }
    g_zUfiSms_DbPointer = NULL;
    return ZTE_WMS_DB_OK;
}

/*  ִһsql **/
T_zUfiSms_DbResult zUfiSms_ExecSql(const char * exec_sql,zte_wms_db_callback callback,void *fvarg)
{
    int try_times = 0;
    int sqlRst    = SQLITE_ERROR;

    while(try_times++ < 10)
    {
        sqlRst = sqlite3_exec(g_zUfiSms_DbPointer, exec_sql, callback, fvarg, NULL);
        if(sqlRst != SQLITE_BUSY && sqlRst != SQLITE_LOCKED && sqlRst != SQLITE_IOERR)
        {
            break;
        }
        printf("zUfiSms_ExecSql: try_times=%d, SQL=%s, Errmsg=%s\n", try_times, exec_sql, sqlite3_errmsg(g_zUfiSms_DbPointer));   
        sleep(1);
    }
    if(sqlRst != SQLITE_OK)
    {
        printf("zUfiSms_ExecSql: try_times=%d, SQL=%s, Errmsg=%s\n", try_times, exec_sql, sqlite3_errmsg(g_zUfiSms_DbPointer)); 
        return ZTE_SMS_DB_ERROR;
    }
    else
    {
#ifdef WEBS_SECURITY
		if(access(ZTE_WMS_TMP1_PATH, F_OK) == 0)
		{
			slog(PB_PRINT,SLOG_ERR,"zUfiSms_ExecSql db stay");
			if(remove(ZTE_WMS_TMP1_PATH) != 0)
			{
				slog(SMS_PRINT,SLOG_ERR,"remove WMS_TMP1_PATH fail");
			}
		}
		{
			char rnum_buf[24] = {0};
			char cmd[128] = {0};
			
			sc_cfg_get("rnum_at", rnum_buf, sizeof(rnum_buf));
			snprintf(cmd, sizeof(cmd), "/bin/openssl enc -e -aes256 -salt -in %s -out %s -pass pass:%s", ZTE_WMS_DB_PATH, ZTE_WMS_TMP1_PATH, rnum_buf);
			zxic_system(cmd);
			if(access(ZTE_WMS_TMP1_PATH, F_OK) == 0)
			{
				if(remove(ZTE_WMS_SEC_PATH) != 0)
				{
					slog(SMS_PRINT,SLOG_ERR,"remove WMS_SEC_PATH fail");
				}
				if(rename(ZTE_WMS_TMP1_PATH, ZTE_WMS_SEC_PATH) != 0)
				{
					slog(SMS_PRINT,SLOG_ERR,"rename WMS_TMP1_PATH fail");
				}
			}
		}
#endif	
        return ZTE_WMS_DB_OK;
    }
}

int zUfiSms_GetFirstColumnInt(void *fvarg, int columns, char **zresult, char **lname)
{
    if(columns >= 1)
    {
        if(zresult[0] == NULL)
        {            
            *(int *)fvarg = 0;
        }
        else
        {
            *(int *)fvarg = atoi(zresult[0]);
        }
        return SQLITE_OK;
    }
    else
    {
        return SQLITE_ERROR;
    }
}

int zUfiSms_SetCmdStatus(T_zUfiSms_StatusInfo *ptSetStatus)
{
	T_zUfiSms_DbResult  result = ZTE_WMS_DB_OK;
    char               *strSQL = NULL;

    printf("[SMS] zUfiSms_SetCmdStatus enter.\n");
    strSQL = sqlite3_mprintf("INSERT OR REPLACE INTO %s(Cmd,Cmd_Status,Err_Code,Send_Fail_Count,Del_Count) " \
                             "VALUES('%d','%d','%d','%d','%d');", 
                             ZTE_WMS_DB_CMD_STATUS_TABLE, 
                             ptSetStatus->cmd, ptSetStatus->cmd_status, ptSetStatus->err_code, 
                             ptSetStatus->send_failed_count, ptSetStatus->delete_failed_count);

    result = zUfiSms_ExecSql(strSQL,NULL,NULL);
    sqlite3_free(strSQL);
    return isSucess(result);
}

void zUfiSms_SetParameterNv(T_zUfiSms_ParaInfo *para)
{
    if(0 == (int)para->status_report_on)
    {
        sc_cfg_set(NV_REPORT_ENABLE,"0");
    }
    else
    {
        sc_cfg_set(NV_REPORT_ENABLE,"1");
    }
    if(0 == (int)para->sendfail_retry_on)
    {
        sc_cfg_set(NV_SENDFAIL_RETRY,"0");
    }
    else
    {
        sc_cfg_set(NV_SENDFAIL_RETRY,"1");
    }
    if(0 == (int)para->outdate_delete_on)
    {
        sc_cfg_set(NV_OUTDATE_DELETE,"0");
    }
    else
    {
        sc_cfg_set(NV_OUTDATE_DELETE,"1");
    }
    if(*(para->default_store) != '\0')
    {
        sc_cfg_set(NV_DEFAULT_STORE,(char*)para->default_store); 
    }

    if(0 == (int)para->mem_store)
    {
        sc_cfg_set(NV_PRA_MEMSTORE,"0");
    }
    else
    {
        sc_cfg_set(NV_PRA_MEMSTORE,"1");
    }
    if(0xFF == (int)para->tp_validity_period)
    {
       sc_cfg_set(NV_SMS_VP,"longest");
    }
    else if(0xAD == (int)para->tp_validity_period)
    {
       sc_cfg_set(NV_SMS_VP,"oneweek");
    }
    else if(0xA7 == (int)para->tp_validity_period)
    {
       sc_cfg_set(NV_SMS_VP,"one_day");
    }
    else if(0x8F == (int)para->tp_validity_period)
    {
       sc_cfg_set(NV_SMS_VP,"twelveh");
    }
    printf("wms_db_set_parameters :: set tp_validity_period %d\n",(int)para->tp_validity_period);
}
/* Ѳݿ⣬ͬµcfg NV **/
int zUfiSms_SetDbParameters(T_zUfiSms_ParaInfo *para)
{
    T_zUfiSms_DbResult result = ZTE_WMS_DB_OK;
    char *strSQL = NULL;
    int   count  = 0;
    
    if(NULL == para)
    {
        return -1;
    }
    
    zUfiSms_ExecSql("SELECT count(*) FROM " ZTE_WMS_DB_PARAMETER_TABLE " WHERE id=1;", zUfiSms_GetFirstColumnInt, &count);
    
    if(count > 0) /*exist*/
    {
        strSQL = sqlite3_mprintf("UPDATE %s SET Sms_Report='%d',Sms_Sca='%q',Mem_Store='%d',Tp_Validity='%d',Send_Retry='%d',Outdate_Delete='%d',Default_Store='%q' WHERE id=1;",
                                 ZTE_WMS_DB_PARAMETER_TABLE,
                                 (int)para->status_report_on,
                                 para->sca,
                                 (int)para->mem_store,
                                 (int)para->tp_validity_period,
                                 (int)para->sendfail_retry_on,
                                 (int)para->outdate_delete_on,
                                 para->default_store,
                                 ZTE_WMS_DB_PARAMETER_TABLE);
    }
    else
    {
        strSQL = sqlite3_mprintf("INSERT INTO %s(id, Sms_Report,Sms_Sca,Mem_Store,Tp_Validity,Send_Retry,Outdate_Delete,Default_Store,Max_Cc_Ref,Max_Sms_Ref) "
                                 "VALUES('1', '%d','%q','%d','%d','%d','%d','%q','0','0');",
                                 ZTE_WMS_DB_PARAMETER_TABLE,
                                 (int)para->status_report_on,
                                 para->sca,
                                 (int)para->mem_store,
                                 (int)para->tp_validity_period,
                                 (int)para->sendfail_retry_on,
                                 (int)para->outdate_delete_on,
                                 para->default_store);
    }
    result = zUfiSms_ExecSql(strSQL,NULL,NULL);
    sqlite3_free(strSQL);
    if (result == ZTE_WMS_DB_OK)
    {
        zUfiSms_SetParameterNv(para);
        return 0;
    }
    return -1;
}

/*ȡ洢db_table֮Ķ*/
int zUfiSms_GetTotalCount(const char *pDbTable,int *pTotalCount)
{
    T_zUfiSms_DbResult  result = ZTE_WMS_DB_OK;
    char               *strSQL = NULL;

    strSQL = sqlite3_mprintf("SELECT count(*) FROM sms WHERE Mem_Store='%q';", pDbTable);
    result = zUfiSms_ExecSql(strSQL, zUfiSms_GetFirstColumnInt, pTotalCount);
    sqlite3_free(strSQL);
    return isSucess(result);
}
// ȡMax_Sms_RefԪֵͨ
int zUfiSms_GetSmsMaxReferInDb(void)
{
    int  max_sms_ref = -1;
    
    zUfiSms_ExecSql("SELECT Max_Sms_Ref FROM " ZTE_WMS_DB_PARAMETER_TABLE " WHERE id = 1;", zUfiSms_GetFirstColumnInt, &max_sms_ref);
    return max_sms_ref;
}
/** ݴ洢λúͶidȡindexseqcontent **/
int zUfiSms_GetConcatInfo(char *mem_store,long id,T_zUfiSms_DbStoreStr *pac,char *content,int len)
{
    sqlite3_stmt *stmt   = NULL;
    char         *strSQL = sqlite3_mprintf("SELECT ind,Cc_Seq,Cc_Content FROM sms WHERE id='%d' AND Mem_Store='%q';", id, mem_store);
    
    
    (void)sqlite3_prepare(g_zUfiSms_DbPointer, strSQL,-1,&stmt,0);
    while(SQLITE_ROW == sqlite3_step(stmt))
    {
    	//klocwork
    	char * column_text = NULL;
    	memset(pac->IndStr, 0, sizeof(pac->IndStr));
		memset(pac->Seg_Seq, 0, sizeof(pac->Seg_Seq));
		if ((column_text = sqlite3_column_text(stmt,0)) != NULL)
        	strncpy(pac->IndStr, column_text, sizeof(pac->FormatInd)-1);
		if ((column_text = sqlite3_column_text(stmt,1)) != NULL)
			strncpy(pac->Seg_Seq, column_text, sizeof(pac->FormatSeq)-1);
		if ((column_text = sqlite3_column_text(stmt,2)) != NULL)
			strncpy(content, column_text, len-1);
        printf("[SMS] teet zUfiSms_GetConcatInfo:%s,%s\n",pac->IndStr,pac->Seg_Seq);
    }
    (void)sqlite3_finalize(stmt);
    
    sqlite3_free(strSQL);
    return 0;
}

/**  һ */
int zUfiSms_UpdateConcatSmsToDb
(
    T_zUfiSms_DbStoreData *db_data,
    const char *mem_store,
    char *format_concat,
    char *content,
    T_zUfiSms_DbStoreStr *pac,
    int concat_num,
    long id
)
{
    char               *sql    = NULL;
    T_zUfiSms_DbResult  result = ZTE_WMS_DB_OK;
    
    sql = sqlite3_mprintf("UPDATE sms SET ind='%s',Tag='%d',Cc_Seq='%s',Cc_Num='%d', "\
                          "Cc_Content='%q',Content='%q',Year='%q',Month='%q', "\
                          "Day='%q',Hour='%q',Minute='%q',Second='%q',TimeZone='%q' "\
                          "WHERE id='%d' AND Mem_Store='%q';",
                          pac->FormatInd,   //index 
                          db_data->tag, //Ѷδ͵
                          pac->FormatSeq,  //еڼ
                          concat_num,  //ܹ
                          format_concat, //ƴӼ
                          content,  //յĶ
                          db_data->julian_date.year,
                          db_data->julian_date.month,
                          db_data->julian_date.day,
                          db_data->julian_date.hour,
                          db_data->julian_date.min,
                          db_data->julian_date.sec,
                          db_data->julian_date.timezone,
                          id,
                          mem_store);
    printf("[SMS] teet zUfiSms_UpdateConcatSmsToDb:%s--%s\n",sql,pac->FormatSeq);    
    result = zUfiSms_ExecSql(sql, NULL, NULL);
    sqlite3_free(sql);
    return isSucess(result);
}
/*һ¶ */
int zUfiSms_InsertConcatSmsToDb
(
    T_zUfiSms_DbStoreData *db_data,
    const char *mem_store,
    char *format_concat,
    char * content,
    T_zUfiSms_DbStoreStr *pac,
    int concat_num
)
{
    char              *sql    = NULL;
    T_zUfiSms_DbResult result = ZTE_WMS_DB_OK;

    sql = sqlite3_mprintf("INSERT INTO sms(ind,Mem_Store,Tag,Number,Cc_Sms,Cc_Ref,Cc_Total,Cc_Seq,Cc_Num,Cc_Content,Tp_Dcs, Msg_Ref," \
                          "Content,Sms_Report_Recived,Draft_Group_Id,Year,Month,Day,Hour,Minute,Second,TimeZone,Mktime,DisplayMode) " \
                          "VALUES(\'%q\',\'%q\', '%d',\'%q\','%d','%d','%d',\'%q\','%d',\'%q\','%d', '%d',\'%q\',\'%q\',\'%q\',\'%q\',\'%q\',\'%q\',\'%q\', \'%q\',\'%q\',\'%q\','%d', '%d');",                         
                          pac->FormatInd,
                          mem_store,
                          db_data->tag,
                          db_data->number,
                          db_data->concat_sms,
                          db_data->concat_info[0],
                          db_data->concat_info[1],
                          pac->FormatSeq,
                          concat_num,
                          format_concat,
                          db_data->tp_dcs,
                          db_data->msg_ref,
                          content,
                          "0",
                          db_data->draft_group_id,
                          db_data->julian_date.year,
                          db_data->julian_date.month,
                          db_data->julian_date.day,
                          db_data->julian_date.hour,
                          db_data->julian_date.min,
                          db_data->julian_date.sec,
                          db_data->julian_date.timezone,
                          (unsigned int)zte_getsecond(db_data->julian_date),
                          db_data->msg_displaymode);

    printf("[SMS] zUfiSms_InsertConcatSmsToDb sql=%s.\n",sql);
    result = zUfiSms_ExecSql(sql,NULL,NULL);
    sqlite3_free(sql);
    return isSucess(result);
}

/*ȡMax_Cc_Refֵͨ*/
int zUfiSms_GetConcatMaxReferInDb(void)
{
    int  ConcatMaxRefer = 0;
    int  result         = 0;

    result = zUfiSms_ExecSql("SELECT Max_Cc_Ref FROM " ZTE_WMS_DB_PARAMETER_TABLE " WHERE id = 1;", zUfiSms_GetFirstColumnInt, &ConcatMaxRefer);
    if(ZTE_WMS_DB_OK != result)
    {
        return -1;
    }
    return ConcatMaxRefer;
}


int zUfiSms_CreateTables()
{
    int                    iMap      = 0;
    const T_zUfiSms_SQLMap SQL_MAP[] =
    {
        { 1, ZTE_WMS_CREATE_TABLE_SMS_SQL    },
        { 1, ZTE_WMS_DEL_SIM_SQL             },
        { 1, ZTE_WMS_CREATE_CMD_STATUS_SQL   },
        { 1, ZTE_WMS_CREATE_SMS_REP_SQL      },
        { 1, ZTE_WMS_CREATE_PAR_SQL          },
        { 1, ZTE_WMS_CREATE_INFO_SQL         },
        { 1, ZTE_WMS_CREATE_CELL_BRO_SQL     },
        { 1, ZTE_WMS_CREATE_SEND_CONTENT_SQL },
    };
    
    for(iMap =0; iMap < sizeof(SQL_MAP)/sizeof(T_zUfiSms_SQLMap); iMap++)
    {
        if(SQL_MAP[iMap].valid == 1)
        {
            if(zUfiSms_ExecSql(SQL_MAP[iMap].strSQL, NULL, NULL) != ZTE_WMS_DB_OK)
            {
                return ZUFI_FAIL;
            }
        }
    }
    return ZUFI_SUCC;
}
/*еݿи*/
int zUfiSms_CreateAllTable (void)
{
    if(ZTE_WMS_DB_OK != zUfiSms_OpenDb())
    {
        printf("[SMS] can not open database.return.\n");
        return ZTE_SMS_DB_ERROR_NOT_OPEN_DB;
    }
    return zUfiSms_CreateTables();
}

int zUfiSms_DropAllTable (void)
{
	T_zUfiSms_DbResult result = ZTE_WMS_DB_OK;    
    
	if(ZTE_WMS_DB_OK != zUfiSms_OpenDb())
    {
        printf("[SMS] can not open database.return.\n");
        return ZTE_SMS_DB_ERROR_NOT_OPEN_DB;
    }  
	result = zUfiSms_ExecSql(ZTE_WMS_DROP_ALL_TABLE_SQL,NULL,NULL);
	printf("[SMS] zUfiSms_DropAllTable: sql = %s, result = %d! \n", ZTE_WMS_DROP_ALL_TABLE_SQL, result);
	return ZUFI_SUCC;
}

int zUfiSms_DropAllTableExceptSms (void)
{
    T_zUfiSms_DbResult result = ZTE_WMS_DB_OK;    
    
    if(ZTE_WMS_DB_OK != zUfiSms_OpenDb())
    {
        printf("[SMS] can not open database.return.\n");
        return ZTE_SMS_DB_ERROR_NOT_OPEN_DB;
    }  
    result = zUfiSms_ExecSql(ZTE_WMS_DROP_TABLE_EXCEPTSMS_SQL, NULL, NULL);
    printf("[SMS] zUfiSms_DropAllTable: sql = %s, result = %d! \n", ZTE_WMS_DROP_ALL_TABLE_SQL, result);
    return ZUFI_SUCC;
}

/* Ƿ 0:Ϊգ1Ϊ **/
int zUfiSms_IsDbEmpty(const char *tab, int *pCount)
{
    T_zUfiSms_DbResult result = ZTE_WMS_DB_OK;
    char *strSQL = sqlite3_mprintf("SELECT count(*) FROM %s;", tab);
    
    result = zUfiSms_ExecSql(strSQL, zUfiSms_GetFirstColumnInt, pCount);
    sqlite3_free(strSQL);
    return isSucess(result);
}
/* ݿpStorePosмһ¼¼ */
int zUfiSms_InsertNormalSmsToDb
(
    T_zUfiSms_DbStoreData *ptDbSaveData,
    const char *pStorePos,
    char *pContent
)
{
    char *strSQL = NULL;
    T_zUfiSms_DbResult result = ZTE_WMS_DB_OK;
		
    strSQL = sqlite3_mprintf("INSERT INTO sms(ind,Mem_Store,Tag,Number,Cc_Sms,Cc_Ref,Cc_Total,Cc_Seq,Tp_Dcs, " \
                             "Msg_Ref,Content,Sms_Report_Recived,Draft_Group_Id,Year,Month,Day,Hour,Minute,Second,TimeZone,Mktime,DisplayMode) VALUES('%d','%q', " \
                             "'%d','%q','%d','%d','%d','%d','%d','%d','%q','%q','%q','%q','%q','%q','%q','%q', " \
                             "'%q','%q','%u', '%d');",
                             ptDbSaveData->index,
                             pStorePos,
                             ptDbSaveData->tag,
                             ptDbSaveData->number,
                             ptDbSaveData->concat_sms,
                             ptDbSaveData->concat_info[0],
                             ptDbSaveData->concat_info[1],
                             ptDbSaveData->concat_info[2],
                             ptDbSaveData->tp_dcs,
                             ptDbSaveData->msg_ref,
                             pContent,
                             "0",
                             ptDbSaveData->draft_group_id,
                             ptDbSaveData->julian_date.year,
                             ptDbSaveData->julian_date.month,
                             ptDbSaveData->julian_date.day,
                             ptDbSaveData->julian_date.hour,
                             ptDbSaveData->julian_date.min,
                             ptDbSaveData->julian_date.sec,
                             ptDbSaveData->julian_date.timezone,
                             (unsigned int)zte_getsecond(ptDbSaveData->julian_date),
                             ptDbSaveData->msg_displaymode);
    printf("[SMS] zUfiSms_InsertNormalSmsToDb sql=%s\n", strSQL);
    result = zUfiSms_ExecSql(strSQL,NULL,NULL);
    sqlite3_free(strSQL);
    return isSucess(result);
}

/*  iSmsIdĴ洢Ϣ  */
int zUfiSms_UpdateNormalSmsToDb
(
    T_zUfiSms_DbStoreData *ptDbSaveData,
    const char *pStorePos,
    char *pContent,
    long iSmsId
)
{
    char               *strSQL = NULL;
    T_zUfiSms_DbResult  result = ZTE_WMS_DB_OK;
     
    strSQL = sqlite3_mprintf("UPDATE sms SET Number='%q',Content='%q',Year='%q',Month='%q', "\
                             "Day='%q',Hour='%q',Minute='%q',Second='%q',TimeZone='%q' "\
                             "WHERE id='%d' and Mem_Store='%q';",
                             ptDbSaveData->number,
                             pContent,
                             ptDbSaveData->julian_date.year,
                             ptDbSaveData->julian_date.month,
                             ptDbSaveData->julian_date.day,
                             ptDbSaveData->julian_date.hour,
                             ptDbSaveData->julian_date.min,
                             ptDbSaveData->julian_date.sec,
                             ptDbSaveData->julian_date.timezone,
                             iSmsId,
                             pStorePos);
    if(NULL == strSQL)
    {
        return ZUFI_FAIL;
    }
    printf("[SMS] zUfiSms_UpdateNormalSmsToDb sql=%s\n",strSQL);
    result = zUfiSms_ExecSql(strSQL,NULL,NULL);
    sqlite3_free(strSQL);
    return isSucess(result);
}
int zUfiSms_GetFirstColumnStr(void *fvarg,int columns, char **zresult,char **lname)
{
    if(columns >= 1 && fvarg != NULL)
    {
        if(zresult[0] != NULL)
        {
            T_zUfiSms_BufInfo *para = (T_zUfiSms_BufInfo *)fvarg;
            
            strncpy(para->buf_addr, zresult[0], para->buf_len-1);
            return SQLITE_OK;
        }
    }
    return SQLITE_ERROR;    
}
/* idȡŵĴ洢λ */
int zUfiSms_GetStorePosById(char *item,char *item_data,int item_len, int id)
{
    T_zUfiSms_DbResult result   = ZTE_WMS_DB_OK;
    T_zUfiSms_BufInfo  buf_info = { 0 };
    char               *strSQL  = NULL;
    
    if(NULL == item || NULL == item_data)
    {
        return ZUFI_FAIL;
    }
    buf_info.buf_addr = item_data;
    buf_info.buf_len  = item_len;
    
    strSQL = sqlite3_mprintf("SELECT %q FROM sms WHERE id='%d';", item, id);
    result = zUfiSms_ExecSql(strSQL, zUfiSms_GetFirstColumnStr, &buf_info);
    sqlite3_free(strSQL);
    
    if((ZTE_WMS_DB_OK != result) || (0 == strcmp(item_data,"")))
    {
        at_print(LOG_ERR,"get table_member by id failed.\n");
        return ZUFI_FAIL;
    }
    return ZUFI_SUCC;
}

int zUfiSms_DeleteSmsInDb(void)
{
    char sql[128] = {0};
    
    snprintf(sql,sizeof(sql),"DELETE FROM sms WHERE Mem_Store='%s' and id='%d';", ZTE_WMS_DB_SIM_TABLE, g_zUfiSms_DelMsg.sim_id[g_zUfiSms_DelMsg.sim_index-1]);
    return isSucess(zUfiSms_ExecSql(sql,NULL,NULL));
}

int zUfiSms_DeleteAllSimSmsInDb(void)
{
    return isSucess(zUfiSms_ExecSql("DELETE FROM sms WHERE Mem_Store='" ZTE_WMS_DB_SIM_TABLE "';", NULL, NULL));
}

/** ɾNVеĶ **/
int zUfiSms_DeleteNvSms(void)
{
	// ɾ
    if(g_zUfiSms_StoreCapablity[ZTE_WMS_MEMORY_NV] == g_zUfiSms_DelMsg.nv_count)
    {
        if(ZTE_WMS_DB_OK != zUfiSms_ExecSql("DELETE FROM sms WHERE Mem_Store='" ZTE_WMS_DB_NV_TABLE "';",NULL,NULL))
        {
            printf("[SMS] zUfiSms_DeleteNvSms:delete fail\n");
            return WMS_CMD_FAILED;
        }
    }
    else
    {
        int  i  = 0;
        printf("[SMS] zUfiSms_DeleteNvSms:delete nv_count=%d\n",g_zUfiSms_DelMsg.nv_count);
        // ɾ
        for(i = 0; i < g_zUfiSms_DelMsg.nv_count; i++)
        {
            char sql[128] = { 0 };
            
            snprintf(sql, sizeof(sql), "DELETE FROM sms WHERE Mem_Store='%s' and id='%d';", ZTE_WMS_DB_NV_TABLE, g_zUfiSms_DelMsg.nv_id[i]);
            if(ZTE_WMS_DB_OK != zUfiSms_ExecSql(sql,NULL,NULL))
            {
                printf("[SMS] sms:exec sql failed,i=%d\n",i);
                return WMS_CMD_FAILED;
            }
        }
    }
    printf("[SMS] zUfiSms_DeleteNvSms:delete success\n");
    return WMS_CMD_SUCCESS;
}

/** ȡŵindֶ,ptModifyTag */
int zUfiSms_GetSmsIndex(int id,T_zUfiSms_ModifyTag *ptModifyTag,int is_cc)
{
    char              sql[128] = { 0 };
    T_zUfiSms_BufInfo buf_info = { 0 };
    char str_index[2 * WMS_MESSAGE_LIST_MAX] = {0};
    
    buf_info.buf_addr = str_index;
    buf_info.buf_len  = sizeof(str_index);
    
    snprintf(sql, sizeof(sql), "SELECT ind FROM sms WHERE id='%d';", id);
    if (zUfiSms_ExecSql(sql, zUfiSms_GetFirstColumnStr, &buf_info) != ZTE_WMS_DB_OK)
    {
        at_print(LOG_ERR,"open table sms failed");
        return ZUFI_FAIL;
    }
    
    if(1 == is_cc)/*concat sms*/
    {
        int    i          = 0;
        int    j          = 0;
        int    count      = 0;
        char **out_result = NULL;
        
        count = zUfiSms_SplitString(str_index,&out_result, ';');
        for(i = 0; i < count; i++)
        {
            if(0 != strcmp(out_result[i],""))
            {
                ptModifyTag->indices[j++] = atoi(out_result[i]);
            }
        }
        ptModifyTag->num_of_indices = j;
        free(out_result);
    }
    else /*normal sms*/
    {
        ptModifyTag->indices[0]     = atoi(str_index);
        ptModifyTag->num_of_indices = 1;
    }
    
    ptModifyTag->total_indices = ptModifyTag->num_of_indices;
    printf("modify_tag_ptr->total_indices=%d\n", ptModifyTag->total_indices);
    return ZUFI_SUCC;
}

/* ǷǼ */
int zUfiSms_IsConcatSms(int id)
{
    char sql[128] = { 0 };
    int  is_cc    = 0;
    T_zUfiSms_DbResult result = ZTE_WMS_DB_OK;
    
    snprintf(sql, sizeof(sql), "SELECT Cc_Sms FROM %s WHERE id='%d';", ZTE_WMS_DB_SMS_TABLE, id);
    result = zUfiSms_ExecSql(sql, zUfiSms_GetFirstColumnInt, &is_cc);
    if(ZTE_WMS_DB_OK != result)
    {
        at_print(LOG_ERR,"open table %s failed", ZTE_WMS_DB_SMS_TABLE);
        return -1;
    }
    return is_cc;
}

/** idtag */
int zUfiSms_UpdateSmsTagInDb(unsigned long id,unsigned int tags)
{
    char sql[128] = { 0 };
    
    snprintf(sql, sizeof(sql), "UPDATE %s SET Tag='%d' WHERE id='%d';", ZTE_WMS_DB_SMS_TABLE, tags, id);
    return isSucess(zUfiSms_ExecSql(sql, NULL, NULL));
}

/** ѯidtag */
int zUfiSms_GetTagCountInDb(T_zUfiSms_MemoryType mem_store, unsigned int tags, int *pTotalCount)
{
    T_zUfiSms_DbResult result = ZTE_WMS_DB_OK;
    char sql[128] = {0};

	if(pTotalCount == NULL)
	{
		return ZUFI_FAIL;
	}
	
	if(mem_store == ZTE_WMS_MEMORY_MAX)
	{
		snprintf(sql,sizeof(sql),"SELECT count(*) FROM %s WHERE Tag='%d';", ZTE_WMS_DB_SMS_TABLE, tags);
	}
	else if(mem_store == ZTE_WMS_MEMORY_NV)
	{
	 	snprintf(sql,sizeof(sql),"SELECT count(*) FROM %s WHERE Mem_Store='%s' AND Tag='%d';", ZTE_WMS_DB_SMS_TABLE, ZTE_WMS_DB_NV_TABLE, tags);
	}
	else
	{
	 	snprintf(sql,sizeof(sql),"SELECT count(*) FROM %s WHERE Mem_Store='%s' AND Tag='%d';", ZTE_WMS_DB_SMS_TABLE, ZTE_WMS_DB_SIM_TABLE, tags);
	}
	
	result = zUfiSms_ExecSql(sql, (zte_wms_db_callback)zUfiSms_GetFirstColumnInt, pTotalCount);
    return isSucess(result);

}

/* ݿɾһ */
int zUfiSms_DeleteDraftSms(long iSmsId)
{
    char sql[128] = { 0 };
    
    snprintf(sql, sizeof(sql), "DELETE FROM %s WHERE id='%ld';",ZTE_WMS_DB_SMS_TABLE, iSmsId);
    return isSucess(zUfiSms_ExecSql(sql,NULL,NULL));
}

/*  洢ŵκ */
int zUfiSms_SetConcatMaxRefer(int ref)
{
    char sql[128] = { 0 };
    
    if(ZTE_WMS_MAX_CONCAT_REF < ref)
    {
        ref = 0;
    }
    
    snprintf(sql,sizeof(sql),"UPDATE %s SET Max_Cc_Ref='%d' WHERE id=1;", ZTE_WMS_DB_PARAMETER_TABLE, ref);
    return isSucess(zUfiSms_ExecSql(sql,NULL,NULL));
}

/**Ŀ*/
int zUfiSms_SetMaxReference(int ref)
{
    char sql[128] = { 0 };
    
    if(ZTE_WMS_MAX_SMS_REF < ref)
    {
        ref = 0;
    }
    
    snprintf(sql,sizeof(sql),"UPDATE %s SET Max_Sms_Ref='%d' WHERE id=1;", ZTE_WMS_DB_PARAMETER_TABLE, ref);
    return isSucess(zUfiSms_ExecSql(sql,NULL,NULL));
}


int zUfiSms_InsertReportStatusToDb(unsigned char *pNumber,T_zUfiSms_Date *ptSmsDate,int iReportStatus)
{
    char               *strSQL = NULL;
    T_zUfiSms_DbResult  result = ZTE_WMS_DB_OK;
    
    strSQL = sqlite3_mprintf("INSERT INTO sms_report(address,content,Year,Month,Day,Hour,Minute,Second,TimeZone) " \
                             "VALUES('%s','%d','%s','%s','%s','%s', '%s','%s','%s');",    
                             pNumber,
                             iReportStatus,
                             ptSmsDate->year,
                             ptSmsDate->month,
                             ptSmsDate->day,
                             ptSmsDate->hour,
                             ptSmsDate->min,
                             ptSmsDate->sec,
                             ptSmsDate->timezone);
    
    result = zUfiSms_ExecSql(strSQL, NULL, NULL);
    sqlite3_free(strSQL);
    return isSucess(result);
}

int zUfiSms_GetFirstColumnParaInfo(void *fvarg,int columns,char **zresult,char **lname)
{
    
    if(columns >= 1 && fvarg != NULL)
    {
        if(zresult[0] != NULL)
        {
            T_zUfiSms_ParaInfo *para = (T_zUfiSms_ParaInfo *)fvarg;
            
            strncpy(para->sca, zresult[0], sizeof(para->sca) - 1);
            para->mem_store = atoi(zresult[1]);
            para->tp_validity_period = atoi(zresult[2]);
            para->status_report_on = atoi(zresult[3]);
            para->sendfail_retry_on = atoi(zresult[4]);
            para->outdate_delete_on = atoi(zresult[5]);
            (void)strncpy(para->default_store,zresult[6],sizeof(para->default_store)-1);
            return SQLITE_OK;
        }
    }
    
    return SQLITE_ERROR;
}

int zUfiSms_GetDbParameters(void)
{
    char *strSQL = "SELECT Sms_Sca,Mem_Store,Tp_Validity,Sms_Report,Send_Retry,Outdate_Delete,Default_Store FROM " ZTE_WMS_DB_PARAMETER_TABLE ";";
    
    memset(&g_zUfiSms_CurSmsPara, 0, sizeof(T_zUfiSms_ParaInfo));
    return isSucess(zUfiSms_ExecSql(strSQL,zUfiSms_GetFirstColumnParaInfo, &g_zUfiSms_CurSmsPara));
}

int zUfiSms_GetSendContent(void *fvarg,int column, char **zresult,char **lname)
{
    T_zUfiSms_BufInfo *para = (T_zUfiSms_BufInfo *)fvarg;

    if(column >= 1 && para != NULL)
	
    (void)strncpy(para->buf_addr,zresult[0],para->buf_len-1);
    return 0;
}

// SqlлȡݣpSmsBuf
int zUfiSms_GetSmsContent(char *pSmsBuf,int len)
{
    T_zUfiSms_BufInfo buf_info = { 0 };
    char             *strSQL   = "SELECT msg_content FROM " ZTE_WMS_DB_SEND_CONTENT_TABLE ";";
    
    buf_info.buf_addr = pSmsBuf;
    buf_info.buf_len  = len;
    memset(buf_info.buf_addr, 0, len);
    
    return isSucess(zUfiSms_ExecSql(strSQL, zUfiSms_GetSendContent, &buf_info));
}

/*  pMemStoreҵptDbSaveDataƥĶ id */
int zUfiSms_SearchConcatSmsInDb(T_zUfiSms_DbStoreData *ptDbSaveData,char *pMemStore)
{
    char         *sql  = NULL;
    sqlite3_stmt *stmt = NULL;
    int           id   = -1;

    switch(ptDbSaveData->tag)
    {
        case WMS_TAG_TYPE_MO_SENT_V01:/*send box*/
        case WMS_TAG_TYPE_MO_NOT_SENT_V01:/*draft box*/
        {
            sql = sqlite3_mprintf("SELECT Cc_Seq,id FROM sms WHERE Number='%q' AND Cc_Ref='%d' AND Cc_Total='%d' AND Mem_Store='%s' AND (Tag = '%d' OR Tag= '%d');",
                                  ptDbSaveData->number,
                                  ptDbSaveData->concat_info[0],
                                  ptDbSaveData->concat_info[1],
                                  pMemStore,
                                  WMS_TAG_TYPE_MO_SENT_V01,
                                  WMS_TAG_TYPE_MO_NOT_SENT_V01);
            break;
        }
        case 4:/*saved box*/
        {
            sql = sqlite3_mprintf("SELECT Cc_Seq,id FROM sms WHERE Number='%q' AND Cc_Ref='%d' AND Cc_Total='%d' AND Mem_Store='%s' AND Tag = '%d';",
                                  ptDbSaveData->number,
                                  ptDbSaveData->concat_info[0],
                                  ptDbSaveData->concat_info[1],
                                  pMemStore,
                                  4);
            break;
        }
        case WMS_TAG_TYPE_MT_READ_V01:/*receive box*/
        case WMS_TAG_TYPE_MT_NOT_READ_V01:/*receive box*/
        {
            sql = sqlite3_mprintf("SELECT Cc_Seq,id FROM sms WHERE Number='%q' AND Cc_Ref='%d' AND Cc_Total='%d' AND Mem_Store='%s' AND (Tag = '%d' OR Tag= '%d');",
                                  ptDbSaveData->number,
                                  ptDbSaveData->concat_info[0],
                                  ptDbSaveData->concat_info[1],
                                  pMemStore,
                                  WMS_TAG_TYPE_MT_READ_V01,
                                  WMS_TAG_TYPE_MT_NOT_READ_V01);
 
            break;
        }
        default:
        {
            sql = sqlite3_mprintf("SELECT Cc_Seq,id FROM sms WHERE Number='%q' AND Cc_Ref='%d' AND Cc_Total='%d' AND Mem_Store='%s';", 
                                  ptDbSaveData->number,
                                  ptDbSaveData->concat_info[0],
                                  ptDbSaveData->concat_info[1],
                                  pMemStore);
            at_print(LOG_ERR,"tag %d is unknown",ptDbSaveData->tag);
            break;
        }
    }
    printf("[SMS] teet:%s\n",sql);

    if(sqlite3_prepare(g_zUfiSms_DbPointer,sql,-1,&stmt,0) != SQLITE_OK)
    {
        at_print(LOG_ERR,"can not exec sql,sqlite3_errmsg:%s.\n",sqlite3_errmsg(g_zUfiSms_DbPointer));
        sqlite3_free(sql);
        return -1;
    }
    while(SQLITE_ROW == sqlite3_step(stmt))
    {
        int j = 0;
        char **out_result = NULL;
		char * column_text = sqlite3_column_text(stmt, 0);
        int count = -1;
		if (column_text != NULL) //klocwork
			count = zUfiSms_SplitString(column_text, &out_result, ';');
        
        for(j = 0; j < count; j++)
        {
            if(0 == strcmp(out_result[j],""))
            {
                if(j+1 == ptDbSaveData->concat_info[2])
                {
                    id = sqlite3_column_int(stmt,1);
                    break;
                }
            }
        }
        
        //if(count != -1)
		if(out_result != NULL)//cov
        {
            free(out_result);
            out_result = NULL;
        }
        
        if(-1 != id)
        {
            break;
        }
    }
    (void)sqlite3_finalize(stmt);
    sqlite3_free(sql);
    return id;
}

int zUfiSms_CheckDbOutdateSms_Callback (void *fvarg, int columns, char **zresult,char **lname)
{
    if(fvarg != NULL && columns >= 1)
    {
        if(zresult[0] != NULL)
        {
            T_zUfiSms_DelReq *result = (T_zUfiSms_DelReq *)fvarg;
            
            result->id[result->all_or_count] = atoi(zresult[0]);
            result->all_or_count++;
            return SQLITE_OK;
        }
    }
    return SQLITE_ERROR;
}

VOID zUfiSms_CheckDbOutdateSms(const char *pDbTable, T_zUfiSms_DelReq *pSmsDel)
{
    char acSql[128] = {0};
    struct timeval tp;

    if (0 != gettimeofday(&tp,NULL))
    {
        printf("[SMS] gettimeofday error!!!");
        return;
    }
    if(tp.tv_sec <= OUTDATEINTERVAL)
    {
        return;
    }
    snprintf(acSql, sizeof(acSql), "SELECT id FROM %s WHERE Mktime<'%u' AND Mem_Store='%s';" ,ZTE_WMS_DB_SMS_TABLE, (unsigned int)(tp.tv_sec -OUTDATEINTERVAL), pDbTable);
    if (ZTE_WMS_DB_OK != zUfiSms_ExecSql(acSql,zUfiSms_CheckDbOutdateSms_Callback, pSmsDel))
    {
        at_print(LOG_ERR,"open table %s failed", ZTE_WMS_DB_CMD_STATUS_TABLE);
        //return ZUFI_FAIL;
    }

    return;
}

int zUfiSms_GetCurrentRecvTotalSeq_Callback(void *fvarg,int column,char **zresult,char **lname)
{
    if(fvarg != NULL && column >= 2)
    {
        if(zresult[0] != NULL && zresult[1] != NULL)
        {
            SMS_MSG_INFO *msg = (SMS_MSG_INFO *)fvarg;

			memset(msg->id, 0, sizeof(msg->id));
			memset(msg->total_seq, 0, sizeof(msg->total_seq));
            strncpy (msg->id, zresult[0], sizeof(msg->id)-1);
            strncpy (msg->total_seq, zresult[1],sizeof(msg->total_seq)-1);
            printf("[SMS][traffic] zUfiSms_GetCurrentRecvTotalSeq_Callback id = %s, total_seq = %s\n", msg->id, msg->total_seq);
            return SQLITE_OK;
        }
    }
    return SQLITE_ERROR;
}

int zUfiSms_GetCurrentRecvTotalSeq(T_zUfiSms_DbStoreData *ptDbSaveData,SMS_MSG_INFO *pmsg)
{
    T_zUfiSms_DbResult result = ZTE_WMS_DB_OK;
    char              *strSQL = NULL;
    
    strSQL = sqlite3_mprintf("SELECT id, Cc_Num FROM sms WHERE  number='%q' AND Cc_Ref='%d' AND Cc_Total='%d';",
                             ptDbSaveData->number, ptDbSaveData->concat_info[0], ptDbSaveData->concat_info[1]);
    printf("[SMS][traffic] zUfiSms_GetCurrentRecvTotalSeq sql : %s \n", strSQL);
    result = zUfiSms_ExecSql(strSQL,zUfiSms_GetCurrentRecvTotalSeq_Callback, pmsg);
    sqlite3_free(strSQL);
    return isSucess(result);
}

