/*
 * Copyright (C) 2008 The Android Open Source Project
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

#ifndef _SOFTAP_CONTROLLER_H
#define _SOFTAP_CONTROLLER_H
#include <stdbool.h>

#include <net/if.h>
#include <wifi_socket.h>
#include <semaphore.h>
#include <rtc_timer.h>

#define SOFTAP_MAX_BUFFER_SIZE	4096
#define AP_BSS_START_DELAY	100000
#define AP_BSS_STOP_DELAY	200000
#define AP_SET_CFG_DELAY	500000
#define AP_DRIVER_START_DELAY	800000
#define AP_CHANNEL_DEFAULT	6

/* Used to retry syscalls that can return EINTR. */
#ifndef TEMP_FAILURE_RETRY
#define TEMP_FAILURE_RETRY(exp) ({           \
	typeof (exp) _rc;                        \
	do{                                      \
		_rc = (exp);                         \
	}while((_rc == -1) && (errno == EINTR)); \
	_rc; })
#endif

#define NVIO_WIFI_LEN_8					8
#define NVIO_WIFI_LEN_16				16
#define NVIO_WIFI_LEN_32				32

typedef struct   wlan_ap_para {
	char wifi_set_flags[NVIO_WIFI_LEN_8];
	char ssid[WIFI_STATION_SSID_LEN];
	char ignore_broadcast_ssid[NVIO_WIFI_LEN_8];
	char auth_mode[WIFI_STATION_AUTH_MODE_LEN];
	char password[WIFI_STATION_SPOT_PASSWORD_LEN];
	char max_num_sta[NVIO_WIFI_LEN_8];
	char wifi_11n_cap[NVIO_WIFI_LEN_8];
	char WirelessMode[NVIO_WIFI_LEN_8];
	char  Channel[NVIO_WIFI_LEN_8];
	char  CountryCode[NVIO_WIFI_LEN_8];
	char  wifi_band[NVIO_WIFI_LEN_8] ;
	char wifi_coverage[NVIO_WIFI_LEN_16];
	char accesspolicy0[NVIO_WIFI_LEN_8];
	char m_ssid[WIFI_STATION_SSID_LEN];
	char m_ignore_broadcast_ssid[NVIO_WIFI_LEN_8];
	char m_auth_mode[WIFI_STATION_AUTH_MODE_LEN];
	char m_password[WIFI_STATION_SPOT_PASSWORD_LEN];
	char m_max_num_sta[NVIO_WIFI_LEN_8];
}basic_para;


typedef struct   wlan_ap_server {
	struct   wlan_socket  sock;
	struct   wlan_socket  sock_m;
	struct   wlan_ap_para  ap_para;
	struct   wlan_drv_proxy  drv_proxy;

	int		ap0_state;		//0 :close   1: open
	int 		ap1_state;
	int 		ap0_wps_state;
	int		ap1_wps_state;
	int 		g_tsw_sleep_flag;//޴ʱ˯ߵrtc timer
	int 		g_tsw_wake_flag;//޴ʱѵrtc timer

	int 		g_sta_num;
	sem_t 	g_hostap_id;
	int 		g_hostap;

	void 		(*drv_insmod)(struct   wlan_ap_server *ap_svr);
	void 		(*init)(struct   wlan_ap_server *ap_svr);
	int 		(*enable)(struct   wlan_ap_server *ap_svr);
	void 		(*disable)(struct   wlan_ap_server *ap_svr);
	void  	(*open)(struct   wlan_ap_server *ap_svr);
	int  		(*setap)(struct   wlan_ap_server *ap_svr);
	int  		(*startap)(struct   wlan_ap_server *ap_svr);
	int		(*stopap)(struct   wlan_ap_server *ap_svr);
	int		(*basic_deal)(struct   wlan_ap_server *ap_svr, int  cmd);
	
}wlan_ap_server_t;


void *hostap_loop (void *param);
#if defined(__MULTI_AP__)
void *hostap_loop_multi(void *param);
#endif


LONG wlan_get_wps_sta();
int captureWlanStaInfo();
void wps_deal (MSG_BUF *pstMsg);
void acl_set_process();
void wps_down (MSG_BUF* pMsg);
void wps_up();
void wlan_ap_open ();
int wifi_fw_mac_config_ssid(struct wlan_ap_server *ap_svr);
void apsta_connect_enable_ap();


#endif
