/**************************************************************************
*
*                  Copyright (c) 2013 ZTE Corporation.
*
***************************************************************************
* ģ   : CcApp
*    : at_proc.c
* ļ :
* ʵֹ : ATͺͽģ麯
*      : syx
*      : V1.0
*  : 2013-01-05
* ˵ :
**************************************************************************/

/**************************************************************************
* ޸ļ¼ :
***************************************************************************/
/**************************************************************************
* ޸ı : 0001
*    :
* ޸ :
* ޸ :
**************************************************************************/

/**************************************************************************
* #include
**************************************************************************/
#include "cc_main.h"
#include "cc_proc.h"
#include "cc_com.h"
#include "cc_at.h"
#include "cc_timer.h"
#include "string.h"
#ifdef TEST_CCAPP
#include "soft_timer.h"
#endif

#include "slic_inf.h"
#include <stdint.h>
#include <linux/volte_drv.h>
#include "voice_lib.h"

#define LOCAL_TEST_CALL_CODE "*#66*#"
#define TZ_TEST_TIMING "*#83781234*#"
typedef enum{
	LocalTestCallST_None = 0,
	LocalTestCallST_Start,
	LocalTestCallST_Ring,
	LocalTestCallST_End
}eLocalTestCallST;
int local_test_call_st = 0;
typedef enum{
	LocalTestCallType_None = 0,
	LocalTestCallType_LOOP
}eLocalTestCallType;
int local_test_call_type = 0;

extern SINT32 g_zCc_AtRspId;

int zCc_find_held_cid(void);
int zCc_find_held_incoming_cid(void);
int zCc_find_all_callout(int slave[ZCC_SLAVES]);
int zCc_talking_count(void);
char *get_local_date_time(void);
char *get_local_datetime(char *buff);


/**************************************************************************
* 
**************************************************************************/

/*  {
    ZCC_S_IDLE_S        = 0,
    ZCC_S_DT_S           ,
    ZCC_S_DACCM_S    ,
    ZCC_S_DIALING_S  ,
    ZCC_S_RINGBACK_S   ,// йе̬
    ZCC_S_BSYT_S       ,
    ZCC_S_TKYT_S       ,
    ZCC_S_SIL_S        ,
    ZCC_S_TALKING_S    ,
    ZCC_S_TRYING_S     ,
    ZCC_S_WAIT_RESOURCE_S ,
} */
const pCcSlaveFsmFunc zCcSlaveFsmFunc[] = {zCc_SIdleState, 
                                                                   zCc_SDtState, 
                                                                   zCc_SDaccmState, 
                                                                   zCc_SDialingState, 
                                                                   zCc_SRingbackState,
                                                                   zCc_SBsyToneState, 
                                                                   zCc_STkytState, 
                                                                   zCc_SSilState, 
                                                                   zCc_STalkingState, 
                                                                   zCc_STryingState,
                                                                   zCc_SWaitResourceState
                        };
    /*
    CB
        *54*KSSSS#     REGISTER         AT+CLCK="AO",1,"SSSS"
        #54*KSSSS#     DeREGISTER      AT+CLCK="AO",0,"SSSS"
        *#54#              QUERY/CHECK    AT+CLCK="AO",2,"SSSS"            not supported---------------------------
        K=1 "AO"; K=2 or K=3 "OI"(ƶûйڳ;ҵ); SSSS password
        *56#     REGISTER         AT+CLCK="AI",1,"SSSS"    Ҫն˷Ĳʽ---------------------------
        #56#     DeREGISTER      AT+CLCK="AI",0,"SSSS"              ---------------------------
    CFU
        *57*DN#     REGISTER         AT+CCFC=0,1,"DN"
        #57#          DeREGISTER      AT+CCFC=0,0
        *#57*DN#   AT+CCFC=0,2            not supported---------------------------
    CFNRy
        *41*DN#     REGISTER         AT+CCFC=2,1,"DN"
        #41#          DeREGISTER      AT+CCFC=2,0
        *#41*DN#   AT+CCFC=2,2            not supported---------------------------
    CFB
        *40*DN#     REGISTER         AT+CCFC=1,1,"DN"
        #40#          DeREGISTER      AT+CCFC=1,0
        *#40*DN#   AT+CCFC=1,2            not supported---------------------------
    CW ( ն˷ )
        *58#     REGISTER         AT+CCWA=0,1 ---------------------------
        #58#     DeREGISTER      AT+CCWA=0,0 ---------------------------
    */
static const T_zCc_ScTab g_zCc_SCTab[] = 
{
    {ZCC_BAOC_REG, 10, 10,         "*54*1"},
    {ZCC_BAOC_DEREG, 10, 10,         "#54*1"},
    {ZCC_BOIC_REG, 10, 10,         "*54*2"},
    {ZCC_BOIC_DEREG, 10, 10,         "#54*2"},
    {ZCC_BOIC_REG, 10, 10,         "*54*3"},
    {ZCC_BOIC_DEREG, 10, 10,         "#54*3"},
    {ZCC_CFU_REG, 6, SC_MAXLEN,          "*57*"},
    {ZCC_CFU_DEREG, 4, 4,            "#57#"},
    {ZCC_CFNRY_REG, 6, SC_MAXLEN,          "*41*"},
    {ZCC_CFNRY_DEREG, 4, 4,            "#41#"},
    {ZCC_CFB_REG, 6, SC_MAXLEN,          "*40*"},
    {ZCC_CFB_DEREG, 4, 4,            "#40#"},
};



T_CC_APP_RecvAtIndItem gCcAppRecvAtIndProc[]=
{
    {MSG_CMD_DSCI_IND, zCc_RecvDsciInd},     
    {MSG_CMD_ZCPI,zCc_RecvZcpiInd}, 
    {MSG_CMD_ZIMSPLUS_IND,zCc_RecvImsplusInd},
    {MSG_CMD_ZVOICECHNL,zCc_RecvZvoiceChnl},
    {MSG_CMD_ATD_DIAL_RSP,zCc_RecvRsp},
    {MSG_CMD_ATA_RSP,zCc_RecvRsp},
    {MSG_CMD_CHUP_RSP,zCc_RecvRsp},
    {MSG_CMD_VTS_RSP,zCc_RecvRsp},
    {MSG_CMD_ZIMSPLUS_RSP,zCc_RecvRsp},
    {MSG_CMD_CLCK_RSP,zCc_RecvRsp},
    {MSG_CMD_CCFC_RSP,zCc_RecvRsp},
    {MSG_CMD_CHLD_RSP,zCc_RecvRsp}
};
 T_CC_APP_AtIndProcItem gCcAppAtIndProc[]=
{
    {MSG_CMD_DSCI_IND, zCc_DsciIndProc},     
    {MSG_CMD_ZCPI,zCc_ZcpiIndProc}, 
    {MSG_CMD_ZIMSPLUS_IND,zCc_ZimsplusProc},
    {MSG_CMD_ZVOICECHNL,zCc_ZvoicechnlProc}
};


SINT32 gCcAppRecvAtIndProcCnt = sizeof(gCcAppRecvAtIndProc)/sizeof(gCcAppRecvAtIndProc[0]);
SINT32 gCcAppRecvAtIndCnt = sizeof(gCcAppAtIndProc)/sizeof(gCcAppAtIndProc[0]);
char g_zCcApp_AtRecvBuf[ZCC_APP_AT_BUF_MAX_LEN+1] = {0};
T_zCc_CurAtCmdInfo * g_Cc_AtIndRspMsg;

VOID zCc_ShowAllSlave(VOID)
{
    UINT8   slave = 0;

    for (slave = 0; slave < ZCC_SLAVES; slave++) // slave[0] 
    {
        ccapp_log(" slave=%d number=%s cid=%d state=%d tone=%d msg=%d held=%d isOut=%d dsci6=%d",
            slave,
            g_Cc_CallDetail.slaveObj[slave].number,
            g_Cc_CallDetail.slaveObj[slave].cid,
            g_Cc_CallDetail.slaveObj[slave].state,
            g_Cc_CallDetail.slaveObj[slave].tone,
            g_Cc_CallDetail.slaveObj[slave].sMsg,
            g_Cc_CallDetail.slaveObj[slave].heldcall,
            g_Cc_CallDetail.slaveObj[slave].is_callout,
            g_Cc_CallDetail.slaveObj[slave].waitDSCI6);
    }
}

VOID zCc_ShowAllSlaveWithTips(const char *tips)
{

    UINT8   slave = 0;

    for (slave = 0; slave < ZCC_SLAVES; slave++) // slave[0] 
    {
        printf/*ccapp_log*/("%s master_state=%d\n        slave=%d number=%s cid=%d state=%d tone=%d msg=%d held=%d isOut=%d dsci6=%d",
            tips, g_Cc_CallDetail.state, 
            slave,
            g_Cc_CallDetail.slaveObj[slave].number,
            g_Cc_CallDetail.slaveObj[slave].cid,
            g_Cc_CallDetail.slaveObj[slave].state,
            g_Cc_CallDetail.slaveObj[slave].tone,
            g_Cc_CallDetail.slaveObj[slave].sMsg,
            g_Cc_CallDetail.slaveObj[slave].heldcall,
            g_Cc_CallDetail.slaveObj[slave].is_callout,
            g_Cc_CallDetail.slaveObj[slave].waitDSCI6);
    }
}


VOID zCc_CheckSlaveState(const char *tips)
{
    UINT8   slave = 0;

    if(g_Cc_CallDetail.old_state != g_Cc_CallDetail.state)
    {
        ccapp_log("=========== %s =============\n           master state %d --> %d",
            tips,
            g_Cc_CallDetail.old_state,
            g_Cc_CallDetail.state);
        g_Cc_CallDetail.old_state = g_Cc_CallDetail.state;
    }

    for (slave = 0; slave < ZCC_SLAVES; slave++) // slave[0] 
    {
        if(g_Cc_CallDetail.slaveObj[slave].old_state != g_Cc_CallDetail.slaveObj[slave].state)
        {
            ccapp_log("=========== %s =============\n           slave=%d state %d --> %d",
                tips,
                slave,
                g_Cc_CallDetail.slaveObj[slave].old_state,
                g_Cc_CallDetail.slaveObj[slave].state);
                
            g_Cc_CallDetail.slaveObj[slave].old_state = g_Cc_CallDetail.slaveObj[slave].state;
        }
    }
}


VOID zCc_ClearDigits(VOID)
{
    g_Cc_CallDetail.dCount = 0;
    memset(g_Cc_CallDetail.digits, 0, sizeof(g_Cc_CallDetail.digits));
    zte_log_append(__FILE__, __LINE__, "zte_ccapp.log","%s  zCc_ClearDigits: digits cleared\n",__FUNCTION__);
}

VOID zCc_InitSlaveObj(UINT8   slave)
{
    memset(&g_Cc_CallDetail.slaveObj[slave], 0, sizeof(T_zCc_SlaveObj));
    if (slave == g_Cc_CallDetail.ringCid)
    {
        g_Cc_CallDetail.ringCid = 0;
    }
}

UINT8 zCc_TalkingCall(UINT8 heldcall)
{
    UINT8   slave = 0, cnt = 0;

    for (slave = 1; slave < ZCC_SLAVES; slave++) // slave[0] 
    {
        if (g_Cc_CallDetail.slaveObj[slave].state == ZCC_S_TALKING_S 
            && g_Cc_CallDetail.slaveObj[slave].heldcall == heldcall
            && g_Cc_CallDetail.slaveObj[slave].waitDSCI6 == 0)
        {
            cnt++;
        }
    }

    return cnt;
}

UINT8 zCc_GetWaitDisc6Slave(VOID)
{
    UINT8   slave = 0, cnt = 0;

    for (slave = 1; slave < ZCC_SLAVES; slave++) // slave[0] 
    {
        if (g_Cc_CallDetail.slaveObj[slave].waitDSCI6 == 1)
        {
            cnt++;
        }
    }
    return cnt;
}

UINT8 zCc_BusyToneAllowed(VOID)
{
    UINT8   slave = 0, cnt = 0;

    for (slave = 0; slave < ZCC_SLAVES; slave++) 
    {
        if (g_Cc_CallDetail.slaveObj[slave].state != ZCC_S_IDLE_S )
        {
            cnt++;
        }
    }
    if ((1 == cnt)//ǰû
        ||(cnt == 2 && g_Cc_CallDetail.ringCid !=0 
          && g_Cc_CallDetail.slaveObj[g_Cc_CallDetail.ringCid].state == ZCC_S_TRYING_S
          && g_Cc_CallDetail.slaveObj[g_Cc_CallDetail.ringCid].tone != ZCC_TONE_CIDCW_A)//ժ̬δ
        ||(cnt == zCc_GetWaitDisc6Slave()+1))//жڵdsci6
    {
        return 1;
    }
    else  
    {
        return 0;
    }
    
}

UINT8 zCc_ActiveCall(VOID)
{
    return zCc_TalkingCall(0);
}

UINT8 zCc_HeldCall(VOID)
{
    return zCc_TalkingCall(1);
}

UINT8 zCc_GetSpecSlave(UINT8 state)
{
    UINT8   slave = 0;

    for (slave = 1; slave < ZCC_SLAVES; slave++) // slave[0] 
    {
        if (g_Cc_CallDetail.slaveObj[slave].state == state && g_Cc_CallDetail.slaveObj[slave].waitDSCI6 == 0)
        {
            return slave;
        }
    }
    return 0;
}

UINT8 zCc_GetSpecSlaveIgnoreWaitDSCI6(UINT8 state)
{
    UINT8   slave = 0;

    for (slave = 1; slave < ZCC_SLAVES; slave++) // slave[0] 
    {
        if (g_Cc_CallDetail.slaveObj[slave].state == state)
        {
            return slave;
        }
    }
    return 0;
}

UINT8 zCc_Find_waitDSCI6_cid(void)
{
    UINT8   slave = 0;

	for (slave = 1; slave < ZCC_SLAVES; slave++) // slave[0] 
    {
        if (g_Cc_CallDetail.slaveObj[slave].state!=ZCC_S_IDLE_S &&
        	g_Cc_CallDetail.slaveObj[slave].waitDSCI6!=0)
        {
            return slave;
        }
    }
    return 0;
}




UINT8 zCc_GetDialingSlave(UINT8 waitDSCI6)
{
    UINT8   slave = 0;

    for (slave = 1; slave < ZCC_SLAVES; slave++) // slave[0] 
    {
        if (g_Cc_CallDetail.slaveObj[slave].state == ZCC_S_DIALING_S )
        {
            if (waitDSCI6)
            {
                if (g_Cc_CallDetail.slaveObj[slave].waitDSCI6 == 0)
                {
                    return slave;
                }
            }
            else
            {
                return slave;
            }
        }
    }
    return 0;
}

UINT8 zCc_GetDiscSlave(UINT8 state)
{
    UINT8   slave = 0;
    UINT8   cnt = 0;

    for (slave = 1; slave < ZCC_SLAVES; slave++) // slave[0] 
    {
        if (g_Cc_CallDetail.slaveObj[slave].sMsg== ZCC_SDISCN_M && g_Cc_CallDetail.slaveObj[slave].waitDSCI6 == 0)
        {
             cnt++;
        }
    }
    return cnt;
}


int  tz_lock_cellid_is_limit_callin()
{
	char cellid_is_lock[4] = {0};

	sc_cfg_get("cellid_is_lock",cellid_is_lock,sizeof(cellid_is_lock));
	if(strcmp(cellid_is_lock, "1") == 0)	
		return 1;

	return 0;
}

int tz_lock_cellid_check_sos_num()
{
	int ret = 0;
	char tz_Mexico_sos_lock_cellid[128] = {0};
	
	ret = strlen(g_Cc_CallDetail.digits);
	sc_cfg_get("tz_Mexico_sos_lock_cellid",tz_Mexico_sos_lock_cellid,sizeof(tz_Mexico_sos_lock_cellid));
	if(ret > 0 && ((g_Cc_CallDetail.digits[ret-1] == '#') || (g_Cc_CallDetail.digits[ret-1] == 'T')))
	{
		return TRUE;
	}
	else if(strstr(tz_Mexico_sos_lock_cellid, g_Cc_CallDetail.digits) != NULL)
	{
		return TRUE;
	}
	else
	{
		return FALSE;
	}
	
}

extern int digit_map_call(char *num);
/* ǰһ·  ֵ УFLASHǰбֻͷţdigitsֻ¼ûĺ룻
 ǰһ·  ֵ УFLASHǰбָ
 Ҫdigits ¼ZCC_FLASH_SIGNû һλ  */
UINT8 zCc_DigitsMatch(VOID)
{
    UINT16  i  = 0;
    UINT8   scSum = sizeof(g_zCc_SCTab)/sizeof(T_zCc_ScTab);

    ccapp_log("zCc_DigitsMatch: digits=%s dCount=%d\n",g_Cc_CallDetail.digits,g_Cc_CallDetail.dCount);
	if(tz_lock_cellid_is_limit_callin())
	{
		if(tz_lock_cellid_check_sos_num() == FALSE)
			return ZCC_MATCHERR;
	}
	
    if (g_Cc_CallDetail.dCount == 0)
    {
    	//ccapp_log("1");
        return ZCC_NO_RESULT;
	}
	
	if(g_Cc_CallDetail.dCount >= 2 && g_Cc_CallDetail.dCount<ZDIAL_NUM_MAX)
	{
		if(g_Cc_CallDetail.digits[0]!=ZCC_FLASH_SIGN &&
			g_Cc_CallDetail.digits[g_Cc_CallDetail.dCount-1]!=ZCC_TIMEOUT_SIGN)
		{
			printf("g_Cc_CallDetail.digits = %s\n",g_Cc_CallDetail.digits);
	    	if(strcmp(LOCAL_TEST_CALL_CODE, g_Cc_CallDetail.digits)==0)
	    	{
	    		//ccapp_log("2");
				local_test_call_type = LocalTestCallType_None;
	    		return ZCC_LOCAL_TEST_CALL;
	    	}
	    	else if(strcmp(TZ_TEST_TIMING, g_Cc_CallDetail.digits)==0)
	    	{
	    		local_test_call_type = LocalTestCallType_LOOP;
				return ZCC_LOCAL_TEST_CALL;
	    	}
	    }

	    if(g_Cc_CallDetail.digits[0]=='*' && g_Cc_CallDetail.digits[1]=='#')
	    {
	    	//ccapp_log("3");
	    	return ZCC_NO_RESULT;
	    }
	}

	if(g_Cc_CallDetail.dCount>=ZDIAL_NUM_MAX)
	{
		//ccapp_log("4");
		return ZCC_MATCHERR;
	}
	
    if(digit_map_call(g_Cc_CallDetail.digits)!=0)
    {
    	ccapp_log("digit_map_call match %s", g_Cc_CallDetail.digits);
    	return ZCC_CALL;
	}
    
    if (g_Cc_CallDetail.digits[0] >= '0' && g_Cc_CallDetail.digits[0] <= '9')
    {
    	//ccapp_log("5");
        return (g_Cc_CallDetail.digits[g_Cc_CallDetail.dCount-1] == '#'
                || g_Cc_CallDetail.digits[g_Cc_CallDetail.dCount-1] == ZCC_TIMEOUT_SIGN
                || g_Cc_CallDetail.dCount == ZDIAL_NUM_MAX)  ? ZCC_CALL : ZCC_NO_RESULT;
    }

    //ccapp_log("6");
    if (g_Cc_CallDetail.digits[0] == ZCC_FLASH_SIGN) //2·
    {
        switch (g_Cc_CallDetail.digits[1])
        {
        case '0':
            return ZCC_FLASH_0;
        case '1':
            return ZCC_FLASH_1;
        case '2':
        case ZCC_TIMEOUT_SIGN:
            return ZCC_FLASH_2;
        case '3':
            return ZCC_FLASH_3;
        case '4':
            return ZCC_FLASH_4;    
        default:
            return ZCC_MATCHERR;
        }
    }

    /*for (i = 0; i<scSum; i++)
    {
        if (strncmp((CHAR *)g_zCc_SCTab[i].sc, (CHAR *)g_Cc_CallDetail.digits, 
            (UINT32)(strlen(g_zCc_SCTab[i].sc)<g_Cc_CallDetail.dCount)?strlen(g_zCc_SCTab[i].sc):g_Cc_CallDetail.dCount) == 0)
        { 
            if (g_Cc_CallDetail.digits[g_Cc_CallDetail.dCount-1] == '#')
            {
                return g_zCc_SCTab[i].scName;
            }
            if (g_Cc_CallDetail.dCount < g_zCc_SCTab[i].scMaxLen)
            {
                return ZCC_NO_RESULT;
            }
            if (g_Cc_CallDetail.dCount == g_zCc_SCTab[i].scMaxLen)
            {
                return ZCC_MATCHERR;
            }
        }
    }*/
	
    if(g_Cc_CallDetail.dCount>=2 && 
    	g_Cc_CallDetail.dCount<ZDIAL_NUM_MAX &&
    	g_Cc_CallDetail.digits[0]=='*')
    {
		if(g_Cc_CallDetail.digits[g_Cc_CallDetail.dCount-1] == '#'
                || g_Cc_CallDetail.digits[g_Cc_CallDetail.dCount-1] == ZCC_TIMEOUT_SIGN)
        {
        	ccapp_log("match special code: %s", g_Cc_CallDetail.digits);
			return ZCC_CALL;
		}
		else
		{
			//ccapp_log("8");
			return ZCC_NO_RESULT;
		}
    }

    //ccapp_log("9");
    return ZCC_MATCHERR;
}

VOID zCc_DigitsMatchRltProc(UINT8   ret)
{
    UINT8   callCnt = 0, slave = 0;
    SINT32  chldret = -1;

    ccapp_log("ret=%d", ret);

    slave = zCc_GetSpecSlave(ZCC_S_DACCM_S);
    switch (ret)
    {
        case ZCC_NO_RESULT:
            sc_timer_create(ZCCAPP_TIMER_DTMF_DETECT,
                        0,
                        ZCCAPP_TIMER_DTMF_INTERVAL,
                        zCcApp_DtmfTimer,
                        NULL);                    
            zte_log_append(__FILE__, __LINE__, "zte_ccapp.log","%s  zCc_DigitsMatchRltProc sc_timer_create zCcApp_DtmfTimer\n",__FUNCTION__);
            return;
            
        case ZCC_CALL:
            g_Cc_CallDetail.slaveObj[slave].sMsg = ZCC_SINV_M;
            g_Cc_CallDetail.slaveObj[slave].state = ZCC_S_DIALING_S;
            if(g_Cc_CallDetail.digits[0]!='*' && (digit_map_call(g_Cc_CallDetail.digits)==0))
            {
	            g_Cc_CallDetail.digits[g_Cc_CallDetail.dCount-1] = 0; 
	            g_Cc_CallDetail.dCount--;
            }
            strcpy(g_Cc_CallDetail.slaveObj[slave].number, g_Cc_CallDetail.digits);
            g_Cc_CallDetail.slaveObj[slave].is_callout = TRUE;
            return;
            
        case ZCC_FLASH_1:
            callCnt = zCc_CallCount();
            if ((1 < callCnt) && (zCc_ActiveCall() == callCnt) )  // ¼βΪconf 
            {
                chldret = zCc_SendAtChldReq(21);
            }
            else //if (1 < callCnt)
            {
    			slave = zCc_GetSpecSlave(ZCC_S_DIALING_S);
    			if(slave)
    			{
    				ccapp_log("zCc_SendAtChldReq(%d) dialing", 10+slave);
					chldret = zCc_SendAtChldReq(10+slave);
					SLIC_Stop_Signal(0,TONE_SIGNAL);
					g_Cc_CallDetail.slaveObj[slave].tone = ZCC_TONE_OFF_A;
					g_Cc_CallDetail.lastTone = ZCC_TONE_OFF_A;
					break;
    			}

				slave = zCc_GetSpecSlave(ZCC_S_RINGBACK_S);
    			if(slave)
    			{
    				ccapp_log("zCc_SendAtChldReq(%d) ringback", 10+slave);
					chldret = zCc_SendAtChldReq(10+slave);
					SLIC_Stop_Signal(0,TONE_SIGNAL);
					g_Cc_CallDetail.slaveObj[slave].tone = ZCC_TONE_OFF_A;
					g_Cc_CallDetail.lastTone = ZCC_TONE_OFF_A;
					break;
    			}

    			ccapp_log("zCc_SendAtChldReq(1)-");
                chldret = zCc_SendAtChldReq(1);
            }
            break;
            
        case ZCC_FLASH_2:
            chldret = zCc_SendAtChldReq(2);
            break;
            
        case ZCC_FLASH_3:
        	if(zCc_talking_count()==1 && zCc_GetSpecSlave(ZCC_S_TRYING_S))  
			{
				// talking + incoming, skip hookflash+3, do nothing
			}
			else
            	chldret = zCc_SendAtChldReq(3);
            break;

        case ZCC_FLASH_4:
        	if( zCc_CallCount()> 1)
        	{
	        	//system("at_cmd AT+ZTOR=2");
	        	//zCcApp_send_message(MSG_CMD_ACTIVE_CALL_TRANSFER, 0, NULL);
	        	//ccapp_log("send MSG_CMD_ACTIVE_CALL_TRANSFER");
	        	chldret = zCc_SendAtChldReq(4); //AT+CHLD=4
        	}
        	else
        		ccapp_log("skip at_cmd AT+ZTOR=2");
        	break;
            
        case ZCC_FLASH_0://ܽ磬ָֹͣ
            SLIC_Stop_Signal(0,0);
            zte_log_append(__FILE__, __LINE__, "zte_ccapp.log","%s  zCc_DigitsMatchRltProc: SLIC_Stop_Signal <---\n",__FUNCTION__);
            zCc_InitSlaveObj(0);
            g_Cc_CallDetail.lastTone = ZCC_TONE_OFF_A;
            SLIC_Start_PCM();  
            zte_log_append(__FILE__, __LINE__, "zte_ccapp.log","%s  zCc_DigitsMatchRltProc: SLIC_Start_PCM <---\n",__FUNCTION__);
            chldret = zCc_SendAtChldReq(0);
            break;
            
        case ZCC_MATCHERR:
            if (g_Cc_CallDetail.digits[0] != ZCC_FLASH_SIGN)
            {
                zCc_ClearDigits();
                if (1 == zCc_BusyToneAllowed() && g_Cc_CallDetail.state == ZCC_M_SEIZE_S)//ʱæ
                {
                    sc_timer_create(ZCCAPP_TIMER_BUSYTONE_DETECT,
                                0,
                                ZCCAPP_TIMER_BUSYTONE_INTERVAL,
                                zCcApp_BusyToneTimer,
                                NULL);              
                    zte_log_append(__FILE__, __LINE__, "zte_ccapp.log","%s  zCc_DigitsMatchRltProc sc_timer_create zCcApp_BusyToneTimer\n",__FUNCTION__);
                    g_Cc_CallDetail.slaveObj[slave].tone = ZCC_TONE_BSY_A;
                    g_Cc_CallDetail.slaveObj[slave].state = ZCC_S_BSYT_S;
                    g_Cc_CallDetail.slaveObj[slave].confcall = 0;
                    g_Cc_CallDetail.slaveObj[slave].heldcall = 0;
                }
                else
                {
    zte_log_append(__FILE__, __LINE__, "zte_ccapp.log","%s  zCc_InitSlaveObj: slaveObj[%d] cleared\n",__FUNCTION__, slave);
                    zCc_InitSlaveObj(slave);
                }
                return;
            }
            break;
            
        default: 
            if (ret >= ZCC_BAOC_REG && ret <= ZCC_CFB_DEREG)// SS slave=1
            {
                g_Cc_CallDetail.slaveObj[slave].sMsg = ZCC_SINV_M;
                g_Cc_CallDetail.slaveObj[slave].state = ZCC_S_IDLE_S;//һᷢchup
            }
            return;
        }   

        zCc_ClearDigits();
        //zCc_InitSlaveObj(slave);
}
#if 0
VOID zCc_PreProcRes(CHAR *pParaLine)
{
    SINT32  flg                                     = 0;
    UINT32  i                                       = 0;
    UINT32  length                                  = 0;
    CHAR    *pSource                                = pParaLine;
    CHAR    *pDest                                  = NULL;

    CHAR    *pStrDestMalloc = (CHAR *)malloc(AT_CMD_MAX);
    if (NULL == pStrDestMalloc)
    {
        zte_log_append(__FILE__, __LINE__, "zte_ccapp.log","%s  zCc_PreProcRes: Malloc failed !!!\n",__FUNCTION__);
        return;
    }
    memset(pStrDestMalloc, 0, AT_CMD_MAX); 

    assert(pParaLine != NULL);
    pDest = pStrDestMalloc;
    length = strlen(pParaLine);
    if (length == 0 || length >= ZAT_MAX_LEN)
    {
        free(pStrDestMalloc);
        return;
    }
    for (i = 0; (i < length )&& (pDest - pStrDestMalloc < AT_CMD_MAX); i++)
    {
        if ('"' == *pSource)
        {
            flg = (0 == flg)?1:0;                           /* ˫ ɾ  */
            if ('"' == *(pSource + 1))                      /* ǺźǺţմռλ */
            {
                *pDest++ = (CHAR)ZAT_NULL_FILL;
            }
        }
        else if ((',' == *pSource) && (0 == flg))
        {
            *pDest++ = ' ';                                 /* ˫Ķţ滻ɿո */
            if (',' == *(pSource + 1))                       /* źţԶŽβմռλ */
            {
                *pDest++ = '9';                             //9ʱ
            }
            else if ('\0' == *(pSource + 1))                 /* źţԶŽβմռλ */
            {
                *pDest++ = (CHAR)ZAT_NULL_FILL;
            }
        }
        else if (('\r' == *pSource) ||('\n' == *pSource))
        {
            pSource++;
        }
        else
        {
            *pDest++ = ((' ' == *pSource) && (1 == flg))?(CHAR)ZAT_SPACE_REPLACE:((('\t' == *pSource) && (1 == flg))?(CHAR)ZAT_TAB_REPLACE:(*pSource));
        }
        pSource++;
    }

    memset(pParaLine, 0, length);                           /* Ԥݿز */
    strcpy(pParaLine, pStrDestMalloc);
    free(pStrDestMalloc);
}
#endif
UINT8 zCc_CallCount(VOID)
{
    UINT8   slave = 0, cnt = 0;

    for (slave = 1; slave < ZCC_SLAVES; slave++)
    {
        if (g_Cc_CallDetail.slaveObj[slave].state != ZCC_S_IDLE_S 
            && g_Cc_CallDetail.slaveObj[slave].waitDSCI6 == 0)
            //&& !(g_Cc_CallDetail.slaveObj[slave].waitDSCI6 == 1
              //&& g_Cc_CallDetail.slaveObj[slave].state ==ZCC_S_TRYING_S))
        {
            cnt++;
        }
    }

    return cnt;
}

UINT8 zCc_FlashClearCall(VOID)
{
    UINT8   slave = 0, cnt = 0;

    for (slave = 1; slave < ZCC_SLAVES; slave++)
    {
        if (g_Cc_CallDetail.slaveObj[slave].state == ZCC_S_DACCM_S//ժatd·ǰ
            || g_Cc_CallDetail.slaveObj[slave].state == ZCC_S_BSYT_S
            || g_Cc_CallDetail.slaveObj[slave].state == ZCC_S_TKYT_S
            || g_Cc_CallDetail.slaveObj[slave].state == ZCC_S_SIL_S//æ
            && g_Cc_CallDetail.slaveObj[slave].waitDSCI6 == 0)
        {
            zCc_InitSlaveObj(slave);
    zte_log_append(__FILE__, __LINE__, "zte_ccapp.log","%s  zCc_InitSlaveObj: slaveObj[%d] cleared\n",__FUNCTION__, slave);
            cnt++;
        }
    }

    return cnt;
}

UINT8 zCc_MoInactiveCall(VOID)
{
    UINT8   slave = 0, cnt = 0;

    for (slave = 0; slave < ZCC_SLAVES; slave++)
    {
        if (g_Cc_CallDetail.slaveObj[slave].state > ZCC_S_IDLE_S 
            && g_Cc_CallDetail.slaveObj[slave].state < ZCC_S_BSYT_S
            && g_Cc_CallDetail.slaveObj[slave].waitDSCI6 == 0)
        {
            cnt++;
        }
    }

    return cnt;
}
UINT8 zCc_MoBeforDialingCall(VOID)
{
    UINT8   slave = 0, cnt = 0;

    for (slave = 0; slave < ZCC_SLAVES; slave++)
    {
    	if (g_Cc_CallDetail.slaveObj[slave].state != ZCC_S_IDLE_S)
    	{
	    	ccapp_log("zCc_MoBeforDialingCall slave[%d]=%d", 
	    		slave, 
	    		g_Cc_CallDetail.slaveObj[slave].state); 
		}
		
        if (g_Cc_CallDetail.slaveObj[slave].state > ZCC_S_IDLE_S
	        && g_Cc_CallDetail.slaveObj[slave].state < ZCC_S_DIALING_S 
            && g_Cc_CallDetail.slaveObj[slave].waitDSCI6 == 0)
        {
            cnt++;
        }
    }

    return cnt;
}

int zCc_GetMoBeforDialingCallCID(VOID)
{
    UINT8   slave = 0, cnt = 0;

    for (slave = 0; slave < ZCC_SLAVES; slave++)
    {
    	if (g_Cc_CallDetail.slaveObj[slave].state != ZCC_S_IDLE_S)
    	{
	    	ccapp_log("zCc_GetMoBeforDialingCallCID slave[%d]=%d", 
	    		slave, 
	    		g_Cc_CallDetail.slaveObj[slave].state); 
		}
		
        if (g_Cc_CallDetail.slaveObj[slave].state > ZCC_S_IDLE_S
	        && g_Cc_CallDetail.slaveObj[slave].state < ZCC_S_DIALING_S 
            && g_Cc_CallDetail.slaveObj[slave].waitDSCI6 == 0)
        {
            return slave;
        }
    }

    return -1;
}


int zCc_findCID_by_number(const char *number)
{
    UINT8   slave = 0, len = 0;
    char slave_number[ZDIAL_NUM_MAX];

    for (slave = 1; slave < ZCC_SLAVES; slave++)
    {
    	if (g_Cc_CallDetail.slaveObj[slave].state != ZCC_S_IDLE_S)
    	{
	    	ccapp_log("zCc_findCID_by_number[%s] slave[%d]=%d num=%s", 
	    		number,
	    		slave, 
	    		g_Cc_CallDetail.slaveObj[slave].state,
	    		g_Cc_CallDetail.slaveObj[slave].number); 
		}

		strcpy(slave_number, g_Cc_CallDetail.slaveObj[slave].number);
		len = strlen(slave_number);
		if(len>0)
		{
    		if(slave_number[len-1]=='T')
    		    slave_number[len-1]='\0';
		}
		   
        if (strcmp(slave_number, number)==0)
            return slave;
    }

    return 0;
}

int check_incoming_call_is_in_slave(MSG_BUF *ptMsgBuf)
{
	T_zCcApp_DsciInd tDiscInd = {0};
    memcpy(&tDiscInd, (T_zCcApp_DsciInd*)ptMsgBuf->aucDataBuf, sizeof(T_zCcApp_DsciInd));

    if(tDiscInd.cid==0)
    	return 0;

    return zCc_findCID_by_number(tDiscInd.num);
}


UINT8 zCc_MtInactiveCall(VOID)
{
    UINT8   slave = 0, cnt = 0;

    for (slave = 0; slave < ZCC_SLAVES; slave++)
    {
        if (g_Cc_CallDetail.slaveObj[slave].state == ZCC_S_TRYING_S 
            || g_Cc_CallDetail.slaveObj[slave].state == ZCC_S_WAIT_RESOURCE_S)
            //&& g_Cc_CallDetail.slaveObj[slave].waitDSCI6 == 0)
        {
            cnt++;
        }
    }

    return cnt;
}
UINT8 zCc_GetCallSlave(UINT8 heldcall)//·ʵ
{
    UINT8   slave = 0;

    for (slave = 1; slave < ZCC_SLAVES; slave++) // slave[0] 
    {
        if (g_Cc_CallDetail.slaveObj[slave].state == ZCC_S_TALKING_S 
            && g_Cc_CallDetail.slaveObj[slave].heldcall == heldcall
            && g_Cc_CallDetail.slaveObj[slave].waitDSCI6 == 0)
        {
			return slave;
        }
    }
    return 0;
}

VOID zCc_ControlTone(VOID)
{
    T_zCc_Tone            tone = ZCC_TONE_OFF_A;   /* What tone to play */
    SIGNAL_DATA  tSig;
    memset(tSig.cid, 0, 32);
    UINT8   slave = 0;

    for (slave = 0; slave < ZCC_SLAVES; slave++)
    {
        if (g_Cc_CallDetail.slaveObj[slave].tone != ZCC_TONE_OFF_A)
        {
            tone = g_Cc_CallDetail.slaveObj[slave].tone;
            break;
        }
    }
    printf("[ccapp_debug]:zCc_ControlTone,cur_tone=%d, last_tone=%d\n",tone,g_Cc_CallDetail.lastTone);
    if (g_Cc_CallDetail.lastTone == tone || ZCC_TONE_OFF_A == tone)
    {
        return;
    }

    if(local_test_call_st != 0)
    {
		g_Cc_CallDetail.lastTone = tone;
		return ;
    }

    switch (tone)
    {
    case ZCC_TONE_DIAL_A:
        if (g_Cc_CallDetail.lastTone == ZCC_TONE_CIDCW_A)//಻
        {
            SLIC_Stop_PCM();
        zte_log_append(__FILE__, __LINE__, "zte_ccapp.log","%s  zCc_ControlTone: SLIC_Stop_PCM <---\n",__FUNCTION__);
        }
        tSig.signal_type= TONE_SIGNAL;
        tSig.tone_type = TONE_DIAL;
        SLIC_Play_Signal(0, 0, &tSig);
        zte_log_append(__FILE__, __LINE__, "zte_ccapp.log","%s  zCc_ControlTone: SLIC_Play_Signal TONE_DIAL<---\n",__FUNCTION__);
        break;
    case ZCC_TONE_RB_A:
        tSig.signal_type= TONE_SIGNAL;
        tSig.tone_type = TONE_RINGBACK;
        SLIC_Play_Signal(0, 0, &tSig);
        zte_log_append(__FILE__, __LINE__, "zte_ccapp.log","%s  zCc_ControlTone: SLIC_Play_Signal ZCC_TONE_RB_A<---\n",__FUNCTION__);
        break;
    case ZCC_TONE_BSY_A:
        tSig.signal_type= TONE_SIGNAL;
        tSig.tone_type = TONE_BUSY;
        SLIC_Play_Signal(0, 0, &tSig);
        zte_log_append(__FILE__, __LINE__, "zte_ccapp.log","%s  zCc_ControlTone: SLIC_Play_Signal TONE_BUSY<---\n",__FUNCTION__);
        break;
    case ZCC_TONE_SIL_A:     
        SLIC_Stop_Signal(0, TONE_SIGNAL);
        zte_log_append(__FILE__, __LINE__, "zte_ccapp.log","%s  zCc_ControlTone: SLIC_Stop_Signal <---\n",__FUNCTION__);
        break;
    case ZCC_TONE_CIDCW_A:
    	memset(&tSig, 0, sizeof(tSig));
        tSig.signal_type= TONE_SIGNAL;
        tSig.tone_type = TONE_CW;
        //memcpy(tSig.cid, g_Cc_CallDetail.number, strlen(g_Cc_CallDetail.number));
        strncpy(tSig.cid, g_Cc_CallDetail.number, sizeof(tSig.cid)-1);
        zte_log_append(__FILE__, __LINE__, "zte_ccapp.log","%s  zCc_ControlTone ZCC_TONE_CIDCW_A,number = %s\n",__FUNCTION__,g_Cc_CallDetail.number);
        zCc_sleep(100);
        SLIC_Play_Signal(0, 0, &tSig);
        zte_log_append(__FILE__, __LINE__, "zte_ccapp.log","%s  zCc_ControlTone: SLIC_Play_Signal TONE_CW<---\n",__FUNCTION__);
        break;
    case ZCC_TONE_TKY_A:
        tSig.signal_type= TONE_SIGNAL;
        tSig.tone_type = TONE_TKY;
        SLIC_Play_Signal(0, 0, &tSig);
        zte_log_append(__FILE__, __LINE__, "zte_ccapp.log","%s  zCc_ControlTone: SLIC_Play_Signal TONE_TKY<---\n",__FUNCTION__);
        break;
    }
    g_Cc_CallDetail.lastTone = tone;

}
void zCcApp_SetAtChnlCmdId(E_CC_APP_AtReqCmdId AtCmdId)
{
     g_Cc_CallDetail.curAtCmdId = AtCmdId;
}
VOID zCc_SendSsReq(PSTR pAtCmdPara)
{
    CHAR pw[5] = {0};
    CHAR dn[ZDIAL_NUM_MAX] = {0};
    UINT8   scSum = sizeof(g_zCc_SCTab)/sizeof(T_zCc_ScTab);
    UINT8 scName = 0;
    UINT8 i = 0;
    T_zCcapp_ClckReq tclckreq = {0};
    T_zCcapp_CcfcReq tccfcreq = {0};

    for (i = 0; i<scSum; i++)
    {
        if (strncmp((CHAR *)g_zCc_SCTab[i].sc, (CHAR *)g_Cc_CallDetail.digits, 
            (UINT32)(strlen(g_zCc_SCTab[i].sc)<g_Cc_CallDetail.dCount)?strlen(g_zCc_SCTab[i].sc):g_Cc_CallDetail.dCount) == 0)
        {
            scName = g_zCc_SCTab[i].scName;
            break;
        }
    }
    switch(scName)
    {
        case ZCC_BAOC_REG:
            sscanf(pAtCmdPara, "%*5s%4s#", pw);
            pw[4] = '\0';
            tclckreq.type = 0;//AO
            tclckreq.act = 1;
            strncpy(tclckreq.pw,pw,sizeof(tclckreq.pw)-1);
            break;
        case ZCC_BAOC_DEREG:
            sscanf(pAtCmdPara, "%*5s%4s#", pw);
            pw[4] = '\0';
            tclckreq.type = 0;//AO
            tclckreq.act = 0;
            strncpy(tclckreq.pw,pw,sizeof(tclckreq.pw)-1);
            break;
        case ZCC_BOIC_REG: 
            sscanf(pAtCmdPara, "%*5s%4s#", pw);
            pw[4] = '\0';
            tclckreq.type = 1;//OI
            tclckreq.act = 1;
            strncpy(tclckreq.pw,pw,sizeof(tclckreq.pw)-1);
            break;
        case ZCC_BOIC_DEREG:
            sscanf(pAtCmdPara, "%*5s%4s#", pw);
            pw[4] = '\0';
            tclckreq.type = 1;//OI
            tclckreq.act = 0;
            strncpy(tclckreq.pw,pw,sizeof(tclckreq.pw)-1);
            break;
        case ZCC_CFU_REG:
            sscanf(pAtCmdPara, "%*4s%47s#", dn);
            dn[strlen(dn)-1] = '\0';
            tccfcreq.type = 0;
            tccfcreq.act = 1;
            strncpy(tccfcreq.dn, dn, strlen(dn));
            break;
        case ZCC_CFU_DEREG:
            tccfcreq.type = 0;
            tccfcreq.act = 0;
            break;
        case ZCC_CFNRY_REG:
            sscanf(pAtCmdPara, "%*4s%47s#", dn);
            dn[strlen(dn)-1] = '\0';
            tccfcreq.type = 2;
            tccfcreq.act = 1;
            strncpy(tccfcreq.dn, dn, strlen(dn));
            break;
        case ZCC_CFNRY_DEREG:
            tccfcreq.type = 2;
            tccfcreq.act = 0;
            break;
        case ZCC_CFB_REG:
            sscanf(pAtCmdPara, "%*4s%47s#", dn);
            dn[strlen(dn)-1] = '\0';
            tccfcreq.type = 1;
            tccfcreq.act = 1;
            strncpy(tccfcreq.dn, dn, strlen(dn));
            break;
        case ZCC_CFB_DEREG:
            tccfcreq.type = 1;
            tccfcreq.act = 0;
            break;
    }
        
    
    if (scName > ZCC_BOIC_DEREG)
    {
        zCcApp_Ccfc(&tccfcreq);
    }
    else
    {
        zCcApp_Clck(&tclckreq);
    }
        
}

VOID zCc_SendAtDialReq(PSTR pAtCmdPara)
{
    UINT8 slave =0;

    //ccapp_log("pAtCmdPara=%s len=%s", pAtCmdPara, strlen(pAtCmdPara));

    if (strlen(pAtCmdPara)+1 > ZDIAL_NUM_MAX)
    {
        return;
    }
    else if (strlen(pAtCmdPara) <= 2)
    {
        slave = zCc_GetDialingSlave(1);
        if (1 == zCc_BusyToneAllowed() && g_Cc_CallDetail.slaveObj[slave].waitDSCI6 == 0 && g_Cc_CallDetail.state == ZCC_M_SEIZE_S)//ѹһʱæ
        {
            sc_timer_create(ZCCAPP_TIMER_BUSYTONE_DETECT,
                        0,
                        ZCCAPP_TIMER_BUSYTONE_INTERVAL,
                        zCcApp_BusyToneTimer,
                        NULL);  
            zte_log_append(__FILE__, __LINE__, "zte_ccapp.log","%s  zCc_SendAtDialReq sc_timer_create zCcApp_BusyToneTimer\n",__FUNCTION__);
            g_Cc_CallDetail.slaveObj[slave].tone = ZCC_TONE_BSY_A;
            g_Cc_CallDetail.slaveObj[slave].state = ZCC_S_BSYT_S;
            g_Cc_CallDetail.slaveObj[slave].confcall = 0;
            g_Cc_CallDetail.slaveObj[slave].heldcall = 0;
        }
        else
        {           
        	int index;
            zCc_InitSlaveObj(slave);
    zte_log_append(__FILE__, __LINE__, "zte_ccapp.log","%s  zCc_InitSlaveObj: slaveObj[%d] cleared\n",__FUNCTION__, slave);
			index = zCc_find_held_cid();  // hookflash + onekey and dtmf timeout
			if(index!=0)
				zCc_SendAtChldReq(2);
        }
        return;
    }
    g_Cc_CallDetail.curAtCmdId  = CC_APP_AT_CMD_REQ_D;
    zte_log_append(__FILE__, __LINE__, "zte_ccapp.log","%s  zCc_SendAtDialReq:AtcmdMsg = %s\n",__FUNCTION__,pAtCmdPara);
    zCcApp_Dial((char *)pAtCmdPara);
    
}

VOID zCc_SendAtAnswerReq(VOID)
{
    zte_log_append(__FILE__, __LINE__, "zte_ccapp.log","%s  zCc_SendAtAnswerReq\n",__FUNCTION__);
    g_Cc_CallDetail.curAtCmdId = CC_APP_AT_CMD_REQ_A;
    zCcApp_Answer();
}

VOID zCc_SendAtHangupReq(VOID)
{
    zte_log_append(__FILE__, __LINE__, "zte_ccapp.log","%s  zCc_SendAtHangupReq\n",__FUNCTION__);
    g_Cc_CallDetail.curAtCmdId = CC_APP_AT_CMD_REQ_CHUP;
    zCcApp_Chup();
}

VOID zCc_SendAtDtmfReq(char* dtmfchar)
{
    g_Cc_CallDetail.curAtCmdId  = CC_APP_AT_CMD_REQ_VTS;
    zCcApp_Vts(dtmfchar);
}

VOID zCc_SendAtImsPlusReq(int rate, int setfg)
{
 zte_log_append(__FILE__, __LINE__, "zte_ccapp.log","%s  zCc_SendAtImsPlusReq\n",__FUNCTION__);
    g_Cc_CallDetail.curAtCmdId = CC_APP_AT_CMD_REQ_IMSPLUS;
    zCcApp_SetImsPlus(rate, setfg);
}
#if 0
VOID zCc_SendAtVolumnReq(PSTR pAtCmdPara)
{
    CHAR AtcmdMsg[ZAT_PARAM_LEN50]   = {0};

    if (pAtCmdPara[0] == 0 || strlen(pAtCmdPara)+1 > ZDIAL_NUM_MAX)
    {
        return;
    }
    g_Cc_CallDetail.curAtCmdId  = CC_APP_AT_CMD_REQ_VTS;
    sprintf(AtcmdMsg, "AT+VTS=\"%s\",20\r\n", pAtCmdPara);
    printf( "--->  ccApp zCc_SendAtDtmfReq:AtcmdMsg = %s\n", AtcmdMsg);
    zCcApp_Vts(AtcmdMsg);
}
#endif
SINT32 zCc_SendAtChldReq(int chldtype)
{
    SINT32 ret = -1;

    if (g_Cc_CallDetail.digits[0] == ZCC_FLASH_SIGN)
    {
        zCc_ClearDigits();
    }
    sc_timer_delete(ZCCAPP_TIMER_SSDIALTONE_DETECT);
    g_Cc_CallDetail.curAtCmdId  = CC_APP_AT_CMD_REQ_SET_CHLD;
    ret = zCcApp_Chld(chldtype);
    return ret;
}

VOID zCc_SendLedInformMsg(VOID)
{
    int lRet = -1;
    int lTgtMsgID = 0;
    MSG_BUF stMsg;
    LONG msgSize = sizeof(MSG_BUF) - sizeof(LONG); 

#ifndef TEST_CCAPP
    lTgtMsgID = msgget(MODULE_ID_MMI, 0);
    if (-1 == lTgtMsgID) 
    {
        zte_log_append(__FILE__, __LINE__, "zte_ccapp.log","%s  zCc_SendLedInformMsg msgget MMI fail\n",__FUNCTION__);
        return;
    }
    
    memset(&stMsg, 0, sizeof(MSG_BUF));
    stMsg.ulMagic = MSG_MAGIC_WORD;
    stMsg.lMsgType = MSG_TYPE_DEFAULT;
    stMsg.src_id = MODULE_ID_CALL_CTRL;
    stMsg.dst_id = MODULE_ID_MMI;
    stMsg.usMsgCmd = MSG_CMD_VOIP_STATUS_INFO;
    stMsg.usDataLen = 0;
    lRet = msgsnd(lTgtMsgID, &stMsg, msgSize, IPC_NOWAIT);
    if (lRet < 0)
    {        
        zte_log_append(__FILE__, __LINE__, "zte_ccapp.log","%s  zCc_SendLedInformMsg msgsnd to MMI fail\n",__FUNCTION__);
        return;
    }
#endif
}

VOID zCc_SetLedStatus(char* LedStatus)
{
    
#ifndef TEST_CCAPP
    sc_cfg_set("voip_status", LedStatus);
#endif
    zCc_SendLedInformMsg();
    zte_log_append(__FILE__, __LINE__, "zte_ccapp.log","%s  zCc_SetLedStatus = %s\n",__FUNCTION__,LedStatus);
}

SINT32 zCc_RecvDsciInd(MSG_BUF *ptMsgBuf)
{    
    zte_log_append(__FILE__, __LINE__, "zte_ccapp.log","RECV dsciind!!!<---\n");
    //ptMsgBuf->usMsgCmd   = ZCC_NO_E;
    //ptMsgBuf->usMsgCmd = ZCCAPP_ATIND_DSCI;
    //ptMsgBuf->usSourceModuleID = MSG_ID_CALL_CTRL;
    
    zCc_SendMsgToSub(ptMsgBuf); /* ߳ */ 
    return 0;
}

int is_onecall_in_help_and_ready_to_input_new_call(void)
{
    int i;
    if(zCc_find_held_cid()==0)
        return 0;

    for(i=0;i<ZCC_SLAVES;i++)   // should start from 0, it'll be 0 when hookflash comes but not input any key
        if(g_Cc_CallDetail.slaveObj[i].state==ZCC_S_DT_S || 
            g_Cc_CallDetail.slaveObj[i].state==ZCC_S_DACCM_S)
            return 1;
    
    return 0;
}

void tz_lock_cellid_active_for_call(int state)
{
	static int old_state = -1;
	static int cellid_active_count = 0;
	char tz_lock_cellid_active[4] = {0};

	sc_cfg_get("tz_lock_cellid_active",tz_lock_cellid_active,sizeof(tz_lock_cellid_active));
	if(strcmp(tz_lock_cellid_active, "1") == 0)
		return;
	
	if((old_state == 3) && (state == 0) && (cellid_active_count < 3))
	{
		cellid_active_count++;
		if(cellid_active_count == 3)
		{
			sc_cfg_set("tz_lock_cellid_call_active", "1");
		}
	}
	old_state = state;
	return;
}

SINT32 zCc_DsciIndProc(MSG_BUF *ptMsgBuf)
{
    int inMpty = 0;
    int cid = 0;
    int state = 0;
    int dir = 0;
    CHAR num[ZDIAL_NUM_MAX]   = {0}; 
    CHAR voip_status[ZDIAL_NUM_MAX] = {0};
    T_zCcApp_DsciInd tDiscInd = {0};

    int n;
    int slave_callout[ZCC_SLAVES];

    memcpy(&tDiscInd, (T_zCcApp_DsciInd*)ptMsgBuf->aucDataBuf, sizeof(T_zCcApp_DsciInd));
    cid = tDiscInd.cid;
    inMpty = tDiscInd.inMpty;
    dir = tDiscInd.dir;
    state = tDiscInd.state;
    strncpy(num, tDiscInd.num,sizeof(num)-1);
    zte_log_append(__FILE__, __LINE__, "zte_ccapp.log","%s RECV dsciind: cid=%d num=%s dir=%d inMpty=%d state=%d !!!<---\n",
        __FUNCTION__, cid, num, dir,inMpty,state);
    zCc_ShowAllSlave();
    
    if (cid < ZCC_MINCID || cid > ZCC_MAXCID)
    {
        return 0;
    }
    if (num[0] < 0)
    {
        memset(num,0,ZDIAL_NUM_MAX);
    }
    ptMsgBuf->dst_id = cid;
	tz_lock_cellid_active_for_call(state);
    switch(state)
    { 
    case 0://Z_MMIACC_CALL_STATE_ACTIVE
        if (g_Cc_CallDetail.slaveObj[cid].state == ZCC_S_TALKING_S)//held->active
        {
            SLIC_Start_PCM();
            zte_log_append(__FILE__, __LINE__, "zte_ccapp.log","%s  zCc_DsciIndProc: SLIC_Start_PCM <---\n",__FUNCTION__);

            if (g_Cc_CallDetail.lastTone == ZCC_TONE_DIAL_A
           && g_Cc_CallDetail.slaveObj[0].tone == ZCC_TONE_DIAL_A)
            {
                SLIC_Stop_Signal(0, TONE_SIGNAL);
                zte_log_append(__FILE__, __LINE__, "zte_ccapp.log","%s  zCc_DsciIndProc: SLIC_Stop_Signal <---\n",__FUNCTION__);
                g_Cc_CallDetail.lastTone = ZCC_TONE_OFF_A;      
                zte_log_append(__FILE__, __LINE__, "zte_ccapp.log","%s  zCc_DsciIndProc handling zCc_InitSlaveObj(0)\n",__FUNCTION__);
                zCc_InitSlaveObj(0);                
            }
            g_Cc_CallDetail.slaveObj[cid].heldcall = 0;
            g_Cc_CallDetail.slaveObj[cid].confcall = inMpty;
        }
        else
        {
            ptMsgBuf->usMsgCmd = ZCC_SANS_E;
        }
        	
#ifndef TEST_CCAPP
		sc_cfg_get("voip_status",voip_status,sizeof(voip_status));
		if (0 != strcmp("ledon" , voip_status))
#endif
        {
            zCc_SetLedStatus("ledon");
        }
        break;
    case 1://Z_MMIACC_CALL_STATE_HELD
        if (g_Cc_CallDetail.slaveObj[cid].state == ZCC_S_TALKING_S)//active->held
        {
            if (1 == zCc_CallCount())
            {
                //SLIC_Stop_PCM();
            } 
            g_Cc_CallDetail.slaveObj[cid].heldcall = 1;
            g_Cc_CallDetail.slaveObj[cid].confcall = inMpty;

        }
        break;
    case 3://Z_MMIACC_CALL_STATE_MO_ALERTING
        ptMsgBuf->usMsgCmd = ZCC_SRING_E;
        break;
    case 4://Z_MMIACC_CALL_STATE_MT_INCOMING
		 if(tz_lock_cellid_is_limit_callin())
		 {
			 zCc_SendAtChldReq(10+cid);
			 break;
		 }
		 
        if(g_Cc_CallDetail.state==ZCC_M_SEIZE_S)    
        {
        	int cnt;

        	cnt= zCc_CallCount();
        	ccapp_log("cnt=%d slave[0]=%d", cnt, g_Cc_CallDetail.slaveObj[0].state);
        	
			if(cnt==0)			// hookoff but not dail out utill dtmf-timer timeout
			{	
				if(ZCC_S_BSYT_S<=g_Cc_CallDetail.slaveObj[0].state &&
					g_Cc_CallDetail.slaveObj[0].state<=ZCC_S_SIL_S)
				{
					zCc_SendAtChldReq(10+cid);
	                break;
                }
			}
        	
            if(zCc_GetSpecSlaveIgnoreWaitDSCI6(ZCC_S_BSYT_S)||
                zCc_GetSpecSlaveIgnoreWaitDSCI6(ZCC_S_TKYT_S)||   	// fast dududu is being ....
                zCc_GetSpecSlaveIgnoreWaitDSCI6(ZCC_S_SIL_S))		// fast dududu is end ....
            {
                zCc_SendAtChldReq(10+cid);
                break;
            }
        }
		else if(g_Cc_CallDetail.state==ZCC_M_RELEASE_S) 
        {
        	int dsci6_cid = zCc_Find_waitDSCI6_cid();
			if(dsci6_cid!=0 && dsci6_cid==cid)
			{
                zCc_SendAtChldReq(10+cid);
                zCc_InitSlaveObj(cid);
                ccapp_log("zCc_Find_waitDSCI6_cid and skip this call %s", num);

                char temp[200];
                sprintf(temp, "echo \"%s get error incoming call cid=%d num=%s\" > /tmp/log.ccapp.callin.err",
                	get_local_date_time(), cid, num);
                soft_system(temp);
                break;
            }
        }
        
        ptMsgBuf->usMsgCmd = ZCC_SINVITE_E;
        memset(g_Cc_CallDetail.number, 0, sizeof(g_Cc_CallDetail.number));
        memcpy(g_Cc_CallDetail.number, num, ZDIAL_NUM_MAX);
        break;
    case 5://Z_MMIACC_CALL_STATE_MT_WAITING
        if(g_Cc_CallDetail.state==ZCC_M_RINGING_S && zCc_find_held_cid())
        {
            zCc_SendAtChldReq(10+cid);
            break;
        }
        else if(is_onecall_in_help_and_ready_to_input_new_call())
        {
            zCc_SendAtChldReq(10+cid);
            break;
        }
        
        if(zCc_CallCount()>=2)
        {
            zCc_SendAtChldReq(10+cid);
            break;
        }
        
        ptMsgBuf->usMsgCmd = ZCC_CIDCW_E;
        memset(g_Cc_CallDetail.number, 0, sizeof(g_Cc_CallDetail.number));
        memcpy(g_Cc_CallDetail.number, num, ZDIAL_NUM_MAX);
        break;
    case 6://Z_MMIACC_CALL_STATE_END
    	zCcApp_Vts_CleanReq();
    	if(zCc_findCID_by_number(num)==0)
    		break;
    	
        ptMsgBuf->usMsgCmd = dir?ZCC_SDISCN_MT_E: ZCC_SDISCN_MO_E;
        g_Cc_CallDetail.chupSent = 0;

		memset(slave_callout, 0, sizeof(slave_callout));
		n = zCc_find_all_callout(slave_callout);
		
        ccapp_log("DscInd 6, dir=%d is_callout=%d, find_all_callout=%d", 
        		dir, 
        		g_Cc_CallDetail.slaveObj[cid].is_callout,
        		n);

        if(dir==0 && g_Cc_CallDetail.slaveObj[cid].is_callout == TRUE) 
        {
        	if(n<1 || (n==1 && slave_callout[0]==cid))
        		SLIC_PolarityReverse(0, FALSE);
        }
        
        if ((cid == g_Cc_CallDetail.ringCid) && (ZCC_TONE_CIDCW_A == g_Cc_CallDetail.lastTone))
        {
            SLIC_Stop_Signal(0, 0);//ֹͣеȴ
            zte_log_append(__FILE__, __LINE__, "zte_ccapp.log","%s  zCc_DsciIndProc: SLIC_Stop_Signal <---\n",__FUNCTION__);
            g_Cc_CallDetail.slaveObj[0].tone = ZCC_TONE_OFF_A;
            g_Cc_CallDetail.lastTone = ZCC_TONE_OFF_A;
        }
        
        break;
      case 2://Z_MMIACC_CALL_STATE_MO_DIALING
        ptMsgBuf->usMsgCmd = ZCC_SDIALLING_E;
        break;
    case 7://Z_MMIACC_CALL_STATE_MT_CONNREQ
    case 8://Z_MMIACC_CALL_STATE_DISC
    default:
        break;
    }
    return 0;
}



SINT32 zCc_RecvZvoiceChnl(MSG_BUF *ptMsgBuf)
{
    zte_log_append(__FILE__, __LINE__, "zte_ccapp.log","RECV zvoicechnl!!!<---\n");
    //if (g_Cc_CallDetail.state == ZCC_M_RELEASE_S)
    //{
    //    return 0;
    //}
    printf("[ccapp_debug]:recv zvoicechnl and send to local cc\n");

    //ptMsgBuf->usMsgCmd   = ZCC_NO_E;
    //ptMsgBuf->usMsgCmd = ZCCAPP_ATIND_IMSPLUS;
    //ptMsgBuf->usSourceModuleID = MSG_ID_CALL_CTRL;
    
    zCc_SendMsgToSub(ptMsgBuf); /* ߳ */ 
    return 0;
}



SINT32 zCc_RecvImsplusInd(MSG_BUF *ptMsgBuf)
{
    zte_log_append(__FILE__, __LINE__, "zte_ccapp.log","RECV imsplusind!!!<---\n");
    //if (g_Cc_CallDetail.state == ZCC_M_RELEASE_S)
    //{
    //    return 0;
    //}
     printf("[ccapp_debug]:recv imsplus and send to local cc\n");

    //ptMsgBuf->usMsgCmd   = ZCC_NO_E;
    //ptMsgBuf->usMsgCmd = ZCCAPP_ATIND_IMSPLUS;
    //ptMsgBuf->usSourceModuleID = MSG_ID_CALL_CTRL;
    
    zCc_SendMsgToSub(ptMsgBuf); /* ߳ */ 
    return 0;
}
SINT32 zCc_RecvRsp(MSG_BUF *ptMsgBuf)
{
    zte_log_append(__FILE__, __LINE__, "zte_ccapp.log","RECV at_rsp %d !!!<---\n", ptMsgBuf->usMsgCmd);
    
    zCc_SendMsgToSub(ptMsgBuf); /* ߳ */ 
    return 0;
}

static inline unsigned char zCc_MapVoiceChnlAct(unsigned char  act)
{
    if (act == 3)
    {
        return  0; //gsm
    }
    else if (act == 5)
    {
        return 2; //wcdma
    }
    else if (act == 15)
    {
        return 1;
    }
    else
    {
        assert(0);
    }
	return 3;
}

static unsigned char  g_zCc_VoiceOpenSucc = 1;

static  T_Voice_Para   g_zCc_VoicePara_bak;

static  unsigned int   g_zCc_pcm_bak = 0; /*new add*/

SINT32 zCc_ZvoicechnlProc(MSG_BUF *ptMsgBuf)
{
    T_zCcApp_VoiceChnl  tVoiceChnl;
    T_Voice_Para    tVoicePara = {0};
    memcpy(&tVoiceChnl, (T_zCcApp_VoiceChnl*)ptMsgBuf->aucDataBuf, sizeof(T_zCcApp_VoiceChnl));

    tVoicePara.mode = zCc_MapVoiceChnlAct(tVoiceChnl.act);
    tVoicePara.codec_type = tVoiceChnl.codetype; //0-nb, 1-wb
    if ( tVoicePara.codec_type == 1)
        tVoicePara.clock_rate = 16000;
    else
        tVoicePara.clock_rate = 8000;

    tVoicePara.codec_path = tVoiceChnl.amrpath;
        
    printf("[ccapp_debug]:recv zvoicechnl, tVoicePara=%d,%d,%d,%d\n",tVoicePara.clock_rate,tVoicePara.mode,tVoicePara.codec_type,tVoicePara.codec_path);
    if (tVoiceChnl.op == 1)
    {
    /*  new add begin*/
        //start voice
        if (/*voice_open(&tVoicePara) != 0 ||*/ g_Cc_CallDetail.state == ZCC_M_RINGING_S)
        {
            printf("[ccapp]:voice open fail");//voiceʧܣ̬յzvoicechnlΪʧ
            g_zCc_VoiceOpenSucc = 0;
            g_zCc_VoicePara_bak = tVoicePara;
        }
	  else if (g_Cc_CallDetail.state == ZCC_M_SEIZE_S)
        {

            if ( voice_open(&tVoicePara) != 0)

            {

                printf("[ccapp_debug]:mo call voice_open fail!!!\n");

                voice_close(&tVoicePara);

            }

        }
/*  new add end*/
        printf("[ccapp_debug]:voice_open:rlt=%d\n",g_zCc_VoiceOpenSucc);

    }
    else
    {
        //close voice
        g_zCc_VoiceOpenSucc = 1;
        voice_close(&tVoicePara);
        printf("[ccapp_debug]:voice_close:rlt=%d\n",g_zCc_VoiceOpenSucc);

    }
	return 0;
}





SINT32 zCc_ZimsplusProc(MSG_BUF *ptMsgBuf)
{
    int act = 0;
    int rate = 0;  
    T_zCcApp_ImsplusInd tImsplusInd = {0};

    memcpy(&tImsplusInd, (T_zCcApp_ImsplusInd*)ptMsgBuf->aucDataBuf, sizeof(T_zCcApp_ImsplusInd));
    act = tImsplusInd.act;
    rate = tImsplusInd.rate;
    zte_log_append(__FILE__, __LINE__, "zte_ccapp.log","%s  zCc_ZimsplusProc: act = %d  rate = %d new!!!<---\n",__FUNCTION__, act, rate);
    printf("[ccapp_debug]:recv imsplus, tImsplusInd=%d,%d\n",tImsplusInd.act,tImsplusInd.rate);

 
    if (act == 0)
    {
        SLIC_Stop_PCM();
    zte_log_append(__FILE__, __LINE__, "zte_ccapp.log","%s  zCc_ZimsplusProc: SLIC_Stop_PCM <---\n",__FUNCTION__);
    }
    else if (act == 1)
    { 
        /*  new add begin*/
        if ( g_Cc_CallDetail.state == ZCC_M_RINGING_S)
        {
            g_zCc_pcm_bak =  rate;
            return 0;
        }
        /*  new add end */

        if (rate == 8000)
        {
            SLIC_PCM_Set_NB();
    zte_log_append(__FILE__, __LINE__, "zte_ccapp.log","%s  zCc_ZimsplusProc: SLIC_PCM_Set_NB <---\n",__FUNCTION__);
            SLIC_Start_PCM();
    zte_log_append(__FILE__, __LINE__, "zte_ccapp.log","%s  zCc_ZimsplusProc: SLIC_Start_PCM <---\n",__FUNCTION__);
        }
        else if (rate == 16000)
        {
            SLIC_PCM_Set_WB();
    zte_log_append(__FILE__, __LINE__, "zte_ccapp.log","%s  zCc_ZimsplusProc: SLIC_PCM_Set_WB <---\n",__FUNCTION__);
            SLIC_Start_PCM();
    zte_log_append(__FILE__, __LINE__, "zte_ccapp.log","%s  zCc_ZimsplusProc: SLIC_Start_PCM <---\n",__FUNCTION__);
        }
    }
    else if (act == 2)//رpcműػ
    {
        if (ZCC_S_RINGBACK_S != g_Cc_CallDetail.slaveObj[rate].state)
        {
    zte_log_append(__FILE__, __LINE__, "zte_ccapp.log","%s  zCc_ZimsplusProc: act 2,cid err <---\n",__FUNCTION__);
            return 0; 
        }
        SLIC_Stop_PCM();
        zte_log_append(__FILE__, __LINE__, "zte_ccapp.log","%s  zCc_ZimsplusProc: SLIC_Stop_PCM <---\n",__FUNCTION__);
        g_Cc_CallDetail.slaveObj[rate].tone = ZCC_TONE_RB_A;
    }
    else if (act == 3)//act1ϱԴʱpcm
    {
        SLIC_Stop_Signal(0,0);
        zte_log_append(__FILE__, __LINE__, "zte_ccapp.log","%s  zCc_ZimsplusProc: SLIC_Stop_Signal <---\n",__FUNCTION__);
              
        zCc_SendAtImsPlusReq(rate,0);
        g_Cc_CallDetail.slaveObj[rate].tone = ZCC_TONE_OFF_A;
    }
    return 0;
}
SINT32 zCc_RecvZcpiInd(MSG_BUF *ptMsgBuf)
{
    //ptMsgBuf->usMsgCmd = ZCCAPP_ATIND_ZCPI;
    zte_log_append(__FILE__, __LINE__, "zte_ccapp.log","RECV zcpiind!!!<---\n");
    //ptMsgBuf->usSourceModuleID = MSG_ID_CALL_CTRL;
    zCc_SendMsgToSub(ptMsgBuf); /* ߳ */ 
    return 0;
}

SINT32 zCc_ZcpiIndProc(MSG_BUF *ptMsgBuf)
{
    int              state = 0;
    int              cid   = 0;
    int              progdsp   = 0;
    T_zCcApp_ZcpiInd tZcpiInd = {0};

    memcpy(&tZcpiInd, (T_zCcApp_ZcpiInd*)ptMsgBuf->aucDataBuf, sizeof(T_zCcApp_ZcpiInd));
    state = tZcpiInd.state;
    cid = tZcpiInd.cid;
    progdsp = tZcpiInd.progdsp;

    zte_log_append(__FILE__, __LINE__, "zte_ccapp.log","%s  zCc_ZcpiIndProc: cid= %d, state=%d, progdsp=%d  <---\n",__FUNCTION__,cid,state,progdsp);
    if (5 == state)
    {   
        ptMsgBuf->dst_id = cid;
        ptMsgBuf->usMsgCmd = ZCC_RESOURCE_READY_E;
        g_Cc_CallDetail.resourceReady = 1;
    }
    else if (6 == state)
    {
        g_Cc_CallDetail.resourceReady = 0;
    }

    if (8 == progdsp)
    {
        SLIC_Start_PCM();
    }

    return 0;
}

LONG zCcApp_send_message(unsigned short Msg_cmd,unsigned short us_DataLen,unsigned char *pData)
{
    ipc_send_message(MODULE_ID_CALL_CTRL, MODULE_ID_AT_CTL, Msg_cmd, us_DataLen, (unsigned char *)pData,0);    
    zte_log_append(__FILE__, __LINE__, "zte_ccapp.log","%s  ipc_send_message:Msg_cmd is %d<---\n",__FUNCTION__, Msg_cmd);

    return 0;
}

VOID zCcApp_Dial(char *ptMsgBuf)
{
    SINT32 ret = -1;
    MSG_BUF stMsg;
    LONG msgSize =  sizeof(MSG_BUF)-sizeof(LONG);   
    T_zCcapp_CallMoReq tcallReq = {0};

	memset(tcallReq.number, 0, sizeof(tcallReq.number));
    //strncpy(tcallReq.number, ptMsgBuf,strlen(ptMsgBuf));
    strncpy(tcallReq.number, ptMsgBuf,sizeof(tcallReq.number)-1);
    zCcApp_send_message(MSG_CMD_ATD_DIAL_REQ, sizeof(T_zCcapp_CallMoReq), (unsigned char *) &tcallReq);
    zte_log_append(__FILE__, __LINE__, "zte_ccapp.log","%s  ipc_send_message:Msg is  MSG_CMD_ATD_DIAL_REQ<---\n",__FUNCTION__);

}
SINT32 zCcApp_Ccfc(T_zCcapp_CcfcReq *ptccfcreq)
{
    SINT32 ret = -1;  
    MSG_BUF stMsg;
    LONG msgSize =  sizeof(MSG_BUF)-sizeof(LONG);    
  
    zCcApp_send_message(MSG_CMD_CCFC_REQ, sizeof(T_zCcapp_CcfcReq), (unsigned char *) ptccfcreq);
    zte_log_append(__FILE__, __LINE__, "zte_ccapp.log","%s  ipc_send_message:Msg is MSG_CMD_CCFC_REQ<---\n",__FUNCTION__);

    return 0;
}
SINT32 zCcApp_Clck(T_zCcapp_ClckReq *ptclckreq)
{
    SINT32 ret = -1;
    MSG_BUF stMsg;
    LONG msgSize =  sizeof(MSG_BUF)-sizeof(LONG);    
  
    zCcApp_send_message( MSG_CMD_CLCK_REQ, sizeof(T_zCcapp_ClckReq), (unsigned char *) ptclckreq);
    zte_log_append(__FILE__, __LINE__, "zte_ccapp.log","%s  ipc_send_message:Msg is MSG_CMD_CLCK_REQ<---\n",__FUNCTION__);

    return 0;
}

SINT32 zCcApp_Answer(VOID)
{
    SINT32 ret = -1;
    MSG_BUF stMsg;
    LONG msgSize =  sizeof(MSG_BUF)-sizeof(LONG);    
  
    zCcApp_send_message(MSG_CMD_ATA_REQ, 0, NULL);
    zte_log_append(__FILE__, __LINE__, "zte_ccapp.log","%s  ipc_send_message:Msg is MSG_CMD_ATA_REQ<---\n",__FUNCTION__);

    return 0;
}

SINT32 zCcApp_Chup(void)
{
    SINT32 ret = -1;
    MSG_BUF stMsg;
    LONG msgSize =  sizeof(MSG_BUF)-sizeof(LONG);    
  
    zCcApp_send_message(MSG_CMD_CHUP_REQ, 0, NULL);
    zte_log_append(__FILE__, __LINE__, "zte_ccapp.log","%s  ipc_send_message:Msg isMSG_CMD_CHUP_REQ<---\n",__FUNCTION__);

    return 0;
}

//һVTSûյOKǰVTSȫյһOKʱ·һ
//main̴߳軥
typedef struct {
	struct list_head list;
	T_zCcapp_VtsReq vts;
}T_zCcapp_VtsReq_list;

static LIST_HEAD(ccapp_vts_waitqueue);
static int ccapp_vts_flag = 0;

void zCcApp_Vts_CleanReq(void)
{
	struct list_head *head = &ccapp_vts_waitqueue;
	T_zCcapp_VtsReq_list *l, *tmp;
	
	if(!list_empty(head))
	{
		list_for_each_entry_safe(l, tmp, head, list)
		{
			list_del(&l->list);
			free(l);
		}
		ccapp_vts_flag = 0;
	}
}

void zCcApp_Vts_Rsp(void)
{
	struct list_head *head = &ccapp_vts_waitqueue;
	printf("[ccapp_debug]:Vts_Rsp flag=%d\n",ccapp_vts_flag);
	if(list_empty(head))
	{
		ccapp_vts_flag = 0;
	}
	else
	{
		T_zCcapp_VtsReq_list *node = list_entry(head->next,T_zCcapp_VtsReq_list,list);
		
		zCcApp_send_message(MSG_CMD_VTS_REQ, sizeof(T_zCcapp_VtsReq), (unsigned char *) &node->vts);
		ccapp_vts_flag = 1;
		list_del(&node->list);
		free(node);
	}
}

SINT32 zCcApp_Vts(char* dtmfchar)
{
    T_zCcapp_VtsReq tvtsreq = {0};
	struct list_head *head = &ccapp_vts_waitqueue;
	
    zte_log_append(__FILE__, __LINE__, "zte_ccapp.log","vtschar=%s<---\n",dtmfchar);
    tvtsreq.dtmfchar=*dtmfchar;
	printf("[ccapp_debug]:Vts_Req flag=%d\n",ccapp_vts_flag);
	if(list_empty(head) && ccapp_vts_flag == 0)
	{
		zCcApp_send_message(MSG_CMD_VTS_REQ, sizeof(T_zCcapp_VtsReq), (unsigned char *) &tvtsreq);
		ccapp_vts_flag = 1;
	}
	else
	{
		T_zCcapp_VtsReq_list *node = (T_zCcapp_VtsReq_list *)malloc(sizeof(T_zCcapp_VtsReq_list));
		if(node == NULL)
		{
			printf("[ccapp_debug]: zCcApp_Vts malloc fail!!!\n");
			return 0;
		}
		memset(node, 0 , sizeof(T_zCcapp_VtsReq_list));
		node->vts.dtmfchar = tvtsreq.dtmfchar;
		list_add_tail(&node->list,head);
	}
    zte_log_append(__FILE__, __LINE__, "zte_ccapp.log","%s  ipc_send_message:Msg is MSG_CMD_VTS_REQ<---\n",__FUNCTION__);

    return 0;
}
SINT32 zCcApp_SetImsPlus(int rate, int setfg)
{
    SINT32 ret = -1;
    MSG_BUF stMsg;
    LONG msgSize =  sizeof(MSG_BUF)-sizeof(LONG);   
    T_zCcapp_ImsplusReq timsplusreq= {0};

    timsplusreq.act = rate;
    timsplusreq.setfg = setfg;
    
    zCcApp_send_message(MSG_CMD_ZIMSPLUS_REQ, sizeof(T_zCcapp_ImsplusReq), (unsigned char *) &timsplusreq);
    zte_log_append(__FILE__, __LINE__, "zte_ccapp.log","%s  ipc_send_message:Msg is MSG_CMD_ZIMSPLUS_REQ<---\n",__FUNCTION__);

    return 0;
}

SINT32 zCcApp_Chld(int chldtype)
{
    SINT32 ret = -1;
    MSG_BUF stMsg;
    LONG msgSize =  sizeof(MSG_BUF)-sizeof(LONG);  
    
    T_zCcapp_ChldReq tchldreq = {0};

    tchldreq.type = chldtype;
  
    zCcApp_send_message(MSG_CMD_CHLD_REQ, sizeof(T_zCcapp_ChldReq), (unsigned char *) &tchldreq);
    zte_log_append(__FILE__, __LINE__, "zte_ccapp.log","%s  ipc_send_message:Msg is MSG_CMD_CHLD_REQ[%d]<---\n",__FUNCTION__,chldtype);

    return 0;
}

SINT32 zCcApp_AtIndRspProc(MSG_BUF *ptMsgBuf)
{
    SINT32 i ;
    SINT32 ret  = -1;
    for(i=0;i< gCcAppRecvAtIndProcCnt;i++)
    {
        if(ptMsgBuf->usMsgCmd == gCcAppRecvAtIndProc[i].AtIndCmd)
        {
            if(NULL!= gCcAppRecvAtIndProc[i].RecvAtIndProcFun)
            {
                ret = gCcAppRecvAtIndProc[i].RecvAtIndProcFun(ptMsgBuf);
            }
            break;
        }
    }
    
    return ret;
}
VOID zCc_MReleaseState(MSG_BUF *ptMsgBuf)
{
	CHAR voip_status[ZDIAL_NUM_MAX] = {0};
	zte_log_append(__FILE__, __LINE__, "zte_ccapp.log","%s  zCc_MReleaseState ptMsgBuf->usMsgCmd = %d\n",__FUNCTION__,ptMsgBuf->usMsgCmd);

       printf("[ccapp_debug]: Release State Recv MsgCmd: %d\n",ptMsgBuf->usMsgCmd);

    switch (ptMsgBuf->usMsgCmd)
    {
    case ZCC_SEIZE_E: // ժ
        // slave[0] to play dial tone
        g_Cc_CallDetail.evt[0] = ZCC_DIAL_E;
        g_Cc_CallDetail.state = ZCC_M_SEIZE_S;     
        g_Cc_CallDetail.chupSent = FALSE;
        g_Cc_CallDetail.hookofffg = TRUE;
        if (g_Cc_CallDetail.ringCid)// ܾȴԴ״̬incoming call
        {
            zCc_SendAtHangupReq();
            g_Cc_CallDetail.slaveObj[g_Cc_CallDetail.ringCid].waitDSCI6 = 1;
        } 
         
#ifndef TEST_CCAPP
		sc_cfg_get("voip_status",voip_status,sizeof(voip_status));

        if (0 != strcmp("ledblink" , voip_status))
#endif
        {
            zCc_SetLedStatus("ledblink");
        }   
        break;

    case ZCC_SINVITE_E:
        g_Cc_CallDetail.evt[ptMsgBuf->dst_id] = ZCC_SINVITE_E;
        //g_Cc_CallDetail.state = ZCC_M_RINGING_S; ȷԴǨ״̬
        break;

    case ZCC_RESOURCE_READY_E:
    	ccapp_log("g_Cc_CallDetail.ringCid=%d", g_Cc_CallDetail.ringCid);
        if (g_Cc_CallDetail.ringCid)
        {
            g_Cc_CallDetail.evt[g_Cc_CallDetail.ringCid] = ZCC_RESOURCE_READY_E;
        }
        break;

    case ZCC_SDISCN_MO_E:
    case ZCC_SDISCN_MT_E:
        g_Cc_CallDetail.evt[ptMsgBuf->dst_id] = ptMsgBuf->usMsgCmd;
        break;

    case ZCC_RELEASE_E:
    case ZCC_FLASH_E:
    default:
        // do nothing
        break;
    }
}

pthread_t slic_ring_test_pid;	
void* slic_ring_test_thread(void * ptr)
{
	SIGNAL_DATA tSig;
	while(1)
	{
		sleep(30);
		printf("ring stop\n");
		SLIC_Stop_Signal(0, RING_SIGNAL);
		zCc_SetLedStatus("ledoff");

		sleep(30);
		printf("ringing\n");
		memset(&tSig, 0, sizeof(tSig));
		tSig.signal_type = RING_SIGNAL;
		strcpy(g_Cc_CallDetail.number, "1234567890");
		strncpy(tSig.cid, g_Cc_CallDetail.number,sizeof(tSig.cid)-1);
		get_local_datetime(tSig.date_time);
		ccapp_log("local test call RING_SIGNAL,number = %s\n",g_Cc_CallDetail.number);
		SLIC_Play_Signal(0, 0, &tSig);	
		zCc_SetLedStatus("ledblink");
	}
	return NULL;
}

VOID zCc_MRingingState(MSG_BUF *ptMsgBuf)
{
    int held_call_cid = 0;
    int incoming_call_cid = 0;
    int shall_ring_cid;
    
    SIGNAL_DATA  tSig;
    
	CHAR voip_status[ZDIAL_NUM_MAX] = {0};
    zte_log_append(__FILE__, __LINE__, "zte_ccapp.log","%s  zCc_MRingingState ptMsgBuf->usMsgCmd = %d\n",__FUNCTION__,ptMsgBuf->usMsgCmd);
    switch (ptMsgBuf->usMsgCmd)
    {
    case ZCC_SEIZE_E: // ժ
        g_Cc_CallDetail.state = ZCC_M_SEIZE_S;
        SLIC_Stop_Signal(0, RING_SIGNAL);     
        zte_log_append(__FILE__, __LINE__, "zte_ccapp.log","%s  zCc_MRingingState: SLIC_Stop_Signal <---\n",__FUNCTION__);
        if (g_zCc_VoiceOpenSucc == 0)
        {
            g_zCc_VoiceOpenSucc = 1;
            voice_open(&g_zCc_VoicePara_bak);
		/* new add begin */	
	        if (g_zCc_pcm_bak == 8000)
	        {
	            SLIC_PCM_Set_NB();
	    zte_log_append(__FILE__, __LINE__, "zte_ccapp.log","%s  zCc_ZimsplusProc: SLIC_PCM_Set_NB <---\n",__FUNCTION__);
	            SLIC_Start_PCM();
	    zte_log_append(__FILE__, __LINE__, "zte_ccapp.log","%s  zCc_ZimsplusProc: SLIC_Start_PCM <---\n",__FUNCTION__);
	        }
	        else if (g_zCc_pcm_bak == 16000)
	        {
	            SLIC_PCM_Set_WB();
	            zte_log_append(__FILE__, __LINE__, "zte_ccapp.log","%s  zCc_ZimsplusProc: SLIC_PCM_Set_WB <---\n",__FUNCTION__);
	            SLIC_Start_PCM();
	            zte_log_append(__FILE__, __LINE__, "zte_ccapp.log","%s  zCc_ZimsplusProc: SLIC_Start_PCM <---\n",__FUNCTION__);
	        }
	       g_zCc_pcm_bak = 0;
		/* new add end */	
        }
        
        g_Cc_CallDetail.chupSent = FALSE;

        ccapp_log("ZCC_SEIZE_E held_cid=%d held_incoming_cid=%d", 
            zCc_find_held_cid(),
            zCc_find_held_incoming_cid());

        if(local_test_call_st==LocalTestCallST_Ring)
        {
			/*memset(&tSig, 0, sizeof(tSig));
        	tSig.signal_type= TONE_SIGNAL;
	        tSig.tone_type = TONE_TKY;
	        SLIC_Play_Signal(0, 0, &tSig);*/
			if(local_test_call_type == LocalTestCallType_LOOP)
	        	pthread_cancel(slic_ring_test_pid);

	        g_Cc_CallDetail.lastTone = ZCC_TONE_OFF_A;
	        g_Cc_CallDetail.evt[0]= ZCC_NO_E;
	        g_Cc_CallDetail.slaveObj[0].sMsg = ZCC_SNO_M;

	        local_test_call_st = LocalTestCallST_End;

            //system("echo loop_1 >> /tmp/log.ccapp.vploop");
	        //system("( sleep 1 && at_cmd AT+VPLOOP=1 ) &");
	        sc_cfg_set("tz_vploop", "1");
	        ipc_send_message(MODULE_ID_CALL_CTRL_LOCAL,
	            MODULE_ID_AT_CTL,
	            MSG_CMD_SET_VPLOOP_REQ,
	            0,
	            NULL,
	            0);

	        zCc_ShowAllSlaveWithTips("testCall-end");
			break;
        }

        incoming_call_cid = zCc_find_held_incoming_cid();
        ccapp_log("incoming_call_cid=%d is_cidcw=%d",
            incoming_call_cid, 
            g_Cc_CallDetail.slaveObj[incoming_call_cid].is_cidcw);
            
        if(zCc_find_held_cid())
        {
			zCc_SendAtChldReq(1);
        }
        else if(incoming_call_cid)
        {
            if(g_Cc_CallDetail.slaveObj[incoming_call_cid].is_cidcw == TRUE)
                zCc_SendAtChldReq(1);
            else
            {
                if (g_Cc_CallDetail.ringCid)
    	        {
    	            g_Cc_CallDetail.evt[g_Cc_CallDetail.ringCid] = ZCC_CNCT_E;
    	            zCc_SendAtAnswerReq();
    	        }
            }
        }
        else
        {
	        if (g_Cc_CallDetail.ringCid)
	        {
	            g_Cc_CallDetail.evt[g_Cc_CallDetail.ringCid] = ZCC_CNCT_E;
	            zCc_SendAtAnswerReq();
	        }
        }
        break;

//    case ZCC_SINVITE_E:
    case ZCC_SDISCN_MT_E:
    case ZCC_SDISCN_MO_E:
    	if(check_incoming_call_is_in_slave(ptMsgBuf)==0)
    		break;
    		
        g_Cc_CallDetail.evt[ptMsgBuf->dst_id] = ptMsgBuf->usMsgCmd;
        g_Cc_CallDetail.state = ZCC_M_RELEASE_S;
        SLIC_Stop_Signal(0, RING_SIGNAL);
        g_zCc_VoiceOpenSucc = 1;
        zte_log_append(__FILE__, __LINE__, "zte_ccapp.log","%s  zCc_MRingingState: SLIC_Stop_Signal <---\n",__FUNCTION__);
#ifndef TEST_CCAPP
		sc_cfg_get("voip_status",voip_status,sizeof(voip_status));

		if (0 != strcmp("ledoff" , voip_status ))
#endif
        {
            zCc_SetLedStatus("ledoff");
        }

        shall_ring_cid = 0;
        held_call_cid = zCc_find_held_cid();
        incoming_call_cid = zCc_find_held_incoming_cid();
        if(held_call_cid && (ptMsgBuf->dst_id!=held_call_cid))
            shall_ring_cid = held_call_cid;
        else if(incoming_call_cid && (ptMsgBuf->dst_id!=incoming_call_cid))
            shall_ring_cid = incoming_call_cid;

        if(shall_ring_cid!=0)   
        {
        	memset(&tSig, 0, sizeof(tSig));
            g_Cc_CallDetail.state = ZCC_M_RINGING_S;
            tSig.signal_type = RING_SIGNAL;
            /*memcpy(tSig.cid, 
                g_Cc_CallDetail.slaveObj[shall_ring_cid].number, 
                strlen(g_Cc_CallDetail.slaveObj[shall_ring_cid].number));*/
            strncpy(tSig.cid, g_Cc_CallDetail.slaveObj[shall_ring_cid].number, sizeof(tSig.cid)-1);
            get_local_datetime(tSig.date_time);
            zte_log_append(__FILE__, __LINE__, "zte_ccapp.log","%s  zCc_RunMaster RING_SIGNAL,number = %s\n",__FUNCTION__,g_Cc_CallDetail.slaveObj[held_call_cid].number);
            SLIC_Play_Signal(0, 0, &tSig);  
            zCc_SetLedStatus("ledblink");
        }
        break;

    default:
        // do nothing
        break;
    }
}

VOID zCc_MSeizeState(MSG_BUF *ptMsgBuf)
{
    zte_log_append(__FILE__, __LINE__, "zte_ccapp.log","%s  zCc_MSeizeState ptMsgBuf->usMsgCmd = %d\n",__FUNCTION__,ptMsgBuf->usMsgCmd);
    UINT8   slave = (UINT8)ptMsgBuf->dst_id;
    UINT8   callCnt = 0;
    UINT8   ret = 0;
    SINT32  chldret = -1;
    UINT8 tmpslave = 0;
    CHAR voip_status[ZDIAL_NUM_MAX] = {0};

    printf("[ccapp_debug]: Seize State Recv MsgCmd: %d,localtest=%d\n",ptMsgBuf->usMsgCmd,local_test_call_st);

    switch (ptMsgBuf->usMsgCmd)
    {
    case ZCC_DTMF_E: // 
        // slave[0] dial , or other call's DTMF
        ccapp_log("--> ZCC_DTMF_E[%c] lastTone=%d Count=%d Held=%d Active=%d getSlave(DACCM)=%d getSlave(RINGBACK)=%d ringCid=%d dig=%s", 
                    ptMsgBuf->aucDataBuf[0],
        			g_Cc_CallDetail.lastTone,
        			zCc_CallCount(),
        			zCc_HeldCall(),
        			zCc_ActiveCall(), 
        			zCc_GetSpecSlave(ZCC_S_DACCM_S),
        			zCc_GetSpecSlave(ZCC_S_RINGBACK_S),
        			g_Cc_CallDetail.ringCid,
        			g_Cc_CallDetail.digits); 
        printf("[ccapp_debug]: ZCC_DTMF_E[%c] lastTone=%d Count=%d Held=%d Active=%d getSlave(DACCM)=%d getSlave(RINGBACK)=%d ringCid=%d dig=%s\n", 
                    ptMsgBuf->aucDataBuf[0],
        			g_Cc_CallDetail.lastTone,
        			zCc_CallCount(),
        			zCc_HeldCall(),
        			zCc_ActiveCall(), 
        			zCc_GetSpecSlave(ZCC_S_DACCM_S),
        			zCc_GetSpecSlave(ZCC_S_RINGBACK_S),
        			g_Cc_CallDetail.ringCid,
        			g_Cc_CallDetail.digits);

        /* callwait ringback but he drop then we hookflash+1
lastTone=6 Count=2 Held=1 Active=0 getSlave(DACCM)=0 getSlave(RINGBACK)=2 ringCid=0 dig[0]=F
        */			
        if ((g_Cc_CallDetail.lastTone == ZCC_TONE_BSY_A) || (g_Cc_CallDetail.lastTone == ZCC_TONE_TKY_A))//æϢ
        {
            zCc_ClearDigits();
            break;
        }
        callCnt = zCc_CallCount();
        if ( (g_Cc_CallDetail.lastTone == ZCC_TONE_DIAL_A || callCnt == zCc_HeldCall()) //ֻбֺУŷº
            && g_Cc_CallDetail.digits[0] != ZCC_FLASH_SIGN
            && 0 == zCc_ActiveCall())//Ųбֺʱû,һַųactive+heldʱ·F2
        {            
            slave = zCc_GetSpecSlave(ZCC_S_IDLE_S);
            if (0 == slave )
            {
                return;
            }        
            g_Cc_CallDetail.slaveObj[slave] = g_Cc_CallDetail.slaveObj[0];
            g_Cc_CallDetail.evt[slave] = ZCC_DTMF_E;
            sc_timer_delete(ZCCAPP_TIMER_SSDIALTONE_DETECT);
            zCc_InitSlaveObj(0);
            zte_log_append(__FILE__, __LINE__, "zte_ccapp.log","%s  zCc_MSeizeState ZCC_DTMF_E \n",__FUNCTION__);
            break;
        }
        else if ((g_Cc_CallDetail.lastTone == ZCC_TONE_SIL_A) && (0 != zCc_GetSpecSlave(ZCC_S_DACCM_S)))//
        {           
            slave = zCc_GetSpecSlave(ZCC_S_DACCM_S);
            g_Cc_CallDetail.evt[slave] = ZCC_DTMF_E;
            zte_log_append(__FILE__, __LINE__, "zte_ccapp.log","%s  zCc_MSeizeState ZCC_DTMF_E \n",__FUNCTION__);
            break;
        }
        else if ((g_Cc_CallDetail.digits[0] != ZCC_FLASH_SIGN) && ((0 != zCc_ActiveCall())
            ||((0 == zCc_ActiveCall()) && (0 != zCc_GetSpecSlave(ZCC_S_RINGBACK_S)))))//dtmf
        {            
            if (0 != zCc_ActiveCall())
            {
                slave = zCc_GetCallSlave(0);
            }
            else
            {
                slave = zCc_GetSpecSlave(ZCC_S_RINGBACK_S);
            }
            g_Cc_CallDetail.evt[slave] = ZCC_DTMF_E;
            zte_log_append(__FILE__, __LINE__, "zte_ccapp.log","%s  zCc_MSeizeState ZCC_DTMF_E \n",__FUNCTION__);
            break;
        }
        else if ((0 == zCc_ActiveCall()) && (0 == zCc_GetSpecSlave(ZCC_S_RINGBACK_S))
           && (g_Cc_CallDetail.digits[0] != ZCC_FLASH_SIGN))//̬ǻ״̬յַ
        {
            zCc_ClearDigits();
            return;
        }
        else 
        {
            if (g_Cc_CallDetail.ringCid && (g_Cc_CallDetail.slaveObj[g_Cc_CallDetail.ringCid].tone == ZCC_TONE_CIDCW_A))//active+waiting+flashordtmf
            {
                sc_timer_delete(ZCCAPP_TIMER_SSDIALTONE_DETECT);     
                if (g_Cc_CallDetail.digits[0] != ZCC_FLASH_SIGN)
                {             
                    slave = zCc_GetSpecSlave(ZCC_S_TALKING_S);
                    if (0 == slave )
                    {
                        return;
                    }        
                    g_Cc_CallDetail.evt[slave] = ZCC_DTMF_E;
                    zte_log_append(__FILE__, __LINE__, "zte_ccapp.log","%s  zCc_MSeizeState ZCC_DTMF_E \n",__FUNCTION__);
                    break;
                }        
            }  

            sc_timer_delete(ZCCAPP_TIMER_DTMF_DETECT);
            ret = zCc_DigitsMatch();
            if ((ZCC_NO_RESULT != ret && ZCC_MATCHERR != ret && g_Cc_CallDetail.lastTone == ZCC_TONE_DIAL_A)
              ||(ZCC_MATCHERR == ret && g_Cc_CallDetail.lastTone == ZCC_TONE_DIAL_A && 2 <= zCc_CallCount()))
            {//call waitingյflash4ָֹͣеȴ
                SLIC_Stop_Signal(0, TONE_SIGNAL);
        zte_log_append(__FILE__, __LINE__, "zte_ccapp.log","%s  zCc_MSeizeState: SLIC_Stop_Signal <---\n",__FUNCTION__);
                g_Cc_CallDetail.lastTone = ZCC_TONE_OFF_A;
                if (g_Cc_CallDetail.slaveObj[0].tone != ZCC_TONE_OFF_A)
                {                   
                    zCc_InitSlaveObj(0);
                }  
                if (0 != zCc_ActiveCall())
                {
                    SLIC_Start_PCM();
                }
                if ((ZCC_FLASH_1 == ret || ZCC_FLASH_2 == ret) && (g_Cc_CallDetail.ringCid != 0))//waiting callеȴӦ
                {
                    g_Cc_CallDetail.slaveObj[g_Cc_CallDetail.ringCid].tone = ZCC_TONE_OFF_A;
                }
            } 
            zCc_DigitsMatchRltProc(ret);
            zte_log_append(__FILE__, __LINE__, "zte_ccapp.log","%s  zCc_MSeizeState ZCC_DTMF_E \n",__FUNCTION__);
        }
        
        break;

    case ZCC_SDIALLING_E: // SIP INVITE  CC SETUP , ͨϢϱ cid
        if (0 != zCc_GetDialingSlave(0))
        {
            tmpslave = zCc_GetDialingSlave(0);
            if (tmpslave != slave)
            {
                g_Cc_CallDetail.slaveObj[slave] =  g_Cc_CallDetail.slaveObj[tmpslave];
                zCc_InitSlaveObj(tmpslave);
            }
        }
        break;

    case ZCC_SRING_E:
    case ZCC_SANS_E:
    case ZCC_SINVITE_E:
    case ZCC_CIDCW_E:
        g_Cc_CallDetail.evt[slave] = ptMsgBuf->usMsgCmd;
        break;

    case ZCC_SDISCN_MT_E:  
    case ZCC_SDISCN_MO_E: 
	{ //cov m
    	if(check_incoming_call_is_in_slave(ptMsgBuf)==0)
    		break;
    		
    	g_Cc_CallDetail.evt[slave] = ptMsgBuf->usMsgCmd;
    	
    	T_zCcApp_DsciInd *ptr = ptMsgBuf->aucDataBuf;

    	/* somebody drop the call
		zCc_MSeizeState  zCc_MSeizeState ptMsgBuf->usMsgCmd = 43
		zCc_MSeizeState ==> get MT/MO cid=1 num=13088877803 stat=6 inMp=0 getCnt=2
		zCc_MSeizeState 	slv=1 cid=0 held=1 stat=8
		zCc_MSeizeState 	slv=2 cid=0 held=0 stat=8
		zCc_STalkingState  zCc_STalkingState g_Cc_CallDetail.evt[1] = 43
    	*/
    	ccapp_log("==> get MT/MO cid=%d num=%s stat=%d inMp=%d getCnt=%d", 
    			ptr->cid, ptr->num, ptr->state, ptr->inMpty,
    			zCc_CallCount());
	
    	for (tmpslave = 0; tmpslave < ZCC_SLAVES; tmpslave++)
        {
            if (g_Cc_CallDetail.slaveObj[tmpslave].state != ZCC_S_IDLE_S)
            {
                ccapp_log("    slave=%d cid=%d held=%d stat=%d", 
                			tmpslave, 
                			g_Cc_CallDetail.slaveObj[tmpslave].cid,
                			g_Cc_CallDetail.slaveObj[tmpslave].heldcall,
                			g_Cc_CallDetail.slaveObj[tmpslave].state);
            }
        }

        if(zCc_CallCount()<2)
        	break;

        if(ptr->cid>=ZCC_SLAVES) //cov m
        	break;

        if(g_Cc_CallDetail.slaveObj[ptr->cid].heldcall==0 &&
    		g_Cc_CallDetail.slaveObj[ptr->cid].confcall==0)  
    	{
    		if(zCc_HeldCall())					
    		{
	            zCc_SendAtChldReq(1);
	            break;
            }
    	}

        int incoming_call_cid = zCc_GetSpecSlave(ZCC_S_TRYING_S);
        if(incoming_call_cid!=0 && incoming_call_cid!=ptr->cid) 
			zCc_SendAtChldReq(2);

		#if 0
        tmpslave = zCc_GetSpecSlave(ZCC_S_TRYING_S);  // incoming call here and wait for to be accepted
        ccapp_log("zCc_CallCount()=%d zCc_GetSpecSlave(ZCC_S_TRYING_S)=%d", 
            zCc_CallCount(), 
            tmpslave);
        if(tmpslave!=0 && ptMsgBuf->usMsgCmd==ZCC_SDISCN_MO_E)  // foreground drop, automaticly accept the incoming call
        {
            SLIC_Stop_Signal(0, TONE_SIGNAL); 
            zCc_SendAtChldReq(1);
            break;
        }
        
        if(zCc_CallCount()<2)
        	break;

        if(ptr->cid<0 || ptr->cid>=ZCC_SLAVES)
        	break;
	
    	if(g_Cc_CallDetail.slaveObj[ptr->cid].heldcall==0 &&
    		g_Cc_CallDetail.slaveObj[ptr->cid].confcall==0)  
    	{
    		/*if(g_Cc_CallDetail.slaveObj[ptr->cid].state==ZCC_S_DIALING_S ||
    			g_Cc_CallDetail.slaveObj[ptr->cid].state==ZCC_S_RINGBACK_S ||
    			g_Cc_CallDetail.slaveObj[ptr->cid].state==ZCC_S_TALKING_S) */
    		if(zCc_HeldCall())
    		{
	            zCc_SendAtChldReq(1);
            }
    	}
    	#endif
        break;
    }
    case ZCC_RELEASE_E:
    	if(local_test_call_st==LocalTestCallST_Start)
    	{
    		SIGNAL_DATA tSig;

			SLIC_Stop_Signal(0, TONE_SIGNAL); 

            memset(&tSig, 0, sizeof(tSig));
            tSig.signal_type = RING_SIGNAL;
            strcpy(g_Cc_CallDetail.number, "1234567890");
            strncpy(tSig.cid, g_Cc_CallDetail.number,sizeof(tSig.cid)-1);
            get_local_datetime(tSig.date_time);
            ccapp_log("local test call RING_SIGNAL,number = %s\n",g_Cc_CallDetail.number);
            SLIC_Play_Signal(0, 0, &tSig);  
            zCc_SetLedStatus("ledblink");

			if(local_test_call_type == LocalTestCallType_LOOP) {
				if (pthread_create(&slic_ring_test_pid, NULL, slic_ring_test_thread,0) != 0) //cov m
					printf("slic_ring_test_thread create fail\n");
			}

     		g_Cc_CallDetail.lastTone = ZCC_TONE_OFF_A;
		    g_Cc_CallDetail.evt[slave]= ZCC_NO_E;
            g_Cc_CallDetail.slaveObj[slave].sMsg = ZCC_SNO_M;
            g_Cc_CallDetail.state = ZCC_M_RINGING_S;

            local_test_call_st = LocalTestCallST_Ring;
            zCc_ShowAllSlaveWithTips("testCall-ring");
			break;
    	}
    	else if(local_test_call_st==LocalTestCallST_End)
    	{
    		zCc_ClearDigits();
			zCc_InitSlaveObj(0);
			for (slave = 1; slave < ZCC_SLAVES; slave++)
	        {
	            if (g_Cc_CallDetail.slaveObj[slave].state != ZCC_S_IDLE_S)
	                zCc_InitSlaveObj(slave);
	        }
        
		    SLIC_Stop_Signal(0, TONE_SIGNAL); 
		    SLIC_Stop_PCM();
		    zCc_SetLedStatus("ledoff");

		    g_Cc_CallDetail.resourceReady = 0;
	        g_Cc_CallDetail.hookofffg = FALSE;
	        g_Cc_CallDetail.state = ZCC_M_RELEASE_S;

            //system("echo loop_0 >> /tmp/log.ccapp.vploop");
	        //system("( sleep 1 && at_cmd AT+VPLOOP=0 ) &");
	        sc_cfg_set("tz_vploop", "0");
	        ipc_send_message(MODULE_ID_CALL_CTRL_LOCAL,
	            MODULE_ID_AT_CTL,
	            MSG_CMD_SET_VPLOOP_REQ,
	            0,
	            NULL,
	            0);
	        
	        sc_timer_delete(ZCCAPP_TIMER_HOOKOFF_DETECT);
	        sc_timer_delete(ZCCAPP_TIMER_DTMF_DETECT);
	        sc_timer_delete(ZCCAPP_TIMER_BUSYTONE_DETECT);
	        sc_timer_delete(ZCCAPP_TIMER_TKYTONE_DETECT);
	        sc_timer_delete(ZCCAPP_TIMER_SSDIALTONE_DETECT);
	        sc_timer_delete(ZCCAPP_TIMER_HOOKOFF_IDLE);
	        
	        local_test_call_st = LocalTestCallST_None;
    		zCc_ShowAllSlaveWithTips("testCall-end-none");
    		break;
    	}
    	
        for (slave = 1; slave < ZCC_SLAVES; slave++)
        {
            if (g_Cc_CallDetail.slaveObj[slave].state != ZCC_S_IDLE_S && g_Cc_CallDetail.slaveObj[slave].waitDSCI6 == 0)
            {
                g_Cc_CallDetail.evt[slave] = ZCC_DISCN_E;
            }
        }
		//if(slave == ZCC_SLAVES)
		//	return;
        if (g_Cc_CallDetail.slaveObj[0].state != ZCC_S_IDLE_S)//slave0ڷӦ
        {            
            zCc_InitSlaveObj(0);
        }
        SLIC_Stop_Signal(0, TONE_SIGNAL); 
        zte_log_append(__FILE__, __LINE__, "zte_ccapp.log","%s  zCc_MSeizeState: SLIC_Stop_Signal <---\n",__FUNCTION__);
        g_Cc_CallDetail.lastTone = ZCC_TONE_OFF_A;
        //g_Cc_CallDetail.chupSent = FALSE;
        //SLIC_Stop_PCM();
    zte_log_append(__FILE__, __LINE__, "zte_ccapp.log","%s  zCc_MSeizeState: SLIC_Stop_PCM <---\n",__FUNCTION__);
        
#ifndef TEST_CCAPP


		sc_cfg_get("voip_status",voip_status,sizeof(voip_status));

        if (0 != strcmp("ledoff" , voip_status ))
#endif
        {
            zCc_SetLedStatus("ledoff");
        }
        g_Cc_CallDetail.state = ZCC_M_RELEASE_S;
        if (!(0 != zCc_GetSpecSlave(ZCC_S_TRYING_S) && (1 == zCc_CallCount())))//ժʱ磬
        {
            g_Cc_CallDetail.resourceReady = 0;
        }
        zCc_ClearDigits();
        g_Cc_CallDetail.hookofffg = FALSE;
        sc_timer_delete(ZCCAPP_TIMER_HOOKOFF_DETECT);//յϣǰʱҪֹͣ
        sc_timer_delete(ZCCAPP_TIMER_DTMF_DETECT);
        sc_timer_delete(ZCCAPP_TIMER_BUSYTONE_DETECT);
        sc_timer_delete(ZCCAPP_TIMER_TKYTONE_DETECT);
        sc_timer_delete(ZCCAPP_TIMER_SSDIALTONE_DETECT);
        
        sc_timer_delete(ZCCAPP_TIMER_HOOKOFF_IDLE);
        for (slave = 1; slave < ZCC_SLAVES; slave++)
        {
            g_Cc_CallDetail.slaveObj[slave].idle_second = 0;//hook off ldle timer is killed,  time_cnt reset
        }
        
        break;
    case ZCC_BUSYTONETIMER_E:
        for (slave = 0; slave < ZCC_SLAVES; slave++)
        {
            if(g_Cc_CallDetail.slaveObj[slave].tone == ZCC_TONE_BSY_A)
            break;
        }
		if(slave == ZCC_SLAVES)
			return;
        g_Cc_CallDetail.slaveObj[slave].tone = ZCC_TONE_TKY_A;
        sc_timer_create(ZCCAPP_TIMER_TKYTONE_DETECT,
                    0,
                    ZCCAPP_TIMER_TKYTONE_INTERVAL,
                    zCcApp_TkyToneTimer,
                    NULL);  
        zte_log_append(__FILE__, __LINE__, "zte_ccapp.log","%s  zCc_MSeizeState sc_timer_create zCcApp_TkyToneTimer\n",__FUNCTION__);
        if (!(0 == zCc_GetSpecSlave(ZCC_S_BSYT_S)
           &&(g_Cc_CallDetail.slaveObj[slave].state== ZCC_S_WAIT_RESOURCE_S
            ||g_Cc_CallDetail.slaveObj[slave].state== ZCC_S_TRYING_S)
           && g_Cc_CallDetail.lastTone == ZCC_TONE_BSY_A))
        {
            g_Cc_CallDetail.slaveObj[slave].state = ZCC_S_TKYT_S;
        }
        return;
    case ZCC_HOOKOFFTIMER_E:
        for (slave = 0; slave < ZCC_SLAVES; slave++)
        {
            if(g_Cc_CallDetail.slaveObj[slave].state == ZCC_S_DT_S)
            break;
        }
		if(slave == ZCC_SLAVES)
			return;
        if (1 == zCc_BusyToneAllowed() && g_Cc_CallDetail.state == ZCC_M_SEIZE_S)//ʱæ
        {
            g_Cc_CallDetail.slaveObj[slave].tone = ZCC_TONE_BSY_A;
            g_Cc_CallDetail.slaveObj[slave].state = ZCC_S_BSYT_S; 
            g_Cc_CallDetail.slaveObj[slave].confcall = 0;
            g_Cc_CallDetail.slaveObj[slave].heldcall = 0; 
            sc_timer_create(ZCCAPP_TIMER_BUSYTONE_DETECT,
                    0,
                    ZCCAPP_TIMER_BUSYTONE_INTERVAL,
                    zCcApp_BusyToneTimer,
                    NULL);   
            zte_log_append(__FILE__, __LINE__, "zte_ccapp.log","%s  zCc_MSeizeState sc_timer_create zCcApp_BusyToneTimer22222\n",__FUNCTION__);
        }
        else
        {
            zCc_InitSlaveObj(slave);
    zte_log_append(__FILE__, __LINE__, "zte_ccapp.log","%s  zCc_InitSlaveObj: slaveObj[%d] cleared\n",__FUNCTION__, slave);
        }
        return;
    case ZCC_HOOKOFF_IDLE_TIMER_E:
    	for (slave = 0; slave < ZCC_SLAVES; slave++)
        {
            if(g_Cc_CallDetail.slaveObj[slave].state == ZCC_S_DT_S)
            {
            	g_Cc_CallDetail.slaveObj[slave].idle_second++;            	
				if(g_Cc_CallDetail.slaveObj[slave].idle_second >= 5000/ZCCAPP_TIMER_HOOKOFF_IDLE_INTERVAL)
				{
					int rt;
					char hotline[ZDIAL_NUM_MAX-1];
					
					memset(hotline, 0, sizeof(hotline));
					rt = sc_cfg_get("dialog_hotline_str", hotline, sizeof(hotline)-1);
					if(rt!=0 || strlen(hotline)<=0)
					{
						sc_timer_delete(ZCCAPP_TIMER_HOOKOFF_IDLE);
						break;
					}
					
					strcpy(g_Cc_CallDetail.digits, hotline);
					g_Cc_CallDetail.dCount = strlen(hotline);

					MSG_BUF msgBuf = {0};
	                msgBuf.usMsgCmd   = ZCC_DTMF_E;
	                msgBuf.src_id = MODULE_ID_SLIC;
	                msgBuf.aucDataBuf[0] = (UINT8)'#';
	                msgBuf.usDataLen = 1;
	                zCc_SendMsgToSub(&msgBuf);

	                g_Cc_CallDetail.slaveObj[slave].tone = ZCC_TONE_SIL_A;
        			g_Cc_CallDetail.slaveObj[slave].state = ZCC_S_DACCM_S;

	                sc_timer_delete(ZCCAPP_TIMER_HOOKOFF_DETECT);
	                
					ccapp_log("==> HOOKOFF_IDLE_TIMER send hotline=%s\n", hotline);
				}
            }
        }
    	break;
    case ZCC_DTMFTIMER_E:
        for (slave = 0; slave < ZCC_SLAVES; slave++)
        {
            if(g_Cc_CallDetail.slaveObj[slave].state == ZCC_S_DACCM_S)
            break;
        }
		if(slave == ZCC_SLAVES)
			return;
        g_Cc_CallDetail.digits[g_Cc_CallDetail.dCount++] = ZCC_TIMEOUT_SIGN;
        ret = zCc_DigitsMatch();
        zCc_DigitsMatchRltProc(ret);
        if (ZCC_MATCHERR != ret)
        {
            if (g_Cc_CallDetail.slaveObj[slave].state == ZCC_S_IDLE_S)//ss
            {
                zCc_SendSsReq(g_Cc_CallDetail.digits);
                g_Cc_CallDetail.slaveObj[slave].tone = ZCC_TONE_OFF_A;
            }
            else
            {
                zCc_SendAtDialReq(g_Cc_CallDetail.digits);
            }
        }
        g_Cc_CallDetail.slaveObj[slave].sMsg = ZCC_SNO_M;
        zCc_ClearDigits();
        return;
    case ZCC_TKYTIMER_E:
        for (slave = 0; slave < ZCC_SLAVES; slave++)
        {
            if(g_Cc_CallDetail.slaveObj[slave].tone == ZCC_TONE_TKY_A)
            break;
        }
		if(slave == ZCC_SLAVES)
			return;
        SLIC_Stop_Signal(0, TONE_SIGNAL);
        zte_log_append(__FILE__, __LINE__, "zte_ccapp.log","%s  zCc_MSeizeState: SLIC_Stop_Signal <---\n",__FUNCTION__);
        g_Cc_CallDetail.slaveObj[slave].tone = ZCC_TONE_SIL_A;
        if (!(0 == zCc_GetSpecSlave(ZCC_S_TKYT_S)
           &&(g_Cc_CallDetail.slaveObj[slave].state== ZCC_S_WAIT_RESOURCE_S
            ||g_Cc_CallDetail.slaveObj[slave].state== ZCC_S_TRYING_S)
           && g_Cc_CallDetail.lastTone == ZCC_TONE_TKY_A))
        {
            g_Cc_CallDetail.slaveObj[slave].state = ZCC_S_SIL_S;
        }
        g_Cc_CallDetail.lastTone = ZCC_TONE_SIL_A;
        return;
    case ZCC_SSDIALTONETIMER_E:
        zCc_InitSlaveObj(0);//Ųslave0 
        zCc_ClearDigits();      
        if (1 == zCc_CallCount() 
            && (g_Cc_CallDetail.lastTone == ZCC_TONE_DIAL_A))//ǰֻһ·ֹͣ
        {                
            SLIC_Stop_Signal(0,0);
        zte_log_append(__FILE__, __LINE__, "zte_ccapp.log","%s  zCc_MSeizeState: SLIC_Stop_Signal <---\n",__FUNCTION__);
            g_Cc_CallDetail.lastTone = ZCC_TONE_OFF_A;
            if (1 == zCc_HeldCall())//ѱָ֣
            {
                chldret = zCc_SendAtChldReq(2);
            }
            else if (0 != zCc_ActiveCall())
            {
                SLIC_Start_PCM();
            }
        }
        else if (1 < zCc_CallCount() && (g_Cc_CallDetail.lastTone == ZCC_TONE_DIAL_A))//active/held mpty and held+waiting
        {            
            SLIC_Stop_Signal(0,0);
        zte_log_append(__FILE__, __LINE__, "zte_ccapp.log","%s  zCc_MSeizeState: SLIC_Stop_Signal <---\n",__FUNCTION__);
            g_Cc_CallDetail.lastTone = ZCC_TONE_OFF_A;
            if((0 == zCc_HeldCall() && 0 != g_Cc_CallDetail.ringCid)//active+waiting ָheld+waiting, ָźеȴ
            ||(0 != zCc_HeldCall() && 0 !=zCc_ActiveCall()))//active+heldָ
            {
                SLIC_Start_PCM();
                zte_log_append(__FILE__, __LINE__, "zte_ccapp.log","%s  zCc_MSeizeState: SLIC_Start_PCM <---\n",__FUNCTION__);
            }
        }
        return;
    case ZCC_FLASH_E:
    	ccapp_log("ZCC_FLASH_E cnt=%d held=%d active=%d BefDial=%d",
    		zCc_CallCount(),
    		zCc_HeldCall(),
    		zCc_ActiveCall(),
    		zCc_MoBeforDialingCall());
    		
        if (!(zCc_CallCount() > 1 && g_Cc_CallDetail.digits[0] == ZCC_FLASH_SIGN))//·ʱҪжflashεĳ
        {
            zCc_ClearDigits();
        }
        sc_timer_delete(ZCCAPP_TIMER_HOOKOFF_DETECT);//յϣǰʱҪֹͣ
        sc_timer_delete(ZCCAPP_TIMER_DTMF_DETECT);
        sc_timer_delete(ZCCAPP_TIMER_BUSYTONE_DETECT);
        sc_timer_delete(ZCCAPP_TIMER_TKYTONE_DETECT);
        sc_timer_delete(ZCCAPP_TIMER_SSDIALTONE_DETECT);
        
        callCnt = zCc_CallCount();
        
        if (g_Cc_CallDetail.ringCid && (g_Cc_CallDetail.slaveObj[g_Cc_CallDetail.ringCid].tone == ZCC_TONE_CIDCW_A))//еȴflashַ
        {
            if(g_Cc_CallDetail.digits[0] == ZCC_FLASH_SIGN)
            {
                zCc_InitSlaveObj(0);
                zCc_ClearDigits();      
                SLIC_Stop_Signal(0,0);
        zte_log_append(__FILE__, __LINE__, "zte_ccapp.log","%s  zCc_MSeizeState: SLIC_Stop_Signal <---\n",__FUNCTION__);
                g_Cc_CallDetail.lastTone = ZCC_TONE_OFF_A;
                if (0 != zCc_ActiveCall())
                {
                    SLIC_Start_PCM();
                }
                break;
            }
            g_Cc_CallDetail.digits[g_Cc_CallDetail.dCount++] = ZCC_FLASH_SIGN;
            // slave[0] to play dial tone
             sc_timer_create(ZCCAPP_TIMER_SSDIALTONE_DETECT,
                 0,
                 ZCCAPP_TIMER_HOOKOFF_INTERVAL,
                 zCcApp_SsDialToneTimer,
                 NULL);  
    zte_log_append(__FILE__, __LINE__, "zte_ccapp.log","%s  zCc_MSeizeState: sc_timer_create zCcApp_SsDialToneTimer\n",__FUNCTION__);
            g_Cc_CallDetail.evt[0] = ZCC_DIAL_E;
            //g_Cc_CallDetail.slaveObj[g_Cc_CallDetail.ringCid].tone = ZCC_TONE_OFF_A;ֶΣflash4ʧʱָеȴ
            SLIC_Stop_PCM();
    zte_log_append(__FILE__, __LINE__, "zte_ccapp.log","%s  zCc_MSeizeState: SLIC_Stop_PCM2222\n",__FUNCTION__);
    zte_log_append(__FILE__, __LINE__, "zte_ccapp.log","%s  zCc_MSeizeState:ZCC_FLASH_E\n",__FUNCTION__);
            break;
        }
                
        if (  callCnt==0 //ŲδɲŻժδŷæ
            ||(callCnt ==1 && zCc_FlashClearCall() > 0))  //ҵеԼͷеĺУͷţŲ
        {
            zCc_InitSlaveObj(0);
            g_Cc_CallDetail.evt[0] = ZCC_DIAL_E;
            SLIC_Stop_PCM();
    zte_log_append(__FILE__, __LINE__, "zte_ccapp.log","%s  zCc_MSeizeState:SLIC_Stop_PCM\n",__FUNCTION__);
            g_Cc_CallDetail.hookofffg = TRUE;  
    zte_log_append(__FILE__, __LINE__, "zte_ccapp.log","%s  zCc_MSeizeState:ZCC_FLASH_E\n",__FUNCTION__);
            break;
        }
        
        if (zCc_ActiveCall() == callCnt) //ֻactive callŲ
        {
            if (callCnt > 1) // conf call, Ų
            {
                g_Cc_CallDetail.digits[g_Cc_CallDetail.dCount++] = ZCC_FLASH_SIGN;
                g_Cc_CallDetail.digits[ZDIAL_NUM_MAX-1] = 1;// ¼βΪconf 
    zte_log_append(__FILE__, __LINE__, "zte_ccapp.log","%s  zCc_MSeizeState:ZCC_FLASH_E\n",__FUNCTION__);
            }
            else
            {
                chldret = zCc_SendAtChldReq(2);
    zte_log_append(__FILE__, __LINE__, "zte_ccapp.log","%s  zCc_MSeizeState:ZCC_FLASH_E\n",__FUNCTION__);
            g_Cc_CallDetail.waitchldresult = 1;
            }
            break;
        }
        
        if (zCc_HeldCall() == callCnt) //ֻheld callָ
        {
            if (callCnt == 1 )
            {
                chldret = zCc_SendAtChldReq(2);
                zte_log_append(__FILE__, __LINE__, "zte_ccapp.log","%s  zCc_MSeizeState:ZCC_FLASH_E\n",__FUNCTION__);
            }
            else
            {
                g_Cc_CallDetail.digits[g_Cc_CallDetail.dCount++] = ZCC_FLASH_SIGN;
                sc_timer_create(ZCCAPP_TIMER_SSDIALTONE_DETECT,
                                 0,
                                 ZCCAPP_TIMER_HOOKOFF_INTERVAL,
                                 zCcApp_SsDialToneTimer,
                                 NULL);   
                zte_log_append(__FILE__, __LINE__, "zte_ccapp.log","%s  zCc_MSeizeState:sc_timer_create zCcApp_SsDialToneTimer\n",__FUNCTION__);
                g_Cc_CallDetail.evt[0] = ZCC_DIAL_E;
                
            }
            break;
        }
        //active + held

        if(g_Cc_CallDetail.digits[0] == ZCC_FLASH_SIGN)
        {
            zCc_InitSlaveObj(0);
            zCc_ClearDigits();      
            SLIC_Stop_Signal(0,0);
        zte_log_append(__FILE__, __LINE__, "zte_ccapp.log","%s  zCc_MSeizeState: SLIC_Stop_Signal <---\n",__FUNCTION__);
            g_Cc_CallDetail.lastTone = ZCC_TONE_OFF_A;
            if (0 != zCc_ActiveCall())
            {
                SLIC_Start_PCM();
            }
            break;
        }   

		/*
			zCc_MSeizeState befor=1 act=0 held=1 callCnt=2
				zCc_MoBeforDialingCall slave[1]=8
				zCc_MoBeforDialingCall slave[2]=4
		*/
        ccapp_log("ZCC_FLASH_E befor=%d active=%d held=%d callCnt=%d",
        	zCc_MoBeforDialingCall(),
        	zCc_ActiveCall(),
        	zCc_HeldCall(),
        	callCnt);

        if (((0 != zCc_MoBeforDialingCall())			
        	&& (0 != zCc_ActiveCall() || 0 != zCc_HeldCall())) //active or held + еĺ
            ||(0 != zCc_MoBeforDialingCall() && 1 == callCnt))
        {
        	/*if(g_Cc_CallDetail.digits[0]==ZCC_FLASH_SIGN && 
        		strlen(g_Cc_CallDetail.digits)<=3)
        	{
				zCc_InitSlaveObj(0);
            	zCc_ClearDigits();    
            	zCc_SendAtChldReq(2);
            	ccapp_log("get ZCC_FLASH_SIGN and return to old talk");
        	}*/

        	int cid = zCc_GetMoBeforDialingCallCID();
        	if(cid>=0 && zCc_HeldCall()!=0)	// drop the beforeDialing call
        	{
				zCc_InitSlaveObj(cid);
            	zCc_ClearDigits();    
            	zCc_SendAtChldReq(1);
            	ccapp_log("drop the beforeDialing call cid=%d", cid);
        	}
        	
            zte_log_append(__FILE__, __LINE__, "zte_ccapp.log","%s  zCc_MSeizeState:ZCC_FLASH_E return\n",__FUNCTION__);
            return;
        }
        
        g_Cc_CallDetail.digits[g_Cc_CallDetail.dCount++] = ZCC_FLASH_SIGN;
        g_Cc_CallDetail.evt[0] = ZCC_DIAL_E;
        sc_timer_create(ZCCAPP_TIMER_SSDIALTONE_DETECT,
                 0,
                 ZCCAPP_TIMER_HOOKOFF_INTERVAL,
                 zCcApp_SsDialToneTimer,
                 NULL);   
    zte_log_append(__FILE__, __LINE__, "zte_ccapp.log","%s  zCc_MSeizeState:sc_timer_create zCcApp_SsDialToneTimer\n",__FUNCTION__);
        SLIC_Stop_PCM();
    zte_log_append(__FILE__, __LINE__, "zte_ccapp.log","%s  zCc_MSeizeState:SLIC_Stop_PCM\n",__FUNCTION__);
        break;

    case ZCC_RESOURCE_READY_E:
        g_Cc_CallDetail.evt[slave] = ZCC_RESOURCE_READY_E;
        break;
        /*ATӦĿǰֻatdӦҪ*/
    case MSG_CMD_ATD_DIAL_RSP:
        zte_log_append(__FILE__, __LINE__, "zte_ccapp.log","%s  ATD_rsp=%d\n",__FUNCTION__,((T_zCcapp_optRsp*)ptMsgBuf->aucDataBuf)->result);
        if(((T_zCcapp_optRsp*)ptMsgBuf->aucDataBuf)->result == 0)
            break;
        slave = zCc_GetDialingSlave(1);
        zte_log_append(__FILE__, __LINE__, "zte_ccapp.log","%s  zCc_SendAtDialReq:RECV ERROR\n",__FUNCTION__);
        slave = zCc_GetDialingSlave(1);
        if (1 == zCc_BusyToneAllowed() && g_Cc_CallDetail.slaveObj[slave].waitDSCI6 == 0 && g_Cc_CallDetail.state == ZCC_M_SEIZE_S)//ѹһʱæ
        {
            sc_timer_create(ZCCAPP_TIMER_BUSYTONE_DETECT,
                        0,
                        ZCCAPP_TIMER_BUSYTONE_INTERVAL,
                        zCcApp_BusyToneTimer,
                        NULL);  
            zte_log_append(__FILE__, __LINE__, "zte_ccapp.log","%s  zCc_SendAtDialReq sc_timer_create zCcApp_BusyToneTimer\n",__FUNCTION__);
            g_Cc_CallDetail.slaveObj[slave].tone = ZCC_TONE_BSY_A;
            g_Cc_CallDetail.slaveObj[slave].state = ZCC_S_BSYT_S;
            g_Cc_CallDetail.slaveObj[slave].confcall = 0;
            g_Cc_CallDetail.slaveObj[slave].heldcall = 0;
        }
        else
        {           
        	char num[ZDIAL_NUM_MAX+1];
        	strcpy(num, g_Cc_CallDetail.slaveObj[slave].number);
        	
            zCc_InitSlaveObj(slave);
            zte_log_append(__FILE__, __LINE__, "zte_ccapp.log","%s  zCc_InitSlaveObj: slaveObj[%d] cleared\n",__FUNCTION__, slave);

			if(zCc_find_held_cid()|| zCc_find_held_incoming_cid())  // restore prvious talk to active
			{
				zCc_SendAtChldReq(2);

				char temp[200];
                sprintf(temp, "echo \"%s get error dialout cid=%d num=%s\" > /tmp/log.ccapp.callout.err",
                	get_local_date_time(), slave, num);
                soft_system(temp);
			}
        }
        break;
    /*case MSG_CMD_ATA_RSP:
    case MSG_CMD_CHUP_RSP:
    case MSG_CMD_VTS_RSP:
    case MSG_CMD_ZIMSPLUS_RSP:
    case MSG_CMD_CCFC_RSP:
    case MSG_CMD_CLCK_RSP:
        break;*/
    case MSG_CMD_CHLD_RSP:        
                zte_log_append(__FILE__, __LINE__, "zte_ccapp.log","%s  CHLD_rsp=%d\n",__FUNCTION__,((T_zCcapp_optRsp*)ptMsgBuf->aucDataBuf)->result);
        if(g_Cc_CallDetail.waitchldresult == 1 )
        {
            g_Cc_CallDetail.waitchldresult = 0;
            if (((T_zCcapp_optRsp*)ptMsgBuf->aucDataBuf)->result == 0)
            {
                sc_timer_create(ZCCAPP_TIMER_SSDIALTONE_DETECT,
                     0,
                     ZCCAPP_TIMER_HOOKOFF_INTERVAL,
                     zCcApp_SsDialToneTimer,
                     NULL);   
                zte_log_append(__FILE__, __LINE__, "zte_ccapp.log","%s  zCc_MSeizeState:sc_timer_create zCcApp_SsDialToneTimer\n",__FUNCTION__);
                g_Cc_CallDetail.evt[0] = ZCC_DIAL_E;
                SLIC_Stop_PCM(); 
                zte_log_append(__FILE__, __LINE__, "zte_ccapp.log","%s  zCc_MSeizeState:SLIC_Stop_PCM\n",__FUNCTION__);
                }
        }
        break;

    case ZCC_SEIZE_E: // ժ
    default:
        // do nothing
        break;
    }
}


//get local time string , format"YYYY-MM-DD HH:MM:SS"
char *get_local_date_time(void)
{
	time_t now;
	struct tm *timenow;
	static char localtimestr[32];
	
	time(&now);
	timenow = localtime(&now);
	memset(localtimestr, 0, 32);
	if(timenow)
	snprintf(localtimestr, 32, "%04d-%02d-%02d %02d:%02d:%02d",
		timenow->tm_year + 1900, timenow->tm_mon+1, timenow->tm_mday,
		timenow->tm_hour, timenow->tm_min, timenow->tm_sec);
	return localtimestr;
}


//get local time string , format"MMDDHHMM"
char *get_local_datetime(char *buff)
{
	time_t now;
	struct tm *timenow;
	static char localtimestr[48];
	
	memset(localtimestr, 0, sizeof(localtimestr));

	time(&now);
	timenow = localtime(&now);
	if(timenow)
	sprintf(localtimestr, "%02d%02d%02d%02d",
		timenow->tm_mon+1, timenow->tm_mday,
		timenow->tm_hour, timenow->tm_min);

	if(buff!=NULL)
		strcpy(buff, localtimestr);
		
	return localtimestr;
}


int zCc_find_held_cid(void)
{
	int slavetmp;

	for (slavetmp = 1; slavetmp < ZCC_SLAVES; slavetmp++)
	{
		if (g_Cc_CallDetail.slaveObj[slavetmp].heldcall!=0)
		{
			return slavetmp;
		}
	}

	return 0;
}

int zCc_talking_count(void)
{
	int cnt = 0;
	int slavetmp;

	for (slavetmp = 1; slavetmp < ZCC_SLAVES; slavetmp++)
	{
		if (g_Cc_CallDetail.slaveObj[slavetmp].state==ZCC_S_TALKING_S)
			cnt++;
	}

	return cnt;
}


int zCc_find_held_incoming_cid(void)
{
	int slavetmp;

	for (slavetmp = 1; slavetmp < ZCC_SLAVES; slavetmp++)
	{
		if (g_Cc_CallDetail.slaveObj[slavetmp].state==ZCC_S_TRYING_S)
		{
			return slavetmp;
		}
	}

	return 0;
}


int zCc_find_all_callout(int slave[ZCC_SLAVES])
{
	int n=0;

	int i;
	for (i = 1; i < ZCC_SLAVES; i++)
	{
		if (g_Cc_CallDetail.slaveObj[i].is_callout!=0)
		{
			slave[n] = i;
			n++;
		}
	}

	return n;
}


void zCc_hungup_all(int slave)
{
	int slavetmp;
	if (!g_Cc_CallDetail.chupSent)
    {
        zCc_SendAtHangupReq();
        for (slavetmp = 1; slavetmp < ZCC_SLAVES; slavetmp++)
        {
            if (g_Cc_CallDetail.slaveObj[slavetmp].state == ZCC_S_DIALING_S
             || g_Cc_CallDetail.slaveObj[slavetmp].state == ZCC_S_RINGBACK_S
             || g_Cc_CallDetail.slaveObj[slavetmp].state == ZCC_S_TALKING_S
             || g_Cc_CallDetail.slaveObj[slavetmp].state == ZCC_S_TRYING_S 
             || g_Cc_CallDetail.slaveObj[slavetmp].state == ZCC_S_WAIT_RESOURCE_S)
            {
                g_Cc_CallDetail.slaveObj[slavetmp].waitDSCI6 = 1;
            }
        }
        if (!((zCc_CallCount() == 1) && ((ZCC_S_DACCM_S == g_Cc_CallDetail.slaveObj[slave].state)
            || (ZCC_S_DIALING_S == g_Cc_CallDetail.slaveObj[slave].state)))
            && !((zCc_CallCount() > 1) && (0 != zCc_MtInactiveCall()) && (0 != zCc_MoInactiveCall())))//idle״̬ժ̬յҾܽ
        {
            g_Cc_CallDetail.chupSent = TRUE;//Уظchup
        }
    }   
}

VOID zCc_RunMaster(MSG_BUF *ptMsgBuf)
{
    UINT8   slave = 0;
    UINT8   slavetmp = 0;
    SIGNAL_DATA  tSig;
    int held_call_cid;
    int incoming_call_cid;    

	static int old_state = -1;
	if(old_state != g_Cc_CallDetail.state)
	{
		ccapp_log("=======================\n");
		ccapp_log("zCc_RunMaster state %d --> %d\n", old_state, g_Cc_CallDetail.state);
		old_state = g_Cc_CallDetail.state;
	}

    memset(tSig.cid, 0, 32);

    zCc_CheckSlaveState("start zCc_RunMaster");
    switch (g_Cc_CallDetail.state)
    {
    case ZCC_M_RELEASE_S:
        zCc_MReleaseState(ptMsgBuf);
        break;

    case ZCC_M_RINGING_S:
        zCc_MRingingState(ptMsgBuf);
        break;

    case ZCC_M_SEIZE_S:
    default:
        zCc_MSeizeState(ptMsgBuf);
        break;
    }

    zCc_CheckSlaveState("in zCc_RunSlave");
    /* Now run the slaves.  Since the slaves will always be run with the master , run them now.   */
    for (slave = 0; slave < ZCC_SLAVES; slave++)
    {
        zCc_RunSlave(slave);
        g_Cc_CallDetail.evt[slave] = ZCC_NO_E;
    }

    
    /* Process sMsg.     */
    for (slave = 1; slave < ZCC_SLAVES; slave++)
    {
        if(g_Cc_CallDetail.slaveObj[slave].sMsg!=ZCC_SNO_M)
        {
            zCc_CheckSlaveState("in slaveObj[slave].sMsg");
            ccapp_log("g_Cc_CallDetail.slaveObj[%d].sMsg=%d", 
                slave, 
                g_Cc_CallDetail.slaveObj[slave].sMsg);
        }
        
        switch (g_Cc_CallDetail.slaveObj[slave].sMsg)
        {
        case ZCC_SINV_M:
            if (g_Cc_CallDetail.slaveObj[slave].state == ZCC_S_IDLE_S)//ss
            {
                zCc_SendSsReq(g_Cc_CallDetail.digits);
                g_Cc_CallDetail.slaveObj[slave].tone = ZCC_TONE_OFF_A;
            }
            else
            {
                zCc_SendAtDialReq(g_Cc_CallDetail.digits);
            }
            g_Cc_CallDetail.slaveObj[slave].sMsg = ZCC_SNO_M;
            zCc_ClearDigits();
            break;
        case ZCC_SDTMF_M:            
    zte_log_append(__FILE__, __LINE__, "zte_ccapp.log","%s  ZCC_SDTMF_M handling ptMsgBuf->aucDataBuf[0] = %d\n",__FUNCTION__,ptMsgBuf->aucDataBuf[0]);
            zCc_SendAtDtmfReq((char*)(&(ptMsgBuf->aucDataBuf[0])));
            g_Cc_CallDetail.slaveObj[slave].sMsg = ZCC_SNO_M;
			if(g_Cc_CallDetail.waitchldresult == 0)//chldвŰadd by zpr
            zCc_ClearDigits();
            break;
        case ZCC_SRING_M:
            if (g_Cc_CallDetail.state == ZCC_M_RELEASE_S)// && g_Cc_CallDetail.ringCid)
            {
                g_Cc_CallDetail.state = ZCC_M_RINGING_S;
                memset(&tSig, 0, sizeof(tSig));
                tSig.signal_type = RING_SIGNAL;
                //memcpy(tSig.cid, g_Cc_CallDetail.number, strlen(g_Cc_CallDetail.number));
				strncpy(tSig.cid, g_Cc_CallDetail.number, sizeof(tSig.cid)-1);
                get_local_datetime(tSig.date_time);
                zte_log_append(__FILE__, __LINE__, "zte_ccapp.log","%s  zCc_RunMaster RING_SIGNAL,number = %s\n",__FUNCTION__,g_Cc_CallDetail.number);
                SLIC_Play_Signal(0, 0, &tSig);  
                zCc_SetLedStatus("ledblink");
            }        
            g_Cc_CallDetail.slaveObj[slave].sMsg = ZCC_SNO_M;
            break;
        case ZCC_SANS_M://ʲô?
            if (zCc_CallCount() == 1)
            {
                SLIC_Stop_Signal(0, TONE_SIGNAL);
        zte_log_append(__FILE__, __LINE__, "zte_ccapp.log","%s  : SLIC_Stop_Signal <---\n",__FUNCTION__);
                g_Cc_CallDetail.lastTone = ZCC_TONE_OFF_A;
            }            
            g_Cc_CallDetail.slaveObj[slave].sMsg = ZCC_SNO_M;
            break;
        case ZCC_SDISCN_M:
        	held_call_cid = zCc_find_held_cid();
        	incoming_call_cid = zCc_GetSpecSlave(ZCC_S_TRYING_S);
			ccapp_log("ZCC_SDISCN_M held_call_cid=%d incoming_call_cid=%d chupSent=%d", 
			            held_call_cid,
			            incoming_call_cid,
			            g_Cc_CallDetail.chupSent);

			if((held_call_cid!=0 ||incoming_call_cid!=0) && g_Cc_CallDetail.chupSent==FALSE)
			{
				int active_call_cid = 0;

				for (slavetmp = 1; slavetmp < ZCC_SLAVES; slavetmp++)
                {
                    if( (g_Cc_CallDetail.slaveObj[slavetmp].state == ZCC_S_DIALING_S
                     || g_Cc_CallDetail.slaveObj[slavetmp].state == ZCC_S_RINGBACK_S
                     || g_Cc_CallDetail.slaveObj[slavetmp].state == ZCC_S_TALKING_S
//                     || g_Cc_CallDetail.slaveObj[slavetmp].state == ZCC_S_TRYING_S // incoming_call_cid
                     || g_Cc_CallDetail.slaveObj[slavetmp].state == ZCC_S_WAIT_RESOURCE_S) &&
                      g_Cc_CallDetail.slaveObj[slavetmp].heldcall==0)
                    {
                        active_call_cid = slavetmp;
                        break;
                    }
                }

				ccapp_log("ZCC_SDISCN_M active_call_cid=%d", active_call_cid);
				
                if(active_call_cid!=0)
                {
					zCc_SendAtChldReq(10+active_call_cid);

	                g_Cc_CallDetail.chupSent = TRUE;
	                g_Cc_CallDetail.state = ZCC_M_RINGING_S;

	                /*MSG_BUF   msgBuff      = {0};				// let while(1) run one more time
	                msgBuff.usMsgCmd   = ZCC_ASSIST_MSG_E;
	                msgBuff.src_id = MODULE_ID_SLIC;
	                zCc_SendMsgToSub(&msgBuff);

	                ccapp_log("sendMsg ZCC_ASSIST_MSG_E"); */
                }
                else
                {
					zCc_hungup_all(slave);
                }
			}
			else
        	{
	            zCc_hungup_all(slave); 
	       	}     

	        g_Cc_CallDetail.slaveObj[slave].sMsg = ZCC_SNO_M;
            break;
        default:
            break;
        }
    }

    if (g_Cc_CallDetail.state == ZCC_M_RINGING_S 
        && g_Cc_CallDetail.ringCid == 0
        && zCc_find_held_cid()==0 
        && zCc_find_held_incoming_cid()==0
        && local_test_call_st==0)
    {
        g_Cc_CallDetail.state = ZCC_M_RELEASE_S;
        SLIC_Stop_Signal(0, RING_SIGNAL);
        zte_log_append(__FILE__, __LINE__, "zte_ccapp.log","%s  : SLIC_Stop_Signal <---\n",__FUNCTION__);
    }
    /*else if (g_Cc_CallDetail.state == ZCC_M_SEIZE_S && g_Cc_CallDetail.ringCid > 0 && zCc_CallCount() == 1)
    {
        //תΪ
        һ֪粢⴦
    }*/    
    zCc_ControlTone();

    // slaveصϢ
    zCc_CheckSlaveState("End zCc_RunMaster");
}

VOID zCc_RunSlave(UINT8   slave)
{
    if (g_Cc_CallDetail.evt[slave] == ZCC_NO_E)
    {
        return;
    }
    
    /* Call respective state function based on the current state. */
    printf("[ccapp_debug]:Slave Run,slave:%d, state=%d,event=%d\n", slave, g_Cc_CallDetail.slaveObj[slave].state,g_Cc_CallDetail.evt[slave]);
    zCcSlaveFsmFunc[g_Cc_CallDetail.slaveObj[slave].state](slave);
}

VOID zCc_SIdleState(UINT8   slave)
{
    UINT8   tmpslave = 0;
    zte_log_append(__FILE__, __LINE__, "zte_ccapp.log","%s  zCc_SIdleState g_Cc_CallDetail.evt[%d] = %d\n",__FUNCTION__,slave,g_Cc_CallDetail.evt[slave]);
    g_Cc_CallDetail.slaveObj[slave].cid = slave;
    switch (g_Cc_CallDetail.evt[slave])
    {
    case ZCC_DIAL_E:
        g_Cc_CallDetail.slaveObj[slave].tone = ZCC_TONE_DIAL_A;
        g_Cc_CallDetail.slaveObj[slave].state = g_Cc_CallDetail.digits[0] != ZCC_FLASH_SIGN ? ZCC_S_DT_S : ZCC_S_DACCM_S;

        if (g_Cc_CallDetail.hookofffg == TRUE)
        {
            g_Cc_CallDetail.hookofffg = FALSE;
            sc_timer_create(ZCCAPP_TIMER_HOOKOFF_DETECT,
                            0,
                            ZCCAPP_TIMER_HOOKOFF_INTERVAL,
                            zCcApp_HookOffTimer,
                            NULL);  
    zte_log_append(__FILE__, __LINE__, "zte_ccapp.log","%s  zCc_SIdleState sc_timer_create zCcApp_HookOffTimer\n",__FUNCTION__);

			g_Cc_CallDetail.slaveObj[slave].idle_second = 0;
            sc_timer_create(ZCCAPP_TIMER_HOOKOFF_IDLE,
                            TIMER_FLAG_RESTART,
                            ZCCAPP_TIMER_HOOKOFF_IDLE_INTERVAL,
                            zCcApp_HookOff_Idle_Timer,
                            NULL);  
    zte_log_append(__FILE__, __LINE__, "zte_ccapp.log","%s  zCc_SIdleState sc_timer_create zCcApp_HookOff_Idle_Timer\n",__FUNCTION__);
        }
        break;
    case ZCC_DTMF_E://held+dailing
        if ( 0 != zCc_HeldCall() && 0 == zCc_ActiveCall())
        {    
            sc_timer_delete(ZCCAPP_TIMER_SSDIALTONE_DETECT);            
            sc_timer_create(ZCCAPP_TIMER_DTMF_DETECT,
                        0,
                        ZCCAPP_TIMER_DTMF_INTERVAL,
                        zCcApp_DtmfTimer,
                        NULL);  
    zte_log_append(__FILE__, __LINE__, "zte_ccapp.log","%s  zCc_SIdleState sc_timer_create zCcApp_DtmfTimer\n",__FUNCTION__);
            g_Cc_CallDetail.slaveObj[slave].tone = ZCC_TONE_SIL_A;          
            g_Cc_CallDetail.slaveObj[slave].state = ZCC_S_DACCM_S;
    zte_log_append(__FILE__, __LINE__, "zte_ccapp.log","%s  zCc_SIdleState handling ZCC_DTMF_E\n",__FUNCTION__);
        }
        break;
    case ZCC_CIDCW_E:
        g_Cc_CallDetail.slaveObj[slave].tone = ZCC_TONE_CIDCW_A;
         //lint -fallthrough
    case ZCC_SINVITE_E:
        zCc_ShowAllSlaveWithTips("zCc_SIdleState");
        if (((0 != zCc_GetDialingSlave(1)) || (0 != zCc_GetSpecSlave(ZCC_S_RINGBACK_S)))//Ѿ·atd ĺʱܾ
			 || (0 != zCc_MoInactiveCall()))//
        {
            //zCc_InitSlaveObj(slave);dsci6ϱ
            g_Cc_CallDetail.slaveObj[slave].state = g_Cc_CallDetail.resourceReady?ZCC_S_TRYING_S:ZCC_S_WAIT_RESOURCE_S;
    zte_log_append(__FILE__, __LINE__, "zte_ccapp.log","%s  zCc_InitSlaveObj: slaveObj[%d] cleared\n",__FUNCTION__, slave);
            g_Cc_CallDetail.slaveObj[slave].sMsg = ZCC_SDISCN_M;
            return;
        }
        
        g_Cc_CallDetail.ringCid = slave;
        if(g_Cc_CallDetail.evt[slave]==ZCC_CIDCW_E)
            g_Cc_CallDetail.slaveObj[slave].is_cidcw = TRUE;
        else
            g_Cc_CallDetail.slaveObj[slave].is_cidcw = FALSE;
        strcpy(g_Cc_CallDetail.slaveObj[slave].number, g_Cc_CallDetail.number);
        
        if (g_Cc_CallDetail.resourceReady == 1)
        {
            g_Cc_CallDetail.slaveObj[slave].sMsg = ZCC_SRING_M;
            g_Cc_CallDetail.slaveObj[slave].state = ZCC_S_TRYING_S;
        }
        else
        {
            g_Cc_CallDetail.slaveObj[slave].state = ZCC_S_WAIT_RESOURCE_S;
        }
        break;
    
    case ZCC_SRING_E://cidƥĳ
        tmpslave = zCc_GetDialingSlave(0);
        if (0 == tmpslave )
        {
            return;
        }        
        g_Cc_CallDetail.slaveObj[slave] = g_Cc_CallDetail.slaveObj[tmpslave];
        zCc_InitSlaveObj(tmpslave);
        g_Cc_CallDetail.slaveObj[slave].state = ZCC_S_RINGBACK_S;
        break;   
    case ZCC_SDISCN_MO_E://cidƥĳ
        tmpslave = zCc_GetDialingSlave(0);
        if (0 == tmpslave )
        {
            return;
        }        
        g_Cc_CallDetail.slaveObj[slave] = g_Cc_CallDetail.slaveObj[tmpslave];
        zCc_InitSlaveObj(tmpslave);
        zte_log_append(__FILE__, __LINE__, "zte_ccapp.log","%s  zCc_InitSlaveObj: slaveObj[%d] cleared\n",__FUNCTION__, tmpslave);
        if (1 == zCc_BusyToneAllowed() && g_Cc_CallDetail.slaveObj[slave].waitDSCI6 == 0&& g_Cc_CallDetail.state == ZCC_M_SEIZE_S)//ѹһʱæ
        {
            sc_timer_create(ZCCAPP_TIMER_BUSYTONE_DETECT,
                        0,
                        ZCCAPP_TIMER_BUSYTONE_INTERVAL,
                        zCcApp_BusyToneTimer,
                        NULL);  
            zte_log_append(__FILE__, __LINE__, "zte_ccapp.log","%s  zCc_SIdleState sc_timer_create zCcApp_BusyToneTimer\n",__FUNCTION__);
            g_Cc_CallDetail.slaveObj[slave].tone = ZCC_TONE_BSY_A;
            g_Cc_CallDetail.slaveObj[slave].state = ZCC_S_BSYT_S;
            g_Cc_CallDetail.slaveObj[slave].confcall = 0;
            g_Cc_CallDetail.slaveObj[slave].heldcall = 0;
        }
        else
        {           
            zCc_InitSlaveObj(slave);
            zte_log_append(__FILE__, __LINE__, "zte_ccapp.log","%s  zCc_InitSlaveObj: slaveObj[%d] cleared\n",__FUNCTION__, slave);
        }
        return;
    default:
        zte_log_append(__FILE__, __LINE__, "zte_ccapp.log","%s  zCc_SIdleState:evt=%d\n",__FUNCTION__,g_Cc_CallDetail.evt[slave]);
        break;
    }
}

VOID zCc_SDtState(UINT8   slave)
{
    zte_log_append(__FILE__, __LINE__, "zte_ccapp.log","%s  zCc_SDtState g_Cc_CallDetail.evt[%d] = %d\n",__FUNCTION__,slave, g_Cc_CallDetail.evt[slave]);
    switch (g_Cc_CallDetail.evt[slave])
    {
    case ZCC_DTMF_E:
    	sc_timer_delete(ZCCAPP_TIMER_HOOKOFF_IDLE);
    	g_Cc_CallDetail.slaveObj[slave].idle_second = 0;
    	
        sc_timer_delete(ZCCAPP_TIMER_HOOKOFF_DETECT);
        
        sc_timer_create(ZCCAPP_TIMER_DTMF_DETECT,
                    0,
                    ZCCAPP_TIMER_DTMF_INTERVAL,
                    zCcApp_DtmfTimer,
                    NULL);    
    zte_log_append(__FILE__, __LINE__, "zte_ccapp.log","%s  zCc_SDtState sc_timer_create zCcApp_DtmfTimer\n",__FUNCTION__);
        g_Cc_CallDetail.slaveObj[slave].tone = ZCC_TONE_SIL_A;
        g_Cc_CallDetail.slaveObj[slave].state = ZCC_S_DACCM_S;
        break;

    case ZCC_DISCN_E:
        //zCc_ClearDigits();
        zCc_InitSlaveObj(slave);
    zte_log_append(__FILE__, __LINE__, "zte_ccapp.log","%s  zCc_InitSlaveObj: slaveObj[%d] cleared\n",__FUNCTION__, slave);
        return;
        
    default://ֻslave0dscicidͻ
        break;
    }
}

VOID zCc_SDaccmState(UINT8   slave)
{
    zte_log_append(__FILE__, __LINE__, "zte_ccapp.log","%s  zCc_SDaccmState g_Cc_CallDetail.evt[%d] = %d\n",__FUNCTION__,slave, g_Cc_CallDetail.evt[slave]);
    UINT8   ret = 0;
    UINT8   tmpslave = 0;
    
    switch (g_Cc_CallDetail.evt[slave])
    {
    case ZCC_DTMF_E:
        sc_timer_delete(ZCCAPP_TIMER_DTMF_DETECT);
        ret = zCc_DigitsMatch();
        break;

    case ZCC_DISCN_E:
        zCc_ClearDigits();
        zCc_InitSlaveObj(slave);
        zte_log_append(__FILE__, __LINE__, "zte_ccapp.log","%s  zCc_InitSlaveObj: slaveObj[%d] cleared\n",__FUNCTION__, slave);
        return;
    case ZCC_CIDCW_E:
    case ZCC_SINVITE_E://dscicidΪ׼¸moĺзidle cid                 
        tmpslave = zCc_GetSpecSlave(ZCC_S_IDLE_S);
        if (0 == tmpslave )
        {
            return;
        } 
        g_Cc_CallDetail.slaveObj[tmpslave] =  g_Cc_CallDetail.slaveObj[slave];
        zCc_InitSlaveObj(slave);
        g_Cc_CallDetail.slaveObj[slave].sMsg = ZCC_SDISCN_M;
        g_Cc_CallDetail.slaveObj[slave].state = g_Cc_CallDetail.resourceReady?ZCC_S_TRYING_S:ZCC_S_WAIT_RESOURCE_S;
        zte_log_append(__FILE__, __LINE__, "zte_ccapp.log","%s  zCc_SDaccmState: reject mtcall\n",__FUNCTION__, slave);
        return;
    default:
        return;
    }

	if(ret==ZCC_LOCAL_TEST_CALL)
    {
    	SIGNAL_DATA tSig;
    	if(zCc_talking_count())
    	{
			zCc_ClearDigits();
			zCc_InitSlaveObj(slave);
			return;
    	}

		SLIC_Stop_Signal(0, TONE_SIGNAL);
		memset(&tSig, 0, sizeof(tSig));
    	tSig.signal_type= TONE_SIGNAL;
        tSig.tone_type = TONE_CW;
        SLIC_Play_Signal(0, 0, &tSig);

        zCc_ClearDigits();

        g_Cc_CallDetail.lastTone = ZCC_TONE_OFF_A;
        g_Cc_CallDetail.evt[slave]= ZCC_NO_E;
        g_Cc_CallDetail.slaveObj[slave].sMsg = ZCC_SNO_M;

        local_test_call_st = LocalTestCallST_Start;

        zCc_ShowAllSlaveWithTips("testCall-start");
		return ;
    }
    
    zCc_DigitsMatchRltProc(ret);
}

VOID zCc_SDialingState(UINT8   slave)
{
    UINT8   tmpslave = 0;
    zte_log_append(__FILE__, __LINE__, "zte_ccapp.log","%s  zCc_SDialingState g_Cc_CallDetail.evt[%d] = %d\n",__FUNCTION__,slave, g_Cc_CallDetail.evt[slave]);
    switch (g_Cc_CallDetail.evt[slave])
    {
    case ZCC_SRING_E:
        g_Cc_CallDetail.slaveObj[slave].state = ZCC_S_RINGBACK_S;
        break;

    case ZCC_SANS_E:
        g_Cc_CallDetail.slaveObj[slave].tone = ZCC_TONE_OFF_A;
        g_Cc_CallDetail.slaveObj[slave].state = ZCC_S_TALKING_S;
        SLIC_Stop_Signal(0, TONE_SIGNAL);
        zte_log_append(__FILE__, __LINE__, "zte_ccapp.log","%s  zCc_SDialingState: SLIC_Stop_Signal <---\n",__FUNCTION__);
        g_Cc_CallDetail.lastTone = ZCC_TONE_OFF_A;
        SLIC_Start_PCM();
    zte_log_append(__FILE__, __LINE__, "zte_ccapp.log","%s  zCc_SDialingState: SLIC_Start_PCM <---\n",__FUNCTION__);
        break;

    case ZCC_DISCN_E:
        //zCc_InitSlaveObj(slave);
        g_Cc_CallDetail.slaveObj[slave].sMsg = ZCC_SDISCN_M;
        g_Cc_CallDetail.slaveObj[slave].tone = ZCC_TONE_OFF_A;
        return;

    case ZCC_SDISCN_MO_E:
        if (1 == zCc_BusyToneAllowed() && g_Cc_CallDetail.slaveObj[slave].waitDSCI6 == 0 && g_Cc_CallDetail.state == ZCC_M_SEIZE_S)//ѹһʱæ
        {
            sc_timer_create(ZCCAPP_TIMER_BUSYTONE_DETECT,
                        0,
                        ZCCAPP_TIMER_BUSYTONE_INTERVAL,
                        zCcApp_BusyToneTimer,
                        NULL);  
            zte_log_append(__FILE__, __LINE__, "zte_ccapp.log","%s  zCc_SDialingState sc_timer_create zCcApp_BusyToneTimer\n",__FUNCTION__);
            g_Cc_CallDetail.slaveObj[slave].tone = ZCC_TONE_BSY_A;
            g_Cc_CallDetail.slaveObj[slave].state = ZCC_S_BSYT_S;
            g_Cc_CallDetail.slaveObj[slave].confcall = 0;
            g_Cc_CallDetail.slaveObj[slave].heldcall = 0;
        }
        else
        {           
            zCc_InitSlaveObj(slave);
    zte_log_append(__FILE__, __LINE__, "zte_ccapp.log","%s  zCc_InitSlaveObj: slaveObj[%d] cleared\n",__FUNCTION__, slave);
        }
        return;
    case ZCC_SDISCN_MT_E:
        zCc_InitSlaveObj(slave);//в
        //g_Cc_CallDetail.slaveObj[slave].waitDSCI6 = 0;
        return;
    case ZCC_CIDCW_E:
    case ZCC_SINVITE_E://dscicidΪ׼¸moĺзidle cid                 
        tmpslave = zCc_GetSpecSlave(ZCC_S_IDLE_S);
        if (0 == tmpslave )
        {
            return;
        } 
        g_Cc_CallDetail.slaveObj[tmpslave] =  g_Cc_CallDetail.slaveObj[slave];
        zCc_InitSlaveObj(slave);
        g_Cc_CallDetail.slaveObj[slave].sMsg = ZCC_SDISCN_M;
        g_Cc_CallDetail.slaveObj[slave].state = g_Cc_CallDetail.resourceReady?ZCC_S_TRYING_S:ZCC_S_WAIT_RESOURCE_S;
        zte_log_append(__FILE__, __LINE__, "zte_ccapp.log","%s  zCc_SDaccmState: reject mtcall\n",__FUNCTION__, slave);
        return;
        
    default:
        return;
    }
}

VOID zCc_SRingbackState(UINT8   slave)
{
    zte_log_append(__FILE__, __LINE__, "zte_ccapp.log","%s  zCc_SRingbackState g_Cc_CallDetail.evt[%d] = %d\n",__FUNCTION__,slave, g_Cc_CallDetail.evt[slave]);
    switch (g_Cc_CallDetail.evt[slave])
    {
    case ZCC_SANS_E:
        g_Cc_CallDetail.slaveObj[slave].tone = ZCC_TONE_OFF_A;
        g_Cc_CallDetail.slaveObj[slave].state = ZCC_S_TALKING_S;
        SLIC_Stop_Signal(0, TONE_SIGNAL);
        zte_log_append(__FILE__, __LINE__, "zte_ccapp.log","%s  zCc_SRingbackState: SLIC_Stop_Signal <---\n",__FUNCTION__);
        g_Cc_CallDetail.lastTone = ZCC_TONE_OFF_A;
        
        if(g_Cc_CallDetail.slaveObj[slave].is_callout)
        	SLIC_PolarityReverse(0, TRUE);
        
        SLIC_Start_PCM();
    zte_log_append(__FILE__, __LINE__, "zte_ccapp.log","%s  zCc_SRingbackState SLIC_Start_PCM2222\n",__FUNCTION__);
        break;

    case ZCC_DISCN_E:
        //zCc_InitSlaveObj(slave);
        g_Cc_CallDetail.slaveObj[slave].sMsg = ZCC_SDISCN_M;
        g_Cc_CallDetail.slaveObj[slave].tone = ZCC_TONE_OFF_A;
        return;

    case ZCC_SDISCN_MO_E:
        if (1 == zCc_BusyToneAllowed() && g_Cc_CallDetail.slaveObj[slave].waitDSCI6 == 0 &&  g_Cc_CallDetail.state == ZCC_M_SEIZE_S)//ʱæ
        {
            sc_timer_create(ZCCAPP_TIMER_BUSYTONE_DETECT,
                        0,
                        ZCCAPP_TIMER_BUSYTONE_INTERVAL,
                        zCcApp_BusyToneTimer,
                        NULL);  
            zte_log_append(__FILE__, __LINE__, "zte_ccapp.log","%s  zCc_SRingbackState sc_timer_create zCcApp_BusyToneTimer\n",__FUNCTION__);
            g_Cc_CallDetail.slaveObj[slave].tone = ZCC_TONE_BSY_A;
            g_Cc_CallDetail.slaveObj[slave].state = ZCC_S_BSYT_S;
            g_Cc_CallDetail.slaveObj[slave].confcall = 0;
            g_Cc_CallDetail.slaveObj[slave].heldcall = 0;
            SLIC_Stop_PCM();
            zte_log_append(__FILE__, __LINE__, "zte_ccapp.log","%s  zCc_SRingbackState SLIC_Stop_PCM\n",__FUNCTION__);
        }
        else
        {
            zCc_InitSlaveObj(slave);
            if ( 0 == zCc_ActiveCall() && 0 == zCc_HeldCall())
            {
                SLIC_Stop_PCM();
            zte_log_append(__FILE__, __LINE__, "zte_ccapp.log","%s  zCc_SRingbackState SLIC_Stop_PCM\n",__FUNCTION__);
            }
    zte_log_append(__FILE__, __LINE__, "zte_ccapp.log","%s  zCc_InitSlaveObj: slaveObj[%d] cleared\n",__FUNCTION__, slave);
        }
        return;
    case ZCC_SDISCN_MT_E:
        g_Cc_CallDetail.slaveObj[slave].waitDSCI6 = 0;
        return;
        
    case ZCC_DTMF_E: // 
        g_Cc_CallDetail.slaveObj[slave].sMsg = ZCC_SDTMF_M;///???
        return;

    case ZCC_RESOURCE_READY_E:           
        g_Cc_CallDetail.slaveObj[slave].tone = ZCC_TONE_OFF_A;
        zte_log_append(__FILE__, __LINE__, "zte_ccapp.log","%s  zCc_SRingbackState: SLIC_Stop_Signal <---\n",__FUNCTION__);
        SLIC_Stop_Signal(0, TONE_SIGNAL);
        g_Cc_CallDetail.lastTone = ZCC_TONE_OFF_A;
        SLIC_Start_PCM();//Դѷ䣬
        zte_log_append(__FILE__, __LINE__, "zte_ccapp.log","%s  zCc_SRingbackState SLIC_Start_PCM\n",__FUNCTION__);
        return;
        
    default:
        return;
    }
}

VOID zCc_STalkingState(UINT8   slave)
{
    zte_log_append(__FILE__, __LINE__, "zte_ccapp.log","%s  zCc_STalkingState g_Cc_CallDetail.evt[%d] = %d\n",__FUNCTION__,slave, g_Cc_CallDetail.evt[slave]);
    switch (g_Cc_CallDetail.evt[slave])
    {
    case ZCC_DISCN_E:
        //zCc_InitSlaveObj(slave);
        g_Cc_CallDetail.slaveObj[slave].sMsg = ZCC_SDISCN_M;
        g_Cc_CallDetail.slaveObj[slave].tone = ZCC_TONE_OFF_A;
        return;

    case ZCC_SDISCN_MO_E:  
    case ZCC_SDISCN_MT_E:
        //zCc_InitSlaveObj(slave);
        if (zCc_CallCount() >= 2 || g_Cc_CallDetail.state == ZCC_M_RELEASE_S)//ʣһ·
        {
            zCc_InitSlaveObj(slave);
    zte_log_append(__FILE__, __LINE__, "zte_ccapp.log","%s  zCc_InitSlaveObj: slaveObj[%d] cleared\n",__FUNCTION__, slave);
            break;
        }             
        if (g_Cc_CallDetail.slaveObj[0].tone != ZCC_TONE_OFF_A)
        {                   
            zCc_InitSlaveObj(0);
        }                             
        if (1 == zCc_BusyToneAllowed() && g_Cc_CallDetail.slaveObj[slave].waitDSCI6 == 0)//ʱæ
        {
            sc_timer_create(ZCCAPP_TIMER_BUSYTONE_DETECT,
                        0,
                        ZCCAPP_TIMER_BUSYTONE_INTERVAL,
                        zCcApp_BusyToneTimer,
                        NULL);  
            zte_log_append(__FILE__, __LINE__, "zte_ccapp.log","%s  zCc_STalkingState sc_timer_create zCcApp_BusyToneTimer\n",__FUNCTION__);
            g_Cc_CallDetail.slaveObj[slave].tone = ZCC_TONE_BSY_A;
            g_Cc_CallDetail.slaveObj[slave].state = ZCC_S_BSYT_S;
            g_Cc_CallDetail.slaveObj[slave].confcall = 0;
            g_Cc_CallDetail.slaveObj[slave].heldcall = 0;
        }
        else
        {
            zCc_InitSlaveObj(slave);
    zte_log_append(__FILE__, __LINE__, "zte_ccapp.log","%s  zCc_InitSlaveObj: slaveObj[%d] cleared\n",__FUNCTION__, slave);
        }
        return;
        
    case ZCC_DTMF_E: // . Ĵ
        if (g_Cc_CallDetail.slaveObj[slave].heldcall == 0)
        {
            g_Cc_CallDetail.slaveObj[slave].sMsg = ZCC_SDTMF_M;///???
        }
        return;
    default:
        return;
    }
}

VOID zCc_SWaitResourceState(UINT8   slave)
{
    zte_log_append(__FILE__, __LINE__, "zte_ccapp.log","%s  zCc_SWaitResourceState g_Cc_CallDetail.evt[%d] = %d\n",__FUNCTION__,slave, g_Cc_CallDetail.evt[slave]);
    switch (g_Cc_CallDetail.evt[slave])
    {
    case ZCC_RESOURCE_READY_E:
        g_Cc_CallDetail.slaveObj[slave].sMsg = ZCC_SRING_M;
        g_Cc_CallDetail.slaveObj[slave].state = ZCC_S_TRYING_S;
        break;

    case ZCC_SDISCN_MT_E:
        zCc_InitSlaveObj(slave);
    zte_log_append(__FILE__, __LINE__, "zte_ccapp.log","%s  zCc_InitSlaveObj: slaveObj[%d] cleared\n",__FUNCTION__, slave);
        return;
        
    default:
        return;
    }
}

VOID zCc_STryingState(UINT8   slave)
{
    zte_log_append(__FILE__, __LINE__, "zte_ccapp.log","%s  zCc_STryingState g_Cc_CallDetail.evt[%d] = %d\n",__FUNCTION__,slave, g_Cc_CallDetail.evt[slave]);
    switch (g_Cc_CallDetail.evt[slave])
    {
    case ZCC_CNCT_E:
        g_Cc_CallDetail.slaveObj[slave].sMsg = ZCC_SANS_M;
        //lint -fallthrough
    case ZCC_SANS_E: //CHLD=2, յDSCIǨ״̬
        g_Cc_CallDetail.slaveObj[slave].tone = ZCC_TONE_OFF_A;
        g_Cc_CallDetail.slaveObj[slave].state = ZCC_S_TALKING_S;
        g_Cc_CallDetail.ringCid = 0;
        SLIC_Stop_Signal(0, TONE_SIGNAL);
        zte_log_append(__FILE__, __LINE__, "zte_ccapp.log","%s  zCc_STryingState: SLIC_Stop_Signal <---\n",__FUNCTION__);
        g_Cc_CallDetail.lastTone = ZCC_TONE_OFF_A;
        SLIC_Start_PCM();
    zte_log_append(__FILE__, __LINE__, "zte_ccapp.log","%s  zCc_STryingState SLIC_Start_PCM\n",__FUNCTION__);
        break;

    case ZCC_SDISCN_MT_E:
        zCc_InitSlaveObj(slave);
    zte_log_append(__FILE__, __LINE__, "zte_ccapp.log","%s  zCc_InitSlaveObj: slaveObj[%d] cleared\n",__FUNCTION__, slave);
        return;

    case ZCC_DISCN_E://trying ̬յһϢֻժ̬(еȴ)ĳ
        g_Cc_CallDetail.slaveObj[slave].tone = ZCC_TONE_OFF_A;
        SLIC_Stop_Signal(0, TONE_SIGNAL);
        zte_log_append(__FILE__, __LINE__, "zte_ccapp.log","%s  zCc_STryingState: SLIC_Stop_Signal <---\n",__FUNCTION__);
        g_Cc_CallDetail.lastTone = ZCC_TONE_OFF_A;
        if (1 == zCc_CallCount() && (zCc_GetDiscSlave(ZCC_SDISCN_M) == 0)// ժ̬ʱһǰֻһ·Уת
        ||(2 == zCc_CallCount()  
            && (0 != zCc_GetSpecSlave(ZCC_S_DACCM_S)
             ||0 != zCc_GetSpecSlave(ZCC_S_BSYT_S)
             ||0 != zCc_GetSpecSlave(ZCC_S_TKYT_S)
             ||0 != zCc_GetSpecSlave(ZCC_S_SIL_S))))//ժ磬ٲţһҲҪ
        {
            g_Cc_CallDetail.slaveObj[slave].sMsg = ZCC_SRING_M;
        }
        else
        {
            //zCc_InitSlaveObj(slave);
            g_Cc_CallDetail.slaveObj[slave].tone = ZCC_TONE_OFF_A;
            g_Cc_CallDetail.ringCid = 0;
            g_Cc_CallDetail.slaveObj[slave].sMsg = ZCC_SDISCN_M;
        }
        return;
        
    default:
        return;
    }
}

VOID zCc_SBsyToneState(UINT8   slave)
{
    zte_log_append(__FILE__, __LINE__, "zte_ccapp.log","%s  zCc_SBsyToneState g_Cc_CallDetail.evt[%d] = %d\n",__FUNCTION__,slave, g_Cc_CallDetail.evt[slave]);
    switch (g_Cc_CallDetail.evt[slave])
    {
    case ZCC_DISCN_E:
        zCc_InitSlaveObj(slave);
    zte_log_append(__FILE__, __LINE__, "zte_ccapp.log","%s  zCc_InitSlaveObj: slaveObj[%d] cleared\n",__FUNCTION__, slave);
        return;  
    case ZCC_CIDCW_E:
        g_Cc_CallDetail.slaveObj[slave].tone = ZCC_TONE_CIDCW_A;
         //lint -fallthrough
    case ZCC_SINVITE_E:
        if ((0 != zCc_GetDialingSlave(1)) || (0 != zCc_GetSpecSlave(ZCC_S_RINGBACK_S)))//Ѿ·atd ĺʱܾ
        {
            zCc_InitSlaveObj(slave);
    zte_log_append(__FILE__, __LINE__, "zte_ccapp.log","%s  zCc_InitSlaveObj: slaveObj[%d] cleared\n",__FUNCTION__, slave);
            g_Cc_CallDetail.evt[slave] = ZCC_DISCN_E;
            return;
        }
        g_Cc_CallDetail.ringCid = slave;
        
        if(g_Cc_CallDetail.evt[slave]==ZCC_CIDCW_E)
            g_Cc_CallDetail.slaveObj[slave].is_cidcw = TRUE;
        else
            g_Cc_CallDetail.slaveObj[slave].is_cidcw = FALSE;
            
        if (g_Cc_CallDetail.resourceReady == 1)
        {
            g_Cc_CallDetail.slaveObj[slave].sMsg = ZCC_SRING_M;
            g_Cc_CallDetail.slaveObj[slave].state = ZCC_S_TRYING_S;
        }
        else
        {
            g_Cc_CallDetail.slaveObj[slave].state = ZCC_S_WAIT_RESOURCE_S;
        }
        break;   
    default:
        return;
    }
}

VOID zCc_STkytState(UINT8   slave)
{
    zte_log_append(__FILE__, __LINE__, "zte_ccapp.log","%s  zCc_STkytState g_Cc_CallDetail.evt[%d] = %d\n",__FUNCTION__,slave, g_Cc_CallDetail.evt[slave]);
    switch (g_Cc_CallDetail.evt[slave])
    {
    case ZCC_DISCN_E:
        zCc_InitSlaveObj(slave);
    zte_log_append(__FILE__, __LINE__, "zte_ccapp.log","%s  zCc_InitSlaveObj: slaveObj[%d] cleared\n",__FUNCTION__, slave);
        return; 
    case ZCC_CIDCW_E:
        g_Cc_CallDetail.slaveObj[slave].tone = ZCC_TONE_CIDCW_A;
         //lint -fallthrough
    case ZCC_SINVITE_E:
        if ((0 != zCc_GetDialingSlave(1)) || (0 != zCc_GetSpecSlave(ZCC_S_RINGBACK_S)))//Ѿ·atd ĺʱܾ
        {
            zCc_InitSlaveObj(slave);
    zte_log_append(__FILE__, __LINE__, "zte_ccapp.log","%s  zCc_InitSlaveObj: slaveObj[%d] cleared\n",__FUNCTION__, slave);
            g_Cc_CallDetail.evt[slave] = ZCC_DISCN_E;
            return;
        }
        g_Cc_CallDetail.ringCid = slave;

        if(g_Cc_CallDetail.evt[slave]==ZCC_CIDCW_E)
            g_Cc_CallDetail.slaveObj[slave].is_cidcw = TRUE;
        else
            g_Cc_CallDetail.slaveObj[slave].is_cidcw = FALSE;
            
        if (g_Cc_CallDetail.resourceReady == 1)
        {
            g_Cc_CallDetail.slaveObj[slave].sMsg = ZCC_SRING_M;
            g_Cc_CallDetail.slaveObj[slave].state = ZCC_S_TRYING_S;
        }
        else
        {
            g_Cc_CallDetail.slaveObj[slave].state = ZCC_S_WAIT_RESOURCE_S;
        }
        break;       
    default:
        return;
    }
}

VOID zCc_SSilState(UINT8   slave)
{
    zte_log_append(__FILE__, __LINE__, "zte_ccapp.log","%s  zCc_SSilState g_Cc_CallDetail.evt[%d] = %d\n",__FUNCTION__,slave, g_Cc_CallDetail.evt[slave]);
    switch (g_Cc_CallDetail.evt[slave])
    {
    case ZCC_DISCN_E:
        zCc_InitSlaveObj(slave);
    zte_log_append(__FILE__, __LINE__, "zte_ccapp.log","%s  zCc_InitSlaveObj: slaveObj[%d] cleared\n",__FUNCTION__, slave);
        return;
    case ZCC_CIDCW_E:
        g_Cc_CallDetail.slaveObj[slave].tone = ZCC_TONE_CIDCW_A;
         //lint -fallthrough
    case ZCC_SINVITE_E:
        if ((0 != zCc_GetDialingSlave(1)) || (0 != zCc_GetSpecSlave(ZCC_S_RINGBACK_S)))//Ѿ·atd ĺʱܾ
        {
            zCc_InitSlaveObj(slave);
    zte_log_append(__FILE__, __LINE__, "zte_ccapp.log","%s  zCc_InitSlaveObj: slaveObj[%d] cleared\n",__FUNCTION__, slave);
            g_Cc_CallDetail.evt[slave] = ZCC_DISCN_E;
            return;
        }
        g_Cc_CallDetail.ringCid = slave;

        if(g_Cc_CallDetail.evt[slave]==ZCC_CIDCW_E)
            g_Cc_CallDetail.slaveObj[slave].is_cidcw = TRUE;
        else
            g_Cc_CallDetail.slaveObj[slave].is_cidcw = FALSE;
            
        if (g_Cc_CallDetail.resourceReady == 1)
        {
            g_Cc_CallDetail.slaveObj[slave].sMsg = ZCC_SRING_M;
            g_Cc_CallDetail.slaveObj[slave].state = ZCC_S_TRYING_S;
        }
        else
        {
            g_Cc_CallDetail.slaveObj[slave].state = ZCC_S_WAIT_RESOURCE_S;
        }
        break;
        
    default:
        return;
    }
}


