#include "zte_web_net_other.h"
#include "../wifi/zte_web_lan_utils.h"
#include "zte_web_mgmt.h"
#include "wifi.h"

#include <stdlib.h>
//#include <linux/wireless.h>
#include <sys/ioctl.h>
#include "message.h"
#include "softap_api.h"

#define NV_MACIP_LIST_MAX_LEN 500

#define safe_free(x) do { if(x) {free(x); x=NULL;} } while(0)

//extern void zte_get_wifi_sta_list(RT_802_11_MAC_TABLE *staList);

//ĳIPַǷΪû̬õնIPַ
BOOL zte_is_static_dhcp_ip(char *ipAddr)
{
	char list[NV_MACIP_LIST_MAX_LEN] = {0};

	sc_cfg_get("mac_ip_list", list, sizeof(list));
	if (strlen(list) == 0) {
		return FALSE;
	}

	if (strstr(list, ipAddr) == NULL) {
		return FALSE;
	}

	return TRUE;
}

//ڼǷΪUSBMACַ
static BOOL zte_is_usb_mac(unsigned char mac[])
{
	/*
	char mac0[3] = {0};
	char mac1[3] = {0};
	char mac2[3] = {0};

	sprintf(mac0, "%02X", mac[0]);
	sprintf(mac1, "%02X", mac[1]);
	sprintf(mac2, "%02X", mac[2]);
	*/

	BOOL ret = TRUE;
	int i;
	size_t read_len = 0;

	FILE *usb_mac_file = NULL;
	unsigned char usb_mac[7] = {0};

	usb_mac_file = fopen("/var/usbmac", "r");
	if (usb_mac_file != NULL) {
		read_len = fread(usb_mac, sizeof(usb_mac[0]), 7, usb_mac_file);
		if(read_len != 7)
		{
		    slog(MISC_PRINT, SLOG_DEBUG, "read len :%d \n", read_len);
		}
		fclose(usb_mac_file);
	}

	//printf("is_usb_mac stored usbmac %x %x %x %x %x %x\n",usb_mac[0],usb_mac[1],usb_mac[2],usb_mac[3],usb_mac[4],usb_mac[5]);
	//printf("is_usb_mac lease mac %x %x %x %x %x %x\n",mac[0],mac[1],mac[2],mac[3],mac[4],mac[5]);

	for (i = 0; i < 6; i++) {

		if (usb_mac[i] != mac[i]) {
			ret = FALSE;
			break;
		}
	}

	/*
	if (strcmp(mac0, "00") == 0 && strcmp(mac1, "A0") == 0 && strcmp(mac2, "C6") == 0)
	{
		fprintf(stderr, "current mac is from usb");
		return TRUE;
	}
	*/

	return ret;
}

//MTU 
void zte_mtu_set(webs_t wp)
{
	char_t *new_mtu = NULL;

	new_mtu = websGetVar(wp, T("mtu"), T(""));

	if ('\0' == (*new_mtu)) {
		zte_write_result_to_web(wp, FAILURE);
		return;
	}

	slog(MISC_PRINT, SLOG_DEBUG, "mtu_set new_mtu= %s\n", new_mtu);

	(void)zte_web_write("mtu", new_mtu);
	slog(MISC_PRINT, SLOG_NORMAL, "mtu_set MESSAGE TO MC START");
	//zte_send_message(MODULE_ID_MAIN_CTRL, MSG_CMD_NET_MTU, 0, 0);
	ipc_send_message(MODULE_ID_WEB_CGI, MODULE_ID_MAIN_CTRL, MSG_CMD_NET_MTU, 0, NULL, 0);
	slog(MISC_PRINT, SLOG_DEBUG, "mtu_set MESSAGE TO MC END");

	//sc_cfg_save();

	zte_write_result_to_web(wp, SUCCESS);
}

//ֶDNS mode
/*void zte_dns_mode_set(webs_t wp)
{
    char_t *pswan_dns_mode = NULL;
    char_t *pswan_ipv6_dns_mode = NULL;

    pswan_dns_mode = websGetVar(wp, T("pswan_dns_mode"), T(""));
    pswan_ipv6_dns_mode = websGetVar(wp, T("pswan_ipv6_dns_mode"), T(""));

    if ('\0' == (*pswan_dns_mode) && '\0' == (*pswan_ipv6_dns_mode))
    {
        zte_write_result_to_web(wp, FAILURE);
		return;
    }

    if (('\0' != (*pswan_dns_mode) && strcmp(pswan_dns_mode, "auto") && strcmp(pswan_dns_mode, "manual"))
        || ('\0' != (*pswan_ipv6_dns_mode) && strcmp(pswan_ipv6_dns_mode, "auto") && strcmp(pswan_ipv6_dns_mode, "manual")))
    {
        zte_write_result_to_web(wp, FAILURE);
		return;
    }

    if ('\0' != (*pswan_dns_mode))
        (void)zte_web_write("pswan_dns_mode", pswan_dns_mode);

    if ('\0' != (*pswan_ipv6_dns_mode))
        (void)zte_web_write("pswan_ipv6_dns_mode", pswan_ipv6_dns_mode);

	//sc_cfg_save();
    zte_write_result_to_web(wp, SUCCESS);
}
*/
//ֶDNS server --- ʱֻ֧pswan
/*void zte_dns_server_set(webs_t wp)
{
    char_t *pswan_pridns = NULL;
    char_t *pswan_secdns = NULL;
    char_t *pswan_ipv6_pridns = NULL;
    char_t *pswan_ipv6_secdns = NULL;

    pswan_pridns = websGetVar(wp, T("pswan_pridns_manual"), T(""));
    pswan_secdns = websGetVar(wp, T("pswan_secdns_manual"), T(""));
    pswan_ipv6_pridns = websGetVar(wp, T("pswan_ipv6_pridns_manual"), T(""));
    pswan_ipv6_secdns = websGetVar(wp, T("pswan_ipv6_secdns_manual"), T(""));

    printf("dns_server_set: %s - %s - %s - %s \n", pswan_pridns, pswan_secdns, pswan_ipv6_pridns, pswan_ipv6_secdns);

    if ('\0' == (*pswan_pridns) && '\0' == (*pswan_secdns) && '\0' == (*pswan_ipv6_pridns) && '\0' == (*pswan_ipv6_secdns))
    {
        zte_write_result_to_web(wp, FAILURE);
		return;
    }

    //˵ַǴ
    if (('\0' != (*pswan_pridns) && !isIpValid(pswan_pridns))
        || ('\0' != (*pswan_secdns) && !isIpValid(pswan_secdns))
        || ('\0' != (*pswan_ipv6_pridns) && !isIpv6Valid(pswan_ipv6_pridns))
        || ('\0' != (*pswan_ipv6_secdns) && !isIpv6Valid(pswan_ipv6_secdns)))
    {
        zte_write_result_to_web(wp, FAILURE);
		return;
    }

    if ('\0' != (*pswan_pridns))
        (void)zte_web_write("pswan_pridns_manual", pswan_pridns);
    if ('\0' != (*pswan_secdns))
        (void)zte_web_write("pswan_secdns_manual", pswan_secdns);
    if ('\0' != (*pswan_ipv6_pridns))
        (void)zte_web_write("pswan_ipv6_pridns_manual", pswan_ipv6_pridns);
    if ('\0' != (*pswan_ipv6_secdns))
        (void)zte_web_write("pswan_ipv6_secdns_manual", pswan_ipv6_secdns);

	//sc_cfg_save();

    zte_write_result_to_web(wp, SUCCESS);
}
*/

//༭MACͶӦ
void zte_edit_hostname(webs_t wp)
{
	char_t *mac = NULL;
	char_t *hostname = NULL;
	struct mac_hostname_info mac_hostname_info;

	mac = websGetVar(wp, T("mac"), T(""));
	hostname = websGetVar(wp, T("hostname"), T(""));

	slog(NET_PRINT, SLOG_ERR, "edit_hostname:mac= %s, hostname = %s\nlen=%d", mac, hostname, strlen(hostname));
	if ((strcmp(hostname, "") == 0) || (strlen(mac) != 17)) {
		zte_write_result_to_web(wp, FAILURE);
		return;
	}

	strncpy(mac_hostname_info.mac, mac,sizeof(mac_hostname_info.mac)-1);
	strncpy(mac_hostname_info.hostname, hostname,sizeof(mac_hostname_info.hostname)-1);

	slog(MISC_PRINT, SLOG_NORMAL, "edit_hostname MESSAGE TO MC START");
	//zte_send_message(MODULE_ID_MAIN_CTRL, MSG_CMD_NET_GET_HOSTNAME, sizeof(struct mac_hostname_info), (UCHAR *)&mac_hostname_info);
	ipc_send_message(MODULE_ID_WEB_CGI, MODULE_ID_MAIN_CTRL, MSG_CMD_NET_GET_HOSTNAME, sizeof(struct mac_hostname_info), (UCHAR *)&mac_hostname_info, 0);
	slog(MISC_PRINT, SLOG_DEBUG, "edit_hostname MESSAGE TO MC END");
	Sleep(2);
	zte_write_result_to_web(wp, SUCCESS);
}

//ļжȡMACͶӦʾwebui
void zte_get_hostnamelist(webs_t wp)
{
	FILE *hostname_mac_file = NULL;
	char line[200] = {0};
	char line_mac[18] = {0};
	char line_hostname[150] = {0};

	BOOL first = TRUE;

	char path_conf[50] = {0};
	char path_file[100] = {0};
	sc_cfg_get("path_conf", path_conf, sizeof(path_conf));
	sprintf(path_file, "%s/hostname_mac_file", path_conf);

	web_feedback_header(wp);
	zte_rest_cmd_write_head(wp);
	(void)websWrite(wp, T("\"%s\":["), DEVICES);
	hostname_mac_file = fopen(path_file, "r");
	if (hostname_mac_file == NULL) {
		slog(MISC_PRINT, SLOG_ERR, "can not open file hostname_mac_file.");
		goto out;
	}

	while (fgets(line, 200, hostname_mac_file) != NULL) {
		if (first == FALSE) {
			(void)websWrite(wp, T(","));
		} else {
			first = FALSE;
		}
		strncpy(line_mac, line, 17);
		if((strlen(line) - 19) < 150)
			snprintf(line_hostname,strlen(line) -18,"%s",line + 18);
		//strncpy(line_hostname, line + 18, strlen(line) - 19);
		if (strncmp(line_mac, "", sizeof(line_mac)) != 0 && strncmp(line_hostname, "", sizeof(line_hostname)) != 0) {
			(void)websWrite(wp, T("{\"%s\":\"%s\",\"%s\":\"%s\"}"), HOSTANME, line_hostname, MAC, line_mac);
		}

		memset(line, 0, sizeof(line));
		memset(line_mac, 0, sizeof(line_mac));
		memset(line_hostname, 0, sizeof(line_hostname));

	}
	fclose(hostname_mac_file);

out:
	(void)websWrite(wp, T("]"));
	zte_rest_cmd_write_foot(wp);
}

/* * check the existence of semicolon in str */
int checkSemicolon(char *str)
{
	char *c = strchr(str, ';');
	if (c)
		return 1;
	return 0;
}

void zte_goform_ddns(webs_t wp)
{

	char *ddns_provider, *ddns, *DDNS_Hash_Value, *ddns_acc, *ddns_pass, *DDNS_Enable, *DDNS_Mode;
	//char empty_char = '\0';

	DDNS_Enable = websGetVar(wp, T("DDNS_Enable"), T("1"));
	DDNS_Mode = websGetVar(wp, T("DDNS_Mode"), T("manual"));
	ddns_provider = websGetVar(wp, T("DDNSProvider"), T("none"));
	ddns = websGetVar(wp, T("DDNS"), T(""));
	DDNS_Hash_Value = websGetVar(wp, T("DDNS_Hash_Value"), T(""));
	ddns_acc = websGetVar(wp, T("DDNSAccount"), T(""));
	ddns_pass = websGetVar(wp, T("DDNSPassword"), T(""));

	if (strcmp(DDNS_Enable, "0")) { //disable
		if (!ddns_provider || !ddns || !ddns_acc || !ddns_pass) {
			zte_write_result_to_web(wp, FAILURE);
			return;
		}
		if (!strcmp(T("none"), ddns_provider)) {
			//ddns = ddns_acc = ddns_pass = DDNS_Hash_Value = T("");//&empty_char;//cov
		} else {
			if (!strlen(ddns) || !strlen(ddns_acc) || !strlen(ddns_pass)) {
				zte_write_result_to_web(wp, FAILURE);
				return;
			}
		}

		if (checkSemicolon(ddns) || checkSemicolon(ddns_acc) || checkSemicolon(ddns_pass)) {
			zte_write_result_to_web(wp, FAILURE);
			return;
		}
		sc_cfg_set("DDNS_Mode", DDNS_Mode);
		sc_cfg_set("DDNSProvider", ddns_provider);
		if(!strcmp(T("none"), ddns_provider))// kw OVERWRITE_CONST_CHAR
		{
			sc_cfg_set("DDNS", "");
			sc_cfg_set("DDNS_Hash_Value", "");
			sc_cfg_set("DDNSAccount", "");
			sc_cfg_set("DDNSPassword", "");
		}
		else
		{
			sc_cfg_set("DDNS", ddns);
			sc_cfg_set("DDNS_Hash_Value", DDNS_Hash_Value);
			sc_cfg_set("DDNSAccount", ddns_acc);
			sc_cfg_set("DDNSPassword", ddns_pass);
		}
	}
	sc_cfg_set("DDNS_Enable", DDNS_Enable);
	//sc_cfg_save();

	system("ddns.sh");
	zte_write_result_to_web(wp, SUCCESS);
}

//parent control nv set
void zte_parent_control_set(webs_t wp)
{
	char* time_limited = NULL;
	char old_time_limited[512] = {0};
	sc_cfg_get("time_limited", old_time_limited, sizeof(old_time_limited));
	time_limited = websGetVar(wp, T("time_limited"), T(""));
	slog(MISC_PRINT, SLOG_DEBUG,"[%s]time_limited=%s,old_time_limited=%s\n", __FUNCTION__, time_limited, old_time_limited);

	//parent control time has no open/close button,so if time_limited is null,
	//means close , if time_limited is not null, means set
#if 0
	if (time_limited == NULL || *time_limited == '\0') {
		printf("parent_control_set: invalid input para\n");/*lint !e26*/
		zte_write_result_to_web(wp, FAILURE);
		return;
	}
#endif

	if (strcmp(time_limited, old_time_limited) == 0) {
		slog(MISC_PRINT, SLOG_NORMAL,"[%s]para not changed\n", __FUNCTION__); /*lint !e26*/
		zte_write_result_to_web(wp, SUCCESS);
		return;
	} else {
		sc_cfg_set("time_limited", time_limited);
		if (strcmp(time_limited, "") == 0) {
			slog(MISC_PRINT, SLOG_NORMAL,"[%s]send to parent control set : MSG_CMD_PARENT_CONTROL_CLOSE\n", __FUNCTION__);
			//zte_send_message(MODULE_ID_PARENT_CONTROL_SET,MSG_CMD_PARENT_CONTROL_CLOSE,0,NULL);
			ipc_send_message(MODULE_ID_WEB_CGI, MODULE_ID_PARENT_CONTROL_SET, MSG_CMD_PARENT_CONTROL_CLOSE, 0, NULL, 0);
		} else {
			slog(MISC_PRINT, SLOG_NORMAL,"[%s]send to parent control set : MSG_CMD_PARENT_CONTROL_SET\n", __FUNCTION__);
			//zte_send_message(MODULE_ID_PARENT_CONTROL_SET,MSG_CMD_PARENT_CONTROL_SET,0,NULL);
			ipc_send_message(MODULE_ID_WEB_CGI, MODULE_ID_PARENT_CONTROL_SET, MSG_CMD_PARENT_CONTROL_SET, 0, NULL, 0);
		}
	}
	zte_write_result_to_web(wp, SUCCESS);
}

//ʱ
void zte_get_poweron_time(webs_t wp)
{
	unsigned long cur_time;

	slog(MISC_PRINT, SLOG_NORMAL,"get_poweron_time enter \n");

	cur_time = time_sec();

	web_feedback_header(wp);
	zte_rest_cmd_write_head(wp);
	zte_rest_cmd_write_int(wp, "poweron_time", cur_time, 0);
	zte_rest_cmd_write_foot(wp);
	slog(MISC_PRINT, SLOG_DEBUG,"get_poweron_time cur_time:%lu \n", cur_time);
}

