


#ifndef boolean
#define boolean unsigned char
#endif

#ifndef PBM_MAX_DEL_LEN
#define PBM_MAX_DEL_LEN 50
#endif

#ifndef ZTE_PB_INDEX_MAX
#define ZTE_PB_INDEX_MAX 100
#endif

#ifndef ZTE_WEB_PBM_REC_LEN
#define ZTE_WEB_PBM_REC_LEN  32
#endif

#ifndef PBM_WEB_MAX_CHAR_LEN
#define PBM_WEB_MAX_CHAR_LEN  ZTE_WEB_PBM_REC_LEN*ZTE_PB_INDEX_MAX
#endif

#ifndef PBM_MAX_NUM_LENGTH
#define PBM_MAX_NUM_LENGTH   40
#endif

#ifndef PBM_NUM_SIZE
#define PBM_NUM_SIZE (PBM_MAX_NUM_LENGTH+2)  /* + and null for string */
#endif


#ifndef uint16
#define uint16 unsigned short
#endif

#ifndef PBM_MAX_TEXT_LENGTH
#define PBM_MAX_TEXT_LENGTH 90
#endif

#ifndef PBM_TEXT_SIZE_CHARS
#define PBM_TEXT_SIZE_CHARS (PBM_MAX_TEXT_LENGTH+1)              /* Null terminated string */
#endif

#ifndef PBM_TEXT_SIZE_BYTES
#define PBM_TEXT_SIZE_BYTES (PBM_TEXT_SIZE_CHARS*sizeof(uint16)) /* size in bytes */
#endif

#ifndef ZTE_PBM_NV
#define ZTE_PBM_NV  "pbm_write_flag"
#endif

#define PBM_OPRATING "20"

#define PBM_SIM "pbm_sim"
#define PBM_NATIVE "pbm_native"

//pbm device capacity
#define PBM_DEV_MAX_RECORD_NUM "pbm_dev_max_record_num"
#define PBM_DEV_USED_RECORD_NUM "pbm_dev_used_record_num"

//pbm sim capacity
#define PBM_SIM_SIM_TYPE "pbm_sim_type"
#define PBM_SIM_MAX_RECORD_NUM "pbm_sim_max_record_num"
#define PBM_SIM_USED_RECORD_NUM "pbm_sim_used_record_num"
#define PBM_SIM_MAX_NAME_LEN "pbm_sim_max_name_len"
#define PBM_SIM_MAX_NUMBER_LEN "pbm_sim_max_number_len"
#define PBM_SIM_MAX_ANR_NUM "pbm_sim_max_anr_num"
#define PBM_SIM_MAX_ANR_LEN "pbm_sim_max_anr_len"
#define PBM_SIM_MAX_ANR1_NUM "pbm_sim_max_anr1_num"
#define PBM_SIM_MAX_ANR1_LEN "pbm_sim_max_anr1_len"
#define PBM_SIM_MAX_EMAIL_NUM "pbm_sim_max_email_num"
#define PBM_SIM_MAX_EMAIL_LEN "pbm_sim_max_email_len"
#define PBM_SIM_MAX_SNE_LEN "pbm_sim_max_sne_len"

#define ZTE_WEB_PBM_NUMBER_TYPE_1   			145
#define ZTE_WEB_PBM_NUMBER_TYPE_2   			129
#define ZTE_WEB_PBM_NUMBER_TYPE_SPLIT 		'+'
#define ZTE_WEB_PBM_NUMBER_TYPE_START 		0
#define ZTE_WEB_PBM_PAGE_DEL_PART   		"delete_num"
#define ZTE_WEB_PBM_PAGE_DEL_ALL   			"delete_all"
#define ZTE_WEB_PBM_DEL_BY_GROUP            "delete_all_by_group"
#define ZTE_WEB_PBM_REC_LEN					32
#define ZTE_WEB_PBM_INDEX_SPLIT_FLAG			','
#define ZTE_WEB_PBM_DEL_MULT_OR_ONE_FLAG	1
#define ZTE_WEB_PBM_DEL_MULT_FLAG			0
#define ZTE_WEB_PBM_DEL_ONE_IND 				0
#define ZTE_WEB_PBM_MEM_SIM					0

#define PBM_PAGE_RECORD_MAX_NUM  10

#define PBM_DATA "pbm_data"

#define PBM_ID "pbm_id"
#define PBM_INDEX "pbm_index"
#define PBM_LOCATION "pbm_location"
#define PBM_NAME "pbm_name"
#define PBM_NUMBER "pbm_number"
#define PBM_TYPE "pbm_type"
#define PBM_ANR "pbm_anr"
#define PBM_ANR1 "pbm_anr1"
#define PBM_EMAIL "pbm_email"
#define PBM_SNE "pbm_sne"
#define PBM_GROUP "pbm_group"

typedef struct  zte_pbm_create_ext_record_s_type {
	int   zte_pbm_id;   //the id in the pbm table,unique,ASC
	int   zte_pbm_index;
	int   zte_pbm_location;
	char  zte_pbm_name[PBM_TEXT_SIZE_BYTES];
	char  zte_pbm_number[PBM_NUM_SIZE];
	int   zte_pbm_type;
	char  zte_pbm_anr[PBM_NUM_SIZE];
	char  zte_pbm_anr1[PBM_NUM_SIZE];
	char  zte_pbm_email[PBM_TEXT_SIZE_BYTES];
	//char  zte_pbm_sne[PBM_TEXT_SIZE_BYTES];
	//char  zte_pbm_group[PBM_TEXT_SIZE_BYTES];
	char  zte_pbm_sne[32];// 91*2 ---> 32  ʱδõò
	char  zte_pbm_group[32];  // 91*2 ---> 32
	int   zte_pbm_del_id;
} zte_pbm_create_ext_record_s_type;



typedef enum  zte_web_pbm_contact_save {
	ZTE_WEB_PBM_CONTACT_SIM,
	ZTE_WEB_PBM_CONTACT_PC,

	ZTE_WEB_PBM_MAX
} zte_web_pbm_contact_save_e_type;

typedef struct  zte_pbm_del_multi_records_s_type {
	int  zte_del_pbm_id[PBM_MAX_DEL_LEN];
	int  zte_del_pbm_total;
	int  zte_del_pbm_location;
	int  zte_del_pbm_index[PBM_MAX_DEL_LEN];
} zte_pbm_del_multi_records_s_type;


typedef enum {
	PBM_LOCATION_SIM = 0,            //sim card only,exsit in database
	PBM_LOCATION_DEVICE = 1,      //device only,exit in database
	PBM_LOCATION_ALL = 2,            //sim card and device, not exsit in database, only use in pbm code
	PBM_LOCATION_GROUP = 3,      //group in device,for example:common,family and so on,not exsit in database, only use in pbm code

	PBM_LOCATION_MAX
} zte_pbm_location_e_type;

typedef struct {
	uint8 page;
	uint8 num_per_page;
	zte_pbm_location_e_type location;
	boolean asc_flag;
	uint8 order_by;
} zte_pbm_query_req_s_type;




typedef struct {
	uint8 count;
	zte_pbm_create_ext_record_s_type  data[0]; /*lint !e1501*/
} zte_pbm_query_resp_s_type;


typedef struct {
	int  sim_type;
	int  max_record_number;
	int  used_record_number;
	int  max_name_len;
	int  max_number_len;
	int  max_anr_num;
	int  max_anr_len;
	int  max_anr1_num;
	int  max_anr1_len;
	int  max_email_num;
	int  max_email_len;
	int  max_sne_len;
} zte_pbm_sim_capability_s_type;


typedef struct {
	int  max_record_number;
	int  used_record_number;
} zte_pbm_device_capability_s_type;

extern void zte_rest_get_pbm_data_head(webs_t wp);
extern void zte_rest_get_pbm_data_foot(webs_t wp);
extern void zte_rest_get_pbm_data_sim(webs_t wp, zte_pbm_query_resp_s_type *p_pbm_query_result, int index, int tag);
extern void zte_rest_get_pbm_data_other(webs_t wp, zte_pbm_query_resp_s_type *p_pbm_query_result, int index, int tag);




