/**
 * @file flags_api.h
 * @brief flagsӿ
 *
 * Copyright (C) 2023 Sanechips Technology Co., Ltd.
 * @author 
 * @ingroup 
 * 
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License version 2 as
 * published by the Free Software Foundation. ѡGPLv2 Licence
 *
 */


#ifndef FLAGS_API_H
#define FLAGS_API_H


/*******************************************************************************
 *                           Include header files                              *
 ******************************************************************************/
#include "pub_flags.h"


/*******************************************************************************
 *                             Macro definitions                               *
 ******************************************************************************/


/*******************************************************************************
 *                             Type definitions                                *
 ******************************************************************************/


/*******************************************************************************
 *                       Global variable declarations                          *
 ******************************************************************************/


/*******************************************************************************
 *                       Global function declarations                          *
 ******************************************************************************/
/**
 * @brief  ʼflags
 * @param[out]  p_flags_info  flagsʼ
 * @return  0 ʼɹ, -1 ʼʧ
 * @note
 */
int flags_init();


/**
 * @brief  ȡflags
 * @param[out]  p_flags_info  flags
 * @return  0 ȡɹ, -1 ȡʧ
 * @note
 */
int flags_get(T_FLAGS_INFO *p_flags_info);


/**
 * @brief  flags
 * @param[in]  p_flags_info  flags
 * @return  0 óɹ, -1 ʧ
 * @note
 */
int flags_set(T_FLAGS_INFO *p_flags_info);


/**
 * @brief  ȡflagsubifs״̬
 * @param[out]  status  ubifs״̬
 * @return  0 ȡɹ, -1 ȡʧ
 * @note
 */
int flags_get_ubifs_status(T_UBIFS_STATUS *p_ubifs_status);


/**
 * @brief  flagsubifs״̬
 * @param[in]  status  ubifs״̬
 * @return  0 óɹ, -1 ʧ
 * @note
 */
int flags_set_ubifs_status(T_UBIFS_STATUS *p_ubifs_status);


/**
 * @brief  ȡǰϵͳ
 * @return  ǰϵͳ
 * @note
 */
int flags_get_current_system();

/**
 * @brief  ȡflagsnvro_flag״̬
 * @param[out]  
 * @return  nvro_flag
 * @note
 */
unsigned int flags_get_nvroflag(void);

/**
 * @brief  flagsnvro_flag
 * @param[in]  flag nvro״̬
 * @return  0 óɹ, -1 ʧ
 * @note
 */
int flags_set_nvroflag(unsigned int flag);


/**
 * @brief  ȡflags(CRC)
 * @param[out]  p_flags_info  flags
 * @return  0 ȡɹ, -1 ȡʧ
 * @note  APIڵ⣬ʽ벻ʹ

 */
int flags_get_nocrc(T_FLAGS_INFO *p_flags_info);


/**
 * @brief  flags(CRC)
 * @param[in]  p_flags_info  flags
 * @return  0 óɹ, -1 ʧ
 * @note  APIڵ⣬ʽ벻ʹ
 */
int flags_set_nocrc(T_FLAGS_INFO *p_flags_info);


/**
 * @brief  ʼCRC32(С)
 * @param  
 * @return 
 * @note
 */
void crc32init_le(void);


/**
 * @brief  CRC32У(С)
 * @param[in]  crc ʼֵ
 * @param[in]  p  ҪCRC32Уbufferָ
 * @param[in]  len  buffer @pĴС
 * @return  õCRC32У
 * @note
 */
unsigned int crc32_le(unsigned int crc, unsigned char const *p, size_t len);


#endif // FLAGS_API_H

