/**
 * 
 * @file      amt_agent_devicetest.h
 * @brief     
 *            This file is part of FTM.
 *            AMTӦò
 *            
 * @details   
 * @author    Tools Team.
 * @email     
 * @copyright Copyright (C) 2013 Sanechips Technology Co., Ltd.
 * @warning   
 * @date      2019/02/02
 * @version   1.1
 * @pre       
 * @post      
 *            
 * @par       
 * Change History :
 * ---------------------------------------------------------------------------
 * date        version  author         description
 * ---------------------------------------------------------------------------
 * 2016/12/12  1.0      lu.xieji       Create file
 * 2019/02/02  1.1      jiang.fenglin  ޸עͷʽΪdoxygen
 * ---------------------------------------------------------------------------
 * 
 * 
 */

#ifndef _AMT_AGENT_DEVICETEST_H
#define _AMT_AGENT_DEVICETEST_H
//#include "zcore_type.h"



//#include "amt_agent_ref.h"

// TestItem: 1~100
#define TEST_COMMON                             0
#define TEST_INFO                               1
#define TEST_KEYBOARD                           2
#define TEST_LCD                                3
#define TEST_LCDBACKLIGHT                       4
#define TEST_VIBRATOR                           5
#define TEST_SIM                                6
#define TEST_SD                                 7
#define TEST_BATTERY                            8
#define TEST_KEYBACKLIGHT                       9
#define TEST_CAMERA_BACK                        10
#define TEST_CAMERA_FRONT                       11
#define TEST_AUDIO                              12
#define TEST_TP                                 13
#define TEST_GSENSOR                            14
#define TEST_CHARGER                            15
#define TEST_FLASH_LIGHT                        16
#define TEST_WIFI                               17


// Common
#define MSG_DEVICETEST_STATUS_IDLE              (MSG_DEVICETEST_START + 0x00)
#define MSG_DEVICETEST_TESTINIT                 (MSG_DEVICETEST_START + 0x01)

// Test info
#define MSG_DEVICETEST_TESTINFO                 (MSG_DEVICETEST_START + 0x20)
// Keyboard
#define MSG_DEVICETEST_KEYBOARD_START           (MSG_DEVICETEST_START + 0x30)
#define MSG_DEVICETEST_KEYBOARD_STOP            (MSG_DEVICETEST_START + 0x31)
#define MSG_DEVICETEST_KEYBOARD_READ            (MSG_DEVICETEST_START + 0x32)

// LCD
#define MSG_DEVICETEST_LCD_START                (MSG_DEVICETEST_START + 0x40)
#define MSG_DEVICETEST_LCD_STOP                 (MSG_DEVICETEST_START + 0x41)
//LCD
#define MSG_DEVICETEST_LCD_BOARD                (MSG_DEVICETEST_START + 0x42) 

// LCD backlight
#define MSG_DEVICETEST_LCDBACKLIGHT_START       (MSG_DEVICETEST_START + 0x50)
#define MSG_DEVICETEST_LCDBACKLIGHT_STOP        (MSG_DEVICETEST_START + 0x51)
// Vibrator
#define MSG_DEVICETEST_VIBRATOR_START           (MSG_DEVICETEST_START + 0x60)
#define MSG_DEVICETEST_VIBRATOR_STOP            (MSG_DEVICETEST_START + 0x61)
// SIM
#define MSG_DEVICETEST_SIM_READ                 (MSG_DEVICETEST_START + 0x70)
// SD
#define MSG_DEVICETEST_SD_READ                  (MSG_DEVICETEST_START + 0x80)
// Battery&charger
#define MSG_DEVICETEST_BATTERY_VOLTAGE          (MSG_DEVICETEST_START + 0x90)
#define MSG_DEVICETEST_BATTERY_TEMPERATURE      (MSG_DEVICETEST_START + 0x91)
#define MSG_DEVICETEST_CHARGER_STATUS           (MSG_DEVICETEST_START + 0x92)
// Keybacklight
#define MSG_DEVICETEST_KEYBACKLIGHT_START       (MSG_DEVICETEST_START + 0xA0)
#define MSG_DEVICETEST_KEYBACKLIGHT_STOP        (MSG_DEVICETEST_START + 0xA1)
// Camera
#define MSG_DEVICETEST_CAMERA_BACK_START        (MSG_DEVICETEST_START + 0xB0)
#define MSG_DEVICETEST_CAMERA_BACK_SNAPSHOT     (MSG_DEVICETEST_START + 0xB1)
#define MSG_DEVICETEST_CAMERA_BACK_STOP         (MSG_DEVICETEST_START + 0xB2)
//ͷ
#define MSG_DEVICETEST_CAMERA_BOARD             (MSG_DEVICETEST_START + 0xB3)
// Audio
#define MSG_DEVICETEST_AUDIO_MIC_RECEIVER       (MSG_DEVICETEST_START + 0xC0)
#define MSG_DEVICETEST_AUDIO_MIC_SPEAKER        (MSG_DEVICETEST_START + 0xC1)
#define MSG_DEVICETEST_AUDIO_HEADSET_HEADSET    (MSG_DEVICETEST_START + 0xC2)
//˹ȺֹͣϢ
#define MSG_DEVICETEST_AUDIO_MIC_RECEIVER_STOP  (MSG_DEVICETEST_START + 0xC3)
#define MSG_DEVICETEST_AUDIO_MIC_SPEAKER_STOP   (MSG_DEVICETEST_START + 0xC4)
// Flashlight
#define MSG_DEVICETEST_FLASHLIGHT_START			 (MSG_DEVICETEST_START + 0xD0)
#define MSG_DEVICETEST_FLASHLIGHT_STOP			 (MSG_DEVICETEST_START + 0xD1)
// TP
#define MSG_DEVICETEST_TP_START                 (MSG_DEVICETEST_START + 0xE0)
#define MSG_DEVICETEST_TP_STOP                  (MSG_DEVICETEST_START + 0xE1)
//TP
#define MSG_DEVICETEST_TP_BOARD                 (MSG_DEVICETEST_START + 0xE2)
// G-Sensor
#define MSG_DEVICETEST_GSENSOR_START            (MSG_DEVICETEST_START + 0xF0)
#define MSG_DEVICETEST_GSENSOR_STOP             (MSG_DEVICETEST_START + 0xF1)
//G-Sensor
#define MSG_DEVICETEST_GSENSOR_BOARD            (MSG_DEVICETEST_START + 0xF2)
//WiFi(ȵ)
#define MSG_DEVICETEST_WIFI       (MSG_DEVICETEST_START + 0x100)



#define AMT_SUCCESS_RET     (0)
#define AMT_ERROR_RET       (-1)

//幦ܲʹõһЩ豸·
#define TP_MODE_PATH				"/sys/class/input/input2/tp_mode"
#define DEVICE_GSENSOR				"/dev/mir3da"
#define DEVICE_CAMERA				"/dev/camera_device"
#define BATTERY_TEMPERATURE_PATH	"/sys/class/power_supply/battery/temp"
#define CHARGER_STATUS_PATH			"/sys/class/power_supply/charger/status"
#define DEVICE_LCD					"/dev/fb0"




typedef int (*process_func)(unsigned int msg_id, unsigned char *msg_buf, unsigned int msg_len);

typedef struct
{
    unsigned int item_id;
    unsigned int msg_id;
    process_func fun;
    char *test_name;
} T_COMMAND;

enum
{
    LCD_COLOR_WHITE = 0,
    LCD_COLOR_RED,
    LCD_COLOR_GREEN,
    LCD_COLOR_BLUE,
    LCD_COLOR_BLACK,
    MAX_LCD_COLOR_NUM
};

typedef struct
{
    int result;
    int length;
} T_DeviceTest_Header;
/*
typedef struct
{
	SINT32	keyValue;
	BOOL	keyFlag;
	SINT32	staticID;	
}T_ZWndEm_CheckKey;
*/

/**
 * @brief AMTԳʼ
 * @return ɹ0, ʧܷ-1
 * @note
 * @see 
 */
int Amt_DeviceTest_Init(void);

/**
 * @brief AMTϢ
 * @param[in] msg_id FID
 * @param[in] msg_buf buffer
 * @param[in] msg_len buffer
 * @return ɹ0, ʧܷ-1
 * @note
 * @see 
 */
int Amt_DeviceTest_ProcessMsg(unsigned int msg_id, unsigned char *msg_buf, unsigned int msg_len);

/**
 * @brief AMTϢPC
 * @param[in] msg_id FID
 * @param[in] result ״̬
 * @param[in] msg_buf buffer
 * @param[in] msg_len buffer
 * @return ɹ0, ʧܷ-1
 * @note
 * @see 
 */
int Amt_DeviceTest_SendMsg(unsigned int msg_id, int result, unsigned char *msg_buf, unsigned int msg_len);

#endif

