/**************************************************************************
*
*                  Copyright (c) 2013 ZTE Corporation.
*
***************************************************************************
* ģ   : Atserver-PB
*    : pb_db.c
* ļ :
* ʵֹ : Pb ݿӿںʵ
*      : syx
*      : V1.0
*  : 2013-05-16
* ˵ :
**************************************************************************/

/**************************************************************************
* ޸ļ¼ :
***************************************************************************/
/**************************************************************************
* ޸ı :
*    :
* ޸ :
* ޸ :
**************************************************************************/

/**************************************************************************
* #include
**************************************************************************/
#include "pb_com.h"

/**************************************************************************
* 
**************************************************************************/

/**************************************************************************
* ݽṹ
**************************************************************************/
/**************************************************************************
* static
**************************************************************************/

/**************************************************************************
* ȫֱ
**************************************************************************/

/**************************************************************************
* ʵ
**************************************************************************/
T_zPb_DbResult atPb_CreatDb()
{
    T_zPb_DbResult  result                = ZPB_DB_OK;
    CHAR            sql[ZPB_MAX_BYTES_DB] = {0};
    UINT32          count                   = 0;
    
    result = atPb_ExecDbSql(ZPB_CREATE_PBM_TABLE,NULL,NULL);
    if(ZPB_DB_OK != result)
    {
        slog(PB_PRINT,SLOG_ERR,"pb:pbm:create pbm table result is %d\n", result);
        return result;
    }
    /*create pbm_sim_capability table*/
    result = atPb_ExecDbSql(ZPB_CREATE_PBM_SIM_CAPABILITY_TABLE,NULL,NULL);
    if(ZPB_DB_OK != result)
    {
        slog(PB_PRINT,SLOG_ERR,"pb:pbm:create pbm_sim_capability table result is %d\n", result);
        return result;
    }
    /*create pbm_device_capability table*/
    result = atPb_ExecDbSql(ZPB_CREATE_PBM_DEVICE_CAPABILITY_TABLE,NULL,NULL);
    if(ZPB_DB_OK != result)
    {
        slog(PB_PRINT,SLOG_ERR,"pb:pbm:create pbm_device_capability table result is %d\n", result);
        return result;
    }
    /*ɾpbmλΪsimĵ绰¼*/
    snprintf(sql,sizeof(sql),"delete from %s where Location=%d",ZPB_DB_PBM_TABLE, ZPB_LOCATION_USIM);
    result = atPb_ExecDbSql(sql,NULL,NULL);
    if(ZPB_DB_OK != result)
    {
        slog(PB_PRINT,SLOG_ERR,"pb:pbm:create pbm_device_capability table result is %d\n", result);
        return result;
    }

    memset(sql, 0, sizeof(sql));
    snprintf(sql,sizeof(sql)-1,"select count(*) from %s",ZPB_DB_SIM_CAPABILITY_TABLE);
    (VOID)atPb_ExecDbSql(sql,atPb_DbCountTableLineCb,&count);
    if(0 < count)
    {
        memset(sql, 0, sizeof(sql));
        snprintf(sql,sizeof(sql)-1,"delete from %s where Sim_type>=0",ZPB_DB_SIM_CAPABILITY_TABLE);
        result = atPb_ExecDbSql(sql,NULL,NULL);
        if(ZPB_DB_OK != result)
        {
            slog(PB_PRINT,SLOG_DEBUG,"pb:atPb_SetSimCapacityTable:fail!\n");
            return result;
        }
    }
    return ZPB_DB_OK;
}

T_zPb_DbResult atPb_DropDb()
{
	T_zPb_DbResult  result                = ZPB_DB_OK;
    CHAR            sql[ZPB_MAX_BYTES_DB] = {0};

	
	result = atPb_ExecDbSql(ZTE_DROP_PBM_SQL,NULL,NULL);
    if(ZPB_DB_OK != result)
    {
        slog(PB_PRINT,SLOG_ERR,"atPb_DropDb:del pbm table result is %d\n", result);
        return result;
    }

	result = atPb_ExecDbSql(ZTE_DROP_PBM_DEVICE_SQL,NULL,NULL);
    if(ZPB_DB_OK != result)
    {
        slog(PB_PRINT,SLOG_ERR,"atPb_DropDb:del pbm_device table result is %d\n", result);
        return result;
    }

	result = atPb_ExecDbSql(ZTE_DROP_PBM_SIM_SQL,NULL,NULL);
    if(ZPB_DB_OK != result)
    {
        slog(PB_PRINT,SLOG_ERR,"atPb_DropDb:del pbm_sim table result is %d\n", result);
        return result;
    }

	result = atPb_ExecDbSql(ZTE_DROP_PBM_SIM_CAPABILITY_SQL,NULL,NULL);
    if(ZPB_DB_OK != result)
    {
        slog(PB_PRINT,SLOG_ERR,"atPb_DropDb:del pbm_sim_capability table result is %d\n", result);
        return result;
    }

	result = atPb_ExecDbSql(ZTE_DROP_PBM_DEVICE_CAPABILITY_SQL,NULL,NULL);
    if(ZPB_DB_OK != result)
    {
        slog(PB_PRINT,SLOG_ERR,"atPb_DropDb:del pbm_device_capability table result is %d\n", result);
        return result;
    }
	
	return ZPB_DB_OK;
}

T_zPb_DbResult atPb_DbOpen(sqlite3**pDb)
{
    sqlite3* pTmpDb = NULL;

    if(NULL == pDb)
    {
        slog(PB_PRINT,SLOG_ERR,"pb:pbm:invalide inputs.");/*lint  !e26*/
        return ZPB_DB_ERROR_INVALIDPTR;
    }
    slog(PB_PRINT,SLOG_DEBUG,"pb:sqlite3_open call");/*lint  !e26*/

#if 0
	if(!fopen(ZPB_DB_PATH, "r"))
	{
		file = fopen(ZPB_DB_PATH, "w");
		if(!file)
		{
	        printf("unable to open  file etc_rw/pbm.db\n");/*lint !e26*/

		}
		else
		{
			printf(" open  file etc_rw/pbm.db file=%d\n", file);
			fclose(file);
		}
	}
	#endif
	if(sqlite3_open(ZPB_DB_PATH, &pTmpDb))
    {
        slog(PB_PRINT,SLOG_ERR,"pb:pbm:can not open db,sqlite3_errmsg:%s.",sqlite3_errmsg(pTmpDb));
        (VOID) sqlite3_close(pTmpDb);
        return ZPB_DB_ERROR_NOTOPENDB;
    }
    *pDb = pTmpDb;
    return ZPB_DB_OK;
}
T_zPb_DbResult atPb_DbClose (sqlite3*pDb)
{
    if (NULL == pDb)
    {
        slog(PB_PRINT,SLOG_ERR,"pb:pbm:invalide inputs.");/*lint  !e26*/
        return ZPB_DB_ERROR_INVALIDPTR;
    }
    if(sqlite3_close(pDb))
    {
        slog(PB_PRINT,SLOG_ERR,"pb:pbm:can not close db");/*lint  !e26*/
        return ZPB_DB_ERROR;
    }
#ifdef WEBS_SECURITY
	if(access(ZPB_TMP_PATH, F_OK) == 0)
	{
		slog(PB_PRINT,SLOG_ERR,"pb:pbm:tmp db stay");/*lint  !e26*/
		if(remove(ZPB_TMP_PATH) != 0)
		{
			slog(PB_PRINT,SLOG_ERR,"remove ZPB_TMP_PATH fail");
		}
	}
	if(rename(ZPB_SEC_PATH, ZPB_TMP_PATH) != 0)
	{
		slog(PB_PRINT,SLOG_ERR,"rename ZPB_SEC_PATH fail");
	}
	{
		char rnum_buf[24] = {0};
		char cmd[128] = {0};
		
		sc_cfg_get("rnum_at", rnum_buf, sizeof(rnum_buf));
		snprintf(cmd, sizeof(cmd), "/bin/openssl enc -e -aes256 -salt -in %s -out %s -pass pass:%s", ZPB_DB_PATH, ZPB_SEC_PATH, rnum_buf);
		zxic_system(cmd);
		if(access(ZPB_SEC_PATH, F_OK) == 0)
		{
			if(remove(ZPB_TMP_PATH) != 0)
			{
				slog(PB_PRINT,SLOG_ERR,"remove ZPB_TMP_PATH1 fail");
			}
		}
	}
#endif	
    return ZPB_DB_OK;
}

static check_sql_cmd(const char *pSql)
{
	if(pSql != NULL)
	{
		if(strstr(pSql, ";") || strstr(pSql, "--"))
		{
			return 0;
		}
		return 1;
	}
	return 0;
}

T_zPb_DbResult atPb_ExecDbSql(const char *pSql, sqlite3_callback callback,VOID *pFvarg)
{
    sqlite3     *pDb           = NULL;
    CHAR         dbErrMsg[128] = {0};
    if(NULL == pSql)
    {
        return ZPB_DB_ERROR_INVALIDPTR;
    }
#ifdef WEBS_SECURITY
	if(check_sql_cmd(pSql) == 0)
	{
        slog(PB_PRINT,SLOG_ERR,"!!atPb_ExecDbSql:xss %s\n",pSql);
        return ZPB_DB_ERROR_INVALIDPTR;
	}
#endif	
    if(ZPB_DB_OK != atPb_DbOpen(&pDb))
    {
        slog(PB_PRINT,SLOG_ERR,"pb:open pbm.db failed.");/*lint  !e26*/
        return ZPB_DB_ERROR_NOTOPENDB;
    }
    slog(PB_PRINT,SLOG_DEBUG,"pb:atPb_ExecDbSql:%s\n",pSql);

    if(sqlite3_exec(pDb,pSql,callback,pFvarg,NULL))
    {
        strncpy(dbErrMsg,sqlite3_errmsg(pDb),sizeof(dbErrMsg)-1);
        slog(PB_PRINT,SLOG_ERR,"pb:pbm:can not exec sql,sqlite3_errmsg:%s.",dbErrMsg);
        (VOID)sqlite3_close(pDb);
        return ZPB_DB_ERROR;
    }
    (VOID)atPb_DbClose(pDb);
    return ZPB_DB_OK;
}

SINT32 atPb_InitApIndexCb(VOID *fvarg,int line,char **zresult,char **lname)
{
	SINT32  index = 0;
	
    if(1 > line)
    {
        slog(PB_PRINT,SLOG_ERR,"pb:atPb_InitApIndexCb:record no data.\n");/*lint  !e26*/
        return -1;
    }

    index = atoi(zresult[0]);
	if (index > ZPB_AP_MAX_RECORD) {
        slog(PB_PRINT,SLOG_ERR,"pb:atPb_InitApIndexCb:index overflow.\n");
        return -1;
    }
    slog(PB_PRINT,SLOG_DEBUG,"pb:atPb_InitApIndexCb:pbm_index=%d\n",index);
    g_zPb_ApIndex[index] = PBM_SUCCESS;

    return 0;
}

T_zPb_DbResult atPb_InitApIndex()
{
    CHAR            sql[ZPB_MAX_BYTES_DB]   = {0};
    SINT32          i                       = 1;

    g_zPb_ApIndex[0] = ZPB_AP_MAX_RECORD;

    for(i=1; i<=g_zPb_ApIndex[0]; i++)
    {
        g_zPb_ApIndex[i] = PBM_ERROR_NOT_FOUND;
    }
    snprintf(sql,sizeof(sql),"select Pbm_index from %s where Location=%d",ZPB_DB_PBM_TABLE, ZPB_LOCATION_AP);
    return atPb_ExecDbSql(sql,atPb_InitApIndexCb,ZUFI_NULL);
}

/*check whether the web pbm dir exist or not*/
INT zte_pbm_check_and_creat_dir(char *path)
{
    if (-1==access(path,/*F_OK*/0))
    {
        slog(PB_PRINT,SLOG_DEBUG,"pb:pbm:%s does not exist,socreate it.\n",ZPB_DB_DIR);
        if (-1 == mkdir(path, 0777))
        {
            slog(PB_PRINT,SLOG_ERR,"pb::failed to create db dir.\n");
            return -1;
        }
    }
    return 0;
}

UINT8 zte_pbm_check_web_pbm_dir(VOID)
{
#ifdef _MBB_OS_UCLINUX
	(VOID)zte_pbm_check_and_creat_dir("/mnt/jffs2/etc_rw");
    (VOID)zte_pbm_check_and_creat_dir("/mnt/jffs2/etc_rw/config");
#else
(VOID)zte_pbm_check_and_creat_dir("/etc_rw");
(VOID)zte_pbm_check_and_creat_dir("/etc_rw/config");
#endif
    return ZUFI_SUCC;
}

T_zPb_DbResult atPb_DelSimRecFromPbTable(SINT32 index)
{
    T_zPb_DbResult  result                  = ZPB_DB_OK;
    CHAR            sql[ZPB_MAX_BYTES_DB]   = {0};

    snprintf(sql,sizeof(sql),"delete from %s where location=%d and Pbm_index=%d",ZPB_DB_PBM_TABLE, ZPB_LOCATION_USIM,index);
    result = atPb_ExecDbSql(sql,NULL,NULL);

    if(ZPB_DB_OK == result)
    {
        g_zPb_SimIndex[index] = PBM_ERROR_NOT_FOUND;
    }
    return result;
}

T_zPb_DbResult atPb_LoadARecToPbmTable(T_zPb_WebContact *pbPara)
{
    T_zPb_DbResult  result                  = ZPB_DB_ERROR;
    CHAR            sql[ZPB_MAX_BYTES_DB]   = {0};
    if(NULL == pbPara)
    {
        slog(PB_PRINT,SLOG_ERR,"pb:atPb_LoadARecToPbmTable:invalid input");/*lint  !e26*/
        return ZPB_DB_ERROR_INVALIDPTR;
    }
    snprintf(sql,sizeof(sql),"insert into %s (Pbm_index,Location,Number,Type,Name,Anr,Anr1,Email,Sne) \
			values(\'%d\',\'%d\',\'%s\',\'%d\',\'%s\',\'%s\',\'%s\',\'%s\',\'%s\')",
            ZPB_DB_PBM_TABLE,
            pbPara->pbIndex,
            pbPara->pbLocation,
            pbPara->mobilNumber,
            pbPara->pbType,
            pbPara->name,
            pbPara->homeNumber,
            pbPara->officeNumber,
            pbPara->email,
            pbPara->sne);
    result = atPb_ExecDbSql(sql,NULL,NULL);
    if(ZPB_DB_OK==result)
    {
        CHAR pbMax[50]={0};
        sc_cfg_get(ZPB_NV_USIMINDEXMAX,pbMax,sizeof(pbMax));
        if((pbPara->pbIndex>=1)&&(pbPara->pbIndex <= atoi(pbMax)))/*Comment: 绰,ZhaoYong,2008/12/23  10:49 */
        {
            g_zPb_SimIndex[pbPara->pbIndex] = PBM_SUCCESS;
        }
        (VOID)sc_cfg_set(ZPB_NV_WRITE_FLAG, ZPB_OPERATE_SUC);
    }
    else
    {
        (VOID)sc_cfg_set(ZPB_NV_WRITE_FLAG, ZPB_NEW_ERROR);
    }
    slog(PB_PRINT,SLOG_DEBUG,"pb:pbm:exec table %s result %d\n", ZPB_DB_PBM_TABLE,result);
    return result;
}

VOID atPb_SqlModifyOneRec(T_zPb_WebContact *pbmPara,char *sql,int len)
{
    printf("pb:atPb_SqlModifyOneRec enter");/*lint  !e26*/

    if(ZPB_LOCATION_USIM == pbmPara->pbLocation)
    {
        snprintf(sql,len,"update %s set Pbm_index=\'%d\',Location=\'%d\',Number=\'%s\',Type=\'%d\',Name=\'%s\',Anr=\'%s\', \
        		Anr1=\'%s\',Email=\'%s\',Sne=\'%s\' where id=%d",
                ZPB_DB_PBM_TABLE,
                pbmPara->pbIndex,
                pbmPara->pbLocation,
                pbmPara->mobilNumber,
                pbmPara->pbType,
                pbmPara->name,
                pbmPara->homeNumber,
                pbmPara->officeNumber,
                pbmPara->email,
                pbmPara->sne,
                pbmPara->pbId);
    }
    else if(ZPB_LOCATION_AP == pbmPara->pbLocation)
    {
        snprintf(sql,len,"update %s set Pbm_index=\'%d\',Location=\'%d\',Number=\'%s\',Type=\'%d\',Name=\'%s\',Anr=\'%s\', \
					Anr1=\'%s\',Email=\'%s\',Sne=\'%s\',Pbm_group=\'%s\' where id=%d",
                ZPB_DB_PBM_TABLE,
                pbmPara->pbIndex,
                pbmPara->pbLocation,
                pbmPara->mobilNumber,
                pbmPara->pbType,
                pbmPara->name,
                pbmPara->homeNumber,
                pbmPara->officeNumber,
                pbmPara->email,
                pbmPara->sne,
                pbmPara->group,
                pbmPara->pbId);
    }
}

T_zPb_DbResult atPb_DbGetParamCb(VOID *fvarg,int line,char **zresult,char **lname)
{
    T_zPb_Header para = {0};

    if(1 > line)
    {
        slog(PB_PRINT,SLOG_ERR,"pb:atPb_DbGetParamCb:record no data.");/*lint  !e26*/
        return ZPB_DB_ERROR;
    }

    para.pbIndex      = atoi(zresult[0]);
    para.pbLocation   = atoi(zresult[1]);
    slog(PB_PRINT,SLOG_DEBUG,"pb:atPb_DbGetParamCb: index=%d,location=%d", para.pbIndex, para.pbLocation);
    memcpy(fvarg,&para,sizeof(para));
    return ZPB_DB_OK;
}
T_zPb_DbResult atPb_GetIndexLocationById(T_zPb_Header *pbPara)
{
    CHAR            sql[ZPB_MAX_BYTES_DB]   = {0};

    snprintf(sql,sizeof(sql)-1,"select Pbm_index,Location from %s where id=%d",
            ZPB_DB_PBM_TABLE,
            pbPara->pbId);

    memset(pbPara, 0,sizeof(T_zPb_Header));
    return atPb_ExecDbSql(sql,atPb_DbGetParamCb, pbPara);
}

VOID atPb_SqlNewOneRec(T_zPb_WebContact *pbmPara,CHAR *sql,int len)
{
    if(ZPB_LOCATION_USIM == pbmPara->pbLocation)
    {
        snprintf(sql,len,"insert into %s (Pbm_index,Location,Number,Type,Name,Anr,Anr1,Email,Sne)\
    			values(\'%d\',\'%d\',\'%s\',\'%d\',\'%s\',\'%s\',\'%s\',\'%s\',\'%s\')",
                ZPB_DB_PBM_TABLE,
                pbmPara->pbIndex,
                pbmPara->pbLocation,
                pbmPara->mobilNumber,
                pbmPara->pbType,
                pbmPara->name,
                pbmPara->homeNumber,
                pbmPara->officeNumber,
                pbmPara->email,
                pbmPara->sne);

    }
    else if(ZPB_LOCATION_AP == pbmPara->pbLocation)
    {
        snprintf(sql,len,"insert into %s (Pbm_index,Location,Number,Type,Name,Anr,Anr1,Email,Sne,Pbm_group)\
				values(\'%d\',\'%d\',\'%s\',\'%d\',\'%s\',\'%s\',\'%s\',\'%s\',\'%s\',\'%s\')",
                ZPB_DB_PBM_TABLE,
                pbmPara->pbIndex,
                pbmPara->pbLocation,
                pbmPara->mobilNumber,
                pbmPara->pbType,
                pbmPara->name,
                pbmPara->homeNumber,
                pbmPara->officeNumber,
                pbmPara->email,
                pbmPara->sne,
                pbmPara->group);
    }
}


T_zPb_DbResult atPb_WriteContactToPbmTable(T_zPb_WebContact *pPbRecord, BOOL pbNewFlag)
{
    T_zPb_DbResult  result                  = ZPB_DB_OK;
    CHAR            sql[ZPB_MAX_BYTES_DB]   = {0};
    //UINT8           ascName[ZPB_TEXT_SIZE_BYTES]={0};

    if(NULL == pPbRecord)
    {
        slog(PB_PRINT,SLOG_ERR,"pb:atPb_WriteContactToPbmTable:invalid input");/*lint  !e26*/
        return ZPB_DB_ERROR_INVALIDPTR;
    }
    slog(PB_PRINT,SLOG_DEBUG,"pb:atPb_WriteContactToPbmTable:input index is %d,location=%d\n",pPbRecord->pbIndex,pPbRecord->pbLocation);

    //atPb_EncodeNameToAscii(pbRecord->name,ascName);
    if(TRUE == pbNewFlag)
    {
        atPb_SqlNewOneRec(pPbRecord,sql,sizeof(sql));
    }
    else
    {
        atPb_SqlModifyOneRec(pPbRecord,sql,sizeof(sql));
    }
    result = atPb_ExecDbSql(sql,NULL,NULL);

    if(ZPB_DB_OK == result)
    {
        if(ZPB_LOCATION_USIM == pPbRecord->pbLocation)
        {
            g_zPb_SimIndex[(pPbRecord->pbIndex)] = PBM_SUCCESS;
        }
        else if(ZPB_LOCATION_AP == pPbRecord->pbLocation)
        {
            g_zPb_ApIndex[(pPbRecord->pbIndex)] = PBM_SUCCESS;
        }
        //(VOID)system("adb push /etc_rw/config/pbm.db /usr/zte/zte_conf/config");
    }
    return result;
}



SINT32 atPb_DbCountTableLineCb(VOID *fvarg,int line,char **zresult,char **lname)
{
    if(1 > line)
    {
        slog(PB_PRINT,SLOG_ERR,"pb:pbm:record no data.");/*lint  !e26*/
        return -1;
    }
    *(int*)fvarg = atoi(zresult[0]);

    return 0;
}

T_zPb_DbResult atPb_SetSimCapacityTable(T_zPb_UsimCapacity pbPara)
{
    T_zPb_DbResult  result                  = ZPB_DB_OK;
    CHAR            sql[ZPB_MAX_BYTES_DB]   = {0};
    UINT32          count                   = 0;

    snprintf(sql,sizeof(sql)-1,"select count(*) from %s",ZPB_DB_SIM_CAPABILITY_TABLE);
    (VOID)atPb_ExecDbSql(sql,atPb_DbCountTableLineCb,&count);
    if(0 < count)
    {
        memset(sql, 0, sizeof(sql));
        snprintf(sql,sizeof(sql)-1,"delete from %s where Sim_type>=0",ZPB_DB_SIM_CAPABILITY_TABLE);
        result = atPb_ExecDbSql(sql,NULL,NULL);
        if(ZPB_DB_OK != result)
        {
            slog(PB_PRINT,SLOG_DEBUG,"pb:atPb_SetSimCapacityTable:fail!\n");
            return result;
        }
    }

    memset(sql, 0, sizeof(sql));
    snprintf(sql,sizeof(sql)-1,"insert into %s (Sim_type,Max_record_number,Used_record_number,Max_number_len,Max_name_len,Max_anr_len,Max_anr1_len, \
	          Max_email_len,Max_sne_len) values(\'%d\',\'%d\',\'%d\',\'%d\',\'%d\',\'%d\',\'%d\',\'%d\',\'%d\')",
            ZPB_DB_SIM_CAPABILITY_TABLE,
            pbPara.simType,
            pbPara.maxRecordNum,
            pbPara.usedRecordNum,
            pbPara.maxNumberLen,
            pbPara.maxNameLen,
            pbPara.maxAnrLen,
            pbPara.maxAnr1Len,
            pbPara.maxEmailLen,
            pbPara.maxSneLen);
    
    slog(PB_PRINT,SLOG_DEBUG,"pb:atPb_SetSimCapacityTable:ok!\n");
    return atPb_ExecDbSql(sql,NULL,NULL);
}

T_zPb_DbResult atPb_SetApCapacityTable()
{
    T_zPb_DbResult      result                  = ZPB_DB_OK;
    CHAR                sql[ZPB_MAX_BYTES_DB]   = {0};
    SINT32              count                   = 0;
    T_zPb_ApCapacity    pbPara                  = {0};
    snprintf(sql,sizeof(sql)-1,"select count(*) from %s",ZPB_DB_DEVICE_CAPABILITY_TABLE);
    (VOID)atPb_ExecDbSql(sql,atPb_DbCountTableLineCb,&count);
    if(0 < count)
    {
        memset(sql, 0, sizeof(sql));
        snprintf(sql,sizeof(sql)-1,"delete from %s",ZPB_DB_DEVICE_CAPABILITY_TABLE);
        result = atPb_ExecDbSql(sql,NULL,NULL);
        if(ZPB_DB_OK != result)
        {
            slog(PB_PRINT,SLOG_DEBUG,"pb:atPb_SetApCapacityTable:fail!\n");
            return result;
        }
    }
    memset(sql, 0, sizeof(sql));
    snprintf(sql,sizeof(sql)-1,"select count(*) from %s where Location=%d",ZPB_DB_PBM_TABLE,ZPB_LOCATION_AP);
    result = atPb_ExecDbSql(sql,atPb_DbCountTableLineCb,&count);
    if(ZPB_DB_OK == result)
    {
        pbPara.usedRecordNum = count;
        pbPara.maxRecordNum  = ZPB_AP_MAX_RECORD;
    }
    slog(PB_PRINT,SLOG_DEBUG,"pb:max_rec_num=%d,used=%d",pbPara.maxRecordNum,pbPara.usedRecordNum);

    memset(sql, 0, sizeof(sql));
    snprintf(sql,sizeof(sql)-1,"insert into %s (Max_record_number,Used_record_number) values(\'%d\',\'%d\')",
            ZPB_DB_DEVICE_CAPABILITY_TABLE,
            pbPara.maxRecordNum,
            pbPara.usedRecordNum);
    return atPb_ExecDbSql(sql,NULL,NULL);
}

T_zPb_DbResult atPb_DbGetIndexByGroupCb(VOID *fvarg,int line,char **zresult,char **lname)
{
    T_zPb_ApIndex   *pbIndex    = NULL;
    int             i           = 0;

    if(1 > line)
    {
        return ZPB_DB_ERROR;
    }

    pbIndex = (T_zPb_ApIndex*)fvarg;
    i = pbIndex->count;
    slog(PB_PRINT,SLOG_DEBUG,"pb:atPb_DbGetIndexByGroupCb enter,i=%d\n",i);

    pbIndex->apIndex[i+1]= atoi(zresult[0]);
    slog(PB_PRINT,SLOG_DEBUG,"pb:get_index_by_group_cb:pbm_index=%d",pbIndex->apIndex[i+1]);

    pbIndex->count = i + 1;
    slog(PB_PRINT,SLOG_DEBUG,"pb:get_index_by_group_cb:pbm count is %d",pbIndex->count);
    return ZPB_DB_OK;
}

T_zPb_DbResult atPb_DelRecFromPbmTableByGroup(T_zPb_ApIndex *index)
{
    T_zPb_DbResult  result                      = ZPB_DB_OK;
    CHAR            sql[ZPB_MAX_BYTES_DB]       = {0};
    SINT32          countByGroup                = 0;
    CHAR            pbGroup[ZPB_PARAM_SIZE20]   = {0};

    sc_cfg_get(ZPB_NV_GROUP,pbGroup,sizeof(pbGroup));
    snprintf(sql,sizeof(sql)-1,"select count(*) from %s where Location=%d and (Pbm_group=\"%s\")",
            ZPB_DB_PBM_TABLE, ZPB_LOCATION_AP, pbGroup);
    (VOID)atPb_ExecDbSql(sql,atPb_DbCountTableLineCb,&countByGroup);

    memset(sql,0,sizeof(sql));
    snprintf(sql,sizeof(sql)-1,"select Pbm_index from %s where Location=%d and (Pbm_group=\"%s\")",ZPB_DB_PBM_TABLE,ZPB_LOCATION_AP,pbGroup);
    result = atPb_ExecDbSql(sql,atPb_DbGetIndexByGroupCb, index);    /*lint !e64*/

    if(countByGroup == index->count)
    {
        memset(sql,0,sizeof(sql));
        snprintf(sql,sizeof(sql)-1,"delete from %s where Location=%d and (Pbm_group=\"%s\")",
                ZPB_DB_PBM_TABLE,
                ZPB_LOCATION_AP,
                pbGroup);

        if(ZPB_DB_OK == atPb_ExecDbSql(sql,NULL,NULL))
        {
            (VOID)sc_cfg_set(ZPB_NV_WRITE_FLAG, ZPB_OPERATE_SUC);
        }
        slog(PB_PRINT,SLOG_DEBUG,"pb:pbm:exec table %s result %d\n", ZPB_DB_PBM_TABLE,result);
    }
    else
    {
        return ZPB_DB_ERROR;
    }
    /*write group nvconfig ""*/
    (VOID)sc_cfg_set(ZPB_NV_GROUP, "");
    return result;
}

VOID atPb_GetLocationIndexForDel(T_zPb_DelInfo *recData,SINT32 delTime)
{
    T_zPb_Header pbHeader = {0};

    if(NULL == recData)
    {
        slog(PB_PRINT,SLOG_ERR,"pb:atPb_GetLocationIndexForDel--invalid input\n");
        return;
    }

    pbHeader.pbId = recData->delId[delTime];

    if(ZPB_DB_OK != atPb_GetIndexLocationById(&pbHeader))
    {
        slog(PB_PRINT,SLOG_ERR,"pb:pbm:find index and location failed");
        return;
    }
    recData->delIndex[delTime]  = pbHeader.pbIndex;
    recData->delLocation        = pbHeader.pbLocation;
    slog(PB_PRINT,SLOG_DEBUG,"pb:pbm:del index=%d,location=%d,del_pbm_time=%d",
            recData->delIndex[delTime],recData->delLocation,delTime);
}

/* ת޸ģΪȷatٴݿ⣬ʴ洢ɹatʧɾ֮ǰ洢Ķֳ
T_zPb_DbResult atPb_DelRecordFromDBWhenAddErr()
{
    T_zPb_DbResult  result                  = ZPB_DB_OK;
    CHAR            sql[ZPB_MAX_BYTES_DB]   = {0};

    sprintf(sql,"delete from %s where Pbm_index=%ld",ZPB_DB_PBM_TABLE,g_zPb_pbIndex);
    result = atPb_ExecDbSql(sql,NULL,NULL);

    if(ZPB_DB_OK == result)
    {
       g_zPb_SimIndex[g_zPb_pbIndex] = PBM_ERROR_NOT_FOUND;
    }
    
    printf("[PB] atPb_DelRecordFromDBWhenAddErr  result=%d,g_zPb_pbIndex=%d\n", result,g_zPb_pbIndex);
    g_zPb_pbIndex = 0;
    return result;
}*/


T_zPb_DbResult atPb_DelARecFromPbmTable(T_zPb_DelInfo *pbPara, SINT32 delTime)
{
    T_zPb_DbResult  result                  = ZPB_DB_OK;
    CHAR            sql[ZPB_MAX_BYTES_DB]   = {0};

    if(NULL == pbPara)
    {
        slog(PB_PRINT,SLOG_ERR,"pb:pbm:invalid input");
        return ZPB_DB_ERROR_INVALIDPTR;
    }
    atPb_GetLocationIndexForDel(pbPara, delTime);//del_pbm_time);
    slog(PB_PRINT,SLOG_DEBUG,"pb:atPb_DelARecFromPbmTable enter,delTime=%d,id=%d\n",delTime,pbPara->delId[delTime]);

    snprintf(sql,sizeof(sql)-1,"delete from %s where id=%d",ZPB_DB_PBM_TABLE,pbPara->delId[delTime]);//del_pbm_time]);// ʱȶΪ0
    result = atPb_ExecDbSql(sql,NULL,NULL);

    if(ZPB_DB_OK == result)
    {
        if(ZPB_LOCATION_AP == pbPara->delLocation)
        {
            g_zPb_ApIndex[(pbPara->delIndex[delTime])] = PBM_ERROR_NOT_FOUND;
        }
        else if(ZPB_LOCATION_USIM == pbPara->delLocation)
        {
            g_zPb_SimIndex[(pbPara->delIndex[delTime])] = PBM_ERROR_NOT_FOUND;
        }
    }
    return result;
}
VOID atPb_ClearSimPbmIndexArray(VOID)
{
    SINT32 i = 1;

    for(i = 1; (i <= g_zPb_SimIndex[0]) && (i < (ZPB_SIM_MAX_RECORD+1)); i++)
    {
        g_zPb_SimIndex[i] = PBM_ERROR_NOT_FOUND;
    }
}

VOID atPb_ClearApPbmIndexArray(VOID)
{
    SINT32 i = 1;

    for(i = 1 ; (i <= g_zPb_ApIndex[0]) && (i < (ZPB_AP_MAX_RECORD+1)); i++)
    {
        g_zPb_ApIndex[i] = PBM_ERROR_NOT_FOUND;
    }
}

T_zPb_DbResult atPb_DelAllRecsFromPbmTable(T_zPb_DelInfo *pbPara)
{
    T_zPb_DbResult  result                  = ZPB_DB_OK;
    CHAR            sql[ZPB_MAX_BYTES_DB]   = {0};

    if(NULL == pbPara)
    {
        slog(PB_PRINT,SLOG_ERR,"pb:atPb_DelAllRecsFromPbmTable:invalid input\n");/*lint  !e26*/
        return ZPB_DB_ERROR_INVALIDPTR;
    }
    snprintf(sql,sizeof(sql)-1,"delete from %s where Location=%d",ZPB_DB_PBM_TABLE, pbPara->delLocation);
    result = atPb_ExecDbSql(sql,NULL,NULL);
    slog(PB_PRINT,SLOG_DEBUG,"pb:atPb_DelAllRecsFromPbmTable:exec table %s result %d", ZPB_DB_PBM_TABLE,result);

    if(ZPB_LOCATION_USIM == pbPara->delLocation)
    {
        atPb_ClearSimPbmIndexArray();
    }
    else if(ZPB_LOCATION_AP == pbPara->delLocation)
    {
        atPb_ClearApPbmIndexArray();
    }
    else if(ZPB_LOCATION_ALL == pbPara->delLocation)
    {
        atPb_ClearSimPbmIndexArray();
        atPb_ClearApPbmIndexArray();
    }
    return result;
}


