/**************************************************************************
*
*                  Copyright (c) 2013 ZTE Corporation.
*
***************************************************************************
* ģ   : pb
*    : pb_main.c
* ļ :
* ʵֹ : PBϢ̿ƴ
*      : 
*      : V1.0
*  : 2017.3.13
* ˵ :
**************************************************************************/

/**************************************************************************
* #include
**************************************************************************/
#include <errno.h>
#include <sys/msg.h>
#include <semaphore.h>

#include "pb_com.h"
/**************************************************************************
* 
**************************************************************************/
//#define MODULE_ID_PB_LOCAL 0x2002
/**************************************************************************
* ݽṹ
**************************************************************************/
typedef VOID (*pAtWeb_PbMsgProc)(UINT8 *pDatabuf); 

typedef struct
{
	UINT32 msg_id;
	VOID (*func_ptr)(UINT8 *pDatabuf);
	BOOL need_block;//ǷҪҪϢתڲ̴߳
}T_zPbHandleTable;


/**************************************************************************
* static
**************************************************************************/

VOID atWeb_AddOneContact(UINT8 *pDatabuf);
VOID atWeb_DelOneContact(UINT8 *pDatabuf);
VOID atWeb_DelMultiContact(UINT8 *pDatabuf);
VOID atWeb_DelAllContact(UINT8 *pDatabuf);

/**************************************************************************
* ȫֱ
**************************************************************************/
T_zPb_optRsp g_PbOptRsp = {0};	
sem_t   g_Pb_sem_id = {0};//ڲȴ
int  g_zPb_MsqId  = -1;
int  g_zPb_LocalMsqId  = -1;

/**************************************************************************
* ʵ
**************************************************************************/

// pDatabufΪpstMsg->aucDataBuf
VOID atWeb_AddOneContact(UINT8 *pDatabuf)
{
	T_zPb_WebContact* webPbContact = NULL;
	
	if(pDatabuf == NULL)
	{
		printf("[pb], atWeb_AddOneContact para is null\n");
		return;
	}
	webPbContact = (T_zPb_WebContact*)pDatabuf;
    atWeb_AddOnePb(webPbContact, g_Pb_sem_id);
}

VOID atWeb_DelOneContact(UINT8 *pDatabuf)
{
    T_zPb_DelInfo *delRecord = NULL;
	
	if(pDatabuf == NULL)
	{
		printf("[pb], atWeb_DelOneContact para is null\n");
		return;
	}
	delRecord = (T_zPb_DelInfo*)pDatabuf;
    atWeb_DelOnepb(delRecord, g_Pb_sem_id);
}

VOID atWeb_DelMultiContact(UINT8 *pDatabuf)
{
    T_zPb_DelInfo *delRecord = NULL;
	
	if(pDatabuf == NULL)
	{
		printf("[pb], atWeb_DelOneContact para is null\n");
		return;
	}
	delRecord = (T_zPb_DelInfo*)pDatabuf;
    atWeb_DelMultPb(delRecord, g_Pb_sem_id);
}
VOID atWeb_DelAllContact(UINT8 *pDatabuf)
{
    T_zPb_DelInfo *delRecord = NULL;
	
	if(pDatabuf == NULL)
	{
		printf("[pb], atWeb_DelOneContact para is null\n");
		return;
	}
	delRecord = (T_zPb_DelInfo*)pDatabuf;
    atWeb_DelAllpb(delRecord, g_Pb_sem_id);
}

/*VOID zPb_RecvPbInitRst(UINT8 *pDatabuf)
{
	memcpy(&g_PbOptRsp, pDatabuf, sizeof(T_zPb_optRsp));

	if(g_PbOptRsp.result == 1)
	{
		zPb_initAtOk();
	}
	else
	{
		zPb_initAtErr();
	}
}*/
	
VOID zPb_RecvScpbrInd(UINT8 *pDatabuf)
{
	T_zPb_AtScpbrTestRes*  scpbsInd= NULL;
	
	if(pDatabuf == NULL)
	{
		return;
	}
		
	scpbsInd = (T_zPb_AtScpbrTestRes*)pDatabuf;
	atPb_ScpbrTestRsp(scpbsInd);
}	

VOID zPb_RecvScpbrReadInd(UINT8 *pDatabuf)
{
	T_zPb_ScpbrSetRes*  scpbsReadInd= NULL;
	
	if(pDatabuf == NULL)
	{
		return;
	}
		
	scpbsReadInd = (T_zPb_ScpbrSetRes*)pDatabuf;
	atPb_ScpbrSetRsp(scpbsReadInd);
}	
	
VOID zPb_RecvCpmsInd(UINT8 *pDatabuf)
{
	T_zPb_AtCpbsReadRes*  cpbsInd = NULL;
	
	if(pDatabuf == NULL)
	{
		return;
	}
		
	cpbsInd = (T_zPb_AtCpbsReadRes*)pDatabuf;
	atPb_RecvCpbsReadRsp(cpbsInd);
}	
	
VOID zPb_RecvZpbicInd(UINT8 *pDatabuf)
{
	T_zAt_ZpbicRes *ptPara = ZUFI_NULL;	
    if(pDatabuf == NULL)
    {
        return;
    }
    ptPara = (T_zAt_ZpbicRes*)(pDatabuf);
	printf( "zPb_RecvZpbicInd para,result:%d, type:%d\n", ptPara->result, ptPara->opertype);
	if((1 == ptPara->result) && (1 == ptPara->opertype))
    {
        //жNV,added by wenqin 2016-5-18
        CHAR needPb[50]={0};
        sc_cfg_get(NV_NEED_SUPPORT_PB,needPb,sizeof(needPb));
        if(0 != strcmp(needPb,"no"))
        {
            ipc_send_message(MODULE_ID_PB, MODULE_ID_AT_CTL, MSG_CMD_PBINIT_REQ, 0, NULL, 0);
        }        
    }
}

VOID zPb_RecvZuslotInd(UINT8 *pDatabuf)
{
	T_zAt_ZuslotRes *ptPara = ZUFI_NULL;	
    if(pDatabuf == NULL)
    {
        return;
    }
    ptPara = (T_zAt_ZuslotRes*)(pDatabuf);
	printf( "zPb_RecvZpbicInd para,result:%d, type:%d\n", ptPara->slot, ptPara->slot_state);
	if(ptPara->slot_state == 0)
    {
        //жNV,added by wenqin 2016-5-18
        CHAR needPb[50]={0};
        sc_cfg_get(NV_NEED_SUPPORT_PB,needPb,sizeof(needPb));
        if(0 != strcmp(needPb,"no"))
        {
            atPb_CfgPbNvInit();
            atPb_DelAllRecsSimDb();  
        }        
    }
}

VOID zPb_RecvPbInitRst(UINT8 *pDatabuf)
{
	int pbReadRet = -1;
	memcpy(&g_PbOptRsp, pDatabuf, sizeof(T_zPb_optRsp));

	if(g_PbOptRsp.result == -1)
	{
		atPb_IintPbErr(NULL);
		return;
	}
	//Ƭݶȡ
	pbReadRet = atPb_SendScpbrSet_repeat(g_Pb_sem_id);
	printf("zPb_RecvPbInitRst result:%d\n", pbReadRet);
	sc_cfg_set(ZPB_NV_INIT, ZPB_OPERATE_SUC);
}

void zPbLocalHandleWebMsg(MSG_BUF *ptMsgBuf)
{
	assert(ptMsgBuf != NULL);
	printf( "Pb recv web msg cmd:%d\n", ptMsgBuf->usMsgCmd);
	switch(ptMsgBuf->usMsgCmd)
	{
		case MSG_CMD_WRITE_PB:
			atWeb_AddOneContact(ptMsgBuf->aucDataBuf);
			break;
		case MSG_CMD_DEL_A_PB:
			atWeb_DelOneContact(ptMsgBuf->aucDataBuf);
			break;
		case MSG_CMD_DEL_MUTI_PB:
			atWeb_DelMultiContact(ptMsgBuf->aucDataBuf);
			break;
		case MSG_CMD_DEL_ALL_PB:
			atWeb_DelAllContact(ptMsgBuf->aucDataBuf);
			break;
		default:
			break;

	}
}

void zPbHandleWebMsg(MSG_BUF *ptMsgBuf)
{
	assert(ptMsgBuf != NULL);
	printf( "Pb recv web msg cmd:%d\n", ptMsgBuf->usMsgCmd);
	switch(ptMsgBuf->usMsgCmd)
	{
		case MSG_CMD_WRITE_PB:		
		case MSG_CMD_DEL_A_PB:
		case MSG_CMD_DEL_MUTI_PB:
		case MSG_CMD_DEL_ALL_PB:
		ipc_send_message(MODULE_ID_PB, MODULE_ID_PB_LOCAL, ptMsgBuf->usMsgCmd, ptMsgBuf->usDataLen, (unsigned char *)ptMsgBuf->aucDataBuf, 0);
			break;
		default:
			break;

	}
}

UINT8 zPbMsgCreat(VOID)
{
	g_zPb_MsqId = msgget(MODULE_ID_PB, IPC_CREAT | 0600);
    if(g_zPb_MsqId == -1)
    {
        return ZUFI_FAIL;
    }
	g_zPb_LocalMsqId = msgget(MODULE_ID_PB_LOCAL, IPC_CREAT | 0600);
    if(g_zPb_LocalMsqId == -1)
    {
        return ZUFI_FAIL;
    }
	sem_init(&g_Pb_sem_id, 0 , 0);

	return ZUFI_SUCC;
}

/*ʼpbmAP 绰׼ɹ޿ʱwebuiתȦʱϲգat_ctlҲһ飬Ϣ*/
void detect_modem_state(void)
{
    CHAR state[50] = {0};

    sc_cfg_get("modem_main_state", state, sizeof(state));
    if(0 == strcmp(state, "modem_sim_undetected") || 0 == strcmp(state, "modem_sim_destroy"))
    {        
        sc_cfg_set("pbm_init_flag","0");
    }
}

void zPbLocalHandleAtctlMsg(MSG_BUF *ptMsgBuf)
{
	assert(ptMsgBuf != NULL);
	printf( "Pb local recv msg cmd:%d\n", ptMsgBuf->usMsgCmd);
	switch(ptMsgBuf->usMsgCmd)
	{
		case MSG_CMD_PBINIT_RSP:
			zPb_RecvPbInitRst(ptMsgBuf->aucDataBuf);
			break;
		default:
			break;

	}
}

VOID zPbHandleAtctlMsg(MSG_BUF *ptMsgBuf)
{
    assert(ptMsgBuf != NULL);
	printf( "Pb recv msg cmd:%d\n", ptMsgBuf->usMsgCmd);
	switch(ptMsgBuf->usMsgCmd)
	{
        case MSG_CMD_DELETE_PB_RSP:
        case MSG_CMD_ADD_MODIFY_PB_RSP:
		case MSG_CMD_READ_PB_RSP:
			{
				memcpy(&g_PbOptRsp, ptMsgBuf->aucDataBuf, sizeof(T_zPb_optRsp));
				sem_post(&g_Pb_sem_id);
			}
			break;
		case MSG_CMD_CPBS_IND:
			zPb_RecvCpmsInd(ptMsgBuf->aucDataBuf);
			break;
		case MSG_CMD_SCPBR_IND:
			zPb_RecvScpbrInd(ptMsgBuf->aucDataBuf);
			break;
		case MSG_CMD_SCPBR_READ_IND:
			zPb_RecvScpbrReadInd(ptMsgBuf->aucDataBuf);
			break;
		case MSG_CMD_ZPBIC_IND:			
			zPb_RecvZpbicInd(ptMsgBuf->aucDataBuf);
			break;
        case MSG_CMD_ZUSLOT_IND:
            zPb_RecvZuslotInd(ptMsgBuf->aucDataBuf);
			break;    
		case MSG_CMD_PBINIT_RSP:
			ipc_send_message(MODULE_ID_PB, MODULE_ID_PB_LOCAL, ptMsgBuf->usMsgCmd, ptMsgBuf->usDataLen, (unsigned char *)ptMsgBuf->aucDataBuf,0);
			break;
		
		default:
			break;

	}
}	

VOID zPbHandleResetToFactory()
{
    CHAR clearPb[50] = {0};
	
    sc_cfg_get(NV_CLEAR_PB_WHEN_RESTORE,clearPb,sizeof(clearPb));

	printf("atWeb_RestoreFactorySetting entered! \n");
	printf("clear_pb_when_restore=%s \n", clearPb);	
	if(strcmp(clearPb, "yes") == 0)
    {
        atPb_DropDb();
    }
	ipc_send_message(MODULE_ID_PB, MODULE_ID_MAIN_CTRL, MSG_CMD_RESET_RSP, 0, NULL,0);
}

void zPbHandleMainCtrlMsg(MSG_BUF *ptMsgBuf)
{
	assert(ptMsgBuf != NULL);
	printf( "Pb recv main ctrl msg cmd:%d\n", ptMsgBuf->usMsgCmd);
	switch(ptMsgBuf->usMsgCmd)
	{
		case MSG_CMD_RESET_NOTIFY:
			zPbHandleResetToFactory(ptMsgBuf->aucDataBuf);
			break;
		default:
			break;

	}
}


void pb_msg_thread_proc(void* arg)
{
	int iRet = 0;
	MSG_BUF stMsg = {0};
	int msgSize = sizeof(MSG_BUF) - sizeof(SINT32);
	int queueId = *((int*)arg);
	prctl(PR_SET_NAME, "pb_local", 0, 0, 0);
	while(1)
	{
		iRet = 0;
		memset(&stMsg, 0x00, sizeof(MSG_BUF));
		iRet = msgrcv(queueId, &stMsg, msgSize, 0, 0);
printf("pb_msg_thread_proc:%x,%x MODULE_ID_AT_CTL=%x\n",stMsg.src_id,stMsg.usMsgCmd, MODULE_ID_AT_CTL);        
		if (iRet >= 0)
		{
			switch (stMsg.src_id)
	        {
	            case MODULE_ID_WEB_CGI:
	            {
					zPbHandleWebMsg(&stMsg);
	                break;
	            }
	            case MODULE_ID_AT_CTL:
	            {                
					zPbHandleAtctlMsg(&stMsg);
	                break;
	            }
	            case MODULE_ID_PB://ضд
				{
					zPbLocalHandleWebMsg(&stMsg);				
					zPbLocalHandleAtctlMsg(&stMsg);
					break;
				}
				case MODULE_ID_MAIN_CTRL:
				{
					zPbHandleMainCtrlMsg(&stMsg);
					break;
				}
	            default:
	            {
	                break;
	            }
	        }
		}
		else
		{    
			printf("[pb] errno = %d, errmsg = %s\n", errno,strerror(errno));
		}
	} 
}


int phonebook_main(int argc, char* argv[])
{
	pthread_t recv_thread_tid = 0;
    MSG_BUF   msgBuf      = {0};
	CHAR needPb[50] = {0};
	prctl(PR_SET_NAME, "pb_main", 0, 0, 0);

	//NVʼӡ𣬲עᶯ̬ӡź
	loglevel_init();
	
	//жNV,added by wenqin 2016-5-18
    sc_cfg_get(NV_NEED_SUPPORT_PB, needPb, sizeof(needPb));
    if(0 != strcmp(needPb, "no"))
    {
#ifdef WEBS_SECURITY
		if(access(ZPB_DB_PATH, F_OK) != 0)
		{
			if(access(ZPB_TMP_PATH, F_OK) == 0)
			{
				if(remove(ZPB_SEC_PATH) != 0)
				{
					slog(PB_PRINT,SLOG_ERR,"remove ZPB_SEC_PATH fail");
				}
				if(rename(ZPB_TMP_PATH, ZPB_SEC_PATH) != 0)
				{
					slog(PB_PRINT,SLOG_ERR,"rename ZPB_TMP_PATH fail");
				}
			}
			if(access(ZPB_SEC_PATH, F_OK) == 0)
			{
				char rnum_buf[24] = {0};
				char cmd[128] = {0};
				
				sc_cfg_get("rnum_at", rnum_buf, sizeof(rnum_buf));
				snprintf(cmd, sizeof(cmd), "/bin/openssl enc -d -aes256 -salt -in %s -out %s -pass pass:%s", ZPB_SEC_PATH, ZPB_DB_PATH, rnum_buf);
				zxic_system(cmd);
			}
		}
#endif		
        zPbMsgCreat();
 		atPb_Init();		
    }
	else
	{
		return -1;
	}
		
    printf("Pb app init finished, will to receive msg, msgid:%d\n", g_zPb_MsqId);	
	//߳ڴڲϢӦϢsourceIdMODULE_ID_SMS
    if(pthread_create(&recv_thread_tid, NULL, pb_msg_thread_proc, (void*)(&g_zPb_LocalMsqId)) == -1)
    {
		assert(0);
    }
    
    detect_modem_state();
    
	//߳ڴⲿϢӦϢsourceIdMODULE_ID_SMS
    pb_msg_thread_proc(&g_zPb_MsqId);
	return 0;
}

