/**************************************************************************
*
*                  Copyright (c) 2013 ZTE Corporation.
*
***************************************************************************
* ģ   : Atserver
*    : pb_proc.c
* ļ :
* ʵֹ : ATͺͽģ麯
*      : syx
*      : V1.0
*  : 2013-04-16
* ˵ :
**************************************************************************/

/**************************************************************************
* ޸ļ¼ :
***************************************************************************/
/**************************************************************************
* ޸ı :
*    :
* ޸ :
* ޸ :
**************************************************************************/

/**************************************************************************
* #include
**************************************************************************/
//#include "port_com.h"
//#include "at_main.h"
//#include "at_proc.h"
#include <ctype.h>
#include <semaphore.h>
#include <limits.h>
#include "pb_com.h"

/**************************************************************************
* 
**************************************************************************/
#define ZPB_UCS2                    1
#define ZPB_UCS2_PREFIX             0x80
#define ZPB_UCS2_PREFIX_LEN         2
#define ZPB_NON_GSM                     0x20
#define ZPB_GSM_CHARACTER_SET_SIZE      0x80
#define ZPB_INIT_LOAD_RECORD_NUM    50

/**************************************************************************
* ݽṹ
**************************************************************************/
VOID atPb_CvtChCode(UINT16 basePointer, UINT8 srcData, UINT8 *chMsb, UINT8 *chLsb);
BOOL atPb_CvtU82ToU80(const UINT8 *srcData, UINT32 srcLen, UINT8 *destData, UINT32 destLen);
BOOL atPb_CvtU81ToU80(const UINT8 *srcData, UINT32 srcLen, UINT8 *destData, UINT32 destLen);
extern VOID atPb_ClearSimPbmIndexArray(VOID);
/**************************************************************************
* static
**************************************************************************/

/**************************************************************************
* ȫֱ
**************************************************************************/
extern sem_t   g_Pb_sem_id;
extern T_zPb_optRsp g_PbOptRsp;
//UINT32                      g_zPb_pbIndex = 0;
UINT32                      g_zPb_DelIndex = 0;
SINT32                      g_zPb_SimIndex[ZPB_SIM_MAX_RECORD+1]  = {0};
SINT32                      g_zPb_ApIndex[ZPB_AP_MAX_RECORD+1]    = {0};
T_zPb_DelStatusMultiOrAll   g_zPb_DelStatusUsim     = {0};
const unsigned char G_ZPB_NEWUCS2TOGSM[ZPB_GSM_CHARACTER_SET_SIZE*2] =
    {           /*+0x0      +0x1        +0x2        +0x3        +0x4        +0x5        +0x6        +0x7*/
    /*0x00*/    ZPB_NON_GSM,    ZPB_NON_GSM,    ZPB_NON_GSM,    ZPB_NON_GSM,    ZPB_NON_GSM,    ZPB_NON_GSM,    ZPB_NON_GSM,    ZPB_NON_GSM,
    /*0x08*/    ZPB_NON_GSM,    ZPB_NON_GSM,    0x0a,       ZPB_NON_GSM,    ZPB_NON_GSM,    0x0d,       ZPB_NON_GSM,    ZPB_NON_GSM,
    /*0x10*/    ZPB_NON_GSM,    ZPB_NON_GSM,    ZPB_NON_GSM,    ZPB_NON_GSM,    ZPB_NON_GSM,    ZPB_NON_GSM,    ZPB_NON_GSM,    ZPB_NON_GSM,
    /*0x18*/    ZPB_NON_GSM,    ZPB_NON_GSM,    ZPB_NON_GSM,    ZPB_NON_GSM,    ZPB_NON_GSM,    ZPB_NON_GSM,    ZPB_NON_GSM,    ZPB_NON_GSM,
    /*0x20*/    0x20,       0x21,       0x22,       0x23,       0x02,       0x25,       0x26,       0x27,
    /*0x28*/    0x28,       0x29,       0x2a,       0x2b,       0x2c,       0x2d,       0x2e,       0x2f,
    /*0x30*/    0x30,       0x31,       0x32,       0x33,       0x34,       0x35,       0x36,       0x37,
    /*0x38*/    0x38,       0x39,       0x3a,       0x3b,       0x3c,       0x3d,       0x3e,       0x3f,
    /*0x40*/    0x00,       0x41,       0x42,       0x43,       0x44,       0x45,       0x46,       0x47,
    /*0x48*/    0x48,       0x49,       0x4a,       0x4b,       0x4c,       0x4d,       0x4e,       0x4f,
    /*0x50*/    0x50,       0x51,       0x52,       0x53,       0x54,       0x55,       0x56,       0x57,
    /*0x58*/    0x58,       0x59,       0x5a,       0x5b,       ZPB_NON_GSM,    0x5d,       ZPB_NON_GSM,    0x11,
    /*0x60*/    ZPB_NON_GSM,    0x61,       0x62,       0x63,       0x64,       0x65,       0x66,       0x67,
    /*0x68*/    0x68,       0x69,       0x6a,       0x6b,       0x6c,       0x6d,       0x6e,       0x6f,
    /*0x70*/    0x70,       0x71,       0x72,       0x73,       0x74,       0x75,       0x76,       0x77,
    /*0x78*/    0x78,       0x79,       0x7a,       ZPB_NON_GSM,    ZPB_NON_GSM,    ZPB_NON_GSM,    ZPB_NON_GSM,    ZPB_NON_GSM,
    /*0x80*/    ZPB_NON_GSM,    ZPB_NON_GSM,    ZPB_NON_GSM,    ZPB_NON_GSM,    ZPB_NON_GSM,    ZPB_NON_GSM,    ZPB_NON_GSM,    ZPB_NON_GSM,
    /*0x88*/    ZPB_NON_GSM,    ZPB_NON_GSM,    ZPB_NON_GSM,    ZPB_NON_GSM,    ZPB_NON_GSM,    ZPB_NON_GSM,    ZPB_NON_GSM,    ZPB_NON_GSM,
    /*0x90*/    ZPB_NON_GSM,    ZPB_NON_GSM,    ZPB_NON_GSM,    ZPB_NON_GSM,    ZPB_NON_GSM,    ZPB_NON_GSM,    ZPB_NON_GSM,    ZPB_NON_GSM,
    /*0x98*/    ZPB_NON_GSM,    ZPB_NON_GSM,    ZPB_NON_GSM,    ZPB_NON_GSM,    ZPB_NON_GSM,    ZPB_NON_GSM,    ZPB_NON_GSM,    ZPB_NON_GSM,
    /*0xa0*/    ZPB_NON_GSM,    0x40,       ZPB_NON_GSM,    0x01,       0x24,       0x03,       ZPB_NON_GSM,    0x5f,
    /*0xa8*/    ZPB_NON_GSM,    ZPB_NON_GSM,    ZPB_NON_GSM,    ZPB_NON_GSM,    ZPB_NON_GSM,    ZPB_NON_GSM,    ZPB_NON_GSM,    ZPB_NON_GSM,
    /*0xb0*/    ZPB_NON_GSM,    ZPB_NON_GSM,    ZPB_NON_GSM,    ZPB_NON_GSM,    ZPB_NON_GSM,    ZPB_NON_GSM,    ZPB_NON_GSM,    ZPB_NON_GSM,
    /*0xb8*/    ZPB_NON_GSM,    ZPB_NON_GSM,    ZPB_NON_GSM,    ZPB_NON_GSM,    ZPB_NON_GSM,    ZPB_NON_GSM,    ZPB_NON_GSM,    0x60,
    /*0xc0*/    0x41,       0x41,       0x41,       0x41,       0x5b,       0x0e,       0x1c,       0x09,
    /*0xc8*/    0x45,       0x1f,       0x45,       0x45,       0x49,       0x49,       0x49,       0x49,
    /*0xd0*/    ZPB_NON_GSM,    0x5d,       0x4f,       0x4f,       0x4f,       0x4f,       0x5c,       ZPB_NON_GSM,
    /*0xd8*/    0x0b,       0x55,       0x55,       0x55,       0x5e,       0x59,       ZPB_NON_GSM,    0x1e,
    /*0xe0*/    0x7f,       0x61,       0x61,       0x61,       0x7b,       0x0f,       0x1d,       0x09,
    /*0xe8*/    0x04,       0x05,       0x65,       0x65,       0x07,       0x69,       0x69,       0x69,
    /*0xf0*/    ZPB_NON_GSM,    0x7d,       0x08,       0x6f,       0x6f,       0x6f,       0x7c,       ZPB_NON_GSM,
    /*0xf8*/    0x0c,       0x06,       0x75,       0x75,       0x7e,       0x79,       ZPB_NON_GSM,    0x79
    };
/**************************************************************************
* ʵ
**************************************************************************/
VOID atPb_Init(VOID)
{
    UINT32              pbCount         = 0;

    g_zPb_SimIndex[0] = 0;

    sc_cfg_set(ZPB_NV_INIT,ZPB_LOADING);
	(VOID)sc_cfg_set(ZPB_NV_WRITE_FLAG, ZPB_OPERATE_SUC);
	
    for(pbCount=1; pbCount<=ZPB_SIM_MAX_RECORD; pbCount++)
    {
        g_zPb_SimIndex[pbCount] = PBM_ERROR_NOT_FOUND;
    }
    if(ZPB_DB_OK != atPb_CreatDb())
    {
        slog(PB_PRINT,SLOG_ERR,"pb:atPb_Init:create pbm table failed\n");/*lint  !e26*/
        return;
    }
    if(ZPB_DB_OK != atPb_InitApIndex())
    {
        slog(PB_PRINT,SLOG_ERR,"pb:atPb_Init:init apIndex failed\n");
        return;
    }
    (VOID)atPb_SetApCapacityTable();
}

VOID atPb_CfgPbNvInit(VOID)
{
    (VOID)sc_cfg_set(ZPB_NV_USIMINDEXMIN,    "0");
    (VOID)sc_cfg_set(ZPB_NV_USIMINDEXMAX,    "0");
    (VOID)sc_cfg_set(ZPB_NV_USIMMEMORYFULL,  "no");
}
 /**
      * ʹ8182ʽ룬ѡ80ʽ
      *
       * @param src ԴUCS2ֽ
       * @param srcLen Դֽ鳤
       * @param dest Ŀ
       * @return Ŀ鳤
      */
int atpb_CvtUcs2ToAlphaField(char *src, int srcLen,char* dest) 
{
    int i = 0;
    int min = 0x7FFF;
    int max = 0;
    int temp = 0;
    int outOff = 0;
    
    printf("[PB] atpb_CvtUcs2ToAlphaField, srcLen=%d\n",srcLen);
    if(srcLen <= 0 || src == NULL ||dest == NULL)
    {
        return -1;
    }
    
    if(srcLen <= 2)
    {
        dest[0]=0x80;
        memcpy(dest+1, src, srcLen);
        printf("[PB] atpb_CvtUcs2ToAlphaField, use 80 code, len =%d\n",srcLen+1);
        return srcLen+1;
    }
    
    // Դĳȴ2ʱʹ8182ʽ
    
    // ȡԴСֵֵ
    for (i = 0; i < srcLen; i += 2) 
    {
        //ÿַĵ1ֽڲΪ0
        if (src[i] != 0) 
        {
            temp = (int) (((src[i] << 8) & 0xFF00) | (src[i+1] & 0xFF));
            // Ϊ81ʽлַ7λλҪ08000FFFFʹ81
#if 0 //kw 3
			if (temp < 0) 
            {
                max = min + 130;
                break;
            }
#endif            
            if (min > temp) 
            {
                min = temp;
            }
            
            if (max < temp) 
            {
                max = temp;
            }
        }
    }
    
    printf("[PB] atpb_CvtUcs2ToAlphaField, min=%d, max=%d\n",min, max);
    // ַUCS붼128ķΧڣô1ֽڶͬ
    if ((max - min) < 129) 
    {
        // 15λ8λͬͿʹ81ʽ
        if ((unsigned char) (min & 0x80) == (unsigned char) (max & 0x80)) 
        {
            // 81ʽĳȣʼĿ
            //dest = new unsigned char[srcLen / 2 + 3];
            // Ŀĵ2ֽΪ
            dest[1] = (unsigned char) (srcLen / 2);
            // õ1ֽΪ81
            dest[0] = (unsigned char) 0x81;
            // ַΪ15λ8λ
            min = (int) (min & 0x7F80);
            dest[2] = (unsigned char) ((min >> 7) & 0xFF);
            outOff = 3;
            printf("[PB] atpb_CvtUcs2ToAlphaField, use 81 code\n");
        }
        // 8ֽڲһһΪ0һΪ1ôʹ82ʽ
        else 
        {
            // 82ʽĳȣʼĿ
            //dest = new unsigned char[srcLen / 2 + 4];
            // Ŀĵ2ֽΪ
            dest[1] = (unsigned char) (srcLen / 2);
            // õ1ֽΪ82
            dest[0] = (unsigned char) 0x82;
            // ַΪԴСֵ1ֽΪ0ĳ⣩
            dest[2] = (unsigned char) ((min >> 8) & 0xFF);
            dest[3] = (unsigned char) (min & 0xFF);
            outOff = 4;
            printf("[PB] atpb_CvtUcs2ToAlphaField, use 82 code\n");
        }
        
        for (i = 0; i < srcLen; i += 2)
        {
            // 1ֽΪ0ȡ71λλ0
            if (src[i] == 0) 
            {
                dest[outOff] = (unsigned char) (src[i+1] & 0x7F);
            }
            // 1ֽڲΪ0UCSȥַλ1
            else 
            {
                temp = (int) ((((src[i] << 8) & 0xFF00) | (src[i+1] & 0xFF)) - min);
                dest[outOff] = (unsigned char) (temp | 0x80);
            }
            outOff++;
        }
        printf("[PB] atpb_CvtUcs2ToAlphaField,  outOff=%d,dest[%d]=%x\n",outOff,outOff,dest[outOff]);
        return outOff;
    }
    
    // 8182ĸʽҪʹ80ʽ
    dest[0]=0x80;
    memcpy(dest+1, src, srcLen);
    printf("[PB] atpb_CvtUcs2ToAlphaField, use 80 code, len =%d\n",srcLen+1);
    return srcLen+1;
}

 
int atPb_GetU80Code(const UINT8 *srcCode, UINT32 srcCodeLen, UINT8 *destCode, UINT32 destCodeLen)
{
    assert(destCode != NULL && srcCode != NULL);
    if(srcCodeLen == 0 || destCodeLen == 0 || destCodeLen < srcCodeLen)
    {
        return -1;
    }
    memset(destCode, 0, destCodeLen);
    destCode[0] = 0x80;
    printf("chenjie -----atPb_GetU80Code-----srcCode[0] = %d\n", srcCode[0]);
    switch (srcCode[0])
    {
    case 0x80:
        {
            memcpy(destCode, srcCode, srcCodeLen);
            return srcCodeLen;
        }
    case 0x81:
        {
            atPb_CvtU81ToU80(srcCode + 1, srcCodeLen - 1, destCode + 1, destCodeLen - 1);
            return srcCode[1]*2+1;
        }
    case 0x82:
        {
            atPb_CvtU82ToU80(srcCode + 1, srcCodeLen - 1, destCode + 1, destCodeLen - 1);
            return srcCode[1]*2+1;
        }
    default:
        {
            return -1;//FALSE;
        }
    }
}

/**************************************************************************
* : atPb_CvtU82ToU80
* : UCS282ʽıתΪ80ʽ
* ˵: (IN)
*           (OUT)
*   ֵ: 
* ˵: ͷֽ
**************************************************************************/
BOOL atPb_CvtU82ToU80(const UINT8 *srcData, UINT32 srcLen, UINT8 *destData, UINT32 destLen)
{
    UINT8  chNum       = 0;
    UINT16 basePointer = 0;
    UINT8  iCurChar    = 0;
    UINT32 iCurSrc     = 0;
    
    chNum       = (UINT32)srcData[0];
    basePointer = (UINT16)srcData[1];
    basePointer = basePointer << 8;
    basePointer = basePointer + srcData[2];
    if(chNum * 2 > destLen)
    {
        return FALSE;
    }
    for(iCurSrc = 3; iCurSrc < srcLen && iCurChar < chNum; iCurSrc++, iCurChar++)
    {
        UINT8 *curDest = destData + 2 * iCurChar;
        atPb_CvtChCode(basePointer, srcData[iCurSrc], curDest, curDest + 1);
    }
    return TRUE;
}

BOOL atPb_CvtU81ToU80(const UINT8 *srcData, UINT32 srcLen, UINT8 *destData, UINT32 destLen)
{
    UINT8  chNum       = 0;
    UINT16 basePointer = 0;
    UINT8  iCurChar    = 0;
    UINT32 iCurSrc     = 0;
    
    chNum       = srcData[0];
    basePointer = ((UINT16)srcData[1]) << 7;
    if(chNum * 2 > destLen)
    {
        return FALSE;
    }
    for(iCurSrc = 2; iCurSrc < srcLen && iCurChar < chNum; iCurSrc++, iCurChar++)
    {
        UINT8 *curDest = destData + 2 * iCurChar;
        atPb_CvtChCode(basePointer, srcData[iCurSrc], curDest, curDest + 1);
    }
    return TRUE;
}

/**************************************************************************
* : atPb_CvtChCode
* : U81\U82תΪU80
* ˵: (IN)
*           (OUT)
*   ֵ: 
* ˵: 
**************************************************************************/
VOID atPb_CvtChCode(UINT16 basePointer, UINT8 srcData, UINT8 *chMsb, UINT8 *chLsb)
{    
    UINT16 curChar = 0;
    
    assert(chMsb != NULL && chLsb != NULL);
    if((srcData & 0x80) == 0)
    {
        curChar = srcData;
    }
    else
    {
        curChar = basePointer + (srcData & 0x7f);
    }
    *chMsb = (UINT8)(curChar >> 8);
    *chLsb = (UINT8)((curChar << 8) >> 8);
    return;
}


 /**************************************************************************
* ƣ int atPb_String2Bytes(const char* pSrc, unsigned char* pDst, int nSrcLength)
*  ɴӡַתΪֽ 磺"C8329BFD0E01" --> {0xC8, 0x32, 0x9B, 0xFD, 0x0E, 0x01}
* ʵı 
* ޸ĵı 
* 
             pSrc: Դַָ
             pDst: Ŀָ
            nSrcLength: Դַ
*  
             ޣ 
*   ֵ
             Ŀݳȣ
* ˵ 
* ޸    汾     ޸      ޸
* -----------------------------------------------
* 2004/10/18  V1.0             ú
**************************************************************************/
int atPb_String2Bytes(const char* pSrc, unsigned char* pDst, int nSrcLength)
{
    int i=0;
    
    //У
    if(pSrc ==  NULL || pDst == NULL || nSrcLength < 0)
    {
        return -1;
    }

    for(i = 0; i < nSrcLength; i += 2)
    {
        // 4λ
        if(*pSrc >= '0' && *pSrc <= '9')
        {
            *pDst = (*pSrc - '0') << 4;
        }
        else
        {
            *pDst = ((toupper(*pSrc) - 'A') + 10) << 4;
        }

        pSrc++;

        // 4λ
        if(*pSrc >= '0' && *pSrc <= '9')
        {
            *pDst |= *pSrc - '0';
        }
        else
        {
            *pDst |= (toupper(*pSrc) - 'A') + 10;
        }

        pSrc++;
        pDst++;
    }

    // Ŀݳ
    return nSrcLength / 2;
}

 /**************************************************************************
* ƣ int atPb_Bytes2String(const unsigned char* pSrc, char* pDst, int nSrcLength)
*  ֽתΪɴӡַ 磺{0xC8, 0x32, 0x9B, 0xFD, 0x0E, 0x01} --> "C8329BFD0E01"
* ʵı
* ޸ĵı
* 
             pSrc: Դָ
             pDst: Ŀַָ
             nSrcLength: Դݳ
* 
             ޣ
*   ֵ
             Ŀݳȣ
* ˵
* ޸    汾     ޸      ޸
* -----------------------------------------------
* 2004/10/18  V1.0             ú
**************************************************************************/
int atPb_Bytes2String(const unsigned char* pSrc, char* pDst, int nSrcLength)
{
    const char tab[]="0123456789ABCDEF";    // 0x0-0xfַұ
    int i=0;

    //У
    if(pSrc ==  NULL || pDst == NULL || nSrcLength < 0)
    {
        return -1;
    }

    for(i=0; i<nSrcLength; i++)
    {
        *pDst++ = tab[*pSrc >> 4];      // 4λ
        *pDst++ = tab[*pSrc & 0x0f];    // 4λ
        pSrc++;
    }

    // ַӸ
    *pDst = '\0';

    // Ŀַ
    return nSrcLength * 2;
}


/*ӡwebĵ绰Ϣ*/
static VOID atPb_WebRecodeShow(T_zPb_WebContact const *pFromweb)
{
    slog(PB_PRINT,SLOG_DEBUG,"pb:fromweb.Index=%d\n",pFromweb->pbIndex);
    slog(PB_PRINT,SLOG_DEBUG,"pb:fromweb.Name=%s\n",pFromweb->name);
    slog(PB_PRINT,SLOG_DEBUG,"pb:fromweb.PbNum1=%s\n",pFromweb->mobilNumber);
    slog(PB_PRINT,SLOG_DEBUG,"pb:fromweb.PbNum2=%s\n",pFromweb->homeNumber);
    slog(PB_PRINT,SLOG_DEBUG,"pb:fromweb.PbNum3=%s\n",pFromweb->officeNumber);
    slog(PB_PRINT,SLOG_DEBUG,"pb:fromweb.email=%s\n",pFromweb->email);
}

int atPb_IintPbErr(UINT8 *pErrCode)
{
    sc_cfg_set(ZPB_NV_INIT, ZPB_LOAD_ERROR);
    //need break
    return TRUE;
}

int atPb_ScpbrSetErr(UINT8 *pErrCode)
{
   printf("[PB] atPb_ScpbrSetErr fail and return\n");
   sc_cfg_set(ZPB_NV_INIT, ZPB_OPERATE_SUC);
   return TRUE;
}

VOID atBase_IintPbOk(VOID)
{
    sc_cfg_set(ZPB_NV_INIT, ZPB_OPERATE_SUC);
    printf("[PB] atPb_SendScpbrSet atBase_IintPbOk \n");
}

/*SM洢*/
/*int atPb_SendCpbsSetReq(PSTR pAtCmdPara, int cid, PSTR pAtRst, int atRstSize)
{
    return zSvr_SendAtSyn(ZAT_CPBS_SET_CMD,"AT+CPBS=\"SM\"\r\n",cid,pAtRst,atRstSize);
}*/

/*ѯpbϢܴ洢ô洢Ϣ*/
/*int atPb_SendCpbsReadReq(PSTR pAtCmdPara, int cid, PSTR pAtRst, int atRstSize)
{
    return zSvr_SendAtSyn(ZAT_CPBS_READ_CMD,"AT+CPBS?\r\n",cid,pAtRst,atRstSize);
}*/

VOID atPb_RecvCpbsReadRsp(T_zPb_AtCpbsReadRes*  cpbsInd)
{
    CHAR                resInfo[20] = {0};

    if(strncmp(cpbsInd->locType,"SM",2) == 0)
    {
        (VOID)snprintf(resInfo, 20,"%d",cpbsInd->usedEntries);
        (VOID)sc_cfg_set(NV_PB_USEDENTRIES,resInfo);
        memset(resInfo, 0, 20);
        (VOID)snprintf(resInfo,20,"%d",cpbsInd->totalEntries);
        (VOID)sc_cfg_set(NV_PB_TOTALENTRIES,resInfo);
        g_zPb_SimIndex[0] = (UINT32)(cpbsInd->totalEntries);
    }
    else
    {//teet
        //atBase_SendMsgToSelf(ZAT_CPBS_SET_CMD, ZUFI_NULL, 0);
        printf("atPb_RecvCpbsReadRsp not SM:%s\n", cpbsInd->locType);
    }
}

/*ѯpbϢȵϢ*/
/*int atPb_SendScpbrTest(PSTR pAtCmdPara, int cid, PSTR pAtRst, int atRstSize)
{
    return zSvr_SendAtSyn(ZAT_SCPBR_TEST_CMD,"AT^SCPBR=?\r\n",cid,pAtRst,atRstSize);
}*/

static VOID atPb_SetScpbrResToNv(CHAR const*pbNvKeyWord, UINT32 len)
{
    char converted[10]   = {0};

    assert(pbNvKeyWord != ZUFI_NULL);
    (VOID)snprintf(converted,10, "%d", len);
    (VOID)sc_cfg_set(pbNvKeyWord, converted);
}

VOID atPb_ScpbrTestRsp(T_zPb_AtScpbrTestRes*  scpbsInd)
{
    T_zPb_UsimCapacity      pbPara  = {0};
    CHAR pbUsed[50]={0};
    sc_cfg_get(NV_PB_USEDENTRIES,pbUsed,sizeof(pbUsed));
	
    g_zPb_DelIndex          = (UINT32)scpbsInd->minIndex;
    pbPara.simType          = ZPB_USIM;
    pbPara.maxRecordNum     = scpbsInd->maxIndex;
    pbPara.usedRecordNum    = atoi(pbUsed);
    pbPara.maxNumberLen     = scpbsInd->maxNumberLen;
    pbPara.maxNameLen       = scpbsInd->maxTextLen;
    pbPara.maxAnrLen        = scpbsInd->maxNumberLen;
    pbPara.maxAnr1Len       = scpbsInd->maxNumberLen;
    pbPara.maxEmailLen      = scpbsInd->maxEmailLen;
    atPb_SetScpbrResToNv(ZPB_NV_USIMINDEXMIN, (UINT32)scpbsInd->minIndex);
    atPb_SetScpbrResToNv(ZPB_NV_USIMINDEXMAX, (UINT32)scpbsInd->maxIndex);

    /*simݿ*/
    (VOID)atPb_SetSimCapacityTable(pbPara);
}



/*ֶζζȡPB Ϣ*/
int atPb_SendScpbrSet_repeat(sem_t  tSemId)
{
    int min = 0;//klocwork
    int max = 0;
    int res = 0;
    int index = 0;
    CHAR pbMin[50]={0};
    CHAR pbMax[50]={0};
    int indexmin = 0;
    int indexmax = 0;
	T_zPb_ScpbrReadRes scpbrReadInfo = {0};
    
    sc_cfg_get(ZPB_NV_USIMINDEXMIN,pbMin,sizeof(pbMin));
    sc_cfg_get(ZPB_NV_USIMINDEXMAX,pbMax,sizeof(pbMax));

    (VOID)sc_cfg_set(ZPB_NV_INIT, ZPB_LOADING);

    //assert(strcmp(cfg_safe_get(ZPB_NV_USIMINDEXMIN),"0") != 0 && strcmp(cfg_safe_get(ZPB_NV_USIMINDEXMAX),"0") != 0);
    if(strcmp(pbMin,"0") == 0 || strcmp(pbMax,"0") == 0)
    {
        sc_cfg_set(ZPB_NV_INIT, ZPB_OPERATE_SUC);
        printf("atPb_SendScpbrSet card unsupport pb\n");
        return -1;
    }

    sscanf(pbMin, "%d", &min);
    sscanf(pbMax, "%d", &max);
	if ((min < 0 || min > INT_MAX-1) ||
		(max < 0 || max > INT_MAX-1)) { //kw 3
		printf("atPb_SendScpbrSet pb num err min:%d, max:%d\n", min, max);
		return -1;
	}

    while(1)
    {   
        if(indexmin < min)
        {
            indexmin = min;
            indexmax = min+ZPB_INIT_LOAD_RECORD_NUM-1;
            if(indexmax > max)
            {
                indexmax = max;
                break;
            }
            printf("[PB] 111 indexmin=%d, indexmax=%d,(%d-%d)\n",indexmin, indexmax, min, max);
        }
        else
        {
            indexmin = indexmin+ZPB_INIT_LOAD_RECORD_NUM;
            if(indexmin > max)
            {
                printf("[PB] 333 indexmin=%d, indexmax=%d,(%d-%d)\n",indexmin,indexmax,min,max);
                break;
            }
            indexmax = indexmax+ZPB_INIT_LOAD_RECORD_NUM;
            if(indexmax > max)
            {
                indexmax = max;
            }
            printf("[PB] 222 indexmin=%d, indexmax=%d,(%d-%d)\n",indexmin, indexmax,min,max);
        }
        
		scpbrReadInfo.minIndex = indexmin;
		scpbrReadInfo.maxIndex = indexmax;
		res = ipc_send_message(MODULE_ID_PB, MODULE_ID_AT_CTL, MSG_CMD_READ_PB_REQ, sizeof(T_zPb_ScpbrReadRes), &scpbrReadInfo, 0);
		sem_wait(&g_Pb_sem_id);
		if(g_PbOptRsp.result == -1)
		{
			break;
		}
    }

    return g_PbOptRsp.result; 
}
#if 0
/*һζȡPB Ϣ*/
int atPb_SendScpbrSet(PSTR pAtCmdPara, int cid, PSTR pAtRst, int atRstSize)
{
    UINT32 indexmin = 0;
    UINT32 indexmax = 0;
    CHAR atcmdMsg[70] = {0};
    int res = 0;
    CHAR pbMin[50]={0};
    CHAR pbMax[50]={0};
    sc_cfg_get(ZPB_NV_USIMINDEXMIN,pbMin,sizeof(pbMin));
    sc_cfg_get(ZPB_NV_USIMINDEXMAX,pbMax,sizeof(pbMax));

    (VOID)sc_cfg_set(ZPB_NV_INIT, ZPB_LOADING);

    //assert(strcmp(cfg_safe_get(ZPB_NV_USIMINDEXMIN),"0") != 0 && strcmp(cfg_safe_get(ZPB_NV_USIMINDEXMAX),"0") != 0);
    if(strcmp(pbMin,"0") == 0 || strcmp(pbMax,"0") == 0)
    {
        //sc_cfg_set(ZPB_NV_INIT, ZPB_OPERATE_SUC);
        printf("atPb_SendScpbrSet card unsupport pb\n");
        return ZAT_RESULT_OK;
    }
    
    sscanf(pbMin, "%d", &indexmin);
    sscanf(pbMax, "%d", &indexmax);
    (VOID)snprintf(atcmdMsg, sizeof(atcmdMsg), "AT^SCPBR=%d,%d\r\n", indexmin, indexmax);

    pthread_mutex_lock(&smsdb_mutex);
    res = zSvr_SendAtSyn(ZAT_SCPBR_SET_CMD,atcmdMsg,cid,pAtRst,atRstSize);
    pthread_mutex_unlock(&smsdb_mutex);
    return res; 
}
#endif
/*ԶȡPBΪUcs2*/
UINT8 atPb_EncodeText(CHAR *pbDst,CHAR const*pbTextSrc, UINT32 dstLen)
{
    UINT8   i                               = 0;
    CHAR    strTarget[ZPB_TEXT_SIZE_BYTES]    = {0};

    if(pbTextSrc != ZUFI_NULL)
    {
        if(strlen(pbTextSrc) *4 + ZPB_UCS2_PREFIX_LEN < dstLen)
        {
            snprintf((CHAR *)&strTarget[0], sizeof(strTarget),"%02X", ZPB_UCS2_PREFIX);
            for (i = 0; (i < strlen(pbTextSrc)) && (i * 4 + ZPB_UCS2_PREFIX_LEN < dstLen); i++ )
            {
                snprintf(strTarget + i * 4 + ZPB_UCS2_PREFIX_LEN, sizeof(strTarget)- i*4 -ZPB_UCS2_PREFIX_LEN,"00%02X", pbTextSrc[i] );
            }
            strncpy(pbDst, strTarget,dstLen-1);
            return ZUFI_SUCC;
        }
    }
    return ZUFI_FAIL;
}

/*ȡ绰¼ϱӦ*/
VOID atPb_ScpbrSetRsp(T_zPb_ScpbrSetRes* atRes)
{
    T_zPb_WebContact    pbRecord    = {0};
    CHAR	pbDst[ZPB_TEXT_SIZE_BYTES] = {0};
    CHAR	text[ZPB_TEXT_SIZE_BYTES]  = {0};
    int text_len = 0;
    int tmp_len = 0;
	CHAR	tmp[ZPB_TEXT_SIZE_BYTES]   = {0}; 
	
    if(atRes->coding != ZPB_UCS2)
    {
        if(atPb_EncodeText(pbDst, atRes->text, ZPB_TEXT_SIZE_BYTES) == ZUFI_SUCC)
        {
            strncpy(atRes->text,pbDst+2,sizeof(atRes->text)-1);//80
        }
        else
        {
            slog(PB_PRINT,SLOG_ERR, "pb:atPb_ScpbrSetRspencode err!.\n");
            return;
        }
    }
    else
    {
        text_len = atPb_String2Bytes(&atRes->text, &text, strlen(atRes->text));
        tmp_len = atPb_GetU80Code(&text, text_len, &tmp, ZPB_TEXT_SIZE_BYTES);
        if(tmp_len < 0) return;
        
        memset(&text, 0, ZPB_TEXT_SIZE_BYTES);
        text_len = atPb_Bytes2String(&tmp, &text, tmp_len);
		if (text_len > 2){
	        memset(&atRes->text, 0, ZPB_TEXT_SIZE_BYTES);	 
	        memcpy(&atRes->text, text+2, strlen(text)-2);
		}
    }
    pbRecord.pbId       = -1;
    pbRecord.pbIndex    = (SINT32)atRes->index;/*ת绰*/
    strncpy(pbRecord.name, atRes->text,sizeof(pbRecord.name)-1);
    strncpy(pbRecord.mobilNumber,atRes->number1,sizeof(pbRecord.mobilNumber)-1);
    strncpy(pbRecord.officeNumber,atRes->number2,sizeof(pbRecord.officeNumber)-1);
    strncpy(pbRecord.homeNumber,atRes->number3,sizeof(pbRecord.homeNumber)-1);
    strncpy(pbRecord.email,atRes->email,sizeof(pbRecord.email)-1);
    pbRecord.pbLocation=ZPB_LOCATION_USIM;
    (VOID)atPb_LoadARecToPbmTable(&pbRecord);
    //(VOID)system("adb push /etc_rw/config/pbm.db /usr/zte/zte_conf/config");
}

VOID atPb_SetDelStatusMultOrAll()
{
    if(g_zPb_DelStatusUsim.dealFailNum>0)
    {
        if(g_zPb_DelStatusUsim.dealSuccNum>0)
        {
            (VOID)sc_cfg_set(ZPB_NV_WRITE_FLAG, ZPB_MUL_DEL_PART_SUC);
        }
        else
        {
            (VOID)sc_cfg_set(ZPB_NV_WRITE_FLAG, ZPB_DEL_ERROR);
        }
    }
    else
    {
        (VOID)sc_cfg_set(ZPB_NV_WRITE_FLAG, ZPB_OPERATE_SUC);
    }
    //(VOID)system("adb push /etc_rw/config/pbm.db /usr/zte/zte_conf/config");
}

/*ɾһPbϢ*/
/*int atPb_SendScpbwDelReq(PSTR pAtCmdPara, int cid, PSTR pAtRst, int atRstSize)
{
    SINT32  pbIndex                     = 0;
    CHAR    atcmdMsg[70]   = {0};
   
    pbIndex = *((SINT32*)pAtCmdPara);
    (VOID)snprintf(atcmdMsg,sizeof(atcmdMsg),"AT^SCPBW=%d\r\n", pbIndex);
    return zSvr_SendAtSyn(ZAT_SCPBW_DEL_CMD,atcmdMsg,cid,pAtRst,atRstSize);
}*/
#if 0
/*ִ֧20ڴ*/
VOID atPb_RecvScpbwAddErr(UINT8 *pErrCode)
{
	(VOID)sc_cfg_set(ZPB_NV_WRITE_FLAG, ZPB_NEW_ERROR);
    if((strncmp(pErrCode, ZAT_ERRCODE_MEMORY_FULL, 2) == 0))
    {
        /*ʾWebҳ棬ɾһΪ"no"*/
        (VOID)sc_cfg_set(ZPB_NV_USIMMEMORYFULL, "yes");
        printf("pb:Recv CME ErrCode: 20.\n");
    }
    else
    {
        printf("pb:Recv At Scpbw add Err.\n");
    }

    //Ҫ֮ǰݿļ¼ɾ
    //atPb_DelRecordFromDBWhenAddErr();
}
#endif
VOID atPb_RecvScpbwModifyErr(UINT8 *pErrCode)
{
    (VOID)sc_cfg_set(ZPB_NV_WRITE_FLAG, ZPB_NEW_ERROR);
    printf("pb:Recv At Scpbw modify err.\n");    
}


/*****************************************************************************
*  ƣweb_AsctoHex
*  ˵ڽֽתɰֽڡ罫"8090ed"ת
             0x8090ed;"a4"ת0xa4
*  pcASC     ĿַĴŻ壻
             iDstLen   Ŀ껺ĳȣ
             pcHex     Դַ壻
             iSrcLen   Դַȱ
*  
*  ֵ  
****************************************************************************/
VOID pb_AsctoHex(UINT16 *pcHex, SINT32 iDstLen, UINT8 const *pcASC,SINT32 iSrcLen)
{
    UINT32  iOddOrEven  = 0;// 1ʾOdd,0ʾEven;
    UINT8   iTemp       = 0;
    SINT32  i           = 0;

    if((NULL    == pcHex )
       ||(NULL  == pcASC)
       ||(0     == iDstLen)
       ||(iDstLen < (iSrcLen/2 +1)))
    {
        return;
    }

    for(i=0; i<iSrcLen; i++)
    {
        if(iOddOrEven%2 == 0)
        {
            iTemp = *(pcASC + i);
            if((iTemp >='0')&& (iTemp <='9'))
            {
                *(pcHex + i/2) |= (UINT8)(iTemp -48) << 4;
            }
            else
            {
                *(pcHex + i/2) |= (UINT8)(iTemp -55) << 4;
            }
        }
        else
        {
            iTemp = *(pcASC + i);
            if((iTemp >='0')&& (iTemp <='9'))
            {
                *(pcHex + i/2) |= iTemp -48;
            }
            else
            {
                *(pcHex + i/2) |= iTemp -55;
            }
        }
        iOddOrEven++;
    }
}

/**********************************************************************
* ƣ IfaUcs2IsSMS7
*  жUcs2ַǷGsmű
* ʵı
* ޸ĵı 
*  psUcs2  UCS2봮 
             iLength UCS2ַȣַ 
*  
*   ֵ  0ûаڷűУ1ڷű
* ˵ 
* ޸        汾     ޸	  ޸
* -----------------------------------------------------------------------
*  2005/06/30     v1.0       yusong   
***********************************************************************/
SINT32 atPb_IfUcs2IsSMS7(UINT16 *psUcs2, SINT32 iLength)
{
    int iRetVal = 1;
    char cTemp;
	int i = 0;
	
    if(NULL == psUcs2 )
    {
        return -1;
    }
    for(i = 0; i<iLength; i++)
    {
        // Сڵ0x00ffUCS2Ĵ
        if (256 > psUcs2[i])
        {
            switch (psUcs2[i])
            {
                // ûаԶUcs2Gsm7תеַĴ
                case 0x0c://12
                case 0x5b://91
                case 0x5c://92
                case 0x5d://93
                case 0x5e://94
                case 0x7b://123
                case 0x7c://124
                case 0x7d://125
                case 0x7e://126
                case 0xa4://164
                case 0x20://ո
                {
                    break;
                }
                // ڱв鵽ĽΪZPB_NON_GSMGSM7
                default:
                {
                    cTemp = (char)G_ZPB_NEWUCS2TOGSM[psUcs2[i]];
                    if (ZPB_NON_GSM == cTemp)
                    {
                        iRetVal = 0;
                    }
                    break;
                }
            }
        }
        // 鷶ΧмֵGSM7
        else
        {
            switch (psUcs2[i])
            {
                case 0x0394:
                case 0x03a6:
                case 0x0393:
                case 0x039b:
                case 0x03a9:
                case 0x03a0:
                case 0x03c8:
                case 0x03a3:
                case 0x03b8:
                case 0x039e:
                {
                    break;
                }
                default:
                {
                    iRetVal = 0;
                    break;
                }
            }
        }
        if (0 == iRetVal)
        {
            break;
        }
    }
    return iRetVal;
}
static UINT8 atPb_EncodeNameToUcs2(char *pbDst, UINT32 iDstLen, char const *pbSrc)
{
    UINT16  acHex[256]  = {0};
    SINT32  srclen      = 0;
    SINT32  rest        = 0;
    assert(pbDst!= NULL && pbSrc != NULL);

    srclen = (SINT32)strlen(pbSrc);
    slog(PB_PRINT,SLOG_DEBUG,"pb:atPb_EncodeNameToUcs2 input psSrc=%s,iSrcLen=%d\n", pbSrc, srclen);
    pb_AsctoHex(acHex, 256, (UINT8 *)pbSrc, srclen);

    rest = atPb_IfUcs2IsSMS7(acHex, srclen/4);
    if(rest == 1)
    {
        return atPb_EncodeText(pbDst, pbSrc, iDstLen);
    }
    else if(rest == 0)
    {
        if(strlen(pbSrc) + 2 < iDstLen)
        {
            memcpy(pbDst, "80", 2);
            memcpy(pbDst + 2, pbSrc, srclen);
            return ZUFI_SUCC;
        }
    }
    return ZUFI_FAIL;
}


SINT32 atPb_FindIdleIndex(T_zPb_WebContact const *pbRecv, BOOL pbNewFlag)
{
    SINT32 count = 1;
    SINT32 total = 0;
    SINT32 *IndexType = NULL;

    if ((NULL == pbRecv))
    {
        slog(PB_PRINT,SLOG_ERR,"pb:find_pbm_index:the para of find_pbm_index are NULL\n");
        return -1;
    }

    if (TRUE == pbNewFlag)       //new a pbm record
    {
        if(ZPB_LOCATION_USIM == pbRecv->pbLocation)
        {
            total       = g_zPb_SimIndex[0];
            IndexType   = g_zPb_SimIndex;
        }
        else if(ZPB_LOCATION_AP== pbRecv->pbLocation)
        {
            total       = g_zPb_ApIndex[0];
            IndexType   = g_zPb_ApIndex;
        }

        for(; count<=total; count++)
        {
            if ((NULL != IndexType) && (IndexType[count] == PBM_ERROR_NOT_FOUND))
            {
                break;
            }
        }
        if (count > total)
        {
            slog(PB_PRINT,SLOG_ERR,"pb:find_pbm_index:can not find index_id,index_id=%d\n.",count);
            return -1;
        }
        slog(PB_PRINT,SLOG_DEBUG,"pb:find_pbm_index: index_id=%d, total is %d\n", count, total);
        return count;
    }
    else
    {
        /*modify a pbm record*/
        return pbRecv->pbIndex;
    }
}

BOOL atPb_GetASCII(CHAR *pSrc, CHAR *pDst, SINT32 len)
{	
    SINT32 j = 0;
    SINT32 i = 0;
    CHAR buf[ZPB_TEXT_SIZE_BYTES] = {0};
    CHAR str[3] = {0};
    SINT32  length = 0;
    
    length = atPb_String2Bytes(pSrc, buf, len);
    
    for(i = 0; i < length; i+=2)
    {
        if (buf[i] != 0 || buf[i+1] > 127)
        {
            return FALSE;
        }
        pDst[j++] = buf[i+1];
    }
    return TRUE;
}

VOID atWeb_AddOrModOnePbUsim(T_zPb_WebContact *pWebPbContact, BOOL pbNewFlag, sem_t semId)
{
	//CHAR errCode[ZSVR_AT_RES_CODE_LEN] = {0};	
	int atRes = 0;
    CHAR                pbName[ZPB_TEXT_SIZE_BYTES+3] = {0};
    CHAR   buf_src[ZPB_TEXT_SIZE_BYTES+3] = {0};
    CHAR   buf_dest[ZPB_TEXT_SIZE_BYTES+3] = {0};
    T_zPb_ScpbwParam    scpbwParam                  = {0};
    int len = 0;

    atPb_WebRecodeShow(pWebPbContact);

    //ȷAT
    if(atPb_GetASCII(pWebPbContact->name, pbName,strlen(pWebPbContact->name)))
    {
         scpbwParam.coding = 0;
    }
    else
    {
        len = atPb_String2Bytes(pWebPbContact->name,buf_src,strlen(pWebPbContact->name));
        len = atpb_CvtUcs2ToAlphaField(buf_src,len, buf_dest);
        atPb_Bytes2String(buf_dest,pbName, len);
        
        //sprintf((CHAR *)&pbName[0], "%02X", ZPB_UCS2_PREFIX);
        //strncat(pbName,pWebPbContact->name,ZPB_TEXT_SIZE_BYTES);
        scpbwParam.coding = 1;
    }
    /*webֻ룬ûд*/
    scpbwParam.pbIndex = pWebPbContact->pbIndex;
    strncpy(scpbwParam.name,pbName,sizeof(scpbwParam.name)-1); 
    strncpy(scpbwParam.mobilNumber,pWebPbContact->mobilNumber, sizeof(scpbwParam.mobilNumber)-1);
    strncpy(scpbwParam.officeNumber,pWebPbContact->officeNumber, sizeof(scpbwParam.officeNumber)-1);
    strncpy(scpbwParam.homeNumber,pWebPbContact->homeNumber,sizeof(scpbwParam.homeNumber)-1);
    strncpy(scpbwParam.email,pWebPbContact->email,sizeof(scpbwParam.email)-1);
    
	ipc_send_message(MODULE_ID_PB, MODULE_ID_AT_CTL, MSG_CMD_ADD_MODIFY_PB_REQ, sizeof(T_zPb_ScpbwParam), (unsigned char *)&scpbwParam, 0);
    sem_wait(&g_Pb_sem_id);
	if(g_PbOptRsp.result != 1)
	{
        /*ӵ绰*/
		(VOID)sc_cfg_set(ZPB_NV_WRITE_FLAG, ZPB_NEW_ERROR);
        if(TRUE == pbNewFlag)
        {
            //atPb_RecvScpbwAddErr(errCode);
            printf("pb:add Scpbw error.\n"); 
        }
        /*޸ĵ绰*/
        else
        {
            //atPb_RecvScpbwModifyErr(errCode);
            printf("pb:modify Scpbw error.\n");
        }
        return;
    }

    printf("pb:Send Scpbw ok.\n");    
    //g_zPb_pbIndex = 0;
    if(ZPB_DB_OK == atPb_WriteContactToPbmTable(pWebPbContact, pbNewFlag))
    {
        (VOID)sc_cfg_set(ZPB_NV_WRITE_FLAG, ZPB_OPERATE_SUC);
        printf("pb:WriteContactToPbmTable ok.\n");    
        //g_zPb_pbIndex = pWebPbContact->pbIndex;
    }
    else
    {
        (VOID)sc_cfg_set(ZPB_NV_WRITE_FLAG, ZPB_NEW_ERROR);
        printf("pb:WriteContactToPbmTable error.\n");    
    }
}

VOID atWeb_AddOnePb(T_zPb_WebContact*  webPbContact, sem_t semId)
{
    SINT32                 idleIndex       = 1;
    T_zPb_Header        pbHeader        = {0};
    BOOL                pbNewFlag       = FALSE;
    T_zPb_DelInfo delRecord = {0};
    CHAR ptFlag[20]={0};
    
    printf("[PB] atWeb_AddOnePb, pbId=%d!\n",webPbContact->pbId); 

    if(-1 == webPbContact->pbId)   /*new*/
    {
        slog(PB_PRINT,SLOG_DEBUG, "pb:atWeb_AddOnePb new.\n");
        pbNewFlag = TRUE;
        idleIndex = atPb_FindIdleIndex(webPbContact, pbNewFlag);
        printf("[PB] atWeb_AddOnePb idleIndex=%d.\n", idleIndex);

        if(idleIndex!= -1)
        {
            webPbContact->pbIndex = idleIndex;
        }
        else
        {
            (VOID)sc_cfg_set(ZPB_NV_WRITE_FLAG, ZPB_NEW_ERROR);
            printf("[PB] memory is full, can not add recode any more.\n");// (VOID)sc_cfg_set("memory","full");
            return;
        }
    }
    else   /*according to id to select index and location when modify a record*/
    {
        printf("[PB] atWeb_AddOnePb modify.\n");
        pbHeader.pbId = webPbContact->pbId;
        if(ZPB_DB_OK != atPb_GetIndexLocationById(&pbHeader))
        {
            (VOID)sc_cfg_set(ZPB_NV_WRITE_FLAG, ZPB_NEW_ERROR);
            return;
        }
        webPbContact->pbIndex    = pbHeader.pbIndex;
        webPbContact->pbLocation = pbHeader.pbLocation;
    }
    printf("[PB] atWeb_AddOnePb:location=%d\n",webPbContact->pbLocation);

    //豸
    if (ZPB_LOCATION_AP == webPbContact->pbLocation)
    {
        if(ZPB_DB_OK != atPb_WriteContactToPbmTable(webPbContact, pbNewFlag))
        {
            (VOID)sc_cfg_set(ZPB_NV_WRITE_FLAG, ZPB_NEW_ERROR);
        }
        else
        {
            (VOID)sc_cfg_set(ZPB_NV_WRITE_FLAG, ZPB_OPERATE_SUC);
        }
    }
    //
    else if (ZPB_LOCATION_USIM == webPbContact->pbLocation)
    {
        atWeb_AddOrModOnePbUsim(webPbContact, pbNewFlag, semId);
    }
    //
    else
    {
        printf("[PB] write_pbm_record:location is NULL\n");
        (VOID)sc_cfg_set(ZPB_NV_WRITE_FLAG, ZPB_LOCATION_IS_NULL);
    }
    printf("[PB] atWeb_AddOnePb del_id=%d.\n",webPbContact->del_id);

    //ɹɾ
    sc_cfg_get(ZPB_NV_WRITE_FLAG,ptFlag,sizeof(ptFlag));
    if(0 == strcmp("0",ptFlag) && -1 != webPbContact->del_id)
    {
        delRecord.delId[0] = webPbContact->del_id;
        atWeb_DelOnepb(&delRecord, semId);
    }
}


VOID atWeb_DelOnepb(T_zPb_DelInfo *delRecord, sem_t semId)
{
	CHAR errCode[ZSVR_AT_RES_CODE_LEN] = {0};	
	int atRes = 0;
    SINT32        delTime   = 0;

    /*Ҫɾpb¼IDλúֵ*/
    atPb_GetLocationIndexForDel(delRecord, delTime);
    printf("[PB] del_a_pbm_record--del index=%d,location=%d\n",delRecord->delIndex[0],delRecord->delLocation);

    if (ZPB_LOCATION_AP == delRecord->delLocation)
    {
        if(ZPB_DB_OK == atPb_DelARecFromPbmTable(delRecord, delTime))
        {
            (VOID)sc_cfg_set(ZPB_NV_WRITE_FLAG, ZPB_OPERATE_SUC);
            printf("[PB] atWeb_DelOnepb--del AP success\n");
            return;
        }
        slog(PB_PRINT,SLOG_DEBUG,"pb:del_a_pbm_record:remove rec from pbm table failed\n");/*lint  !e26*/
        (VOID)sc_cfg_set(ZPB_NV_WRITE_FLAG, ZPB_DEL_ERROR);
    }
    else if (ZPB_LOCATION_USIM == delRecord->delLocation)
    {
        CHAR pbMax[50]={0};
        sc_cfg_get(ZPB_NV_USIMINDEXMAX,pbMax,sizeof(pbMax));
        if((delRecord->delIndex[0]>=1)&&(delRecord->delIndex[0]<=atoi(pbMax)))/*ֵ*/
        {
            //g_zAt_AtActTab[ZAT_SCPBW_DEL_CMD].atBase_AtSendReq((PSTR)&delRecord->delIndex[0]);
            //atRes = atPb_SendScpbwDelReq((PSTR)&delRecord->delIndex[0],cid,errCode,ZSVR_AT_RES_CODE_LEN);
			ipc_send_message(MODULE_ID_PB, MODULE_ID_AT_CTL, MSG_CMD_DELETE_PB_REQ, sizeof(int), (unsigned char *)&delRecord->delIndex[0], 0);
			sem_wait(&g_Pb_sem_id);
			if(g_PbOptRsp.result != 1)			         
            {
                sc_cfg_set(ZPB_NV_WRITE_FLAG,ZPB_DEL_ERROR);
            }
            sc_cfg_set(ZPB_NV_USIMMEMORYFULL, "no");
        }
        
        if(ZPB_DB_OK == atPb_DelARecFromPbmTable(delRecord,delTime))
        {
            (VOID)sc_cfg_set(ZPB_NV_WRITE_FLAG,ZPB_OPERATE_SUC);
            printf("[PB] atWeb_DelOnepb--del SIM success\n");
            return;
        }
        (VOID)sc_cfg_set(ZPB_NV_WRITE_FLAG,ZPB_DEL_ERROR);
    }
    else
    {
        slog(PB_PRINT,SLOG_DEBUG,"pb:del_a_pbm_record:location is NULL\n");
        (VOID)sc_cfg_set(ZPB_NV_WRITE_FLAG, ZPB_LOCATION_IS_NULL);
    }
}

VOID atWeb_DelMultPb(T_zPb_DelInfo *delRecord, sem_t semId)
{
	CHAR errCode[ZSVR_AT_RES_CODE_LEN] = {0};	
	int atRes = 0;
    SINT32        delCount  = 0;

    (VOID)sc_cfg_set(NV_PHO_DEL,"");
    memset(&g_zPb_DelStatusUsim,0,sizeof(T_zPb_DelStatusMultiOrAll));
    g_zPb_DelStatusUsim.dealFlag = ZPB_DEL_MULTI_RECORD_USIM;
    for(; delCount < delRecord->delTotal; delCount++)
    {
        slog(PB_PRINT,SLOG_DEBUG,"pb3:delId[%d]=%d,del_pbm_index[%d]=%d\n",delCount,delRecord->delId[delCount],delCount, delRecord->delIndex[delCount] );
        atPb_GetLocationIndexForDel(delRecord,delCount);
        if (ZPB_LOCATION_AP == delRecord->delLocation)
        {
            if(ZPB_DB_OK != atPb_DelARecFromPbmTable(delRecord, delCount))
            {
                slog(PB_PRINT,SLOG_DEBUG,"pb:pbm:remove the i(%d) rec from pbm table failed\n", delCount);
                g_zPb_DelStatusUsim.dealFailNum++;
                continue;
            }
            g_zPb_DelStatusUsim.dealSuccNum++;
        }
        else if (ZPB_LOCATION_USIM == delRecord->delLocation)
        {
            CHAR pbMax[50]={0};
            sc_cfg_get(ZPB_NV_USIMINDEXMAX,pbMax,sizeof(pbMax));
            if((delRecord->delIndex[delCount]>=1)&&(delRecord->delIndex[delCount]<= atoi(pbMax)))/*ֵ*/
            {
                printf("pb9:atWeb_DelMultPb:remove the index(%d) rec from pbm table\n", delRecord->delIndex[delCount]);
                //atBase_SendMsgToSelf(ZAT_SCPBW_DEL_CMD,(PSTR)&delRecord->delIndex[delCount],10);//strlen(delRecord->delIndex[delCount]));
                //atRes = atPb_SendScpbwDelReq((PSTR)&delRecord->delIndex[delCount],cid,errCode,ZSVR_AT_RES_CODE_LEN);
				ipc_send_message(MODULE_ID_PB, MODULE_ID_AT_CTL, MSG_CMD_DELETE_PB_REQ, sizeof(int), (unsigned char *)&delRecord->delIndex[delCount], 0);
				sem_wait(&g_Pb_sem_id);
				if(g_PbOptRsp.result != 1)
                {
                    g_zPb_DelStatusUsim.dealFailNum++;
                    sc_cfg_set(ZPB_NV_WRITE_FLAG,ZPB_DEL_ERROR);
                }
                else
                {
                    g_zPb_DelStatusUsim.dealSuccNum++;
                    sc_cfg_set(ZPB_NV_USIMMEMORYFULL, "no");
                }
            }
            else
            {
                continue;
            }
            (VOID)atPb_DelSimRecFromPbTable(delRecord->delIndex[delCount]);
        }
        else
        {
            slog(PB_PRINT,SLOG_DEBUG,"pb:location is NULL\n");
            (VOID)sc_cfg_set(ZPB_NV_WRITE_FLAG, ZPB_LOCATION_IS_NULL);
        }
    }
    /*ɾϺNV*/
    atPb_SetDelStatusMultOrAll();
}

T_zPb_DbResult atPb_DelRecByGroup(VOID)
{
    T_zPb_DbResult  result  = ZPB_DB_OK;
    T_zPb_ApIndex   index   = {0};
    SINT32          i       = 1;

    result = atPb_DelRecFromPbmTableByGroup(&index);
    //(VOID)system("adb push /etc_rw/config/pbm.db /usr/zte/zte_conf/config");
    if(ZPB_DB_OK != result)
    {
        (VOID)sc_cfg_set(ZPB_NV_WRITE_FLAG, ZPB_DEL_ERROR);
        return result;
    }
    (VOID)sc_cfg_set(ZPB_NV_WRITE_FLAG, ZPB_OPERATE_SUC);

    for(i=1; i<=ZPB_AP_MAX_RECORD; i++)
    {
        if(0 != index.apIndex[i])
        {
            g_zPb_ApIndex[(index.apIndex[i])] = PBM_ERROR_NOT_FOUND;
        }
    }
    return result;
}
VOID atPb_DelAllRecsSimDb(VOID)
{
    CHAR            sql[ZPB_MAX_BYTES_DB]   = {0};
    snprintf(sql,sizeof(sql)-1,"delete from %s where Location=%d",ZPB_DB_PBM_TABLE, ZPB_LOCATION_USIM);
    if(ZPB_DB_OK == atPb_ExecDbSql(sql,NULL,NULL))
    {
        atPb_ClearSimPbmIndexArray(); 
        
        if(ZPB_DB_OK != atPb_ExecDbSql(ZTE_DROP_PBM_SIM_CAPABILITY_SQL,NULL,NULL))
        {
            printf("[PB] atPb_DelAllRecsSimDb execDb 2222 fail\n");
            (VOID)sc_cfg_set(ZPB_NV_WRITE_FLAG, ZPB_DEL_ERROR);
            return;
        }
        (VOID)sc_cfg_set(ZPB_NV_WRITE_FLAG, ZPB_OPERATE_SUC);
    }
    else
    {
        (VOID)sc_cfg_set(ZPB_NV_WRITE_FLAG, ZPB_DEL_ERROR);
    }
}
VOID atPb_DelAllRecsSim(T_zPb_DelInfo *pdelRecord, sem_t semId)
{
    CHAR errCode[ZSVR_AT_RES_CODE_LEN] = {0};	
    int atRes = 0;
    UINT32 i = 0;
    
    CHAR            sql[ZPB_MAX_BYTES_DB]   = {0};
    UINT32          count                   = 0;
    
    if (pdelRecord != NULL)
    {
        memset(&g_zPb_DelStatusUsim,0,sizeof(T_zPb_DelStatusMultiOrAll));
        g_zPb_DelStatusUsim.dealFlag =  ZPB_DEL_ALL_RECORD_USIM;
        snprintf(sql,sizeof(sql)-1,"select count(*) from %s where Location=%d",ZPB_DB_PBM_TABLE,ZPB_LOCATION_USIM);
        (VOID)atPb_ExecDbSql(sql,atPb_DbCountTableLineCb,&count);
        if(0 < count)
        {        
            CHAR pbMin[50]={0};
            CHAR pbMax[50]={0};
			UINT32 i_pbMin = 0;
            UINT32 i_pbMax = 0;
            sc_cfg_get(ZPB_NV_USIMINDEXMIN,pbMin,sizeof(pbMin));
            sc_cfg_get(ZPB_NV_USIMINDEXMAX,pbMax,sizeof(pbMax));
			//klocwork
			i_pbMin = atoi(pbMin);
			i_pbMax = atoi(pbMax);
			if (i_pbMin > ZPB_SIM_MAX_RECORD || i_pbMax > ZPB_SIM_MAX_RECORD) {
				printf("[PB] atPb_DelAllRecsSim sim index too large\n");
				return;
			}

			for(i = i_pbMin; i <= i_pbMax; i++)
            {
                //atRes = atPb_SendScpbwDelReq((PSTR)&i,cid,errCode,ZSVR_AT_RES_CODE_LEN);
				ipc_send_message(MODULE_ID_PB, MODULE_ID_AT_CTL, MSG_CMD_DELETE_PB_REQ, sizeof(int), (unsigned char *)&i, 0);
                sem_wait(&g_Pb_sem_id);
				if(g_PbOptRsp.result != 1)
                {
                    g_zPb_DelStatusUsim.dealFailNum++;
                    sc_cfg_set(ZPB_NV_WRITE_FLAG,ZPB_DEL_ERROR);
                }
                else
                {
                    g_zPb_DelStatusUsim.dealSuccNum++;
                    sc_cfg_set(ZPB_NV_USIMMEMORYFULL, "no");
                }
            }
            /*ɾ,ɾݿļ¼*/
            snprintf(sql,sizeof(sql)-1,"delete from %s where Location=%d",ZPB_DB_PBM_TABLE, ZPB_LOCATION_USIM);
            if(ZPB_DB_OK == atPb_ExecDbSql(sql,NULL,NULL))
            {
                (VOID)sc_cfg_set(ZPB_NV_WRITE_FLAG, ZPB_OPERATE_SUC);
                atPb_ClearSimPbmIndexArray(); 
            }
            else
            {
                (VOID)sc_cfg_set(ZPB_NV_WRITE_FLAG, ZPB_DEL_ERROR);
            }
            atPb_SetDelStatusMultOrAll();                                                                                             (VOID)sc_cfg_set(ZPB_NV_USIMMEMORYFULL, "no");
        }
    }
}

VOID atWeb_DelAllpb(T_zPb_DelInfo *delRecord, sem_t semId)
{
    printf("[PB] atWeb_DelAllpb delLocation=%d\n",delRecord->delLocation);
    if (ZPB_LOCATION_AP == delRecord->delLocation)
    {
        if(ZPB_DB_OK == atPb_DelAllRecsFromPbmTable(delRecord))
        {
            (VOID)sc_cfg_set(ZPB_NV_WRITE_FLAG, ZPB_OPERATE_SUC);
        }
        else
        {
            (VOID)sc_cfg_set(ZPB_NV_WRITE_FLAG, ZPB_DEL_ERROR);
        }
        //(VOID)system("adb push /etc_rw/config/pbm.db /usr/zte/zte_conf/config");
    }
    else if (ZPB_LOCATION_USIM == delRecord->delLocation)
    {
        atPb_DelAllRecsSim(delRecord, semId);
    }
    else if(ZPB_LOCATION_ALL == delRecord->delLocation)
    {
        delRecord->delLocation = ZPB_LOCATION_AP;
        (VOID)atPb_DelAllRecsFromPbmTable(delRecord);
        delRecord->delLocation = ZPB_LOCATION_USIM;
        atPb_DelAllRecsSim(delRecord, semId);
    }
    else if(ZPB_LOCATION_GROUP ==  delRecord->delLocation)
    {
        (VOID)atPb_DelRecByGroup();
    }
    else
    {
        printf("[PB] atWeb_DelAllpb location is NULL\n");
        (VOID)sc_cfg_set(ZPB_NV_WRITE_FLAG, ZPB_LOCATION_IS_NULL);
        return;
    }
}

