/**
* @file rtc-service.h
* @brief Public APIs of Sanechips
*
* Copyright (C) 2017 Sanechips Technology Co., Ltd.
* @author  Linxu Gebin
* @defgroup si_id Sanechips
*
* This program is free software; you can redistribute it and/or modify
* it under the terms of the GNU General Public License version 2 as
* published by the Free Software Foundation.
*************************************************************************
*/

#ifndef _RTC_SERVICE_H
#define _RTC_SERVICE_H


/*******************************************************************************
*							 Include header files							   *
******************************************************************************/
#include <stdlib.h>
#include <stdio.h>
#include <string.h>
#include <fcntl.h>
#include <signal.h>
#include <sys/time.h>
#include <pthread.h>
#include <errno.h>
#include <linux/rtc.h>
#include <sys/ioctl.h>
#include <unistd.h>
#include <sys/stat.h>
#include <sys/ioctl.h>
#include <sys/types.h>
#include <sys/ipc.h>
#include <sys/msg.h>
#include <stdarg.h> //for rtc_log variable para
#include <linux/prctl.h>
#include <sys/prctl.h>

#include "softap_api.h"
#include "message.h"
#include  "rtc_timer.h"
#include <linux/netlink.h>
#include <sys/socket.h>
/*******************************************************************************
 *                             Macro definitions                               *
 ******************************************************************************/
#define RTC_MSG_PARAM_SIZE 16
#define RTC_MSG_PARAM_MAC  16 //13  for align
#define RTC_ALARM_DATA		"/etc_rw/rtc_alarm.dat"
#define DATA_S   0xA5A5
#define DATA_E   0x5A5A
/*
    sleep  process
 1. rtc  no elapsed
 2. sta linked in
 3. no timer

    wps process
1. no timer can be used

xx xx  xx xx

*/
#ifdef __ZTE_UCLINUX__
#define   ROOT_DIR     "/mnt/jffs2"
#else
#define   ROOT_DIR     ""
#endif


#define MAX_ALARM_NUM 256

#define RTC_DEV_NAME "/dev/rtc0"
#define NV_STRING_LEN_20 20

#define WLAN_RTC_LOG1_FILE_PATH     ROOT_DIR"/wifi/rtclog1"
#define WLAN_RTC_LOG2_FILE_PATH     ROOT_DIR"/wifi/rtclog2"

#define WLAN_RTC_MAX_LOG_LENGTH   262144

#define _RTC_SERVICE_DEBUG 1
#define RTC_MSG_BUFFER_SIZE  2048
/*******************************************************************************
 *                             Type definitions                                *
 ******************************************************************************/
typedef enum {
	WF_SLEEP_SET_TIMER = 0x01,//  rtc-service add alarm ok
	WF_SLEEP_RTC_HW_SEND_ELAPSED = 0x02,
	WF_SLEEP_RTC_HANDLE_ELAPSED = 0x04,
	WF_SLEEP_RECEIVE_ELAPSED_MSG = 0x08,
	WF_SLEEP_HANDLE_SLEEP_MSG = 0x10,

	WF_WPS_SET_TIMER = 0x0100,//  rtc-service add alarm ok
	WF_WPS_RTC_HW_ELAPSED = 0x0200,
	WF_WPS_RTC_HANDLE_ELAPSED = 0x0400,
	WF_WPS_RECEIVE_ELAPSED_MSG = 0x0800,
	WF_WPS_HANDLE_SLEEP_MSG = 0x1000,

	WF_RTC_HW_SET_TIMER_OK = 0x00010000, //  rtc ioctl set timer ok
	WF_RTC_HW_SET_TIMER_FAILED = 0x00020000, //  rtc ioctl set timer failed
	WF_RTC_HW_HAVE_ELAPSED = 0x00040000,       //  rtc hw  elapsed normal
	WF_RTC_SERVICE_NO_FREE_TIMER = 0x00080000, // no enough free timer
	WF_HAVE_STA_LINKED_IN = 0x00100000,              // sta linked in


} wf_rtc_debug;

enum RTC_TYPE {
	RTC_TYPE_NONE = 0,
	RTC_TYPE_TIME,      // RTC_RD_TIME RTC_SET_TIME
	RTC_TYPE_ALM,       // RTC_ALM_READ RTC_ALM_SET
	RTC_TYPE_WKALM,     // RTC_WKALM_READ RTC_WKALM_SET
};

/* count down timer */
typedef enum {
	ZX234290_SET_TIMER = ('r' << 24 | 't' << 16 | 'c' << 8 | 0),
	ZX234290_GET_TIMER = ('r' << 24 | 't' << 16 | 'c' << 8 | 1),
	ZX234290_TIMER_ENABLED = ('r' << 24 | 't' << 16 | 'c' << 8 | 2),
	ZX234290_GET_TIMER_REMAIN = ('r' << 24 | 't' << 16 | 'c' << 8 | 3),
	ZX234290_GET_TIMER_STATUS = ('r' << 24 | 't' << 16 | 'c' << 8 | 4),
	ZX234290_FUNCTION_MAX = ('r' << 24 | 't' << 16 | 'c' << 8 | 5),
} zx234290_rtc_timer;

/**
* @brief ʱϢ
* @param list ͷ
* @param time_val ǰʱ䣬λ:s
* @param rtc_tm   ǰʱʱ
* @param interval  ʱ䣬λ:s
* @param remain_time  ʣʱ䣬λ:s
* @param rtc_id  ʱid
* @param module_id  ʱģid
* @param wakeup  ػѣ1:򿪣0:ر
* @param is_utc  Ƿutcʱ䣬utcʱȽϳWKALMʱ
* @param cpu  rtccpu 0: cp, 1:ap
* @note 
*/
/* count down timer */
typedef struct tag_ALARM {
	struct list_head list;
	long time_val;             
	struct rtc_time rtc_tm;    
	long interval;             
	long remain_time;          
	int rtc_id;
	int module_id;
	int wakeup;       
	int is_utc;       
	int cpu;        
} ALARM_T;

typedef enum _TIME_CONVERT_TYPE {
       CONVERT_TYPE_NONE = 0,      //ʼֵʱת
	CONVERT_TYPE_RTC,               //תΪutc0ʱ
	CONVERT_TYPE_OS                  //תΪʱʱ
} TIME_CONVERT_TYPE;
#endif
