/**************************************************************************
*
*                  Copyright (c) 2013 ZTE Corporation.
*
***************************************************************************
* ģ   : AT_SERVER
*    : SMS_fnc.c
* ļ : 
* ʵֹ : AtServerģsmsļ
*      : G.F
*      : V1.0
*  : 2013-09-29 
* ˵ : 
**************************************************************************/

/**************************************************************************
* ޸ļ¼:
***************************************************************************/
/**************************************************************************
* ޸ı : EC:617002775282, EC617002775301
*    :    chenjie10092374
* ޸ : 2014.5.30
* ޸ : (߲)޸ڴʴ
**************************************************************************/
/**************************************************************************
* ޸ı : ¹
*    : chenjie10092374
* ޸ : 2014.6.24
* ޸ : ֧ufi monitorܴ
**************************************************************************/
/**************************************************************************
* ޸ı : ¹
*    : chenjie10092374
* ޸ : 2014.08.07
* ޸ : MMIͶ״̬Ĵ
**************************************************************************/
/**************************************************************************
* #include
**************************************************************************/
#include <fcntl.h>
#include <stdio.h>
#include <sys/types.h>
#include <fcntl.h>
#include <sys/time.h>
#include <limits.h>
#include "sms_fnc.h"
#include "sms_db.h"
#include "sms_code.h"


/**************************************************************************
* 
**************************************************************************/
#define SMS_RETRY_COUNT 3
#define SHORT_INT_LEN 6

/* 괦 */


/**************************************************************************
* ݽṹ
**************************************************************************/

/**************************************************************************
* static
**************************************************************************/

/**************************************************************************
* ȫֱ
**************************************************************************/
//¼ŵĴ洢λ
SMS_LOCATION g_zUfiSms_CurLocation = SMS_LOCATION_SIM;

//οtpduеһֶΣ൱ڶŵID
int g_zUfiSms_ConcatSmsReference = 0;

/* ¼ǰһЩsms״̬ */
T_zUfiSms_ParaInfo g_zUfiSms_CurSmsPara = {"",WMS_STORAGE_TYPE_UIM_V01,ZTE_WMS_SMS_DEFAULT_TP_VALIDITY_PERIOD_GW,0,0,0,"nv"};

//¼ʽ֣ʱʹ
int g_zUfiSms_Language = NOT_DEFINE_LANGUAGE;
int g_zUfiSms_Dcs = 0;
unsigned long g_zUfiSms_StoreCapablity[ZTE_WMS_MEMORY_MAX] = {100,ZTE_WMS_DB_MSG_COUNT_MAX};

//Ҫ͸At
T_zSms_SendSmsReq g_zUfiSms_FinalCmgsBuf;

SMS_PARAM    g_zUfiSms_SendingSms;
UINT16 g_zUfiSms_IsLanguageShift = 0;

extern int g_zUfiSms_MsgRefer;
extern T_zUfiSms_DelSms g_zUfiSms_DelMsg;
extern T_zUfiSms_DelIndexInfo g_deleteIndex;
extern T_zUfiSms_ModifyIndexInfo g_modifyIndex;
extern T_zUfiSms_ModifySms g_zUfiSms_modifyMsg;
extern UINT8 g_zUfiSms_MemFullFlag[ZTE_WMS_MEMORY_MAX];
extern int g_zUfiSms_ConcatTotalNum;
extern T_zUfiSms_ConcatInfo g_zUfiSms_ConcatSms;
extern T_zUfiSms_GroupInfo g_zUfiSms_GroupSms; 
extern int g_zUfiSms_UnitLen;
extern UINT8 g_zUfiSms_IsConcatSendSuc;
extern int g_zUfiSms_SendFailedCount;

extern T_zUfiSms_DbStoreData g_zUfiSms_DbStoreData[ZTE_WMS_CONCAT_SMS_COUNT_MAX];
extern int g_zUfiSms_SendFailedRetry;
/**************************************************************************
* ʵ
**************************************************************************/

/************************************
        ڲܺ
************************************/
void zUfiSms_SetSmsLocation(SMS_LOCATION eLocation)
{   
    switch(eLocation)
    {
        case SMS_LOCATION_SIM:
        {   
            g_zUfiSms_CurLocation = SMS_LOCATION_SIM;       
            break;
        }
        case SMS_LOCATION_ME:
        {
            g_zUfiSms_CurLocation = SMS_LOCATION_ME;            
            break;
        }
    default:
        {
            return;
        }
    }
}



/* ȡptDelMsgиidĴ洢λãg_zUfiSms_DelMsg */
int zUfiSms_SetDeleteInfo(T_zUfiSms_DelReq *ptDelMsg)
{
    char acStorePos[50];
    int i = 0;

    g_zUfiSms_DelMsg.nv_count = 0;
    g_zUfiSms_DelMsg.nv_index = 0;
    g_zUfiSms_DelMsg.sim_count = 0;
    g_zUfiSms_DelMsg.sim_index = 0;
    for(i = 0; i < ptDelMsg->all_or_count; i++)
    {
        memset(acStorePos,0,sizeof(acStorePos));
        if(ZUFI_FAIL == zUfiSms_GetStorePosById("Mem_Store",acStorePos,sizeof(acStorePos),ptDelMsg->id[i]))
        {
            return ZUFI_FAIL;
        }
        
        if(0 == strcmp(acStorePos,ZTE_WMS_DB_NV_TABLE))/*nv sms*/
        {
            g_zUfiSms_DelMsg.nv_id[g_zUfiSms_DelMsg.nv_count] = ptDelMsg->id[i];
            g_zUfiSms_DelMsg.nv_count++;
            g_zUfiSms_DelMsg.nv_index_count++;
        }
        else if(0 == strcmp(acStorePos,ZTE_WMS_DB_SIM_TABLE))/*sim sms*/
        {
            g_zUfiSms_DelMsg.sim_id[g_zUfiSms_DelMsg.sim_count] = ptDelMsg->id[i];
            g_zUfiSms_DelMsg.sim_count++;
            g_zUfiSms_DelMsg.sim_index_count++;
        }
    }
    return ZUFI_SUCC;
}

void zUfiSms_ChangeMainState(T_zUfiSms_MainState iNewState)
{
    char *ptStrSmsState[] = 
    {  "sms_initing",
       "sms_inited",
       "sms_loading",   
       "sms_loaded",
       "sms_sending",
       "sms_sended",
       "sms_deling",
       "sms_deled",
       "sms_recving",
       "sms_recved",
       "sms_saving",
       "sms_saved",
       "sms_delsaving",
       "sms_delsaved",
       "sms_sim_loaded",
       "sms_setting",
       "sms_haveset",
       "sms_concatsending",
    };
    
    switch(iNewState)
    {
        case SMS_STATE_INITING:
        case SMS_STATE_INITED:  
        case SMS_STATE_LOADING: 
        case SMS_STATE_LOADED:
        case SMS_STATE_SIM_LOADED:
        case SMS_STATE_SENDING: 
        case SMS_STATE_SENDED:
        case SMS_STATE_DELING:
        case SMS_STATE_DELED:
        case SMS_STATE_RECVING:
        case SMS_STATE_RECVED:
        case SMS_STATE_DELSAVING:
        case SMS_STATE_DELSAVED:
        {
            break;
        }
        default:
        {
            return;
        }
    }
    

    sc_cfg_set(NV_SMS_STATE, ptStrSmsState[iNewState]);
    //simеĶţٰmeеĶżһ
  /*  if(SMS_STATE_SIM_LOADED == iNewState)
    {       
        zUfiSms_LoadSmsFromMe();
    }*/
}

int zUfiSms_CheckStoreDir(void)
{
    if (-1 == access(ZTE_WMS_DB_DIR,F_OK))
    {
        printf("[SMS] sms:%s does not exist,socreate it.\n",ZTE_WMS_DB_DIR);
        if (-1 == mkdir(ZTE_WMS_DB_DIR, 0777))
        {
            printf("[SMS] sms:failed to create db dir.\n");
            return ZUFI_FAIL;
        }
    }
    return ZUFI_SUCC;
}

int zUfiSms_CheckSmsDb(void)
{
    if (-1 == access(ZTE_WMS_DB_PATH,F_OK))
    {
        printf("[SMS] sms:%s does not exist,so get default config.\n",ZTE_WMS_DB_PATH);
        return ZUFI_FAIL;
    }
	printf("[SMS] ======%s exist.\n",ZTE_WMS_DB_PATH);
    return ZUFI_SUCC;
}

    


//    if(-1 == unlink(ZTE_WMS_DB_FLAG))//ɾļ

/**cfgлȡǰãg_zUfiSms_CurSmsPara */ 
void zUfiSms_GetDefaultCfgPara(void)
{
    unsigned char sts_flag = 0;
    unsigned char mem_store_flag = 0;
    unsigned int tp_validity_period = 0;
    char Temp_sms_vp[8] = {0};
    CHAR reportEnable[50]={0};
    CHAR smsLocation[50]={0};
    CHAR sendfailRetry[50]={0};
    CHAR outdateDelete[50]={0};
    CHAR defaultStore[50]={0};

    sc_cfg_get(NV_REPORT_ENABLE,reportEnable,sizeof(reportEnable));
    sc_cfg_get(NV_SMS_LOCATION_SET,smsLocation,sizeof(smsLocation));
    sc_cfg_get(NV_SENDFAIL_RETRY,sendfailRetry,sizeof(sendfailRetry));
    sc_cfg_get(NV_OUTDATE_DELETE,outdateDelete,sizeof(outdateDelete));
    sc_cfg_get(NV_DEFAULT_STORE,defaultStore,sizeof(defaultStore));

    if(0 == strcmp(reportEnable, "1"))
    {
         sts_flag = 1;
    }
    g_zUfiSms_CurSmsPara.status_report_on = sts_flag;

    if(0== strcmp(smsLocation, "ME"))
    {
        mem_store_flag = 0;
    }
    else
    {
        mem_store_flag = 1;
    }
    
    g_zUfiSms_CurSmsPara.mem_store = (unsigned int)(0 == mem_store_flag ? WMS_STORAGE_TYPE_NV_V01 : WMS_STORAGE_TYPE_UIM_V01);

    sc_cfg_get(NV_SMS_VP,Temp_sms_vp,sizeof(Temp_sms_vp));
    tp_validity_period  = 0xFF; 

    if( 0 == strncmp(Temp_sms_vp,"longest",7))
    {
        tp_validity_period  = 0xFF;
    }
    if(0 == strncmp(Temp_sms_vp,"one_day",7))
    {
        tp_validity_period  = 0xA7;
    }
    if(0 == strncmp(Temp_sms_vp,"oneweek",7))
    {
        tp_validity_period  = 0xAD;
    }
    if(0 == strncmp(Temp_sms_vp,"twelveh",7))
    {
        tp_validity_period  = 0x8F;
    }
    g_zUfiSms_CurSmsPara.tp_validity_period = tp_validity_period;

    if(0 == strcmp(sendfailRetry, "1"))
    {
         g_zUfiSms_CurSmsPara.sendfail_retry_on = 1;
    }
    else
    {
         g_zUfiSms_CurSmsPara.sendfail_retry_on = 0;		
    }
    if(0 == strcmp(outdateDelete, "1"))
    {
         g_zUfiSms_CurSmsPara.outdate_delete_on= 1;
    }
    else
    {
         g_zUfiSms_CurSmsPara.outdate_delete_on= 0;		
    }
    if(0 == strcmp(defaultStore, "sim"))
    {
         strncpy(g_zUfiSms_CurSmsPara.default_store,"sim",sizeof(g_zUfiSms_CurSmsPara.default_store)-1);
    }
    else
    {
         strncpy(g_zUfiSms_CurSmsPara.default_store,"nv",sizeof(g_zUfiSms_CurSmsPara.default_store)-1);	
    }
}

/*  *ȡĬϲ */
void zUfiSms_GetDefaultPara(void)
{
    memset(&g_zUfiSms_CurSmsPara,0,sizeof(T_zUfiSms_ParaInfo));

    g_zUfiSms_CurSmsPara.status_report_on = 0;
    g_zUfiSms_CurSmsPara.mem_store = WMS_STORAGE_TYPE_NV_V01;
    g_zUfiSms_CurSmsPara.tp_validity_period = ZTE_WMS_SMS_DEFAULT_TP_VALIDITY_PERIOD_GW;
    g_zUfiSms_CurSmsPara.sendfail_retry_on = 0;
    g_zUfiSms_CurSmsPara.outdate_delete_on = 0;
    strncpy(g_zUfiSms_CurSmsPara.default_store, "nv",sizeof(g_zUfiSms_CurSmsPara.default_store)-1);
}

#if 0
T_zUfiSms_CmdStatus zUfiSms_SetParameters(T_zUfiSms_CmdMsgBuff *ptSmsBuffer)
{
    T_zUfiSms_ParaInfo *ptSmsParameter = NULL;
    T_zUfiSms_ParaInfo tNewSmsParameter ={0};
    
    if(NULL == ptSmsBuffer)
    {
        return WMS_CMD_FAILED;
    }
    ptSmsParameter = (T_zUfiSms_ParaInfo*)(&(ptSmsBuffer->cmd_info.set_sms_para));

    memcpy((void*)&tNewSmsParameter,(void*)ptSmsParameter,sizeof(T_zUfiSms_ParaInfo));

#ifndef TSP_MODEL
    //ͨCPMSöŵĴ洢λ 
    if ((g_zUfiSms_CurSmsPara.mem_store != ptSmsParameter->mem_store)  )
    {
        if (ZUFI_SMS_FAILURE == zUfiSms_SetCpms(ptSmsParameter))
        {
            at_print(LOG_ERR,"set cfg routes failed.");
            return WMS_CMD_FAILED;
        }
    }
#endif

    if (strlen(ptSmsParameter->sca) != 0)
    {
        if (ZUFI_SMS_FAILURE == zUfiSms_SetCsca(ptSmsParameter))
        {
            return WMS_CMD_FAILED;
        }
    }

    /* ݿ */
    if(ZUFI_SMS_FAILURE == zUfiSms_SetDbParameters(ptSmsParameter))
    {
        return WMS_CMD_FAILED;
    }
    else 
    {
        sc_cfg_set("sms_center_num",ptSmsParameter->sca);
    }       

    memcpy((void*)&g_zUfiSms_CurSmsPara,(void*)&tNewSmsParameter,sizeof(T_zUfiSms_ParaInfo));
    return WMS_CMD_SUCCESS;
}
#endif


/***/
int zUfiSms_LoadSmsPara()
{
    int count = 0;
   if(ZUFI_SUCC != zUfiSms_IsDbEmpty(ZTE_WMS_DB_PARAMETER_TABLE, &count))
   {
       return ZUFI_FAIL;
   }
   
    if(count == 0)
    {
        // ݿΪգõNVлȡ
        zUfiSms_GetDefaultCfgPara();
        if(0 != zUfiSms_SetDbParameters(&g_zUfiSms_CurSmsPara))
        {
            return ZUFI_FAIL;
        }
    }
    else
    {
        printf("[SMS] have default parameter in database.\n");
        if(ZUFI_SUCC != zUfiSms_GetDbParameters())
        {
            return ZUFI_FAIL;
        }
        if(WMS_STORAGE_TYPE_NV_V01 != g_zUfiSms_CurSmsPara.mem_store &&
           WMS_STORAGE_TYPE_UIM_V01 != g_zUfiSms_CurSmsPara.mem_store)
        {
            //ѴڣǿʹĬֵ
            zUfiSms_GetDefaultPara();
            if(0 != zUfiSms_SetDbParameters(&g_zUfiSms_CurSmsPara))
            {
                printf("[SMS] set parameters fails 2.\n");
                return ZUFI_FAIL;
            }
        }
    }
	printf("[SMS] zUfiSms_LoadSmsPara succ.\n");
    return ZUFI_SUCC;
}

/*simnvǷ **/
int zUfiSms_CheckMemoryFull(T_zUfiSms_MemoryType mem_store)
{
    int total_count = 0;
    /* check sim WMS_STORAGE_TYPE_UIM_V01*/
    if ((ZTE_WMS_MEMORY_SIM == mem_store)||(ZTE_WMS_MEMORY_MAX == mem_store))
    {
        if(ZUFI_FAIL == zUfiSms_GetTotalCount(ZTE_WMS_DB_SIM_TABLE,&total_count))
        {
            printf("[SMS] sms:get table total count failed.\n");
            return ZUFI_FAIL;
        }
		printf("[SMS] zUfiSms_CheckMemoryFull get sim count:%d.\n",total_count);
        if(total_count >= (int)g_zUfiSms_StoreCapablity[WMS_STORAGE_TYPE_UIM_V01])
        {
            g_zUfiSms_MemFullFlag[WMS_STORAGE_TYPE_UIM_V01] = TRUE;
        }
        else
        {
            g_zUfiSms_MemFullFlag[WMS_STORAGE_TYPE_UIM_V01] = FALSE;
        }
    }
    /* check nv WMS_STORAGE_TYPE_NV_V01*/
    if((ZTE_WMS_MEMORY_NV == mem_store ) ||(ZTE_WMS_MEMORY_MAX == mem_store ))
    {
        if(ZUFI_FAIL == zUfiSms_GetTotalCount(ZTE_WMS_DB_NV_TABLE,&total_count))
        {
            printf("[SMS] sms:get table total count failed.\n");
            return ZUFI_FAIL;
        }
		printf("[SMS] zUfiSms_CheckMemoryFull get ME count:%d.\n",total_count);
        if(total_count >= (int)g_zUfiSms_StoreCapablity[WMS_STORAGE_TYPE_NV_V01])
        {
            g_zUfiSms_MemFullFlag[WMS_STORAGE_TYPE_NV_V01] = TRUE;
        }
        else
        {
            g_zUfiSms_MemFullFlag[WMS_STORAGE_TYPE_NV_V01] = FALSE;
        }
    }

    return ZUFI_SUCC;
}

int zUfiSms_SetStorePara(char *mem_store)
{
    if(0 == strcmp(mem_store,"SM"))
    {
        g_zUfiSms_CurSmsPara.mem_store = (unsigned int)WMS_STORAGE_TYPE_UIM_V01;  
        (void)sc_cfg_set(NV_SMS_LOCATION_SET, "0");
    }
    else if(0 == strcmp(mem_store,"ME"))
    {
        g_zUfiSms_CurSmsPara.mem_store = (unsigned int)WMS_STORAGE_TYPE_NV_V01;  
        (void)sc_cfg_set(NV_SMS_LOCATION_SET, "1");
    }  
    else if(0 == strcmp(mem_store,"SR"))
    {
        g_zUfiSms_CurSmsPara.mem_store = (unsigned int)2;  
        (void)sc_cfg_set(NV_SMS_LOCATION_SET, "2");  // SR
    }  
    else
    {
        g_zUfiSms_CurSmsPara.mem_store = (unsigned int)WMS_STORAGE_TYPE_NONE_V01;  
        (void)sc_cfg_set(NV_SMS_LOCATION_SET, "-1");
    }  

    if(ZUFI_FAIL == zUfiSms_SetDbParameters(&g_zUfiSms_CurSmsPara))
    {
        at_print(LOG_ERR,"can not set parameters.\n");
        return ZUFI_FAIL;
    }
    return ZUFI_SUCC;

}
int zUfiSms_SetScaPara(char *sca)
{
    strncpy(g_zUfiSms_CurSmsPara.sca,sca,sizeof(g_zUfiSms_CurSmsPara.sca)-1);

    if(ZUFI_FAIL == zUfiSms_SetDbParameters(&g_zUfiSms_CurSmsPara))
    {
        at_print(LOG_ERR,"can not set parameters.\n");
        return ZUFI_FAIL;
    }
    return ZUFI_SUCC;

}

/* ݱ뷽ʽȫ 
 cDcs 1-->ASCII, 2-->UNICODE, 3-->GSM7 SPANISH, 4-->GSM7 DEFAULT, 5-->GSM7 PORTUGUESE */
void zUfiSms_SetGlobalDcsLang(unsigned char cDcs)
{
    if (cDcs == 1)
    {
        g_zUfiSms_Dcs = DCS_ASC;
        g_zUfiSms_Language = NOT_DEFINE_LANGUAGE;
    }
    else if (cDcs == 2)
    {
        g_zUfiSms_Dcs = DCS_USC;
        g_zUfiSms_Language = NOT_DEFINE_LANGUAGE ;
    }
    else if (cDcs == 3)
    {
        g_zUfiSms_Dcs =  DCS_ASC;
        g_zUfiSms_Language = DCS_GSM7_SPANISH;
    }
    else if (cDcs == 5)
    {
        g_zUfiSms_Dcs =  DCS_ASC;
        g_zUfiSms_Language = DCS_GSM7_PORTUGUESE;
    }
    else
    {
        g_zUfiSms_Dcs =  DCS_ASC;
        g_zUfiSms_Language = DCS_GSM7_DEFAULT;
    }
}

/* ҪȺŵĺ͸룬group_sms */
int zUfiSms_FillGroupSms(T_zUfiSms_SendReq *ptSendMsg, T_zUfiSms_GroupInfo *ptGroupSms)
{
    int i;

    if(NULL == ptSendMsg || NULL == ptGroupSms || ZTE_WMS_SEND_NUM_MAX < ptSendMsg->receiver_count)
    {
        return ZUFI_FAIL;
    }

    ptGroupSms->total_receiver = ptSendMsg->receiver_count;
    for(i = 0; i < ptGroupSms->total_receiver; i++)
    {
        strncpy(ptGroupSms->receivers[i],ptSendMsg->dest_num[i],ZTE_WMS_ADDRESS_LEN_MAX);
        printf("[SMS] zUfiSms_FillGroupSms receivers[%d]=%s\n",i,ptGroupSms->receivers[i]);
    }
    ptGroupSms->current_receiver = 0;

    return ZUFI_SUCC;
}

/* pSendSrcMsgֳɼpDestConcatMsg,ܳ */
int zUfiSms_FillConcatSms (T_zUfiSms_SendReq *pSendSrcMsg, T_zUfiSms_ConcatInfo *pDestConcatMsg )
{
    int iTotalLen = 0; 
    int iUnitlen = 0;  
    int iSegNo = 0; 
    unsigned char *pSmsConverted = NULL;  //ָҪַ
    unsigned char  acConvertContent[ZTE_WMS_SMS_MSG_CONTENT_LEN_MAX * ZTE_WMS_CONCAT_SMS_COUNT_MAX *4+4]={0};
    unsigned char  acTmpContent[ZTE_WMS_SMS_MSG_CONTENT_LEN_MAX * ZTE_WMS_CONCAT_SMS_COUNT_MAX *4+4]={0};
    int iTimeZone = 0;
	int tmp_i = 0;

    if(NULL == pSendSrcMsg || NULL == pDestConcatMsg)
    {
        return -1;
    }

    // ݿлȡҪ͵ĶacTmpContentתacConvertContent
    iTotalLen = pSendSrcMsg->msg_len;
    if(ZUFI_FAIL == zUfiSms_GetSmsContent(acTmpContent,sizeof(acTmpContent)))
    {
    	printf("[SMS] zUfiSms_GetSmsContent Fail.\n");
        return -1;
    }
	printf("[SMS] zUfiSms_GetSmsContent:%s.\n",acTmpContent);
    (void)String2Bytes(acTmpContent, acConvertContent, (int)strlen(acTmpContent));

    //ת,
    memset(acTmpContent,0,sizeof(acTmpContent));
    if (DCS_USC == g_zUfiSms_Dcs)
    {
        // Ҫת
        pSmsConverted = acConvertContent;   
    }
    else  
    {
        // ascʽҪཫacConvertContentٴתacTmpContentͬ
        if(NOT_DEFINE_LANGUAGE == g_zUfiSms_Language)
        {
            iTotalLen = zUfiSms_ConvertAsciiToGsmDefault(acConvertContent,acTmpContent,pSendSrcMsg->msg_len);
     
        }
        else if(DCS_GSM7_SPANISH == g_zUfiSms_Language)
        {
            iTotalLen = zUfiSms_ConvertUcs2ToSpanish(acConvertContent,acTmpContent,pSendSrcMsg->msg_len);
        }
        else if(DCS_GSM7_PORTUGUESE == g_zUfiSms_Language)
        {
            iTotalLen = zUfiSms_ConvertUcs2ToPortuguese(acConvertContent,acTmpContent,pSendSrcMsg->msg_len);
        }
        else
        {           
            iTotalLen = zUfiSms_ConvertUcs2ToGsmDefault(acConvertContent,acTmpContent,pSendSrcMsg->msg_len);        
        }               
        pSendSrcMsg->msg_len = iTotalLen;
        pSmsConverted = acTmpContent;       
    }


    // öճ
    if(iTotalLen > (sizeof(acConvertContent) - 1))
    {
        iTotalLen = sizeof(acConvertContent) - 1;
    }
    pDestConcatMsg->sms_len = iTotalLen;

    // 㳤ŵĵλֶγ
    if ((iTotalLen > ZTE_WMS_SMS_MSG_CONTENT_LEN_MAX)||
        (g_zUfiSms_Language == DCS_PORTUGUESE && iTotalLen > 155)||
        ((g_zUfiSms_Dcs == DCS_USC) && iTotalLen > ZTE_WMS_SMS_MSG_CHAR_MAX))
    {
    	printf("[SMS] =====send contact sms.\n");
		
        if(g_zUfiSms_Dcs == DCS_USC)
        {
            iUnitlen = ZTE_WMS_SMS_CONCAT_ELEMNT_UCS_LEN * 2;
        }
        else //if(g_zUfiSms_Dcs == DCS_ASC)
        {
            if(g_zUfiSms_Language == NOT_DEFINE_LANGUAGE || g_zUfiSms_Language ==  DCS_GSM7_DEFAULT)
            {
                iUnitlen = ZTE_WMS_SMS_CONCAT_ELEMNT_ASC_LEN;
            }
            else
            {
                iUnitlen = ZTE_WMS_SMS_CONCAT_ELEMNT_LANGUAGE_LEN;
            }
        }
        //iUnitlenʼзֶ
        while (iTotalLen > 0 && iSegNo < ZTE_WMS_CONCAT_SMS_COUNT_MAX)
        {
        	//cov m
            memcpy(pDestConcatMsg->msg_contents[iSegNo], pSmsConverted, iUnitlen);
           
            iTotalLen -= iUnitlen;
            pSmsConverted += iUnitlen;
            iSegNo++;
        }
        pDestConcatMsg->total_msg = iSegNo;
    }
    else
    {
        // ̶
        iUnitlen = iTotalLen;
        pDestConcatMsg->total_msg = 1;
        memcpy(pDestConcatMsg->msg_contents[0], pSmsConverted, iTotalLen);
		printf("[SMS] =====send normal sms.len:%d.content:%s.\n",iUnitlen,pDestConcatMsg->msg_contents[0]);
    }

    g_zUfiSms_ConcatTotalNum = pDestConcatMsg->total_msg;
    pDestConcatMsg->current_sending = 0;

    // öŷʱ
    memcpy(&(pDestConcatMsg->date),&(pSendSrcMsg->date),sizeof(T_zUfiSms_Date));
	tmp_i = atoi(pDestConcatMsg->date.timezone);
	if(tmp_i < INT_MIN+1 || tmp_i > INT_MAX-1) { //kw 3
		printf("unknown pDestConcatMsg timezone:%d.\n", tmp_i);
		return ZUFI_FAIL;
	}
	iTimeZone = tmp_i * 4;

    memset(pDestConcatMsg->date.timezone,0,sizeof(pDestConcatMsg->date.timezone));
    if(iTimeZone > 0)
    {
        snprintf(pDestConcatMsg->date.timezone,sizeof(pDestConcatMsg->date.timezone),"+%d",iTimeZone);
    }
    else
    {
        snprintf(pDestConcatMsg->date.timezone,sizeof(pDestConcatMsg->date.timezone),"%d",iTimeZone);
    }

    pSmsConverted = NULL;
    return iUnitlen;
}

void zUfiSms_FillDateheader
(
    T_zUfiSms_SubmitTpdu *ptSubmit,
    T_zUfiSms_ConcatInfo *ptConcatSms,
    T_zUfiSms_DbStoreData *ptDbSaveData
)
{
    unsigned char iHeaderNum = 0;

    iHeaderNum = ptSubmit->user_data.num_headers;
    ptSubmit->user_data_header_present = TRUE;
    // ¼ msg_ref
    if (0 == ptConcatSms->current_sending)
    {
        g_zUfiSms_ConcatSmsReference++;
        (void)zUfiSms_SetConcatMaxRefer(g_zUfiSms_ConcatSmsReference);
    }

    // дUD
    ptSubmit->user_data.headers[iHeaderNum].header_id = WMS_UDH_CONCAT_8;
    ptSubmit->user_data.headers[iHeaderNum].u.concat_8.total_sm = ptConcatSms->total_msg;
    ptSubmit->user_data.headers[iHeaderNum].u.concat_8.seq_num = ptConcatSms->current_sending + 1;
    ptSubmit->user_data.headers[iHeaderNum].u.concat_8.msg_ref = g_zUfiSms_ConcatSmsReference % 0xff;
    ptSubmit->user_data.num_headers++;

    ptDbSaveData->concat_sms = 1;
    ptDbSaveData->concat_info[0] = g_zUfiSms_ConcatSmsReference;
}

//ŷݴg_zUfiSms_SendingSmsдg_zUfiSms_FinalCmgsBuf
int zUfiSms_MakeFinalCmgsBuf()
{    
    SMS_PARAM    tSmsData;
    int iPduLength = 0;
    int nSmscLength = 0;
    char Tempstrr[2] = {0}; 
    char Temp_sms_vp[8] = {0};  
    char tmpBuf1[3]={0};
    char tmpBuf2[6]={0};//klocwork
    CHAR smsCenter[50]={0};
        
    memset(&tSmsData, 0, sizeof(SMS_PARAM));   
    memset(&g_zUfiSms_FinalCmgsBuf, 0, sizeof(T_zSms_SendSmsReq));

    //TPUD
    if (CODE_GSM7 == g_zUfiSms_SendingSms.TP_DCS) 
    {
        int i = 0;
        for(; i < g_zUfiSms_SendingSms.TP_UDLength; i++)
        {
            tSmsData.TP_UD[i] = g_zUfiSms_SendingSms.TP_UD[i] ;
        }
        tSmsData.TP_UDLength = g_zUfiSms_SendingSms.TP_UDLength;
    }
    else 
    {
        //ԭʼ
        snprintf(tSmsData.TP_UD,sizeof(tSmsData.TP_UD),"%s", g_zUfiSms_SendingSms.TP_UD);
        tSmsData.TP_UDLength = strlen(tSmsData.TP_UD);

    }

    /*ĺĿ*/
    sc_cfg_get(NV_SMS_CENTER_NUM,smsCenter,sizeof(smsCenter));
    snprintf(tSmsData.SCA, sizeof(tSmsData.SCA),"%s", smsCenter);
    snprintf(tSmsData.TPA, sizeof(tSmsData.TPA),"%s", g_zUfiSms_SendingSms.TPA);    
    tSmsData.TP_DCS = g_zUfiSms_SendingSms.TP_DCS;  

    sc_cfg_get(NV_REPORT_ENABLE,Tempstrr,sizeof(Tempstrr));
    if((0 == strncmp(Tempstrr,"1",1)) && (g_zUfiSms_ConcatSms.current_sending == g_zUfiSms_ConcatSms.total_msg-1))
    {
        // Ҫ״̬
        tSmsData.TP_SRR = 1;
    }
    else
    {
        tSmsData.TP_SRR = 0;
    }
    tSmsData.TP_UDHI= g_zUfiSms_SendingSms.TP_UDHI;
    tSmsData.TP_VP  = 0xFF;
    
    //ڶϢĵĴ洢ʱ
    sc_cfg_get(NV_SMS_VP,Temp_sms_vp,sizeof(Temp_sms_vp));
    if( 0 == strncmp(Temp_sms_vp,"longest",7))
    {
        tSmsData.TP_VP  = 0xFF;
    }
    else if(0 == strncmp(Temp_sms_vp,"one_day",7))
    {
        tSmsData.TP_VP  = 0xA7;
    }
    else if(0 == strncmp(Temp_sms_vp,"oneweek",7))
    {
        tSmsData.TP_VP  = 0xAD;
    }
    else if(0 == strncmp(Temp_sms_vp,"twelveh",7))
    {
        tSmsData.TP_VP  = 0x8F;
    }
    
    tSmsData.TP_PID = 0;

	#if 1//corem for debug
    printf("[SMScorem]begin:%s\n",g_zUfiSms_FinalCmgsBuf.pdu);
	#endif    // tSmsData g_zUfiSms_FinalCmgsBuf.pdu
    iPduLength = EncodePdu_Submit(&tSmsData, g_zUfiSms_FinalCmgsBuf.pdu);    /**/
	#if 1//corem for debug
	printf("[SMScorem] zUfiSms_MakeFinalCmgsBuf make pdu data\n");
    printf("[SMScorem]%s\n",g_zUfiSms_FinalCmgsBuf.pdu);
	#endif
	//!!!!!!!!˵ãȻû⣬
    (void)String2Bytes(g_zUfiSms_FinalCmgsBuf.pdu, tmpBuf1, 2);
    Bytes2String(tmpBuf1, tmpBuf2, strlen(tmpBuf1));
    nSmscLength = atoi(tmpBuf2);
	if(nSmscLength < 0 || nSmscLength > INT_MAX-1) { //kw 3
		at_print(LOG_ERR,"[SMS]nSmscLength err:%d\n", nSmscLength);
		nSmscLength = 0;;
	}
    nSmscLength++;
    g_zUfiSms_FinalCmgsBuf.length = iPduLength / 2 - nSmscLength;
	#if 1//corem for debug
	printf("[SMScorem] zUfiSms_MakeFinalCmgsBuf make end pdu data\n");
    printf("[SMScorem]len:%d, %s\n",g_zUfiSms_FinalCmgsBuf.length, g_zUfiSms_FinalCmgsBuf.pdu);
	#endif
    return ZUFI_SUCC;
}

/* ptConcatSmsptGroupSmsptSubmitֶ,g_SMS_Sending_SmsptDbSaveData */
int zUfiSms_FillSubmitTpdu(
    T_zUfiSms_ConcatInfo *ptConcatSms,
    T_zUfiSms_GroupInfo *ptGroupSms,
    int iSmsLen,
    T_zUfiSms_SubmitTpdu *ptSubmit,
    T_zUfiSms_DbStoreData *ptDbSaveData
)
{
    if(NULL == ptSubmit || NULL == ptConcatSms || NULL == ptGroupSms || NULL == ptDbSaveData)
    {
        return -1;
    }
    ptSubmit->reject_duplicates = FALSE;
    ptSubmit->reply_path_present = FALSE;
    ptSubmit->user_data_header_present = FALSE;
    //Ƿ״̬
    ptSubmit->status_report_enabled = g_zUfiSms_CurSmsPara.status_report_on;

     /* ţֻзһʱ״̬ */
    if((1 < ptConcatSms->total_msg) && (ptConcatSms->current_sending + 1 < ptConcatSms->total_msg))
    {
        ptSubmit->status_report_enabled = 0;
    }
    
    ptSubmit->message_reference = g_zUfiSms_MsgRefer;
    ptSubmit->pid = WMS_PID_DEFAULT;
    ptSubmit->dcs.msg_class = (wms_message_class_e_type)4;
    ptSubmit->dcs.is_compressed = 0;
    ptSubmit->dcs.alphabet = (g_zUfiSms_Dcs == DCS_ASC)? WMS_GW_ALPHABET_7_BIT_DEFAULT : WMS_GW_ALPHABET_UCS2;
    ptSubmit->validity.format = WMS_GW_VALIDITY_RELATIVE;

    // ǰʱдptSubmitʱ
    zUfiSms_DecodeRelativeTime(g_zUfiSms_CurSmsPara.tp_validity_period, &ptSubmit->validity.u.time);
    ptSubmit->user_data.num_headers = 0;

    //伶ŵͷ¼
    if (ptConcatSms->total_msg > 1)
    {
        zUfiSms_FillDateheader(ptSubmit,ptConcatSms,ptDbSaveData);
        ptDbSaveData->concat_info[2] = ptConcatSms->current_sending + 1;
        ptDbSaveData->concat_info[1] = ptConcatSms->total_msg;
    }
    
    // Ҫһheader˵
    if (g_zUfiSms_Language == DCS_PORTUGUESE)
    {
        UINT8 i = ptSubmit->user_data.num_headers;
        ptSubmit->user_data_header_present = TRUE;
        ptSubmit->user_data.headers[i].header_id = WMS_UDH_NAT_LANG_SS;

        ptSubmit->user_data.headers[ptSubmit->user_data.num_headers].u.nat_lang_ss.nat_lang_id
            = WMS_UDH_NAT_LANG_PORTUGUESE;
        ptSubmit->user_data.num_headers++;
        g_zUfiSms_IsLanguageShift = WMS_UDH_NAT_LANG_SS;
    }

    // ǰ͵Ķsegݴsubmit
    ptSubmit->user_data.sm_len = iSmsLen;
    memcpy(ptSubmit->user_data.sm_data,ptConcatSms->msg_contents[ptConcatSms->current_sending], iSmsLen);

    //Žߵĺͳ,ȥ+00
    if (ptGroupSms->receivers[ptGroupSms->current_receiver][0] == '+')
    {
        (void)zUfiSms_CharToInt(ptGroupSms->receivers[ptGroupSms->current_receiver] + 1,
                               strlen(ptGroupSms->receivers[ptGroupSms->current_receiver]) - 1, ptSubmit->address.digits);
        ptSubmit->address.number_type = WMS_NUMBER_INTERNATIONAL;
        ptSubmit->address.number_of_digits = strlen(ptGroupSms->receivers[ptGroupSms->current_receiver]) - 1;
    }
    else  if (ptGroupSms->receivers[ptGroupSms->current_receiver][0] == '0' &&ptGroupSms->receivers[ptGroupSms->current_receiver][1] == '0')
    {
        (void)zUfiSms_CharToInt(ptGroupSms->receivers[ptGroupSms->current_receiver] + 2,
                                     strlen(ptGroupSms->receivers[ptGroupSms->current_receiver]) - 2, ptSubmit->address.digits);
        ptSubmit->address.number_type = WMS_NUMBER_INTERNATIONAL;
        ptSubmit->address.number_of_digits = strlen(ptGroupSms->receivers[ptGroupSms->current_receiver]) - 2;
    }
    else
    {
        (void)zUfiSms_CharToInt(ptGroupSms->receivers[ptGroupSms->current_receiver], strlen(ptGroupSms->receivers[ptGroupSms->current_receiver]), ptSubmit->address.digits);
        ptSubmit->address.number_type = WMS_NUMBER_UNKNOWN;
        ptSubmit->address.number_of_digits = strlen(ptGroupSms->receivers[ptGroupSms->current_receiver]);
    }
    ptSubmit->address.digit_mode = (wms_digit_mode_e_type)0;
    ptSubmit->address.number_mode = (wms_number_mode_e_type)0;
    ptSubmit->address.number_plan = WMS_NUMBER_PLAN_TELEPHONY;//93d Ϊֹ 
   memset(&g_zUfiSms_SendingSms,0, sizeof(SMS_PARAM));
    //õǰŵĽ
    snprintf(g_zUfiSms_SendingSms.TPA, sizeof(g_zUfiSms_SendingSms.TPA),"%s", ptGroupSms->receivers[ptGroupSms->current_receiver]);

    //ͳͳдg_zUfiSms_SendingSmsȥ
    if(g_zUfiSms_Language != NOT_DEFINE_LANGUAGE)
    {
        g_zUfiSms_SendingSms.TP_DCS = CODE_GSM7;
    }
    else
    {
        if(g_zUfiSms_Dcs == DCS_USC)
        {
            g_zUfiSms_SendingSms.TP_DCS = CODE_UCS2;
        }
        else
        {
            g_zUfiSms_SendingSms.TP_DCS = CODE_GSM8;
        }
    }
    if(g_zUfiSms_SendingSms.TP_DCS == CODE_GSM7)
    {
        zUfiSms_FillGlobalTpudGsm7(ptSubmit,ptConcatSms,ptDbSaveData);
    }
    else 
    {
        zUfiSms_FillGlobalTpudUcs2(ptSubmit,ptConcatSms,ptDbSaveData);
    }
    
    //նݴg_zUfiSms_FinalCmgsBuf
    (void)zUfiSms_MakeFinalCmgsBuf();
	return ZUFI_SUCC;
}

// ö
void zUfiSms_FillSca(T_zUfiSms_ClientMsg *ptClientMsg)
{
    char sca[ZTE_WMS_SCA_LEN_MAX] = {0};
    int i = 0;

    if(NULL == ptClientMsg)
    {
        return ;
    }
    
    memcpy((void*)sca,(void*)(g_zUfiSms_CurSmsPara.sca),sizeof(g_zUfiSms_CurSmsPara.sca));
    // ʺ
    if (sca[0] == '+')
    {
        ptClientMsg->u.gw_message.sc_address.number_type = WMS_NUMBER_INTERNATIONAL;
    }

    ptClientMsg->u.gw_message.sc_address.digit_mode = WMS_DIGIT_MODE_8_BIT;
    ptClientMsg->u.gw_message.sc_address.number_plan = WMS_NUMBER_PLAN_TELEPHONY;
    ptClientMsg->u.gw_message.sc_address.number_of_digits = strlen(sca);
    if (sca[0] == '+')
    {
        // ȥ+
        ptClientMsg->u.gw_message.sc_address.number_of_digits--;
        for (i = 0;i < ptClientMsg->u.gw_message.sc_address.number_of_digits;i++)
        {
            sca[i] = sca[i + 1];
        }
    }
    else if (sca[0] == '0' && sca[1] == '0')
    {
        // ȥ00
        ptClientMsg->u.gw_message.sc_address.number_of_digits -= 2;
        for (i = 0;i < ptClientMsg->u.gw_message.sc_address.number_of_digits;i++)
        {
            sca[i] = sca[i + 2];
        }
    }
    //scaеĺַΪ֣ptClientMsg
    (void)zUfiSms_CharToInt(sca, ptClientMsg->u.gw_message.sc_address.number_of_digits,
                           ptClientMsg->u.gw_message.sc_address.digits);
}

// ͳͳװptDbSaveDataȥΪдݿ׼
void zUfiSms_FillDbSaveData
(
    T_zUfiSms_ClientMsg *ptClientMsg,
    T_zUfiSms_ClientTsData *ptClientData,
    T_zUfiSms_ConcatInfo *ptConcatSms,
    T_zUfiSms_GroupInfo *ptGroupSms,
    int iSmsLen,
    T_zUfiSms_DbStoreData *ptDbSaveData
)
{
    if(NULL == ptClientMsg || NULL == ptClientData ||
       NULL == ptConcatSms || NULL == ptGroupSms || NULL == ptDbSaveData)
    {
        at_print(LOG_ERR,"invalid inputs\n");
        return ;
    }
    
    ptDbSaveData->mem_store = ptClientMsg->msg_hdr.mem_store;
    ptDbSaveData->index = ptClientMsg->msg_hdr.index;
    ptDbSaveData->mode = ptClientMsg->msg_hdr.message_mode;
    ptDbSaveData->tag = ptClientMsg->msg_hdr.tag;

    memset(ptDbSaveData->number, 0, ZTE_WMS_ADDRESS_LEN_MAX + 1);
    memcpy(ptDbSaveData->number, ptGroupSms->receivers[ptGroupSms->current_receiver],
           strlen(ptGroupSms->receivers[ptGroupSms->current_receiver]));
    ptDbSaveData->tp_dcs = DCS_USC;
    ptDbSaveData->tp_pid = ptClientData->u.gw_pp.u.submit.pid;
    ptDbSaveData->msg_ref = ptClientData->u.gw_pp.u.submit.message_reference;
    memset(ptDbSaveData->sms_content, 0, sizeof(ptDbSaveData->sms_content));

    if(g_zUfiSms_Dcs == DCS_USC)
    {
        ptDbSaveData->alphabet = WMS_GW_ALPHABET_UCS2;
    }
    else if(g_zUfiSms_Dcs == DCS_ASC)
    {
        ptDbSaveData->alphabet = WMS_GW_ALPHABET_7_BIT_DEFAULT;
    }    
    (void)zUfiSms_DispatchWtoi(ptConcatSms->msg_contents[ptConcatSms->current_sending],
                           iSmsLen,  (UINT8*)ptDbSaveData->sms_content);
    memcpy(&(ptDbSaveData->julian_date),&(ptConcatSms->date),sizeof(T_zUfiSms_Date));
    memcpy(&g_zUfiSms_DbStoreData[ptConcatSms->current_sending],ptDbSaveData,sizeof(zte_wms_db_sms_data_s_type));
}


// ȫͳͳдdb_write_dataclient_message_ptr   !!!!!һθΪڲֲ
void zUfiSms_SetPduData(T_zUfiSms_ClientMsg *ptClientMsg,T_zUfiSms_DbStoreData *ptDbSaveData)
{
    T_zUfiSms_ClientTsData tClientTsData;
    
    ptClientMsg->msg_hdr.mem_store = WMS_MEMORY_STORE_NV_GW;
    ptClientMsg->msg_hdr.tag = WMS_TAG_MO_NOT_SENT;
    ptClientMsg->msg_hdr.message_mode = WMS_MESSAGE_MODE_GW;
    ptClientMsg->u.gw_message.is_broadcast = FALSE;

    //tClientTsDataݣptClientMsg
    memset((void*)&tClientTsData, 0, sizeof(wms_client_ts_data_s_type));
    tClientTsData.format = WMS_FORMAT_GW_PP;
    tClientTsData.u.gw_pp.tpdu_type = WMS_TPDU_SUBMIT;
    (void)zUfiSms_FillSubmitTpdu(&g_zUfiSms_ConcatSms,&g_zUfiSms_GroupSms,g_zUfiSms_UnitLen,&tClientTsData.u.gw_pp.u.submit,ptDbSaveData);
    (void)wms_ts_encode(&tClientTsData,  &ptClientMsg->u.gw_message.raw_ts_data);
    zUfiSms_FillSca(ptClientMsg);
    
    // ͳͳװptDbSaveDataȥΪдݿ׼
    zUfiSms_FillDbSaveData(ptClientMsg,&tClientTsData,&g_zUfiSms_ConcatSms,&g_zUfiSms_GroupSms,g_zUfiSms_UnitLen,ptDbSaveData);
}

/*洢ͨ */
int zUfiSms_StoreNormalSmsToDb(T_zUfiSms_DbStoreData *ptDbSaveData,  const char *pMemStore, long iSmsId)
{
    int result = ZUFI_SUCC;
    char *pContent = NULL;
    int iTotalCount = 0;

    pContent = (char*)malloc(4 * ZTE_WMS_SMS_MSG_CONTENT_STORE_LEN_MAX);
    if (pContent == NULL)
    {
        return ZUFI_FAIL;
    }

    //
    memset(pContent,0,4 * ZTE_WMS_SMS_MSG_CONTENT_STORE_LEN_MAX);
    if( WMS_GW_ALPHABET_7_BIT_DEFAULT == ptDbSaveData->alphabet)
    {
        static char data[4*ZTE_WMS_SMS_MSG_CONTENT_LEN_MAX + 1] = {0};
        memset(data,0,4*ZTE_WMS_SMS_MSG_CONTENT_LEN_MAX+1);

        (void)zUfiSms_DecodeContent((char*) ptDbSaveData->sms_content, strlen(ptDbSaveData->sms_content),FALSE, data);
        strncpy(pContent,data,4 * ZTE_WMS_SMS_MSG_CONTENT_STORE_LEN_MAX-1);
    }
    else
    {
        strncpy(pContent,ptDbSaveData->sms_content,4 * ZTE_WMS_SMS_MSG_CONTENT_STORE_LEN_MAX-1);
    }
    
    ptDbSaveData->tp_dcs = (unsigned char)2;
    if(-1 == iSmsId) /*insert new normal sms*/
    {
        if(ZUFI_FAIL == zUfiSms_GetTotalCount(pMemStore,&iTotalCount))//kw 3
        {
            free(pContent);
            pContent = NULL;
            return ZUFI_FAIL;
        }  
        printf("[SMS] zUfiSms_StoreNormalSmsToDb iTotalCount=%d\n",iTotalCount);
        if(iTotalCount >= g_zUfiSms_StoreCapablity[(strcmp(pMemStore,"nv") ? ZTE_WMS_MEMORY_SIM : ZTE_WMS_MEMORY_NV)])
        {
            free(pContent);
            pContent = NULL;
            return -1;
        }
        
        if(ZUFI_FAIL == zUfiSms_InsertNormalSmsToDb(ptDbSaveData,pMemStore,pContent))
        {
            result = ZUFI_FAIL;
        }
    }
    else /*update exist sms*/
    {
        if(ZUFI_FAIL == zUfiSms_UpdateNormalSmsToDb(ptDbSaveData,pMemStore,pContent,iSmsId))
        {
            result = ZUFI_FAIL;
        }
    }

    free(pContent);
    pContent = NULL;
    return result;
}

static int   zUfiSms_ConcatDataFree(T_zUfiSms_DbStoreData *ptDbSaveData,int count,char ** out_result)
{
	int i = 0;
	for(i = 0; i < count; i++)
    {
        //db_data->concat_info[2]洢ǰǵڼ
        if(ptDbSaveData->concat_info[2] == i+1)
        {
            free(out_result[i]);
            out_result[i] = NULL;
            break;
        }
    }
	return 0;
}
/** еĴ洢еcontentind/CcSeqȼµptDbSaveDataݣʽ */
int   zUfiSms_AddNewSmsToConcatData
(
    T_zUfiSms_DbStoreData *ptDbSaveData,
    char *pOldContent,
    char *pFormatNewContent,
    char *pRealNewContent,
    T_zUfiSms_DbStoreStr *pac,
    int  *pConcatTotalNum,
    int len
)
{
    int count = 0;
    char ** out_result = NULL;
    char cSegChar = ';';
    int i = 0;
    int iTotalSegNum = 0;
    char acContentSeg[2 * ZTE_WMS_SMS_MSG_CONTENT_STORE_LEN_MAX * ZTE_WMS_SMS_COUNT_MAX] = {0};
    //ǰĴ洢λ
    char *pCurConPos = acContentSeg;
    boolean isEsc = FALSE;
    
    if(NULL == pOldContent)//kw 3
    {
        return -1;
    }
    
    /* ȡеļS1;S2;S3ĸݣout_result */
    count = zUfiSms_SplitString(pOldContent, &out_result, cSegChar);
    for(i = 0; i < count; i++)
    {
        //db_data->concat_info[2]洢ǰǵڼ
        if(ptDbSaveData->concat_info[2] == i+1)
        {
            //ҵӦĶseg¶ż뼶
            out_result[i] = (char*)malloc(sizeof(ptDbSaveData->sms_content));
            memset(out_result[i], 0, sizeof(ptDbSaveData->sms_content));
            if(WMS_GW_ALPHABET_7_BIT_DEFAULT == ptDbSaveData->alphabet)
            {
                isEsc = zUfiSms_DecodeContent(ptDbSaveData->sms_content, strlen(ptDbSaveData->sms_content), isEsc, out_result[i]);
            }
            else
            {
                strncpy(out_result[i],ptDbSaveData->sms_content,sizeof(ptDbSaveData->sms_content)-1);
            }
            break;
        }
    }
    //ѸFormatseg׺,pFormat_concatMsgpContent_outУһFormat,һʵ
    for(i = 0; i < count; i++)
    {
        //strcat(acContentSeg,out_result[i]);//klocwork
        snprintf(acContentSeg+strlen(acContentSeg), sizeof(acContentSeg)-strlen(acContentSeg), "%s", out_result[i]);
        strcat(pFormatNewContent,out_result[i]);
        if(i != count -1)
        {
            strcat(pFormatNewContent,";");
        }
    }
    strncpy(pRealNewContent,acContentSeg,len);
    zUfiSms_ConcatDataFree(ptDbSaveData,count,out_result);
    free(out_result);
    out_result = NULL;
    
    /* Indconcat_indеݷָformat_ind */
    count = zUfiSms_SplitString(pac->IndStr, &out_result, cSegChar);
    for(i = 0; i < count; i++)
    {
        if(ptDbSaveData->concat_info[2] == i+1)
        {
            out_result[i] = (char*)malloc(SHORT_INT_LEN);//sizeof(ptDbSaveData->index)
            memset(out_result[i],0,SHORT_INT_LEN);
            snprintf(out_result[i],SHORT_INT_LEN,"%d",ptDbSaveData->index);
            break;
        }
    }
    for(i = 0; i < count; i++)
    {
        //strcat(pac->FormatInd,out_result[i]);
		snprintf(pac->FormatInd+strlen(pac->FormatInd), sizeof(pac->FormatInd)-strlen(pac->FormatInd), "%s", out_result[i]);
        if(i != count -1)
        {
            //strcat(pac->FormatInd,";");
			snprintf(pac->FormatInd+strlen(pac->FormatInd), sizeof(pac->FormatInd)-strlen(pac->FormatInd), ";");
        }
    }
	zUfiSms_ConcatDataFree(ptDbSaveData,count,out_result);
    free(out_result);
    out_result = NULL;
    
    /*cc seq cancat_seqеݷָformat_seq*/
    count = zUfiSms_SplitString(pac->Seg_Seq, &out_result, cSegChar);
    for(i = 0; i < count; i++)
    {
        if(ptDbSaveData->concat_info[2] == i+1)
        {
            out_result[i] = (char*)malloc(SHORT_INT_LEN);//sizeof(ptDbSaveData->concat_info[2])
            memset(out_result[i],0,SHORT_INT_LEN);
            snprintf(out_result[i],SHORT_INT_LEN,"%d",ptDbSaveData->concat_info[2]);
            break;
        }
    }
    for(i = 0; i < count; i++)
    {
		//strcat(pac->FormatSeq,out_result[i]);
		snprintf(pac->FormatSeq+strlen(pac->FormatSeq), sizeof(pac->FormatSeq)-strlen(pac->FormatSeq), "%s", out_result[i]);
        if(i != count -1)
        {
            //strcat(pac->FormatSeq,";");
			snprintf(pac->FormatSeq+strlen(pac->FormatSeq), sizeof(pac->FormatSeq)-strlen(pac->FormatSeq), ";");
        }
        // һЧseg¼
        if(0 != strcmp(out_result[i],""))
        {
            iTotalSegNum++;
        }
    }
    *pConcatTotalNum = iTotalSegNum;
	zUfiSms_ConcatDataFree(ptDbSaveData,count,out_result);
    free(out_result);
    out_result = NULL;
    
    return  0;
}

int zUfiSms_UpdateConcatSms(T_zUfiSms_DbStoreData *ptDbSaveData, const char *pStorePos, long iSmsId)
{
    T_zUfiSms_DbStoreStr ac = {0};
    char *pOldContent = NULL;
    char *pFormatNewContent = NULL;
    char *pRealNewContent = NULL;
    int iTotalNum = 0;
    int result = ZUFI_SUCC;
    int spaceLen = 4* ZTE_WMS_SMS_MSG_CONTENT_LEN_MAX*ZTE_WMS_CONCAT_SMS_COUNT_MAX+4;//(ZTE_WMS_CONCAT_SMS_COUNT_MAX+1)*1024;
    // ռ
    pOldContent = (char*)malloc(spaceLen);
    pFormatNewContent = (char*)malloc(spaceLen);
    pRealNewContent = (char*)malloc(spaceLen);
    if (pOldContent == NULL || pFormatNewContent == NULL || pRealNewContent == NULL)
    {
        if (pOldContent) free(pOldContent);
        if (pFormatNewContent) free(pFormatNewContent);
        if (pRealNewContent) free(pRealNewContent);
        return ZUFI_FAIL;
    }
    
    memset(pRealNewContent,0,spaceLen);
    memset(pOldContent,0,spaceLen);
    memset(pFormatNewContent,0,spaceLen);

    (void)zUfiSms_GetConcatInfo(pStorePos,iSmsId,&ac,pOldContent,spaceLen);
    printf("[SMS] teet -0 IndStr:%s,Seg_Seq:%s,FormatInd:%s,FormatSeq:%s\n",ac.IndStr,ac.Seg_Seq,ac.FormatInd,ac.FormatSeq);
    if(-1 == zUfiSms_AddNewSmsToConcatData(ptDbSaveData,pOldContent,pFormatNewContent,pRealNewContent,&ac,&iTotalNum,spaceLen))
    {
        result = ZUFI_FAIL;
    }
    printf("[SMS] teet 0 IndStr:%s,Seg_Seq:%s,FormatInd:%s,FormatSeq:%s\n",ac.IndStr,ac.Seg_Seq,ac.FormatInd,ac.FormatSeq);
    ptDbSaveData->tp_dcs = 2;
    if(ZUFI_FAIL == zUfiSms_UpdateConcatSmsToDb(ptDbSaveData,pStorePos,pFormatNewContent,pRealNewContent,&ac,iTotalNum,iSmsId))//kw 3
    {
        result = ZUFI_FAIL;
    }
    printf("[SMS] teet 1 IndStr:%s,Seg_Seq:%s,FormatInd:%s,FormatSeq:%s\n",ac.IndStr,ac.Seg_Seq,ac.FormatInd,ac.FormatSeq);    
    free(pRealNewContent);
    free(pOldContent);
    free(pFormatNewContent);
    pRealNewContent = NULL;
    pOldContent = NULL;
    pFormatNewContent = NULL;
    printf("[SMS] zUfiSms_UpdateConcatSms success.\n");
    return result;
}

int zUfiSms_InsertConcatSms(T_zUfiSms_DbStoreData *ptDbSaveData,  const char *pStorePos)
{
    T_zUfiSms_DbStoreStr ac = {0};
    int iSms_TotalCount = 0;
    int i = 0;
    char acTmpContent[256];
    int  iConcatNum = 0;
    char *pFormatConcat = NULL;
    char *pContent = NULL;
    int spaceLen = 4* ZTE_WMS_SMS_MSG_CONTENT_LEN_MAX*ZTE_WMS_CONCAT_SMS_COUNT_MAX+4;

    if(NULL == ptDbSaveData || NULL == pStorePos )
    {
        return ZUFI_FAIL;
    }

	printf("[SMS] enter InsertConcatSms.\n");
    memset(acTmpContent,0,sizeof(acTmpContent));

    // öŶ֮ķָ,ոʽΪ S1;S2;S3
    iSms_TotalCount = ptDbSaveData->concat_info[1];
    for(i = 1; i < iSms_TotalCount; i++)
    {
        strcat(ac.IndStr,";");
        strcat(ac.Seg_Seq,";");
        strcat(acTmpContent,";");
    }
    
    //䳤ŵռ5*160
    pFormatConcat = (char *)malloc(spaceLen);
    if(NULL == pFormatConcat)
    {
        return ZUFI_FAIL;
    }
    memset(pFormatConcat,0,spaceLen);
    
    pContent = (char *)malloc(spaceLen);
    if (pContent == NULL)
    {
        free(pFormatConcat);
        return ZUFI_FAIL;
    }
    memset(pContent,0,spaceLen);
    
    // ԭмŵĸʽdb_dataзtmp_contentcontentformat_indformat_seq
    if(-1 == zUfiSms_AddNewSmsToConcatData(ptDbSaveData, acTmpContent, pFormatConcat, pContent,
           &ac,&iConcatNum,spaceLen))
    {
        free(pFormatConcat);
        free(pContent);
        pFormatConcat = NULL;
        pContent = NULL;
        return ZUFI_FAIL;
    }

    // յĶ
    ptDbSaveData->tp_dcs = 2;
    if(ZUFI_FAIL == zUfiSms_InsertConcatSmsToDb(ptDbSaveData,pStorePos,pFormatConcat,pContent,&ac,iConcatNum))//kw 3
    {
        free(pFormatConcat);
        free(pContent);
        pFormatConcat = NULL;
        pContent = NULL;
        return ZUFI_FAIL;
    }
	
    free(pFormatConcat);
    free(pContent);
    pFormatConcat = NULL;
    pContent = NULL;
    printf("[SMS] zUfiSms_InsertConcatSms success.\n");
    return ZUFI_SUCC;
}

/* ptDbSaveData洢pMemStore */
int zUfiSms_StoreConcatSmsToDb(T_zUfiSms_DbStoreData *ptDbSaveData,   char *pMemStore)
{
    long iSmsId = 0;
    int total_count = 0;

    if(NULL == ptDbSaveData || NULL == pMemStore)
    {
        return ZUFI_FAIL;
    }
	
    iSmsId = zUfiSms_SearchConcatSmsInDb(ptDbSaveData,pMemStore);
    if(-1 != iSmsId) /*concat sms has exist,so update this sms by id*/
    {
		printf("[SMS] zUfiSms_StoreConcatSmsToDb Enter UpdateConcatSms SmsId:%d.\n",iSmsId);
        return zUfiSms_UpdateConcatSms(ptDbSaveData,pMemStore,iSmsId);
    }
    else /*insert a new concat sms if possible */
    {
        if(ZUFI_FAIL == zUfiSms_GetTotalCount(pMemStore,&total_count))//kw 3
        {
			printf("[SMS] zUfiSms_StoreConcatSmsToDb GetTotalCount Failed.\n");
            return ZUFI_FAIL;
        }    

        printf("[SMS] zUfiSms_StoreConcatSmsToDb pMemStore=%s,total_count=%d.\n",pMemStore,total_count);
        if(total_count >= g_zUfiSms_StoreCapablity[(strcmp(pMemStore,"nv") ? ZTE_WMS_MEMORY_SIM : ZTE_WMS_MEMORY_NV)])
        {
        	printf("[SMS] zUfiSms_StoreConcatSmsToDb Sms memory is Full.\n");
            return ZUFI_FAIL;
        }

        return zUfiSms_InsertConcatSms(ptDbSaveData,pMemStore);
    }
}

/**ptDbSaveDataдiMemStoreУӦidΪiSmsId,Ϊ-1ʾ¶  */
int zUfiSms_WriteSmsToDb
(T_zUfiSms_DbStoreData *ptDbSaveData, zUfiSms_StoreType iMemStore,  long iSmsId)
{
    char acDbMemStore[10];
    int iTotalCount = 0;
    int id = 0;
    UINT8 needCheckMemory = 1;
    if(NULL == ptDbSaveData)
    {
        return ZUFI_FAIL;
    }

    //洢λ
    memset(acDbMemStore,0,sizeof(acDbMemStore));
    if(WMS_STORAGE_TYPE_UIM_V01 == iMemStore)
    {
        strncpy(acDbMemStore,ZTE_WMS_DB_SIM_TABLE,sizeof(acDbMemStore)-1);
    }
    else
    {
        strncpy(acDbMemStore,ZTE_WMS_DB_NV_TABLE,sizeof(acDbMemStore)-1);
    }

     if (1 == ptDbSaveData->concat_sms)
    {
	    id = zUfiSms_SearchConcatSmsInDb(ptDbSaveData,&acDbMemStore);
	    if(-1 != id) /*concat sms has exist*/
	    {
	        needCheckMemory = 0;
	    }
    }
    
    if(needCheckMemory == 1)
    {
	 //ǰѴ洢
	    if(ZUFI_FAIL == zUfiSms_GetTotalCount(acDbMemStore,&iTotalCount))
	    {
	        return ZUFI_FAIL;
	    } 
        printf("[SMS] zUfiSms_WriteSmsToDb iTotalCount=%d(needCheckMemory==1)\n",iTotalCount);
	    if(iTotalCount >= g_zUfiSms_StoreCapablity[(strcmp(acDbMemStore,"nv") ? ZTE_WMS_MEMORY_SIM : ZTE_WMS_MEMORY_NV)])
	    {
	        // ޷д
	        printf("[SMS] zUfiSms_WriteSmsToDb memory full, error\n");
	        return ZTE_WMS_NV_MEMORY_FULL;
	    }
    }
    if(ptDbSaveData->concat_info[2] == 0 || ptDbSaveData->concat_info[2] > ptDbSaveData->concat_info[1])
    {
    	ptDbSaveData->concat_sms = 0;
    }
   
	printf("[SMS] zUfiSms_WriteSmsToDb TotalCount:%d.concat_sms:%d.concat_info[1]:%d\n",iTotalCount,ptDbSaveData->concat_sms,ptDbSaveData->concat_info[1]);
    
    /*concat sms*/
    if (1 == ptDbSaveData->concat_sms)
    {
        // ڶλǵǰκ
        if(ZTE_WMS_CONCAT_SMS_COUNT_MAX < ptDbSaveData->concat_info[1])
        {
            return ZUFI_FAIL;
        }
        else
        {
            return zUfiSms_StoreConcatSmsToDb(ptDbSaveData,acDbMemStore);
        }        
    }
    else /*normal sms*/
    {
        return zUfiSms_StoreNormalSmsToDb(ptDbSaveData,acDbMemStore,iSmsId);
    }
}

T_zUfiSms_CmdStatus zUfiSms_SendOutSms(T_zUfiSms_DbStoreData *ptDbSaveData, int cid)
{
	//CHAR errCode[ZSVR_AT_RES_CODE_LEN] = {0};	
	int atRes = 0;

    if(NULL == ptDbSaveData)
    {
        return WMS_CMD_FAILED;
    }
    // ǰʧܵseg
    if(!g_zUfiSms_IsConcatSendSuc)
    {
        //ʧ,  
        ptDbSaveData->tag = WMS_TAG_TYPE_MO_NOT_SENT_V01;
        if(ZUFI_SUCC == zUfiSms_WriteSmsToDb(ptDbSaveData,WMS_STORAGE_TYPE_NV_V01,-1))
        {
            g_zUfiSms_MsgRefer++;
            ptDbSaveData->msg_ref = g_zUfiSms_MsgRefer;
            (void)zUfiSms_SetMaxReference(g_zUfiSms_MsgRefer);
        }
    }
    else
    {
        CHAR sendfailRetry[50]={0};
        sc_cfg_get(NV_SENDFAIL_RETRY,sendfailRetry,sizeof(sendfailRetry));
        if(0 == strcmp("1", sendfailRetry))
        {
            g_zUfiSms_SendFailedRetry = 3;
        }
        //atBase_SendMsgToSelf(ZAT_CMGS_CMD, NULL, 0);
		atRes = zSms_SendCmgsReq();
		if(atRes != ZSMS_RESULT_OK)
	    {
		    zSms_RecvCmgsErr();
	    }
		else
		{
			zSms_RecvCmgsOk();
		}
    }
	return WMS_CMD_SUCCESS;
}

// ͼţһڣȴOKѭú뷢һ
int zUfiSms_SendConcatSms(int cid)
{
	int atRes = 0;

    T_zUfiSms_ClientMsg tClientMsg;
    T_zUfiSms_DbStoreData tDbSaveData;
    int result = ZUFI_FAIL;
    
    if(g_zUfiSms_ConcatSms.current_sending >= g_zUfiSms_ConcatSms.total_msg)
    {
        return  ZUFI_FAIL;
    }

    // ȫй췢ݣtClientMsg/tDbSaveData
    memset((void*)&tClientMsg,0, sizeof(T_zUfiSms_ClientMsg));
    memset((void*)&tDbSaveData, 0, sizeof(tDbSaveData));
    zUfiSms_SetPduData(&tClientMsg,&tDbSaveData);

    /*if the first concat sms failed,then the left concat sms will not be send*/
    if(!g_zUfiSms_IsConcatSendSuc)
    {
        tDbSaveData.tag = WMS_TAG_TYPE_MO_NOT_SENT_V01;
        (void)zUfiSms_WriteSmsToDb(&tDbSaveData,WMS_STORAGE_TYPE_NV_V01,-1);
        g_zUfiSms_SendFailedCount++;
    }
    else
    {
        CHAR sendfailRetry[50]={0};
        sc_cfg_get(NV_SENDFAIL_RETRY,sendfailRetry,sizeof(sendfailRetry));
        if(0 == strcmp("1", sendfailRetry))
        {
            g_zUfiSms_SendFailedRetry = 3;
        }
        //atBase_SendMsgToSelf(ZAT_CMGS_CMD, NULL, 0);
		atRes = zSms_SendCmgsReq();
		if(atRes != ZSMS_RESULT_OK)
	    {
		    zSms_RecvCmgsErr();
	    }
		else
		{
			zSms_RecvCmgsOk();
		}

    }
    
    //ͼ
    g_zUfiSms_ConcatSms.current_sending++;
    if (g_zUfiSms_ConcatSms.current_sending < g_zUfiSms_ConcatSms.total_msg)
    {
        //ʣһֶδ
        if (g_zUfiSms_ConcatSms.sms_len <  g_zUfiSms_UnitLen * (g_zUfiSms_ConcatSms.current_sending +1))
        {
            g_zUfiSms_UnitLen = g_zUfiSms_ConcatSms.sms_len  - g_zUfiSms_UnitLen * g_zUfiSms_ConcatSms.current_sending ;
        }
    }

    //ͽִ
    if( g_zUfiSms_ConcatSms.current_sending == g_zUfiSms_ConcatSms.total_msg && !g_zUfiSms_IsConcatSendSuc )
    {
        T_zUfiSms_StatusInfo tSendStatus;      

        memset((void*)&tSendStatus,0,sizeof(T_zUfiSms_StatusInfo));
        tSendStatus.err_code = ZTE_SMS_CMS_NONE;
        tSendStatus.send_failed_count = g_zUfiSms_SendFailedCount;
        tSendStatus.delete_failed_count = 0;
        tSendStatus.cmd_status = WMS_CMD_FAILED;
        tSendStatus.cmd = WMS_SMS_CMD_MSG_SEND;
        (void)zUfiSms_SetCmdStatus(&tSendStatus);

        sc_cfg_set(NV_SMS_SEND_RESULT, "fail");
        sc_cfg_set(NV_SMS_DB_CHANGE,"1");
        return ZUFI_FAIL;
    } 
    // ʧܣݹãŴ洢ϱ״̬
    if( !g_zUfiSms_IsConcatSendSuc)
    {
        zUfiSms_SendConcatSms(cid);
    }

    return result;
}
int zSvr_sendCmgs(VOID)
{
	int atRes = 0;
	int i = 0;

	atRes = zSms_SendCmgsReq();
	if(atRes != ZSMS_RESULT_OK)
	{
	    CHAR sendfailRetry[50]={0};
        sc_cfg_get(NV_SENDFAIL_RETRY,sendfailRetry,sizeof(sendfailRetry));
        if(0 == strcmp("1", sendfailRetry))
        {
            for(i=0;i<SMS_RETRY_COUNT;i++)
            {
                atRes = zSms_SendCmgsReq();
				if(atRes == ZSMS_RESULT_OK)
				{
					break;
				}
            }
        }
    }
    return atRes;
}
/*concat_smsշgroup_smsη */
T_zUfiSms_CmdStatus zUfiSms_SendSms(VOID)
{
    T_zUfiSms_ClientMsg tClientMsg;
    T_zUfiSms_DbStoreData tDbSaveData;
	int res = 0;

    if(-1 == g_zUfiSms_UnitLen)
    {
        // ݷ
        printf("[SMS] !!!zUfiSms_SendSms: No content!.\n");
        return WMS_CMD_FAILED;
    }
    while(g_zUfiSms_ConcatSms.current_sending < g_zUfiSms_ConcatSms.total_msg)
    {
        // ȫй췢ݣtClientMsg/tDbSaveData
        memset((void*)&tClientMsg,0, sizeof(T_zUfiSms_ClientMsg));
        memset((void*)&tDbSaveData, 0, sizeof(tDbSaveData));
        zUfiSms_SetPduData(&tClientMsg,&tDbSaveData);
        
        /*if the first concat sms failed,then the left concat sms will not be send*/
        if(!g_zUfiSms_IsConcatSendSuc)
        {
            tDbSaveData.tag = WMS_TAG_TYPE_MO_NOT_SENT_V01;
            (void)zUfiSms_WriteSmsToDb(&tDbSaveData,WMS_STORAGE_TYPE_NV_V01,-1);//loop or only tag
            g_zUfiSms_SendFailedCount++;
        }
        else
        {
            //atBase_SendMsgToSelf(ZAT_CMGS_CMD, NULL, 0);
            res = zSvr_sendCmgs();
            if(res != ZSMS_RESULT_OK)
            {
                zSms_RecvCmgsErr();
            }
            else
            {
                zSms_RecvCmgsOk();
            }
            
        }
        
        //ͼ
        g_zUfiSms_ConcatSms.current_sending++;
        if (g_zUfiSms_ConcatSms.current_sending < g_zUfiSms_ConcatSms.total_msg)
        {
            //ʣһֶδ
            if (g_zUfiSms_ConcatSms.sms_len <  g_zUfiSms_UnitLen * (g_zUfiSms_ConcatSms.current_sending +1))
            {
                g_zUfiSms_UnitLen = g_zUfiSms_ConcatSms.sms_len  - g_zUfiSms_UnitLen * g_zUfiSms_ConcatSms.current_sending ;
            }
        }
        
        //ͽִ
        if( g_zUfiSms_ConcatSms.current_sending == g_zUfiSms_ConcatSms.total_msg && !g_zUfiSms_IsConcatSendSuc )
        {
            T_zUfiSms_StatusInfo tSendStatus;      
            
            memset((void*)&tSendStatus,0,sizeof(T_zUfiSms_StatusInfo));
            tSendStatus.err_code = ZTE_SMS_CMS_NONE;
            tSendStatus.send_failed_count = g_zUfiSms_SendFailedCount;
            tSendStatus.delete_failed_count = 0;
            tSendStatus.cmd_status = WMS_CMD_FAILED;
            tSendStatus.cmd = WMS_SMS_CMD_MSG_SEND;
            (void)zUfiSms_SetCmdStatus(&tSendStatus);
            
            sc_cfg_set(NV_SMS_SEND_RESULT, "fail");
            sc_cfg_set(NV_SMS_DB_CHANGE,"1");
            //return ZUFI_FAIL;
        } 
    }
#if 0	
    if (g_zUfiSms_ConcatSms.total_msg > 1)
    {
        //
        printf("====zUfiSms_SendConcatSms.\n");		
        zUfiSms_SendConcatSms(cid);
    }
    else  
    {
        //̶ţ ȫtClientMsgtDbSaveData
        memset((void*)&tClientMsg,0, sizeof(T_zUfiSms_ClientMsg));
        memset((void*)&tDbSaveData, 0, sizeof(tDbSaveData));
        zUfiSms_SetPduData(&tClientMsg,&tDbSaveData);
		
        printf("====zUfiSms_SendnoramlSms.\n");
		
        if(WMS_CMD_FAILED == zUfiSms_SendOutSms(&tDbSaveData, cid))
        {
       		printf("!!!!!zUfiSms_SendOutSms Fail.\n");
            g_zUfiSms_SendFailedCount++;
            return WMS_CMD_FAILED;
        }
    }
#endif
    return WMS_CMD_SUCCESS;
}


//tDataڸʽptTimestamp
int zUfiSms_FormatDeliverTimestamp(T_zUfiSms_Date tData,T_zUfiSms_TimeStamp *ptTimestamp)
{
    unsigned char tTimeZone[5] = {0};
	int tmp_i = 0;

    memset(ptTimestamp,0,sizeof(T_zUfiSms_TimeStamp));
    if(strlen(tData.year) == 1)
    {
        ptTimestamp->year = zUfiSms_atohex('0')*16 + zUfiSms_atohex(tData.year[0]);
    }
    else if(strlen(tData.year) == 2)
    {
        ptTimestamp->year = zUfiSms_atohex(tData.year[0])*16 + zUfiSms_atohex(tData.year[1]);
    }
    else if(strlen(tData.year) == 4)
    {
        ptTimestamp->year = zUfiSms_atohex(tData.year[2])*16 + zUfiSms_atohex(tData.year[3]);
    }
    else
    {
        printf("unknown year.");
        return ZUFI_FAIL;
    }

    if(strlen(tData.month) == 1)
    {
        ptTimestamp->month= zUfiSms_atohex('0')*16 + zUfiSms_atohex(tData.month[0]);
    }
    else if(strlen(tData.month) == 2)
    {
        ptTimestamp->month= zUfiSms_atohex(tData.month[0])*16 + zUfiSms_atohex(tData.month[1]);
    }
    else
    {
        printf("unknown day.");
    }

    if(strlen(tData.day) == 1)
    {
        ptTimestamp->day= zUfiSms_atohex('0')*16 + zUfiSms_atohex(tData.day[0]);
    }
    else if(strlen(tData.day) == 2)
    {
        ptTimestamp->day= zUfiSms_atohex(tData.day[0])*16 + zUfiSms_atohex(tData.day[1]);
    }
    else
    {
        printf("unknown day.");
    }

    if(strlen(tData.hour) == 1)
    {
        ptTimestamp->hour= zUfiSms_atohex('0')*16 + zUfiSms_atohex(tData.hour[0]);
    }
    else if(strlen(tData.hour) == 2)
    {
        ptTimestamp->hour= zUfiSms_atohex(tData.hour[0])*16 + zUfiSms_atohex(tData.hour[1]);
    }
    else
    {
        printf("unknown hour.");
    }

    if(strlen(tData.min) == 1)
    {
        ptTimestamp->minute= zUfiSms_atohex('0')*16 + zUfiSms_atohex(tData.min[0]);
    }
    else if(strlen(tData.min) == 2)
    {
        ptTimestamp->minute= zUfiSms_atohex(tData.min[0])*16 + zUfiSms_atohex(tData.min[1]);
    }
    else
    {
        printf("unknown minute.");
    }

    if(strlen(tData.sec) == 1)
    {
        ptTimestamp->second= zUfiSms_atohex('0')*16 + zUfiSms_atohex(tData.sec[0]);
    }
    else if(strlen(tData.sec) == 2)
    {
        ptTimestamp->second= zUfiSms_atohex(tData.sec[0])*16 + zUfiSms_atohex(tData.sec[1]);
    }
    else
    {
        printf("unknown second.");
    }
	tmp_i = atoi(tData.timezone);
	if(tmp_i < INT_MIN+1 || tmp_i > INT_MAX-1) { //kw 3
		printf("unknown tData timezone:%d.\n", tmp_i);
		return ZUFI_FAIL;
	}

    memset(tTimeZone,0,sizeof(tTimeZone));
    snprintf(tTimeZone,sizeof(tTimeZone),"%d",tmp_i*4);
    if(tData.timezone[0] == '-')
    {
        if(strlen(tTimeZone) == 2)
        {
            ptTimestamp->timezone = zUfiSms_atohex('0')*16 + zUfiSms_atohex(tTimeZone[1]);
        }
        else if(strlen(tTimeZone) == 3)
        {
            ptTimestamp->timezone = zUfiSms_atohex(tTimeZone[1])*10 + zUfiSms_atohex(tTimeZone[2]);
        }
        else
        {
            printf("unknown -timezone.");
        }
        ptTimestamp->timezone = 0 - ptTimestamp->timezone;
    }
    else
    {
        if(strlen(tTimeZone) == 1)
        {
            ptTimestamp->timezone = zUfiSms_atohex('0')*16 + zUfiSms_atohex(tTimeZone[0]);
        }
        else if(strlen(tTimeZone) == 2)
        {
            ptTimestamp->timezone = zUfiSms_atohex(tTimeZone[0])*10 + zUfiSms_atohex(tTimeZone[1]);
        }
        else
        {
            printf("unknown +timezone.");
        }
    }
    return ZUFI_SUCC;
}

void zUfiSms_FillDeliver(T_zUfiSms_DeliverPdu *deliver,T_zUfiSms_ConcatInfo *concat_sms,
                                   T_zUfiSms_DbStoreData *ptDbSaveData)
{
    static UINT16 msg_ref = 0;

    deliver->user_data_header_present = TRUE;
    if (0 == concat_sms->current_sending)
    {
        g_zUfiSms_ConcatSmsReference ++;
        (void)zUfiSms_SetConcatMaxRefer(g_zUfiSms_ConcatSmsReference);
    }

    deliver->user_data_header_present = TRUE;
    deliver->user_data.num_headers = 1;
    deliver->user_data.headers[0].header_id = WMS_UDH_CONCAT_8;
    deliver->user_data.headers[0].u.concat_8.msg_ref = msg_ref;
    deliver->user_data.headers[0].u.concat_8.total_sm = concat_sms->total_msg;
    deliver->user_data.headers[0].u.concat_8.seq_num = concat_sms->current_sending + 1;

    ptDbSaveData->concat_sms = 1;
    ptDbSaveData->concat_info[0] = msg_ref;
}

/*  concat_smsgroup_smsptDeliverptDbSaveData */
void zUfiSms_FillDeliverPdu
(
    T_zUfiSms_DeliverPdu *ptDeliver,
    T_zUfiSms_ConcatInfo *concat_sms,
    T_zUfiSms_GroupInfo *group_sms,
    int iSmsLen,
    T_zUfiSms_DbStoreData *ptDbSaveData
)
{
    if (NULL == concat_sms ||  NULL == group_sms)
    {
        return ;
    }

    ptDeliver->more = FALSE;
    ptDeliver->reply_path_present = FALSE;
    ptDeliver->status_report_enabled = g_zUfiSms_CurSmsPara.status_report_on;
    ptDeliver->pid = WMS_PID_DEFAULT;
    ptDeliver->dcs.msg_class = WMS_MESSAGE_CLASS_NONE;
    ptDeliver->dcs.is_compressed = FALSE;

    if (g_zUfiSms_Dcs == DCS_ASC)
    {
        ptDeliver->dcs.alphabet = WMS_GW_ALPHABET_7_BIT_DEFAULT;
    }
    else
    {
        ptDeliver->dcs.alphabet = WMS_GW_ALPHABET_UCS2;
    }
    
    if (concat_sms->total_msg > 1)
    {
        zUfiSms_FillDeliver(ptDeliver,concat_sms,ptDbSaveData);

        ptDbSaveData->concat_sms = 1;
        ptDbSaveData->concat_info[2] = concat_sms->current_sending+1;        /*start at 1 and increment by one */
        ptDbSaveData->concat_info[1] = concat_sms->total_msg;
        ptDbSaveData->concat_info[0] = ptDeliver->user_data.headers[0].u.concat_8.msg_ref;
    }
    else
    {
        ptDeliver->user_data_header_present = FALSE;
        ptDeliver->user_data.num_headers = 0;
    }
    
    ptDeliver->user_data.sm_len = iSmsLen;
    memcpy(ptDeliver->user_data.sm_data, concat_sms->msg_contents[concat_sms->current_sending], iSmsLen);
    if (group_sms->receivers[group_sms->current_receiver][0] == '+')
    {
        (void)zUfiSms_CharToInt(group_sms->receivers[group_sms->current_receiver] + 1,
                               strlen(group_sms->receivers[group_sms->current_receiver]) - 1, ptDeliver->address.digits);
        ptDeliver->address.number_type = WMS_NUMBER_INTERNATIONAL;
        ptDeliver->address.number_of_digits = (UINT8)strlen(group_sms->receivers[group_sms->current_receiver]) - 1;
    }
    else
    {
        (void)zUfiSms_CharToInt(group_sms->receivers[group_sms->current_receiver], strlen(group_sms->receivers[group_sms->current_receiver]), ptDeliver->address.digits);
        ptDeliver->address.number_type = WMS_NUMBER_UNKNOWN;
        ptDeliver->address.number_of_digits = (UINT8)strlen(group_sms->receivers[group_sms->current_receiver]);
    }

    ptDeliver->address.digit_mode = WMS_DIGIT_MODE_4_BIT;
    ptDeliver->address.number_mode = WMS_NUMBER_MODE_NONE_DATA_NETWORK;
    ptDeliver->address.number_plan = WMS_NUMBER_PLAN_TELEPHONY;
}

T_zUfiSms_CmdStatus zUfiSms_SaveConcatSms
(
    T_zUfiSms_SaveReq *ptSaveSms,
    T_zUfiSms_ConcatInfo *ptConcatSms,
    T_zUfiSms_GroupInfo *ptGroupSms,
    T_zUfiSms_DbStoreData *ptDbSaveData,
    int iSmsLen
)
{
    printf("[SMS] zUfiSms_SaveConcatSms mem_store=%d(NV==01)\n",ptSaveSms->mem_store);
    if(ptSaveSms->mem_store == WMS_STORAGE_TYPE_NV_V01)/*else only write to nv */
    {
        if(ZUFI_FAIL == zUfiSms_WriteSmsToDb(ptDbSaveData,WMS_STORAGE_TYPE_NV_V01,-1))
        {
            at_print(LOG_ERR,"write sms to nv failed.");
            return WMS_CMD_FAILED;
        }
    }
    else
    {
        return WMS_CMD_FAILED;
    }
    
    g_zUfiSms_MsgRefer++;
    ptDbSaveData->msg_ref = g_zUfiSms_MsgRefer;
    (void)zUfiSms_SetMaxReference(g_zUfiSms_MsgRefer);

    return WMS_CMD_SUCCESS;
}

T_zUfiSms_CmdStatus zUfiSms_SaveNormalSms(T_zUfiSms_SaveReq *ptSaveSms, T_zUfiSms_DbStoreData *ptDbSaveData)
{
    g_zUfiSms_MsgRefer++;
    ptDbSaveData->msg_ref = g_zUfiSms_MsgRefer;
    
    if(ptSaveSms->mem_store == WMS_STORAGE_TYPE_NV_V01)/*else only write to nv */
    {
        if(ZUFI_SUCC == zUfiSms_WriteSmsToDb(ptDbSaveData,WMS_STORAGE_TYPE_NV_V01,ptSaveSms->id))
        {
            (void)zUfiSms_SetMaxReference(g_zUfiSms_MsgRefer);
            return WMS_CMD_SUCCESS;
        }
        else
        {
            printf("write sms to nv failed.");
            return WMS_CMD_FAILED;
        }
    }
	return WMS_CMD_SUCCESS;
}

/*ݴݿ */
T_zUfiSms_CmdStatus zUfiSms_SaveSmsToDb
(
    T_zUfiSms_SaveReq *ptSaveSms,
    T_zUfiSms_ConcatInfo *ptConcatSms,
    T_zUfiSms_GroupInfo *ptGroupSms,
    int iSmsLength
)
{
    T_zUfiSms_ClientTsData tClientTsData;
    T_zUfiSms_ClientMsg tClientMsg;
    T_zUfiSms_DbStoreData tDbSaveData;
    T_zUfiSms_CmdStatus result = WMS_CMD_SUCCESS;
    int current_sending = 0;

    if(NULL == ptSaveSms || NULL == ptConcatSms || NULL == ptGroupSms||(-1 == iSmsLength))
    {
        return WMS_CMD_FAILED;
    }
	for(ptConcatSms->current_sending = 0; ptConcatSms->current_sending < ptConcatSms->total_msg; ptConcatSms->current_sending++)
    {
        memset((void*)&tClientMsg,0, sizeof(T_zUfiSms_ClientMsg));
        memset((void*)&tClientTsData, 0, sizeof(T_zUfiSms_ClientTsData));
        memset((void*)&tDbSaveData, 0, sizeof(T_zUfiSms_DbStoreData));
        // !!!!!!!Ͳƥ
        tClientMsg.msg_hdr.mem_store = (ptSaveSms->mem_store == WMS_STORAGE_TYPE_UIM_V01) ? WMS_STORAGE_TYPE_UIM_V01 : WMS_STORAGE_TYPE_NV_V01;
        tClientMsg.msg_hdr.tag =  (T_zUfiSms_SmsTag)ptSaveSms->tags;
        tClientMsg.msg_hdr.message_mode = WMS_MESSAGE_MODE_GW;
        tClientMsg.u.gw_message.is_broadcast = FALSE;
        
        tClientTsData.format = WMS_FORMAT_GW_PP;
        
        switch(ptSaveSms->tags)
        {
            case WMS_TAG_TYPE_MO_SENT_V01:
            case WMS_TAG_TYPE_MO_NOT_SENT_V01:
            case 4: /*for saved sms*/
            {
                tClientTsData.u.gw_pp.tpdu_type = WMS_TPDU_SUBMIT;
                (void)zUfiSms_FillSubmitTpdu(ptConcatSms,ptGroupSms,iSmsLength,&tClientTsData.u.gw_pp.u.submit,&tDbSaveData);
                break;
            }
            case WMS_TAG_TYPE_MT_READ_V01:
            case WMS_TAG_TYPE_MT_NOT_READ_V01:
            {
                tClientTsData.u.gw_pp.tpdu_type = WMS_TPDU_DELIVER;
                (void)zUfiSms_FormatDeliverTimestamp(ptSaveSms->date,&(tClientTsData.u.gw_pp.u.deliver.timestamp));
                zUfiSms_FillDeliverPdu(&tClientTsData.u.gw_pp.u.deliver,ptConcatSms,ptGroupSms,iSmsLength,&tDbSaveData);
                break;
            }
            default:
            {
                printf("unknown tags.");
                break;
            }
        }
        
        //tClientTsDataеsubmitݸʽtClientMsg
        (void)wms_ts_encode(&tClientTsData,&tClientMsg.u.gw_message.raw_ts_data);
        zUfiSms_FillSca(&tClientMsg);
        zUfiSms_FillDbSaveData(&tClientMsg,&tClientTsData,ptConcatSms,ptGroupSms,iSmsLength,&tDbSaveData);
        strncpy(tDbSaveData.draft_group_id, ptSaveSms->draft_group_id,sizeof(tDbSaveData.draft_group_id)-1);
        
        if (TRUE == g_zUfiSms_MemFullFlag[ZTE_WMS_MEMORY_NV])
        {
            //g_zUfiSms_StatusInfo.err_code = ZTE_SMS_CMS_MEM_FULL;
            result = WMS_CMD_FAILED;
            printf("[SMS] zUfiSms_SaveSmsToDb NV memory is full,save error\n");
        }
        else
        {
            if (tDbSaveData.concat_sms == 1) /*concat sms*/
            {
                result = zUfiSms_SaveConcatSms(ptSaveSms,ptConcatSms,ptGroupSms,&tDbSaveData,iSmsLength);
                current_sending = ptConcatSms->current_sending + 1;
                if (ptConcatSms->sms_len <  iSmsLength * (current_sending +1))
                {
                    iSmsLength = ptConcatSms->sms_len  - iSmsLength * current_sending;
                }
            }
            else
            {
                result = zUfiSms_SaveNormalSms(ptSaveSms,&tDbSaveData);
            }
        }
    }
    return result;
}

/** ɾеĶ */
int zUfiSms_DeleteSmsInSim()
{
    char str_index[128] = {0};
    int index = 0;
    int is_cc = 0;
    int iSmsId = 0;
    T_zUfiSms_ModifyTag tDeleteInfo = {0};
	char StrValue[10] = {0};
	
    memset(&tDeleteInfo,0,sizeof(T_zUfiSms_ModifyTag));
    iSmsId = g_zUfiSms_DelMsg.sim_id[g_zUfiSms_DelMsg.sim_index];
    if(-1 == (is_cc = zUfiSms_IsConcatSms(iSmsId)))
    {
        printf("[SMS] zUfiSms_DeleteSmsInSim check concat failed.\n");
        return ZUFI_FAIL;
    }
	
    printf("[SMS] zUfiSms_DeleteSmsInSim is_cc:%d, id=%d\n",is_cc,iSmsId);
    if(1 == is_cc) 
    {
        //
        if(ZUFI_FAIL  == zUfiSms_GetSmsIndex(iSmsId,&tDeleteInfo,is_cc))
        {
            return ZUFI_FAIL;
        }
        g_zUfiSms_DelMsg.sim_index++ ;
        g_zUfiSms_DelMsg.sim_index_count-- ;
        //ɾ
        while(tDeleteInfo.num_of_indices > 0)
        {
            index = tDeleteInfo.indices[tDeleteInfo.id_index];
	        g_deleteIndex.index[g_deleteIndex.total] = index;
	        g_deleteIndex.total++;

            //zUfiSms_DelModemSms(index);
            //SMS_SendToBackEx(AT_CMGD_CMD,AT_CMD_TYPE_SET, MSG_TYPE_CMGD, &Para,sizeof(T_zCmgd_SetCmd));
            tDeleteInfo.id_index++;
            tDeleteInfo.num_of_indices--;
        }
    }
    else 
    {
        //̶
        memset(str_index,0,sizeof(str_index));
        if(ZUFI_FAIL == zUfiSms_GetStorePosById("ind",str_index,sizeof(str_index),iSmsId))
        {
            at_print(LOG_ERR,"get index from db faild.");
            return ZUFI_FAIL;
        }
        index = atoi(str_index);
        //atSms_SendCmgdReq(&index);
        g_deleteIndex.index[g_deleteIndex.total] = index;
	    g_deleteIndex.total++;
		//sat_print(LOG_DEBUGStrValue,"%d",index);
		//atBase_SendMsgToSelf(ZAT_CMGD_CMD, StrValue, (UINT16)strlen(StrValue));
	    //atSms_SendCmgdReq(StrValue);	
        g_zUfiSms_DelMsg.sim_index++;
        g_zUfiSms_DelMsg.sim_index_count--;
    }
    (void)zUfiSms_DeleteSmsInDb();
    return ZUFI_SUCC;
}

/*  ɾж  */
T_zUfiSms_CmdStatus zUfiSms_DeleteSimSms(VOID)
{
	int atRes = 0;
    char StrValue[10] = {0};
	
    zUfiSms_SetSmsLocation(SMS_LOCATION_SIM);
    memset(&g_deleteIndex,0,sizeof(T_zUfiSms_DelIndexInfo));
    while( g_zUfiSms_DelMsg.sim_index_count >0)
    {
        if(ZUFI_FAIL == zUfiSms_DeleteSmsInSim())
        {
            printf("[SMS] zUfiSms_DeleteSimSms delete all:%d sms failed\n",WMS_STORAGE_TYPE_UIM_V01);
            return WMS_CMD_FAILED;
        }
    }
    while(g_deleteIndex.cur_index < g_deleteIndex.total)
    {
        //snat_print(LOG_DEBUGStrValue,sizeof(StrValue),"%d",g_deleteIndex.index[g_deleteIndex.cur_index]);
        //atBase_SendMsgToSelf(ZAT_CMGD_CMD, StrValue, (UINT16)strlen(StrValue));
        atRes = zSms_SendCmgdReq(g_deleteIndex.index[g_deleteIndex.cur_index]);
        if(atRes == ZSMS_RESULT_OK)
        {
            zSms_RecvCmgdOk();
        }
        else
        {
            zSms_RecvCmgdErr();
        }
        g_deleteIndex.cur_index++;
    }
    zSms_RecvCmgdFinish();
    printf("[SMS] zUfiSms_DeleteSimSms success\n");
    return WMS_CMD_SUCCESS;
}

// Pduж״ֶ̬
void zUfiSms_GetReportStatus(char  *pdu_tmp,int *stat)
{
    unsigned char tmp;                         // ڲõʱֽڱ
    unsigned char first_octet;                    //汣first octetϢ

    if(pdu_tmp ==  NULL )
    {
        return ;
    }

    // ĵַϢ
    (void)String2Bytes(pdu_tmp, &tmp, 2);               
    if(tmp == 0)
    {
        // ϢĵַΪ0ֵָֻ2
        pdu_tmp += 2;
    }
    else
    {
        //  ϢĵַȲΪ0ֵָtmpֵ
        tmp = (tmp + 1) * 2;// SMSC봮
        pdu_tmp += tmp;// ָ
    }
    
    // TPDUλظַ
    (void)String2Bytes(pdu_tmp, &tmp, 2);// ȡfirst octet
    first_octet = tmp;
    if(first_octet & 0x02)
    {
        *stat = 5;
    }
}

T_zUfiSms_TpduType zUfiSms_GetTpduType(UINT8 *pData)
{
    T_zUfiSms_TpduType iTpduType;
    UINT8 mti =0;

    mti = (T_zUfiSms_TpduType) (pData[0] & 0x03); /*bit 0 and bit 1*/
    switch(mti)
    {
        case 0:
            iTpduType = WMS_TPDU_DELIVER;
            break;
        case 1:
            iTpduType = WMS_TPDU_SUBMIT;
            break;
        case 2:
            iTpduType = WMS_TPDU_STATUS_REPORT;
            break;
        default:
            iTpduType = WMS_TPDU_MAX;
            break;
    }

    return iTpduType;
}

static void zUfiSms_FormatDeliverNumber
(
    wms_address_s_type tAddress,
    unsigned char *pNumber
)
{
    UINT8 number_type = 0;

    memset(pNumber, 0, ZTE_WMS_ADDRESS_LEN_MAX+1);
    if (tAddress.number_type == WMS_NUMBER_INTERNATIONAL)
    {
        pNumber[0] = '+';
        pNumber++;
    }
    if (tAddress.digit_mode != WMS_DIGIT_MODE_8_BIT)
    {
        (void)zUfiSms_SmsiAddrToStr(tAddress, (byte*)pNumber, &number_type);
    }
    else
    {
        memcpy(pNumber, tAddress.digits, tAddress.number_of_digits * sizeof(tAddress.digits[0]));
    }
}

byte * zUfiSms_UtilTimeStamp
(
    T_zUfiSms_TimeStamp zte_wms_time,  /* Pointer to Time Stamp        */
    byte * res_ptr,                /* Pointer to the result buffer */
    T_zUfiSms_Date *date
)
{
    UINT8 tmp;

    if (NULL == date)
    {
        return NULL;
    }
    /* Convert BCDs to strings */
    *res_ptr++ = '"';
    tmp = zte_wms_time.year;
    res_ptr = zUfiSms_SmsiUtilitoaFill( (tmp & 0x0F) + ((tmp >> 4) * 10),
                                           res_ptr );
    zUfiSms_SprintfTime(date->year, sizeof(date->year),zte_wms_time.year);
    *res_ptr++ = '/';
    tmp = zte_wms_time.month;
    res_ptr = zUfiSms_SmsiUtilitoaFill( (tmp & 0x0F) + ((tmp >> 4) * 10),
                                           res_ptr );
    zUfiSms_SprintfTime(date->month, sizeof(date->month),zte_wms_time.month);
    *res_ptr++ = '/';
    tmp = zte_wms_time.day;
    res_ptr = zUfiSms_SmsiUtilitoaFill( (tmp & 0x0F) + ((tmp >> 4) * 10),
                                           res_ptr);
    zUfiSms_SprintfTime(date->day, sizeof(date->day),zte_wms_time.day);
    *res_ptr++ = ',';
    tmp = zte_wms_time.hour;
    res_ptr = zUfiSms_SmsiUtilitoaFill( (tmp & 0x0F) + ((tmp >> 4) * 10),
                                           res_ptr);
    zUfiSms_SprintfTime(date->hour, sizeof(date->hour),zte_wms_time.hour);
    *res_ptr++ = ':';
    tmp = zte_wms_time.minute;
    res_ptr = zUfiSms_SmsiUtilitoaFill( (tmp & 0x0F) + ((tmp >> 4) * 10),
                                           res_ptr);
    zUfiSms_SprintfTime(date->min,  sizeof(date->min),zte_wms_time.minute);
    *res_ptr++ = ':';
    tmp = zte_wms_time.second;
    res_ptr = zUfiSms_SmsiUtilitoaFill( (tmp & 0x0F) + ((tmp >> 4) * 10),
                                           res_ptr);
    zUfiSms_SprintfTime(date->sec, sizeof(date->sec),zte_wms_time.second);

    if( zte_wms_time.timezone < 0 )
    {
        *res_ptr++ = '-';
        tmp = (UINT8)(zte_wms_time.timezone * (-1));
        snprintf(date->timezone, sizeof(date->timezone),"-%d", -1 * zte_wms_time.timezone);
    }
    else
    {
        *res_ptr++ = '+';
        tmp = (UINT8)zte_wms_time.timezone;
        snprintf(date->timezone, sizeof(date->timezone),"+%d", zte_wms_time.timezone);
    }
    res_ptr = zUfiSms_SmsiUtilitoaFill( tmp, res_ptr);
    *res_ptr++ = '"';

    return res_ptr;
}

T_zUfiSms_CmdStatus zUfiSms_HandleReport( unsigned char* ptPduData)
{
    T_zUfiSms_RawTsData tRawTsData;
    T_zUfiSms_ClientTsData tClientTsData;
    int iReportStatus = 0;
    unsigned char acDeliverNumber[ZTE_WMS_ADDRESS_LEN_MAX + 1];
    unsigned char tTpScts[ZTE_WMS_TP_SCTS_LEN_MAX + 1];
    T_zUfiSms_Date tSmsDate;
    char acRecFlag[5] = {0};
    int iRpCount = 0;
    char tmp[10];
	int tmp_i = 0;
    unsigned int pos = 0;

    if(NULL == ptPduData)
    {
        return WMS_CMD_FAILED;
    }
    memset(acDeliverNumber,0,sizeof(acDeliverNumber));
    memset(&tSmsDate,0,sizeof(T_zUfiSms_Date));
    memset(tTpScts,0,sizeof(tTpScts));
    memset(&tRawTsData,0,sizeof(T_zUfiSms_RawTsData));
    memset(&tClientTsData,0,sizeof(T_zUfiSms_ClientTsData));

    snprintf(tmp,sizeof(tmp),"%X",ptPduData[0]);
	tmp_i = atoi(tmp);
	if(tmp_i < 0 || tmp_i > INT_MAX-1) { //kw 3
		at_print(LOG_ERR,"[SMS]ptPduData err:%d\n", tmp_i);
		return WMS_CMD_FAILED;
	}
    pos = tmp_i + 1;
	if (pos >= ZSMS_PDU_SIZE) {//klocwork,//from AE
        return WMS_CMD_FAILED;
    }

    memcpy((void*)tRawTsData.data,(void*)(ptPduData + pos),sizeof(tRawTsData.data));
    tRawTsData.tpdu_type = zUfiSms_GetTpduType(ptPduData + pos);
    tRawTsData.format = WMS_FORMAT_GW_PP;
    (void)wms_ts_decode(&tRawTsData,&tClientTsData);
    if(WMS_TPDU_STATUS_REPORT != tClientTsData.u.gw_pp.tpdu_type)
    {
        at_print(LOG_ERR,"does not gw/wcdma sms report status.");
        return WMS_CMD_FAILED;
    }
    /*write sms report status:0:did not received report ,1:success,2:failed,3:unkown status */
    switch(tClientTsData.u.gw_pp.u.status_report.tp_status)
    {
        case WMS_TP_STATUS_RECEIVED_OK:
        case WMS_TP_STATUS_UNABLE_TO_CONFIRM_DELIVERY:
        case WMS_TP_STATUS_REPLACED:
        {
            iReportStatus = 1;
            break;
        }
        case WMS_TP_STATUS_TRYING_CONGESTION:
        case WMS_TP_STATUS_TRYING_SME_BUSY:
        case WMS_TP_STATUS_TRYING_NO_RESPONSE_FROM_SME:
        case WMS_TP_STATUS_TRYING_SERVICE_REJECTED:
        case WMS_TP_STATUS_TRYING_QOS_NOT_AVAILABLE:
        case WMS_TP_STATUS_TRYING_SME_ERROR:
        {
            iReportStatus = 3;
            break;
        }
        default:
        {
            iReportStatus = 2;
            break;
        }
    }

    zUfiSms_FormatDeliverNumber(tClientTsData.u.gw_pp.u.status_report.address, acDeliverNumber);
    (void)zUfiSms_UtilTimeStamp(tClientTsData.u.gw_pp.u.status_report.timestamp,tTpScts, &tSmsDate);
    if(ZUFI_FAIL == zUfiSms_InsertReportStatusToDb(acDeliverNumber,&tSmsDate,iReportStatus))
    {
        at_print(LOG_ERR,"update sms report status failed.");
        return WMS_CMD_FAILED;
    }
    memset(acRecFlag,0,sizeof(acRecFlag));
    sc_cfg_get(ZTE_WMS_NVCONFIG_SMS_REPORT,acRecFlag,sizeof(acRecFlag));
    iRpCount = atoi(acRecFlag);
	if(iRpCount < 0 || iRpCount > INT_MAX-1) { //kw 3
		at_print(LOG_ERR,"[SMS]iRpCount err:%d\n", iRpCount);
		return WMS_CMD_FAILED;
	}
    memset(acRecFlag,0,sizeof(acRecFlag));
    snprintf(acRecFlag,sizeof(acRecFlag),"%d",iRpCount + 1);
    sc_cfg_set(ZTE_WMS_NVCONFIG_SMS_REPORT, acRecFlag);
    
    return WMS_CMD_SUCCESS;
}


void zUfiSms_DelModemSms(int in_index)
{
#if 0 //zhangfen platform 20170210
    char StrValue[10] = {0};    
    printf("[SMS] zUfiSms_DelModemSms fun used!!!!!!!!!!!!!!!!!!!!!!!!!\n");
	snat_print(LOG_DEBUGStrValue,sizeof(StrValue),"%d",in_index);
    //atBase_SendMsgToSelf(ZAT_CMGD_CMD, StrValue, (UINT16)strlen(StrValue));
    zSvr_InnerSendMsg(ZUFI_MODULE_ID_AT_LOCAL,ZUFI_MODULE_ID_AT_UNSOLI,MSG_CMD_AT_DEL_SIM_SMS,strlen(StrValue),StrValue);
#endif
	int atRes = 0;
   
    atRes = zSms_SendCmgdReq(in_index);
    if(atRes == ZSMS_RESULT_OK)
    {
        zSms_RecvCmgdOk();
    }
    else
    {
        zSms_RecvCmgdErr();
    }
    zSms_RecvCmgdFinish();
}

VOID zUfiSms_getModifyInfo(T_zUfiSms_ModifyFlag *ptModifyBuff)
{
    int i = 0;

    memset(&g_zUfiSms_modifyMsg, 0, sizeof(T_zUfiSms_ModifySms));

    for(i = 0; i < ptModifyBuff->total_id; i++)
    {
        g_zUfiSms_modifyMsg.sim_id[g_zUfiSms_modifyMsg.sim_count] = ptModifyBuff->id[i];
        g_zUfiSms_modifyMsg.sim_count++;
        g_zUfiSms_modifyMsg.sim_index_count++;
    }
}


/** ͳƿеδ */
int zUfiSms_GetUnreadSmsIndexInSim()
{
    char str_index[128] = {0};
    int index = 0;
    int is_cc = 0;
    int iSmsId = 0;
    T_zUfiSms_ModifyTag tModifyInfo = {0};
	char StrValue[10] = {0};
	
    memset(&tModifyInfo,0,sizeof(T_zUfiSms_ModifyTag));
    iSmsId = g_zUfiSms_modifyMsg.sim_id[g_zUfiSms_modifyMsg.sim_index];
    if(-1 == (is_cc = zUfiSms_IsConcatSms(iSmsId)))
    {
        at_print(LOG_ERR,"check concat failed.");
        return ZUFI_FAIL;
    }
	
    printf("[SMS] zUfiSms_GetUnreadSmsIndexInSim is_cc:%d",is_cc);
    if(1 == is_cc) 
    {
        //
        if(ZUFI_FAIL  == zUfiSms_GetSmsIndex(iSmsId,&tModifyInfo,is_cc))
        {
            return ZUFI_FAIL;
        }
        g_zUfiSms_modifyMsg.sim_index++ ;
        g_zUfiSms_modifyMsg.sim_index_count-- ;

        while(tModifyInfo.num_of_indices > 0)
        {
            index = tModifyInfo.indices[tModifyInfo.id_index];
	        g_modifyIndex.index[g_modifyIndex.total] = index;
	        g_modifyIndex.total++;
            tModifyInfo.id_index++;
            tModifyInfo.num_of_indices--;
			printf("[SMS] zUfiSms_GetUnreadSmsIndexInSim [1 == is_cc] index = %d, total=%d\n", index, g_modifyIndex.total);
        }
    }
    else 
    {
        //̶
        memset(str_index,0,sizeof(str_index));
        if(ZUFI_FAIL == zUfiSms_GetStorePosById("ind",str_index,sizeof(str_index),iSmsId))
        {
            at_print(LOG_ERR,"get index from db faild.");
            return ZUFI_FAIL;
        }
        index = atoi(str_index);
        g_modifyIndex.index[g_modifyIndex.total] = index;
	    g_modifyIndex.total++;	
        g_zUfiSms_modifyMsg.sim_index++;
        g_zUfiSms_modifyMsg.sim_index_count--;
		printf("[SMS] zUfiSms_GetUnreadSmsIndexInSim [1 != is_cc]index = %d, total=%d\n", index, g_modifyIndex.total);
    }

    return ZUFI_SUCC;
}


void zUfiSms_ModifyModemSms(T_zUfiSms_ModifyFlag *ptModifyBuff)
{
	int atRes = 0;
	char StrValue[10] = {0};
    printf("[SMS] zUfiSms_ModifyModemSms ptModifyBuff->type = %d!\n",ptModifyBuff->type);
    //cmd from ufi monitor
	//if(ptModifyBuff->type == 1)
	{
	    zUfiSms_getModifyInfo(ptModifyBuff);
		memset(&g_modifyIndex,0,sizeof(T_zUfiSms_ModifyIndexInfo));
		printf("[SMS] zUfiSms_ModifyModemSms ptModifyBuff->total_id = %d!\n",ptModifyBuff->total_id);
	    while(g_zUfiSms_modifyMsg.sim_index_count > 0)
	    {
	        if(ZUFI_FAIL == zUfiSms_GetUnreadSmsIndexInSim())
	        {
	            at_print(LOG_ERR,"delete all:%d sms failed\n",WMS_STORAGE_TYPE_UIM_V01);
	            return;
	        }
	    }
        while(g_modifyIndex.cur_index < g_modifyIndex.total)
        {           
            snprintf(StrValue,sizeof(StrValue),"%d",g_modifyIndex.index[g_modifyIndex.cur_index]);
            //atBase_SendMsgToSelf(ZAT_CMGR_CMD, StrValue, (UINT16)strlen(StrValue));
            atRes = zSms_SendCmgrReq(g_modifyIndex.index[g_modifyIndex.cur_index]);
            printf("[SMS] zUfiSms_ModifyModemSms index = %s \n", StrValue);
            g_modifyIndex.cur_index++;
        }
	}
/*    
	else //cmd from webui
	{
	    //sat_print(LOG_DEBUGStrValue,"%d",0);
		//atBase_SendMsgToSelf(ZAT_CMGL_CMD, StrValue, (UINT16)strlen(StrValue));
        atRes = atSms_SendCmglReq(ZUFI_NULL, cid, errCode, ZSVR_AT_RES_CODE_LEN);
	}
*/
}


static int zUfiSms_FormatGwDbData
(
    T_zUfiSms_ClientTsData *ts_data_ptr,
    T_zUfiSms_DbStoreData *db_data
)
{
    int result = ZUFI_SUCC;

    if((NULL == ts_data_ptr) || (NULL == db_data))
    {
        at_print(LOG_ERR,"invalid inputs.");
        return ZUFI_FAIL;
    }
    if (WMS_FORMAT_GW_PP == ts_data_ptr->format)
    {
        switch (ts_data_ptr->u.gw_pp.tpdu_type)
        {
            case WMS_TPDU_DELIVER:
            {
                result = zUfiSms_FormatDeliverDbdata(ts_data_ptr, db_data);
                break;
            }
            case WMS_TPDU_SUBMIT:
            {
                result = zUfiSms_FormatSubmitDbdata(ts_data_ptr, db_data);
                break;
            }
            default:
            {
                break;
            }
        }
    }

    return result;
}

/* ԽյĶŻ߶űн  */
int zUfiSms_DecodeSmsData
(
    T_zUfiSms_DbStoreData *pDb_Data,
    int msg_index,
    zUfiSms_StoreType iStorePos,
    T_SmsStatus bSms_Status,
    wms_message_format_enum_v01 format,
    long iPdu_Len,
    unsigned char *pPdu_Received
)
{
    T_zUfiSms_RawTsData raw_ts;
    T_zUfiSms_ClientTsData ts_data_ptr;
    char tmp[10];
	int tmp_i = 0;
    unsigned int pos = 0;
    int result = ZUFI_SUCC;

    if(NULL == pDb_Data)
    {
        return ZUFI_FAIL;
    }

    pDb_Data->mem_store = (unsigned long)iStorePos;
    pDb_Data->index = (unsigned short)msg_index;

    if(RECEIVED_UNREAD == bSms_Status) 
    {
        pDb_Data->tag = WMS_TAG_TYPE_MT_NOT_READ_V01;
    }
    else if(RECEIVED_READ == bSms_Status)
    {
        pDb_Data->tag = WMS_TAG_TYPE_MT_READ_V01;
    }
    else if(STORED_UNSEND == bSms_Status)
    {
        pDb_Data->tag = WMS_TAG_TYPE_MO_NOT_SENT_V01;
    }
    else
    {
        pDb_Data->tag = WMS_TAG_TYPE_MO_SENT_V01;
    }

    pDb_Data->mode = (unsigned short)format;

    memset(&raw_ts,0,sizeof(T_zUfiSms_RawTsData));
    memset(&ts_data_ptr,0,sizeof(wms_client_ts_data_s_type));

    //洢λ
    memset(tmp,0,sizeof(tmp));
    snprintf(tmp,sizeof(tmp),"%d",pPdu_Received[0]);
	tmp_i = atoi(tmp); //kw 3
	if(tmp_i < 0 || tmp_i > INT_MAX-1) { 
		at_print(LOG_ERR,"[SMS]pPdu_Received err:%d\n", tmp_i);
		return ZUFI_FAIL;
	}
    pos = tmp_i + 1;
	if (pos >= iPdu_Len) {//klocwork
		return ZUFI_FAIL;
	}
    raw_ts.len = iPdu_Len - pos;
    memcpy((void*)raw_ts.data, (void*)(pPdu_Received + pos), WMS_MAX_LEN);
    raw_ts.tpdu_type = zUfiSms_GetTpduType(pPdu_Received + pos);
    raw_ts.format = (WMS_MESSAGE_FORMAT_CDMA_V01 == format) ? WMS_FORMAT_CDMA : WMS_FORMAT_GW_PP;

    (void)wms_ts_decode(&raw_ts,&ts_data_ptr);
    switch(format)
    {
        case WMS_MESSAGE_FORMAT_CDMA_V01:
        {
            result = ZUFI_SUCC;
            break;
        }
        case WMS_MESSAGE_FORMAT_GW_PP_V01:
        {
            result = zUfiSms_FormatGwDbData(&ts_data_ptr, pDb_Data);
            break;
        }
        case WMS_MESSAGE_FORMAT_GW_BC_V01:
        case WMS_MESSAGE_FORMAT_MWI_V01:
        {
            result = ZUFI_FAIL;
            break;
        }
        default:
        {
            result = ZUFI_FAIL;
            break;
        }
    }
    return result;
}

T_zUfiSms_CmdStatus IsSmsLoadSuccess(void) 
{
    char IsInit[36] = {0};
    sc_cfg_get(NV_SMS_LOAD_RESULT,IsInit,sizeof(IsInit));
    if(0 == strcmp("ok", IsInit))
    {
        printf("[SMS] sms Load success!\n");
        return WMS_CMD_SUCCESS;              
    }
    else
    {
        printf("[SMS] sms Load wrong !\n"); 
        return WMS_CMD_FAILED;
    }
}

#if 0
//at_recĶԭʼݰնӦԪʽptSmsPara
int zUfiSms_FormatSms(CHAR *pSmsRawContent, int contentSize, T_zUfiSms_SmsItem *ptSmsPara, int iCmdId)
{
    //ҵ
    char* P1 = strchr(pSmsRawContent,',');
    if(NULL == P1)
    {
        return ZUFI_FAIL;
    }
    
    char* P2 = strchr((char*)(P1+1),',');
    if(NULL == P2) 
    {
        return ZUFI_FAIL;
    }
    char* P3 = strchr((char*)(P2+1),',');
    
    /* Ԥ */
    atBase_PreProcRes(pSmsRawContent,contentSize);
    // cgmlϱ
    if (1 == iCmdId)  
    {
	    if (P3==P2+1) // when the reserved segment is null, cmgl is like as: 1,1,,160,"0891...." 
	    {   
	        sscanf(pSmsRawContent,"%d %d %d ", &ptSmsPara->index, &ptSmsPara->stat,&ptSmsPara->length);
	    }
	    else // when the reserved segment is not null, the cmgl is like as: 1,1,"xxx",160,"0891...." 
	    {                   
	        sscanf(pSmsRawContent,"%d %d %32s %d ", &ptSmsPara->index, &ptSmsPara->stat, ptSmsPara->alpha, &ptSmsPara->length);
	    }                   
    }
	else if(2 == iCmdId)// cgmrϱ
	{
	 	if (P2 == P1+1) // when the reserved segment is null, cmgr is like as: +cmgr:1,,68
	    {   
	        sscanf(pSmsRawContent,"%d %d ", &ptSmsPara->stat,&ptSmsPara->length);
	    }
	    else // when the reserved segment is not null, the cmgr is like as: +cmgr:1,"xxx",68 
	    {                   
	        sscanf(pSmsRawContent,"%d %32s %d ", &ptSmsPara->stat, ptSmsPara->alpha, &ptSmsPara->length);
	    }    
	}
    /* ַָ */
    atBase_RestoreString(ptSmsPara->alpha);
    atBase_RestoreString(ptSmsPara->pdu);
	return ZUFI_SUCC;
}
#endif
void zUfiSms_CmglRespProc(T_zSms_SmsInd *pSmsItem)
{       
    T_zUfiSms_CmdStatus result = WMS_CMD_PROCESSING;
    T_zUfiSms_DbStoreData db_data = {0};
    zUfiSms_StoreType mem_store = WMS_STORAGE_TYPE_UIM_V01;
    unsigned char  pdu_tmp[ZSMS_PDU_SIZE]={0};
    int total_count = 0;
    int sim_capability = 0;
	
	printf("[SMS] Enter zUfiSms_CmglRespProc! index:%d/stat:%d/length:%d!\n", pSmsItem->index,pSmsItem->stat,pSmsItem->length);
	printf("[SMS] pdu data_len:%d, str:%s!\n", strlen(pSmsItem->pdu),pSmsItem->pdu);

    //ת
    memset(&db_data, 0, sizeof(db_data));                   
    memset(pdu_tmp, 0, sizeof(pdu_tmp));                   
    (void)String2Bytes(pSmsItem->pdu, pdu_tmp, (int)strlen(pSmsItem->pdu));

    //TSP_MODEL ʹоƬʱĺ꣬оƬͨоƬ
#if 1//defined (TSP_MODEL)
    zUfiSms_GetReportStatus(pSmsItem->pdu, &pSmsItem->stat);
    if(5 == pSmsItem->stat)
    {   
 	    printf("[SMS] Enter pSmsItem->stat == 5\n");
        (void)zUfiSms_HandleReport(pdu_tmp);
        zUfiSms_DelModemSms(pSmsItem->index);  
        return;
    } 
#endif
		
	#if 1//corem
	printf("****undecode:%s\n", pdu_tmp);
	#endif
    (void)zUfiSms_DecodeSmsData(&db_data,pSmsItem->index, mem_store,(T_SmsStatus)pSmsItem->stat,
            WMS_MESSAGE_FORMAT_GW_PP_V01, pSmsItem->length, pdu_tmp);

	#if 1//corem
	printf("****decodeed:%s\n", db_data.sms_content);
	#endif
    (void)zUfiSms_WriteSmsToDb(&db_data,mem_store,-1);
    //if(WMS_STORAGE_TYPE_NV_V01 == mem_store)
    {
        //zUfiSms_DelModemSms(pSmsItem->index);    ʱ
    }
    
#if 1//defined (TSP_MODEL)
    if(SMS_LOCATION_SIM == g_zUfiSms_CurLocation)
    {
        CHAR simCapability[50]={0};
        sc_cfg_get(ZTE_WMS_NVCONFIG_SIM_CAPABILITY,simCapability,sizeof(simCapability));
        sim_capability = atoi(simCapability);
        (void)zUfiSms_GetTotalCount(ZTE_WMS_DB_SIM_TABLE, &total_count);
        if(total_count == sim_capability )
        {
            zUfiSms_DelModemSms(pSmsItem->index);  
        }
    }
#endif
}
/*******************************
̳ʼ  
********************************/
void zUfiSms_InitDb(void)
{
    if(ZUFI_FAIL == zUfiSms_CheckStoreDir())
    {
        printf("[SMS] zUfiSms_CheckstoreDir failed.\n");
        return;
    }
#ifdef WEBS_SECURITY
	if(access(ZTE_WMS_DB_PATH, F_OK) != 0)
	{
		if((access(ZTE_WMS_TMP1_PATH, F_OK) == 0)&&(access(ZTE_WMS_SEC_PATH, F_OK) != 0))
		{
			if(rename(ZTE_WMS_TMP1_PATH, ZTE_WMS_SEC_PATH) != 0)
			{
				printf("[SMS] WMS_TMP1_PATH failed.\n");
			}
		}
		if((access(ZTE_WMS_TMP0_PATH, F_OK) == 0)&&(access(ZTE_WMS_SEC_PATH, F_OK) != 0))
		{
			if(rename(ZTE_WMS_TMP0_PATH, ZTE_WMS_SEC_PATH) != 0)
			{
				printf("[SMS] WMS_TMP0_PATH failed.\n");
			}
		}
		if(access(ZTE_WMS_SEC_PATH, F_OK) == 0)
		{
			char rnum_buf[24] = {0};
			char cmd[128] = {0};
			
			sc_cfg_get("rnum_at", rnum_buf, sizeof(rnum_buf));
			snprintf(cmd, sizeof(cmd), "/bin/openssl enc -d -aes256 -salt -in %s -out %s -pass pass:%s", ZTE_WMS_SEC_PATH, ZTE_WMS_DB_PATH, rnum_buf);
			zxic_system(cmd);
		}
	}
#endif		
	if(ZUFI_FAIL == zUfiSms_CheckSmsDb())//жļǷ 
    {
        zUfiSms_GetDefaultCfgPara();//get default parameter from config file
    }
    /*create all the needed sms database*/
    if(ZUFI_SUCC != zUfiSms_CreateAllTable())
    {
        printf("[SMS] zUfiSms_CreateAllTable failed\n");
        return;
    }
	
    /*load sms parameters*/
    if(ZUFI_SUCC != zUfiSms_LoadSmsPara())
    {
        zUfiSms_GetDefaultPara();
    }
    /*check nv memory full or not?*/
    (void)zUfiSms_CheckMemoryFull(ZTE_WMS_MEMORY_NV);

    zUfiSms_SendSmsStatusInfo(MSG_SMS_DEFAULT);
	
    g_zUfiSms_MsgRefer = zUfiSms_GetSmsMaxReferInDb();
    g_zUfiSms_ConcatSmsReference = zUfiSms_GetConcatMaxReferInDb();
}
//豸洢smsȳʼ
void zUfiSms_CfgSmsNvInit(void)
{
    char tmp[10]={0};

    sc_cfg_set(NV_SMS_STORE,"");
    sc_cfg_set(NV_SMS_LOAD_RESULT,"");//mengyuan add on 20100302 for sms
    sc_cfg_set(ZTE_WMS_NVCONFIG_RECEVIED,"");
    sc_cfg_set(NV_SMS_CENTER_NUM,"");

    snprintf(tmp,sizeof(tmp),"%d",ZTE_WMS_DB_MSG_COUNT_MAX);
    sc_cfg_set(ZTE_WMS_NVCONFIG_NV_CAPABILITY, tmp);/*lint  !e534*/
}

VOID zUfiSms_InitCmdStatus(T_zUfiSms_StatusInfo *pStatusInfo,T_zUfiSms_CmdType iCmdId)
{
    memset((void*)pStatusInfo,0,sizeof(T_zUfiSms_StatusInfo));
    pStatusInfo->cmd = iCmdId;
    pStatusInfo->cmd_status = WMS_CMD_PROCESSING;
    pStatusInfo->err_code = ZTE_SMS_CMS_NONE;
    pStatusInfo->send_failed_count = 0;
    pStatusInfo->delete_failed_count = 0;
    (void)zUfiSms_SetCmdStatus(pStatusInfo);
}

void zUfiSms_CfgInit(void)
{
    char tmp[10]={0};
    
    sc_cfg_set(NV_SMS_STATE,"");/*lint  !e534*/
    sc_cfg_set(ZTE_WMS_NVCONFIG_RECEVIED,"");/*lint  !e534*/
    sc_cfg_set(NV_SMS_LOAD_RESULT, "");/*lint  !e534*/
    sc_cfg_set(NV_SMS_RECV_RESULT, "");/*lint  !e534*/

    snprintf(tmp,sizeof(tmp),"%d",ZTE_WMS_DB_MSG_COUNT_MAX);
    sc_cfg_set(ZTE_WMS_NVCONFIG_NV_CAPABILITY, tmp);/*lint  !e534*/
    sc_cfg_set(ZTE_WMS_NVCONFIG_SIM_CAPABILITY,"");/*lint  !e534*/
    sc_cfg_set(ZTE_WMS_NVCONFIG_SMS_REPORT, "");/*lint  !e534*/
    sc_cfg_set(NV_SMS_DB_CHANGE,"1");
    sc_cfg_set(NV_SMS_CENTER_NUM,"");
}

int zUfiSms_IsUnreadSms(T_zUfiSms_MemoryType mem_store)
{
	int total_count = 0;
    char buf[20] = {0};
    
	//ѯδŵ
	if(ZUFI_FAIL == zUfiSms_GetTagCountInDb(mem_store,WMS_TAG_TYPE_MT_NOT_READ_V01,&total_count))
	{
		return FALSE;
	}
    
    sprintf(buf,"%d", total_count);
    sc_cfg_set("sms_unread_count", buf);
    
	if(0 == total_count)
	{
		return FALSE;
	}
	else
	{
		return TRUE;
	}	
}

VOID zUfiSms_SendSmsStatusInfo(wms_message_status_info sms_op)
{
    T_zUfi_SmsStatusInfoInd ind = {0};
	
	CHAR temp[50]  = {0};
	
	if(sms_op == MSG_SMS_NEW)
	{
		ind.sms_new_ind = 1;
	}
	if(sms_op == MSG_SMS_READING)
	{
		ind.sms_is_reading = 1;
	}
    /*check nv unread sms or not?*/
	if(zUfiSms_IsUnreadSms(ZTE_WMS_MEMORY_NV))
	{
		ind.sms_unread_ind = 1;
	}
	else
	{
	    ind.sms_unread_ind = 0;
	}

	sc_cfg_get("sms_unread_count",temp,sizeof(temp));

    ind.sms_unread_count = atoi(temp);
    //ind.sms_memory_full_ind = (UINT8)g_zUfiSms_MemFullFlag[WMS_STORAGE_TYPE_NV_V01];
    if((g_zUfiSms_MemFullFlag[WMS_STORAGE_TYPE_NV_V01] == TRUE) || (g_zUfiSms_MemFullFlag[WMS_STORAGE_TYPE_UIM_V01] == TRUE))
    {
		ind.sms_memory_full_ind = 1;
	}
	else
	{
		ind.sms_memory_full_ind = 0;
	}
	printf("[SMS] zUfiSms_SendSmsStatusInfo unread = %d, full=%d, new=%d, reading=%d\n",ind.sms_unread_ind,ind.sms_memory_full_ind, ind.sms_new_ind, ind.sms_is_reading);
	
	ipc_send_message(MODULE_ID_SMS, MODULE_ID_MMI, MSG_CMD_SMS_STATUS_INFO_IND, sizeof(T_zUfi_SmsStatusInfoInd), &ind, 0);

	if(ind.sms_memory_full_ind == 1)
	{
	    sc_cfg_set(NV_SMS_INIT_STATUS,"sms_memory_full");
	}
	else if(ind.sms_unread_ind == 1)
	{
	    sc_cfg_set(NV_SMS_INIT_STATUS,"sms_unread");
	}
	else
	{
	    sc_cfg_set(NV_SMS_INIT_STATUS,"sms_normal");
	}
    return;
}

VOID BakNotificationSms(char * pushSms,int pushSmsLen)
{
    FILE   *fp = NULL;
    int    len;

    fp = fopen("/usr/dm/fota_push_msg.data", "w+");
    if(fp == NULL)
    {
        printf("[SMS] BakNotificationSms fopen error\n");
        at_print(LOG_ERR,"fopen( /usr/dm/fota_push_msg.data , 'w+') error!");
        return;
    }

    len = fwrite(pushSms,1,pushSmsLen,fp);  //ʵдĳ
    if(len==pushSmsLen)
    {
        printf("[SMS] BakNotificationSms write to Notificationbak file OK, len=%d \n", len);
        printf("write to Notificationbak file OK, len=%d!",len);
        fclose(fp);
        return;
    }
    else
    {
        printf("[SMS] BakNotificationSms write to Notificationbak file faild, len=%d \n", len);
        printf("write to Notificationbak file faild, len=%d!",len);
        fclose(fp);
        return;
    }
}



