#ifndef STA_MANAGER_H
#define STA_MANAGER_H

#include "wlan_sm.h"

#define  SUCCESS  "1"
#define  FAILED   "0"
#define REPLY_BUF_SIZE 4096 // wpa_supplicant's maximum size.

#define WIFI_STATION_TIMER_SCAN           111
#define WIFI_STATION_TIMER_SCAN_INTERVAL  60000  /// 10 ----> 15s nxl

#define WIFI_STATION_CMD_LEN    256
#define WIFI_STATION_SCRIPT_RSP_LINE_LEN     1024

//ɨ
#define WIFI_STATION_SCAN_RESULT_STR_LEN    1024
#define WIFI_STATION_SCAN_ONE_RESULT_STR_LEN    256
#define WIFI_STATION_SCAN_RESULT_LIST_NUM    60//һʵʹ̼ɨ30ϵͳܴ洢ɨ಻2048ֽ
#define WIFI_STATION_FLAGS_LEN    128


#define WIFI_STATION_SIGNAL_LEVEL1  -80
#define WIFI_STATION_SIGNAL_LEVEL2  -78
#define WIFI_STATION_SIGNAL_LEVEL3  -75
#define WIFI_STATION_SIGNAL_LEVEL4  -72

#define WIFI_STATION_CHANNEL1  2412
#define WIFI_STATION_CHANNEL2  2417
#define WIFI_STATION_CHANNEL3  2422
#define WIFI_STATION_CHANNEL4  2427
#define WIFI_STATION_CHANNEL5  2432
#define WIFI_STATION_CHANNEL6  2437
#define WIFI_STATION_CHANNEL7  2442
#define WIFI_STATION_CHANNEL8  2447
#define WIFI_STATION_CHANNEL9  2452
#define WIFI_STATION_CHANNEL10  2457
#define WIFI_STATION_CHANNEL11  2462
#define WIFI_STATION_CHANNEL12  2467
#define WIFI_STATION_CHANNEL13  2472

#define WIFI_STATION_SPOT_LEN  256
#define WIFI_STATION_SPOT_LIST_NUM  10

#define WIFI_STATION_SCAN_RESULT_PARSE_IGNORE  "bssid / frequency /"

#define WIFI_STATION_AUTH_WPA_PSK  "WPA-PSK"
#define WIFI_STATION_AUTH_WPA2_PSK  "WPA2-PSK"
#define WIFI_STATION_AUTH_WPA_EAP  "WPA-EAP"
#define WIFI_STATION_AUTH_WPA2_EAP "WPA2-EAP"
#define WIFI_STATION_AUTH_SHARED  "SHARED"
#define WIFI_STATION_ENCRYPT_CCMP  "CCMP"
#define WIFI_STATION_ENCRYPT_TKIP  "TKIP"
#define WIFI_STATION_ENCRYPT_WEP  "WEP"

#define WIFI_STATION_PROFILE_AUTH_WPA_PSK  "WPAPSK"
#define WIFI_STATION_PROFILE_AUTH_WPA2_PSK  "WPA2PSK"
//#define WIFI_STATION_PROFILE_AUTH_WPA_EAP  "WPAEAP"
//#define WIFI_STATION_PROFILE_AUTH_WPA2_EAP  "WPA2EAP"
#define WIFI_STATION_PROFILE_AUTH_WPA_EAP "EAP-SIM/AKA"
#define WIFI_STATION_PROFILE_AUTH_SHARED  "SHARED"
#define WIFI_STATION_PROFILE_ENCRYPT_WEP  "WEP"
#define WIFI_STATION_PROFILE_ENCRYPT_CCMP  "CCMP"
#define WIFI_STATION_PROFILE_ENCRYPT_TKIP  "TKIP"


#define NV_WIFI_ENABLED		"wifiEnabled"
#define INVALID_NETWORK_ID  -1
#define safe_free(x) do { if(x) {free(x); x=NULL;} } while(0)
#define WPA_CLI "wpa_cli -p"ROOT_DIR"/wifi/wpa_supplicant -iwlan0-vxd"





typedef struct {
	char  mac[WIFI_STATION_MAC_LEN];
	char  ssid[WIFI_STATION_SSID_LEN];
	char  password[WIFI_STATION_SPOT_PASSWORD_LEN];
}connect_ssid_t;


typedef void (*sta_sm_handler_t)(wlan_sm_event_t evt, void * data);

typedef enum{
	DISCONNECT_AUTO,
	DISCONNECT_MANUAL,
}disconnect_type_t;

typedef enum{
	CONNECT_AUTO,
	CONNECT_MANUAL,
}connect_type_t;


#define  DHCP_RETRY_TIMES		3
#define  CONN_RETRY_TIMES		3

typedef struct {
	int list_id;// g_spot_list  id
	int linked_id;
	char linking_mac[WIFI_STATION_MAC_LEN];
	int conn_status;
	disconnect_type_t  disc_type;
	connect_type_t  conn_type;
	wlan_sm_handle_t sm_handle;
	int spots_num;
	int scan_spot_num;
	int dhcp_retry_times;
	int conn_retry_times;
	int disable_others;
	int softtimer;
}wlan_sta_handle_t;

typedef struct {
	int id;
	int auth_failures;
	int wrong_key;
	int conn_failed;
	int auth_failed;
}tmp_disabled_t;

typedef struct {
	char  mac[WIFI_STATION_MAC_LEN] ;
	char  ssid[WIFI_STATION_SSID_LEN];
}try_assoc_t;


typedef struct {
	int   id;
	char  mac[WIFI_STATION_MAC_LEN] ;
}sup_connected_t;


typedef struct {
	wlan_sm_event_t evt;
	char data[512];
}supplicant_evt_t;

void  wlan_statemachine_init();
int wlan_sta_parse_msg (MSG_BUF *pMsg);
void  wlan_station_open();
void *station_loop (void *param);

#endif
