/*****************************************************************************
*  汾 (C)ͨѶɷ޹˾
*  ģ    MMI
*  ļ    mmi_adapter.c
*  ļʶ  
*  ļ  
*  ʵֹ  MMI䣬 䲻ͬϵͳ
*        
*  汾      V1.0
*    2014-12-24
*  ˵  
*
******************************************************************************/

/*****************************************************************************
 ͷļ
******************************************************************************/
#include "mmi_common.h"

#ifndef DISABLE_LCD
#include "zcore_threads.h"
#include "zcore_fileop.h"
#endif

struct mmi_queue {
	struct list_head list;
	int id;
};

/**********************************************************************************
:Mutex
***********************************************************************************/

int mmi_getMutex(pthread_mutex_t *mutex_id)
{
	return pthread_mutex_lock(mutex_id);
}

int mmi_putMutex(pthread_mutex_t *mutex_id)
{
	return pthread_mutex_unlock(mutex_id);
}



/**********************************************************************************
:Semaphore
***********************************************************************************/

int mmi_PutSemaphore(sem_t *sem)
{
	return sem_post(sem);
}

int mmi_GetSemaphore(sem_t *sem, UINT32 timeout)
{
	return sem_wait(sem);
}

int mmi_GetSemaphoreEintr(sem_t *sem, UINT32 timeout)
{
    int ret = -1;
    while ( MMI_SUCCESS != (ret = sem_wait(sem)) ) {
			if (EINTR == errno) {
                slog(MMI_PRINT, SLOG_DEBUG, "mmi_GetSemaphore failed,errno=%d\n",errno);
			    continue;
			}
            else {
                slog(MMI_PRINT, SLOG_ERR, "mmi_GetSemaphore failed,errno=%d\n",errno);
                return -1;
            }
	}
    
    return MMI_SUCCESS; 
}

int mmi_DeleteSemaphore(sem_t *sem)
{
	return sem_destroy(sem);
}


/**********************************************************************************
:Sleep
***********************************************************************************/

VOID mmi_sleep(UINT32 time_in_ms)
{
	sleep(time_in_ms / 1000);
}

void mmi_add_list(struct list_head *head, int src_id)
{
	struct mmi_queue *tmp = NULL, *item = NULL;

	slog(NET_PRINT, SLOG_DEBUG, "mmi_add_list start, src_id:0x%x!!!\n", src_id);

	list_for_each_entry(tmp, head, list) {
		//͸target_idģϢѾ¼
		if (tmp->id == src_id) {
			slog(NET_PRINT, SLOG_ERR, "mmi_add_list src_id:0x%x alread existed! \n", src_id);
			return;
		}
	}

	item = malloc(sizeof(struct mmi_queue));
	if (item == NULL) {
		slog(NET_PRINT, SLOG_ERR, "mmi_add_list src_id:0x%x malloc failed! \n", src_id);
		return;
	}

	INIT_LIST_HEAD(&item->list);
	item->id = src_id;
	list_add_tail(&item->list, head);

	slog(NET_PRINT, SLOG_NORMAL, "mmi_add_list src_id:0x%x success !!!\n", src_id);
}

void mmi_del_list(struct list_head *head, int src_id)
{
	struct mmi_queue *tmp = NULL, *item = NULL;

	slog(NET_PRINT, SLOG_DEBUG, "mmi_del_list start, id:0x%x!!!\n", src_id);

	list_for_each_entry(tmp, head, list) {
		if (tmp->id == src_id) {
			slog(NET_PRINT, SLOG_NORMAL, "mmi_del_list id = 0x%x\n", src_id);
			list_del(&tmp->list);
			free(tmp);
			break;
		}
	}
	slog(NET_PRINT, SLOG_DEBUG, "mmi_del_list success !!!\n");
}

