//#include "at_com.h"
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <ctype.h>
#include <errno.h>
#include <sys/types.h>
#include <sys/wait.h>
#include <sys/msg.h>
#include "at_api.h"

#define AT_PARAM_MAX_NUM 50
#define RESEND_TIMES_MAX 3

//øýӿڷϱַԶоƬ
int send_rsp_str_to_modem(int      module_id, char *rsp_cmd,int rsp_len)
{
	return at_send_msg(module_id, MODULE_ID_AT_CLIENT, MSG_CMD_SEND_RSP_TO_ZTE, rsp_len, rsp_cmd, 0);
}

//ȡATǰ׺
static void get_at_req_prefix(char *at_str, char** at_prefix)
{
	char *prefix = NULL;	
    char *pszAtHead = NULL;	
    char *ptemstr = NULL;
	
	if((*at_str == 'A'||*at_str == 'a')&&(*(at_str+1) == 'T'||*(at_str+1) == 't'))
    {
        if(isalpha(*(at_str+2)))
        {
            *at_prefix = NULL;
        }
		else
		{
			prefix = (char*)malloc(50);
			if(prefix == NULL) at_assert(0);
			memset(prefix, 0x00, 50);
	
			pszAtHead = at_str;
			//ҵ׸ĸֵĲ+
			for(; *at_str != '\0'; at_str++)
			{
			   if(!(isalnum(*at_str) || *at_str == '\r' || *at_str == '\n'))
			   {
				   pszAtHead = at_str;
				   pszAtHead++;
				   break;
			   }
			}

			for(ptemstr = pszAtHead; *ptemstr != '\0'; ptemstr++)
			{
				if(*ptemstr == '=' || *ptemstr == '?' || *ptemstr == '\r')
				{
					memcpy(prefix, pszAtHead, ptemstr-pszAtHead); 
					*at_prefix = prefix;
					return;
				}
			}
		}
    }
	else
	{
		at_assert(0);
	}

}

static int is_print_str(const char *str){
    while(isprint(*str)){
        str++;
    }
    return *str == '\0';
}

static int get_fmt_param_count(const char *str){
    int fmt_param_count = 0;
    
    for(; *str != '\0'; str++){
        if(*str == ','){
            fmt_param_count++;
        }
    }
    return fmt_param_count + 1;
}



/*return 0ʾڲϸĲ飬һԼ飬ڿѡҪп*/
static int  parse_param_safe(char *fmt, char *buf, void **pval)
{
	char *p;
    char *sepp; 
    char *tmp;
	char sepc;
	char *pstr[AT_PARAM_MAX_NUM] = {0};
	int  len, flag;
	int  n   = 0;
	int  nparam = 0;//bufַʵʵĲ
	int  fmt_param_num = 0;//fmtʽҪĲܸ%һ
	int  ret  = AT_PARSE_OK;
	int  mark_flag = 0;//ڱʶŵĿǰ˫
	
    while(*buf == ' ') buf++;
	len = strlen(buf) + 1;
	tmp = p = (char*)malloc(len);
	if (p == NULL) {
		return ATERR_NO_PRINT;
	}
	//fmt_param_num = find_char_num(fmt,"%");
	memset(p, 0, len);
	//ڴεATԱζ
	memcpy(p, buf, strlen(buf));
    /*ȥβ\r\nĿǰ7100д */
    for(len--; len > 0; len--){
        if(p[len - 1] == '\r' || p[len - 1] == '\n'){
            p[len - 1] = '\0';
        } else {
            break;
        }
    }
    if(!is_print_str(p)){/* ATаɼֱַӷش */
        free(tmp);
		return ATERR_NO_PRINT;
    }
    /*Žÿķָ,˫Ķ*/
	do {
		flag = 0;
		mark_flag = 0;
		if (*p == '"') {
			int i, j;
			for (i = j = 0, ++p; p[j] != '\0'; i++, j++) {
				if (p[j] == '"') {
					++j;
					mark_flag = 1;
					break;
				}
			}
			if(mark_flag == 0){/* δƥ䵽˫ֱӷش */
				free(tmp);
				return ATERR_DROP_MARK;
			}
			if (j == 1) flag = 1;
			p[j - 1] = '\0';
			sepp = p + j;
		} else {
			sepp = p + strcspn(p, ",");
			if (p == sepp) flag = 1;
		}

		nparam++;
		sepc = sepp[0];
		sepp[0] = '\0';

		if (flag == 1)
			pstr[n++] = NULL;
		else
			pstr[n++] = p;
		p = sepp + 1;
	} while ((n < AT_PARAM_MAX_NUM) && (sepc == ','));

    if(nparam < get_fmt_param_count(fmt)){
		ret = ATWARN_DROP_RN;    
	}else if(nparam > get_fmt_param_count(fmt)){
		ret = ATWARN_LACK_PARAM;    
	}
    /* convert the string params to the types that fmt Appointed */
    int param_count = 0; /*ַЧ*/
    int param_str_index = 0; /* the index of string params */
    int param_val_index = 0; /* the index of param values  */
	//θʽÿֵķظֵ
    for (; fmt !=  NULL && param_str_index < nparam; param_str_index++) {
        char type;
        unsigned int  size;
        char str_param_size[10] = { 0 };
        int  param_size_index  = 0;

        while(*fmt == ' ') fmt++;
        if(*fmt == ','){
            fmt++;
            continue;  /* igmore the param that is without type */
        }
        if(*fmt++ != '%'){
             ret = ATERR_NO_PRINT;
             break;
        }
        for (; param_size_index < sizeof(str_param_size) - 1; fmt++, param_size_index++){
            if(!isdigit(*fmt)){
                break;
            }
            str_param_size[param_size_index] = *fmt;
        }
        type = *(fmt++);
        size = atoi(str_param_size);
        while(*fmt == ' ') fmt++; /* igmore the blanks */
        fmt = (*fmt == ',' ? fmt + 1 : NULL);

        if (type == 'd') {
            if(size == 0 || size == 4) {
                if(pstr[param_str_index] != NULL) {
                    *((int *)pval[param_val_index]) = (int)atoi(pstr[param_str_index]);
                    param_count++;
                }
            } else if(size == 1) {
                if(pstr[param_str_index] != NULL) {
                    *((char *)pval[param_val_index]) = (char)atoi(pstr[param_str_index]);
                    param_count++;
                }
            } else if(size == 2) {
                if(pstr[param_str_index] != NULL) {
                    *((short *)pval[param_val_index]) = (short)atoi(pstr[param_str_index]); 
                    param_count++;
                }
            }else {
                at_assert(0);
                break;
            } 
        } else if (type == 's') {
            if (size == 0) {
                if(pstr[param_str_index] != NULL) {
                    strcpy((char *)pval[param_val_index], pstr[param_str_index]);
                    param_count++;
                }
            } else {
               if(size < strlen(pstr[param_str_index])){
				    ret = ATERR_STR_TOO_LONG;
                    break;
			   }
               if(pstr[param_str_index] != NULL) {
                    strncpy((char *)pval[param_val_index], pstr[param_str_index], size - 1);
                    param_count++;
                }
            }
        } else {
                at_assert(0);
                break;
        }
        param_val_index++;
    }
    free(tmp);
    return ret;
}


/*%dʽʱαΪintͣڲԽķ*/
/*ûʹʱɸýӿڲвĸʽԽfmtֵΪ"%s"pvalֵΪchar **p˫ָ룬Ϊַظ*/
int parse_param(char *fmt, char *buf, void **pval)
{
	int ret = parse_param_safe(fmt,buf,pval);
    if(ret==ATWARN_LACK_PARAM||ret==ATWARN_DROP_RN)
        return  AT_PARSE_OK;
    return ret;
}


//at_clientϢЯatַͳʱʱ
static void send_app_req(int module_id, char *req_at, int len, int timeout,int direct)
{
	struct app_req appreq;

	memset(&appreq, 0x00, sizeof(struct app_req));
	memcpy(appreq.atstr, req_at, len);
	appreq.str_len = len;
    appreq.timeout = timeout;
	if(direct == NEAR_PS)
		at_send_msg(module_id, MODULE_ID_AT_CLIENT, MSG_CMD_SEND_AT_TO_ZTE,sizeof(struct app_req), &appreq, 0);
	
	printf("send_app_req\n");

}


//1   ɳط        0 ط
int at_client_err_proc(int err, int sent_cnt)
{
	if(9001 == err)//΢״̬쳣Ҫ
	{
		at_assert(0);
	}
	if(6003 == err || 6004 == err || 3 == err || 4 == err)
	{
		if(sent_cnt == 1)
		{
			return 1;
		}
		else
		{
			printf("please check req\n");			
		}
	}
	else if(8008 == err || 6000 == err)
	{
		if(sent_cnt == 1)
		{
			return 1;
		}
		else
		{//γʱͨ΢оƬ쳣Ҫ
			at_assert(0);
		}
	}			
	
	return 0;
}


/**
 * @brief Ӧ÷ͶAT󣬲ȴע⣺ýӿֻڲѯúִͨνмڲ
          мϱʱֻ֧һмϱ
 * @param req_at  AT
 * @param info_fmt ATӦĸʽʽ
 * @param pval  ʽATӦ
 * @param safe_parm_check	ָʾǷԲһԼ飬0ʾѡԲм;1ʾԲϸ
 * @return 0ʾسɹֵʾʧܴ
 * @note  1. ûʹʱɸýӿڲвĸʽԽinfo_fmtֵΪ"%s"pvalֵΪchar **p˫ָ룬Ϊַظ
	      2. ZMGL,CPBR, COPS=?һжмʹregister_inform_funcעмĴ
 * @warning 
 */
static int  send_req_and_wait(char *req_at,int len,char *info_fmt,void **pval, int safe_parm_check,int timeout,int direct)
{
	int my_handle = 0;
    char *prefix = NULL;
	MSG_BUF rsp_msg = {0};
	long msgSize = sizeof(MSG_BUF)-sizeof(long);
	int iRet = 0;
    int module_id = MODULE_ID_APP_DYNAMIC_BASE;//ڲ̬ȡԴģIDʼֵΪMODULE_ID_ATDYNAMIC_BASE
    int  err = 0;
	int  at_send_cnt = 0;

	if(len > DATA_BUFFER_MAX-12)	
		at_assert(0);
    at_assert(((info_fmt==NULL&&pval==NULL)||(info_fmt!=NULL&&pval!=NULL)));
    //̬ʱϢйܵ
    //msggetʹòIPC_CREAT | IPC_EXCL| 0600жϵǰmodule_idϢǷ
    //ڣڣֱӴµϢУڣֵδ-1Ȼmodule_id
    //ֵ1ѭֱҵûʹõmodule_idֵ
    while((my_handle = msgget(module_id,IPC_CREAT | IPC_EXCL| 0600)) == -1)
    {
        module_id++;
		if (module_id > MODULE_ID_APP_DYNAMIC_END) 
			//module_idMODULE_ID_ATDYNAMIC_ENDֵʱ
			at_assert(0);
	}
    //ATͲѯ﷨ҵӦĲѯǰ׺ֵ̬Σⲿڴͷ
    get_at_req_prefix(req_at,&prefix);
RESEND:	
    //at_ctlϢ͵Ϣatַ
	at_send_cnt++;
    at_assert(at_send_cnt<=RESEND_TIMES_MAX);
    //atctlڲóʱȴطعöʱ
	send_app_req(module_id,req_at,len,timeout,direct);
	printf("prefix:%s\n",prefix);
	while(1)
	{
		iRet = 0;
		memset(&rsp_msg, 0x00, sizeof(MSG_BUF));
		iRet = msgrcv(my_handle, &rsp_msg, msgSize, 0, 0);
		if (iRet < 0)
        {
        	continue;
		}
		//ӦϢ
		if(rsp_msg.usMsgCmd == MSG_CMD_SEND_AT_MSG_RSP)//ƥ䵽MSG_CMD_SEND_AT_MSG_RSPʱŴ
		{
		    char *buf = rsp_msg.aucDataBuf;
            char *at_paras = NULL;
        	char *rsp_head = NULL;
			char *rsp_tail = NULL;
            rsp_head = buf;
			printf("recv MSG_CMD_SEND_AT_MSG_RSP, buf:%s\n",buf);
        	//ڲѯ󣬲ṩ˲ڴռ䣬вĽ
        	if(prefix!=NULL && info_fmt!=NULL && pval!=NULL && ((rsp_head=strcasestr(buf,prefix))!=NULL))
        	{
        		//мͷҵ׵ַ
        		rsp_head = rsp_head+strlen(prefix)+2; 
				if((rsp_tail = strchr(rsp_head,'\0')) == NULL)//ϱмû\r\nʱ˵⣬ֱӶ
					at_assert(0);
				
				if(strcmp(info_fmt,"%s") == 0)
					//ڲвĸʽʱֱӽȫȡֵpval[0]Уκν
					strncpy((char *)*pval, rsp_head, (int)(rsp_tail-rsp_head));
				else//ҪʱмϱгϱĽпOKڣ
				{
					char *at_paras =  malloc(strlen(rsp_head)+1);
					if(at_paras == NULL) at_assert(0);
                    memset(at_paras, 0, strlen(rsp_head)+1);
					memcpy(at_paras, rsp_head, (int)(rsp_tail-rsp_head));

					if(safe_parm_check)
						err = parse_param_safe(info_fmt, at_paras, pval);//ոʽ
					else
						err = parse_param(info_fmt, at_paras, pval);//ոʽ
					printf("rsp parse_param_safe return ERR=%d!!!!!!\n",err);
					printf("at_paras=%s!!!!!!\n",at_paras);

					if(at_paras != NULL)
						free(at_paras);
                    //ϷǴͨ쳣ɵ
                    else if(err != AT_PARSE_OK)
                        goto RESEND;
				}                
        	}
        	//׼3GPPĴ󣬲ش
        	if((rsp_head = strstr(buf,"ERROR")) != NULL)
			{
				//Ҳðţ˵ERRORûд
				if(strchr(rsp_head,':') != NULL)
					sscanf(rsp_head+strlen("ERROR")+2, "%d", &err); 				
				printf("server return ERR=%d, at_send_cnt=%d!!!!!!!\n",err,at_send_cnt);
				//΢оƬ״̬쳣һΪ˽Ҫ
                if(err == ATERR_ZXIC_ERR)
                    at_assert(!"ZXIC  err!");
				
				//΢оƬʱظΪATERR_DROP_MARKATERR_NO_PRINTATERR_STR_TOO_LONGATWARN_DROP_RN
				//ATWARN_LACK_PARAMATERR_WAIT_REQ_END_TIMEOUTATERR_WAIT_RSP_TIMEOUTATERR_UNKNOWNING_CMDʱط
                else if((err>=ATERR_DROP_MARK && err<=ATWARN_LACK_PARAM) || err == ATERR_WAIT_REQ_END_TIMEOUT || err == ATERR_WAIT_RSP_TIMEOUT
					|| err == ATERR_UNKNOWN_CMD)
                    goto RESEND;
                break;
			}			
			//һЩִֻOKϱûмϱ
			else if((rsp_head = strstr(buf,"OK")) != NULL)
        	{
        		//΢ظĽĲϷ·
        	    if(err>=ATERR_DROP_MARK && err<=ATWARN_LACK_PARAM)
                    goto RESEND;
                break;		
        	}
        }
    }
    if(prefix!=NULL)
        free(prefix);
    //ѯغ֮ǰϢ
    if(msgctl(my_handle,IPC_RMID,0) < 0)
        printf("%d:%s",errno,strerror(errno));	
    return err;
}

//ڲͨ쳣ɵݴطԵݴtimeoutΪΪλĵȴʱ
int  get_modem_info(char *req_at,char *info_fmt,void **pval, int timeout)
{
    return send_req_and_wait(req_at,strlen(req_at),info_fmt,pval,0,timeout,NEAR_PS);
}

//Ϣӿڣɹ0ʧܷط0
int at_send_msg(int source_id, int target_id, unsigned short Msg_cmd, unsigned short us_DataLen, unsigned char *pData, int msgflag)
{
	MSG_BUF stMsg;
	int lRet = 0;
	int lTgtMsgID = 0;
	long msgSize = sizeof(MSG_BUF) - sizeof(long);

	long errNo = 0;

	memset(&stMsg, 0, sizeof(MSG_BUF));

	lTgtMsgID = msgget(target_id, 0);
	if (-1 == lTgtMsgID) {
		return -1;
	}

	if ((us_DataLen > 0) && (NULL == pData)) {
		return -1;
	}

	stMsg.usSourceModuleID = source_id;
	stMsg.usTargetModuleID = target_id;
	stMsg.usMsgCmd = Msg_cmd;
	stMsg.usDataLen = us_DataLen;

	if (us_DataLen > 0) {
		memcpy(stMsg.aucDataBuf, pData, us_DataLen);
	}

AGAIN:

	lRet = msgsnd(lTgtMsgID, &stMsg, msgSize, msgflag!=0?04000:0);//IPC_NOWAIT 04000
	if (lRet < 0) {
		if (errno == EINTR) {
			goto AGAIN;
		}
		if (msgflag == 0) {
			assert(0);
		}
		return -1;
	}
	return 0;
}








