

int  cpe_refresh_igd_ld_wlanconfiguration(cwmp_t * cwmp, parameter_node_t * param_node, callback_register_func_t callback_reg)
{
    FUNCTION_TRACE();

    if(!param_node)
    {
        return FAULT_CODE_9002;
    }
    parameter_node_t * tmp_param, *tmp_node, *child_param;
    child_param = param_node->child;
    if(child_param)
    {
        for(tmp_param=child_param->next_sibling; tmp_param; )
        {
            cwmp_log_info("refresh LANDevice.{i}.WLANConfiguration node, delete param %s\n", tmp_param->name);
            tmp_node = tmp_param->next_sibling;
            cwmp_model_delete_parameter(tmp_param);
            tmp_param = tmp_node;
        }
        child_param->next_sibling = NULL;

		cwmp_log_info("ready to get lan index");
        int lan_index = get_index_after_paramname(param_node, "LANDevice"); 

        cwmp_log_info("lan index is:%d", lan_index);
		
        parameter_node_t * lan1conn_param;
        cwmp_model_copy_parameter(param_node, &lan1conn_param, 1);
		
        if(lan_index == 2)
        {
             parameter_node_t * lan2conn_param;
             cwmp_model_copy_parameter(param_node, &lan2conn_param, 2);
        }

        cwmp_model_refresh_object(cwmp, param_node, 0, callback_reg); 
    }

    return FAULT_CODE_OK;
}



int cpe_get_igd_ld_wc_ssid(cwmp_t * cwmp, const char * name, char ** value, pool_t * pool)
{
	FUNCTION_TRACE();
    char tmp[16] = {0};

	sc_cfg_get("SSID1", tmp, sizeof(tmp)-1);

	*value = pool_pstrdup(pool, tmp);

	return	FAULT_CODE_OK;
}




int  cpe_refresh_igd_ld_wc_wepkey(cwmp_t * cwmp, parameter_node_t * param_node, callback_register_func_t callback_reg)
{
//    FUNCTION_TRACE();

    if(!param_node)
    {
        return FAULT_CODE_9002;
    }
    parameter_node_t * tmp_param, *tmp_node, *child_param;
    child_param = param_node->child;
    if(child_param)
    {
        for(tmp_param=child_param->next_sibling; tmp_param; )
        {
            cwmp_log_info("refresh WLANConfiguration node, delete param %s\n", tmp_param->name);
            tmp_node = tmp_param->next_sibling;
            cwmp_model_delete_parameter(tmp_param);
            tmp_param = tmp_node;
        }
        child_param->next_sibling = NULL;

        int lan_index = get_index_after_paramname(param_node, "LANDevice"); 
        int wlan_cof_index = get_index_after_paramname(param_node, "WLANConfiguration"); 

        if(lan_index == 1)
        {
            parameter_node_t * wlan_conf_param;
            switch(wlan_cof_index)
            {
                case 1: 
                    cwmp_model_copy_parameter(param_node, &wlan_conf_param, 1);
                    break;

                case 2:
                    cwmp_model_copy_parameter(param_node, &wlan_conf_param, 1); 
                    cwmp_model_copy_parameter(param_node, &wlan_conf_param, 2);
                    break;

            }       
            
        }
        else if(lan_index == 2)
        {
            //don't support
            cwmp_log_info("do not support index 2");
        }

        cwmp_model_refresh_object(cwmp, param_node, 0, callback_reg); 
    }

    return FAULT_CODE_OK;
}



int  cpe_refresh_igd_ld_wc_presharekey(cwmp_t * cwmp, parameter_node_t * param_node, callback_register_func_t callback_reg)
{
//    FUNCTION_TRACE();

    if(!param_node)
    {
        return FAULT_CODE_9002;
    }
    parameter_node_t * tmp_param, *tmp_node, *child_param;
    child_param = param_node->child;
    if(child_param)
    {
        for(tmp_param=child_param->next_sibling; tmp_param; )
        {
            cwmp_log_info("refresh WLANConfiguration node, delete param %s\n", tmp_param->name);
            tmp_node = tmp_param->next_sibling;
            cwmp_model_delete_parameter(tmp_param);
            tmp_param = tmp_node;
        }
        child_param->next_sibling = NULL;

        int lan_index = get_index_after_paramname(param_node, "LANDevice"); 
        int wlan_cof_index = get_index_after_paramname(param_node, "WLANConfiguration"); 

        if(lan_index == 1)
        {
            parameter_node_t * wlan_conf_param;
            switch(wlan_cof_index)
            {
                case 1: 
                    cwmp_model_copy_parameter(param_node, &wlan_conf_param, 1);
                    break;

                case 2:
                    cwmp_model_copy_parameter(param_node, &wlan_conf_param, 1); 
                    cwmp_model_copy_parameter(param_node, &wlan_conf_param, 2);
                    break;

            }       
            
        }
        else if(lan_index == 2)
        {
            //don't support
            cwmp_log_info("do not support index 2");
        }

        cwmp_model_refresh_object(cwmp, param_node, 0, callback_reg); 
    }

    return FAULT_CODE_OK;
}



