/*******************************************************************************
* Ȩ (C)2016, ͨѶɷ޹˾
*
* ļ:     nvserver.c
* ļʶ:     nvserver.c
* ժҪ:     nv̨Ӧʵļ
*
* ޸        汾      ޸ı        ޸          ޸
* ------------------------------------------------------------------------------
* 2016/06/13      V1.0        Create                    
*
*******************************************************************************/

/*******************************************************************************
*                                   ͷļ                                     *
*******************************************************************************/
#include <unistd.h>
#include <errno.h>
#include <stdio.h>
#include <stdlib.h>
#include <dirent.h>
#include <string.h>
#include <sys/file.h>
#include <sys/types.h>
#include <sys/stat.h>
#include <sys/ipc.h>
#include <sys/msg.h>

#include "nvserver.h"
#include "nv_typedef.h"
#include <message.h>
#include <fota_common.h>

#ifdef FOTA_AB
#include "pub_flags.h"
#include "flags_api.h"
#endif

#ifdef __cplusplus
extern "C" {
#endif

/*******************************************************************************
*                                                                      *
*******************************************************************************/

/*******************************************************************************
*                                   궨                                     *
*******************************************************************************/

/*******************************************************************************
*                                Ͷ                                  *
*******************************************************************************/

/*******************************************************************************
*                                ֲ                                  *
*******************************************************************************/

/*******************************************************************************
*                              ֲ̬                                *
*******************************************************************************/

/*******************************************************************************
*                                ȫֱ                                  *
*******************************************************************************/
extern T_NV_NODE *nv_list;

/*******************************************************************************
*                                ֲʵ                                  *
*******************************************************************************/

/*******************************************************************************
*                                ȫֺʵ                                  *
*******************************************************************************/
//#define FOTA_UPDATE_STATUS_FILE 					"/cache/zte_fota/update_status"
#ifdef FOTA_AB
int get_update_status (void)
{
	T_FLAGS_INFO flags_info = {0};
	unsigned int status = 0;
	int ret = 0;
	ret = flags_get(&flags_info);
	status = flags_info.boot_fota_flag.fota_status;

	if (status == 1)
		return 2;
	else
		return 0;
}
#else
int get_update_status (void)
{
	int  update_status;
	FILE *fd = 0;
	int ret;
    char* filename = NULL;

    if(access(FOTA_UPDATE_STATUS_FILE_OLD, R_OK) == 0){
        filename = FOTA_UPDATE_STATUS_FILE_OLD;
    }else{
        filename = FOTA_UPDATE_STATUS_FILE;
    }

    printf("get_update_status, read_update_status from %s\n", filename);
	fd = fopen (filename, "rb+");
	if (fd == NULL) {
		printf ("[nvserver]update_status open  error:%s\n", strerror (errno));
		goto error0;
	}

	ret = fscanf (fd, "%d", (int *) &update_status);
	if (ret < 0) {
		printf ("get info from file error:%s\n", strerror (errno));
		fclose (fd);
		goto error0;
	}
	printf ("update_status=%d\n", update_status);
	fclose (fd);

	return update_status;

error0:
	return -1;
}
#endif

int nvupdate (char *nv_file, char *config_file, const char *key, const char *value, int saveFlag)
{
	int index          = 0;
	int key_buf_len    = 0;
	int value_buf_len  = 0;
	T_NV_NODE *list    = NULL;
	T_NV_ITEM *item    = NULL;
	T_NV_ITEM *newItem = NULL;

	if (NULL == key || NULL == value)
		return RESULT_FAIL;

	printf("nvserver nvupdate nv_file:%s key:%s value:%s\n", nv_file, key, value);

	key_buf_len    = strlen(key) + 1;
	value_buf_len  = strlen(value) + 1;

	for (list = nv_list; list; list = list->next) {
		if (strcmp (list->nvFile, nv_file))
			continue;

		index = hash (key) % NV_HASH_LEN;
		for (item = list->nvTable[index]; item; item = item->next) {
			// change item
			if (strcmp (item->key, key))
				continue;

			if (saveFlag)
				item->saveFlag = saveFlag;
			//if value is the same , or the key is in 	default_parameter_user	, though the value change ,but do not update it
			//just update it if the key is in default_parameter_sys
			if (!strcmp (item->value, value))
			{
				/* value equal when sys or user */
				item->update_flag = 1; // indicate the value is  updated , or it is the newest
				printf("nvserver nvupdate sameskip:item->key:%s item->value:%s value:%s config_file:%s\n", item->key, 
				                                  item->value, value, config_file);
				return RESULT_SUCCESS;
			}
			if (strstr(config_file, "user"))
			{
				if (1 == item->update_flag)
				{
					/* second time:key in sys_user or user_user */
					printf("nvserver nvupdate second change:item->key:%s item->value:%s value:%s config_file:%s\n", item->key, 
					                                  item->value, value, config_file);
				}
				else
				{
					item->update_flag = 1;
					printf("nvserver nvupdate userskip:item->key:%s item->value1:%s value:%s config_file:%s\n", item->key, 
					                                  item->value, value, config_file);
					return RESULT_SUCCESS;
				}
			}

			printf ("nvserver key=%s change value:%s to value=%s \n", item->key, item->value, value);
			free (item->value);
			item->value = (char *) malloc (value_buf_len);
			if (!item->value)
				return RESULT_MALLOC_FAIL;

			strncpy (item->value, value, value_buf_len - 1);
			item->value[value_buf_len - 1] = '\0';

			item->update_flag = 1; // indicate the value is  updated , or it is the newest
			return RESULT_SUCCESS;
		}

		// add item
		newItem = (T_NV_ITEM *) malloc (sizeof (T_NV_ITEM));
		if (!newItem) {
			printf ("nvserver RESULT_MALLOC_FAIL1 \n");
			return RESULT_MALLOC_FAIL;
		}
		newItem->key = (char *) malloc (strlen (key) + 1);
		if (!newItem->key) {
			free (newItem);
			printf ("nvserver RESULT_MALLOC_FAIL2\n");

			return RESULT_MALLOC_FAIL;
		}

		newItem->value = (char *) malloc (value_buf_len);
		if (!newItem->value) {
			free (newItem->key);
			free (newItem);
			printf ("nvserver RESULT_MALLOC_FAIL3 \n");
			return RESULT_MALLOC_FAIL;
		}
		
		strncpy (newItem->key, key, key_buf_len - 1);
		newItem->key[key_buf_len - 1] = '\0';
		
		strncpy (newItem->value, value, value_buf_len - 1);
		newItem->value[value_buf_len - 1] = '\0';
		
		newItem->next = NULL;
		newItem->saveFlag = saveFlag;
		newItem->update_flag = 1; // indicate the value is  updated , or it is the newest
		printf ("nvserver add key=%s, value=%s \n", newItem->key, newItem->value);


		if (!list->nvTable[index])
			list->nvTable[index] = newItem;
		else {
			newItem->next = list->nvTable[index]->next;
			list->nvTable[index]->next = newItem;
		}

		return RESULT_SUCCESS;
	}

	return RESULT_FAIL;
}

int  reloadFactroyParam (T_NV_NODE *list)
{
	char *val   = NULL;
	FILE *fp    = NULL;
	T_NV_CONFIG *config = NULL;
	char buf[NV_MAX_ITEM_LEN] = {0};

	printf("nvserver reloadFactroyParam nvFile:%s\n", list->nvFile);

	for (config = list->fileList; config; config = config->next) {
		printf ("nvserver reloadFactroyParam configFile start:%s!\n", config->configFile);
		fp = fopen (config->configFile, "ro");
		if (!fp) {
			printf ("nvserver error:open %s file fail errno = %d!\n", config->configFile, errno);
			return RESULT_FILE_OPEN_FAIL;
		}

		while (fgets (buf, NV_MAX_ITEM_LEN, fp)) {
			if (buf[0] == '\n' || buf[0] == '#')
				continue;

			val = strchr (buf, '=');
			if (!val) {
				printf ("nvserver error:%s file format error:string = %s\n", config->configFile, buf);
				continue;
			}

			buf[strlen (buf) - 1] = '\0';
			*val++ = '\0';

			nvupdate (list->nvFile, config->configFile, buf, val, 1);
		}
		printf ("nvserver reloadFactroyParam configFile end:%s!\n", config->configFile);
		fclose (fp);
	}

	return RESULT_SUCCESS;
}

void dump_list(T_NV_ITEM *list)
{
	 if(list == NULL){
	 	printf("list is null\n");
	 	return;
	 }
	
	 T_NV_ITEM *p = list->next;
	 
	 while(p!= NULL){
			printf ("nvserver dump key=%s, value=%s, p=0x%x\n", p->key, p->value, ((unsigned int)p));	 		
	 		p=p->next;
	 }
}

int  delete_not_needed (T_NV_NODE *list)
{
	int index = 0;
	T_NV_ITEM *item = NULL;
	T_NV_ITEM  head = {0};
	T_NV_ITEM *prev =  &head;

	printf ("nvserver delete_not_needed enter ***\n");

	for (index = 0; index < NV_HASH_LEN; index ++) {
		head.next = list->nvTable[index];
		prev =  &head;
//		printf ("nvserver index=%d   begin *****\n", index);
//		dump_list(&head);
		for (item = prev->next;  item;) {

//	        printf("nvserver1 delete key=%s, value=%s \n", item->key, item->value);

			if (1 == item->update_flag) {
				prev = item;
				item =  item->next;
			} 
			else 
			{			
				printf ("nvserver delete key=%s, value=%s \n", item->key, item->value);
				prev->next = item->next;
				free (item->key);
				free (item->value);
				free (item);
				item = prev->next;

			}
		}
		list->nvTable[index] = head.next;
//		dump_list(&head);
//		printf ("nvserver index=%d   end *****\n", index);

	}

	printf ("nvserver delete_not_needed end ***\n");

	return RESULT_SUCCESS;
}




#ifdef __cplusplus
}
#endif

