/*****************************************************************************
*  汾 (C)ͨѶɷ޹˾
*  ģ    MMI
*  ļ    mmi_led.c
*  ļʶ  
*  ļ  
*  ʵֹ  
*        
*  汾      V1.0
*    2014-6-20
*  ˵  
*
*******************************************************************************/
#include "mmi_common.h"

/********************************************************************************
  ȫֱ
**********************************************************************************/
extern UINT32 g_smstask_enable;
extern UINT32 g_voicetask_enable;
extern UINT32 g_led_sleep_mode;

/*****************************************************************************
 ȫֱ
******************************************************************************/
MMI_LED_STATE s_mmi_batled_laststate = LED_STATE_MAX;//ǵصƵһ״̬
MMI_LED_STATE s_mmi_wanled_laststate = LED_STATE_MAX;//Ƶһ״̬
MMI_LED_STATE s_mmi_lanled_laststate = LED_STATE_MAX;//wifiƵһ״̬
MMI_LED_STATE s_mmi_smsled_laststate = LED_STATE_MAX;//ǶŵƵһ״̬
MMI_LED_STATE s_mmi_traled_laststate = LED_STATE_MAX;//Ƶһ״̬
MMI_LED_STATE s_mmi_voiled_laststate = LED_STATE_MAX;//Ƶһ״̬

extern POWER_ON_OFF_CALLBACK_FUN g_PowerOnOffFun;
extern T_zMmiSmsLedConfig g_mmi_smsled_config_tab[];
extern T_zMmiWifiLedConfig g_mmi_wifiled_config_tab[];
extern T_zMmiNetLedConfig g_mmi_netled_config_tab[];
extern T_zMmiBatteryLedConfig g_mmi_batled_config_tab[];
extern T_zMmiVoipLedConfig g_mmi_voipled_config_tab[];
extern T_zMmiNetLedConfig g_mmi_signalled_config_tab[];
extern T_zMmiWifiLedConfig g_mmi_wpsled_config_tab[];
extern T_zMmiRj11LedConfig g_mmi_rj11led_config_tab[];


extern sem_t g_mmi_traffic_warn_sem_id;
BOOL s_mmi_trafficled_warn_flag = FALSE;//澯Ƿ˫
extern int g_customer_type;
/**********************************************************************************
*:LEDƲ
***********************************************************************************/
static VOID mmi_led_operate_blink_off(T_zMmi_Led_Info*  userInfo)
{
	slog(MMI_PRINT, SLOG_DEBUG, "MMI mmi_led_operate name= %d\n", userInfo->led_name);
	T_zMmi_Led_Info tmpInfo = {0};
	memcpy((VOID *)(&tmpInfo), (const VOID *)userInfo, sizeof(T_zMmi_Led_Info));
	tmpInfo.led_state = LED_STATE_OFF;
	tmpInfo.led_color = userInfo->led_color;
	mmi_led_operate(&tmpInfo);

}

static VOID mmi_led_operate_set_blinktime(T_zMmi_Led_Blink_Time *blink_time, MMI_LED_BLINK_SPEED speed)
{
	switch (speed) {
	case LED_STATE_FAST_BLINK: {
		blink_time->uBlinkOnTime = LED_FAST_BLINK_ON_TIME;
		blink_time->uBlinkOffTime = LED_FAST_BLINK_OFF_TIME;
		break;
	}
	case LED_STATE_SLOW_BLINK: {
		blink_time->uBlinkOnTime = LED_SLOW_BLINK_ON_TIME;
		blink_time->uBlinkOffTime = LED_SLOW_BLINK_OFF_TIME;
		break;
	}
	case LED_STATE_BAT_BLINK: {
		blink_time->uBlinkOnTime = LED_BAT_BLINK_ON_TIME;
		blink_time->uBlinkOffTime = LED_BAT_BLINK_OFF_TIME;
		break;
	}
	case LED_STATE_LAN_BLINK: {
		blink_time->uBlinkOnTime = LED_LAN_BLINK_ON_TIME;
		blink_time->uBlinkOffTime = LED_LAN_BLINK_OFF_TIME;
		break;
	}
	case LED_STATE_SMS_BLINK: {
		blink_time->uBlinkOnTime = LED_SMS_BLINK_ON_TIME;
		blink_time->uBlinkOffTime = LED_SMS_BLINK_OFF_TIME;
		break;
	}
	case LED_STATE_WAN_BLINK: {
		blink_time->uBlinkOnTime = LED_WAN_BLINK_ON_TIME;
		blink_time->uBlinkOffTime = LED_WAN_BLINK_OFF_TIME;
		break;
	}
	case LED_STATE_VOIP_BLINK: {
		blink_time->uBlinkOnTime = LED_VOIP_BLINK_ON_TIME;
		blink_time->uBlinkOffTime = LED_VOIP_BLINK_OFF_TIME;
		break;
	}
	case LED_STATE_WAN_FAST_BLINK: {
		blink_time->uBlinkOnTime = LED_WAN_FAST_BLINK_ON_TIME;
		blink_time->uBlinkOffTime = LED_WAN_FAST_BLINK_OFF_TIME;
		break;
	}
	case LED_STATE_WAN_SLOW_BLINK: {
		blink_time->uBlinkOnTime = LED_WAN_SLOW_BLINK_ON_TIME;
		blink_time->uBlinkOffTime = LED_WAN_SLOW_BLINK_OFF_TIME;
		break;
	}
	//yaoyuan cpe
	case LED_STATE_WAN_CPE_FAST_BLINK: {
		blink_time->uBlinkOnTime = LED_WAN_CPE_FAST_BLINK_ON_TIME;
		blink_time->uBlinkOffTime = LED_WAN_CPE_FAST_BLINK_OFF_TIME;
		break;
	}
	case LED_STATE_WAN_CPE_SLOW_BLINK: {
		blink_time->uBlinkOnTime = LED_WAN_CPE_SLOW_BLINK_ON_TIME;
		blink_time->uBlinkOffTime = LED_WAN_CPE_SLOW_BLINK_OFF_TIME;
		break;
	}
	default: {
		break;
	}
	}
}

static VOID mmi_set_led_laststate(T_zMmi_Led_Info*  userInfo)
{
	switch (userInfo->led_name) {
	case LED_BATTERY: {
		if (userInfo->led_state == LED_STATE_BLINK) {
			s_mmi_batled_laststate = LED_STATE_BLINK;
		} else if (userInfo->led_state == LED_STATE_ON && s_mmi_batled_laststate == LED_STATE_BLINK) {
			mmi_led_operate_blink_off(userInfo);
			s_mmi_batled_laststate = LED_STATE_MAX;
		} else {
			s_mmi_batled_laststate = LED_STATE_MAX;
		}
		break;
	}
	case LED_WAN: {
		if (userInfo->led_state == LED_STATE_BLINK) {
			s_mmi_wanled_laststate = LED_STATE_BLINK;
		} else if (userInfo->led_state == LED_STATE_ON && s_mmi_wanled_laststate == LED_STATE_BLINK) {
			mmi_led_operate_blink_off(userInfo);
			s_mmi_wanled_laststate = LED_STATE_MAX;
		} else {
			s_mmi_wanled_laststate = LED_STATE_MAX;
		}
		break;
	}
	case LED_LAN: {
		if (userInfo->led_state == LED_STATE_BLINK) {
			s_mmi_lanled_laststate = LED_STATE_BLINK;
		} else if (userInfo->led_state == LED_STATE_ON && s_mmi_lanled_laststate == LED_STATE_BLINK) {
			mmi_led_operate_blink_off(userInfo);
			s_mmi_lanled_laststate = LED_STATE_MAX;
		} else {
			s_mmi_lanled_laststate = LED_STATE_MAX;
		}
		break;
	}
	case LED_SMS: {
		if (userInfo->led_state == LED_STATE_BLINK) {
			s_mmi_smsled_laststate = LED_STATE_BLINK;
		} else if (userInfo->led_state == LED_STATE_ON && s_mmi_smsled_laststate == LED_STATE_BLINK) {
			mmi_led_operate_blink_off(userInfo);
			s_mmi_smsled_laststate = LED_STATE_MAX;
		} else {
			s_mmi_smsled_laststate = LED_STATE_MAX;
		}
		break;
	}
	case LED_TRAFFIC: {
		if (userInfo->led_state == LED_STATE_BLINK) {
			s_mmi_traled_laststate = LED_STATE_BLINK;
		} else if (userInfo->led_state == LED_STATE_ON && s_mmi_traled_laststate == LED_STATE_BLINK) {
			mmi_led_operate_blink_off(userInfo);
			s_mmi_traled_laststate = LED_STATE_MAX;
		} else {
			s_mmi_traled_laststate = LED_STATE_MAX;
		}
		break;
	}
	case LED_VOIP: {
		if (userInfo->led_state == LED_STATE_BLINK) {
			s_mmi_voiled_laststate = LED_STATE_BLINK;
		} else if (userInfo->led_state == LED_STATE_ON && s_mmi_voiled_laststate == LED_STATE_BLINK) {
			mmi_led_operate_blink_off(userInfo);
			s_mmi_voiled_laststate = LED_STATE_MAX;
		} else {
			s_mmi_voiled_laststate = LED_STATE_MAX;
		}
		break;
	}
#if 0
	//yao yuan
	case LED_SIGNAL: {
		if (userInfo->led_state == LED_STATE_BLINK) {
			s_mmi_sigled_laststate = LED_STATE_BLINK;
		} else if (userInfo->led_state == LED_STATE_ON && s_mmi_voiled_laststate == LED_STATE_BLINK) {
			mmi_led_operate_blink_off(userInfo);
			s_mmi_sigled_laststate = LED_STATE_MAX;
		} else {
			s_mmi_sigled_laststate = LED_STATE_MAX;
		}
		break;
	}
	case LED_WPS: {
		if (userInfo->led_state == LED_STATE_BLINK) {
			s_mmi_wpsled_laststate = LED_STATE_BLINK;
		} else if (userInfo->led_state == LED_STATE_ON && s_mmi_voiled_laststate == LED_STATE_BLINK) {
			mmi_led_operate_blink_off(userInfo);
			s_mmi_wpsled_laststate = LED_STATE_MAX;
		} else {
			s_mmi_wpsled_laststate = LED_STATE_MAX;
		}
		break;
	}
	case LED_RJ11: {
		if (userInfo->led_state == LED_STATE_BLINK) {
			s_mmi_rj11led_laststate = LED_STATE_BLINK;
		} else if (userInfo->led_state == LED_STATE_ON && s_mmi_voiled_laststate == LED_STATE_BLINK) {
			mmi_led_operate_blink_off(userInfo);
			s_mmi_rj11led_laststate = LED_STATE_MAX;
		} else {
			s_mmi_rj11led_laststate = LED_STATE_MAX;
		}
		break;
	}
#endif	
	default: {
		break;
	}
	}
}

SINT32 mmi_showLed(UINT32 ledInfo)
{
	T_zMmi_Led_Info *led_info = (T_zMmi_Led_Info *)ledInfo;
	T_zMmi_Led_Blink_Time blink_time = {0};
	slog(MMI_PRINT, SLOG_DEBUG, "MMI mmi_showLed name= %d ,state = %d, color=%d !\n", led_info->led_name, led_info->led_state, led_info->led_color);

	mmi_set_led_laststate(led_info);
	if (led_info->led_state == LED_STATE_BLINK) {
		mmi_led_operate_set_blinktime(&blink_time, led_info->ledBlink_speed);
		led_info->ledBlink_time = blink_time;
	}
	if (led_info->led_name == LED_TRAFFIC && s_mmi_traled_laststate == LED_STATE_BLINK && led_info->led_state == LED_STATE_OFF) {
		mmi_led_operate(led_info);//һ״̬ʱ˸Ҫβܹص
	}
	mmi_led_operate(led_info);
	return 0;
}

static VOID mmi_setLedShowInfo(T_zMmi_Led_Info* outLedInfo, T_zMmi_Led_Info inLedInfo)
{
	slog(MMI_PRINT, SLOG_DEBUG, "MMI mmi_setLedShowInfo inLedInfo name:%d,state:%d,color:%d\n", inLedInfo.led_name, inLedInfo.led_state, inLedInfo.led_color);
	outLedInfo->led_name = inLedInfo.led_name;
	outLedInfo->led_color = inLedInfo.led_color;
	outLedInfo->traffic = inLedInfo.traffic;
	outLedInfo->led_state = inLedInfo.led_state;
	outLedInfo->ledBlink_speed = inLedInfo.ledBlink_speed;

	slog(MMI_PRINT, SLOG_DEBUG, "MMI mmi_setLedShowInfo outLedInfo name:%d,state:%d,color:%d\n", outLedInfo->led_name, outLedInfo->led_state, outLedInfo->led_color);
}
/**********************************************************************************
*:ȡŵϢ
***********************************************************************************/
SINT32 mmi_getLedSmsInfo(UINT32 taskInfo, UINT32 outLedInfo)
{
	T_zMmi_Led_Info* pLedInfo = (T_zMmi_Led_Info*)outLedInfo;
	T_zMmi_Sms_Info *pSmsInfo = (T_zMmi_Sms_Info*)taskInfo;
	UINT32 i = 0;
	
	slog(MMI_PRINT, SLOG_DEBUG, "MMI mmi_getLedSmsInfo recvBox_sta=%d\n",pSmsInfo->recvBox_sta);

	for (i = 0; i < (UINT32)mmi_get_config_tab_size(LED_SMS) / sizeof(T_zMmiSmsLedConfig); ++ i) {
		if (pSmsInfo->recvBox_sta == g_mmi_smsled_config_tab[i].sms_info.recvBox_sta) {
			mmi_setLedShowInfo(pLedInfo, g_mmi_smsled_config_tab[i].led_info);
			return MMI_SUCCESS;
		}
	}
	return MMI_ERROR;
}
/**********************************************************************************
*:ȡʾϢ
***********************************************************************************/
SINT32 mmi_getLedVoipInfo(UINT32 taskInfo, UINT32 outLedInfo)
{
	T_zMmi_Led_Info* pLedInfo = (T_zMmi_Led_Info*)outLedInfo;
	T_zMmi_Voip_Info *pVoipInfo = (T_zMmi_Voip_Info*)taskInfo;
	UINT32 i = 0;
	
	slog(MMI_PRINT, SLOG_DEBUG, "MMI mmi_getLedVoipInfo voip_sta=%d\n",pVoipInfo->voip_sta);

	for (i = 0; i < (UINT32)mmi_get_config_tab_size(LED_VOIP) / sizeof(T_zMmiVoipLedConfig); ++ i) {
		if (pVoipInfo->voip_sta == g_mmi_voipled_config_tab[i].voip_info.voip_sta) {
			mmi_setLedShowInfo(pLedInfo, g_mmi_voipled_config_tab[i].led_info);
			return MMI_SUCCESS;
		}
	}
	return MMI_ERROR;
}
/**********************************************************************************
*:ȡrj11Ϣ ҢԶcpe
***********************************************************************************/
SINT32 mmi_getLedRj11Info(UINT32 taskInfo, UINT32 outLedInfo)
{
	T_zMmi_Led_Info* pLedInfo = (T_zMmi_Led_Info*)outLedInfo;
	T_zMmi_Rj11_Info *pVoipInfo = (T_zMmi_Rj11_Info*)taskInfo;
	UINT32 i = 0;

	slog(MMI_PRINT, SLOG_DEBUG, "MMI mmi_getLedRj11Info rj11_sta=%d\n",pVoipInfo->rj11_sta);

	for (i = 0; i < (UINT32)mmi_get_config_tab_size(LED_RJ11) / sizeof(T_zMmiRj11LedConfig); ++ i) {
		if (pVoipInfo->rj11_sta == g_mmi_rj11led_config_tab[i].rj11_info.rj11_sta) {
			mmi_setLedShowInfo(pLedInfo, g_mmi_rj11led_config_tab[i].led_info);
			return MMI_SUCCESS;
		}
	}
	return MMI_ERROR;
}

/**********************************************************************************
*:ȡصϢ
***********************************************************************************/
SINT32 mmi_getLedBatteryInfo(UINT32 taskInfo, UINT32 outLedInfo)
{
	T_zMmi_Led_Info* pLedInfo = (T_zMmi_Led_Info*)outLedInfo;
	T_zMMIBatteryInfo *pBatteryInfo = (T_zMMIBatteryInfo *)taskInfo;
	UINT32 i = 0;
	slog(MMI_PRINT, SLOG_DEBUG, "MMI mmi_getLedBatteryInfo chg_sta=%d\n", pBatteryInfo->chg_state);
	for (i = 0; i < (UINT32)mmi_get_config_tab_size(LED_BATTERY) / sizeof(T_zMmiBatteryLedConfig); ++ i) {
		if (pBatteryInfo->chg_state == g_mmi_batled_config_tab[i].bat_info.chg_state) {
			if (pBatteryInfo->chg_state == STATE_DISCHARGE) {
				if (pBatteryInfo->bat_level == g_mmi_batled_config_tab[i].bat_info.bat_level) {
					mmi_setLedShowInfo(pLedInfo, g_mmi_batled_config_tab[i].led_info);
					return MMI_SUCCESS;
				}
			} else {
				mmi_setLedShowInfo(pLedInfo, g_mmi_batled_config_tab[i].led_info);
				return MMI_SUCCESS;
			}
		}
	}
	return MMI_ERROR;
}

/**********************************************************************************
*:ȡϢ
***********************************************************************************/
SINT32 mmi_getLedNetInfo(UINT32 taskInfo, UINT32 outLedInfo)
{
	T_zMmi_Led_Info* pLedInfo = (T_zMmi_Led_Info*)outLedInfo;
	T_zMMINetInfo *pNetInfo = (T_zMMINetInfo *)taskInfo;
	UINT32 i = 0;
	int customer_type = g_customer_type; 
	E_zMmi_Net_Mode net_mode = pNetInfo->net_mode;
	char mmi_nv_value[32] = {0};
	slog(MMI_PRINT, SLOG_DEBUG, "MMI mmi_getLedNetInfo net_mode=%d connect %d socket %d customer_type=%d\n",pNetInfo->net_mode,pNetInfo->connect_status,pNetInfo->socket_state,g_customer_type);

	sc_cfg_get("mmi_led_plan", mmi_nv_value, sizeof(mmi_nv_value));
	if (0 == strcmp(mmi_nv_value, "yaoyuan")) {
		customer_type = CUSTOMER_YAOYUAN;
		
		sc_cfg_get(NV_MODEM_MAIN_STATE, mmi_nv_value, sizeof(mmi_nv_value));
		if (strcmp(mmi_nv_value, NV_SIM_STATE_INIT_COMPLETE)) {
			net_mode = NET_MODE_NOTREADY;
		}
	}

	for (i = 0; i < (UINT32)mmi_get_config_tab_size(LED_WAN) / sizeof(T_zMmiNetLedConfig); ++ i) {
		if ((net_mode == g_mmi_netled_config_tab[i].net_info.net_mode) && (customer_type == g_mmi_netled_config_tab[i].custom_type)) {
			if (net_mode == NET_MODE_NOSERVICE 
				|| net_mode == NET_MODE_LIMITSERVICE
				|| net_mode == NET_MODE_NOTREADY) {
				mmi_setLedShowInfo(pLedInfo, g_mmi_netled_config_tab[i].led_info);
				return MMI_SUCCESS;
			} else {
				if ((pNetInfo->connect_status == g_mmi_netled_config_tab[i].net_info.connect_status) && (pNetInfo->socket_state == g_mmi_netled_config_tab[i].net_info.socket_state)) {
					mmi_setLedShowInfo(pLedInfo, g_mmi_netled_config_tab[i].led_info);
					slog(MMI_PRINT, SLOG_NORMAL, "MMI mmi_getLedNetInfo netmode = %d, con_sta = %d,i = %d,ledsta = %d\n", net_mode, pNetInfo->connect_status, i, g_mmi_netled_config_tab[i].led_info.led_state);
					return MMI_SUCCESS;
				}
			}
		}
	}
	return MMI_ERROR;
}

/**********************************************************************************
*:ȡźŸϢҢԶcpe
***********************************************************************************/
SINT32 mmi_getLedNetSigInfo(UINT32 taskInfo, UINT32 outLedInfo)
{
	T_zMmi_Led_Info* pLedInfo = (T_zMmi_Led_Info*)outLedInfo;
	T_zMMINetInfo *pNetInfo = (T_zMMINetInfo *)taskInfo;
	UINT32 i = 0;
	int customer_type = g_customer_type; 
	E_zMmi_Net_Mode net_mode = pNetInfo->net_mode;
	char mmi_nv_value[32] = {0};

	sc_cfg_get("mmi_led_plan", mmi_nv_value, sizeof(mmi_nv_value));
	if (0 == strcmp(mmi_nv_value, "yaoyuan")) {
		customer_type = CUSTOMER_YAOYUAN;
	}

	slog(MMI_PRINT, SLOG_DEBUG, "MMI mmi_getLedNetSigInfo net_mode=%d signal_num %d customer_type=%d\n",pNetInfo->net_mode,pNetInfo->signal_num,customer_type);

	for (i = 0; i < (UINT32)mmi_get_config_tab_size(LED_SIGNAL) / sizeof(T_zMmiNetLedConfig); ++ i) {
		if ((net_mode == g_mmi_signalled_config_tab[i].net_info.net_mode) && (customer_type == g_mmi_signalled_config_tab[i].custom_type)) {
			if (net_mode == NET_MODE_NOSERVICE 
				|| net_mode == NET_MODE_LIMITSERVICE
				|| net_mode == NET_MODE_NOTREADY) {
				mmi_setLedShowInfo(pLedInfo, g_mmi_signalled_config_tab[i].led_info);
				return MMI_SUCCESS;
			} else {
				if (pNetInfo->signal_num == g_mmi_signalled_config_tab[i].net_info.signal_num) {
					mmi_setLedShowInfo(pLedInfo, g_mmi_signalled_config_tab[i].led_info);
					slog(MMI_PRINT, SLOG_NORMAL, "MMI mmi_getLedNetSigInfo netmode = %d, con_sta = %d,i = %d,ledsta = %d\n", net_mode, pNetInfo->connect_status, i, g_mmi_netled_config_tab[i].led_info.led_state);
					return MMI_SUCCESS;
				}
			}
		}
	}
	return MMI_ERROR;
}

/**********************************************************************************
*:ȡWIFIϢ
***********************************************************************************/
SINT32 mmi_getLedWifiInfo(UINT32 taskInfo, UINT32 outLedInfo)
{
	T_zMmi_Led_Info* pLedInfo = (T_zMmi_Led_Info*)outLedInfo;
	T_zMMIWifiInfo * pWifiInfo = (T_zMMIWifiInfo *)taskInfo;
	UINT32 i = 0;
	
	slog(MMI_PRINT, SLOG_DEBUG, "MMI mmi_getLedWifiInfo wifi_state=%d, wifidata_state=%d\n",pWifiInfo->wifi_state,pWifiInfo->wifidata_state);

	for (i = 0; i < (UINT32)mmi_get_config_tab_size(LED_LAN) / sizeof(T_zMmiWifiLedConfig); ++ i) {
		if (pWifiInfo->wifi_state == g_mmi_wifiled_config_tab[i].wifi_info.wifi_state
		    && pWifiInfo->wifidata_state == g_mmi_wifiled_config_tab[i].wifi_info.wifidata_state
		    && (g_customer_type == g_mmi_wifiled_config_tab[i].custom_type)) {
			mmi_setLedShowInfo(pLedInfo, g_mmi_wifiled_config_tab[i].led_info);
			return MMI_SUCCESS;
		}
	}
	
	return MMI_ERROR;
}

/**********************************************************************************
*:ȡwpsϢ ҢԶcpe
***********************************************************************************/
SINT32 mmi_getLedWpsInfo(UINT32 taskInfo, UINT32 outLedInfo)
{
	T_zMmi_Led_Info* pLedInfo = (T_zMmi_Led_Info*)outLedInfo;
	T_zMMIWifiInfo * pWifiInfo = (T_zMMIWifiInfo *)taskInfo;
	UINT32 i = 0;

	slog(MMI_PRINT, SLOG_DEBUG, "MMI mmi_getLedWpsInfo wps_state=%d customer_type=%d\n",pWifiInfo->wps_state, g_customer_type);

	for (i = 0; i < (UINT32)mmi_get_config_tab_size(LED_WPS) / sizeof(T_zMmiWifiLedConfig); ++ i) {
		if (pWifiInfo->wps_state == g_mmi_wpsled_config_tab[i].wifi_info.wps_state
		    && (g_customer_type == g_mmi_wpsled_config_tab[i].custom_type)) {
			mmi_setLedShowInfo(pLedInfo, g_mmi_wpsled_config_tab[i].led_info);
			return MMI_SUCCESS;
		}
	}

	return MMI_ERROR;
}

/**********************************************************************************
*:澯˫
***********************************************************************************/
VOID mmi_set_led_double_blink()
{
	slog(MMI_PRINT, SLOG_NORMAL, "MMI mmi_set_led_double_blink 1000ms off\n");

	T_zMmi_Led_Info userInfo = {0};
	userInfo.led_name = LED_WAN;
	userInfo.led_state = LED_STATE_OFF;
	userInfo.led_color = LED_COLOR_YELLOW;
	mmi_led_operate(&userInfo);
	userInfo.led_color = LED_COLOR_BLUE;
	mmi_led_operate(&userInfo);
	mmi_startLedTrafficWarnTimer(1000, 0);

	int sem_ret1 = -1;
	sem_ret1 = mmi_GetSemaphoreEintr(&g_mmi_traffic_warn_sem_id, MMI_WAIT_FOREVER);
	if (sem_ret1 != MMI_SUCCESS) {
		slog(MMI_PRINT, SLOG_ERR, "MMI DBget1 FAILED! errno=%d\n",errno);
	}
	userInfo.led_color = LED_COLOR_RED;
	userInfo.led_state = LED_STATE_ON;
	mmi_led_operate(&userInfo);
	mmi_startLedTrafficWarnTimer(100, 0);

	int sem_ret2 = -1;
	sem_ret2 = mmi_GetSemaphoreEintr(&g_mmi_traffic_warn_sem_id, MMI_WAIT_FOREVER);
	if (sem_ret2 != MMI_SUCCESS) {
		slog(MMI_PRINT, SLOG_ERR, "MMI DBget2 FAILED! errno=%d\n",errno);
	}

	userInfo.led_state = LED_STATE_OFF;
	mmi_led_operate(&userInfo);
	mmi_startLedTrafficWarnTimer(100, 0);

	int sem_ret3 = -1;
	sem_ret3 = mmi_GetSemaphoreEintr(&g_mmi_traffic_warn_sem_id, MMI_WAIT_FOREVER);
	if (sem_ret3 != MMI_SUCCESS) {
		slog(MMI_PRINT, SLOG_ERR, "MMI DBget3 FAILED! errno=%d\n",errno);
	}

	userInfo.led_state = LED_STATE_ON;
	mmi_led_operate(&userInfo);
	mmi_startLedTrafficWarnTimer(100, 0);

	int sem_ret4 = -1;
	sem_ret4 = mmi_GetSemaphoreEintr(&g_mmi_traffic_warn_sem_id, MMI_WAIT_FOREVER);
	if (sem_ret4 != MMI_SUCCESS) {
		slog(MMI_PRINT, SLOG_ERR, "MMI DBget4 FAILED! errno=%d\n",errno);
	}

	userInfo.led_state = LED_STATE_OFF;
	mmi_led_operate(&userInfo);
	mmi_startLedTrafficWarnTimer(1000, 0);

	int sem_ret5 = -1;
	sem_ret5 = mmi_GetSemaphoreEintr(&g_mmi_traffic_warn_sem_id, MMI_WAIT_FOREVER);
	if (sem_ret5 != MMI_SUCCESS) {
		slog(MMI_PRINT, SLOG_ERR, "MMI DBget5 FAILED! errno=%d\n",errno);
	}

	mmi_set_update_flag(MMI_TASK_NET);
	mmi_startLedTrafficWarnTimer(4000, 1);
}
/**********************************************************************************
*:־
***********************************************************************************/
VOID mmi_set_traffic_warn_flag(BOOL flag)
{
	s_mmi_trafficled_warn_flag = flag;
}
/**********************************************************************************
*:ȡϢ
***********************************************************************************/
SINT32 mmi_getLedTrafficInfo(UINT32 taskInfo, UINT32 outLedInfo)
{
	T_zMMITrafficInfo * pTrafficInfo = (T_zMMITrafficInfo *)taskInfo;

#if 0
	pLedInfo->led_name = IOCTL_LED_TRAFFIC;
	pLedInfo->userPara.uBrightness = 0;
	pLedInfo->userPara.uColor = LED_COLOR_GREEN;
	pLedInfo->userPara.uSleep = LED_SLEEP_MAX;
	if (pTrafficInfo->traffic_switch == TRAFFIC_LIMIT_SWITCH_OFF) {
		pLedInfo->userPara.uState = LED_STATE_OFF;
		pLedInfo->speed = LED_STATE_DEFAULT_BLINK;
		pLedInfo->userPara.uTraffic = LED_TRAFFIC_100;
	} else {
		if (pTrafficInfo->warning_tip_flag == 0) {
			pLedInfo->userPara.uState = LED_STATE_ON;
			pLedInfo->speed = LED_STATE_DEFAULT_BLINK;
		} else {
			pLedInfo->userPara.uState = LED_STATE_BLINK;
			pLedInfo->speed = LED_STATE_FAST_BLINK;
		}
	}
#endif

	UINT32 temp = 100 * (pTrafficInfo->uesd_traffic / pTrafficInfo->total_traffic);
	slog(MMI_PRINT, SLOG_DEBUG, "MMI mmi_getLedTrafficInfo temp = %d, level = %d\n", temp, pTrafficInfo->warning_tip_level);
	if ((pTrafficInfo->warning_tip_level != 0) && (temp >= pTrafficInfo->warning_tip_level) && (pTrafficInfo->traffic_switch == TRAFFIC_LIMIT_SWITCH_ON)) {
		if (!s_mmi_trafficled_warn_flag) {
			mmi_set_traffic_warn_flag(TRUE);
			mmi_set_led_double_blink();
		}
	} else {
		mmi_set_traffic_warn_flag(FALSE);
		mmi_stopLedTrafficWarnTimer();
		mmi_set_update_flag(MMI_TASK_NET);
	}
	return MMI_ERROR;

}

static VOID mmi_set_allleds_off(E_zMMI_BatLed_Mode mode)
{
	T_zMmi_Led_Info userInfo = {0};

	slog(MMI_PRINT, SLOG_NORMAL, "MMI mmi_set_allleds_off mode = %d\n", mode);
	mmi_set_traffic_warn_flag(FALSE);
	mmi_stopLedTrafficWarnTimer();
	mmi_clean_update_flag(MMI_TASK_NET);
	mmi_clean_update_flag(MMI_TASK_TRAFFIC);
	mmi_clean_update_flag(MMI_TASK_WIFI);
	
	mmi_clean_update_flag(MMI_TASK_NETSIGNAL);
	mmi_clean_update_flag(MMI_TASK_LED_WPS);
	mmi_clean_update_flag(MMI_TASK_RJ11);

	if (g_voicetask_enable)
		mmi_clean_update_flag(MMI_TASK_VOIP);
	else if (g_smstask_enable)
		mmi_clean_update_flag(MMI_TASK_SMS);

	if (mode == MODE_OFF) {
		userInfo.led_name = LED_BATTERY;
		userInfo.led_color = LED_COLOR_YELLOW;
		userInfo.led_state = LED_STATE_OFF;

		mmi_led_operate(&userInfo);
	} else if (mode == MODE_CHARGING) {

	} else if (mode == MODE_STANDBY) {
		userInfo.led_name = LED_BATTERY;
		userInfo.led_color = LED_COLOR_GREEN;
		userInfo.led_state = LED_STATE_BLINK;
		userInfo.ledBlink_time.uBlinkOffTime = LED_BREATH_BLINK_OFF_TIME;
		userInfo.ledBlink_time.uBlinkOnTime = LED_BREATH_BLINK_ON_TIME;
		mmi_led_operate(&userInfo);
	}
	userInfo.led_name = LED_WAN;
	userInfo.led_state = LED_STATE_OFF;
	userInfo.led_color = LED_COLOR_BLUE;
	mmi_led_operate(&userInfo);
	userInfo.led_color = LED_COLOR_BLUE;
	mmi_led_operate(&userInfo);
	userInfo.led_name = LED_LAN;
	mmi_led_operate(&userInfo);
	if (g_voicetask_enable)
		userInfo.led_name = LED_VOIP;
	else if (g_smstask_enable)
		userInfo.led_name = LED_SMS;
	mmi_led_operate(&userInfo);
	//yaoyuan cpe
	userInfo.led_color = LED_COLOR_BLUE;
	userInfo.led_name = LED_WPS;
	mmi_led_operate(&userInfo);
	userInfo.led_name = LED_RJ11;
	mmi_led_operate(&userInfo);
	userInfo.led_name = LED_SIGNAL;
	mmi_led_operate(&userInfo);
}

/**********************************************************************************
:ػʱеȫȫ
***********************************************************************************/
VOID mmi_set_allleds_blink(VOID)
{

	mmi_set_traffic_warn_flag(FALSE);
	mmi_stopLedTrafficWarnTimer();
	mmi_clean_update_flag(MMI_TASK_NET);
	mmi_clean_update_flag(MMI_TASK_TRAFFIC);
	mmi_clean_update_flag(MMI_TASK_WIFI);
	//yao yuan
	mmi_clean_update_flag(MMI_TASK_NETSIGNAL);
	mmi_clean_update_flag(MMI_TASK_LED_WPS);
	mmi_clean_update_flag(MMI_TASK_RJ11);

	if (g_voicetask_enable)
		mmi_clean_update_flag(MMI_TASK_VOIP);
	else if (g_smstask_enable)
		mmi_clean_update_flag(MMI_TASK_SMS);

	T_zMmi_Led_Info userInfo = {0};

	userInfo.led_name = LED_BATTERY;
	userInfo.led_state = LED_STATE_ON;
	userInfo.led_color = LED_COLOR_RED;
	mmi_led_operate(&userInfo);

	userInfo.led_name = LED_LAN;
	userInfo.led_color = LED_COLOR_BLUE;
	mmi_led_operate(&userInfo);

	if (g_voicetask_enable)
		userInfo.led_name = LED_VOIP;
	else if (g_smstask_enable)
		userInfo.led_name = LED_SMS;
	userInfo.led_color = LED_COLOR_BLUE;
	mmi_led_operate(&userInfo);

	userInfo.led_name = LED_WAN;
	if(g_customer_type == CUSTOMER_SDK_MIN)
		userInfo.led_color = LED_COLOR_GREEN;
	else
		userInfo.led_color = LED_COLOR_BLUE;
	mmi_led_operate(&userInfo);

	//yaoyuan cpe
	userInfo.led_color = LED_COLOR_BLUE;
	userInfo.led_name = LED_WPS;
	mmi_led_operate(&userInfo);
	userInfo.led_name = LED_RJ11;
	mmi_led_operate(&userInfo);
	userInfo.led_name = LED_SIGNAL;
	userInfo.traffic = TRAFFIC_LED_5;
	mmi_led_operate(&userInfo);


	mmi_sleep(LED_BLINK_TIME_INTERVAL);

	userInfo.led_state = LED_STATE_OFF;

	userInfo.led_name = LED_BATTERY;
	userInfo.led_color = LED_COLOR_RED;
	mmi_led_operate(&userInfo);

	userInfo.led_name = LED_LAN;
	userInfo.led_color = LED_COLOR_BLUE;
	mmi_led_operate(&userInfo);

	if (g_voicetask_enable)
		userInfo.led_name = LED_VOIP;
	else if (g_smstask_enable)
		userInfo.led_name = LED_SMS;
	userInfo.led_color = LED_COLOR_BLUE;
	mmi_led_operate(&userInfo);

	userInfo.led_name = LED_WAN;
	userInfo.led_color = LED_COLOR_BLUE;
	mmi_led_operate(&userInfo);
	//yaoyuan cpe
	userInfo.led_color = LED_COLOR_BLUE;
	userInfo.led_name = LED_WPS;
	mmi_led_operate(&userInfo);
	userInfo.led_name = LED_RJ11;
	mmi_led_operate(&userInfo);
	userInfo.led_name = LED_SIGNAL;
	mmi_led_operate(&userInfo);
	
	slog(MMI_PRINT, SLOG_DEBUG, "mmi_set_allleds_blink  off!\n");
}
SINT32 mmi_getLedCtrlInfo(UINT32 taskInfo, UINT32 outLedInfo)
{
	T_zMMICtrlInfo * pCtrlInfo = (T_zMMICtrlInfo *)taskInfo;
	T_zMmi_Led_Info* pLedInfo = (T_zMmi_Led_Info*)outLedInfo;

	pLedInfo->traffic = TRAFFIC_LED_MAX;
	slog(MMI_PRINT, SLOG_DEBUG, "MMI mmi_getLedCtrlInfo pCtrlInfo->ledmode = %d\n", pCtrlInfo->ledmode);
	switch (pCtrlInfo->ledmode) {
	case MMI_ACTIVE_MODE:
		mmi_set_update_flag(MMI_TASK_BATTERY);

		if (g_voicetask_enable)
			mmi_set_update_flag(MMI_TASK_VOIP);
		else if (g_smstask_enable)
			mmi_set_update_flag(MMI_TASK_SMS);

		mmi_set_update_flag(MMI_TASK_WIFI);
		mmi_set_update_flag(MMI_TASK_NET);
		mmi_set_update_flag(MMI_TASK_TRAFFIC);
		mmi_set_update_flag(MMI_TASK_LED_WPS);
		break;
	case MMI_IDLE_LEDOFF_MODE:
		if (g_customer_type == CUSTOMER_SDK || g_customer_type == CUSTOMER_SDK_MIN) {
			mmi_set_allleds_off(MODE_OFF);
		}		
		set_wake_unlock(MMI_MAIN_LOCK_ID);
		break;
	case MMI_IDLE_STANDBY_LEDOFF_MODE:
		if (g_customer_type == CUSTOMER_SDK || g_customer_type == CUSTOMER_SDK_MIN) {
			mmi_set_allleds_off(MODE_STANDBY);
		}		
		set_wake_unlock(MMI_MAIN_LOCK_ID);
		break;
	case MMI_FAKE_POWEROFF_MODE:
		mmi_set_allleds_off(MODE_OFF);
		set_wake_unlock(MMI_MAIN_LOCK_ID);
		break;
	case MMI_IDLE_CHG_LEDOFF_MODE:
		if (g_customer_type == CUSTOMER_SDK || g_customer_type == CUSTOMER_SDK_MIN) {
			mmi_set_allleds_off(MODE_CHARGING);
		}
		break;
	case MMI_FAKE_POWEROFF_CHARGE_MODE:
		mmi_set_update_flag(MMI_TASK_BATTERY);
		mmi_set_allleds_off(MODE_CHARGING);
		break;
	case MMI_POWEROFF_MODE:
	case MMI_RESET_MODE:
	case MMI_RESTART_MODE:
		if(g_customer_type == CUSTOMER_SDK || g_customer_type == CUSTOMER_SDK_MIN){
			mmi_set_allleds_blink();
		}
#ifndef DISABLE_LCD
		if (g_PowerOnOffFun != NULL) {
			slog(MMI_PRINT, SLOG_DEBUG, "mmi_set_allleds_blink  g_PowerOnOffFun!\n");
			g_PowerOnOffFun();
		}
#endif
		break;
	case MMI_FAST_POWERON_MODE:
		mmi_set_allleds_blink();
		mmi_set_update_flag(MMI_TASK_BATTERY);

		if (g_voicetask_enable)
			mmi_set_update_flag(MMI_TASK_VOIP);
		else if (g_smstask_enable)
			mmi_set_update_flag(MMI_TASK_SMS);

		mmi_set_update_flag(MMI_TASK_WIFI);
		mmi_set_update_flag(MMI_TASK_NET);
		mmi_set_update_flag(MMI_TASK_TRAFFIC);
		mmi_set_update_flag(MMI_TASK_LED_WPS);
		break;
	case MMI_POWEROFF_ON_MODE:
		break;
	default:
		break;
	}
	return MMI_ERROR;
}

SINT32 mmi_getLedPowerOffChagerInfo(UINT32 taskInfo, UINT32 outLedInfo)
{
	T_zMmi_Poc_Info *pPocInfo = (T_zMmi_Poc_Info *)taskInfo;
	T_zMmi_Led_Info* pLedInfo = (T_zMmi_Led_Info*)outLedInfo;
	pLedInfo->led_name = LED_BATTERY;
	pLedInfo->traffic = TRAFFIC_LED_MAX;
	pLedInfo->led_color = LED_COLOR_GREEN;

	if (pPocInfo->poc_sta == POC_STATE_FULL || pPocInfo->poc_sta == POC_STATE_TEMP_ERROR) {
		pLedInfo->led_state = LED_STATE_ON;
	}
	else if (pPocInfo->poc_sta == POC_STATE_LOWBATTERY) {
		pLedInfo->led_color = LED_COLOR_RED;
		pLedInfo->led_state = LED_STATE_ON;
	}
	else {
		pLedInfo->led_state = LED_STATE_BLINK;
		pLedInfo->ledBlink_speed = LED_STATE_BAT_BLINK;
	}
	return MMI_SUCCESS;

}

