#if _USE_BL

#include "zbl_ati.h"
#include "zcore_type.h"

UINT32 ZTE_Trace(UINT32 nModNo, UINT8 nPrintLevel, const VOID *pFormat, ...)
{
	return 0;
}

OS_STATUS zblMemFree(VOID **ppAddr)
{
    OS_STATUS nRet = OS_FAILURE;

    if((NULLPTR != ppAddr) && (NULLPTR != *ppAddr))
    {
        //nRet = free((VOID*)(*ppAddr));
        free((VOID*)(*ppAddr));
//        if(OS_FAILURE != nRet) cov2
	{
	    *ppAddr = NULLPTR;
	}
    }
    //return nRet;
    return OS_SUCCESS;
}
ZBL_CHANNEL_MSG_INFO * zblMallocChannelMsg(UINT32 nSize)
{
    ZBL_CHANNEL_MSG_INFO *msg_ptr = NULLPTR;

    msg_ptr = (ZBL_CHANNEL_MSG_INFO *) malloc(sizeof(ZBL_CHANNEL_MSG_INFO));
    if (msg_ptr == NULLPTR)
    {
        return NULLPTR;
    }

    memset((VOID *) msg_ptr, 0, sizeof(ZBL_CHANNEL_MSG_INFO));

    if (0 != nSize)
    {
        msg_ptr->msgData = malloc(nSize + 1); // һ'\0'
        if (msg_ptr->msgData == NULLPTR)
        {
            zblMemFree((VOID * *) &msg_ptr);
            return NULLPTR;
        }
        memset(msg_ptr->msgData, 0, nSize + 1);
    }

    return msg_ptr;
}

VOID zblFreeChannelMsg(ZBL_CHANNEL_MSG_INFO **ppMsg)
{
    if (NULLPTR == ppMsg)
    {
        zblAssert(0);
        return;
    }

    if (NULLPTR == *ppMsg)
    {
        zblAssert(0);
        return;
    }

    if (NULLPTR != (*ppMsg)->msgData)
    {
        /* free msg data */
        zblMemFree((VOID * *) &(*ppMsg)->msgData);
    }

    /* free msg pacekt */
    zblMemFree((VOID * *) ppMsg);
}

#define ATI_DEC_STR_MAX_LEN_16B 10
#define ATI_HEX_STR_MAX_LEN_16B 8
#define ATI_DECIMAL_CARRY 10
#define ATI_HEX_CARRY 16

#define  ATI_UPCASE( c ) ( ((c) >= 'a' && (c) <= 'z') ? ((c) - 0x20) : (c) )
BOOL AtStr2Value(CHAR *sStr , BOOL DorH, UINT32 * pValue)
{
    UINT8 i = 0;
    UINT8 j = 0;             /* ѭñ */
    UINT8 totalLen = 0;      /* ֵַ󳤶 */        
    UINT8 carry = 0;         /* λֵ */
    UINT8 sTemp[10] = {0};   /* ŵַӦֵ */
    UINT32 iValTmp = 0;      /* תֵ */

    if (sStr == NULL || pValue == NULL)
    {
        return FALSE;
    }

    /* ͬȵ10ַ16ַ󳤶Ⱥͽλֵͬ */
    totalLen = (DorH? ATI_DEC_STR_MAX_LEN_16B : ATI_HEX_STR_MAX_LEN_16B);
    carry = (DorH? ATI_DECIMAL_CARRY : ATI_HEX_CARRY);

    /* λַΧ,,򽫵ַתΪӦֵ,ݴ;
       ʧ,ѭ */
    for (i = 0; (*(sStr+i) != 0) && (i < totalLen); i++)
    {
        if ((*(sStr+i) >= '0') && (*(sStr+i) <= '9'))
        {
            *(sTemp+i) = *(sStr+i) - '0';
        }
        else if ((ATI_UPCASE(*(sStr+i)) >= 'A') && (ATI_UPCASE(*(sStr+i)) <= 'F') && (!DorH))
        {
            *(sTemp+i) = ATI_UPCASE(*(sStr+i)) - 'A' + 10;
        }
        else
        {
            return FALSE;
        }
    }

    /* ûг4ֵַֽ󳤶ȣ
       򽫵ֵַӸλλ˳λۼ */
    iValTmp = sTemp[0];
    for(j = 0; j < i-1; j++)
    {
        if (iValTmp * carry <= 0xffffffff - sTemp[j + 1])
        {
            iValTmp = iValTmp * carry + sTemp[j + 1];
        }
    }

    *pValue = iValTmp;

    return TRUE;
}
VOID tp_os_mem_cpy(VOID* dest_ptr, const VOID* src_ptr, UINT32 copy_len)
{
	if ((NULL == src_ptr) || (0 == copy_len))
    {
         return;
    }
    memcpy(dest_ptr, src_ptr, copy_len);
}
BOOL isModemTestVersion()
{
	return FALSE;
}
UINT32 tapiPbGetStringLen(const UINT8 *pStr)
{
    UINT32 nLen = 0;
    UINT32 nIndex = 0;

    zblAssert(NULLPTR != pStr);
    
    if(NULLPTR == pStr)
    {
        return 0;
    }
    
    if(*pStr == 0x80)
    {
        nIndex = 1;    
        while((*(pStr + nIndex) != 0) ||(*(pStr + nIndex + 1) != 0))
        { 
            nIndex += 2;				
        }
        nLen = nIndex;		
    }
    else
    {
        nLen = strlen((CHAR*)pStr);
    }

    return nLen;
}
static BOOL tapiPbConvertAsiciiToUint8(UINT8   uCurrentAsciiCode, UINT8   *byteHigh)
{
    if (uCurrentAsciiCode >= 'A' && uCurrentAsciiCode <= 'F')
    {
        *byteHigh = uCurrentAsciiCode - 'A' + 0xa;
    }
    else if (uCurrentAsciiCode >= 'a' && uCurrentAsciiCode <= 'f')
    {
        *byteHigh = uCurrentAsciiCode - 'a' + 0xa;
    }
    else if (uCurrentAsciiCode >= '0' && uCurrentAsciiCode <= '9')
    {
        *byteHigh = uCurrentAsciiCode - '0';
    }
    else
    {
       // ZTE_Trace(ZBL_PB,  PRN_NOMAL,  "zblPbConvertAsciiToUnicode character is %c", uCurrentAsciiCode);
        zblAssert(0);
        return FALSE;
    }    
    return TRUE;
}
BOOL tapiPbConvertAsciiToUnicode(UINT8 *DestinationStr,UINT8 *upOriginationStr,UINT32 uStrLen)
{
    UINT8   uCurrentAsciiCode   = 0;
    UINT8   uAsciiCode          = 0;
    UINT8   byteHigh            = 0;
    UINT8   byteLow             = 0;
    UINT16  i                   = 0;
    UINT16  uPosition           = 1;            
    
    if (upOriginationStr == NULL)
    {
        zblAssert(0);
        return FALSE;
    }
    zblAssert(tapiPbGetStringLen(upOriginationStr) <= 256); //Ϊ256ֵݴڵı
    zblAssert(uStrLen <= 256);
    
    DestinationStr[0] = 0x80; //0x80ͷԱʶ
    
    while (i < uStrLen)
    {
        uCurrentAsciiCode = *(upOriginationStr + i);
        if(!tapiPbConvertAsiciiToUint8(uCurrentAsciiCode, &byteHigh))
        {
            //ZTE_Trace(ZBL_PB,  PRN_NOMAL,  "zblPbConvertAsciiToUnicode character is %c", uCurrentAsciiCode);
            zblAssert(0);
            return FALSE;
        }
        i++;
        
        uCurrentAsciiCode = *(upOriginationStr + i);
        if(!tapiPbConvertAsiciiToUint8(uCurrentAsciiCode, &byteLow))
        {
            //ZTE_Trace(ZBL_PB,  PRN_NOMAL, "zblPbConvertAsciiToUnicode character is %c",  uCurrentAsciiCode);
            zblAssert(0);
            return FALSE;
        }
        i++;
        
        uAsciiCode = 0;
        uAsciiCode |= byteHigh << 4;
        uAsciiCode |= byteLow;
        
        DestinationStr[uPosition] = uAsciiCode;
        uPosition++;
    }
    return TRUE;
}
SINT32 String2Bytes(CONST CHAR* pSrc, UINT8* pDst, SINT32 nSrcLength)
{
    SINT32 i=0;
    
    //У
    if(pSrc ==  NULL || pDst == NULL || nSrcLength < 0)
    {
        return -1;
    }

    for(i=0; i<nSrcLength; i+=2)
    {
        // 4λ
        if(*pSrc>='0' && *pSrc<='9')
        {
            *pDst = (*pSrc - '0') << 4;
        }
        else
        {
            *pDst = (*pSrc - 'A' + 10) << 4;
        }

        pSrc++;

        // 4λ
        if(*pSrc>='0' && *pSrc<='9')
        {
            *pDst |= *pSrc - '0';
        }
        else
        {
            *pDst |= *pSrc - 'A' + 10;
        }

        pSrc++;
        pDst++;
    }

    // Ŀݳ
    return nSrcLength / 2;
}
OS_STATUS tp_os_mem_free(VOID *mem_ptr)
{
	if (NULL == mem_ptr)
    {        
        return -1;
    }

    free (mem_ptr);
    return 0;
}
SINT32 Encode7bit(CONST CHAR* pSrc, UINT8* pDst, SINT32 nSrcLength)
{
    SINT32 nSrc;		// Դַļֵ
    SINT32 nDst;		// Ŀ봮ļֵ
    SINT32 nChar=0;		// ǰڴַֽڵţΧ0-7
    UINT8 nLeft=0;	// һֽڲ

    //У
    if(pSrc ==  NULL || pDst == NULL || nSrcLength < 0)
    {
        return -1;
    }

    // ֵʼ
    nSrc = 0;
    nDst = 0;

    // Դÿ8ֽڷΪһ飬ѹ7ֽ
    // ѭộֱԴ
    // 鲻8ֽڣҲȷ
    while(nSrc<nSrcLength)
    {
        // ȡԴַļֵ3λ
        nChar = nSrc & 7;

        // Դÿֽ
        if(nChar == 0)
        {
            // ڵһֽڣֻǱһֽʱʹ
            nLeft = *pSrc;
        }
        else
        {
            // ֽڣұ߲ӣõһĿֽ
            *pDst = (*pSrc << (8-nChar)) | nLeft;

            // ֽʣµ߲֣Ϊݱ
            nLeft = *pSrc >> nChar;

            // ޸Ŀ괮ָͼֵ
            pDst++;
            nDst++;
        }

        // ޸Դָͼֵ
        pSrc++;
        nSrc++;
    }

    // Ŀ괮
    return nDst;

}
SINT32 Encode8bit(CONST CHAR* pSrc, UINT8* pDst, SINT32 nSrcLength)
{
    //У
    if(pSrc ==  NULL || pDst == NULL || nSrcLength < 0)
    {
        return -1;
    }

    // 򵥸
    memcpy(pDst, pSrc, nSrcLength);

    return nSrcLength;
}
SINT32 SerializeNumbers(CONST CHAR* pSrc, CHAR* pDst, SINT32 nSrcLength)
{
    SINT32 nDstLength=0;/* Ŀַ*/
    CHAR ch=0;			/* ڱһַ*/
    SINT32 i = 0;

    if(pSrc ==  NULLPTR || pDst == NULLPTR || nSrcLength < 0)
    {
        return -1;
    }

    /* ƴ*/
    nDstLength = nSrcLength;

    /* ߵ*/
    for(i=0; i<nSrcLength;i+=2)
    {
        ch = *pSrc++;		/* ȳֵַ*/
        *pDst++ = *pSrc++;	/* ƺֵַ*/
        *pDst++ = ch;		/* ȳֵַ*/
    }

    /* ַ'F'*/
    if(*(pDst-1) == 'F')
    {
        pDst--;
        nDstLength--;		/* Ŀַȼ1*/
    }

    /* ַӸ*/
    *pDst = '\0';

    /* Ŀַ*/
    return nDstLength;
}
#endif
