
#include <limits.h>

#include "softap_api.h"

#include "wifi_util.h"
#include "hotplug.h"

int wifi_app_msg_parse(const char *msg, int msglen, struct hotplug_event *event);

//#define UEVENT_BUFFER_SIZE   1024*2

#define WIFI_STA_NUM_CHANGE_TIMER_ID  120

int g_sta_num_change_timer = 0;

static const char *search_netlink (const char *key, const char *buf, size_t len)
{
	size_t curlen = 0;
	size_t keylen = strlen ( (char *) key);
	char *cur = (char *) buf;

	while (cur < buf + len - keylen) {
		curlen = strlen (cur);
		if (curlen == 0)
			break;
		//wf_log("[nfhu] search_netlink received data:%s",cur);

		if (!strncmp (key, cur, keylen) && cur[keylen] == '=') {
			//wf_log(" search_netlink creceived data:%s",cur + keylen + 1);
			return cur + keylen + 1;
		}
		cur += (curlen + 1);
	}
	return NULL;
}

int wifi_set_netlink_event()
{
	struct sockaddr_nl addr;
	int s = -1;

	wf_log ("wifi_set_netlink_event ");

	memset (&addr, 0, sizeof (struct sockaddr_nl));
	addr.nl_family = AF_NETLINK;
	addr.nl_pid = 0;//getpid();
	addr.nl_groups = 1;
	s = socket (PF_NETLINK, SOCK_DGRAM, NETLINK_KOBJECT_UEVENT);
	wf_log ("[wlan-server]create socket ");
	if (s < 0)
		return -1;

//	setsockopt (s, SOL_SOCKET, SO_RCVBUF, &sz, sizeof (sz));
//	wf_log ("[wlan-server]setsockopt ");
	if (bind (s, (struct sockaddr *) &addr, sizeof (struct sockaddr_nl)) < 0) {
		close (s);
		return -1;
	}
	return s;
}


void *send_message_to_main_thread(void *arg)
{
	g_sta_num_change_timer = 0;
	ipc_send_message (MODULE_ID_WLAN_SERVER, MODULE_ID_WIFI, MSG_CMD_STA_COUNT_CHANGE, 0, NULL, 0);
	return NULL;
}

void create_sta_num_change_timer(void)
{
	if (g_sta_num_change_timer) {
		sc_timer_delete(WIFI_STA_NUM_CHANGE_TIMER_ID);		
		wf_log ("delete and recreate 1S timer");
	}else{		
		wf_log ("create 1s timer");
	}
	
	sc_timer_create (WIFI_STA_NUM_CHANGE_TIMER_ID, 
		TIMER_FLAG_ONCE, 
		1000, 
		send_message_to_main_thread, 
		NULL);
	
	g_sta_num_change_timer = 1;
	wf_log ("g_sta_num_change_timer=%d", g_sta_num_change_timer);
	return;
}


static void wifi_process_netlink_event (int netlink_fd)
{
	int len = -1;
	char netlinkbuf[UEVENT_BUFFER_SIZE] = {0};
	//char log_buf[128] = {0};

	len = recv (netlink_fd, netlinkbuf, sizeof(netlinkbuf)-1, 0);//cov
	if (len <= 0) {
		perror ("[wlan-server]receive from netlink error");
		return;
	}
	netlinkbuf[UEVENT_BUFFER_SIZE-1] = '\0';
//klocwork
	//memset (log_buf, 0, strlen (log_buf));
	//sprintf (log_buf, "[wlan-server] received data:%s", netlinkbuf);
	//ӡϱueventϢϱַ
	//perror (log_buf);

	wifi_app_msg_parse(netlinkbuf, len, NULL);
}

int wifi_app_msg_parse(const char *msg, int msglen, struct hotplug_event *event)
{
	int byte_counts = msglen;
	char crash_down[12] = {0};
	int crash_down_count = 0;
	const char *keys = NULL;
	const char *subsys = NULL;
	const char *action = NULL;
	const char *dhdisDown = NULL;
	const char *bcmevent = NULL;
	const char *power_supply_name = NULL;
	const char *sta_num_va0 = NULL;
	const char *sta_num_va1 = NULL;
	char sta_count[8] = {0};
	char m_sta_count[8] = {0};

	keys = (char *) (msg + strlen ( (char *) msg) + 1);
	byte_counts -= (strlen ( (char*) msg) + 1);
	//ַ

//	  memset(log_buf,0,strlen(log_buf));
//	  sprintf(log_buf,"[wlan-server] received keys:%s",keys);

	//Ĺؼֽ
	subsys = search_netlink ("SUBSYSTEM", keys, byte_counts);
//	  memset(log_buf,0,strlen(log_buf));
//	  sprintf(log_buf,"[wlan-server] subsys:%s\n",subsys);

	action = search_netlink ("ACTION", keys, byte_counts);
//	  memset(log_buf,0,strlen(log_buf));
//	  sprintf(log_buf,"[wlan-server] action:%s\n",action);

	power_supply_name = search_netlink ("POWER_SUPPLY_NAME", keys, byte_counts);

	dhdisDown = search_netlink ("DHDISDOWN", keys, byte_counts);
//	  memset(log_buf,0,strlen(log_buf));
//	  sprintf(log_buf,"[wlan-server] dhdisDown:%s\n",dhdisDown);

	sta_num_va0 = search_netlink ("EVENT_VA0_STA_NUM", keys, byte_counts);
	sta_num_va1 = search_netlink ("EVENT_VA1_STA_NUM", keys, byte_counts);

	sc_cfg_get ("wifi_crash_down", crash_down, sizeof (crash_down));
	crash_down_count = atoi (crash_down);
	if(crash_down_count < 0 || crash_down_count > INT_MAX-1)
		crash_down_count = 0;//kloocwrk

//	wf_log ("crash_down_count = %d",  crash_down_count);

	//va0 仯sta_count
	if (sta_num_va0 != NULL) {
		wf_log ("driver updates->sta_num_va0 = %s",  sta_num_va0);
	}

	if (sta_num_va1 != NULL) {
		wf_log ("driver updates->sta_num_va1 = %s",  sta_num_va1);
	}

	//ֵײpower_supplychange,ȥȡ״̬״̬ӦĵƲ
	if ( (subsys != NULL) && (action != NULL)) { // for kernel 3.0
		if ( (!strcmp (subsys, "power_supply")) && (!strcmp (action, "change"))
#ifdef __ZTE_LINUX__
			 &&  !strcmp (power_supply_name, "charger")
#endif
		   ) {
			//жǷǳ״̬ļı仯
			ipc_send_message (MODULE_ID_WLAN_SERVER, MODULE_ID_WIFI, MSG_CMD_USB_CHARGING_CHANGED, 0, NULL, 0);
			return -1;
		}
	}
	//wf_log ("wifi subsys:%s, action:%s, dhdisDown:%s.\n", subsys,action,dhdisDown);

	//ֵײwlan0change
	if ( (subsys != NULL) && (action != NULL) && (dhdisDown != NULL)) { // for kernel 3.0
		if (  (!strcmp (subsys, "platform") || !strcmp (subsys, "net") || !strcmp (subsys, "sdio")) && ! (strcmp (action, "change")) && ! (strcmp (dhdisDown, "1"))) {
			//жǷdhd crash down
			crash_down_count++;
			crash_down_count = crash_down_count > (INT_MAX-1) ? 1 : crash_down_count;
			memset (crash_down, 0, sizeof (crash_down));
			sprintf (crash_down, "%d", crash_down_count);
			sc_cfg_set ("wifi_crash_down", crash_down);

			wf_log ("wifi crash down %d ......", crash_down_count);
			ipc_send_message (MODULE_ID_WLAN_SERVER, MODULE_ID_WIFI, MSG_CMD_WIFI_FORCE_RESTART, 0, NULL, 0);
			return -1;
		}
	}

	if (sta_num_va0 != NULL  || sta_num_va1 != NULL) {
		wf_log ("create 1s softtimer to send sta change msg");
		create_sta_num_change_timer();
	}

	return -1;
}


/*
 * ߳: յײϱnetlinkϢҪϢ:
 *             1. usbϢʡ磬ʱʡ
 *             2. wificrashϢ
 *             3. wifiû仯Ϣ
 */
void *netlink_loop (void *param)
{
	int charging_netlink = -1;
	int fd_counts = -1;
	fd_set readfds;
	char name[32] = {0};

	wf_log ("netlink_loop param=%s", (char*) param);
	strncpy(name, (char*) param, sizeof(name)-1);

	if ( (charging_netlink = wifi_set_netlink_event()) < 0) {
		wf_log ("charging_netlink wrong ");
		return NULL;
	}

	wf_log (" netlink netlink_loop getpid=%d", getpid());

	prctl (PR_SET_NAME, name, 0, 0, 0);

	while (1) {    //charging״̬Ĳ
		FD_ZERO (&readfds); //readfdsʼΪռ
		FD_SET (charging_netlink, &readfds);     //charging_netlinkļݸreadfds

		//⵽仯ʱϱ
		fd_counts = select (charging_netlink + 1, &readfds, NULL, NULL, NULL);
		//wake_wait_lock();
		if (fd_counts < 0) {
			wf_log ("select usb_netlink error! ");
			continue;
		} else if (fd_counts == 0) {
			wf_log ("select usb_netlink timeout");
			continue;
		} else {
			if (charging_netlink > 0 && FD_ISSET (charging_netlink, &readfds)) {
				wifi_process_netlink_event (charging_netlink);
			}
		}
	}
}
