#include "zte_mainctrl.h"

char g_router_nvconfig_buf[ROUTER_NV_ITEM_VALUE_MAX_LEN];
char defwan_rel[ZTE_ROUTER_WAN_IF_NAME_LEN] = {0};

static char defwan6_rel[ZTE_ROUTER_WAN_IF_NAME_LEN] = {0};
//static struct url_list old_url_list;
extern int g_limit_time_flag;

#if (MODEM_TYPE == vehicle_dc)
struct list_head g_firewall_ip;

struct firewall_ip_queue {
	struct list_head list;
	char ip[ZTE_ROUTER_IP_ADDR_LEN];
};

#define FIREWALL_CHAIN                 "FIREWALL"

#endif

/******************************************************
* Func:    system_cmd_ex
* Desc:    do system cmd, but printf it first
* Input:
* Output:
* Return:
* Others:
* Modify Date    Version   Author         Modification
*
*******************************************************/

void str_vary_dit(char * str, char *result)
{
	char ch_num = 0;
	int i, firstnumber;
	char *pos = result;
	char *tmpstr;
	if (0 == strlen(str)) {
		result = NULL;
		return;
	}
	tmpstr = (char *)malloc(strlen(str) + 1);
	if (!tmpstr) {
		result = NULL;
		return;
	}
	memset(tmpstr, 0x00, strlen(str) + 1);
	strcpy(tmpstr, str);
	for (i = 0; i < strlen(str); i ++) {
		if (str[i] != '.') {
			continue;
		}
		break;
	}
	firstnumber = i;
	for (i = strlen(str) - 1; i >= 0; i --) {
		if (tmpstr[i] != '.') {
			ch_num ++;
		} else {
			tmpstr[i] = ch_num;
			ch_num = 0;
		}
	}
	pos = result;
	sprintf(pos, "%.2x", firstnumber);
	pos += 2;
	for (i = 0; i < strlen(str); i ++) {
		sprintf(pos, "%.2x", tmpstr[i]);
		pos += 2;
	}
	//sprintf(pos, "%.2x", 0);
	free(tmpstr);
	tmpstr = NULL;
}

void system_cmd_ex(char * cmd)
{
	int rtn = -1;
	if (NULL == cmd) {
		slog(NET_PRINT, SLOG_ERR, "system_cmd_ex: NULL-------------------------------\n");
		return;
	}

	rtn = soft_system(cmd);

	if (0 != rtn) {
		slog(NET_PRINT, SLOG_ERR, "cmd [%s] failed \n", cmd);
	}
	return;
}

int zte_router_nvconfig_read(char *i_item_name)
{
	if (NULL == i_item_name) {
		slog(NET_PRINT, SLOG_ERR, "[router_nvconfig_read] , point null\n");
		return 0;
	}
	memset(g_router_nvconfig_buf, 0, sizeof(g_router_nvconfig_buf));
	sc_cfg_get(i_item_name, g_router_nvconfig_buf, sizeof(g_router_nvconfig_buf));

	return 1;

}

static int isAllNumAndSlash(char *str)
{
	int i = 0;
	int len = 0;
	if (NULL == str) {
		slog(NET_PRINT, SLOG_ERR, "isAllNumAndSlash: str in is NULL\n");
		return 0;
	}
	len = (int)strlen(str);
	for (i = 0; i < len; i++) {
		if ((str[i] >= '0' && str[i] <= '9') || str[i] == '.' || str[i] == '/')
			continue;
		return 0;
	}
	return 1;
}
static int isNumOnly(char *str)
{
	int i = 0;
	int len = 0;
	if (NULL == str) {
		slog(NET_PRINT, SLOG_ERR, "isNumOnly: str in is NULL\n");
		return 0;
	}
	len = (int)strlen(str);
	for (i = 0; i < len; i++) {
		if ((str[i] >= '0' && str[i] <= '9'))
			continue;
		return 0;
	}
	return 1;
}
static int isOnlyOneSlash(char *str)
{
	int i = 0, count = 0;
	int len = 0;
	if (NULL == str) {
		slog(NET_PRINT, SLOG_ERR, "isOnlyOneSlash: str in is NULL\n");
		return 0;
	}
	len = (int)strlen(str);
	for (i = 0; i < len; i++)
		if (str[i] == '/')
			count++;
	return count <= 1 ? 1 : 0;
}

static int isIpValid(char *str)
{
	struct in_addr addr;    // for examination
	//if( (! strcmp(T("any"), str)) || (! strcmp(T("any/0"), str)))
	if ((! strcmp("any", str)) || (! strcmp("any/0", str)))
		return 1;

	if (!(inet_aton(str, &addr))) {
		slog(NET_PRINT, SLOG_ERR, "isIpValid(): %s is not a valid IP address.\n", str);
		return 0;
	}
	return 1;
}
static int isMacValid(char *str)
{
	int i = 0;
	int len = 0;
	if (NULL == str) {
		slog(NET_PRINT, SLOG_ERR, "isMacValid: NULL str ");
		return 0;
	}
	len = (int)strlen(str);
	if (len != 17)
		return 0;

	for (i = 0; i < 5; i++) {
		if ((!isxdigit(str[i * 3])) || (!isxdigit(str[i * 3 + 1])) || (str[i * 3 + 2] != ':'))
			return 0;
	}
	return (isxdigit(str[15]) && isxdigit(str[16])) ? 1 : 0;
}

static int isIpNetmaskValid(char *s)
{
	char str[32] = {0};
	char *slash;
	struct in_addr addr;    // for examination

	if (!s || !strlen(s)) {
		return 0;
	}

	strncpy(str, s, sizeof(str) - 1);

	if ((!strcmp("any", str)) || (!strcmp("any/0", str)))
		return 1;

	if (!isAllNumAndSlash(str)) {
		return 0;
	}

	if (!isOnlyOneSlash(str)) {
		return 0;
	}

	slash = strchr(str, '/');
	if (slash) {
		int mask;

		*slash = '\0';
		slash++;
		if (!strlen(slash)) {
			return 0;
		}

		if (!isNumOnly(slash)) {
			return 0;
		}

		mask = atoi(slash);
		if (mask < 0 || mask > 32) {
			return 0;
		}
	}

	if (!(inet_aton(str, &addr))) {
		slog(NET_PRINT, SLOG_ERR, "isIpNetmaskValid(): %s is not a valid IP address.\n", str);
		return 0;
	}
	return 1;
}

static void iptablesPortForwardFlush(void)
{
	system_cmd_ex("iptables -t nat -F "PORT_FORWARD_CHAIN);
	return;
}

/*
 * substitution of getNthValue which dosen't destroy the original value
 */
int getNthValueSafe(int index, char *value, char delimit, char *result, int len)
{
	int i = 0, result_len = 0;
	char *begin = NULL;
	char *end = NULL;
	if (!value || !result || !len) {
		slog(NET_PRINT, SLOG_ERR, "getNthValueSafe: null in\n");
		return -1;
	}

	begin = value;
	end = strchr(begin, delimit);

	while (i < index && end) {
		begin = end + 1;
		end = strchr(begin, delimit);
		i++;
	}

	//no delimit
	if (!end) {
		if (i == index) {
			end = begin + strlen(begin);
			result_len = (len - 1) < (end - begin) ? (len - 1) : (end - begin);
		} else
			return -1;
	} else
		result_len = (len - 1) < (end - begin) ? (len - 1) : (end - begin);

	memcpy(result, begin, result_len);
	*(result + result_len) = '\0';

	return 0;
}

void zte_router_ping_diagnostics(void)
{
	char cmd[256]		 	= {0};
	char ip_address[32] 	 	= {0};
	char diag_interface[32] 	= {0};
	char repetition_count[20] = {0};
	char time_out[20] 			= {0};
	char data_size[20] 	= {0};
	char path_tmp[50]         = {0};
	int len = 0;

	slog(NET_PRINT, SLOG_NORMAL, "router_ping_diagnostics start! \n");

	sc_cfg_get("ping_diag_addr", ip_address, sizeof(ip_address));
	sc_cfg_get("ping_repetition_count", repetition_count, sizeof(repetition_count));
	sc_cfg_get("ping_time_out", time_out, sizeof(time_out));
	sc_cfg_get("ping_data_size", data_size, sizeof(data_size));
	sc_cfg_get("ping_diag_interface", diag_interface, sizeof(diag_interface));

	if (!isIpValid(ip_address) || (0 == strlen(ip_address))) {
		slog(NET_PRINT, SLOG_ERR, "Error: router_ping_diagnostics, %s is not a valid IP address", ip_address);
		return;
	}

	system("killall ping");

	//ɾ֮ǰ洢ļ
	sc_cfg_get("path_tmp", path_tmp, sizeof(path_tmp));
	sprintf(cmd, "rm %s/ping_diagnostics.txt", path_tmp);
	slog(NET_PRINT, SLOG_NORMAL, "router_ping_diagnostics rm_cmd:%s \n", cmd);
	system_cmd_ex(cmd);

	//ping
	memset(cmd, 0, 256);
	sprintf(cmd, "ping ");
	if (strcmp(repetition_count, "") && strcmp(repetition_count, "\0")) {
		len = strlen(cmd);
		sprintf(cmd + len, "-c %d ", atoi(repetition_count));
	}

	if (strcmp(data_size, "") && strcmp(data_size, "\0")) {
		len = strlen(cmd);
		sprintf(cmd + len, "-s %d ", atoi(data_size));
	}

	if (strcmp(time_out, "") && strcmp(time_out, "\0")) {
		len = strlen(cmd);
		sprintf(cmd + len, "-w %d ", atoi(time_out));
	}

	if (strcmp(diag_interface, "") && strcmp(diag_interface, "\0")) {
		len = strlen(cmd);
		sprintf(cmd + len, "-I %s ", diag_interface);
	}

	len = strlen(cmd);
	slog(NET_PRINT, SLOG_DEBUG, "router_ping_diagnostics cmd:%s, len:%d \n", cmd, len);
	sprintf(cmd + len, "%s > %s/ping_diagnostics.txt & ", ip_address, path_tmp);

	slog(NET_PRINT, SLOG_NORMAL, "router_ping_diagnostics ping_cmd:%s \n", cmd);
	system_cmd_ex(cmd);
}

/******************************************************
* Function: zte_iptables_make_filter_rule()
* Description:  make filter rules, e.g.
*               iptables -A macipport_filter -m mac --mac-source [mac_address]
*                                                    -s 10.128.48.88
*                                                    -d 192.168.0.2
*                                                     -p tcp --sport 1:80 --dport 40:500
*                                                     -j ACCEPT
* Input:
* Output:
* Return:
* Others:
* Modify Date    Version   Author         Modification
* 2010/12/13      V1.0      MaXiaoliang        create
*******************************************************/
static void zte_iptables_make_filter_rule(char *buf, int len, char *mac_address,
        char *sip_1, char *sip_2, int sprf_int, int sprt_int,
        char *dip_1, char *dip_2, int dprf_int, int dprt_int, int proto, int action)
{
	int rc = 0;
	char *pos = buf;

	rc = snprintf(pos, len - rc,
	              "iptables -A %s ", IPPORT_FILTER_CHAIN);
	pos = pos + rc;

	// write mac address
	if (mac_address && strlen(mac_address)) {
		rc = snprintf(pos, len - rc, "-m mac --mac-source %s ", mac_address);
		pos = pos + rc;
	}

	// write source ip
	if (sip_1 && strlen(sip_1)) {
		rc = snprintf(pos, len - rc, "-s %s ", sip_1);
		pos = pos + rc;
	}

	// write dest ip
	if (dip_1 && strlen(dip_1)) {
		rc = snprintf(pos, len - rc, "-d %s ", dip_1);
		pos = pos + rc;
	}

	// write protocol type
	if (proto == PROTO_NONE) {
		rc = snprintf(pos, len - rc, " ");
		pos = pos + rc;
	} else if (proto == PROTO_ICMP) {
		rc = snprintf(pos, len - rc, "-p icmp ");
		pos = pos + rc;
	} else {
		if (proto == PROTO_TCP)
			rc = snprintf(pos, len - rc, "-p tcp ");
		else if (proto == PROTO_UDP)
			rc = snprintf(pos, len - rc, "-p udp ");
		pos = pos + rc;

		// write source port
		if (sprf_int) {
			if (sprt_int)
				rc = snprintf(pos, len - rc, "--sport %d:%d ", sprf_int, sprt_int);
			else
				rc = snprintf(pos, len - rc, "--sport %d ", sprf_int);
			pos = pos + rc;
		}

		// write dest port
		if (dprf_int) {
			if (dprt_int)
				rc = snprintf(pos, len - rc, "--dport %d:%d ", dprf_int, dprt_int);
			else
				rc = snprintf(pos, len - rc, "--dport %d ", dprf_int);
			pos = pos + rc;
		}
	}

	switch (action) {
	case ACTION_DROP:            // 1 == ENABLE--DROP mode
		rc = snprintf(pos, len - rc, "-j DROP");
		break;
	case ACTION_ACCEPT:            // 2 == ENABLE--ACCEPT mode
		rc = snprintf(pos, len - rc, "-j ACCEPT");
		break;
	default:
		slog(NET_PRINT, SLOG_ERR, "Unknown action %d.", action);
		break;
	}
}
/*===========================================================================
    Function:
        zte_make_filter_rules_ipv6

    Description:
        make ipportfilter rules.
        example:
            iptables -A macipport_filter
                        -m mac --mac-source 00:11:22:33:44:55
                        -m iprange --src-range 192.168.1.10-192.168.1.50
                        -m iprange --dst-range 10.128.10.10-10.128.10.100
                        -p tcp --sport 10:2000 --dport 4000:5000
                        -j DROP

    Param:
        buf - cmd buffer to store rule cmd
        len - length of cmd buffer
        mac_address - mac address
        sip_1 - source ip 1
        sip_2 - source ip 2 (not support now)
        sprf_int - source ip from port
        sprt_int - source ip to port
        dip_1 - dest ip 1
        dip_2 - dest ip 2 (not support now)
        dprf_int - dest ip from port
        dprt_int - dest ip to port
        proto - protocol
        action - accept or drop

    Modify Date     Version     Author                  Modification
    2010/07/12      V1.0        zhangyuelong10100551    Create
    2012/03/15      V1.1        liuweipeng            port
===========================================================================*/
void zte_make_filter_rules_v6(char *buf, int len, char *mac_address,
                              char *sip_1, char *sip_2, int sprf_int, int sprt_int,
                              char *dip_1, char *dip_2, int dprf_int, int dprt_int, int proto, int action)
{
	int rc = 0;
	char *pos = buf;

	/*begin by zhangyuelong10100551 2010.12.21*/
	if (NULL == buf) {
		slog(NET_PRINT, SLOG_ERR, "[ERROR]make_filter_rules_ipv6: buf NULL");
		return;
	}
	/*end by zhangyuelong10100551 2010.12.21*/

	rc = snprintf(pos, len - rc, "ip6tables -t filter -A %s ", IPPORT_FILTER_CHAIN);
	pos = pos + rc;

	// write mac address
	if (mac_address && strlen(mac_address)) {
		rc = snprintf(pos, len - rc, "-m mac --mac-source %s ", mac_address);
		pos = pos + rc;
	}

	// write source ip
	if (sip_1 && strlen(sip_1) > 0) {
		if (sip_2 && strlen(sip_2) > 0) {
			rc = snprintf(pos, len - rc, "-m iprange --src-range %s-%s ", sip_1, sip_2);
			pos = pos + rc;
		} else {
			rc = snprintf(pos, len - rc, "-s %s ", sip_1);
			pos = pos + rc;
		}
	} else {
		rc = snprintf(pos, len - rc, "-s any/0 ");
		pos = pos + rc;
	}

	// write dest ip
	if (dip_1 && strlen(dip_1) > 0) {
		if (dip_2 && strlen(dip_2) > 0) {
			rc = snprintf(pos, len - rc, "-m iprange --dst-range %s-%s ", dip_1, dip_2);
			pos = pos + rc;
		} else {
			rc = snprintf(pos, len - rc, "-d %s ", dip_1);
			pos = pos + rc;
		}
	} else {
		rc = snprintf(pos, len - rc, "-d any/0 ");
		pos = pos + rc;
	}

	// write protocol type
	if (proto == PROTO_NONE) {
		//rc = snprintf(pos, len-rc, " ");
		//pos = pos + rc;
	} else if (proto == PROTO_ICMP) {
		rc = snprintf(pos, len - rc, "-p icmpv6 ");
		pos = pos + rc;
	} else if (proto == PROTO_TCP || proto == PROTO_UDP) {
		if (proto == PROTO_TCP)
			rc = snprintf(pos, len - rc, "-p tcp ");
		else/* if (proto == PROTO_UDP)*/ //kw 3
			rc = snprintf(pos, len - rc, "-p udp ");
		pos = pos + rc;

		// write source port
		if (sprf_int) {
			if (sprt_int)
				rc = snprintf(pos, len - rc, "--sport %d:%d ", sprf_int, sprt_int);
			else
				rc = snprintf(pos, len - rc, "--sport %d ", sprf_int);
			pos = pos + rc;
		}

		// write dest port
		if (dprf_int) {
			if (dprt_int)
				rc = snprintf(pos, len - rc, "--dport %d:%d ", dprf_int, dprt_int);
			else
				rc = snprintf(pos, len - rc, "--dport %d ", dprf_int);
			pos = pos + rc;
		}
	}

	switch (action) {
	case ACTION_DROP:       // 1 == ENABLE--DROP mode
		rc = snprintf(pos, len - rc, "-j DROP");
		break;
	case ACTION_ACCEPT:     // 2 == ENABLE--ACCEPT mode
		rc = snprintf(pos, len - rc, "-j ACCEPT");
		break;
	default:
		slog(NET_PRINT, SLOG_ERR, "[ERROR]make_filter_rules_v6: unknown action");
		break;
	}
}  /* zte_make_filter_rules_v6() */

//modified by myc for web5.0 2012-12-12 //split the function zte_iptables_filter_run
void zte_iptables_filter_rule_run(void)
{
	char mac_address[32] = {0};
	char sprf[8] = {0};   /* source port from */
	char sprt[8] = {0};   /* source port to */
	char dprf[8] = {0};  /* dest port from */
	char dprt[8] = {0};  /* dest port to */
	char sip_1[32]  = {0};  /* src ip address */
	char sip_2[32]  = {0};
	char dip_1[32]  = {0};  /* dest ip address */
	char dip_2[32]  = {0};
	char protocol[8] = {0};
	char action_str[4] = {0};

	int i = 0;
	char rec[ROUTER_NV_FW_RULE_MAX_LEN] = {0};
	char cmd[ROUTER_NV_FW_RULE_MAX_LEN] = {0};
	//char rule[NV_FW_RULE_MAX_LEN] = {0};
	char tmp[ROUTER_DEFAULT_LEN] = {0};
	char sys_cmd_bufer[500] = {0};
	int sprf_int = 0;
	int sprt_int = 0;
	int dprf_int = 0;
	int dprt_int = 0;
	int proto = 0;
	int action = 0;

	for (i = 0; i < RULE_MAX; i++) {
		sprintf(tmp, "IPPortFilterRules_%d", i);
		memset(rec, 0, sizeof(rec));
		//zte_router_nvconfig_read(tmp);
		//strcpy(rec,g_router_nvconfig_buf);
		sc_cfg_get(tmp, rec, sizeof(rec));
		// get sip 1
		if ((getNthValueSafe(0, rec, ',', sip_1, sizeof(sip_1)) == -1)) {
			continue;
		}
		if (!isIpNetmaskValid(sip_1)) {
			continue;
		}

		// get source ip port range "from"
		if ((getNthValueSafe(2, rec, ',', sprf, sizeof(sprf)) == -1)) {
			continue;
		}
		if ((sprf_int = atoi(sprf)) > 65535) {
			continue;
		}

		// get dest ip port range "to"
		if ((getNthValueSafe(3, rec, ',', sprt, sizeof(sprt)) == -1)) {
			continue;
		}
		if ((sprt_int = atoi(sprt)) > 65535) {
			continue;
		}

		/* Destination Part */
		// get dip 1
		if ((getNthValueSafe(4, rec, ',', dip_1, sizeof(dip_1)) == -1)) {
			continue;
		}
		if (!isIpNetmaskValid(dip_1)) {
			continue;
		}

		// get dest ip port range "from"
		if ((getNthValueSafe(6, rec, ',', dprf, sizeof(dprf)) == -1)) {
			continue;
		}
		if ((dprf_int = atoi(dprf)) > 65535) {
			continue;
		}

		// get dest ip port range "to"
		if ((getNthValueSafe(7, rec, ',', dprt, sizeof(dprt)) == -1)) {
			continue;
		}
		if ((dprt_int = atoi(dprt)) > 65535) {
			continue;
		}

		// get protocol
		if ((getNthValueSafe(8, rec, ',', protocol, sizeof(protocol)) == -1)) {
			continue;
		}
		proto = atoi(protocol);

		// get action
		if ((getNthValueSafe(9, rec, ',', action_str, sizeof(action_str)) == -1)) {
			continue;
		}
		action = atoi(action_str);

		// getNthValueSafe(10) is "comment".

		// get mac address
		if ((getNthValueSafe(11, rec, ',', mac_address, sizeof(mac_address)) == -1)) {
			continue;
		}
		if (strlen(mac_address) && !isMacValid(mac_address)) {
			continue;
		}
		if (PROTO_TCP_UDP == proto) {
			zte_iptables_make_filter_rule(cmd, sizeof(cmd), mac_address, sip_1, sip_2, sprf_int, sprt_int, dip_1, dip_2, dprf_int, dprt_int, PROTO_TCP, action);
			memset(sys_cmd_bufer, 0, sizeof(sys_cmd_bufer));
			sprintf(sys_cmd_bufer, "%s %s", cmd, FMT_ECHO_IPTABLES_CMD);
			system_cmd_ex(sys_cmd_bufer);
			zte_iptables_make_filter_rule(cmd, sizeof(cmd), mac_address, sip_1, sip_2, sprf_int, sprt_int, dip_1, dip_2, dprf_int, dprt_int, PROTO_UDP, action);
			memset(sys_cmd_bufer, 0, sizeof(sys_cmd_bufer));
			sprintf(sys_cmd_bufer, "%s %s", cmd, FMT_ECHO_IPTABLES_CMD);
			system_cmd_ex(sys_cmd_bufer);
		} else {
			zte_iptables_make_filter_rule(cmd, sizeof(cmd), mac_address, sip_1, sip_2, sprf_int, sprt_int, dip_1, dip_2, dprf_int, dprt_int, proto, action);
			memset(sys_cmd_bufer, 0, sizeof(sys_cmd_bufer));
			sprintf(sys_cmd_bufer, "%s %s", cmd, FMT_ECHO_IPTABLES_CMD);
			system_cmd_ex(sys_cmd_bufer);
		}
	}
}

/******************************************************
* Function: zte_iptables_filter_run()
* Description:  load rules from "IPPortFilterRules", make rules, and run
* Input:
* Output:
* Return:
* Others:
* Modify Date    Version   Author         Modification
* 2010/12/13      V1.0      MaXiaoliang        create
*******************************************************/
void zte_iptables_filter_run(void)
{

	char firewall_enable[ROUTER_DEFAULT_LEN] = {0};
	char default_policy[ROUTER_DEFAULT_LEN] = {0};
	char sys_cmd_bufer[500] = {0};
	int filter_enable = 0;

	/*flush filter chain*/
	sprintf(sys_cmd_bufer, "iptables -F %s %s", IPPORT_FILTER_CHAIN, FMT_ECHO_IPTABLES_CMD);
	system_cmd_ex(sys_cmd_bufer);

	//zte_router_nvconfig_read("IPPortFilterEnable");
	//strcpy(firewall_enable , g_router_nvconfig_buf);
	sc_cfg_get("IPPortFilterEnable", firewall_enable, sizeof(firewall_enable));

	if (0 == strlen(firewall_enable)) {
		slog(NET_PRINT, SLOG_ERR, "IPPortFilter have been disable one .\n");
		system_cmd_ex("iptables -t filter -P FORWARD ACCEPT");
		return;
	}
	filter_enable = atoi(firewall_enable);
	/* if firewall is disable, then return directly: 0 mean disable, 1 means enable */
	if (0 == filter_enable) {
		system_cmd_ex("iptables -t filter -P FORWARD ACCEPT");
		slog(NET_PRINT, SLOG_ERR, "IPPortFilter have been disable two .\n");
		return;
	}

	/* 0: accept   1: drop */
	//zte_router_nvconfig_read("DefaultFirewallPolicy");
	//strcpy(default_policy , g_router_nvconfig_buf);
	sc_cfg_get("DefaultFirewallPolicy", default_policy, sizeof(default_policy));

	if (0 == strlen(default_policy)) {
		strcpy(default_policy, "0");
	}

	zte_iptables_filter_rule_run();

	memset(sys_cmd_bufer, 0, sizeof(sys_cmd_bufer));
	sprintf(sys_cmd_bufer, "iptables -t filter -A %s -m state --state RELATED,ESTABLISHED -j ACCEPT", IPPORT_FILTER_CHAIN);
	system_cmd_ex(sys_cmd_bufer);


	switch (atoi(default_policy)) {
	case 0:
		system_cmd_ex("iptables -t filter -P FORWARD ACCEPT");
		break;
	case 1:
		system_cmd_ex("iptables -t filter -P FORWARD DROP");
		break;
	default:
		slog(NET_PRINT, SLOG_ERR, "Unknown default_policy %d.", atoi(default_policy));
		break;
	}

}

/******************************************************
* Function: zte_iptables_sys_fw_run()
* Description:  make system security rules, then run, e.g.
*                   iptables -A INPUT -i ppp0 -p icmp --icmp-type echo-reply -j ACCEPT
*                   iptables -t filter -A INPUT -i ppp0  -j DROP             // disable remote control
*                   iptables -t filter -A INPUT -i ppp0 -p icmp -j DROP  // disable ping
* Input:
* Output:
* Return:
* Others:
* Modify Date    Version   Author         Modification
* 2010/12/13      V1.0      MaXiaoliang        create
*******************************************************/
void zte_iptables_sys_fw_run(void)
{
	char rmE[ROUTER_NV_FW_RULE_MAX_LEN]  = {0};
	char wpfE[ROUTER_NV_FW_RULE_MAX_LEN] = {0};
	char sys_cmd_bufer[500] = {0};
	//zte_router_nvconfig_read("RemoteManagement");
	///strcpy(rmE , g_router_nvconfig_buf);
	sc_cfg_get("RemoteManagement", rmE, sizeof(rmE));

	//zte_router_nvconfig_read("WANPingFilter");
	//strcpy(wpfE ,g_router_nvconfig_buf);
	sc_cfg_get("WANPingFilter", wpfE, sizeof(wpfE));


	/* flush INPUT chain is OK;  the macipport_filter chain is in FORWARD chain. */
	system_cmd_ex("iptables -t filter -F INPUT");
	/*added by myc for shutdown 1900 and 53 port to wan 2013-05-22 begin*/
	memset(sys_cmd_bufer, 0, sizeof(sys_cmd_bufer));
	sprintf(sys_cmd_bufer, "iptables -t filter -A INPUT -i %s -p tcp --dport 1900 -j DROP ", defwan_rel);
	system_cmd_ex(sys_cmd_bufer);
	/*added by myc for shutdown 1900 and 53 port to wam 2013-05-22 end*/
	/* allow request to dnsmasq from the lan */
	//system_cmd_ex("iptables -t filter -I INPUT -p udp --sport 53  -j ACCEPT");
	//system_cmd_ex("iptables -t filter -I INPUT -p udp --dport 53  -j ACCEPT");
	//system_cmd_ex("iptables -t filter -I INPUT -p tcp --sport 53  -j ACCEPT");
	//system_cmd_ex("iptables -t filter -I INPUT -p tcp --dport 53  -j ACCEPT");

	/* modify by dlf begin, --2016-09-7 */
	//簲ȫfor lan ssh
#if 0 //for aq
	system_cmd_ex("iptables -A INPUT -p tcp --dport 22 -j DROP");
	system_cmd_ex("iptables -A INPUT -p udp --dport 22 -j DROP");
	system_cmd_ex("iptables -A INPUT -p tcp --dport 5555 -j DROP");
	system_cmd_ex("iptables -A INPUT -p udp --dport 5555 -j DROP");
#endif
	//簲ȫfor wan
	//disable 22sh
	/*
	memset(sys_cmd_bufer,0,sizeof(sys_cmd_bufer));
	sprintf(sys_cmd_bufer,"iptables -t filter -A INPUT -i %s -p udp --dport 22 -j DROP", defwan_rel);
	system_cmd_ex(sys_cmd_bufer);
	memset(sys_cmd_bufer,0,sizeof(sys_cmd_bufer));
	sprintf(sys_cmd_bufer,"iptables -t filter -A INPUT -i %s -p tcp --dport 22 -j DROP", defwan_rel);
	system_cmd_ex(sys_cmd_bufer);
	*/
	//disable 23telnet
	/*
	memset(sys_cmd_bufer, 0, sizeof(sys_cmd_bufer));
	sprintf(sys_cmd_bufer, "iptables -t filter -A INPUT -i %s -p udp --dport 23 -j DROP", defwan_rel);
	system_cmd_ex(sys_cmd_bufer);
	memset(sys_cmd_bufer, 0, sizeof(sys_cmd_bufer));
	sprintf(sys_cmd_bufer, "iptables -t filter -A INPUT -i %s -p tcp --dport 23 -j DROP", defwan_rel);
	system_cmd_ex(sys_cmd_bufer);
	*/
	//disable 53domin
	
	memset(sys_cmd_bufer,0,sizeof(sys_cmd_bufer));
	sprintf(sys_cmd_bufer,"iptables -t filter -A INPUT -i %s -p udp --dport 53 -j DROP", defwan_rel);
	system_cmd_ex(sys_cmd_bufer);
	memset(sys_cmd_bufer,0,sizeof(sys_cmd_bufer));
	sprintf(sys_cmd_bufer,"iptables -t filter -A INPUT -i %s -p tcp --dport 53 -j DROP", defwan_rel);
	system_cmd_ex(sys_cmd_bufer);
	memset(sys_cmd_bufer,0,sizeof(sys_cmd_bufer));
	sprintf(sys_cmd_bufer,"ip6tables -t filter -A INPUT -i %s -p udp --dport 53 -j DROP", defwan6_rel);
	system_cmd_ex(sys_cmd_bufer);
	memset(sys_cmd_bufer,0,sizeof(sys_cmd_bufer));
	sprintf(sys_cmd_bufer,"ip6tables -t filter -A INPUT -i %s -p tcp --dport 53 -j DROP", defwan6_rel);
	system_cmd_ex(sys_cmd_bufer);

	sprintf(sys_cmd_bufer,"iptables -t filter -A INPUT -i %s -p udp --dport 67 -j DROP", defwan_rel);
	system_cmd_ex(sys_cmd_bufer);
	memset(sys_cmd_bufer,0,sizeof(sys_cmd_bufer));
	sprintf(sys_cmd_bufer,"ip6tables -t filter -A INPUT -i %s -p udp --dport 67 -j DROP", defwan6_rel);
	system_cmd_ex(sys_cmd_bufer);
	
	//disable 1900upnp
	memset(sys_cmd_bufer, 0, sizeof(sys_cmd_bufer));
	sprintf(sys_cmd_bufer, "iptables -t filter -A INPUT -i %s -p udp --dport 1900 -j DROP", defwan_rel);
	system_cmd_ex(sys_cmd_bufer);
	memset(sys_cmd_bufer, 0, sizeof(sys_cmd_bufer));
	sprintf(sys_cmd_bufer, "iptables -t filter -A INPUT -i %s -p tcp --dport 1900 -j DROP", defwan_rel);
	system_cmd_ex(sys_cmd_bufer);
	memset(sys_cmd_bufer, 0, sizeof(sys_cmd_bufer));
	sprintf(sys_cmd_bufer, "ip6tables -t filter -A INPUT -i %s -p udp --dport 1900 -j DROP", defwan_rel);
	system_cmd_ex(sys_cmd_bufer);
	memset(sys_cmd_bufer, 0, sizeof(sys_cmd_bufer));
	sprintf(sys_cmd_bufer, "ip6tables -t filter -A INPUT -i %s -p tcp --dport 1900 -j DROP", defwan_rel);
	system_cmd_ex(sys_cmd_bufer);
	//disable 5555freeciv
	/*
	memset(sys_cmd_bufer,0,sizeof(sys_cmd_bufer));
	sprintf(sys_cmd_bufer,"iptables -t filter -A INPUT -i %s -p udp --dport 5555 -j DROP", defwan_rel);
	system_cmd_ex(sys_cmd_bufer);
	memset(sys_cmd_bufer,0,sizeof(sys_cmd_bufer));
	sprintf(sys_cmd_bufer,"iptables -t filter -A INPUT -i %s -p tcp --dport 5555 -j DROP", defwan_rel);
	system_cmd_ex(sys_cmd_bufer);
	*/
	/* modify by dlf end, --2016-09-7 */

	/* modify by maxl begin, --2011-01-28 */
	/*added by myc for shutdown 1900 and 53 port to wan 2013-05-22 begin*/
	//memset(sys_cmd_bufer,0,sizeof(sys_cmd_bufer));
	//sprintf(sys_cmd_bufer,"iptables -t filter -I INPUT -i %s -p tcp --dport 53 -j DROP ", defwan_rel);
	// system_cmd_ex(sys_cmd_bufer);
	/*added by myc for shutdown 1900 and 53 port to wam 2013-05-22 end*/
	/*open telnet 4719 port*/
#if 0 //for aq
	system_cmd_ex("iptables -t filter -I INPUT -p tcp --dport 4719 -j ACCEPT");
	system_cmd_ex("iptables -t filter -I INPUT -p udp --dport 4719 -j ACCEPT");
#endif	
	/* modify by maxl end, --2011-01-28 */

	/* allow ping from WAN interface */
	memset(sys_cmd_bufer, 0, sizeof(sys_cmd_bufer));
	sprintf(sys_cmd_bufer, "iptables -A INPUT -i %s -p icmp --icmp-type echo-reply -j ACCEPT", defwan_rel);
	system_cmd_ex(sys_cmd_bufer);

	system_cmd_ex("ip6tables -t filter -F INPUT");
	system_cmd_ex("ip6tables -t filter -I INPUT -p udp --sport 53 -j ACCEPT");
	system_cmd_ex("ip6tables -t filter -I INPUT -p udp --dport 53 -j ACCEPT");
	system_cmd_ex("ip6tables -t filter -I INPUT -p tcp --sport 53 -j ACCEPT");
	system_cmd_ex("ip6tables -t filter -I INPUT -p tcp --dport 53 -j ACCEPT");
	system_cmd_ex("ip6tables -t filter -I INPUT -p tcp --dport 23 -j DROP");
	system_cmd_ex("ip6tables -t filter -I INPUT -p udp --dport 23 -j DROP");
	// allow ping from WAN interface
	memset(sys_cmd_bufer, 0, sizeof(sys_cmd_bufer));
	sprintf(sys_cmd_bufer, "ip6tables -A INPUT -i %s -p icmpv6 --icmpv6-type echo-reply -j ACCEPT", defwan6_rel);
	system_cmd_ex(sys_cmd_bufer);

	/* remote management is enable */
	if (atoi(rmE) == 1) {
		/*
		 * The INPUT chain will be flushed every time, and the default policy of INPUT is ACCEPT,
		 * so it needn't to add the rules for RemoteManagement.
		 */
	} else { /* disable */
		//system_cmd_ex("iptables -t filter -A INPUT -i %s  -j DROP", defwan_rel);
		memset(sys_cmd_bufer, 0, sizeof(sys_cmd_bufer));
		sprintf(sys_cmd_bufer, "iptables -t filter -A INPUT -i %s -p tcp --dport 80  -j DROP", defwan_rel);
		system_cmd_ex(sys_cmd_bufer);

		memset(sys_cmd_bufer, 0, sizeof(sys_cmd_bufer));
		sprintf(sys_cmd_bufer, "ip6tables -t filter -A INPUT -i %s -p tcp --dport 80 -j DROP", defwan6_rel);
		system_cmd_ex(sys_cmd_bufer);

		memset(sys_cmd_bufer, 0, sizeof(sys_cmd_bufer));
		sprintf(sys_cmd_bufer, "iptables -t filter -A INPUT -i %s -p tcp --dport 443  -j DROP", defwan_rel);
		system_cmd_ex(sys_cmd_bufer);

		memset(sys_cmd_bufer, 0, sizeof(sys_cmd_bufer));
		sprintf(sys_cmd_bufer, "ip6tables -t filter -A INPUT -i %s -p tcp --dport 443 -j DROP", defwan6_rel);
		system_cmd_ex(sys_cmd_bufer);
	}

	/* allow ping */
	if (atoi(wpfE) == 1) { /* enable */
		memset(sys_cmd_bufer, 0, sizeof(sys_cmd_bufer));
		sprintf(sys_cmd_bufer, "iptables -t filter -I INPUT -i %s -p icmp -j ACCEPT", defwan_rel);
		system_cmd_ex(sys_cmd_bufer);

		memset(sys_cmd_bufer, 0, sizeof(sys_cmd_bufer));
		sprintf(sys_cmd_bufer, "ip6tables -t filter -I INPUT -i %s -p icmpv6 -j ACCEPT", defwan6_rel);
		system_cmd_ex(sys_cmd_bufer);
	} else {                     /* disable */
		memset(sys_cmd_bufer, 0, sizeof(sys_cmd_bufer));
		sprintf(sys_cmd_bufer, "iptables -t filter -A INPUT -i %s -p icmp -j DROP", defwan_rel);
		system_cmd_ex(sys_cmd_bufer);

		memset(sys_cmd_bufer, 0, sizeof(sys_cmd_bufer));
		//sprintf(sys_cmd_bufer, "ip6tables -t filter -A INPUT -i %s -p icmpv6 -j DROP", defwan_rel);
		sprintf(sys_cmd_bufer, "ip6tables -t filter -A INPUT -i %s -p icmpv6 --icmpv6-type echo-request -j DROP", defwan6_rel);
		system_cmd_ex(sys_cmd_bufer);
	}

	// vpn pass through
	//system_cmd_ex("vpn_pass.sh");

}


static void zte_iptables_make_DMZ_Rule(char *buf, int len, char *wan_name, char *ip_address)
{
	/* iptables -t nat -A PREROUTING -i br0 -j DNAT --to 5.6.7.8 */
	//rc = snprintf(buf, len-rc , "iptables -t nat -A %s -j DNAT -i %s -p udp --dport ! %d --to %s", DMZ_CHAIN, wan_name, getGoAHeadServerPort(), ip_address);
	snprintf(buf, len, "iptables -t nat -A %s -j DNAT -i %s  --to %s", DMZ_CHAIN, wan_name,  ip_address);
}
void zte_iptables_DMZ_Run(void)
{
	char cmd[1024] = {0}, ip_address[128] = {0};
	char dmz_enable[128] = {0};

	/*flush DMZ chain*/
	memset(cmd, 0, sizeof(cmd));
	sprintf(cmd, "iptables -t nat -F %s %s", DMZ_CHAIN, FMT_ECHO_IPTABLES_CMD);
	system_cmd_ex(cmd);

	memset(cmd, 0, sizeof(cmd));

	//zte_router_nvconfig_read("DMZEnable");
	//strcpy(dmz_enable , g_router_nvconfig_buf);
	sc_cfg_get("DMZEnable", dmz_enable, sizeof(dmz_enable));

	if (0 == strcmp(dmz_enable, "")) {
		slog(NET_PRINT, SLOG_ERR, "Warning: DMZ have been disable one\n");
		return;
	}
	if (!atoi(dmz_enable)) {
		slog(NET_PRINT, SLOG_ERR, "Warning: DMZ have been disable two\n");
		return;
	}

	//zte_router_nvconfig_read("DMZIPAddress");
	// strcpy(ip_address , g_router_nvconfig_buf);
	sc_cfg_get("DMZIPAddress", ip_address, sizeof(ip_address));


	if (0 == strcmp(ip_address, "")) {
		slog(NET_PRINT, SLOG_ERR, "Warning: can't find \"DMZIPAddress\" in flash\n");
		return;
	}
	//system_cmd_ex("iptables -t nat -I PREROUTING -i %s  -m state --state RELATED,ESTABLISHED,NEW -j ACCEPT",getWanIfNamePPP);

	sprintf(cmd, "iptables -t nat -A %s -j ACCEPT -i %s -p udp --dport 67:68", DMZ_CHAIN, defwan_rel);
	//ZTE_SYSLOG(6,"zte_mainctrl DMZ:%s",cmd);
	system_cmd_ex(cmd);

	memset(cmd, 0, sizeof(cmd));

	zte_iptables_make_DMZ_Rule(cmd, sizeof(cmd), defwan_rel, ip_address);

	system_cmd_ex(cmd);
	return;
}




//12133
/******************************************************
* Function: zte_iptables_make_port_forward_rule()
* Description:  make port forward rules, then run, e.g.
*                   iptables -t nat -A port_forward -j DNAT -i ppp0 -p tcp --dport 10:400 --to 192.168.0.100
* Input:
* Output:
* Return:
* Others:
* Modify Date    Version   Author         Modification
* 2010/12/13      V1.0      MaXiaoliang        create
*******************************************************/
static void zte_iptables_make_port_forward_rule(char *buf, int len, char *wan_name,
        char *ip_address, int proto, int prf_int, int prt_int)
{
	int rc = 0;
	char *pos = buf;

	rc = snprintf(pos, len - rc, "iptables -t nat -A %s -j DNAT -i %s ", PORT_FORWARD_CHAIN, wan_name);
	pos = pos + rc;

	/* protocol type */
	if (proto == PROTO_TCP)
		rc = snprintf(pos, len - rc, "-p tcp ");
	else if (proto == PROTO_UDP)
		rc = snprintf(pos, len - rc, "-p udp ");
	else if (proto == PROTO_TCP_UDP)
		rc = snprintf(pos, len - rc, " ");
	pos = pos + rc;

	/* port */
	if (prt_int != 0)
		rc = snprintf(pos, len - rc, "--dport %d:%d ", prf_int, prt_int);
	else
		rc = snprintf(pos, len - rc, "--dport %d ", prf_int);
	pos = pos + rc;

	/* dest ip, forward to who */
	rc = snprintf(pos, len - rc, "--to %s ", ip_address);
}

//12134

/******************************************************
* Function: zte_iptables_port_forward_run()
* Description:  make port forward rules, then run
* Input:
* Output:
* Return:
* Others:
* Modify Date    Version   Author         Modification
* 2010/12/13      V1.0      MaXiaoliang        create
*******************************************************/
void zte_iptables_port_forward_run(void)
{
	char forward_enable[10] = {0};
	//char rule[NV_FW_RULE_MAX_LEN] = {0};

	int i = 0;
	char rec[ROUTER_NV_FW_RULE_MAX_LEN] = {0};
	char cmd[ROUTER_NV_FW_RULE_MAX_LEN] = {0};

	int prf_int;
	int prt_int;
	int proto;
	char ip_address[32] = {0};
	char prf[8] = {0};
	char prt[8] = {0};
	char protocol[8] = {0};
	char tmp[ROUTER_DEFAULT_LEN] = {0};
	/* if port forward is disabled or PortForwardRules is NULL, then return */
	//zte_router_nvconfig_read("PortForwardEnable");
	//strcpy(forward_enable , g_router_nvconfig_buf);
	sc_cfg_get("PortForwardEnable", forward_enable, sizeof(forward_enable));

	if (0 == strlen(forward_enable)) {
		slog(NET_PRINT, SLOG_ERR, "Warning: PortForward have been disable one \n");
		return;
	}
	//iptablesPortForwardFlush();
	system_cmd_ex("iptables -t nat -F "PORT_FORWARD_CHAIN);

	/* 0: disable  1: enable */
	if (0 == atoi(forward_enable)) {
		slog(NET_PRINT, SLOG_ERR, "Warning: PortForward have been disable two \n");
		return;
	}

	sprintf(cmd, "iptables -t nat -A %s -j ACCEPT -i %s -p udp --dport 67:68", PORT_FORWARD_CHAIN, defwan_rel);
	//ZTE_SYSLOG(6,"zte_mainctrl port_forward:%s",cmd);
	system_cmd_ex(cmd);
	memset(cmd, 0, sizeof(cmd));

	for (i = 0; i < RULE_MAX; i++) {
		sprintf(tmp, "PortForwardRules_%d", i);
		memset(rec, 0, sizeof(rec));
		//zte_router_nvconfig_read(tmp);
		//strcpy(rec , g_router_nvconfig_buf);
		sc_cfg_get(tmp, rec, sizeof(rec));

		// get ip address
		if ((getNthValueSafe(0, rec, ',', ip_address, sizeof(ip_address)) == -1)) {
			continue;
		}
		if (!isIpValid(ip_address)) {
			continue;
		}

		// get port range "from"
		if ((getNthValueSafe(1, rec, ',', prf, sizeof(prf)) == -1)) {
			continue;
		}
		if ((prf_int = atoi(prf)) == 0 || prf_int > 65535) {
			continue;
		}

		// get port range "to"
		if ((getNthValueSafe(2, rec, ',', prt, sizeof(prt)) == -1)) {
			continue;
		}
		if ((prt_int = atoi(prt)) > 65535) {
			continue;
		}

		// get protocol
		if ((getNthValueSafe(3, rec, ',', protocol, sizeof(protocol)) == -1)) {
			continue;
		}
		proto = atoi(protocol);

		switch (proto) {
		case PROTO_TCP:
		case PROTO_UDP:
			zte_iptables_make_port_forward_rule(cmd, sizeof(cmd), defwan_rel, ip_address, proto, prf_int, prt_int);
			system_cmd_ex(cmd);
			break;
		case PROTO_TCP_UDP:
			zte_iptables_make_port_forward_rule(cmd, sizeof(cmd), defwan_rel, ip_address, PROTO_TCP, prf_int, prt_int);
			system_cmd_ex(cmd);
			zte_iptables_make_port_forward_rule(cmd, sizeof(cmd), defwan_rel, ip_address, PROTO_UDP, prf_int, prt_int);
			system_cmd_ex(cmd);
			break;

		default:
			continue;
		}
	}

}

/******************************************************
* Function: zte_iptables_make_portmap_rule()
* Description:  make filter rules, e.g.
*                   iptables -t nat -A PREROUTING -p udp --port 77 -j DNAT --to 192.168.8.100:88
* Input:
* Output:
* Return:
* Others:
* Modify Date    Version   Author         Modification
* 2015/08/03     V1.0      gebin          create
*******************************************************/
static void zte_iptables_make_portmap_rule(char *buf, int len, char *wan_name, char *ip, int spr_int, int dpr_int, int proto)
{
	int rc = 0;
	char *pos = buf;

	rc = snprintf(pos, len - rc, "iptables -t nat -A %s -j DNAT -i %s ", PORT_MAPPING_CHAIN, wan_name);
	//rc = snprintf(pos, len - rc, "iptables -t nat -A PREROUTING ");
	pos = pos + rc;

	// write protocol type
	if (proto == PROTO_TCP)
		rc = snprintf(pos, len - rc, "-p tcp ");
	else if (proto == PROTO_UDP)
		rc = snprintf(pos, len - rc, "-p udp ");
	else if (proto == PROTO_TCP_UDP)
		rc = snprintf(pos, len - rc, " ");
	pos = pos + rc;

	// write source port
	if (spr_int) {
		rc = snprintf(pos, len - rc, "--dport %d ", spr_int);
		pos = pos + rc;
	}

	// write ip
	if (ip && strlen(ip)) {
		rc = snprintf(pos, len - rc, "--to %s", ip);
		pos = pos + rc;
	}

	// write dest port
	if (dpr_int) {
		rc = snprintf(pos, len - rc, ":%d", dpr_int);
		pos = pos + rc;
	}
}

/******************************************************
* Function: zte_iptables_port_map_run()
* Description:  load rules from "PortMapRules", make rules, and run
* Input:
* Output:
* Return:
* Others:
* Modify Date    Version   Author         Modification
* 2015/08/03     V1.0      gebin          create
*******************************************************/
static void zte_iptables_port_map_run(char *portMapRule)
{
	//char portmap_enable[CONFIG_DEFAULT_LENGTH] = {0};
	char ip[32]  = {0};    /* ip address */
	char spr[8]  = {0};    /* source port from */
	char dpr[8]  = {0};    /* dest port from */
	char protocol[8] = {0};

	int spr_int = 0;
	int dpr_int = 0;
	int proto = 0;
	char cmd[300] = {0};

	// get ip address
	if ((getNthValueSafe(0, portMapRule, ',', ip, sizeof(ip)) == -1)) {
		return;
	}
	if (!isIpNetmaskValid(ip)) {
		return;
	}

	// get source ip port
	if ((getNthValueSafe(1, portMapRule, ',', spr, sizeof(spr)) == -1)) {
		return;
	}
	if ((spr_int = atoi(spr)) > 65535) {
		return;
	}

	// get dest ip port
	if ((getNthValueSafe(2, portMapRule, ',', dpr, sizeof(dpr)) == -1)) {
		return;
	}
	if ((dpr_int = atoi(dpr)) > 65535) {
		return;
	}

	// get protocol
	if ((getNthValueSafe(3, portMapRule, ',', protocol, sizeof(protocol)) == -1)) {
		return;
	}
	proto = atoi(protocol);

	/*
	# iptables example
	# iptables -t nat -A PREROUTING -p udp --port 77 -j DNAT --to 192.168.8.100/88
	*/
	if (PROTO_TCP_UDP == proto) {
		zte_iptables_make_portmap_rule(cmd, sizeof(cmd), defwan_rel, ip, spr_int, dpr_int, PROTO_TCP);
		system_cmd_ex(cmd);
		zte_iptables_make_portmap_rule(cmd, sizeof(cmd), defwan_rel, ip, spr_int, dpr_int, PROTO_UDP);
		system_cmd_ex(cmd);
	} else {
		zte_iptables_make_portmap_rule(cmd, sizeof(cmd), defwan_rel, ip, spr_int, dpr_int, proto);
		system_cmd_ex(cmd);
	}
}

/******************************************************
* Function: zte_iptables_port_map_all_run()
* Description:  load rules from "PortMapRules", make rules, and run
* Input:
* Output:
* Return:
* Others:
* Modify Date    Version   Author         Modification
* 2015/08/03     V1.0      gebin          create
*******************************************************/
void zte_iptables_port_map_all_run(void)
{
	int i = 0;
	char PortMapRules[300] = {0};
	char PortMapRules_x[50] = {0};
	char portmap_enable[64] = {0}; /* 0: Disabled  1: Enabled */
	int portmap_int = 0;
	char cmd[ROUTER_NV_FW_RULE_MAX_LEN] = {0};

	//read port_map setting
	sc_cfg_get("PortMapEnable", portmap_enable, sizeof(portmap_enable));
	slog(NET_PRINT, SLOG_NORMAL, "portmap_enable: %s \n", portmap_enable);
	if (0 == strlen(portmap_enable)) {
		slog(NET_PRINT, SLOG_ERR, "Error: can't find \"PortMapRules\" in flash.\n"); /*lint !e26*/
		return;
	}

	system_cmd_ex("iptables -t nat -F "PORT_MAPPING_CHAIN);

	portmap_int = atoi(portmap_enable);
	/* if firewall is disable, then return directly: 0 mean disable, 1 means enable */
	if (0 == portmap_int) {
		return;
	}

	sprintf(cmd, "iptables -t nat -A %s -j ACCEPT -i %s -p udp --dport 67:68", PORT_MAPPING_CHAIN, defwan_rel);
	system_cmd_ex(cmd);
	memset(cmd, 0, sizeof(cmd));

	for (i = 0; i <= 9; i++) {
		(void)snprintf(PortMapRules_x, 50, "PortMapRules_%d", i);
		memset(PortMapRules, 0, sizeof(PortMapRules));
		sc_cfg_get(PortMapRules_x, PortMapRules, sizeof(PortMapRules));
		if (0 == strcmp(PortMapRules, "")) {
			continue;
		}
		zte_iptables_port_map_run(PortMapRules);
		slog(NET_PRINT, SLOG_NORMAL, "iptables_port_map_all_run %s: %s", PortMapRules_x, PortMapRules);
	}
}

/*===========================================================================
    Function:
        zte_iptables_make_filter_rule_v6

    Description:
        make ipportfilter rules.
        example:
            iptables -A macipport_filter
                        -m mac --mac-source 00:11:22:33:44:55
                        -m iprange --src-range 192.168.1.10-192.168.1.50
                        -m iprange --dst-range 10.128.10.10-10.128.10.100
                        -p tcp --sport 10:2000 --dport 4000:5000
                        -j DROP

    Param:
        buf - cmd buffer to store rule cmd
        len - length of cmd buffer
        mac_address - mac address
        sip_1 - source ip 1
        sip_2 - source ip 2 (not support now)
        sprf_int - source ip from port
        sprt_int - source ip to port
        dip_1 - dest ip 1
        dip_2 - dest ip 2 (not support now)
        dprf_int - dest ip from port
        dprt_int - dest ip to port
        proto - protocol
        action - accept or drop

    Modify Date     Version     Author                  Modification
    2010/07/12      V1.0        zhangyuelong10100551    Create
===========================================================================*/
static void zte_iptables_make_filter_rule_v6(char *buf, int len, char *mac_address,
        char *sip_1, char *sip_2, int sprf_int, int sprt_int,
        char *dip_1, char *dip_2, int dprf_int, int dprt_int, int proto, int action)
{
	int rc = 0;
	char *pos = buf;

	if (NULL == buf) {
		slog(NET_PRINT, SLOG_ERR, "[iptables_make_filter_rule_v6]: buf NULL");
		return;
	}

	rc = snprintf(pos, len - rc, "ip6tables -A %s ", IPPORT_FILTER_CHAIN);
	pos = pos + rc;

	// write mac address
	if (mac_address && strlen(mac_address)) {
		rc = snprintf(pos, len - rc, "-m mac --mac-source %s ", mac_address);
		pos = pos + rc;
	}

	// write source ip
	if (sip_1 && strlen(sip_1)) {
		if (0 != strcmp("any/0", sip_1)) {
			rc = snprintf(pos, len - rc, "-s %s ", sip_1);
			pos = pos + rc;
		}
	}

	// write dest ip
	if (dip_1 && strlen(dip_1)) {
		if (0 != strcmp("any/0", dip_1)) {
			rc = snprintf(pos, len - rc, "-d %s ", dip_1);
			pos = pos + rc;
		}
	}

	// write protocol type
	if (proto == PROTO_NONE) {
		//rc = snprintf(pos, len-rc, " ");
		//pos = pos + rc;
	} else if (proto == PROTO_ICMP) {
		rc = snprintf(pos, len - rc, "-p icmpv6 ");
		pos = pos + rc;
	} else if (proto == PROTO_TCP || proto == PROTO_UDP) {
		if (proto == PROTO_TCP)
			rc = snprintf(pos, len - rc, "-p tcp ");
		else/* if (proto == PROTO_UDP)*/ //kw 3
			rc = snprintf(pos, len - rc, "-p udp ");
		pos = pos + rc;

		// write source port
		if (sprf_int) {
			if (sprt_int)
				rc = snprintf(pos, len - rc, "--sport %d:%d ", sprf_int, sprt_int);
			else
				rc = snprintf(pos, len - rc, "--sport %d ", sprf_int);
			pos = pos + rc;
		}

		// write dest port
		if (dprf_int) {
			if (dprt_int)
				rc = snprintf(pos, len - rc, "--dport %d:%d ", dprf_int, dprt_int);
			else
				rc = snprintf(pos, len - rc, "--dport %d ", dprf_int);
			pos = pos + rc;
		}
	}

	switch (action) {
	case ACTION_DROP:       // 1 == ENABLE--DROP mode
		rc = snprintf(pos, len - rc, "-j DROP");
		break;
	case ACTION_ACCEPT:     // 2 == ENABLE--ACCEPT mode
		rc = snprintf(pos, len - rc, "-j ACCEPT");
		break;
	default:
		slog(NET_PRINT, SLOG_ERR, "[iptables_make_filter_rule_v6]: unknown action", "");
		break;
	}
}  /* zte_iptables_make_filter_rule_v6() */
void zte_iptables_filter_run_v6(void)
{
	char filter_flag[ROUTER_DEFAULT_LEN] = {0}, filter_default_policy[ROUTER_DEFAULT_LEN] = {0}, cmd[500] = {0}, each_rule[ROUTER_NV_FW_RULE_MAX_LEN] = {0}, tmp[ROUTER_DEFAULT_LEN] = {0}, dip_2[ZTE_FW_IP_ADDR_LEN_V6] = {0}, protocol[ZTE_ROUTER_FW_FLAG_LEN] = {0}, mac_address[ROUTER_DEFAULT_LEN] = {0},
	                                       sip_1[ZTE_FW_IP_ADDR_LEN_V6] = {0}, sip_2[ZTE_FW_IP_ADDR_LEN_V6] = {0}, sprf[ZTE_ROUTER_FW_PORT_LEN] = {0}, sprt[ZTE_ROUTER_FW_PORT_LEN] = {0}, dip_1[ZTE_FW_IP_ADDR_LEN_V6] = {0}, dprf[ZTE_ROUTER_FW_PORT_LEN] = {0}, dprt[ZTE_ROUTER_FW_PORT_LEN] = {0}, action[ZTE_ROUTER_FW_FLAG_LEN] = {0};
	int i = 0;

	/* flush all filter rules */
	system_cmd_ex("ip6tables -F "IPPORT_FILTER_CHAIN);
	/* default policy */
	system_cmd_ex("ip6tables -t filter -P FORWARD ACCEPT");
	system_cmd_ex("ip6tables -t filter -A "IPPORT_FILTER_CHAIN" -m state --state RELATED,ESTABLISHED -j ACCEPT");

	/* check whether run filter */
	//zte_router_nvconfig_read("IPPortFilterEnable");
	//strcpy(filter_flag, g_router_nvconfig_buf);
	sc_cfg_get("IPPortFilterEnable", filter_flag, sizeof(filter_flag));

	if (strlen(filter_flag) == 0 || atoi(filter_flag) == 0) {
		return;
	}

	/* set default policy of filter */
	//zte_router_nvconfig_read("DefaultFirewallPolicy");
	//strcpy(filter_default_policy, g_router_nvconfig_buf);
	sc_cfg_get("DefaultFirewallPolicy", filter_default_policy, sizeof(filter_default_policy));

	if (strcmp("1", filter_default_policy) == 0) {
		system_cmd_ex("ip6tables -t filter -P FORWARD DROP");
	} else {
		system_cmd_ex("ip6tables -t filter -P FORWARD ACCEPT");
	}

	for (i = 0; i < RULE_MAX; i++) {
		sprintf(tmp, "IPPortFilterRulesv6_%d", i);
		memset(each_rule, 0, sizeof(each_rule));
		//zte_router_nvconfig_read(tmp);
		//strcpy(each_rule, g_router_nvconfig_buf);
		sc_cfg_get(tmp, each_rule, sizeof(each_rule));

		/* source ip range "from" */
		if (getNthValueSafe(0, each_rule, ',', sip_1, sizeof(sip_1)) == -1) {
			continue;
		}
		/* source ip range "to" */
		if (getNthValueSafe(1, each_rule, ',', sip_2, sizeof(sip_2)) == -1) {
			continue;
		}
		/* source port range "from" */
		if ((getNthValueSafe(2, each_rule, ',', sprf, sizeof(sprf)) == -1) || atoi(sprf) > 65535) {
			continue;
		}
		/* source port range "to" */
		if ((getNthValueSafe(3, each_rule, ',', sprt, sizeof(sprt)) == -1) || atoi(sprt) > 65535) {
			continue;
		}
		/* dst ip range "from" */
		if (getNthValueSafe(4, each_rule, ',', dip_1, sizeof(dip_1)) == -1) {
			continue;
		}
		/* dst ip range "to" */
		if (getNthValueSafe(5, each_rule, ',', dip_2, sizeof(dip_2)) == -1) {
			continue;
		}
		/* dst port range "from" */
		if ((getNthValueSafe(6, each_rule, ',', dprf, sizeof(dprf)) == -1) || atoi(dprf) > 65535) {
			continue;
		}
		/* dst port range "to" */
		if ((getNthValueSafe(7, each_rule, ',', dprt, sizeof(dprt)) == -1) || atoi(dprt) > 65535) {
			continue;
		}
		/* protocol */
		if (getNthValueSafe(8, each_rule, ',', protocol, sizeof(protocol)) == -1) {
			continue;
		}
		/* action */
		if (getNthValueSafe(9, each_rule, ',', action, sizeof(action)) == -1) {
			continue;
		}
		/* comment */
		/* mac_address */
		//kw 3
		if (getNthValueSafe(11, each_rule, ',', mac_address, sizeof(mac_address)) == -1) {
			continue;
		}
		if (strlen(mac_address) && !isMacValid(mac_address)) {
			continue;
		}
		

		/* run rules */
		if (PROTO_TCP_UDP == atoi(protocol)) {
			zte_iptables_make_filter_rule_v6(cmd, sizeof(cmd), mac_address,
			                                 sip_1, sip_2, atoi(sprf), atoi(sprt), dip_1, dip_2, atoi(dprf), atoi(dprt), PROTO_TCP, atoi(action));
			system_cmd_ex(cmd);

			zte_iptables_make_filter_rule_v6(cmd, sizeof(cmd), NULL,
			                                 sip_1, sip_2, atoi(sprf), atoi(sprt), dip_1, dip_2, atoi(dprf), atoi(dprt), PROTO_UDP, atoi(action));
			system_cmd_ex(cmd);
		} else {
			zte_iptables_make_filter_rule_v6(cmd, sizeof(cmd), mac_address,
			                                 sip_1, sip_2, atoi(sprf), atoi(sprt), dip_1, dip_2, atoi(dprf), atoi(dprt), atoi(protocol), atoi(action));
			system_cmd_ex(cmd);
		}
	}
}
void zte_iptables_Webs_Filter_Run(void)
{
	int i = 0;
	char url_filter[ZTE_ROUTER_URL_FILTER_LEN] = {0};
	char entry[ROUTER_NV_ITEM_VALUE_MAX_LEN] = {0};
	char cmd[ROUTER_NV_ITEM_VALUE_MAX_LEN] = {0};
	char url_hexstring[ZTE_ROUTER_URL_FILTER_LEN] = {0};

	/*
	 *ע͵ԭַƥ䣬Ϊģƥ.
	 *[comlee]:2016 04 08  09:14:07 CST
	 *
	*/
	char sys_cmd_bufer[500] = {0};

	/*flush filter chain*/
	sprintf(sys_cmd_bufer, "iptables -F %s %s", WEB_FILTER_CHAIN, FMT_ECHO_IPTABLES_CMD);
	system_cmd_ex(sys_cmd_bufer);
#if 0
	for (i = 0; i < old_url_list.count; i ++) {
		sprintf(cmd, "iptables -D INPUT -m string --hex-string  \"|%s|\" --algo kmp -j DROP", old_url_list.url_list[i]);
		system_cmd_ex(cmd);
	}
	old_url_list.count = 0;
#endif

	sc_cfg_get("websURLFilters", url_filter, sizeof(url_filter));

	i = 0;
	while ((getNthValueSafe(i++, url_filter, ';', entry, sizeof(entry)) != -1)) {
		if (strlen(entry)) {
			if (!strncasecmp(entry, "http://", strlen("http://")))
				strncpy(entry, entry + strlen("http://"), sizeof(entry)-1);


			memset(cmd, 0, sizeof(cmd));

			snprintf(cmd, sizeof(cmd), "iptables -A web_filter -p tcp -m tcp -m webstr --url %s -j REJECT --reject-with tcp-reset", entry);
			system_cmd_ex(cmd);

			/*
			 *ע͵ԭַƥ䣬Ϊģƥ.
			 *[comlee]:2016 04 08  09:14:07 CST
			 *
			*/
#if 0
			memset(cmd, 0, sizeof(cmd));
			memset(url_hexstring, 0, sizeof(url_hexstring));
			str_vary_dit(entry, url_hexstring);
			sprintf(cmd, "iptables -I INPUT -m string --hex-string  \"|%s|\" --algo kmp -j DROP ", url_hexstring);
			if (old_url_list.count < MAX_OLD_URLS_COUNT) {
				memcpy(old_url_list.url_list[old_url_list.count], url_hexstring, (size_t)ZTE_ROUTER_URL_FILTER_LEN);
				old_url_list.count ++;
			}
			system_cmd_ex(cmd);
#endif
		}
	}

	return;
}
static void zte_iptables_all_filter_run(void)
{
	zte_iptables_filter_run();
	zte_iptables_filter_run_v6();
	/* system filter */
	zte_iptables_sys_fw_run();
	/*url filter*/
	zte_iptables_Webs_Filter_Run();

	//ҳģʽ

	zte_iptables_child_filter_run();

}

void zte_iptables_child_filter_run()
{

	system_cmd_ex("iptables -t filter -A INPUT -j children_web_filter");

	/* 0:ʱ 1:ʱ*/
	if (g_limit_time_flag == 1) {
		zte_children_start_nonet();
	} else if (g_limit_time_flag == 0) {
		zte_children_stop_nonet();
	} else {
		return;
	}
}

static void zte_iptables_all_nat_run(void)
{
	/*port forward*/
	zte_iptables_port_forward_run();

	/* EC: 616000297057, ԭ: 粻ֶ֧˿ӳ */
	/*port mapping*/
	zte_iptables_port_map_all_run();

	/*DMZ*/
	zte_iptables_DMZ_Run();

}


void alg_control_fun()
{
	int sip_enable = 0;
	int ftp_enable = 0;
	char buf[32];
	memset(buf, 0x00, sizeof(buf));

	sc_cfg_get("alg_sip_enable", buf, sizeof(buf));
	sip_enable = atoi(buf);
	memset(buf, 0x00, sizeof(buf));
	sc_cfg_get("alg_ftp_enable", buf, sizeof(buf));
	ftp_enable = atoi(buf);
	slog(NET_PRINT, SLOG_NORMAL, "into ***** alg_control_fun");
	//ALG: sip function control
	if (1 == sip_enable) {
		slog(NET_PRINT, SLOG_NORMAL, "insmod sip module");
		system_cmd_ex("insmod /lib/modules/2.6.21/kernel/net/netfilter/nf_conntrack_sip.ko");
	} else {
		slog(NET_PRINT, SLOG_NORMAL, "rmmod sip module");
		system_cmd_ex("rmmod nf_conntrack_sip");
	}
	//ALG: ftp service control
	system_cmd_ex("iptables -t filter -F ftp_filter");
	if (0 == ftp_enable) {
		slog(NET_PRINT, SLOG_NORMAL, "shutdown  ftp service");
		system_cmd_ex("iptables -t filter -N ftp_filter");
		system_cmd_ex("iptables -t filter -I FORWARD 2 -j ftp_filter");
		//system_cmd_ex("iptables -t filter -A ftp_filter -p tcp --dport 20 -j DROP");
		system_cmd_ex("iptables -t filter -A ftp_filter -p tcp --dport 21 -j DROP");
	}
	//ALG: vpn passthr contrl
	system_cmd_ex("vpn_pthr_contrl.sh");
	slog(NET_PRINT, SLOG_NORMAL, "end alg_control_fun");
}

#if (MODEM_TYPE == vehicle_dc)
void notify_list_firewall_add(struct list_head *head, char *ip)
{
	struct firewall_ip_queue *tmp = NULL, *ip_queue = NULL;

	slog(NET_PRINT, SLOG_DEBUG, "notify_list_add_firewall start, id:%s\n", ip);

	list_for_each_entry(tmp, head, list) {
		//Ѿ¼
		if (strcmp(tmp->ip, ip) == 0) {
			slog(NET_PRINT, SLOG_ERR, "notify_list_add_firewall ip:%s alread existed! \n", ip);
			return;
		}
	}

	ip_queue = malloc(sizeof(struct firewall_ip_queue));
	if (ip_queue == NULL) {
		slog(NET_PRINT, SLOG_ERR, "notify_list_add_firewall ip:%s malloc failed! \n", ip);
		return;
	}

	INIT_LIST_HEAD(&ip_queue->list);
	memset(ip_queue->ip, 0, ZTE_ROUTER_IP_ADDR_LEN);
	strncpy(ip_queue->ip, ip, sizeof(ip_queue->ip)-1);
	list_add_tail(&ip_queue->list, head);

	slog(NET_PRINT, SLOG_DEBUG, "notify_list_add_firewall ip:%s success\n", ip);
}

//Ϣģ飬Ҫģлظ
void notify_list_firewall_del(struct list_head *head, char *ip)
{
	struct firewall_ip_queue *tmp = NULL, *tmp2 = NULL, *ip_queue = NULL;

	slog(NET_PRINT, SLOG_DEBUG, "notify_list_del_firewall start, ip:%s!!!\n", ip);

	list_for_each_entry_safe(tmp, tmp2, head, list) {
		if (strcmp(tmp->ip, ip) == 0) {
			slog(NET_PRINT, SLOG_NORMAL, "notify_list_del_firewall ip:%s\n", ip);
			list_del(&tmp->list);
			free(tmp);
			break;
		}
	}

	slog(NET_PRINT, SLOG_NORMAL, "notify_list_del_firewall success !!!\n");
}

void notify_list_firewall_cleanup(struct list_head *head)
{
	struct firewall_ip_queue *tmp = NULL, *tmp2 = NULL;

	list_for_each_entry_safe(tmp, tmp2, head, list) {
		slog(NET_PRINT, SLOG_NORMAL, "notify_list_firewall_cleanup ip:%s\n", tmp->ip);
		list_del(&tmp->list);
		free(tmp);
	}
}

void zte_iptables_firewall_rule_run(struct list_head *head)
{
	int i = 0;
	char nv_name[ROUTER_NV_ITEM_VALUE_MAX_LEN] = {0};
	char cmd[1024] = {0};
	struct firewall_ip_queue *tmp = NULL;

	/*flush Firewall chain*/
	memset(cmd, 0, sizeof(cmd));
	sprintf(cmd, "iptables -F %s %s", FIREWALL_CHAIN, FMT_ECHO_IPTABLES_CMD);
	system_cmd_ex(cmd);

	list_for_each_entry(tmp, head, list) {
		memset(cmd, 0, sizeof(cmd));
		sprintf(cmd, "iptables -A %s -s %s -j DROP", FIREWALL_CHAIN, tmp->ip);
		system_cmd_ex(cmd);
		//slog(NET_PRINT, SLOG_NORMAL, "zte_iptables_firewall_rule_run cmd:%s\n", cmd);

		//sprintf(nv_name, "Firewall_IP-%d", i++);
		//sc_cfg_set(nv_name, tmp->ip);
	}
}

void zte_iptables_firewall_add(char *ip)
{
	if (!ip)
		return;

	notify_list_firewall_add(&g_firewall_ip, ip);
	zte_iptables_firewall_rule_run(&g_firewall_ip);
}

void zte_iptables_firewall_del(char *ip)
{
	if (!ip)
		return;

	notify_list_firewall_del(&g_firewall_ip, ip);
	zte_iptables_firewall_rule_run(&g_firewall_ip);
}

void zte_iptables_firewall_cleanup(void)
{
	notify_list_firewall_cleanup(&g_firewall_ip);
	zte_iptables_firewall_rule_run(&g_firewall_ip);
}

void zte_firewall_init(void)
{
	char cmd[1024] = {0};

	sprintf(cmd, "iptables -N %s", FIREWALL_CHAIN);
	system_cmd_ex(cmd);

	memset(cmd, 0, sizeof(cmd));
	sprintf(cmd, "iptables -A INPUT -j %s", FIREWALL_CHAIN);
	system_cmd_ex(cmd);
}
#endif

void zte_router_init(void)
{
	slog(NET_PRINT, SLOG_NORMAL, "===============init firewall=================== \n");
	/* init firewall and nat*/
	//system_cmd_ex("nat.sh");
	//zte_router_MTU_set();
	//xf.li@20240606 delete for ZXW-300 start
	#if 0
	system_cmd_ex("firewall_init.sh");
	#endif
	//xf.li@20240606 delete for ZXW-300 end
	/* read wan if name */
	memset(defwan_rel, 0, sizeof(defwan_rel));
	sc_cfg_get("default_wan_rel", defwan_rel, sizeof(defwan_rel));

	//ZTE_LOG(LOG_DEBUG, "router_init -> defwan_rel:[%s]", defwan_rel);

	memset(defwan6_rel, 0, sizeof(defwan6_rel));
	sc_cfg_get("default_wan6_rel", defwan6_rel, sizeof(defwan6_rel));
	//xf.li@20240606 delete for ZXW-300 start
	#if 0
	zte_iptables_all_filter_run();
	zte_iptables_all_nat_run();

#if (MODEM_TYPE == vehicle_dc)
	zte_firewall_init();
#endif
	#endif
//xf.li@20240606 delete for ZXW-300 end
	slog(NET_PRINT, SLOG_NORMAL, "router_init end \n");
}


