#ifndef _ZTE_ROUTER_H_
#define _ZTE_ROUTER_H_

#include <stdio.h>
#include <string.h>
#include <stdlib.h>
#include <sys/types.h>
#include <sys/stat.h>
#include <fcntl.h>
#include <netinet/in.h>
#include <unistd.h>
#include <sys/ipc.h>
#include <sys/msg.h>
#include <pthread.h>
#include <errno.h>
#include <signal.h>
#include <sys/socket.h>
#include <syslog.h>
#include <sys/klog.h>
#include <assert.h>
#include <ctype.h>
#include <sys/socket.h>
#include <netinet/in.h>
#include <arpa/inet.h>
#include "soft_timer.h"
#include "message.h"
#include "softap_api.h"
#include "cfg_nv_def.h"


/**************************************************************************
 *                              Types                                     *
 **************************************************************************/

#define RULE_MAX    10
#define ZTE_ROUTER_FW_PORT_LEN 6
#define ZTE_ROUTER_FW_FLAG_LEN 4
#define ZTE_ROUTER_WAN_IF_NAME_LEN 20
#define ZTE_ROUTER_IP_ADDR_LEN 32
#define ZTE_ROUTER_IPV6_ADDR_LEN 64

#define ZTE_FW_IP_ADDR_LEN_V6  45

#define ROUTER_DEFAULT_LEN 64
#define ZTE_ROUTER_URL_FILTER_LEN     512
#define MAX_OLD_URLS_COUNT            100
#define NV_MACIP_LIST_MAX_LEN 500     //zte_mac_list_run
#define ROUTER_NV_ITEM_VALUE_MAX_LEN 256
#define ROUTER_NV_FW_RULE_MAX_LEN 300
#define IPPORT_FILTER_CHAIN      "macipport_filter"
#define VPN_CHAIN                "vpn_filter"
#define PORT_FORWARD_CHAIN       "port_forward"
#define WEB_FILTER_CHAIN         "web_filter"
#define DMZ_CHAIN                 "DMZ"
#define PORT_MAPPING_CHAIN       "port_mapping"

#define CLILDREN_MAC_CHAIN       "children_filter"
#define CLILDREN_WEB_CHAIN       "children_web_filter"
#define CLILDREN_WEB_PHONE_CHAIN       "children_web_filter_phone"

#define ACTION_DROP 0
#define ACTION_ACCEPT   1

#define PROTO_UNKNOWN   0
#define PROTO_TCP   1
#define PROTO_UDP   2
#define PROTO_TCP_UDP   3
#define PROTO_ICMP  4
#define PROTO_NONE  5

#define CONFIG_DEFAULT_LENGTH  64
#define NV_QOS_LIST_MAX_LEN 500
#define NV_STATIC_ROUTE_LIST_MAX_LEN 1500

#define ConnectWaitTime 180000 //1000=1s
#define StateTimerID 68 //timer ID
#define WaitTime 10000 //1000=1s

#define FMT_ECHO_IPTABLES_CMD "1>/dev/null 2>&1"

#define MAINCTRL_LOCK "mainctrl_lock"

/**************************************************************************
 *                            Global Struct                               *
 **************************************************************************/
typedef enum {
	TIMER_MainCtrl_NvSaveID = 60,   /*Nvsaveʱ ID*/
	TIMER_MainCtrl_NetID = 66,      /*ڶʱID*/
	/*治µģֻǰ: ΪڶʱID+devIdֵӻظ*/
} T_emMainCtrl_SoftTimerId;

struct url_list {
	int count;
	char url_list[MAX_OLD_URLS_COUNT][ZTE_ROUTER_URL_FILTER_LEN];
};

/*struct mac_hostname{
    char mac[18];
    char hostname[500];
};*/

struct mainctrl_notify_queue {
	struct list_head list;
	int notify_id;
};

extern char ps_wan[ZTE_ROUTER_WAN_IF_NAME_LEN];
extern char usb_wan[ZTE_ROUTER_WAN_IF_NAME_LEN];
extern char eth_wan[ZTE_ROUTER_WAN_IF_NAME_LEN];
extern char wifi_wan[ZTE_ROUTER_WAN_IF_NAME_LEN];
extern unsigned char ethwan_id; //RJ45ڵĳʱ
extern unsigned char wifiwan_id;//wifiڵĳʱ

extern char g_router_nvconfig_buf[ROUTER_NV_ITEM_VALUE_MAX_LEN];
extern char defwan_rel[ZTE_ROUTER_WAN_IF_NAME_LEN];

extern int g_mainctrl_factory_reset;
extern int g_mainctrl_reset_ext_cmd;
extern int g_mainctrl_poweroff_ext_cmd;
extern int g_mainctrl_restart_ext_cmd;
extern struct list_head g_mainctrl_reset_notify;
extern struct list_head g_mainctrl_poweroff_notify;
extern struct list_head g_mainctrl_restart_notify;

/********************netdev_proc.c    start********************************/
extern int net_pdp_act_proc(struct pdp_active_info *actinfo);
extern int net_pdp_deact_proc(int c_id, unsigned char ip46flag);
extern int net_netdev_connect_internet(unsigned char netdev_id);
extern int net_netdev_disconnect_internet(unsigned char netdev_id);
extern int net_netdev_plugin_proc(unsigned char netdev_id);
extern int net_netdev_plugout_proc(unsigned char netdev_id);
extern int net_tc_control(struct tc_control_info *tcinfo,int src_id);
extern void proc_wan_change_v4(int c_id);
extern void proc_wan_change_v6(int c_id);
extern void out_of_time(unsigned char netdev_id);
extern void deletetimer(unsigned char netdev_id);
extern void creattimer(unsigned char* netdev_id);
extern int pdp_act_check(struct pdp_active_info *actinfo);
extern void set_pdp_mode(int c_id, unsigned char pdp_type);
extern void set_pdp_act_type(int c_id, unsigned char ip46flag);
extern int pdp_wan_config(struct pdp_active_info *actinfo);
extern int pdp_direct_config(struct pdp_active_info *actinfo);
extern int pdp_ppp_config(struct pdp_active_info *actinfo);
extern void reset_pdp_mode(int c_id);
extern void eth_connect();
extern void wifi_connect();
extern void vlan_config(unsigned int sw_type, char* act);
extern void ethwan_plugin();
extern void ethlan_plugin();
extern void ethwan_plugout();
extern void ethlan_plugout();
extern void wifi_plugin();
extern void net_default_wan_proc(struct default_dev_info *dev);
/********************netdev_proc.c    end********************************/

/********************net_xfrm.c    start********************************/
extern void zte_router_init(void);
extern int getNthValueSafe(int index, char *value, char delimit, char *result, int len);
extern void zte_iptables_Webs_Filter_Run(void);
extern void zte_iptables_port_map_all_run(void);
extern void zte_iptables_DMZ_Run(void);
extern void zte_iptables_sys_fw_run(void);
extern void zte_iptables_port_forward_run(void);
extern void zte_iptables_filter_run(void);
extern void zte_iptables_filter_run_v6(void);
extern void system_cmd_ex(char * cmd);
extern void zte_iptables_child_filter_run();
extern void zte_router_ping_diagnostics(void);

#if (MODEM_TYPE == vehicle_dc)
extern void zte_iptables_firewall_add(char *ip);
extern void zte_iptables_firewall_del(char *ip);
extern void zte_iptables_firewall_cleanup(void);
extern void zte_firewall_init(void);
#endif


/********************net_xfrm.c    end********************************/

/********************net_other.c    start********************************/
extern void zte_router_MTU_set(void);
extern void zte_unpn_set(void);
extern void zte_router_dhcp_set_process(void);
extern void alg_control_fun();
extern void zte_router_mtu_set_process(void);

extern void get_mac_hostname_pro(struct mac_hostname_info *mac_hostname_);
extern void zte_macip_list_run(void);
extern void zte_bind_macip_list(void);
extern void zte_bind_macip_list_add(struct static_macip_info *static_macip);
extern void zte_bind_macip_list_del(char* mac);
extern void children_device_add(struct mac_hostname_info *mac_hostname);
extern void children_device_del(char* mac);
extern void white_site_add(struct white_site_info *white_site);
extern void white_site_remove(char* ids);
extern void zte_children_start_nonet(void);
extern void zte_children_stop_nonet(void);
extern void zte_router_dhcp_setting_req_process(dhcp_setting_req *pdhcp_setting_req);
/********************net_other.c    end********************************/

int pppoe_encrypt_code(void);
int pppoe_decrypt_code(void);
int pppoe_aes_init(void);

#endif
