/*****************************************************************************
*  汾 (C)ͨѶɷ޹˾
*  ģ    MMI
*  ļ    mmi_sms.c
*  ļʶ  
*  ļ  
*  ʵֹ  MMIŵƲ
*        
*  汾      V1.0
*    2014-6-20
*  ˵  
*
*******************************************************************************/
#include "mmi_common.h"
#include "mmi_lcd.h"

//#define SMS_IN_BOX_STATUS_NV        "sms_init_status"
//#define SMS_IN_BOX_STATUS_UNREAD    "sms_unread"
//#define SMS_IN_BOX_STATUS_FULL      "sms_memory_full"
//#define SMS_IN_BOX_STATUS_NOR       "sms_normal"

static SINT32 s_mmi_sms_tip_timer_status = 0;//¶ʱҪöʱöŵ˸Ƕʱ״̬
static SINT32 s_mmi_sms_new_tip_num = 0;//ûõǷҪɾ?
static SINT32 sms_unread_number = 0;//δĿ
static E_zMmi_Sms_Recvbox_Status recvBox_state = SMS_RECVBOX_STATUS_NOR;//¼״̬
extern E_zMmiShowMode g_showMode;


/**********************************************************************************
*:ȡŵϢ
***********************************************************************************/
SINT32 mmi_get_smsinfo(UINT32 smsinfo)
{
	if (smsinfo != 0) {
		T_zMmi_Sms_Info * pSmsInfo = (T_zMmi_Sms_Info *)smsinfo;
		pSmsInfo->recvBox_sta = recvBox_state;
		pSmsInfo->mSmsNum = sms_unread_number;
	}
	return MMI_SUCCESS;
}

SINT32 mmi_RegisterSmsTaskInfoItem()
{
	T_zMMITaskInfoItem smsTaskInfoItem = {0};
	smsTaskInfoItem.task = MMI_TASK_SMS;
	smsTaskInfoItem.taskinfo = (VOID *)malloc(sizeof(T_zMmi_Sms_Info));
	smsTaskInfoItem.get_taskinfo_fun = mmi_get_smsinfo;
	smsTaskInfoItem.get_ledinfo_fun = mmi_getLedSmsInfo;
#ifndef DISABLE_LCD
	smsTaskInfoItem.get_lcdinfo_fun = mmi_getLcdSmsInfo;
#endif
	smsTaskInfoItem.ledinfo = (VOID *)malloc(sizeof(T_zMmi_Led_Info));
	//smsAppInfoItem.show_mode = 2;
	mmi_register_taskinfo_item(&smsTaskInfoItem);
	return MMI_SUCCESS;
}

static VOID mmi_set_sms_update()
{
	if (g_showMode == MMI_MODE_LCD || g_showMode == MMI_MODE_ALL) {
		mmi_set_update_flag(MMI_TASK_SMS);
	}
	if (g_showMode == MMI_MODE_LED || g_showMode == MMI_MODE_ALL) {
		E_zMmi_Work_Mode mode = mmi_get_led_mode();
		if (mode != MMI_IDLE_LEDOFF_MODE && mode != MMI_IDLE_CHG_LEDOFF_MODE
		    && mode != MMI_FAKE_POWEROFF_MODE && mode != MMI_FAKE_POWEROFF_CHARGE_MODE && mode != MMI_IDLE_STANDBY_LEDOFF_MODE) {
			mmi_set_update_flag(MMI_TASK_SMS);
		}
	}
}

/************************************************************************************
  ˸ʾʱ
***********************************************************************************/
static VOID * mmi_sms_tip_timer_cb(VOID *arg)
{
	if(recvBox_state == SMS_RECVBOX_STATUS_NEW){
		recvBox_state = SMS_RECVBOX_STATUS_UNREAD;
	}
	s_mmi_sms_tip_timer_status = 0;
	slog(MMI_PRINT, SLOG_DEBUG, "MMI mmi_sms_tip_timer_cb rec_stat:%d!!\n", recvBox_state);
	mmi_set_sms_update();
	return NULL;
}

static VOID mmi_sms_tip_timer_stop(VOID)
{
	if (s_mmi_sms_tip_timer_status == 1) {
		sc_timer_delete(SET_SMS_TIP_TIMER);
		s_mmi_sms_tip_timer_status = 0;
		slog(MMI_PRINT, SLOG_DEBUG, "MMI mmi_sms_tip_timer_stop !!\n");
	}
}

static VOID mmi_sms_tip_timer_create(VOID)
{
	char mmi_new_sms_blink_flag[NV_CONTENT_LEN] = {0};
	sc_cfg_get("mmi_new_sms_blink_flag", mmi_new_sms_blink_flag, sizeof(mmi_new_sms_blink_flag));
	//#if MMI_NEW_SMS_BLINK_FLAG
	if (0 == strcmp(mmi_new_sms_blink_flag, "1") && s_mmi_sms_tip_timer_status == 0) {
		int ret = -1;
		ret = sc_timer_create(SET_SMS_TIP_TIMER, TIMER_FLAG_ONCE, SET_SMS_TIP_TIME, &mmi_sms_tip_timer_cb, NULL);
		if (ret != 0) {
			slog(MMI_PRINT, SLOG_ERR, "MMI mmi_sms_tip_timer_create FAILED\n");
		}
		s_mmi_sms_tip_timer_status = 1;
	}
	//#endif
}

/************************************************************************************
    עᵽat_server Ķռ״̬仯ʱĻص
***********************************************************************************/
SINT32 zMMI_Handle_Msg_SmsBox_Sattus(VOID * data)
{
	SINT32 full_ind = 0;
	SINT32 unread_ind = 0;
	SINT32 newsms_ind = 0;
	SINT32 is_reading = 0;
	SINT32 unread_count = 0;
	if (data == NULL) {
		slog(MMI_PRINT, SLOG_ERR, "MMI svr_handle_msg_smsbox_status NULL message!!!");
		return MMI_ERROR;
	}
	full_ind = ((T_zUfi_SmsStatusInfoInd*)data) ->sms_memory_full_ind;
	unread_ind = ((T_zUfi_SmsStatusInfoInd*)data) ->sms_unread_ind;
	newsms_ind = ((T_zUfi_SmsStatusInfoInd*)data) ->sms_new_ind;
	is_reading = ((T_zUfi_SmsStatusInfoInd*)data) ->sms_is_reading;
	unread_count = ((T_zUfi_SmsStatusInfoInd*)data) ->sms_unread_count;
	slog(MMI_PRINT, SLOG_NORMAL, "MMI svr_handle_msg_smsbox_status full=%d  unread=%d,newsms_ind = %d,is_reading =%d,unread_count = %d !!!\n", full_ind, unread_ind, newsms_ind, is_reading, unread_count);
	sms_unread_number = unread_count;
	if (unread_ind == 1) {
		recvBox_state = SMS_RECVBOX_STATUS_UNREAD;
	}
	if (newsms_ind == 1) {
		recvBox_state = SMS_RECVBOX_STATUS_NEW;
		slog(MMI_PRINT, SLOG_DEBUG, "MMI svr_handle_msg_smsbox_status newsms_ind == 1 s_mmi_sms_tip_timer_status = %d\n", s_mmi_sms_tip_timer_status);
		mmi_sms_tip_timer_create();
	}
	if (full_ind == 1) {
		recvBox_state = SMS_RECVBOX_STATUS_FULL;
		slog(MMI_PRINT, SLOG_DEBUG, "MMI svr_handle_msg_smsbox_status full_ind == 1!!!\n");
	}
	if (is_reading == 1) {
		mmi_sms_tip_timer_stop();
		if (unread_ind == 0 && full_ind == 0 && newsms_ind == 0) {
			recvBox_state = SMS_RECVBOX_STATUS_NOR;
		}
	}
	if (is_reading == 0 && unread_ind == 0 && full_ind == 0 && newsms_ind == 0) {
		mmi_sms_tip_timer_stop();
		recvBox_state = SMS_RECVBOX_STATUS_NOR;
	}
	mmi_set_sms_update();
	return MMI_SUCCESS;
}

/************************************************************************************
                    ʼŵ
***********************************************************************************/
VOID mmi_sms_init(VOID)
{
	char smsinboxstatus[16] = {0};
	char smsUnreadNumber[16] = {0};

	sc_cfg_get(NV_SMS_INIT_STATUS, smsinboxstatus, sizeof(smsinboxstatus));
	slog(MMI_PRINT, SLOG_DEBUG, "MMI sms_led_init smsinboxstatus=%s!!!\n", smsinboxstatus);

	if (!(strncmp(smsinboxstatus, SMS_IN_BOX_STATUS_FULL, strlen(SMS_IN_BOX_STATUS_FULL)))) {
		recvBox_state = SMS_RECVBOX_STATUS_FULL;
	} else if (!(strncmp(smsinboxstatus, SMS_IN_BOX_STATUS_UNREAD, strlen(SMS_IN_BOX_STATUS_UNREAD)))) {
		slog(MMI_PRINT, SLOG_DEBUG, "MMI sms_led_init smsinboxstatus == SMS_IN_BOX_STATUS_UNREAD!!!\n");
		recvBox_state = SMS_RECVBOX_STATUS_UNREAD;
		sc_cfg_get(SMS_UNREAD_COUNT_NV, smsUnreadNumber, sizeof(smsUnreadNumber));
		sms_unread_number = atoi(smsUnreadNumber);
	} else {
		recvBox_state = SMS_RECVBOX_STATUS_NOR;
	}
	slog(MMI_PRINT, SLOG_DEBUG, "MMI sms_led_init sms_unread_number = %d !!!\n", sms_unread_number);
	mmi_set_sms_update();
	slog(MMI_PRINT, SLOG_DEBUG, "MMI sms_led_init finish!!!\n");
}

