/*********************************************************************
 Copyright 2016 by	ZIXC Corporation.
*
* FileName::	zx297520.c
* File Mark:
* Description:
* Others:
* Version:	 v1.0
* Author:	zhouqi
* Date:	  2014-1-15

* History 1:
*	  Date:
*	  Version:
*	  Author:
*	  Modification:
* History 2:
**********************************************************************/

#include <common.h>
#include <errno.h>
#include <nand.h>
#include <asm/arch/nand.h>
#include <asm/arch/hardware.h>
#include <asm/arch/uart.h>
#include <asm/arch/lsp_crpm.h>
#include <power.h>
#include <partition_table.h>

#include <mmc.h>
#include <dwmmc.h>
#include <boot_mode.h>
#include <load_image.h>
#include <zx234290.h>
#include <charge.h>
//#include <led.h>
#include <lcd.h>
#include <peripheral.h>
#include "board.h"

#include <drvs_gpio.h>

#include <asm/arch/gmac.h>
#include <command.h>
#include <version.h>
#include <secure_verify.h>
#include <asm/arch/efuse.h>

#include "cmd_downver.h"
#include <../drivers/dma/zx29_dma.h>

#include <watchdog.h>
#include <linux/mtd/partitions.h>


#define RET_BOOT_READY		1

DECLARE_GLOBAL_DATA_PTR;

#if	TIME_DEBUG
#define time_debug_reset(fmt)	fmt = get_timer(0)
#define time_debug_printf(fmt, val)	printf(fmt ,get_timer(val))
#else
#define time_debug_reset(fmt)
#define time_debug_printf(fmt, val)
#endif	/* TIME_DEBUG */

typedef struct {
	int 	(*Init)(void);
	char	func_name[20];
}sys_init_func_t;

extern boot_reason_t g_boot_reason;
extern uint32_t g_gmac_init_flag;
extern uint32_t g_gmac_init_overtime;
extern unsigned char g_ddr_size_flag;

unsigned int g_uiDebugLevel = UBOOT_NOTICE;
unsigned int g_sys_kernel_sdram_size = CONFIG_SYS_SDRAM32_A9_SIZE;


#ifndef CFG_TEMP_ADDR
#define CFG_TEMP_ADDR	0x22000000
#endif

#define reg32(addr)			(*(volatile unsigned long *)(addr))

#define UDELAY_PARAM_1SEC	(100000/3)

/* DebugLevel - Controlled at compile time
 * UBOOT_ERR	-> Noncritical error conditions.
 * UBOOT_WARN	-> Warning conditions that should be taken care of.
 * UBOOT_NOTICE -> Normal, but significant events.
 * UBOOT_DBG	-> Informational messages that require no action.
 * UBOOT_INFO	-> Debugging messages, output if the developer enabled debugging.
 */
//unsigned int g_uiDebugLevel = UBOOT_NOTICE;
extern int copy_ddr_allbin(void);

/*******************************************************************************
 * Function:	board_init
 * Description:
 * Parameters:
 *	 Input:
 *
 *	 Output:
 *
 * Returns:
 *
 *
 * Others:
 ********************************************************************************/
int board_init(void)
{
	return 0;
}

/*******************************************************************************
 * Function:	dram_init_banksize
 * Description:
 * Parameters:
 *	 Input:
 *
 *	 Output:
 *
 * Returns:
 *
 *
 * Others:
 ********************************************************************************/
void dram_init_banksize(void)
{
	gd->bd->bi_dram[0].start = PHYS_SDRAM_1;
	gd->bd->bi_dram[0].size = PHYS_SDRAM_1_SIZE;
}

/*******************************************************************************
 * Function:	dram_init
 * Description:
 * Parameters:
 *	 Input:
 *
 *	 Output:
 *
 * Returns:
 *
 *
 * Others:
 ********************************************************************************/
int dram_init(void)
{
	gd->ram_size = get_ram_size((long *)CONFIG_SYS_SDRAM_BASE,
				PHYS_SDRAM_1_SIZE);

	return 0;
}

/*******************************************************************************
 * Function:	checkboard
 * Description:
 * Parameters:
 *	 Input:
 *
 *	 Output:
 *
 * Returns:
 *
 *
 * Others:
 ********************************************************************************/
int checkboard(void)
{
#ifdef CONFIG_DISPLAY_BOARDINFO
	printf("Board: ZX297520V3\n");
#endif

	return 0;
}

void clear_iram(uint32_t addr, uint32_t len)
{
	uint32_t i = 0;
	for(i = addr; i < addr + len; i+=4)
	{
		writel(0x0, i);
	}
}

void clear_tmp_buf(void)
{
	clear_iram(CONFIG_SYS_SDRAM_TEMP_BASE, 0x800);
}

static int gmac_download_init(void)
{
	int ret = 0;

	get_gmac_init_flag();
	BOOT_PRINTF(UBOOT_DBG, "get_gmac_init_flag = 0x%x, read_gmac_init_flag = 0x%x.\n", get_gmac_init_flag(), read_gmac_init_flag());
	if(1 == read_gmac_init_flag())
	{
		BOOT_PRINTF(UBOOT_NOTICE, "gmac init overtime[%ds].....$$$$$$$$$$$$$$\n", read_gmac_init_overtime());

		puts("Net:	");
		eth_initialize(gd->bd);

		if (run_command ("downver allbins", 0) >= 0)
		{
			ret = copy_ddr_allbin();
			if(ret != 0)
			{
				BOOT_PRINTF(UBOOT_ERR, "net load write from ddr to nand FAILED !!!\n");
			}
		}
		else
		{
			BOOT_PRINTF(UBOOT_ERR, "run_command downver allbins FAILED !!!\n");
		}
	}

	return 0;
}

static int test_env_entry(void)
{
	/* Ӳ */
#if CONFIG_HARDWARE_TEST
	hardware_test();
#endif

#if CONFIG_MUTUAL_DEBUG	//1֮ͿԽUBoot̨
	for (;;)
	{
		main_loop();
	}
#endif

	return 0;
}

static int boot_reason_init(void)
{
	int ret = 0;
	unsigned int amt_flag = 0;
	unsigned int key_times = 0;
	unsigned int *poweron_type = (unsigned int *)POWERON_TYPE_ADDR;	 //ʱʹ

	BOOT_PRINTF(UBOOT_DBG, "Normal mode.\n");

	amt_flag = readl(POWERON_TYPE_ADDR);
	BOOT_PRINTF(UBOOT_NOTICE, "VALUE = 0x%x!\n", amt_flag);
	if(amt_flag == AMT_MODE_FLAG)
	{
		BOOT_PRINTF(UBOOT_NOTICE, "AMT VALUE = AMT_MODE_FLAG!\n");
		g_boot_reason = RB_AMT;
	}
	else
	{
		ret = get_boot_reason();
		if(ret != 0)
		{
			BOOT_PRINTF(UBOOT_ERR, "get boot reason ERROR !!!\n");
			/* TBD: Error Return. */
		}
	}

	if(read_fota_update_flag() == FOTA_RECOVERY)
	{
		*poweron_type = POWER_ON_FOTA;
	}
	else if(read_fota_update_flag() == FOTA_LOCALUPDATE)
	{
		*poweron_type = POWER_ON_LOCALUPDATE;
	}
	else if(g_boot_reason == RB_AMT)
	{
		*poweron_type = POWER_ON_AMT;
	}
	else if(g_boot_reason == RB_PRODUCTION)
	{
		*poweron_type = POWER_ON_PRODUCTION;
	}
	else if((g_boot_reason & 0xF0) == ZX234290_WDT_RST_FLAG)
	{
		*poweron_type = g_boot_reason & 0x0F;
	}
	else if(g_boot_reason == RB_RESET_NOMAL)
	{
		*poweron_type = POWER_ON_NORMAL;
	}
	else if(g_boot_reason == RB_RTC)
	{
		*poweron_type = POWER_ON_RTC; //POWER_ON_NORMAL;
	}
	else if(g_boot_reason == RB_RESET_EXCEPT)
	{
		*poweron_type = POWER_ON_EXCEPTRESET;
	}
	else if(g_boot_reason == RB_POWER_BOOST_IN)
	{
		*poweron_type = POWER_ON_BOOST_IN;
	}
	else if(g_boot_reason == RB_RESET_ALARM)
	{
		*poweron_type = POWER_ON_NORMAL;
	}
	else
	{
		*poweron_type = POWER_ON_NORMAL;
	}
	BOOT_PRINTF(UBOOT_NOTICE, "poweron_type=0x%x.\n", *poweron_type);
	zx234290_write_flag(ZX234290_WDT_RST_FLAG | *poweron_type);

	return 0;
}

static int bat_detect(void)
{
	return 0;
}

void display_boot_animation(unsigned int poweron_type)
{
	switch (poweron_type) {
	case POWER_ON_LOCALUPDATE:
		Show_UpdateWait();
		break;

	case POWER_ON_NORMAL:
		Show_PowerOn_Normal();
		break;

	case POWER_ON_FOTA:
		Show_PowerOn_Fota();
		break;

	case POWER_ON_CHARGING:
		Show_Charging();
		break;

	default:
		break;
	}
}

static int boot_prepare(void)
{
	unsigned int poweron_type = reg32(POWERON_TYPE_ADDR);	 //ʱʹ

	if (poweron_type == POWER_ON_CHARGING) {
		pmu_pull_off_ps_hold();
	} else {
		pmu_pull_on_ps_hold();
	}

	display_boot_animation(poweron_type);

	return 0;
}

static int boot_entry(void)
{
	int ret = 0;
	unsigned int poweron_type = reg32(POWERON_TYPE_ADDR);	 //ʱʹ

	g_ddr_size_flag = CHIP_DDR_IS_32M;

	switch (poweron_type) {
	case POWER_ON_LOCALUPDATE:
		break;
	case POWER_ON_FOTA:
		BOOT_PRINTF(UBOOT_NOTICE, "Fota entry!\n");
		if(g_ddr_size_flag == CHIP_DDR_IS_32M)
		{
			g_sys_kernel_sdram_size = CONFIG_SYS_SDRAM32_RECOVERY_A9_SIZE;
		}
		else if(g_ddr_size_flag == CHIP_DDR_IS_64M)
		{
			g_sys_kernel_sdram_size = CONFIG_SYS_SDRAM64_RECOVERY_A9_SIZE;
		}
		else if(g_ddr_size_flag == CHIP_DDR_IS_128M)
		{
			g_sys_kernel_sdram_size = CONFIG_SYS_SDRAM128_RECOVERY_A9_SIZE;
		}		
		else
		{
			g_sys_kernel_sdram_size = CONFIG_SYS_SDRAM256_RECOVERY_A9_SIZE;
		}
		
		ret = fs_load_arm_image_linux(ARM_RECOVERY_USERDATA_IMAGE);	/*FOTA-UPDATE*/
		break;
	default:
		BOOT_PRINTF(UBOOT_NOTICE, "Normal entry!\n");
		if(g_ddr_size_flag == CHIP_DDR_IS_32M)
		{
			g_sys_kernel_sdram_size = CONFIG_SYS_SDRAM32_A9_SIZE;
		}
		else if(g_ddr_size_flag == CHIP_DDR_IS_64M)
		{
			g_sys_kernel_sdram_size = CONFIG_SYS_SDRAM64_A9_SIZE;
		}
		else if(g_ddr_size_flag == CHIP_DDR_IS_128M)
		{
			g_sys_kernel_sdram_size = CONFIG_SYS_SDRAM128_A9_SIZE;
		}
		else
		{
			g_sys_kernel_sdram_size = CONFIG_SYS_SDRAM256_A9_SIZE;
		}		
		ret = fs_load_m0_image();
		ret += fs_load_zsp_image();
		ret += fs_load_arm_image_linux(ARM_APP_IMAGE);
		break;
	}

#if VERSION_RELEASE
	if( ret != 0 )
	{
		BOOT_PRINTF(UBOOT_ERR, "load images ERROR !!!\n");
	}
#endif

	return 0;
}

static const sys_init_func_t uboot_init_func_tbl[] =
{
	{wdt_get_reboot_reason,	"wdt_reboot"},
	{dma_init,				"dma"},
	{i2c_init,				"i2c"},
	{peripheral_init,		"peri"},
	{nand_init,				"nand"},
	{partition_init,		"partition"},	
	{gmac_download_init,	"gmac"},
	{test_env_entry,		"test"},
	{efuse_init,			"efuse"},
	{nvrw_flag_init,		"nvrw_flag"},
	{boot_reason_init,		"boot_reason"},
	{wdt_init,				"wdt"},
	{bat_detect,			"bat_det"},
	{boot_prepare,			"boot_prepare"},
	{NULL,					{}}
};

static const sys_init_func_t tboot_init_func_tbl[] =
{
	{wdt_get_reboot_reason,	"wdt_reboot"},
	{dma_init,				"dma"},
	{i2c_init,				"i2c"},
	{peripheral_init,		"peri"},
	{nand_init,				"nand"},
	{NULL,					{}}
};

int uboot_init_func(void)
{
	unsigned int dev_index;
	int ret;

	BOOT_PRINTF(UBOOT_NOTICE, "go into uboot init func\n");

	for (dev_index = 0; (uboot_init_func_tbl[dev_index].Init != NULL); dev_index++)
	{
		ret = uboot_init_func_tbl[dev_index].Init();

		if (ret < 0) {
			BOOT_PRINTF(UBOOT_ERR, "uboot init %s fail, ret = %d\n",
				uboot_init_func_tbl[dev_index].func_name, ret);
			BUG();
			return ret;
		} else {
			BOOT_PRINTF(UBOOT_NOTICE, "uboot init %s success\n",
				uboot_init_func_tbl[dev_index].func_name);
		}
	}

	return SUCCESS;
}

int tboot_init_func(void)
{
	unsigned int dev_index;
	int ret;

	BOOT_PRINTF(UBOOT_NOTICE, "go into tboot init func\n");

	for (dev_index = 0; (tboot_init_func_tbl[dev_index].Init != NULL); dev_index++)
	{
		ret = tboot_init_func_tbl[dev_index].Init();
		if (ret < 0) {
			BOOT_PRINTF(UBOOT_ERR, "tboot init %s fail, ret = %d\n",
				tboot_init_func_tbl[dev_index].func_name, ret);
			BUG();
			return ret;
		} else {
			BOOT_PRINTF(UBOOT_NOTICE, "tboot init %s success\n",
				tboot_init_func_tbl[dev_index].func_name);
		}
	}

	return SUCCESS;
}

/*******************************************************************************
 * Function:	sys_entry
 * Description: ϵͳ
 * Parameters:
 *	 Input:
 *
 *	 Output:
 *
 * Returns:
 *
 *
 * Others:
 ********************************************************************************/
void sys_entry(void)
{

	BOOT_PRINTF(UBOOT_NOTICE, "sys_entry ...\n");

	switch (get_load_mode()) {
	case TLOAD_MODE:
		tboot_init_func();
		run_command("downloader", 0);
		break;
	case ZLOAD_MODE:
		uboot_init_func();
		boot_entry();
		//clear_tmp_buf();
		break;
	default:
		break;
	}

	add_partition_to_bootargs();
	for (;;)
	{
		main_loop();
	}

	hang();
	/* NOTREACHED - no way out of command loop except booting */
}

