#!/bin/sh
### BEGIN INIT INFO
# Provides:          mountvirtfs
# Required-Start:
# Required-Stop:
# Default-Start:     S
# Default-Stop:
# Short-Description: Mount kernel virtual file systems.
# Description:       Mount initial set of virtual filesystems the kernel
#                    provides and that are required by everything.
### END INIT INFO

if [ -e /proc ] && ! [ -e /proc/mounts ]; then
  mount -t proc proc /proc
fi

if [ -e /sys ] && grep -q sysfs /proc/filesystems && ! [ -e /sys/class ]; then
  mount -t sysfs sysfs /sys
fi

if [ -e /sys/kernel/debug ] && grep -q debugfs /proc/filesystems; then
  mount -t debugfs debugfs /sys/kernel/debug
fi

if [ -e /sys/kernel/config ] && grep -q configfs /proc/filesystems; then
  mount -t configfs configfs /sys/kernel/config
fi

if [ -e /sys/firmware/efi/efivars ] && grep -q efivarfs /proc/filesystems; then
  mount -t efivarfs efivarfs /sys/firmware/efi/efivars
fi

if ! [ -e /dev/zero ] && [ -e /dev ] && grep -q devtmpfs /proc/filesystems; then
  mount -n -t devtmpfs devtmpfs /dev
fi

mkdir -p /tmp
#l.yang modify for T106BUG-387 start 
mount   -t  tmpfs   tmpfs    /tmp -o nodev,nosuid,noexec
#l.yang modify for T106BUG-387 end
mkdir -p /run
#l.yang modify for T106BUG-387 start
mount   -t  tmpfs   tmpfs    /run  -o nodev,nosuid,noexec
#l.yang modify for T106BUG-387 end
mkdir -p /dev/pts
mount   -t  devpts  devpts   /dev/pts

mkdir -p /tmp/run
#support cgroup
if [ -e /sys/fs/cgroup ]; then
    mount -t tmpfs cgroup  /sys/fs/cgroup
    #mkdir -p /sys/fs/cgroup/cpuset
    #mount -t cgroup -o cpuset cpuset /sys/fs/cgroup/cpuset
    mkdir -p /sys/fs/cgroup/cpu,cpuacct
    mount -t cgroup -o cpu,cpuacct cgroup /sys/fs/cgroup/cpu,cpuacct
    mkdir -p /sys/fs/cgroup/memory
    mount -t cgroup -o memory cgroup /sys/fs/cgroup/memory
    cd /sys/fs/cgroup
    ln -s /sys/fs/cgroup/cpu,cpuacct cpu
    ln -s /sys/fs/cgroup/cpu,cpuacct cpuacct
fi




#软锁panic
#echo 1 > /proc/sys/kernel/softlockup_panic
#内存耗尽oom panic
echo 1 > /proc/sys/vm/panic_on_oom
#警告panic
#echo 1 > /proc/sys/kernel/panic_on_warn
#echo 0 > /proc/sys/kernel/hung_task_timeout_secs

echo "mount configfs..."
mount none /sys/kernel/config  -t configfs


echo "ifconfig lo up"
ifconfig lo 127.0.0.1 up

echo 2 > /proc/sys/kernel/randomize_va_space
echo 2 > /proc/sys/kernel/kptr_restrict
# l.yang task-208 The patches for T106 eMMC and flash optimization have been integrated start 
echo performance > /sys/devices/system/cpu/cpufreq/policy0/scaling_governor
# l.yang task-208 The patches for T106 eMMC and flash optimization have been integrated end

