SUMMARY       = "zxic normal image"
IMAGE_LINGUAS = " "
LICENSE       = "zte"
PV = "1.0.0"
PR = "r0"

inherit core-image extrausers   ${@bb.utils.contains("DISTRO_FEATURES", "selinux", "selinux-image", "", d)} 

OPENWRT_FULL ="\
    packagegroup-openwrt-minimal \
    packagegroup-openwrt-base \
    packagegroup-openwrt-full \
    ugps \
    usbmode \
    urngd \
    mtd-utils-ubifs \
    fwtool \
    usign \
    swconfig \
    mtd-openwrt \
    opkg \
    cgi-io \
    "
OPENWRT_RECOVERY ="\
    packagegroup-openwrt-minimal \
    mtd-utils-ubifs \
    mtd-openwrt \
    "


OPENWRT_PACKAGE = "${@bb.utils.contains("BOOT_CTL", "recovery", "${OPENWRT_RECOVERY}", "${OPENWRT_FULL}", d)}"
IS_OPENWRT = "${@bb.utils.contains('DISTRO_FEATURES', 'OPENWRT', 'true', 'false', d)}"
ROOT_FS_NAME = "${@bb.utils.contains("BOOT_CTL", "recovery", "ap_recoveryfs.bin", "ap_caprootfs.img", d)}"
USEDATA_FS_NAME = "${@bb.utils.contains("BOOT_CTL", "recovery", "ap_userdata_recovery.bin", "ap_capuserdata.img", d)}"
OEMDATA_FS_NAME = "${@bb.utils.contains("BOOT_CTL", "recovery", "ap_oemdata_recovery.bin", "cap_oemdata.img", d)}"

CORE_IMAGE_BASE_INSTALL = '\
    ${@bb.utils.contains("DISTRO_FEATURES", "OPENWRT", "${OPENWRT_PACKAGE}", "", d)} \ 
    packagegroup-core-boot-zxic \
    packagegroup-lynq-t106 \
    ${@bb.utils.contains("DISTRO_FEATURES", "selinux", "packagegroup-selinux-minimal", "", d)} \ 
    ${MACHINE_EXTRA_RDEPENDS}   \
    ${CORE_IMAGE_EXTRA_INSTALL} \
    '

# Include modules in rootfs
IMAGE_INSTALL += "${CORE_IMAGE_BASE_INSTALL}"

IMAGE_INSTALL += " \
	kernel-modules \
	${@bb.utils.contains('DISTRO_FEATURES', 'sysvinit', 'dpkg-start-stop', '', d)} \
	"

#pub include
include ${BSPDIR}/sources/meta-zxic/conf/pub.inc

DEPENDS  += "\
    u-boot-tools-native rsync-native \
    ${@bb.utils.contains("USERDATA_FSTYPE", "ubi", "mtd-utils-native", "", d)} \
    ${@bb.utils.contains('IMAGE_FSTYPES', 'squashfs', 'squashfskit-native', '', d)} \
    ${@bb.utils.contains('DISTRO_FEATURES','dm-verity','cryptsetup-native','',d)} \
    ${@bb.utils.contains('DISTRO_FEATURES','dm-verity','coreutils-native','',d)} \
    " 

# Add \ in front of $
ROOT_PASSWD = "\$6\$GnJN6BAFj7TmbOS\$o4tptoaFJYZe79CWh2VzAgGhQGqfDHoraVUs0nr4TT2e9V2ubq.l.nLrF80ECrtfvPrJDL1J3fbR62nei9A3F1"
#EXTRA_USERS_PARAMS += "usermod -p '${ROOT_PASSWD}' root;"
EXTRA_USERS_PARAMS += "${@bb.utils.contains("DISTRO_FEATURES", "OPENWRT", "usermod -p '${ROOT_PASSWD}' root;", "", d)}"

fakeroot distro_rootfs_files_systemd() {
	rm -rf ${IMAGE_ROOTFS}/boot
	cp -arfp ${FS-DIR}/fs/${BOOT_CTL}/rootfs/*   ${IMAGE_ROOTFS}/
}

fakeroot distro_rootfs_files_fpga() {
	rm -rf ${IMAGE_ROOTFS}/boot
	rm -rf ${IMAGE_ROOTFS}/linuxrc
	rm -rf ${IMAGE_ROOTFS}/etc/systemd/system.conf
	cp -arfp ${FS-DIR}/fs/${BOOT_CTL}/rootfs/*   ${IMAGE_ROOTFS}/
	chmod 644 ${IMAGE_ROOTFS}/etc/passwd
	chmod 644 ${IMAGE_ROOTFS}/etc/group
	chmod 644 ${IMAGE_ROOTFS}/etc/inittab
	chmod 400 ${IMAGE_ROOTFS}/etc/shadow
	chmod a+x ${IMAGE_ROOTFS}/etc/init.d/rcS
	chmod a+r ${IMAGE_ROOTFS}/etc/init.d/rcS
}

fakeroot distro_rootfs_files_sysvinit() {
	rm -rf ${IMAGE_ROOTFS}/boot
	cp -arfp ${FS-DIR}/fs/${BOOT_CTL}/rootfs/*   ${IMAGE_ROOTFS}/

	rm -rf ${IMAGE_ROOTFS}/etc/rc[0-6].d
	rm -f ${IMAGE_ROOTFS}/etc/fstab
	rm -f ${IMAGE_ROOTFS}/etc/default/rcS
	chmod 644 ${IMAGE_ROOTFS}/etc/passwd
	chmod 644 ${IMAGE_ROOTFS}/etc/group
	chmod 644 ${IMAGE_ROOTFS}/etc/inittab
	chmod 400 ${IMAGE_ROOTFS}/etc/shadow
	chmod a+x ${IMAGE_ROOTFS}/etc/init.d/rcS
	find ${IMAGE_ROOTFS}/ -name '.gitkeep' -print0 | xargs -0 rm -fr
}

ROOTFS_POSTPROCESS_COMMAND += "\
    ${@bb.utils.contains("DISTRO_FEATURES", "sysvinit", "distro_rootfs_files_sysvinit;", "", d)}   \
    ${@bb.utils.contains("DISTRO_FEATURES", "systemd", "distro_rootfs_files_systemd;", "", d)}   \
    "

fakeroot do_cprootfs() {
	#rm -fv ${BINS-PATH}/${ROOT_FS_NAME}
	mkdir -p ${BINS-PATH} ${ELFS-PATH}

	if [ ${IMAGE_FSTYPES} = 'cpio.gz' ]; then
		cd ${IMAGE_ROOTFS} && find . | cpio -o -H newc | gzip -9 > ${IMAGE_ROOTFS}/ramdisk.image.gz
		mv  ${IMAGE_ROOTFS}/ramdisk.image.gz  ${BINS-PATH}/${ROOT_FS_NAME}
		if [ -d "${TMPDIR}/work/zx298501-zxic-linux-musl/linux-zxic/5.4.154-r0" ]; then      
			cp -arfp ${THISDIR}/files/Makefile_dtb ${B}/Makefile
			cp -arfp ${THISDIR}/files/fix_rootfs_dts.sh  ${B}/
			${B}/fix_rootfs_dts.sh   ${MACHINE}-${DISTRO}  ${TMPDIR}/work-shared/zx298501/kernel-source  ${BINS-PATH}
			oe_runmake -C ${B} S=${TMPDIR}/work/zx298501-zxic-linux-musl/linux-zxic/5.4.154-r0  BINS-PATH=${ELFS-PATH} DTB=${MACHINE}-${DISTRO}.dtb
		fi
	else
		#cp -v ${IMGDEPLOYDIR}/${IMAGE_LINK_NAME}.${IMAGE_FSTYPES}  ${BINS-PATH}/${ROOT_FS_NAME}
		cp -v ${IMGDEPLOYDIR}/rootfs.tgz ${ELFS-PATH}/${ROOT_FS_NAME}.tgz
	fi
}

fakeroot do_cleanrootfs () {
	rm -fv ${BINS-PATH}/${ROOT_FS_NAME}
	rm -fv ${BINS-PATH}/${USEDATA_FS_NAME}
	rm -fv ${BINS-PATH}/*.img*
}

do_product_ini() {
	mkdir -p ${BINS-PATH}
	echo "[imagefs]" > ${BINS-PATH}/product.ini
	echo "mkfs_ubifs=${IMAGEFS_MKUBIFS_ARGS}" >>  ${BINS-PATH}/product.ini
	echo "ubinize=${IMAGEFS_UBINIZE_ARGS}"    >>  ${BINS-PATH}/product.ini
}

do_all_flags_bin() {
	${BSPDIR}/zxic_code/pub/tools/libflags/flags_tool -f ${BINS-PATH}/all_flags.bin ${FLAGS_ARGS}
}

fakeroot do_mkubifs(){
	if [ ${BOOT_CTL} = 'normal' ]; then
		cp -arfp ${THISDIR}/files/ubinize-cfg.sh ${B}
		cp -arfp ${BSPDIR}/sources/meta-zxic-custom/conf/distro/include/${USERDATA_UBINIZE_CFG} ${B}
		mkdir -p ${BINS-PATH}
		${B}/ubinize-cfg.sh "${BINS-PATH}/${USEDATA_FS_NAME}"  "${B}/${USERDATA_UBINIZE_CFG}"  "${USERDATA_UBINIZE_ARGS}"
#LYNQ_MODIFY_ZXW_TASK944_XF.Li_20250123_START
if ${@bb.utils.contains('MOBILETEK_NAND_TYPE','M22','true','false',d)}; then
		${B}/ubinize-cfg.sh "${BINS-PATH}/ap_capuserdata_M22.img"  "${B}/${USERDATA_UBINIZE_CFG}"  "${LYNQ_M22_USERDATA_UBINIZE_ARGS}"
fi
#LYNQ_MODIFY_ZXW_TASK944_XF.Li_20250123_END
		mkdir -p ${IMAGE_ROOTFS}/etc_ro/
		cp -v "${BINS-PATH}/${USEDATA_FS_NAME}" ${IMAGE_ROOTFS}/etc_ro/
	fi
}


fakeroot do_rootfs_squashfs(){
	cp -arfp ${THISDIR}/files/ubinize-static.sh ${B}
	if ${@bb.utils.contains('DISTRO_FEATURES','dm-verity','true','false',d)}; then
		cp -arfp ${THISDIR}/files/squashfs_dm-verity.sh ${B}
		cp -arfp ${THISDIR}/files/zxic_generate_squashfs_verity ${B}
	fi
	if ${@bb.utils.contains('DISTRO_FEATURES','dm-verity','true','false',d)}; then
		touch  ${IMAGE_ROOTFS}/etc_ro/dm-verity
	else
		rm -fv ${IMAGE_ROOTFS}/etc_ro/dm-verity
	fi

	rm -fv ${IMGDEPLOYDIR}/${IMAGE_NAME}${IMAGE_NAME_SUFFIX}.squashfs_tmp
	mksquashfs4 ${IMAGE_ROOTFS} ${IMGDEPLOYDIR}/${IMAGE_NAME}${IMAGE_NAME_SUFFIX}.squashfs_tmp ${ROOTFS_SQUASHFS_ARGS}
	if ${@bb.utils.contains('DISTRO_FEATURES','dm-verity','true','false',d)}; then
		cp ${IMGDEPLOYDIR}/${IMAGE_NAME}${IMAGE_NAME_SUFFIX}.squashfs_tmp  ${S}/${ROOT_FS_NAME}.unsigned
		echo "veritysetup and ubinize in do_dm_verity() later ${IMAGE_NAME}${IMAGE_NAME_SUFFIX}"
	else
		echo "rootfs squashfs need ubinize-image on nand flash"
		${B}/ubinize-static.sh vol_rootfs "${BINS-PATH}/ap_caprootfs.img" ${IMGDEPLOYDIR}/${IMAGE_NAME}${IMAGE_NAME_SUFFIX}.squashfs_tmp "${UBINIZE_ARGS}"
	fi
	cd ${IMAGE_ROOTFS}/../ && tar -czvf ${IMGDEPLOYDIR}/rootfs.tgz  rootfs
}

fakeroot do_oemfs_squashfs(){
	cp -arfp ${THISDIR}/files/ubinize-static.sh ${B}
	cp  -arfp  ${FS-DIR}/fs/normal/oem/   ${S}/
	if ${@bb.utils.contains('DISTRO_FEATURES','dm-verity','true','false',d)}; then
		cp -arfp ${THISDIR}/files/squashfs_dm-verity.sh ${B}
		cp -arfp ${THISDIR}/files/zxic_generate_squashfs_verity ${B}
	fi

	rm -fv ${IMGDEPLOYDIR}/oem.squashfs_tmp
	mksquashfs4 ${S}/oem ${IMGDEPLOYDIR}/oem.squashfs_tmp ${ROOTFS_SQUASHFS_ARGS}
	if ${@bb.utils.contains('DISTRO_FEATURES','dm-verity','true','false',d)}; then
		cp ${IMGDEPLOYDIR}/oem.squashfs_tmp  ${S}/cap_oem.img.unsigned
		echo "veritysetup and ubinize in do_dm_verity() later"
	else
		echo "oem squashfs need ubinize-image on nand flash"
		${B}/ubinize-static.sh vol_oem "${BINS-PATH}/cap_oem.img" ${IMGDEPLOYDIR}/oem.squashfs_tmp "${UBINIZE_ARGS}"
		mkdir -p ${ELFS-PATH}
		rm -rf ${IMGDEPLOYDIR}/oem.squashfs_tmp
	fi
	mkdir -p ${ELFS-PATH}
	cd ${S}/oem/../ && tar -czvf ${ELFS-PATH}/oem.tgz  oem

}

fakeroot do_oemfs_oemdata(){
	if [ ${BOOT_CTL} = 'normal' ]; then
		cp -arfp ${THISDIR}/files/ubinize-cfg.sh ${B}
		cp -arfp ${BSPDIR}/sources/meta-zxic-custom/conf/distro/include/${OEMDATA_UBINIZE_CFG} ${B}
		mkdir -p ${BINS-PATH}
		${B}/ubinize-cfg.sh "${BINS-PATH}/${OEMDATA_FS_NAME}"  "${B}/${OEMDATA_UBINIZE_CFG}"  "${USERDATA_UBINIZE_ARGS}"
#LYNQ_MODIFY_ZXW_TASK944_XF.Li_20250123_START
if ${@bb.utils.contains('MOBILETEK_NAND_TYPE','M22','true','false',d)}; then
		${B}/ubinize-cfg.sh "${BINS-PATH}/cap_oemdata_M22.img"  "${B}/${OEMDATA_UBINIZE_CFG}"  "${LYNQ_M22_USERDATA_UBINIZE_ARGS}"
fi
#LYNQ_MODIFY_ZXW_TASK944_XF.Li_20250123_END
		mkdir -p ${IMAGE_ROOTFS}/etc_ro/
		cp -v "${BINS-PATH}/${OEMDATA_FS_NAME}" ${IMAGE_ROOTFS}/etc_ro/
	fi
}

ROOTFS_POSTPROCESS_COMMAND_remove += 'empty_var_volatile;'

fakeroot do_postinstall(){
	if [ -f ${IMAGE_ROOTFS}/postinstall.sh ]; then
		cd ${IMAGE_ROOTFS} && sh postinstall.sh && rm -v ${IMAGE_ROOTFS}/postinstall.sh
	fi
}

fakeroot do_ln_musl_ld(){
	if [ ! -L ${IMAGE_ROOTFS}/lib/ld-linux-aarch64.so.1 ]; then
		if [ -L ${IMAGE_ROOTFS}/lib/ld-musl-aarch64.so.1 ]; then
			cd ${IMAGE_ROOTFS}/lib && ln -snf ld-musl-aarch64.so.1  ld-linux-aarch64.so.1
		fi
	fi
}

do_dm_verity(){
	if ${@bb.utils.contains('DISTRO_FEATURES','dm-verity','true','false',d)}; then
		rm -fv ${BINS-PATH}/ap_caprootfs.dm
		${S}/squashfs_dm-verity.sh  ${S}/${ROOT_FS_NAME}.unsigned  ${S} \
			${BINS-PATH}/ap_caprootfs.img.dm ${SIGNIMAGE_PRIVATE_KEY} ${BSPDIR}/tools/SignTool/SignImage
		${S}/ubinize-static.sh vol_rootfs "${BINS-PATH}/ap_caprootfs.img" ${BINS-PATH}/ap_caprootfs.img.dm "${UBINIZE_ARGS}"
#LYNQ_MODIFY_ZXW_TASK944_XF.Li_20250123_START
if ${@bb.utils.contains('MOBILETEK_NAND_TYPE','M22','true','false',d)}; then
		${S}/ubinize-static.sh vol_rootfs "${BINS-PATH}/ap_caprootfs_M22.img" ${BINS-PATH}/ap_caprootfs.img.dm "${LYNQ_M22_UBINIZE_ARGS}"
fi
#LYNQ_MODIFY_ZXW_TASK944_XF.Li_20250123_END
		if ${@bb.utils.contains('DISTRO_FEATURES','oemfs','true','false',d)}; then
			rm -fv ${BINS-PATH}/cap_oem.img.dm
			${B}/squashfs_dm-verity.sh  ${S}/cap_oem.img.unsigned  ${B} \
				${BINS-PATH}/cap_oem.img.dm ${SIGNIMAGE_PRIVATE_KEY} ${BSPDIR}/tools/SignTool/SignImage
			${B}/ubinize-static.sh vol_oem "${BINS-PATH}/cap_oem.img" ${BINS-PATH}/cap_oem.img.dm "${UBINIZE_ARGS}"
#LYNQ_MODIFY_ZXW_TASK944_XF.Li_20250123_START
if ${@bb.utils.contains('MOBILETEK_NAND_TYPE','M22','true','false',d)}; then
			${B}/ubinize-static.sh vol_oem "${BINS-PATH}/cap_oem_M22.img" ${BINS-PATH}/cap_oem.img.dm "${LYNQ_M22_UBINIZE_ARGS}"
fi
#LYNQ_MODIFY_ZXW_TASK944_XF.Li_20250123_END
		fi
	fi
}

IMAGE_POSTPROCESS_COMMAND_prepend = ' \
    do_postinstall; \
    ${@bb.utils.contains("TCLIBC", "musl", "do_ln_musl_ld;", "", d)} \
    ${@bb.utils.contains("DISTRO_FEATURES", "selinux", "selinux_set_labels ;", "", d)} \
   '

IMAGE_POSTPROCESS_COMMAND += "\
    ${@bb.utils.contains("USERDATA_FSTYPE", "ubi", "do_mkubifs;", "", d)} \
    ${@bb.utils.contains("DISTRO_FEATURES", "oemfs", "do_oemfs_squashfs;", "", d)} \
    ${@bb.utils.contains("DISTRO_FEATURES", "oemfs", "do_oemfs_oemdata;", "", d)} \
    ${@bb.utils.contains("IMAGE_FSTYPES", "squashfs", "do_rootfs_squashfs;", "", d)} \
    "
#xf.li@20240716 add start
do_oem_config() {
	LYNQ_INSIDE_VERSION_UCI="        option LYNQ_SW_INSIDE_VERSION '${LYNQ_CONFIG_VERSION}'"
	eval sed -i 's/^.*LYNQ_SW_INSIDE_VERSION.*$/"${LYNQ_INSIDE_VERSION_UCI}"/' ${IMAGE_ROOTFS}/etc/config/lynq_uci_ro
	cp -R ${TOPDIR}/prebuilt/rootfs/* ${IMAGE_ROOTFS}/
	if [ "${MOBILETEK_LOG_ENCRYPT}" = "enable" ]; then
		touch ${IMAGE_ROOTFS}/etc/syslog_encrypt_flag
	else
		rm -rf ${IMAGE_ROOTFS}/etc/syslog_encrypt_flag
		touch ${IMAGE_ROOTFS}/etc/no_log_encrypt
	fi
}
addtask  do_oem_config after do_rootfs before do_image
#xf.li@20240716 add end
addtask  cprootfs after do_dm_verity before do_build
addtask  do_dm_verity after do_image_complete  before do_build
addtask  cleanrootfs after do_clean  before do_cleansstate

