inherit externalsrc package systemd

DESCRIPTION = "autosuspend.service"

LICENSE = "MobileTekProprietary"
LIC_FILES_CHKSUM = "file://${WORKDIR}/LICENSE;md5=44d8d2b6296ca24bcd4894bb7155bf27"

SRC_URI = "file://autosuspend.c file://LICENSE \
           file://autosuspend.h \
           file://autosuspend_ops.h \
           file://autosuspend_wakeup_count.c \
           file://main.c \
           file://autosuspend.service \
           file://lynq-autosuspend.sh \
           file://makefile \
"

EXTRA_OEMAKE = "'TARGET_PLATFORM = ${TARGET_PLATFORM}'"

TARGET_CC_ARCH += "${LDFLAGS}"

LOCAL_C_INCLUDES = "-I. "

DEPENDS = "liblynq-log liblynq-uci"
DEPENDS += "${@bb.utils.contains('TARGET_PLATFORM', 'mt2735', 'audio-mixer-ctrl streamer1.0', '', d)} liblynq-log liblynq-uci libbsp libsctel libatutils libatreg liblynq-sim"
LOCAL_LIBS = "-L. -ldl -lstdc++ -lpthread -llog"
SOURCES = "$(wildcard *.c )"

OBJECTS = "$(SOURCES:.c=.o)"

EXECUTABLE = "autosuspend"
S = "${WORKDIR}"
TARGET_CC_ARCH += "${LDFLAGS}"
SYSTEMD_PACKAGES = "${PN}"
SYSTEMD_SERVICE_${PN} = "autosuspend.service"
FILES_${PN} += "${systemd_unitdir}/system/autosuspend.service"
#INHIBIT_PACKAGE_STRIP = "1"
do_compile () {

	#${CXX} -Wall ${LOCAL_C_INCLUDES} autosuspend.c autosuspend_wakeup_count.c main.c ${LOCAL_LIBS} -o ${EXECUTABLE}
	if test "${PACKAGE_ARCH}" = "cortexa7hf-vfp-vfpv4-neon" || test "${PACKAGE_ARCH}" = "cortexa7hf-neon-vfpv4"; then
		oe_runmake all ROOT=${STAGING_DIR_HOST} OFLAGS="--sysroot=${STAGING_DIR_HOST} -mhard-float"
	else
		oe_runmake all ROOT=${STAGING_DIR_HOST} OFLAGS="--sysroot=${STAGING_DIR_HOST}"
	fi
}

do_install() {
	install -d ${D}${bindir}/
	echo "Installing image PN ${PN}"
	echo "Installing image systemd_unitdir ${systemd_unitdir}"
	echo "Installing image D ${D}"
	echo "Installing image B ${B}"
	if ${@bb.utils.contains('DISTRO_FEATURES','systemd','true','false',d)}; then
		install -d ${D}${systemd_unitdir}/system/
		install -m 0644 ${B}/autosuspend.service ${D}${systemd_unitdir}/system
    else
		install -d ${D}${sysconfdir}/init.d
        install -m 0755  ${S}/lynq-autosuspend.sh ${D}${sysconfdir}/init.d/
        install -d ${D}${sysconfdir}/rcS.d
        ln -s ../init.d/lynq-autosuspend.sh ${D}${sysconfdir}/rcS.d/S82lynq-autosuspend-service
	fi

	install -m 0755 ${S}/autosuspend ${D}${bindir}/
	install -d ${D}${includedir}
}






