#inherit externalsrc package

DESCRIPTION = "liblynq-qser-gnss"
LICENSE = "CLOSED"
LIC_FILES_CHKSUM = "file://LICENSE;md5=3f86c7f456a6d0bbeca155e65084eee1"
DEPENDS += "liblynq-log libxml2 liblynq-uci libsctel libscrtc libbsp liblynq-qser-autosuspend"
#inherit workonsrc
WORKONSRC = "${TOPDIR}/../src/lynq/lib/liblynq-qser-gnss/"
FILESEXTRAPATHS_prepend :="${TOPDIR}/../src/lynq/lib/:"
SRC_URI = " \
          file://liblynq-qser-gnss\
          "

SRC-DIR = "${S}/../liblynq-qser-gnss"

TARGET_CC_ARCH += "${LDFLAGS}"
BB_INCLUDE_ADD = "--sysroot=${STAGING_DIR_HOST}"
BB_LDFLAGS_ADD = "--sysroot=${STAGING_DIR_HOST} -Wl,--hash-style=gnu"

EXTRA_OEMAKE += "'MOBILETEK_GNSS_TYPE = ${MOBILETEK_GNSS_TYPE}'"

EXTRA_OEMAKE += "'TARGET_PLATFORM = ${TARGET_PLATFORM}'"

FILES_${PN} += "${bindir} /data/gnss_update"
FILES_${PN} += "${base_libdir}/*.so "
FILES_${PN}-dev = "/test \
                   ${includedir}"

FILES_${PN}-doc = "/doc"

FILES_${PN}-dbg ="${base_bindir}/.debug \
                  ${base_libdir}/.debug \
                  ${base_sbindir}/.debug"

INSANE_SKIP_${PN} += "already-stripped"
INSANE_SKIP_${PN} += "installed-vs-shipped"


#INHIBIT_PACKAGE_STRIP = "1"
do_compile () {
        oe_runmake all -C ${SRC-DIR} ROOT=${STAGING_DIR_HOST} OFLAGS="--sysroot=${STAGING_DIR_HOST} -Os -Wl,--hash-style=gnu -DTELEPHONYWARE"
}

do_install () {
    oe_runmake install -C ${SRC-DIR} ROOT=${D}

    if [ -d "${WORKONSRC}" ] ; then
        install -d ${D}${includedir}/
        cp -raf ${SRC-DIR}/include/ ${D}${includedir}/
    fi
    if [ "${MOBILETEK_GNSS_UPDATE_ENABLE}" = "yes" ]; then
        install -d ${D}/data/gnss_update
        install -m 644 ${WORKONSRC}HD8122.YIKE.GN3.115200.0035.720e5.53ef0.GQALS.ANT.EPH.CFG.PPS13.240115R1.bin ${D}/data/gnss_update
        install -m 644 ${WORKONSRC}HD8122.YIKE.GN3.115200.0037.dbd12.53ef0.GAQBS.B1C.ANT.EPH.CFG.PPS13.240416R1.bin ${D}/data/gnss_update
        install -m 644 ${WORKONSRC}agps.conf ${D}/data/gnss_update
        ln -sf ./HD8122.YIKE.GN3.115200.0035.720e5.53ef0.GQALS.ANT.EPH.CFG.PPS13.240115R1.bin ${D}/data/gnss_update/HD.bin
        ln -sf ./HD8122.YIKE.GN3.115200.0037.dbd12.53ef0.GAQBS.B1C.ANT.EPH.CFG.PPS13.240416R1.bin ${D}/data/gnss_update/HD_BD.bin
    fi
}

addtask bachclean
do_bachclean () {
    oe_runmake clean
}
