/*******************************************************************************
 * Copyright (C) 2007, ZTE Corporation.
 *
 * File Name:    hal_voicebuffer.h
 * File Mark:    
* Description:  Provide voicebuffer hal function prototype declaration and type declaration.
 * Others:        
 * Version:       V0.5
 * Author:        xxq
 * Date:          2024-07-11
 * History 1:      
 *     Date: 
 *     Version:
 *     Author: 
 *     Modification:  add mute/read/write/loopback.
 * History 2: 
  ********************************************************************************/

#ifndef _HAL_VOICEBUFFER_H
#define _HAL_VOICEBUFFER_H


/****************************************************************************
*                                             Include files
****************************************************************************/


/****************************************************************************
*                                             Macros
****************************************************************************/
#define VP_BUF_LENGTH  0x7FF80 //0xFFD80   //0x7FE40  //0x4df80// (0.5M  0x80000)
#define VP_FRAME_BUFFER_SIZE 320 //20ms 800KHZ
#define VP_I2S_BUFFER_SIZE 320
#define VOICE_SYNC_TIMEOUT_TIME 100
	
	//#define VP_INOUT_BAK_BUFFER_SIZE 0x30000	// 0x60000
#define VP_INOUT_NOBAK_BUFSIZE  640
#define VB_MAX_INT	     0x7fffffff
#define VB_MIN_INT        0 //(0-2<<31)//0x80000000
	
#define VB_INT_OVERFLOW(x) if((x < VB_MIN_INT)||(x > VB_MAX_INT))  x = 0;

#define RPMSG_CAP_ID 1

#define MAX_BUF_SIZE	     640
#define MAX_BUF_NUM        3

/****************************************************************************
*                                             Types
****************************************************************************/



enum{
	UP_LINK,
	DOWN_LINK	
};

struct voice_ring_buffer {
	volatile uint read_pos;
	volatile uint write_pos;
	volatile char data[];

};


/****************************************************************************
*                                             Constants
****************************************************************************/

/****************************************************************************
*                                             Global  Variables
****************************************************************************/

/****************************************************************************
*                                             Function Prototypes
****************************************************************************/

SINT32 vp_Open_Vbuffer(void);

SINT32 vp_Close_Vbuffer(void);

SINT32 vp_VoiceI2sStart_Vbuffer(VOID);

VOID vp_VoiceI2sStop_Vbuffer(VOID);

SINT32 zDrvVp_VoiceWorkStop_Vbuffer(VOID);

SINT32 vp_VolteReadStart_Vbuffer(VOID);
//whole replace 
SINT32 vp_VolteReadStop_Vbuffer(VOID);

SINT32 vp_VolteWriteStart_Vbuffer(VOID);
//whole replace
SINT32 vp_VolteWriteStop_Vbuffer(VOID);

SINT32 vp_WriteDataToCodec_Vbuffer(UINT8 *pBuf, UINT32 count);

SINT32 vp_ReadDataFromCodec_Vbuffer(UINT8 *pBuf, UINT32 count);

SINT32 vp_CreateThreadSemaph_Vbuffer(VOID);




#endif/*_HAL_VOICEBUFFER_H*/

