/*******************************************************************************
 * Copyright (C) 2007, ZTE Corporation.
 *
 * File Name:
 * File Mark:
 * Description:
 * Others:
 * Version:
 * Author:        lvwenhua
 * Date:          2011-8-24
 * History 1:
 *     Date: 2016-2-16
 *     Version:
 *     Author:xuxinqiang
 *     Modification: edit for union version
 * History 2:
  ********************************************************************************/

/****************************************************************************
* 	                                           Include files
****************************************************************************/
#include "drvs_general.h"
#include "NvParam_drv.h"

#ifdef _OS_TOS
#include "./tos/LVVE.h"
#include "./tos/PARAM_Default.h"
#include "./tos/nxp_DrvNvData.h"

#elif defined _OS_LINUX
#include "./uclinux/LVVE.h"
#include "./uclinux/PARAM_Default.h"
#include "./uclinux/nxp_DrvNvData.h"

#else
#include "LVVE.h"
#include "PARAM_Default.h"
#include "nxp_DrvNvData.h"
#endif

#include "drvs_voiceprocess.h"
#include "drvs_ramlog.h"

#include "hal_audiointf.h"
#include "RWNvConfig.h"

/****************************************************************************
* 	                                           Local Macros
****************************************************************************/
#define MAX_BLK_SIZE                400                  /* Maximum possible block size */
#define LVVE_NUM_OF_SAMPLES        160
#define VP_PARAM_IS_IN_NV        1

/****************************************************************************
* 	                                          Global Constants
****************************************************************************/
//extern BOOL g_vpMuteEn;
//extern UINT8 g_voiceInGsmTdMode;
//extern UINT8 g_voiceInVolteMode;
//extern UINT8 g_volteIsWb;
//extern UINT8 g_isUseSlicCodec;
extern T_zDrvVoice_GbVar g_voiceVar;
static BOOL g_nxpIsOpen = FALSE;


/****************************************************************************
* 	                                          Global Variables
****************************************************************************/
LVM_INT32   InBuffer16_Tx_FE[MAX_BLK_SIZE];                  /* Stereo, 16-bit aligned input buffer */
LVM_INT16   pNoiseData[4];

LVM_MemoryTable_st          MemoryTable_Tx = {0};                             /* Module memory table */
LVM_MemoryTable_st          MemoryTable_Rx = {0};                             /* Module memory table */
LVVE_Tx_Handle_t            hInstance_Tx = LVM_NULL;                               /* Module instance handle */
LVVE_Rx_Handle_t            hInstance_Rx = LVM_NULL;                               /* Module instance handle */

#define NUM_VOL_RX                   (5)                  /* Number of Rx volumes */

//LVM_CHAR                    LVVE_Tx_Preset_Buffer[LVVE_TX_PRESET_LENGTH]; /* Byte buffer */
LVVE_Tx_Preset_t            LVVE_Tx_Preset ; /* Preset buffer */
//LVM_CHAR                    LVVE_Rx_Preset_Buffer[NUM_VOL_RX*LVVE_RX_PRESET_LENGTH]; /* Byte buffer */
LVVE_Rx_Preset_t            LVVE_Rx_Preset ; /* Preset buffer */
//LVM_CHAR                    LVVE_Tx_Preset_Buffer_Volte[LVVE_TX_PRESET_LENGTH]; /* Byte buffer */
//LVM_CHAR                    LVVE_Rx_Preset_Buffer_Volte[NUM_VOL_RX*LVVE_RX_PRESET_LENGTH]; /* Byte buffer */

T_Audio_NvParam g_audioNvParam = {0};

static LVM_UINT32	NumBytesReadRx;                               /* Number of bytes in the preset file  RX*/
static LVM_UINT32	NumBytesReadTx;                               /* Number of bytes in the preset file  TX*/

static BOOL isFirstTxProcessErr = TRUE;
static BOOL isFirstRxProcessErr = TRUE;
/****************************************************************************
* 	                                          Global Function Prototypes
****************************************************************************/
//T_ZDrv_VoiceOutputPath  s_vpPathout;
//T_ZDrvVoice_OutputVolLevel  s_vpVolout;

UINT32 zOss_NvItemRead(UINT32 NvItemID, UINT8 *NvItemData, UINT32 NvItemLen);
UINT32 zOss_NvItemWrite(UINT32 NvItemID, UINT8 *NvItemData, UINT32 NvItemLen);

/****************************************************************************
* 	                                          Function Definitions
****************************************************************************/
SINT32 Vp_NxpInitNvParam(VOID)
{
	SINT32 ret = DRV_SUCCESS;
	SINT32 i = 0;

	LVVE_VersionInfo            pVersion;                                   /* version information */
	LVVE_GetVersionInfo(&pVersion);

	zDrvRamlog_PRINTF(RAMLOG_MOD_AUDIO, "nxp Version  %s\n", pVersion.VersionNumber);
#if 0
	ret = zOss_NvItemRead(OS_FLASH_VOICE_DRV_RW_NONFAC_BASE_ADDR, ((UINT8 *)(&g_audioNvParam.audio_ctrlFlag)),  sizeof(g_audioNvParam.audio_ctrlFlag));
	zDrvRamlog_PRINTF(RAMLOG_MOD_AUDIO, "Vp_NxpInitNvParam voice  flag baseAdd=0x%x, ret =%d ,isVpParamInNv= %d \n", (OS_FLASH_VOICE_DRV_RW_NONFAC_BASE_ADDR), \
	                  ret, g_audioNvParam.audio_ctrlFlag.isVpParamInNv);

	zDrvRamlog_PRINTF(RAMLOG_MOD_AUDIO, "Vp_NxpInitNvParam voiceflag isVpParamInNv=%d,isUseSlicCodec=%d,isUseVoiceProc=%d,isUseCodecDsp=%d,isUseNvWrite=%d \n", \
	                  g_audioNvParam.audio_ctrlFlag.isVpParamInNv, g_audioNvParam.audio_ctrlFlag.isUseSlicCodec, g_audioNvParam.audio_ctrlFlag.isUseVoiceProc, \
	                  g_audioNvParam.audio_ctrlFlag.isUseCodecDsp, g_audioNvParam.audio_ctrlFlag.isUseNvWrite);

	zDrvRamlog_PRINTF(RAMLOG_MOD_AUDIO, "Vp_NxpInitNvParam the g_audioNvParam size=%d,audio_ctrlFlag size=%d\n", \
	                  sizeof(g_audioNvParam), sizeof(g_audioNvParam.audio_ctrlFlag));

	g_voiceVar.audio_ctrlFlag = g_audioNvParam.audio_ctrlFlag;
	g_voiceVar.isUseSlicCodec = g_audioNvParam.audio_ctrlFlag.isUseSlicCodec;
	g_voiceVar.g_isUseTdm = g_audioNvParam.audio_ctrlFlag.isUseTdm;
	zDrvRamlog_PRINTF(RAMLOG_MOD_AUDIO, " Vp_NxpInitNvParam g_voiceVar.isUseSlicCodec=%d, g_voiceVar.g_isUseTdm=%d!\n", g_voiceVar.isUseSlicCodec, g_voiceVar.g_isUseTdm);
#endif

	g_audioNvParam.audio_ctrlFlag = g_voiceVar.audio_ctrlFlag;
#if 0
	if (g_audioNvParam.audio_ctrlFlag.isVpParamInNv == 1)
	{
		ret = zOss_NvItemRead(OS_FLASH_VOICE_RW_NONFAC_BASE_ADDR, ((UINT8 *)(&g_audioNvParam.vpNxpParamFile)),  sizeof(g_audioNvParam.vpNxpParamFile));
		zDrvRamlog_PRINTF(RAMLOG_MOD_AUDIO, "Vp_NxpInitNvParam Read audio nv param base add=0x%x,vpNxpParamFile size=%d \n", \
		                  (OS_FLASH_VOICE_RW_NONFAC_BASE_ADDR), sizeof(g_audioNvParam.vpNxpParamFile));

	}
	else
	{
		zDrvRamlog_PRINTF(RAMLOG_MOD_AUDIO, "Vp_NxpInitNvParam Set all path to the default param, txbuffer size=%d, rxbuffer size=%d \n", sizeof(LVVE_Tx_Preset_Buffer_Voice_Tool), sizeof(LVVE_Rx_Preset_Buffer_Voice_Tool));
		// Vp_Nxp_Param_File.LVVE_Tx_File_Buffer=LVVE_Tx_Preset_Buffer_Voice_Tool;
		//Vp_Nxp_Param_File.LVVE_Rx_File_Buffer=LVVE_Rx_Preset_Buffer_Voice_Tool;
		for (i = 0; i < AUDIO_MAX_VP_PATH; i++)
		{
			zOss_Memcpy(g_audioNvParam.vpNxpParamFile.vpNxpPathParam[i].nxpTxFileBuffer, LVVE_Tx_Preset_Buffer_Voice_Tool, sizeof(LVVE_Tx_Preset_Buffer_Voice_Tool));
			zOss_Memcpy(g_audioNvParam.vpNxpParamFile.vpNxpPathParam[i].nxpRxFileBuffer, LVVE_Rx_Preset_Buffer_Voice_Tool, sizeof(LVVE_Rx_Preset_Buffer_Voice_Tool));
		}
		zOss_Memcpy(g_audioNvParam.vpNxpParamFile.nxpTxNbMuteBuffer, LVVE_Tx_Mute_File_Buffer, sizeof(LVVE_Tx_Mute_File_Buffer));
		zOss_Memcpy(g_audioNvParam.vpNxpParamFile.nxpTxWbMuteBuffer, LVVE_Tx_Wb_Mute_File_Buffer, sizeof(LVVE_Tx_Wb_Mute_File_Buffer));
	}
#endif
	zDrvRamlog_PRINTF(RAMLOG_MOD_AUDIO, "Vp_NxpInitNvParam is over \n");

	return ret;
}

SINT32 Vp_NxpOpen(UINT32 fs)
{

	LVVE_Tx_InstanceParams_st   InstanceParams_Tx;                          /* Instance parameters */
	LVVE_Rx_InstanceParams_st   InstanceParams_Rx;                          /* Instance parameters */
	LVVE_ReturnStatus_en        LVVE_Status;                                /* Module status return */
	LVM_INT32                   i, ret = 0;                                          /* Index variable */

	if (g_nxpIsOpen == TRUE)
	{
		zDrvRamlog_PRINTF(RAMLOG_MOD_AUDIO, "nxp already opened!  \n");
		return DRV_SUCCESS;
	}

	if (fs == 8000)
	{

		InstanceParams_Rx.SampleRate    = LVM_FS_8000;
		InstanceParams_Rx.EQ_InstParams.EQ_MaxLength = LVVE_MAX_EQ_LENGTH_NB;
		InstanceParams_Tx.SampleRate    = LVM_FS_8000;
		InstanceParams_Tx.MaxBulkDelay  = LVVE_MAX_BULK_DELAY;
		InstanceParams_Tx.EQ_InstParams.EQ_MaxLength = LVVE_MAX_EQ_LENGTH_NB;
		zDrvRamlog_PRINTF(RAMLOG_MOD_AUDIO, "Vp_NxpOpen confg NB param!  \n", fs);
	}
	else if (fs == 16000)
	{
		InstanceParams_Rx.SampleRate    =  LVM_FS_16000;
		InstanceParams_Rx.EQ_InstParams.EQ_MaxLength =  LVVE_MAX_EQ_LENGTH_WB;
		InstanceParams_Tx.SampleRate    =  LVM_FS_16000;
		InstanceParams_Tx.MaxBulkDelay  =  LVVE_MAX_BULK_DELAY;
		InstanceParams_Tx.EQ_InstParams.EQ_MaxLength =  LVVE_MAX_EQ_LENGTH_WB;
		zDrvRamlog_PRINTF(RAMLOG_MOD_AUDIO, "Vp_NxpOpen confg WB param !  \n", fs);
	}
	else
	{
		zDrvRamlog_PRINTF(RAMLOG_MOD_AUDIO, "Vp_NxpOpen nxp the fs=%d not support!  \n", fs);
		return DRV_ERROR;
	}

	/******************************************************************************
	    Allocate memory
	*******************************************************************************/
	/*
	 * Get the memory requirements for the Tx Module
	 */
	zDrvRamlog_PRINTF(RAMLOG_MOD_AUDIO, "before LVVE_Tx_GetMemoryTable\n");

	LVVE_Status = LVVE_Tx_GetMemoryTable(LVM_NULL,
	                                     &MemoryTable_Tx,
	                                     &InstanceParams_Tx);

	if (LVVE_Status == LVVE_NULLADDRESS)
	{
		zDrvRamlog_PRINTF(RAMLOG_MOD_AUDIO, "Parameter error - null pointer error returned by LVVE_Tx_GetMemoryTable\n");
		return DRV_ERROR;
	}
	if (LVVE_Status == LVVE_OUTOFRANGE)
	{
		zDrvRamlog_PRINTF(RAMLOG_MOD_AUDIO, "Parameter error - out of range error returned by LVVE_Tx_GetMemoryTable\n");
		return DRV_ERROR;
	}

	/*
	 * Allocate the memory for the Tx module
	 */
	for (i = 0; i < LVM_NR_MEMORY_REGIONS; i++)
	{
		if (MemoryTable_Tx.Region[i].Size != 0)
		{
			MemoryTable_Tx.Region[i].pBaseAddress = zOss_Malloc(MemoryTable_Tx.Region[i].Size);
			zDrvRamlog_PRINTF(RAMLOG_MOD_AUDIO, "Nxp tx malloc size = %d", MemoryTable_Tx.Region[i].Size);

			if (MemoryTable_Tx.Region[i].pBaseAddress == LVM_NULL)
			{
				zDrvRamlog_PRINTF(RAMLOG_MOD_AUDIO, "Failed to allocate %d bytes for region %d\n", (LVM_INT16)MemoryTable_Tx.Region[i].Size, (LVM_INT16)i);
			}
		}

	}

	/*
	 * Get the memory requirements for the Rx Module
	 */

	LVVE_Status = LVVE_Rx_GetMemoryTable(LVM_NULL,
	                                     &MemoryTable_Rx,
	                                     &InstanceParams_Rx);
	if (LVVE_Status == LVVE_NULLADDRESS)
	{
		zDrvRamlog_PRINTF(RAMLOG_MOD_AUDIO, "Parameter error - null pointer error returned by LVVE_Rx_GetMemoryTable\n");
		return DRV_ERROR;
	}
	if (LVVE_Status == LVVE_OUTOFRANGE)
	{
		zDrvRamlog_PRINTF(RAMLOG_MOD_AUDIO, "Parameter error - out of range error returned by LVVE_Rx_GetMemoryTable\n");
		return DRV_ERROR;
	}

	/*
	 * Allocate the memory for the Rx module
	 */
	for (i = 0; i < LVM_NR_MEMORY_REGIONS; i++)
	{
		if (MemoryTable_Rx.Region[i].Size != 0)
		{
			MemoryTable_Rx.Region[i].pBaseAddress = zOss_Malloc(MemoryTable_Rx.Region[i].Size);
			zDrvRamlog_PRINTF(RAMLOG_MOD_AUDIO, "Nxp rx malloc size = %d\n", MemoryTable_Rx.Region[i].Size);

			if (MemoryTable_Rx.Region[i].pBaseAddress == LVM_NULL)
			{
				zDrvRamlog_PRINTF(RAMLOG_MOD_AUDIO, "Failed to allocate %d bytes for region %d\n", (LVM_INT16)MemoryTable_Rx.Region[i].Size, (LVM_INT16)i);
			}
		}
	}

	/*
	 * Allocate the memory for the noise data buffer (2*LVVE_NUM_OF_SAMPLES)
	 */

	hInstance_Tx = LVM_NULL;                                            /* Initialise to NULL */
	LVVE_Status = LVVE_Tx_GetInstanceHandle(&hInstance_Tx,              /* Init sets the instance handle */
	                                        &MemoryTable_Tx,
	                                        &InstanceParams_Tx);

	zDrvRamlog_PRINTF(RAMLOG_MOD_AUDIO, "LVVE_Tx_GetInstanceHandle LVVE_Status=%d\n", LVVE_Status);
	if (LVVE_Status == LVVE_NULLADDRESS)
	{
		zDrvRamlog_PRINTF(RAMLOG_MOD_AUDIO, "Parameter error - null pointer error returned by LVVE_Tx_GetInstanceHandle\n");
		return DRV_ERROR;
	}
	if (LVVE_Status == LVVE_OUTOFRANGE)
	{
		zDrvRamlog_PRINTF(RAMLOG_MOD_AUDIO, "Parameter error - out of range error returned by LVVE_Tx_GetInstanceHandle\n");
		return DRV_ERROR;
	}

	hInstance_Rx = LVM_NULL;                                            /* Initialise to NULL */
	LVVE_Status = LVVE_Rx_GetInstanceHandle(&hInstance_Rx,              /* Init sets the instance handle */
	                                        &MemoryTable_Rx,
	                                        &InstanceParams_Rx);
	zDrvRamlog_PRINTF(RAMLOG_MOD_AUDIO, "LVVE_Rx_GetInstanceHandle LVVE_Status=%d\n", LVVE_Status);
	if (LVVE_Status == LVVE_NULLADDRESS)
	{
		zDrvRamlog_PRINTF(RAMLOG_MOD_AUDIO, "Parameter error - null pointer error returned by LVVE_Rx_GetInstanceHandle\n");
		return DRV_ERROR;
	}
	if (LVVE_Status == LVVE_OUTOFRANGE)
	{
		zDrvRamlog_PRINTF(RAMLOG_MOD_AUDIO, "Parameter error - out of range error returned by LVVE_Rx_GetInstanceHandle\n");
		return DRV_ERROR;
	}
	LVM_UINT32 nxpParamSize = 0, nxpParamOffset = 0;

	nxpParamSize = 4 * (LVWM_TX_FILE_SIZE + LVWM_RX_FILE_SIZE);

	g_audioNvParam.s_nxpPathParam = zOss_Malloc(nxpParamSize);
	if (g_audioNvParam.s_nxpPathParam == NULL)
	{
		zDrvRamlog_PRINTF(RAMLOG_MOD_AUDIO, "Failed to allocate g_audioNvParam.s_nxpPathParam\n");
		return DRV_ERROR;
	}

	g_audioNvParam.s_nxpTxNbMuteParam = zOss_Malloc(2 * LVWM_TX_FILE_SIZE);
	if (g_audioNvParam.s_nxpTxNbMuteParam == NULL)
	{
		zDrvRamlog_PRINTF(RAMLOG_MOD_AUDIO, "Failed to allocate g_audioNvParam.s_nxpTxNbMuteParam\n");
		return DRV_ERROR;
	}
	g_audioNvParam.s_nxpTxWbMuteParam = g_audioNvParam.s_nxpTxNbMuteParam + LVWM_TX_FILE_SIZE;

	zDrvRamlog_PRINTF(RAMLOG_MOD_AUDIO, "Vp_NxpOpen s_nxpPathParam=%p,s_nxpTxNbMuteParam=%p\n", g_audioNvParam.s_nxpPathParam, g_audioNvParam.s_nxpTxNbMuteParam);
	if (g_audioNvParam.audio_ctrlFlag.isVpParamInNv == 1)
	{
		if (g_voiceVar.voiceMode == VOICE_GSM_MODE)
		{
			nxpParamOffset = 0;
		}
		else if ((g_voiceVar.voiceMode == VOICE_WCDMA_MODE) || (g_voiceVar.voiceMode == VOICE_TD_MODE))
		{
			if (g_voiceVar.volteIsWb != 1)
			{
				nxpParamOffset = nxpParamSize;
			}
			else
			{
				nxpParamOffset = 2 * nxpParamSize;
			}
		}
		else if (g_voiceVar.voiceMode == VOICE_LTE_MODE)
		{
			if (g_voiceVar.volteIsWb != 1)
			{
				nxpParamOffset = 3 * nxpParamSize;
			}
			else
			{
				nxpParamOffset = 4 * nxpParamSize;
			}
		}

		ret = zOss_NvItemRead(OS_FLASH_VOICE_RW_NONFAC_BASE_ADDR + nxpParamOffset, g_audioNvParam.s_nxpPathParam,  nxpParamSize);

		nxpParamOffset = 5 * nxpParamSize;
		ret = zOss_NvItemRead(OS_FLASH_VOICE_RW_NONFAC_BASE_ADDR + nxpParamOffset, g_audioNvParam.s_nxpTxNbMuteParam,  2 * LVWM_TX_FILE_SIZE);
		zDrvRamlog_PRINTF(RAMLOG_MOD_AUDIO, "Vp_NxpInitNvParam Read audio nv param base add=0x%x,vpNxpParamFile size=%d \n", \
		                  (OS_FLASH_VOICE_RW_NONFAC_BASE_ADDR + nxpParamOffset), nxpParamSize);

	}
	else
	{
		zDrvRamlog_PRINTF(RAMLOG_MOD_AUDIO, "Vp_NxpInitNvParam Set all path to the default param, txbuffer size=%d, rxbuffer size=%d \n", sizeof(LVVE_Tx_Preset_Buffer_Voice_Tool), sizeof(LVVE_Rx_Preset_Buffer_Voice_Tool));
		// Vp_Nxp_Param_File.LVVE_Tx_File_Buffer=LVVE_Tx_Preset_Buffer_Voice_Tool;
		//Vp_Nxp_Param_File.LVVE_Rx_File_Buffer=LVVE_Rx_Preset_Buffer_Voice_Tool;
		for (i = 0; i < 4; i++)
		{
			zOss_Memcpy(g_audioNvParam.s_nxpPathParam + i * (LVWM_TX_FILE_SIZE + LVWM_RX_FILE_SIZE), LVVE_Tx_Preset_Buffer_Voice_Tool, sizeof(LVVE_Tx_Preset_Buffer_Voice_Tool));
			zOss_Memcpy(g_audioNvParam.s_nxpPathParam + LVWM_TX_FILE_SIZE + i * (LVWM_TX_FILE_SIZE + LVWM_RX_FILE_SIZE), LVVE_Rx_Preset_Buffer_Voice_Tool, sizeof(LVVE_Rx_Preset_Buffer_Voice_Tool));
		}
		zOss_Memcpy(g_audioNvParam.s_nxpTxNbMuteParam, LVVE_Tx_Mute_File_Buffer, sizeof(LVVE_Tx_Mute_File_Buffer));
		zOss_Memcpy(g_audioNvParam.s_nxpTxWbMuteParam, LVVE_Tx_Wb_Mute_File_Buffer, sizeof(LVVE_Tx_Wb_Mute_File_Buffer));
	}
	isFirstTxProcessErr = TRUE;
	isFirstRxProcessErr = TRUE;
	g_nxpIsOpen = TRUE;

	return DRV_SUCCESS;
}

SINT32 Vp_NxpClose(VOID)
{

	LVVE_ReturnStatus_en        LVVE_Status;                                /* Module status return */
	LVM_INT32                   i;                                          /* Index variable */

	LVVE_Status = LVVE_Tx_GetMemoryTable(hInstance_Tx,
	                                     &MemoryTable_Tx,
	                                     LVM_NULL);

	if (LVVE_Status == LVVE_NULLADDRESS)
	{
		zDrvRamlog_PRINTF(RAMLOG_MOD_AUDIO, "Vp_NxpClose Parameter error - null pointer error returned by LVVE_Tx_GetMemoryTable\n");
		return DRV_ERROR;
	}
	if (LVVE_Status == LVVE_OUTOFRANGE)
	{
		zDrvRamlog_PRINTF(RAMLOG_MOD_AUDIO, "Vp_NxpClose Parameter error - out of range error returned by LVVE_Tx_GetMemoryTable\n");
		return DRV_ERROR;
	}

	/* For each region */
	for (i = 0; i < LVM_NR_MEMORY_REGIONS; i++)
	{
		if ((MemoryTable_Tx.Region[i].Size != 0) && (MemoryTable_Tx.Region[i].pBaseAddress != LVM_NULL))
		{
			zOss_Free(MemoryTable_Tx.Region[i].pBaseAddress);
			MemoryTable_Tx.Region[i].pBaseAddress = LVM_NULL;
		}
	}

	LVVE_Status = LVVE_Rx_GetMemoryTable(hInstance_Rx,
	                                     &MemoryTable_Rx,
	                                     LVM_NULL);

	if (LVVE_Status == LVVE_NULLADDRESS)
	{
		zDrvRamlog_PRINTF(RAMLOG_MOD_AUDIO, "Vp_NxpClose Parameter error - null pointer error returned by LVVE_Rx_GetMemoryTable\n");
		return DRV_ERROR;
	}

	if (LVVE_Status == LVVE_OUTOFRANGE)
	{
		zDrvRamlog_PRINTF(RAMLOG_MOD_AUDIO, "Vp_NxpClose Parameter error - out of range error returned by LVVE_Rx_GetMemoryTable\n");
		return DRV_ERROR;
	}

	/* For each region */
	for (i = 0; i < LVM_NR_MEMORY_REGIONS; i++)
	{
		if ((MemoryTable_Rx.Region[i].Size != 0) && (MemoryTable_Rx.Region[i].pBaseAddress != LVM_NULL))
		{
			zOss_Free(MemoryTable_Rx.Region[i].pBaseAddress);
			MemoryTable_Rx.Region[i].pBaseAddress = LVM_NULL;
		}
	}

	if (g_audioNvParam.s_nxpPathParam != NULL)
	{
		zOss_Free(g_audioNvParam.s_nxpPathParam);
		g_audioNvParam.s_nxpPathParam = NULL;
	}
	if (g_audioNvParam.s_nxpTxNbMuteParam != NULL)
	{
		zOss_Free(g_audioNvParam.s_nxpTxNbMuteParam);
		g_audioNvParam.s_nxpTxNbMuteParam = NULL;
	}

	hInstance_Tx = LVM_NULL;
	hInstance_Rx = LVM_NULL;
	g_nxpIsOpen = FALSE;

	//zOss_Free(pNoiseData);

//   zOss_Printf(SUBMDL_HAL, PRINT_LEVEL_NORMAL,"Vp_NxpClose success\n");
	return DRV_SUCCESS;
}

SINT32 Vp_NxpGetParam(T_ZDrvVoice_MODE voiceMode, T_ZDrv_VpPath path)
{
	//add by zhanglixia
	//UINT32  ret;//xiu gai chu
	zDrvRamlog_PRINTF(RAMLOG_MOD_AUDIO, "Vp_NxpGetParam ######get NXP parameter start####### voiceMode=%d,path=%d \n", voiceMode, path);
	UINT32 pathTxOffset, pathRxOffset;
	/************************************************************************************/
	/* Set the Voice Engine Parameter values                                            */
	/************************************************************************************/
	/*
	* Read the Rx preset file and send the bytes to the Rx Module
	*/

	if (g_nxpIsOpen == FALSE)
	{
		zDrvRamlog_PRINTF(RAMLOG_MOD_AUDIO, "Vp_NxpGetParam, nxp has not been opened yet!\n");
		return DRV_ERR_NOT_OPENED;
	}
	
	/*klocwork 3  INVARIANT_CONDITION.UNREACH  MAX_VP_PATHΪVP_PATH_BLUETOOTH ɾ (path<0)*/
	if (path > VP_PATH_BLUETOOTH) 
	{
		zDrvRamlog_PRINTF(RAMLOG_MOD_AUDIO, "Vp_NxpGetParam the path error\n");
		return DRV_ERROR;
	}

	if (g_audioNvParam.audio_ctrlFlag.isUseVoiceProc != 1)
	{
		zDrvRamlog_PRINTF(RAMLOG_MOD_AUDIO, "Vp_NxpGetParam error g_audioNvParam.audio_ctrlFlag.isUseVoiceProc != 1 \n");
		return DRV_ERROR;
	}

	pathTxOffset = path * (LVWM_TX_FILE_SIZE + LVWM_RX_FILE_SIZE);
	pathRxOffset = path * (LVWM_TX_FILE_SIZE + LVWM_RX_FILE_SIZE) + LVWM_TX_FILE_SIZE;

	if (g_audioNvParam.audio_ctrlFlag.isVpParamInNv == 1)
	{
		LVVE_Tx_Preset = (LVM_CHAR*)g_audioNvParam.s_nxpPathParam + pathTxOffset ;
		LVVE_Rx_Preset = (LVM_CHAR*)g_audioNvParam.s_nxpPathParam + pathRxOffset ;

		NumBytesReadTx = LVWM_TX_FILE_SIZE;
		NumBytesReadRx = LVWM_RX_FILE_SIZE;
	}
	else
	{
		LVVE_Rx_Preset = LVVE_Rx_Preset_Buffer_Voice_Tool;
		LVVE_Tx_Preset = LVVE_Tx_Preset_Buffer_Voice_Tool;

		NumBytesReadTx = sizeof(LVVE_Tx_Preset_Buffer_Voice_Tool);
		NumBytesReadRx =  sizeof(LVVE_Rx_Preset_Buffer_Voice_Tool);

	}

	if (g_voiceVar.muteEn == TRUE)
	{
		if (g_audioNvParam.audio_ctrlFlag.isVpParamInNv == 1)
		{
			if (g_voiceVar.volteIsWb != 1)
			{
				zDrvRamlog_PRINTF(RAMLOG_MOD_AUDIO, "Vp_NxpGetParam set nb mute config !\r\n");
				LVVE_Tx_Preset = g_audioNvParam.s_nxpTxNbMuteParam;//xiu gai chu tong shang
				NumBytesReadTx = LVWM_TX_FILE_SIZE;
			}
			else
			{
				zDrvRamlog_PRINTF(RAMLOG_MOD_AUDIO, "Vp_NxpGetParam set wb mute config !\r\n");
				LVVE_Tx_Preset = g_audioNvParam.s_nxpTxWbMuteParam;//xiu gai chu tong shang
				NumBytesReadTx = LVWM_TX_FILE_SIZE;
			}
		}
		else
		{
			if (g_voiceVar.volteIsWb != 1)
			{
				zDrvRamlog_PRINTF(RAMLOG_MOD_AUDIO, "Vp_NxpGetParam set nb mute config !\r\n");
				LVVE_Tx_Preset = LVVE_Tx_Mute_File_Buffer;
				NumBytesReadTx = sizeof(LVVE_Tx_Mute_File_Buffer);
			}
			else
			{
				zDrvRamlog_PRINTF(RAMLOG_MOD_AUDIO, "Vp_NxpGetParam set wb mute config !\r\n");
				LVVE_Tx_Preset = LVVE_Tx_Wb_Mute_File_Buffer;
				NumBytesReadTx = sizeof(LVVE_Tx_Wb_Mute_File_Buffer);

			}
		}
	}

	zDrvRamlog_PRINTF(RAMLOG_MOD_AUDIO, "Vp_NxpGetParam NumBytesReadRx=%d NumBytesReadTx= %d\n ", NumBytesReadRx , NumBytesReadTx);
	/*klocwork 3  INVARIANT_CONDITION.UNREACH   delete if*/
    /*
	if ((NumBytesReadRx == LVM_NULL) || (NumBytesReadTx == LVM_NULL))
	{
		zDrvRamlog_PRINTF(RAMLOG_MOD_AUDIO, "Vp_NxpSetParam NXP read para is null !\r\n");
		return DRV_ERROR;
	}*/
	return DRV_SUCCESS;

}

SINT32 Vp_NxpSetParam(T_ZDrv_VpPath path, T_ZDrv_VpVol volume, BOOL isLoop)
{
	LVVE_ReturnStatus_en        LVVE_Status;                                /* Module status return */
	LVM_UINT16                  VolumeIndex;

	zDrvRamlog_PRINTF(RAMLOG_MOD_AUDIO, "Vp_NxpSetParam ######set NXP parameter start#######");
	/************************************************************************************/
	/* Set the Voice Engine Parameter values                                            */
	/************************************************************************************/
	if (g_nxpIsOpen == FALSE)
	{
		zDrvRamlog_PRINTF(RAMLOG_MOD_AUDIO, "Vp_NxpSetParam, nxp has not been opened yet!\n");
		return DRV_ERR_NOT_OPENED;
	}

	/*klocwork 3  INVARIANT_CONDITION.UNREACH  MAX_VP_PATHΪVP_PATH_BLUETOOTH ɾ (path<0)*/
	if (path > VP_PATH_BLUETOOTH) 
	{
		zDrvRamlog_PRINTF(RAMLOG_MOD_AUDIO, "Vp_NxpSetParam the path error\n");
		return DRV_ERROR;
	}
	VolumeIndex = volume; /* Max Rx volume */
	zDrvRamlog_PRINTF(RAMLOG_MOD_AUDIO, "Vp_NxpSetParam VolumeIndex  is %d\n", VolumeIndex);

	if ((hInstance_Rx == NULL) || (LVVE_Rx_Preset == NULL) || (hInstance_Tx == NULL) || (LVVE_Tx_Preset == NULL))
	{
		zDrvRamlog_PRINTF(RAMLOG_MOD_AUDIO, "Vp_NxpSetParam, the input parameter is NULL\n");
		return DRV_ERR_INVALID_PARAM;
	}

	LVVE_Status = LVVE_Rx_SetPreset(hInstance_Rx, LVVE_Rx_Preset, NumBytesReadRx, VolumeIndex);
	if (LVVE_Status != LVVE_SUCCESS)
	{
		zDrvRamlog_PRINTF(RAMLOG_MOD_AUDIO, "Vp_NxpSetParam Error returned by LVVE_Rx_SetPreset: Error_code = %d\n", LVVE_Status);
		return DRV_ERROR;
	}

	LVVE_Status = LVVE_Tx_SetPreset(hInstance_Tx, LVVE_Tx_Preset, NumBytesReadTx, 0);
	if (LVVE_Status != LVVE_SUCCESS)
	{
		zDrvRamlog_PRINTF(RAMLOG_MOD_AUDIO, "Vp_NxpSetParam Error returned by LVVE_Tx_SetPreset: Error_code = %d\n", LVVE_Status);
		return DRV_ERROR;
	}

	return DRV_SUCCESS;
}

SINT32 Vp_NxpSetParamTool(T_ZDrv_VpPath path, T_ZDrv_VpVol volume,
                          zDrvVp_NxpParamsTool *NxpParamsTool,   BOOL isLoop, BOOL isVolte)
{
	LVVE_ReturnStatus_en        LVVE_Status;                                /* Module status return */
	//LVM_UINT32  ret;//xiu gai chu
	LVM_UINT16                  VolumeIndex;                                /* Volume index variable */
	UINT32 nvAddrTxOffset = 0;
	UINT32 nvAddrRxOffset = 0;

	UINT32 pathTxOffset, pathRxOffset;

	UINT32  ret = DRV_SUCCESS;
	/************************************************************************************/
	/* Set the Voice Engine Parameter values                                            */
	/************************************************************************************/
	VolumeIndex = volume; /* Max Rx volume */
	if (g_nxpIsOpen == FALSE)
	{
		zDrvRamlog_PRINTF(RAMLOG_MOD_AUDIO, "Vp_NxpSetParamTool,nxp has not been opened yet!\n");
		return DRV_ERR_NOT_OPENED;
	}

	zDrvRamlog_PRINTF(RAMLOG_MOD_AUDIO, "######set NXP parameter start#######");
	zDrvRamlog_PRINTF(RAMLOG_MOD_AUDIO, "Vp_NxpSetParamTool path = %d, volume = %d\n", path, volume);
	if ((NxpParamsTool->PresetLengthTx > LVWM_TX_FILE_SIZE) || (NxpParamsTool->PresetLengthRx > LVWM_RX_FILE_SIZE))
	{
		zDrvRamlog_PRINTF(RAMLOG_MOD_AUDIO, "The length is wrong!PresetLengthRx=%d,PresetLengthTx=%d", NxpParamsTool->PresetLengthRx, NxpParamsTool->PresetLengthTx);
		return DRV_ERROR;
	}
	zDrvRamlog_PRINTF(RAMLOG_MOD_AUDIO, "PresetLengthRx=%d NumBytesReadRx= %d volume= %d", NxpParamsTool->PresetLengthRx, NumBytesReadRx, volume);

	LVVE_Status = LVVE_Rx_SetPreset(hInstance_Rx, (const LVVE_Rx_Preset_t)NxpParamsTool->pPresetRx, NxpParamsTool->PresetLengthRx, VolumeIndex);

	if (LVVE_Status != LVVE_SUCCESS)
	{
		zDrvRamlog_PRINTF(RAMLOG_MOD_AUDIO, "Error returned by LVVE_Rx_SetPreset: Error_code = %d\n", LVVE_Status);
		return DRV_ERROR;
	}
	zDrvRamlog_PRINTF(RAMLOG_MOD_AUDIO, "PresetLengthTx=%d NumBytesReadTx= %d", NxpParamsTool->PresetLengthTx, NumBytesReadTx);
	LVVE_Status = LVVE_Tx_SetPreset(hInstance_Tx, (const LVVE_Tx_Preset_t)NxpParamsTool->pPresetTx, NxpParamsTool->PresetLengthTx, 0);

	if (LVVE_Status != LVVE_SUCCESS)
	{
		zDrvRamlog_PRINTF(RAMLOG_MOD_AUDIO, "Error returned by LVVE_Tx_SetPreset: Error_code = %d\n", LVVE_Status);
		return DRV_ERROR;
	}

	if (g_audioNvParam.audio_ctrlFlag.isVpParamInNv == 1)
	{
		zDrvRamlog_PRINTF(RAMLOG_MOD_AUDIO, "Vp_NxpSetParamTool set voice  param isVpParamInNv \n");

		if (g_voiceVar.muteEn == TRUE)
		{
			if (g_voiceVar.volteIsWb == 1)
			{
				zOss_Memcpy(g_audioNvParam.s_nxpTxWbMuteParam, NxpParamsTool->pPresetTx, NxpParamsTool->PresetLengthTx);
			}
			else
			{
				zOss_Memcpy(g_audioNvParam.s_nxpTxNbMuteParam, NxpParamsTool->pPresetTx, NxpParamsTool->PresetLengthTx);
			}
		}
		else
		{
			pathTxOffset = path * (LVWM_TX_FILE_SIZE + LVWM_RX_FILE_SIZE);
			pathRxOffset = path * (LVWM_TX_FILE_SIZE + LVWM_RX_FILE_SIZE) + LVWM_TX_FILE_SIZE;

			zOss_Memcpy(g_audioNvParam.s_nxpPathParam + pathTxOffset, NxpParamsTool->pPresetTx, NxpParamsTool->PresetLengthTx);
			zOss_Memcpy(g_audioNvParam.s_nxpPathParam + pathRxOffset, NxpParamsTool->pPresetRx, NxpParamsTool->PresetLengthRx);
		}

		if (g_audioNvParam.audio_ctrlFlag.isUseNvWrite == 1)
		{
			if (g_voiceVar.voiceMode == VOICE_GSM_MODE)
			{
				if (path == VP_PATH_HANDSET)
				{
					nvAddrTxOffset = 0;
					nvAddrRxOffset = nvAddrTxOffset + LVWM_TX_FILE_SIZE;


				}
				else if (path == VP_PATH_SPEAKER)
				{
					nvAddrTxOffset = LVWM_TX_FILE_SIZE + LVWM_RX_FILE_SIZE;
					nvAddrRxOffset = nvAddrTxOffset + LVWM_TX_FILE_SIZE;
				}
				else if (path == VP_PATH_HEADSET)
				{
					nvAddrTxOffset = 2 * (LVWM_TX_FILE_SIZE + LVWM_RX_FILE_SIZE);
					nvAddrRxOffset = nvAddrTxOffset + LVWM_TX_FILE_SIZE;

				}
				else if (path == VP_PATH_BLUETOOTH)
				{

					nvAddrTxOffset = 3 * (LVWM_TX_FILE_SIZE + LVWM_RX_FILE_SIZE);
					nvAddrRxOffset = nvAddrTxOffset + LVWM_TX_FILE_SIZE;
				}

			}
			else if ((g_voiceVar.voiceMode == VOICE_WCDMA_MODE) || (g_voiceVar.voiceMode == VOICE_TD_MODE))
			{
				if (g_voiceVar.volteIsWb != 1)
				{
					if (path == VP_PATH_HANDSET)
					{
						nvAddrTxOffset = 4 * (LVWM_TX_FILE_SIZE + LVWM_RX_FILE_SIZE);
						nvAddrRxOffset = nvAddrTxOffset + LVWM_TX_FILE_SIZE;
					}
					else if (path == VP_PATH_SPEAKER)
					{
						nvAddrTxOffset = 5 * (LVWM_TX_FILE_SIZE + LVWM_RX_FILE_SIZE);
						nvAddrRxOffset = nvAddrTxOffset + LVWM_TX_FILE_SIZE;
					}
					else if (path == VP_PATH_HEADSET)
					{
						nvAddrTxOffset = 6 * (LVWM_TX_FILE_SIZE + LVWM_RX_FILE_SIZE);
						nvAddrRxOffset = nvAddrTxOffset + LVWM_TX_FILE_SIZE;
					}
					else if (path == VP_PATH_BLUETOOTH)
					{
						nvAddrTxOffset = 7 * (LVWM_TX_FILE_SIZE + LVWM_RX_FILE_SIZE);
						nvAddrRxOffset = nvAddrTxOffset + LVWM_TX_FILE_SIZE;
					}
				}
				else
				{
					if (path == VP_PATH_HANDSET)
					{
						nvAddrTxOffset = 8 * (LVWM_TX_FILE_SIZE + LVWM_RX_FILE_SIZE);
						nvAddrRxOffset = nvAddrTxOffset + LVWM_TX_FILE_SIZE;
					}
					else if (path == VP_PATH_SPEAKER)
					{
						nvAddrTxOffset = 9 * (LVWM_TX_FILE_SIZE + LVWM_RX_FILE_SIZE);
						nvAddrRxOffset = nvAddrTxOffset + LVWM_TX_FILE_SIZE;
					}
					else if (path == VP_PATH_HEADSET)
					{
						nvAddrTxOffset = 10 * (LVWM_TX_FILE_SIZE + LVWM_RX_FILE_SIZE);
						nvAddrRxOffset = nvAddrTxOffset + LVWM_TX_FILE_SIZE;
					}
					else if (path == VP_PATH_BLUETOOTH)
					{
						nvAddrTxOffset = 11 * (LVWM_TX_FILE_SIZE + LVWM_RX_FILE_SIZE);
						nvAddrRxOffset = nvAddrTxOffset + LVWM_TX_FILE_SIZE;
					}
				}
			}
			else if (g_voiceVar.voiceMode == VOICE_LTE_MODE)
			{
				if (g_voiceVar.volteIsWb != 1)
				{
					if (path == VP_PATH_HANDSET)
					{
						nvAddrTxOffset = 12 * (LVWM_TX_FILE_SIZE + LVWM_RX_FILE_SIZE);
						nvAddrRxOffset = nvAddrTxOffset + LVWM_TX_FILE_SIZE;
					}
					else if (path == VP_PATH_SPEAKER)
					{
						nvAddrTxOffset = 13 * (LVWM_TX_FILE_SIZE + LVWM_RX_FILE_SIZE);
						nvAddrRxOffset = nvAddrTxOffset + LVWM_TX_FILE_SIZE;
					}
					else if (path == VP_PATH_HEADSET)
					{
						nvAddrTxOffset = 14 * (LVWM_TX_FILE_SIZE + LVWM_RX_FILE_SIZE);
						nvAddrRxOffset = nvAddrTxOffset + LVWM_TX_FILE_SIZE;
					}
					else if (path == VP_PATH_BLUETOOTH)
					{
						nvAddrTxOffset = 15 * (LVWM_TX_FILE_SIZE + LVWM_RX_FILE_SIZE);
						nvAddrRxOffset = nvAddrTxOffset + LVWM_TX_FILE_SIZE;
					}
				}
				else
				{
					if (path == VP_PATH_HANDSET)
					{
						nvAddrTxOffset = 16 * (LVWM_TX_FILE_SIZE + LVWM_RX_FILE_SIZE);
						nvAddrRxOffset = nvAddrTxOffset + LVWM_TX_FILE_SIZE;
					}
					else if (path == VP_PATH_SPEAKER)
					{
						nvAddrTxOffset = 17 * (LVWM_TX_FILE_SIZE + LVWM_RX_FILE_SIZE);
						nvAddrRxOffset = nvAddrTxOffset + LVWM_TX_FILE_SIZE;
					}
					else if (path == VP_PATH_HEADSET)
					{
						nvAddrTxOffset = 18 * (LVWM_TX_FILE_SIZE + LVWM_RX_FILE_SIZE);
						nvAddrRxOffset = nvAddrTxOffset + LVWM_TX_FILE_SIZE;
					}
					else if (path == VP_PATH_BLUETOOTH)
					{
						nvAddrTxOffset = 19 * (LVWM_TX_FILE_SIZE + LVWM_RX_FILE_SIZE);
						nvAddrRxOffset = nvAddrTxOffset + LVWM_TX_FILE_SIZE;
					}
				}
			}

			if (g_voiceVar.muteEn != TRUE)
			{
				ret = zOss_NvItemWrite(OS_FLASH_VOICE_RW_NONFAC_BASE_ADDR + nvAddrTxOffset, (UINT8*)NxpParamsTool->pPresetTx, NxpParamsTool->PresetLengthTx);
				if (ZOSS_SUCCESS == ret)
				{
					ret = Nvram_Flush();
				}
				zDrvRamlog_PRINTF(RAMLOG_MOD_AUDIO, "Vp_NxpSetParamTool set tx config to nv ,path=%d,add=0x%x !\r\n", path, OS_FLASH_VOICE_RW_NONFAC_BASE_ADDR + nvAddrTxOffset);
			}
			ret = zOss_NvItemWrite(OS_FLASH_VOICE_RW_NONFAC_BASE_ADDR + nvAddrRxOffset, (UINT8*)NxpParamsTool->pPresetRx, NxpParamsTool->PresetLengthRx);
			if (ZOSS_SUCCESS == ret)
			{
				ret = Nvram_Flush();
			}
			zDrvRamlog_PRINTF(RAMLOG_MOD_AUDIO, "Vp_NxpSetParamTool set rx config to nv ,path=%d,add=0x%x !\r\n", path, OS_FLASH_VOICE_RW_NONFAC_BASE_ADDR + nvAddrTxOffset);
			if (g_voiceVar.muteEn == TRUE)
			{
				if (g_voiceVar.volteIsWb != 1)
				{
					nvAddrTxOffset = 20 * (LVWM_TX_FILE_SIZE + LVWM_RX_FILE_SIZE);
					zDrvRamlog_PRINTF(RAMLOG_MOD_AUDIO, "Vp_NxpSetParamTool set nb mute config to nv ,path=%d,add=0x%x !\r\n", path, OS_FLASH_VOICE_RW_NONFAC_BASE_ADDR + nvAddrTxOffset);
				}
				else
				{
					nvAddrTxOffset = 20 * (LVWM_TX_FILE_SIZE + LVWM_RX_FILE_SIZE) + LVWM_TX_FILE_SIZE;
					zDrvRamlog_PRINTF(RAMLOG_MOD_AUDIO, "Vp_NxpSetParamTool set wb mute config to nv ,path=%d,add=0x%x !\r\n", path, OS_FLASH_VOICE_RW_NONFAC_BASE_ADDR + nvAddrTxOffset);
				}
				ret = zOss_NvItemWrite(OS_FLASH_VOICE_RW_NONFAC_BASE_ADDR + nvAddrTxOffset, (UINT8*)NxpParamsTool->pPresetTx, NxpParamsTool->PresetLengthTx);
				if (ZOSS_SUCCESS == ret)
				{
					ret = Nvram_Flush();
				}
			}

		}

		zDrvRamlog_PRINTF(RAMLOG_MOD_AUDIO, "Vp_NxpSetParamTool get voice mode param \n");
	}
	else
	{
		zDrvRamlog_PRINTF(RAMLOG_MOD_AUDIO, "Vp_NxpSetParamTool set voice  param not isVpParamInNv \n");
		if (NxpParamsTool->PresetLengthTx <= sizeof(LVVE_Tx_Preset_Buffer_Voice_Tool))
			zOss_Memcpy(LVVE_Tx_Preset_Buffer_Voice_Tool, NxpParamsTool->pPresetTx, NxpParamsTool->PresetLengthTx);
		if (NxpParamsTool->PresetLengthRx <= sizeof(LVVE_Rx_Preset_Buffer_Voice_Tool))
			zOss_Memcpy(LVVE_Rx_Preset_Buffer_Voice_Tool, NxpParamsTool->pPresetRx, NxpParamsTool->PresetLengthRx);
		zDrvRamlog_PRINTF(RAMLOG_MOD_AUDIO, "Vp_NxpsetParamTool set param to default param array !\r\n");
	}

	zDrvRamlog_PRINTF(RAMLOG_MOD_AUDIO, "Vp_NxpSetParamTool  PresetLengthRx = %d ,PresetLengthTx= %d!\n", NxpParamsTool->PresetLengthRx, NxpParamsTool->PresetLengthTx);

	return DRV_SUCCESS;
}

SINT32 Vp_NxpGetParamTool(T_ZDrv_VpPath path, T_ZDrv_VpVol volume,
                          zDrvVp_NxpParamsTool *NxpParamsTool, BOOL isLoop, BOOL isVolte)
{
	UINT32 pathTxOffset, pathRxOffset;

	zDrvRamlog_PRINTF(RAMLOG_MOD_AUDIO, "######get NXP parameter start#######");
	//LVM_UINT32                  NumBytesRead;                               /* Number of bytes in the preset file */
	/************************************************************************************/
	/* Set the Voice Engine Parameter values                                            */
	/************************************************************************************/
	if (g_nxpIsOpen == FALSE)
	{
		zDrvRamlog_PRINTF(RAMLOG_MOD_AUDIO, "Vp_NxpGetParamTool,nxp has not been opened yet!\n");
		return DRV_ERR_NOT_OPENED;
	}

	if (g_audioNvParam.audio_ctrlFlag.isVpParamInNv == 1)
	{

		zDrvRamlog_PRINTF(RAMLOG_MOD_AUDIO, "Vp_NxpGetParamTool get para isVpParamInNv !\r\n");
		pathTxOffset = path * (LVWM_TX_FILE_SIZE + LVWM_RX_FILE_SIZE);
		pathRxOffset = path * (LVWM_TX_FILE_SIZE + LVWM_RX_FILE_SIZE) + LVWM_TX_FILE_SIZE;

		NxpParamsTool->pPresetTx = (char*)g_audioNvParam.s_nxpPathParam + pathTxOffset;
		NxpParamsTool->pPresetRx = (char*)g_audioNvParam.s_nxpPathParam + pathRxOffset;

		NxpParamsTool->PresetLengthTx =  LVWM_TX_FILE_SIZE;
		NxpParamsTool->PresetLengthRx =  LVWM_RX_FILE_SIZE;
	}
	else
	{
		zDrvRamlog_PRINTF(RAMLOG_MOD_AUDIO, "Vp_NxpGetParamTool get para not isVpParamInNv !\r\n");

		NxpParamsTool->pPresetTx = LVVE_Tx_Preset_Buffer_Voice_Tool;
		NxpParamsTool->pPresetRx = LVVE_Rx_Preset_Buffer_Voice_Tool;
		NxpParamsTool->PresetLengthTx = sizeof(LVVE_Tx_Preset_Buffer_Voice_Tool);
		NxpParamsTool->PresetLengthRx = sizeof(LVVE_Rx_Preset_Buffer_Voice_Tool);
		zDrvRamlog_PRINTF(RAMLOG_MOD_AUDIO, "Vp_NxpGetParamTool get default param !\r\n");
	}

	if (g_voiceVar.muteEn == TRUE)
	{
		if (g_audioNvParam.audio_ctrlFlag.isVpParamInNv == 1)
		{
			zDrvRamlog_PRINTF(RAMLOG_MOD_AUDIO, "Vp_NxpGetParamTool get mute isVpParamInNv !\r\n");
			if (g_voiceVar.volteIsWb != 1)
			{
				zDrvRamlog_PRINTF(RAMLOG_MOD_AUDIO, "Vp_NxpGetParamTool get nb mute config !\r\n");
				NxpParamsTool->pPresetTx = (char*)g_audioNvParam.s_nxpTxNbMuteParam; //xiu gai chu
				NxpParamsTool->PresetLengthTx = LVWM_TX_FILE_SIZE;
			}
			else
			{
				zDrvRamlog_PRINTF(RAMLOG_MOD_AUDIO, "Vp_NxpGetParamTool get wb mute config !\r\n");
				NxpParamsTool->pPresetTx = (char*)g_audioNvParam.s_nxpTxWbMuteParam; //xiu gai chu
				NxpParamsTool->PresetLengthTx = LVWM_TX_FILE_SIZE;
			}
		}
		else
		{
			zDrvRamlog_PRINTF(RAMLOG_MOD_AUDIO, "Vp_NxpGetParamTool get mute not isVpParamInNv !\r\n");
			if (g_voiceVar.volteIsWb != 1)
			{
				zDrvRamlog_PRINTF(RAMLOG_MOD_AUDIO, "Vp_NxpGetParamTool get nb mute config !\r\n");
				NxpParamsTool->pPresetTx = LVVE_Tx_Mute_File_Buffer;
				NxpParamsTool->PresetLengthTx = sizeof(LVVE_Tx_Mute_File_Buffer);
			}
			else
			{
				zDrvRamlog_PRINTF(RAMLOG_MOD_AUDIO, "Vp_NxpGetParamTool get wb mute config !\r\n");
				NxpParamsTool->pPresetTx = LVVE_Tx_Wb_Mute_File_Buffer;
				NxpParamsTool->PresetLengthTx = sizeof(LVVE_Tx_Wb_Mute_File_Buffer);
			}
		}
	}

	zDrvRamlog_PRINTF(RAMLOG_MOD_AUDIO, "Vp_NxpGetParamTool PresetLengthRx=%d PresetLengthTx= %d ", NxpParamsTool->PresetLengthRx, NxpParamsTool->PresetLengthTx);
	/*klocwork 3  INVARIANT_CONDITION.UNREACH  delete if*/
	/*
	if ((NxpParamsTool->PresetLengthRx == LVM_NULL) || (NxpParamsTool->PresetLengthTx == LVM_NULL))
	{
		zDrvRamlog_PRINTF(RAMLOG_MOD_AUDIO, "Vp_NxpGetParamTool NXP read para is null !\r\n");
		return DRV_ERROR;
	}*/
	return DRV_SUCCESS;
}
#if 0
SINT32 Vp_NxpSetGain(SINT32 gain, UINT32 channel, T_ZDrv_VpPath path)
{
	//LVVE_ReturnStatus_en        LVVE_Status=LVVE_SUCCESS;//xiu gai chu
	//LVM_INT16                         tempGain=0;//xiu gai chu
	if (g_nxpIsOpen == FALSE)
	{
		zDrvRamlog_PRINTF(RAMLOG_MOD_AUDIO, "Vp_NxpSetGain,nxp has not been opened yet!\n");
		return DRV_ERR_NOT_OPENED;
	}

	return DRV_SUCCESS;
}
#endif
SINT32 Vp_NxpRxProcess(UINT8 **pPReadBuffer, UINT8 **pPWriteBuffer, UINT16 sampleNums)
{
	LVM_INT16   *pWriteBuffer;
	LVM_INT16   *pReadBuffer;
	LVM_INT16   *pReadBuffer_FE;
	LVVE_ReturnStatus_en        LVVE_Status;                                /* Module status return */

	SINT32 ret = DRV_SUCCESS;
	if (g_nxpIsOpen == FALSE)
	{
		zDrvRamlog_PRINTF(RAMLOG_MOD_AUDIO, "Vp_NxpRxProcess,nxp has not been opened yet!\n");
		return DRV_ERR_NOT_OPENED;
	}

	/*************************/
	/* PROCESS THE RX MODULE */
	/*************************/

	pReadBuffer = (LVM_INT16  *)(*pPReadBuffer);
	pWriteBuffer = (LVM_INT16  *)(*pPWriteBuffer);
	pReadBuffer_FE  = (LVM_INT16 *)&InBuffer16_Tx_FE[0];

	LVVE_Status = LVVE_Rx_Process(hInstance_Rx,                         /* Instance handle */
	                              pReadBuffer,                        /* Input buffer */
	                              pNoiseData,                         /* Noise data */
	                              pWriteBuffer,                       /* Output buffer */
	                              sampleNums);                        /* Number of samples pairs to process */

	if (LVVE_Status == LVVE_NULLADDRESS)
	{
		zDrvRamlog_PRINTF(RAMLOG_MOD_AUDIO, "Vp_NxpRxProcess Parameter error - null pointer returned from LVVE_Rx_Process\n");
		ret = DRV_ERROR;
	}
	if (LVVE_Status == LVVE_INVALIDNUMSAMPLES)
	{
		zDrvRamlog_PRINTF(RAMLOG_MOD_AUDIO, "Vp_NxpRxProcess Invalid number of samples, check value or range returned from LVVE_Rx_Process\n");
		ret = DRV_ERROR;
	}
	if (LVVE_Status == LVVE_ALIGNMENTERROR)
	{
		zDrvRamlog_PRINTF(RAMLOG_MOD_AUDIO, "Vp_NxpRxProcess Alignment error, check input and/or output buffer alignment returned from LVVE_Rx_Process\n");
		ret = DRV_ERROR;
	}

	if (LVVE_Status != LVVE_SUCCESS)
	{
		if (isFirstRxProcessErr == TRUE)
		{
			zDrvRamlog_PRINTF(RAMLOG_MOD_AUDIO, "Vp_NxpRxProcess Error while processing returned from LVVE_Rx_Process: %d\n", (LVM_INT16)LVVE_Status);
			isFirstRxProcessErr = FALSE;
		}
		ret = DRV_ERROR;
	}

	zOss_Memcpy((VOID*)pReadBuffer_FE, (VOID*)pWriteBuffer, sampleNums * sizeof(LVM_INT16));
//zDrvRamlog_PRINTF(RAMLOG_MOD_AUDIO, "Vp_NxpRxProcess\n");
	ret = DRV_SUCCESS;//xiu waring:unused ret
	return ret;
}

SINT32 Vp_NxpTxProcess(UINT8 **pPReadBuffer_NE_MAIN, UINT8 **pPReadBuffer_NE_AUX, UINT8 **pPWriteBuffer, UINT16 sampleNums)
{
	SINT32 ret = DRV_SUCCESS;

	LVM_INT16   *pWriteBuffer;
	LVVE_ReturnStatus_en        LVVE_Status;                                /* Module status return */

	LVM_INT16   *pReadBuffer_NE0;
	LVM_INT16   *pReadBuffer_NE1;
	LVM_INT16   *pReadBuffer_FE;

	if (g_nxpIsOpen == FALSE)
	{
		zDrvRamlog_PRINTF(RAMLOG_MOD_AUDIO, "Vp_NxpTxProcess,nxp has not been opened yet!\n");
		return DRV_ERR_NOT_OPENED;
	}

	/*************************/
	/* PROCESS THE TX MODULE */
	/*************************/

	pReadBuffer_NE0 = (LVM_INT16 *)(*pPReadBuffer_NE_MAIN);
	if (pPReadBuffer_NE_AUX == NULL)
	{
		pReadBuffer_NE1 = NULL;
	}
	else
	{
		pReadBuffer_NE1 = (LVM_INT16 *)(*pPReadBuffer_NE_AUX);
	}
	pWriteBuffer    = (LVM_INT16 *)(*pPWriteBuffer);
	pReadBuffer_FE  = (LVM_INT16 *)&InBuffer16_Tx_FE[0];

	LVVE_Status = LVVE_Tx_Process(hInstance_Tx,                         /* Instance handle */
	                              pReadBuffer_NE0,                    /* Input buffer primary Mic */
	                              pReadBuffer_NE1,                    /* Input buffer secondary Mic */
	                              pReadBuffer_FE,                     /* Input buffer */
	                              pNoiseData,                         /* Noise data */
	                              pWriteBuffer,                       /* Output buffer */
	                              sampleNums);                        /* Number of samples pairs to process */

	/*
	 * Check for error and stop if needed
	 */
	if (LVVE_Status == LVVE_NULLADDRESS)
	{
		zDrvRamlog_PRINTF(RAMLOG_MOD_AUDIO, "Vp_NxpTxProcess Parameter error - null pointer returned from LVVE_Tx_Process\n");
		ret = DRV_ERROR;
	}
	if (LVVE_Status == LVVE_INVALIDNUMSAMPLES)
	{
		zDrvRamlog_PRINTF(RAMLOG_MOD_AUDIO, "Vp_NxpTxProcess Invalid number of samples, check value or range returned from LVVE_Tx_Process\n");
		ret = DRV_ERROR;
	}
	if (LVVE_Status == LVVE_ALIGNMENTERROR)
	{
		zDrvRamlog_PRINTF(RAMLOG_MOD_AUDIO, "Vp_NxpTxProcess Alignment error, check input and/or output buffer alignment returned from LVVE_Tx_Process\n");
		ret = DRV_ERROR;
	}
	if (LVVE_Status != LVVE_SUCCESS)
	{

		if (isFirstTxProcessErr == TRUE)
		{
			zDrvRamlog_PRINTF(RAMLOG_MOD_AUDIO, "Vp_NxpTxProcess Error while processing returned from LVVE_Tx_Process: %d\n", (LVM_INT16)LVVE_Status);
			isFirstTxProcessErr = FALSE;
		}
		ret = DRV_ERROR;
	}
	ret = DRV_SUCCESS;//xiu warning:unused ret
	//zDrvRamlog_PRINTF(RAMLOG_MOD_AUDIO, "Vp_NxpTxProcess\n");
	return ret;//xiu
}

