/**************************************************************************
*
*                  Copyright (c) 2012 ZTE Corporation.
*
***************************************************************************
* ģ   : 
*    : sup_except.c
* ļ : 
* ʵֹ : 쳣ģ
*      : ¹
*      : V1.0
*  : 2007/08/01
* ˵ : 
**************************************************************************/

/**************************************************************************
* ޸ļ¼
**************************************************************************/
/**************************************************************************
* ޸ı : 0001
*    : ܹ
*    : V1.1
* ޸ : 2007/09/03
* ޸ : ӽӿںʵ
**************************************************************************/
/**************************************************************************
* ޸ı : 0002
*    : dengningkun
* ޸ : 2012/9/27
* ޸ : ʽ淶PC-LINT  EC:617001782169
**************************************************************************/
/**************************************************************************
* ޸ı : 0003
*    : dengningkun
* ޸ : 2012/10/10
* ޸ : ߲               EC:617001782205
**************************************************************************/

/**************************************************************************
* #include
**************************************************************************/

#include "oss_api.h"
#include "osa.h"
#include "sup.h"
#include "sup_except.h"
#include "ThreadPriority.h"
#ifdef _USE_WDT_RST
#include "drvs_wdt.h"
#include "sys_func_atcfg.h"
#endif

#ifdef __cplusplus
extern "C"
{
#endif

/**************************************************************************
* ⲿ
**************************************************************************/
#ifdef _OS_TOS
extern FLOAT Osa_GetProcessCPU(ZOSS_THREAD_ID thread_id);
#endif

/**************************************************************************
* 궨
**************************************************************************/
#ifdef _USE_WDT_RST
#define TRACE_WATCHDOG_FEED_PERIOD          1000
#define TRACE_WATCHDOG_FEED_VALUE           5000
#endif
/**************************************************************************
* ݽṹ
**************************************************************************/
 
/**************************************************************************
* ֲԭ
**************************************************************************/
#ifndef _USE_PSM
#if defined (_OS_WIN) || defined (_OS_OSE)
static VOID Excep_IdleThread(SINT32 ingore);
#endif
#endif
#ifdef _USE_WDT_RST
static VOID Excep_WatchDogCallBack(SINT32 args);
#endif

/**************************************************************************
* ȫֳ/
**************************************************************************/
ZOSS_TASK_ID gExcep_DaemonTask = ZOSS_INVALID_TASK_ID;

static T_EXCEP_PARAM                *gExcep_Param   = NULL;

#ifdef _USE_WDT_RST
static ZOSS_TIMER_ID                gTrace_WatchDogTimerID      = NULL;
#endif
/* ֲ */
/**************************************************************************
* ֲʵ
**************************************************************************/
/*  ֲ */
#ifndef _USE_PSM
#if defined (_OS_WIN) || defined (_OS_OSE)
/**************************************************************************
* ƣ Excep_IdleThread
*  
* ˵ 
*   ֵ 
* ˵
**************************************************************************/
static VOID Excep_IdleThread(SINT32 ingore)
{
#ifdef _OS_OSE
    UINT32 dwZero=0;
    SINT32 i = 0;

    for(;;)
    {
        i++;
        if (!(i%3000000))
        {
            SYSTIME_Init();
        }
    }
#elif defined (_OS_TOS)
     for(;;)
        ;
#elif defined (_OS_LINUX)
     for(;;)
        ;
#endif
}
#endif
#endif
#ifdef _USE_WDT_RST
/**************************************************************************
* ƣ Excep_WatchDogCallBack
*  ʱιص
* ˵ args:  ʱ
*   ֵ VOID
* ˵ VOID
**************************************************************************/
static VOID Excep_WatchDogCallBack(SINT32 args)
{
    zDrvWdt_FeedDog(TRACE_WATCHDOG_FEED_VALUE);
}
#endif
/**************************************************************************
* ȫֺʵ
**************************************************************************/

/**************************************************************************
* ƣ Excep_Init
*  쳣ģʼ
* ˵ 
*   ֵ ɹZOSS_SUCCESSʧܷZOSS_ERROR
* ˵
**************************************************************************/
UINT32 EXCEP_Init(VOID)
{
#if defined(_USE_WDT_RST)
    UINT32          nRet    = ZOSS_ERROR;
    UINT32          flag    = 0;

    flag = zOss_GetExceptResetFlag();
    if (flag == EXCEPT_RESET_ENABLE)
    {
        gTrace_WatchDogTimerID = zOss_CreateTimer("WatchDogTimer",
                                                  (ZOSS_TIMER_FUN)Excep_WatchDogCallBack,
                                                  (SINT32)0,
                                                  TRUE);
        zOss_AssertEx(NULL != gTrace_WatchDogTimerID, ZOSS_ERROR);

        nRet = zOss_StartTimer(gTrace_WatchDogTimerID,
                               TRACE_WATCHDOG_FEED_PERIOD,
                               Excep_WatchDogCallBack,
                               0);
        zOss_AssertEx(ZOSS_ERROR != nRet, ZOSS_ERROR);
    }
    else
    {
        zDrvWdt_Stop();
    }
#endif

    return ZOSS_SUCCESS;
}

/**************************************************************************
* ƣ EXCEP_StartDaemonTask
*  ѭ
* ˵ 
*   ֵ ɹZOSS_SUCCESSʧܷZOSS_ERROR
* ˵
**************************************************************************/
UINT32 EXCEP_StartDaemonTask(VOID)
{
    T_OSS_PARAM     *osscfg = NULL;

    if(THR1_PRI < 1)
    {
        return ZOSS_ERROR;
    }

    osscfg = zOss_GetOssCfg();
    gExcep_Param = &(osscfg->ExcepCfg);
    gExcep_DaemonTask = zOss_CreateTask(EXCEP_DAEMONTASKNAME, Excep_DaemonTask, 4 * 1024, THR1_PRI - 1, 2048, 0);
    if (ZOSS_INVALID_TASK_ID == gExcep_DaemonTask)
    {
        return ZOSS_ERROR;
    }
    if (ZOSS_ERROR == zOss_TaskSend(EV_POWERON, NULL, 0, gExcep_DaemonTask))
    {
        return ZOSS_ERROR;
    }

    return ZOSS_SUCCESS;
}

/**************************************************************************
* ƣ Excep_DaemonTask
*  쳣ģػ
* ˵ state:״̬
      msg_id:ϢID
      buf:Ϣָ
      msg_len:Ϣ
      private_data:˽
*   ֵ 
* ˵
**************************************************************************/
VOID Excep_DaemonTask(UINT8 state, UINT32 msg_id, UINT8 *buf, UINT16 msg_len, UINT8 *private_data)
{
    ZOSS_TIMER_ID   tid         = ZOSS_INVALID_TIMER_ID;
    ZOSS_TASK_ID    *task_ids   = (ZOSS_TASK_ID *)private_data;
    
    switch (state)
    {
    case ZOSS_STATUS_INIT:
        {
            switch (msg_id)
            {
            case EV_INIT:
                {
                    break;
                }
            case EV_POWERON:
                {
                    tid = zOss_SetRelativeTimer(gExcep_Param->DeamonStartTime, EV_ZOSS_EXCEP_WDT_SET, 0);
                    if (ZOSS_INVALID_TIMER_ID == tid)
                    {
                        zOss_ASSERT(0);
                    }
                    if (ZOSS_ERROR == zOss_SetState(ZOSS_STATUS_WORK))
                    {
                        zOss_ASSERT(0);
                    }
                    break;
                }
            default:
                {
                    break;
                }
            }
            break;
        }
    case ZOSS_STATUS_WORK:
        {
            switch (msg_id)
            {
            case EV_ZOSS_EXCEP_WDT_SET:
                {
                    /* ѭⶨʱ */
                    tid = zOss_SetLoopTimer(gExcep_Param->DeadLoopCheckTime, EV_ZOSS_EXCEP_DEADLOOPCHECK, 0);
                    if (ZOSS_INVALID_TIMER_ID == tid)
                    {
                        zOss_ASSERT(0);
                    }
#ifndef _USE_PSM
#if defined (_OS_WIN) || defined (_OS_OSE)
                    if (ZOSS_INVALID_THREAD_ID == zOss_CreateThread(EXCEP_IDLETHREADNAME, Excep_IdleThread, 0, 1024, 31, 1, 1))
                    {
                        zOss_ASSERT(0);
                    }
#endif
#endif
                    break;
                }
            case EV_ZOSS_EXCEP_DEADLOOPCHECK:
                {
                    UINT32 num = 0;
                    UINT32 i = 0;
                    T_ZOss_TCB *tinfo = NULL;
                    
                    num = Sche_DeadLoop(task_ids);
                    while (ZOSS_INVALID_TASK_ID != task_ids[i] && i < num)
                    {
                        /* OSS_DeleteTask(task_ids[i]); */
                        if (NULL == tinfo)
                        {
                            tinfo = (T_ZOss_TCB *)zOss_Malloc(sizeof(T_ZOss_TCB));
                            if (NULL == tinfo)
                            {
                                zOss_AssertExN(NULL != tinfo);
                            }
                        }
                        if (ZOSS_ERROR == zOss_GetTaskInfo(task_ids[i], tinfo))
                        {
                            tinfo->task_name[0] = '\0';
                        }
                        zOss_Printf(SUBMDL_EXCEP, PRINT_LEVEL_ABNORMAL, "dead task found:%p,name:%s\r\n", task_ids[i], tinfo->task_name);
                        
                        i++;
                    }
                    if (NULL != tinfo)
                    {
                        zOss_Free(tinfo);
                    }
                    break;
                }
            default:
                {
                    break;
                }
            }   /* end switch(msg_id) */
            break;
        }
    default:
        {  
            break;
        }
    }   /* end switch(state) */
}

/**************************************************************************
* ƣ zOss_GetCPU
*  õCPUʹ
* ˵ 
*   ֵ CPUʹ(0-100)
* ˵
**************************************************************************/
UINT8 zOss_GetCPU(VOID)
{
#ifdef _OS_OSE
    UINT8                   rate = 0;
    ZOSS_THREAD_ID          t_id = ZOSS_INVALID_THREAD_ID;
    T_ZOsa_ThreadUserArea   *pUa = NULL;

    t_id    = zOss_GetThreadIDByName(EXCEP_IDLETHREADNAME);
    pUa     = Osa_GetThreadUserArea(t_id, FALSE);
    rate    = (UINT8)pUa->cpupercent;
    if (rate > 100)
    {
        rate = 0;
    }

    return (100 - rate);
#elif defined (_OS_TOS)
    return (UINT8)(100 - Osa_GetProcessCPU(zOss_GetThreadIDByName(EXCEP_IDLETHREADNAME)));
#else
    return 0;
#endif
}

#ifdef _USE_DEBUG_INFO
/**************************************************************************
* ƣ zOss_DebugInfoRecord
*  ModemϵͳάϢ¼ӿ
* ˵ id: ģID
*            pFormat: ӡַ
*   ֵ ɹ: д볤; ʧ: ZOSS_ERROR
* ˵
**************************************************************************/
UINT32 zOss_DebugInfoRecord(char *id, const VOID *pFormat, ...)
{
#ifdef _OS_WIN
    return ZOSS_ERROR;
#else
    va_list args;
	int r;

	va_start(args, pFormat);
	r = sc_debug_info_vrecord(id, pFormat, args);
	va_end(args);

    return r;
#endif
}
#else
UINT32 zOss_DebugInfoRecord(char *id, const VOID *pFormat, ...)
{
    return ZOSS_SUCCESS;
}
#endif

#ifdef __cplusplus
}
#endif


